#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2025 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: install_wrapper.sh - logging wrapper for install script
#

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )

INSTALL_LOG=~/icewarp-install.log
INSTALL_ERROR_LOG=~/icewarp-install-error.log

DATE=$(date)
touch "$INSTALL_ERROR_LOG"
echo "INSTALLATION STARTED ON ${DATE}" > "$INSTALL_ERROR_LOG"

ARGUMENTS="${SCRIPT_DIR}/_install.sh $@"

# Check for TTY presence
if [[ -t 0 ]] && [[ -t 1 ]]; then
    script -q -e -f -c "$ARGUMENTS" "$INSTALL_LOG"
else
    bash -c "${ARGUMENTS}" | tee -a "$INSTALL_LOG"
fi

RESULT_CODE=$?

FINISHED_DATE=$(date)
echo "INSTALLATION FINISHED ON ${FINISHED_DATE}" >> "$INSTALL_ERROR_LOG"

if [ -f "/etc/icewarp/icewarp.conf" ]; then
    source "/etc/icewarp/icewarp.conf"

    # Copy logs to icewarp directory for future reference
    mkdir -p "${IWS_INSTALL_DIR}/logs/setup"
    cp -f "${INSTALL_LOG}" "${IWS_INSTALL_DIR}/logs/setup"
    cp -f "${INSTALL_ERROR_LOG}" "${IWS_INSTALL_DIR}/logs/setup"
fi

exit $RESULT_CODE
