#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2025 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: domain_del.sh - wizard menu script
#

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

deldomain()
{
    good ""
    bad "${BAD}Delete domain:${NORMAL}"
    good ""

    getparam "Domain name:"
    DOMAINNAME=$PARAM
    good ""

    ask_with_confirmation "OK?" "N" "y"
    if [ $? -eq 2 ]; then
        run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "delete" "domain" "${DOMAINNAME}"
        EXITCODE=$?
        if [ ${EXITCODE} -eq 0 ]; then
            good "Domain deleted"
        else
             bad "Domain deletion problem, error code ${EXITCODE}!"
        fi
    else
        warn "User cancelled"
    fi

    ask_with_confirmation "Delete another domain?" "N" "y"
    if [ $? -eq 2 ]; then
        deldomain
    fi
    return 0
}

deldomain
exit 0
