#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2025 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: createtables.sh - wizard menu script
#

source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"

createtables()
{
    SERVICETYPE="$1"
    SERVICENAME="$2"
    good ""
    hilite "Set up connection for $SERVICENAME:"
    good ""

    DBNAME="icewarp_server"
    DBUSER="icewarp_server"
    DBHOST=$(grep "^socket" /etc/mysql/my.cnf /etc/my.cnf ~/.my.cnf 2>/dev/null | cut -d'=' -f2 | cut -d' ' -f2 | tail -n 1)

    getparam "Database name [${DBNAME}]:"
    if [ "x${PARAM}" != "x" ]; then
        DBNAME=$PARAM
    fi

    getparam "Database username [${DBUSER}]:"
    if [ "x${PARAM}" != "x" ]; then
        DBUSER=$PARAM
    fi

    getpassword "Database password:"
    DBUSERPW=$SPARAM

    getparam "Database server (socket path or host or leave blank) [${DBHOST}]:"
    if [ "x${PARAM}" != "x" ]; then
        DBHOST=$PARAM
    fi

    ask_with_confirmation "OK?" "Y" "n"
    if [ $? -ne 1 ]; then
        return 0
    fi

    DBNEWUSER=$DBUSER
    DBNEWNAME=$DBNAME
    DBNEWUSERPW=$DBUSERPW
    DBNEWHOST=$DBHOST

    mysqlcall
    if [ $? -ne 0 ]; then
        ask_with_confirmation "MySQL login failed using supplied credentials, create new database for this user?" "Y" "n"
        if [ $? -ne 1 ]; then
            return 0
        fi

        DBUSER="root"
        DBUSERPW=""
        unset DBNAME

        getparam "MySQL administrator username [${DBUSER}]:"
        if [ "x${PARAM}" != "x" ]; then
            DBUSER=$PARAM
        fi
    fi

    run_cmd_log "${IWS_INSTALL_DIR}/tool.sh" "CREATE" "TABLES" "${SERVICETYPE}" "${DBNEWNAME};${DBNEWUSER};${DBNEWUSERPW};${DBNEWHOST};3;2" > /dev/null
    EXITCODE=$?
    if [ ${EXITCODE} -eq 0 ]; then
        good "Tables created" 
    else
        bad "Tables already exist or save problem, error code ${EXITCODE}" 
    fi
    return 0
}

case `basename "$0"` in
    createtables-accounts)
        createtables "0" "Accounts storage"
        if [ $? -ne 0 ]; then
            storageswitch-convert-DB
        fi
        echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  " $?
        ;;
    createtables-groupware)
        if [ $? -ne 0 ]; then
            verybad "GroupWare daemon must be running!"
        else
            createtables "2" "GroupWare storage"
        fi
        ;;
    createtables-challengeresponse)
        createtables "3" "Challenge-response storage"
        ;;
    createmysqldb)
        createdbmysql $*
        ;;
esac

exit 0
