#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2025 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: wizard.sh - maintenance script
#

# include configuration file
source /etc/icewarp/icewarp.conf
if [ $? -ne 0 ]; then
    echo "Can not find configuration file icewarp.conf"
    exit 255
fi

# include functions
source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"
if [ $? -ne 0 ]; then
    echo "Can not find functions include file"
    exit 255
fi

copyright()
{
    IWS_NICE_VERSION=$(get_api_variable system C_niceversion)
    
    good ""
    hilite "IceWarp Server"
    hilite "(c) 1999 - 2025 IceWarp Ltd."
    good ""
    good "Wizard configuration assistant"
    good ""
    good "Installed IceWarp Server version: ${IWS_NICE_VERSION}"
    good ""
    good "Logging is redirected to the following file for future reference:"
    good "Commands: ${WIZARD_CMD_LOG}"
    good ""
    good "Press [ENTER] to continue, CTRL-C to quit."
}

getscriptparams()
{
    case $1 in
    action)
        if [ "x${2}" != "x" ]; then
            export MENU_SCRIPTS_DIR
            "${MENU_SCRIPTS_DIR}/${2}"
            if [ $? -ne 0 ]; then
                bad "Error running script!"
            fi
        else
            bad "ERROR: action not specified"
        fi
        ;;
    *)
        MENUROOT="ROOT"
        MENULIST="${IWS_INSTALL_DIR}/scripts/wizard/menu.lst"
        menu "Root menu" "$MENUROOT" "$MENULIST" "wizard"
        ;;
    esac
}

# Test API availability
IWS_API_TEST=$(get_api_variable system c_version)

if [[ $IWS_API_TEST =~ "API initialization error" ]]; then
    echo $IWS_API_TEST

    exit 255
fi

# Init command log
IWS_LOGDIR=$(get_api_variable system c_system_storage_dir_logpath)
mkdir -p "${IWS_LOGDIR}/wizard"
WIZARD_CMD_LOG="${IWS_LOGDIR}wizard/icewarpserver-wizard-cmd.log"
rm -f "$WIZARD_CMD_LOG"
touch "$WIZARD_CMD_LOG"

# Display copyright and wait for [Enter]
clear
copyright
read -s

# Run wizard

export IWS_INSTALL_DIR
export IWS_PROCESS_USER
export MENU_SCRIPTS_DIR="${IWS_INSTALL_DIR}/scripts/wizard"
export WIZARD_CMD_LOG
clear
getscriptparams $*

exit 0
