#!/bin/bash

get_api_variable()
{
    CMD_STDOUT=$("./tool.sh" get "$1" "$2" | sed 's/^[^:]*: //')
    CMD_RET=$?
    echo "${CMD_STDOUT}"
    return ${CMD_RET}
}

source /etc/icewarp/icewarp.conf

cd $IWS_INSTALL_DIR

echo "Waiting for groupware being available ..."
GW_READY=false
MAX_WAIT=60
while [ $MAX_WAIT -gt 0 ]; do
    GW_AVAIL=$(get_api_variable "system" "C_GW_IsAvailable")
    if [ "${GW_AVAIL}" == "1" ]; then
        GW_READY=true
        break
    fi
    sleep 1
    MAX_WAIT=$(($MAX_WAIT - 1))
done

if $GW_READY; then
    echo "Groupware is ready"
    exit 0
else
    echo "Waiting for groupware timed out. Please check IceWarp server state."
    exit 1
fi

