#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2025 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: upgrade.sh - script for upgrading server version
# param 1: previous version
#

SCRIPT_FILE="scripts/script.php"

# include configuration file
source /etc/icewarp/icewarp.conf
if [ $? -ne 0 ]; then
    echo "Can not find configuration file icewarp.conf"
    exit 255
fi

# ensure, that server is started before upgrade
echo "Starting icewarp server"
"${IWS_INSTALL_DIR}/icewarpd.sh" --start

# test for argument
if [ "x$1" != "x" ]; then
    # arguments given, run upgrade
    echo -n "Performing upgrade..."
    "${IWS_INSTALL_DIR}/tool.sh" upgrade "$1" 1
    echo "OK"
fi

# execute script.php if any, regardless of argument
if [ -f "${IWS_INSTALL_DIR}/${SCRIPT_FILE}" ]; then
    echo -n "Performing localization tasks..."
    "${IWS_INSTALL_DIR}/scripts/php.sh" "${IWS_INSTALL_DIR}/${SCRIPT_FILE}" $1 > /dev/null
    echo "OK"
fi

sleep 10

# restart server after upgrade
echo "Restarting icewarp server"
"${IWS_INSTALL_DIR}/icewarpd.sh" --restart

exit 0
