#!/bin/bash
#
# IceWarp Server
# Copyright (c) 2008-2025 IceWarp Ltd. All rights reserved.
#
# http://www.icewarp.com
#
# file: purpleserv.sh - server internal script
#

# include configuration file
source /etc/icewarp/icewarp.conf
if [ $? -ne 0 ]; then
    echo "Can not find configuration file icewarp.conf"
    exit 255
fi

# start purpleserv
export IWS_INSTALL_DIR
export LD_LIBRARY_PATH="${IWS_INSTALL_DIR}/purple/lib:${IWS_INSTALL_DIR}/purple/plugins:${LD_LIBRARY_PATH}"
export LANGUAGE="en"

# include functions
source "${IWS_INSTALL_DIR}/scripts/inc/functions.sh"
if [ $? -ne 0 ]; then
    echo "Can not find functions include file"
    exit 255
fi

# obtain log directory
LOGDIR=$(get_api_variable system c_system_storage_dir_logpath)
mkdir -p "${LOGDIR}/purple"

cd "${IWS_INSTALL_DIR}/purple" &> /dev/null
"${IWS_INSTALL_DIR}/purple/purpleserv" "$@" &> "${LOGDIR}/purple/purplestartup.log" & echo $! > "${IWS_INSTALL_DIR}/var/purpleserv.pid"

exit 0
