<?php

define('SCRIPT_CLI', true);

if (($sharedLibPath = realpath(__DIR__ . '/../../html/_shared')) && is_dir($sharedLibPath)) {
    define('SHAREDLIB_PATH', $sharedLibPath . '/');
} else {
    define('SHAREDLIB_PATH', get_cfg_var('icewarp_sharedlib_path'));
}

if(is_dir(SHAREDLIB_PATH . '/../webmail/server')){
    define('WEBMAIL_PATH', SHAREDLIB_PATH . '../webmail/server/');
}

$error = '{
   "result" : false
}
';
if (PHP_SAPI == 'cli') {
    parse_str($argv[1], $params);
} else {
    $params = $_GET;
}

$params['type'] = strtoupper($params['type'] ?? '');
if(($params['type'] != 'GET' && $params['type'] != 'SET') || empty($params['email'] ?? null || !filter_var($params['email'], FILTER_VALIDATE_EMAIL))){
    echo $error;
    exit(1);
}
try {
    $_GET['email'] = $params['email'];
    ob_start();
    require_once(WEBMAIL_PATH . 'signature.php');
    $signature = ob_get_clean();
        $signature = simplexml_load_string($signature ?? '');
        $signature = $signature->xpath('//signature[(@name="Default")]')[0];
    if($params['type'] == 'GET'){
        if($signature === false){
            echo "{
    \"readonly\" : false,
    \"signature\" : \"\"
}
";
            exit(0);
        }
        echo "{
    \"readonly\" : " . ($signature['allow-edit'] == 'true' ? 'false' : 'true') . ",
    \"signature\" : \"" . str_replace('"', '\\"',$signature) . "\"
}
";
    }elseif($signature['allow-edit'] == 'false') {
        echo $error;
        exit(1);
    }else{
        $sigsrc = (PHP_SAPI == 'cli') ? "php://stdin" : "php://input";
        $signature = file_get_contents($sigsrc);
        $signature = slToolsString::basicSanitizeHTML($signature);

        $path = $_SESSION['USERDIR'] . SETTINGS_FOLDER . SETTINGS_FILE . storeageext;
        if(!file_exists($path)){
            echo $error;
            exit(1);
        }

        $xml = simplexml_load_file($path);
        $parent = current($xml->xpath('(//signature)'));
        if(!$parent) $parent = $xml->addChild('signature');
        $found = current($xml->xpath('(//signature/item[not(name)])'));
        if($found){
            $found->text = $signature;
        }else{
            $item = $parent->addChild('item');
            $item->addChild('text', $signature);
        }
        $xml->asXML($path);

        echo '{
    "result" : true
}
';
    }
    exit(0);
}catch(Exception $e){
    echo $error . PHP_EOL;
    exit(1);
}
