<?php

namespace server\model;

use server\inc\gw\Search;

class Upload extends AGwEventItem
{
    use TEvnGwSearch, THasThumbnail, TFileSearch;

    CONST TYPE = 'U';

    protected $evngrpId;
    protected $evnownId;
    protected $evnmodifiedownId;
    protected $evnsharetype;
    protected $evnstartdate;
    protected $evnstarttime;
    protected $evnMetadata;
    protected $evncomplete;
    protected $evnfolder;
    protected $evntitle;
    protected $evnlocation;
    protected $evnclass;
    protected $evnurl;

    public static $searchFields = [
        'EvnTitle',
        'EvnLocation',
        'EvnNote',
    ];

    public static function getByFilter(\Folder $folder, &$filter) : array
    {
        $items = [];
        $gwApi = $folder->account->gwAPI;
        $filter['orderby'] = 'evn_created DESC';
        $attributes = $gwApi->filterToAttributes($filter);
        $result = $gwApi->FunctionCall(
            'getMyUploads', 
            $gwApi->OpenGroup('*'), 
            $filter['sql'], 
            'evnfolder, evnstartdate, evnstarttime, evn_created, evntitle, evnlocation, evnclass, evnurl, \'\' as evnthumbnailid, \'\' as evnthumbnailticket,\'\' as evnprocessingqueued', 
            $attributes
        );
        $parser = new \tools\ParamLineParser($result);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $item = new Upload($folder);
            $item->fillFromArray($parsedParamLine, false);
            $item->setFilterTag($filter);
            $items[] = $item;
        }
        return $items;
    }

    public function fillFromArray(array $array, $loadAllAddons = false, array $loadAddons = [],bool $markVariablesSet = false)
    {
        parent::fillFromArray($array, $loadAllAddons, $loadAddons, $markVariablesSet);
        $created = $this->getEvncreated(false);
        if($this->getEvnstartdate()=='' && $created){
            $this->setEvnstartdate(\MerakGWAPI::unix2calendardate($created));
            $this->setEvnstarttime(\MerakGWAPI::unix2calendartime($created));
        }
    }

    public static function getCountByFilter()
    {
        return false;
    }

    public function getTemplateDataArray(array $allowEmpty = []) : array
    {
        $result = $this->getAsArrayFE(false, true, $allowEmpty);
        $result['id'] = \slToolsPHP::htmlspecialchars($this->getId());
        $result['sFields'] = '<values>' . $this->xml . '</values>';
        return $result;
    }

     
    public function delete()
    {
        if(empty($this->getId())) return;
         
        $gwApi = $this->getFolder()->account->gwAPI;
        return $gwApi->FunctionCall('deleteeventreference', $gwApi->OpenGroup('*'), $this->getId());
    }

    public function getFullpath($accountId)
    {
        return $accountId . '/' . $this->getFolder()->name . '/' . $this->getId();
    }

    public function greaterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnComplete > %s', self::kiloByteToByte($value));
    }

    public function smallerCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnComplete < %s', self::kiloByteToByte($value));
    }

    public function afterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified > %s', strtotime($value));
    }

    public function aftertimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified > %s', strtotime($value));
    }

    public function beforetimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified < %s', strtotime($value));
    }

    public function beforeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified < %s', strtotime($value));
    }

     
    public function getEvngrpId()
    {
        return $this->evngrpId;
    }

     
    public function setEvngrpId($evngrpId): void
    {
        $this->evngrpId = $evngrpId;
    }

     
    public function getEvnownId()
    {
        return $this->evnownId;
    }

     
    public function setEvnownId($evnownId): void
    {
        $this->evnownId = $evnownId;
    }

     
    public function getEvnmodifiedownId()
    {
        return $this->evnmodifiedownId;
    }

     
    public function setEvnmodifiedownId($evnmodifiedownId): void
    {
        $this->evnmodifiedownId = $evnmodifiedownId;
    }

     
    public function getEvnsharetype()
    {
        return $this->evnsharetype;
    }

     
    public function setEvnsharetype($evnsharetype): void
    {
        $this->evnsharetype = $evnsharetype;
    }

     
    public function getEvnstartdate()
    {
        return $this->evnstartdate;
    }

     
    public function setEvnstartdate($evnstartdate): void
    {
        $this->evnstartdate = $evnstartdate;
    }

     
    public function getEvnstarttime()
    {
        return $this->evnstarttime;
    }

     
    public function setEvnstarttime($evnstarttime): void
    {
        $this->evnstarttime = $evnstarttime;
    }

     
    public function getEvnMetadata()
    {
        return $this->evnMetadata;
    }

     
    public function setEvnMetadata($evnMetadata): void
    {
        $this->evnMetadata = $evnMetadata;
    }

     
    public function getEvncomplete()
    {
        return $this->evncomplete;
    }

     
    public function setEvncomplete($evncomplete): void
    {
        $this->evncomplete = $evncomplete;
    }

    public function getICalendar(): string
    {
        return '';
    }

    public function getType(): string
    {
        return self::TYPE;
    }

    protected function afterLoad(): void
    {
             }

     
    public function getEvnfolder()
    {
        return $this->evnfolder;
    }

     
    public function setEvnfolder($evnfolder): void
    {
        $this->evnfolder = $evnfolder;
    }

     
    public function getEvntitle()
    {
        return $this->evntitle;
    }

     
    public function setEvntitle($evntitle): void
    {
        $this->evntitle = $evntitle;
    }

     
    public function getEvnlocation()
    {
        return $this->evnlocation;
    }

     
    public function setEvnlocation($evnlocation): void
    {
        $this->evnlocation = $evnlocation;
    }

     
    public function getEvnurl()
    {
        return $this->evnurl;
    }

     
    public function setEvnurl($evnurl): void
    {
        $this->evnurl = $evnurl;
    }
}