<?php

 

namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Node;
use server\inc\gw\Search;
use tools\ParamLineParser;
use tools\VCalendar;

class TeamChat extends AGwEventItem implements IHasAttachments, IHasItemAttributes, IHasEventReactions, IHasAttendees, IHasRecurrences, IHasReminders
{
    use THasAttachments, THasItemAttributes, THasEventReactions, THasAttendees, THasRecurrences, THasReminders, THasThumbnail, TEvnGwSearch;

    CONST TYPE = 'I';

    protected $evnnote;
    protected $evnsharetype;
    protected $evntitle;
    protected $ctz;

    protected $evnfolder;

    protected $evngrpId;

    protected $evnrcrId;
    protected $evnownId;
    protected $evnlockownId;
    protected $evnModifiedownId;
    protected $evnstartdate;
    protected $evnstarttime;
    protected $evnenddate;
    protected $evnendtime;
    protected $evntimeformat;
    protected $evnMetadata;
    protected $evnuid;
    protected $evncomplete;
    protected $pinownId;
    protected $pinownemail;
    protected $pinownname;
    protected $gpinwhen;
    protected $lpinwhen;
    protected $evnlinkid;
    protected $evnlinktype;
    protected $evnlocation;
    protected $evncomevnid;
    protected $evnowneremail;
    protected $evnownername;
    protected $evnmodifiedowneremail;
    protected $evnmodifiedownername;
    protected $evnmystatus;
    protected $evnticket = '';
    protected $evnmentionsInfo;
    protected $evncomlinkextras;
    protected $evnaccepted;
    protected $evnsizeinfo;
    protected $evnlinkextras;
    protected $evnurl;
    protected $teamchatLinkId;
    protected $evnrid;
    protected $reavalue;
    protected $evnmeetingid;
    protected $evnacceptedparticipantscount;
    protected $pinId;
    protected $gpinownId;
    protected $gpinMetadata;
    protected $menwhoownId;
    protected $menId;
    protected $menevnId;
    protected $mengrpId;
    protected $menFolder;
    protected $menwhoownemail;
    protected $menwhoownname;
    protected $menlinktype;
    protected $menlinkId;
    protected $menlinkemail;
    protected $menlinkname;
    protected $menwhen;
    protected $tctgrp_id;
    protected $tctfdr_id;
    protected $tctevn_id;
    protected $tcttopic;
    protected $isthread;
    protected $isfollowed;
    protected $comcount;
    protected $unreadcount;
    protected $tctlasttime;
    protected $tctlastid;
    protected $evnorganizer;
    protected $evnsequence;
    protected $evnflags;
    protected $evndescformat = 'text/plain';
    protected $gpinownemail;
    protected $gpinownname;
    protected $gpinId;
    protected $pinwhen;
    protected $evnacceptedparticipantcount;
    protected $meetingAction;
    protected $meetingPassword;
    protected $evndocinvite;
    protected $evndocpass;
    protected $evnmimetype;
    protected $evndocrights;
    protected $inviteticket;
    protected $data;
    protected $part = null;
    protected $linkinfo;
    protected $thumbnailimageid;

         protected $lastevnclass;
    protected $lastevnlinkid;
    protected $lastevnthumbnailtime;  
    protected $lastevnlinktype;
    protected $lastevnlocation;
    protected $lastevn_metadata;
    protected $lastevncomevnid;
    protected $lastevnstartdate;
    protected $lastevnstarttime;
    protected $lastevn_created;
    protected $lastevn_modified;
    protected $lastevnsharetype;
    protected $lastevnurl;
    protected $lastevn_id;
    protected $lastevnmeetingid;
    protected $lastreavalue;
    protected $lastgpin_id;
    protected $lastgpinownemail;
    protected $lastgpinownname;
    protected $lastgpinown_id;
    protected $lastgpinwhen;
    protected $lastgpin_metadata;
    protected $lastpin_id;
    protected $lastpinown_id;
    protected $lastpinwhen;
    protected $lastpin_metadata;
    protected $lastevnlinkextras;
    protected $lastevnowneremail;
    protected $lastevnownername;
    protected $lastevnmodifiedowneremail;
    protected $lastevnmodifiedownername;
    protected $lastevnmystatus;
    protected $lastevnthumbnailid;
    protected $lastevnthumbnailticket = '';
    protected $lastevnticket = '';
    protected $lastevnmentions_info;
    protected $lastevnacceptedparticipantscount;
    protected $lastevnaccepted;
    protected $lastevnprocessingqueued;
    protected $lastevnnote;
    protected $evnRid;
    protected $tcoccreateddate;
 
    public static $skipVariablesExport = [];

    public static $renameVariablesExportGW = [
        'evnMetadata' => 'metadata'
    ];

    public static $lengthVariablesExport = [
        'evnmeetingid' => 255,
        'evnlocation' => 510,
        'evntitle' => 510,
    ];

    public static $searchFields = [
        'EvnTitle',
        'EvnNote',
    ];

    public function fillFromVObject(Node $vObject)
    {
             }

     
    public function loadById(string $id) : bool
    {
        if(strpos($id, '|') !== false) {
            $parts = explode('|', $id,2);
            $id = $parts[0];
            $this->part = $parts[1];
        }
        $this->setId($id);
        $data = $this->getGwApi()->FunctionCall('getEventInfo', $this->getFolderSessionId(), $this->getId(), 'use_tzid=1&revision_extended=1&groupchat_extended=1');
        $paramParser = new ParamLineParser($data, true);
        if(empty($paramParser->parsedParamLines[0] ?? null)) return false;
        $this->fillFromArray($paramParser->parsedParamLines[0], true);
        $this->afterLoad(true);
                          if (empty($this->getInviteticket()) && filter_var($this->evndocinvite, FILTER_VALIDATE_BOOLEAN)) {
            $result = $this->getGwApi()->FunctionCall("GetAttachmentPathLocal", $this->getFolder()->openAccess(), $this->getId(), '', 'INVITETICKET');
            $this->setInviteticket($result);
        }
        return true;
    }

    protected function afterLoad(bool $children = false) : void
    {
        if(empty($this->getEvnthumbnailid()) && preg_match('/&EvnThumbnailId=(?P<id>[^&]+)/ui', $this->getEvnlinkextras(), $matches)){
            $this->setEvnthumbnailid($matches['id']);
        }
        if(empty($this->getEvnthumbnailticket()) && preg_match('/&EvnThumbnailTicket=(?P<ticket>[^&]+ticket[^&]+)/ui', $this->getEvnlinkextras(), $matches)){
            $this->setEvnthumbnailticket($matches['ticket']);
        }
        if(!$children) return;
        $this->addAttachmentsFromGW();
        $this->addAttendeesFromGW();
        $this->addRemindersFromGW();
        $this->addRecurrencesFromGW();
    }

     
    public static function createFromXML(\Folder $folder, string $xml, bool $save = false, AGwEventItem $parent = null)
    {
         
        $result = parent::createFromXML($folder, $xml, false, $parent);

                 if(($folder->getType() == 'I' && ($result->getEvnclass() == 'F' || $result->getEvnclass() == 'M')) && !\GroupWareItem::checkAttachmentName($result->getEvntitle())){
            throw new \Exc('attachment_name',$result->getEvntitle());
        }
        if(count($result->getAttachments()) > 1){
            $item = $result;
            $result = [];
            $attachments = $item->getAttachments();
            $item->setAttachments([]);
            foreach ($attachments as $attachment) {
                $tempItem = clone $item;
                $tempItem->addAttachment($attachment);
                $attachment->setParent($tempItem);
                $tempItem->setEvnRid($attachment->getName())
                    ->setEvnlocation($attachment->getName())
                    ->setEvncomplete($attachment->getSize())
                    ->setEvntitle($attachment->getName());
                $result[] = $tempItem;
            }
            unset($item);
        }
        if($folder->getType() == 'I') self::correctPostWithEmailAttachments($result, $save);

        if($save){
            if(!is_array($result)){
                $result->save();
            }else{
                foreach ($result as $item) {
                    $item->save();
                }
            }
        }
        return $result;
    }

    public function getICalendar(): string
    {
        return '';
    }

    public static function getCountCommentsByFilter(\Folder $folder, $filter, $threadId)
    {
         
        $gwApi = $folder->account->gwAPI;
        $folderSessionId = $folder->openAccess();
        return $gwApi->FunctionCall('GetTeamChatCommentCount', $folderSessionId, $threadId, $filter['sql']);
    }

    public static function getCountByFilter(\Folder $folder, $filter)
    {
        if(isset($filter['aroundid'])){
            return false;
        }

        if(!empty(($threadId = trim(str_replace($folder->name, '', $filter['folderId'] ?? ''), "/ \t\n\r\x0B")))){
            return self::getCountCommentsByFilter($folder, $filter, $threadId);
        }
        $attributes = [];
         
        $gwApi = $folder->account->gwAPI;
        if($folder->name == '__@@THREADS@@__'){
            $filter['groupchat_type'] = 'threads';
            $attributes[] = 'include_last_comment=1';
            $attributes[] = 'followed=1';
            $sessionId = $gwApi->OpenGroup();
        }else{
            $sessionId = $folder->openAccess();
        }
        if (isset($filter['lasttime'])){
            $attributes[] = 'lasttime='.$filter['lasttime'];
        }
        if($filter['tcsearch']){
            $attributes[] = 'search='.urlencode($filter['tcsearch']);
        }
        unset($filter['limit'], $filter['offset'], $filter['orderby']);
        if($filter['groupchat_type'] == 'events'){
            $attributes = $gwApi->filterToAttributesUrlEnc($filter, $attributes);
        }else{
            $attributes = $gwApi->filterToAttributes($filter, $attributes);
        }
        return $gwApi->FunctionCall('GetTeamChatCount', $sessionId, $filter['groupchat_type'], $filter['sql'], $attributes);
    }

    protected static function getCommentsByFilter(\Folder $folder, &$filter, $threadId)
    {
        $items = [];
        if(isset($filter['aroundid'])){
            $items = self::handleAroundIdFilter($folder, $filter, $threadId);

            if($filter['includePost'] ?? false){
                $items[] = new TeamChat($folder, $threadId);
            }

            return $items;
        }
         
        $gwApi = $folder->account->gwAPI;
        $folderSessionId = $folder->openAccess();
        \slToolsIcewarp::removeEmptyConditionsSQL($filter['sql']);
        $otherSelect = "reavalue,evnnote,'' as evnsizeinfo,evn_created,evn_modified,evnsharetype,evnurl,evn_id,evnmeetingid,'' as evnlockown_email,'' as evn_documenteditinginfo,evnclass,'' as evnthumbnailticket,evncomevnid,'' as evncomlinkextras,'' as evnmentions_info,Evn_Metadata,EvnTitle,EvnLocation,EvnLinkId,EvnLinkType,'' as EvnLinkExtras,'' as evnowneremail,'' as evnownername,'' as evnmodifiedowneremail,'' as evnmodifiedownername, '' as EvnMyStatus,0 as EvnAccepted, 0 as EvnAcceptedParticipantCount,0 as EvnProcessingQueued,0 as EvnThumbnailTime, '' as EvnThumbnailId, '' as EvnTicket";
        $attributes = $gwApi->filterToAttributes($filter);

        $result = $gwApi->FunctionCall('GetTeamChatCommentList', $folderSessionId, $threadId, $filter['sql'], $otherSelect, $attributes);
        $parser = new \tools\ParamLineParser($result);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $item = new TeamChat($folder);
            $item->fillFromArray($parsedParamLine);
            $items[] = $item;
        }

        if($filter['includePost'] ?? false){
            $items[] = new TeamChat($folder, $threadId);
        }

        return $items;
    }

    protected static function handleAroundIdFilter(\Folder $folder, &$filter, $threadId = null)
    {
        $baseSearchString = preg_replace('/aroundid:[\'"\\s]*' . $filter['aroundid'] . '[\'"\\s]?/i', '', $filter['search']);
        $newFilter = [
            'search' => 'untilid:' . $filter['aroundid'] . ' ' . $baseSearchString,
            'limit' => $filter['limit'] ?? 31,
            'offset' => $filter['offset'] ?? 0,
            'tag' => $filter['tag'] ?? '',
            'type' => $filter['type'] ?? '',
            'groupchat_type' => $filter['groupchat_type'] ?? '',
            'orderby' => 'evn_id DESC',
        ];
        $search = new Search($folder, $newFilter, 'search');
        $newFilter['sql'] = $search->getSearchSql();
        if(empty($threadId)) {
            $firstResults = self::getByFilter($folder, $newFilter);
        }else{
            $firstResults = self::getCommentsByFilter($folder, $newFilter, $threadId);
        }

        $newFilter['orderby'] = 'evn_id ASC';
        $newFilter['limit']--;
        $newFilter['search'] = 'afterid:' . $filter['aroundid'] . ' ' . $baseSearchString;
        $search = new Search($folder, $newFilter, 'search');
        $newFilter['sql'] = $search->getSearchSql();
        $newFilter['reset_unread'] = true;
        if(empty($threadId)) {
            $secondResults = self::getByFilter($folder, $newFilter);
        }else {
            $secondResults = self::getCommentsByFilter($folder, $newFilter, $threadId);
        }

        if(preg_match('/evn_id\\s(?P<direction>ASC)/i', $filter['orderby'], $match)){
            return array_merge(array_reverse($firstResults), $secondResults);
        }else{
            return array_merge(array_reverse($secondResults), $firstResults);
        }
    }

    public static function getByFilter(\Folder $folder, &$filter): array
    {
        if(!empty(($threadId = trim(str_replace($folder->name, '', $filter['folderId'] ?? ''), "/ \t\n\r\x0B")))){
            return self::getCommentsByFilter($folder, $filter, $threadId);
        }
        if(isset($filter['aroundid'])){
            return self::handleAroundIdFilter($folder, $filter);
        }
         
        $gwApi = $folder->account->gwAPI;
        $attributes = [];
        if($folder->name == '__@@THREADS@@__'){
            $filter['groupchat_type'] = 'threads';
            $attributes[] = 'include_last_comment=1';
            $attributes[] = 'followed=1';
            $sessionId = $gwApi->OpenGroup();
        }else{
            $sessionId = $folder->openAccess();
        }
        if($filter['tcsearch']){
            $attributes[] = 'search='.urlencode($filter['tcsearch']);
        }
        \slToolsIcewarp::removeEmptyConditionsSQL($filter['sql']);

        if(isset($filter['lasttime'])){
            $attributes[] = 'lasttime='.$filter['lasttime'];
        }
        if($filter['groupchat_type'] == 'mentions') $otherSelect = "GlobalEventPin.PinWhen as GPinWhen,EventPin.PinWhen,'' as EvnLinkExtras, '' as evnowneremail, '' as evnownername, '' as evnmodifiedowneremail, '' as evnmodifiedownername, '' as evnmentions_info, evn_created, evn_modified, evn_deleted, evnfolder, evnoriginalfolder, evntitle, evnnote, evndescformat, evnlocation, evnpriority, evncompleted, evncolor, evnclass, evntype, evnstatus, evnorganizer, evncontact, evnurl, evnrid, evnexpire, evnsequence, evnflags, evnmeetingid, evnlockappmask, evnlockhash, evnlockinfo, evnlinkid, evnlinktype, evncomevnid, evndocinvite, evndocexpire, evndocrights, evndocpass, men_id, menevn_id, mengrp_id, men_folder, menwhoownemail, menwhoownname, menlinktype, menlink_id, menlinkemail, menlinkname, menwhen, reavalue, reaevn_id, reagrp_id, rea_folder, reaown_id, reaownemail, reaownname";
        if($filter['groupchat_type'] == 'main') $otherSelect = "";
        if($filter['groupchat_type'] == 'events'){
            $attributes = $gwApi->filterToAttributesUrlEnc($filter, $attributes);
        }else{
            $attributes = $gwApi->filterToAttributes($filter, $attributes);
        }
        if($filter['groupchat_type'] == 'global_pins') $attributes = str_replace('pin_id', 'gpin_id', $attributes);
                 $result = $gwApi->FunctionCall('GetTeamChatList', $sessionId, $filter['groupchat_type'], $filter['sql'], $otherSelect, $attributes);
        
        $parser = new \tools\ParamLineParser($result);
        $items = [];
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $item = new TeamChat($folder);
            $item->fillFromArray($parsedParamLine, false);
            $item->setFilterTag($filter);
            $items[] = $item;
        }
        return $items;
    }

    protected function getTemplateDataArrayPart()
    {
        if($this->part == '@@MAIN@@'){
            foreach ($this->getAttachments() as $attachment) {
                if($attachment->getAttType(true) == 'F') break;
            }

            $result = new Email($this->getFolder(), $this->getId(), $attachment->getFileLocation());
            $result = $result->getTemplateDataArray();
        }
        return $result;
    }

     
    public function getTemplateDataArray(array $allowEmpty = []) : array
    {
        if(!empty($this->part)) return $this->getTemplateDataArrayPart();
        $filterTag = $this->getFilterTag();
        if(isset($filterTag['tag']) && in_array('data', $filterTag['tag'])) {
            foreach ($this->getAttachments() as $attachment) {
                if ($attachment->getClass() != 'attachment') continue;
                $this->setData($attachment->getFileContent());
                break;
            }
        }

        $result = $this->getAsArrayFE(false, true, $allowEmpty);
        $result['id'] = \slToolsPHP::htmlspecialchars($this->getId());
        $result['sFields'] = '<values>' . $this->xml . '</values>';
        $this->addAttachmentsTemplateDataArray($result);
        $this->addAttendeesTemplateDataArray($result);
        $this->addRemindersTemplateDataArray($result);
        $this->addRecurrencesTemplateDataArray($result);
        $this->addEventReactionsTemplateDataArray($result);

        if($result['EVNCLASS'] == 'I' && !empty($result['EVNURL']) && preg_match('/'.preg_quote($result['EVNURL'],'/').'[^\s]+/', $result['EVNNOTE'], $matches)){
            $matches[0] = \slToolsString::utf8_bad_replace(\slToolsString::removeHTML($matches[0]));
            $fields = preg_replace('/'.preg_quote('<evnurl>'.$result['EVNURL'], '/').'/','<evnurl>'.(\slToolsPHP::htmlspecialchars($matches[0])), $result['sFields'], 1);
            if(!empty($fields)) $result['sFields'] = $fields;
            $result['EVNURL'] = $matches[0];
        }
        return $result;
    }

    public function getType(): string
    {
        return self::TYPE;
    }

     
    public function save(): AGwEventItem
    {
        $this->saveOld();
        return $this;
    }

     
    public function saveOld($finalize = true)
    {
        $this->setEvnCreated();
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $folderSessionId = $this->getFolder()->openAccess();
                 if(!$this->prepareParamLine('use_tzid=1', ';SKIP_GROUPCHAT_PROCESSING')){
            if($this->finalized) $finalize = false;
        }elseif(!$sEvnId = $gwApi->FunctionCall('AddEventInfo', $folderSessionId, $this->getParamLine(), $this->getId())){
            $lastError = $gwApi->FunctionCall("GetLastError",$this->getFolder()->account->sGWSessionID);
            if($lastError != 13) throw new \Exc('item_create',$sEvnId);
            throw new \Exc('item_duplicity',$this->getEvntitle());
        }
        $this->setId($sEvnId ?? $this->getId());

        $itemAttributes = $this->getItemAttributes();
        foreach ($itemAttributes as $itemAttribute) {
            $itemAttribute->saveOld();
        }

        $eventReactions = $this->getEventReactions();
        foreach ($eventReactions as $eventReaction) {
            $eventReaction->saveOld();
        }

        foreach ($this->getAttachments() as $attachment) {
            $attachment->saveOld();
            $attachment->setSize(filesize($attachment->getFileLocation()));
            $attachment->setAttWebdavLink(\User::addTokenToTicket($this->getGwApi()->FunctionCall("getAttachmentPath", $this->getFolderSessionId(), $this->getId(), $attachment->getId(), 'READONLYTICKET')));
        }

        foreach ($this->getAttendees() as $attendee) {
            $attendee->save();
        }

        foreach ($this->getReminders() as $reminder) {
            $reminder->save();
        }

        foreach ($this->getRecurrences() as $recurrence) {
            $recurrence->save();
        }

        $this->backupState();
        if(!$finalize) return;
                 $finalizeParams = '&return_link_id=1';
        $id = $gwApi->FunctionCall('AddEventInfo', $folderSessionId, $finalizeParams, $this->getId());
        parse_str($id,$result);
        if($result['linkid']){
            $this->setTeamchatLinkId($result['linkid']);
        }
        $this->getFolder()->groupChatLastActivity = $this->getEvnCreated(false);
        $this->finalized = true;
    }

    public function getCreatedData() : array
    {
        $result = parent::getCreatedData();
        $attachment = current($this->getAttachments());
        if($attachment) $result['name'] = $attachment->getId();
        $result['reactions_metadata'] = '';
        $result['att_size'] = $this->getEvnsizeinfo();
        $result['teamchat_link_id'] = $this->getTeamchatLinkId();
        return $result;
    }

         static public function createFromMessage(&$folder, $file, $comment = '', &$item = false, &$aItem = array(), $finalize = false, $folderName = null) : TeamChat
    {
        if($item) throw new \Exc('item_create', 'TeamChat object invalid input'.get_class($item));
        $folder->openAccess();

        $parser = new \slMailParse($file, array(), true);
        $structure = $parser->parse(false, true);

        $parent = null;
        if(!empty(($threadId = trim(str_replace($folder->name, '', $folderName ?? ''), "/ \t\n\r\x0B")))){
            $parent = new TeamChat($folder);
            $parent->setId($threadId);
        }

        $teamChat = new TeamChat($folder, null, $parent);

                 if (!isset($aItem['EVNCLASS']) || $aItem['EVNCLASS'] == 'F') {
            $teamChat->setEvnclass('M');
        }

        $teamChat->setEvnorganizer($structure['headers']['from'])
            ->setEvnmeetingid($structure['headers']['to']);

        if($structure['headers']['cc']) $teamChat->setEvnmeetingid($teamChat->getEvnmeetingid() . ','.$structure['headers']['cc']);
        if($structure['headers']['bcc']) $teamChat->setEvnmeetingid($teamChat->getEvnmeetingid() . ','.$structure['headers']['bcc']);

        $to_count = count(\slMailParse::parseAddresses($structure['headers']['to']) ?? []);
        $cc_count = count(\slMailParse::parseAddresses($structure['headers']['cc']) ?? []);
        $bcc_count = count(\slMailParse::parseAddresses($structure['headers']['bcc']) ?? []);
        $teamChat->setEvnsequence($to_count+$cc_count+$bcc_count);
        $unixtime = strtotime($structure['headers']['date']);
        $teamChat->setEvnstartdate(\IceWarpGWAPI::unix2calendarDate($unixtime))
            ->setEvnstarttime(\IceWarpGWAPI::unix2calendarTime($unixtime))
            ->setEvnnote($comment)
            ->setEvnlocation($structure['isHTML'] ? \slToolsString::removeHTML($structure['html_body']) : $structure['text_body']);

        if($structure['isHTML']){
            if(!$teamChat->getEvnflags()){
                $teamChat->setEvnflags(\GroupWareItem::FLAG_HTMLCONTENT);
            }else{
                $teamChat->setEvnflags($teamChat->getEvnflags() | \GroupWareItem::FLAG_HTMLCONTENT);
            }
            $teamChat->setEvndescformat('text/html');
        }else{
            $teamChat->setEvndescformat('text/plain');
        }
        $teamChat->setEvncomplete( filesize($file));

        if(!isset($aItem['EVNSHARETYPE'])) $teamChat->setEvnsharetype('U');

        if(isset($structure['attachments']) && is_array($structure['attachments']) && !empty($structure['attachments'])){
            $attachments = '[';
            $attachmentjson = [];
            foreach($structure['attachments'] as $key => $attachment){
                if(!empty($attachment['cid'] ?? null)) continue;
                $attachmentjson[]= '{' .
                    '"name":"'.trim(json_encode($attachment['name']),'"').'",'.
                    '"part_id":"'.trim(json_encode($attachment['part_id']),'"').'",'.
                    '"size":"'.trim(json_encode($attachment['size']),'"').'",'.
                    '"type":"'.trim(json_encode($attachment['type']),'"').'"'.
                    '}';
            }
            $attachments.= join(",",$attachmentjson);
            $attachments.= ']';
            $metadata= '&attachments='.urlencode($attachments);
        }

        $name = \slMailParse::getAttachmentName($structure,'1',array(),true,messageext);
        if(!$name){
            $name = trim(\Storage::getNoTitleLabel()).messageext;
        }
        $fixed_name = \CacheItem::getSubjectFileNameStatic($name,'',messageext);

        $teamChat->setEvntitle($name);
        $teamChat->setEvnRid($name);
        $teamChat->setEvnMetadata($metadata);

        $teamChat->saveOld(false);

        $xattributes = [];
        if ($structure['headers']['to']) $xattributes[] = ['atrtype' => 'to', 'atrvalue' => $structure['headers']['to']];
        if ($structure['headers']['cc']) $xattributes[] = ['atrtype' => 'cc', 'atrvalue' => $structure['headers']['cc']];
        if ($structure['headers']['bcc']) $xattributes[] = ['atrtype' => 'bcc', 'atrvalue' => $structure['headers']['bcc']];

        if(!empty($xattributes)) self::addItemAttributesForeach($teamChat, $xattributes);

                 $idsArray = ['sid' => $_SESSION['SID'], 'account_id' => $_SESSION['EMAIL'], 'folder_id' => $folder->folderID, 'item_id' => $teamChat->getId(), 'placeholder' => true];
        $parser = new \slMailParse($file, $idsArray, true);
        $structure = $parser->parse(false, true);

        $folderID = date('Y-m-d-') . \Tools::my_uniqid();
        $itemID = \Tools::my_uniqid();
        $aData['class'] = 'file';
        $aData['fullpath'] = $folderID.'/'.$itemID;
        $_SESSION['user']->addFileAttachment($file, $fixed_name, 'message/rfc822', $folderID, $itemID);

        $attachment = new Attachment($teamChat->getFolder(), null, $teamChat);
        $attachment->isMail = true;
        $attachment->setClass('file');
        $attachment->setFullpath($folderID.'/'.$itemID);
        $attachment->setAttType('F');
        $teamChat->addAttachment($attachment);

        if($structure['isHTML']){
            $html = $structure['html_body'];
            $plain = \slToolsString::removeHTML($html);
        }else{
            $html = \slToolsString::text2html($structure['plain_body']);
            $plain = $structure['plain_body'];
        }
        $previewHtml = urldecode($html);
        if(!empty($url) && preg_match_all('/(?P<search>src=""\s*icewarp-src="(?:[^"&]+&amp;)+(?:[^"&]+&amp;)*part=(?P<part>[^"&]+)[^"]*")/i', $previewHtml, $matches, PREG_SET_ORDER)){
            foreach ($matches as $match) {
                $previewHtml = str_replace($match['search'], 'src="' . $url . '&partid=' . $match['part'] . '"', $previewHtml);
            }
        }

        $folderID = $folderID ? $folderID : \Tools::my_uniqid();
        $itemID_html = \Tools::my_uniqid();
        $_SESSION['user']->addStringAttachment($previewHtml, 'MAIL_PREVIEW.html', 'text/html', $folderID, $itemID_html);

        $attachment = new Attachment($teamChat->getFolder(), null, $teamChat);
        $attachment->isMail = true;
        $attachment->setClass('file');
        $attachment->setFullpath($folderID.'/'.$itemID_html);
        $attachment->setAttType('H');
        $teamChat->addAttachment($attachment);

        $itemID_text = \Tools::my_uniqid();
        $_SESSION['user']->addStringAttachment($previewHtml, 'MAIL_PREVIEW.txt', 'text/plain', $folderID, $itemID_text);

        $attachment = new Attachment($teamChat->getFolder(), null, $teamChat);
        $attachment->isMail = true;
        $attachment->setClass('file');
        $attachment->setFullpath($folderID.'/'.$itemID_text);
        $attachment->setAttType('E');
        $teamChat->addAttachment($attachment);

        $teamChat->saveOld();
        return $teamChat;
    }

    protected function membersConditionBuilder($value, $type)
    {
        $oMembersFolder = $this->folder->account->getFolder('__@@GROUP@@__/'.$this->folder->name);
        if(!$oMembersFolder) return '';
        $filter = [$type => $value];
        $oMembers = $oMembersFolder->getItems($filter);
        $ownerIDS = [];
        if ($oMembers) foreach($oMembers as $oMember){
            $ownerIDS[] = $oMember->item['OWNERID'];
        }
        return 'EvnOwn_ID in (\''.join('\',\'',$ownerIDS).'\')';
    }

    public function fromCondition(Search $search, $value) : string
    {
        return $this->membersConditionBuilder($value, 'everywhere');
    }

    public function everywhereCondition(Search $search, $value) : string
    {
        return $this->membersConditionBuilder($value, 'everywhere');
    }

    public function isemailCondition(Search $search, $value) : string
    {
        return $this->membersConditionBuilder($value, 'isemail');
    }

    public function emailCondition(Search $search, $value) : string
    {
        return $this->membersConditionBuilder($value, 'email');
    }

    public function greaterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnComplete > %s', self::kiloByteToByte($value));
    }

    public function smallerCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnComplete < %s', self::kiloByteToByte($value));
    }

    public function beforeCondition(Search $search, $value) : string
    {
        $dateTime = $this->getDateTimeByString($value);
        $dateTime->modify('-30 day');
        $search->filter['start'] = unixtojd($dateTime->getTimestamp());
        $search->filter['intervalAttr'] = 29;
        return '';
    }

    public function afterCondition(Search $search, $value) : string
    {
        $dateTime = $this->getDateTimeByString($value);
        $dateTime->modify('+1 day');
        $search->filter['start'] = unixtojd($dateTime->getTimestamp());
        $search->filter['intervalAttr'] = 30;
        return '';
    }

    protected function getDateTimeByString($value)
    {
        $dateTime = new \DateTime();
        $dateTime->setTimezone(new \DateTimeZone($_SESSION['CLIENT_TIMEZONE'] ? $_SESSION['CLIENT_TIMEZONE'] : $_SESSION['SERVER_TIMEZONE']));
        $dateTime->setTimestamp(strtotime($value));
        return $dateTime;
    }

    public function aftertimeCondition(Search $search, $value) : string
    {
        $dateTime = $this->getDateTimeByString($value);
        return $this->placeValueToCondition('Evn_Created > %s', $dateTime->getTimestamp());
    }

    public function beforetimeCondition(Search $search, $value) : string
    {
        $dateTime = $this->getDateTimeByString($value);
        return $this->placeValueToCondition('Evn_Created < %s', $dateTime->getTimestamp());
    }

    public function hasCondition(Search $search, $value) : string
    {
        if($value == 'conference') return "(EvnMeetingID IS NOT NULL AND EvnMeetingID <> '')";
        return '';
    }

    public function aroundidCondition(Search $search, $value) : string
    {
        $search->filter['aroundid'] = $value;
        return '';
    }

    public function afterackidCondition(Search $search, $value) : string
    {
        $value = explode('|', $value);
        if(count($value) != 2) return '';
        return $this->placeValueToCondition('TCTLastTime > %s OR (TCTLastTime = %s AND EVN_ID > \'%s\')', [$value[0], $value[0], $value[1]]);
    }

    public function afterackCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('TCTLastTime > %s', $value);
    }

    public function beforeackidCondition(Search $search, $value) : string
    {
        $value = explode('|', $value);
        if(count($value) != 2) return '';
        return $this->placeValueToCondition('TCTLastTime < %s OR (TCTLastTime = %s AND EVN_ID < \'%s\')', [$value[0], $value[0], $value[1]]);
    }

    public function beforeackCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('TCTLastTime < %s', $value);
    }

    public function untilidCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EVN_ID <= \'%s\'', $value);
    }

    public function gchatCondition(Search $search, $value, & $filter) : string
    {
        $filter['groupchat_type'] = trim($value);
        return '';
    }

    public function fulltextCondition(Search $search, $value, & $filter) : string
    {
        $filter['tcsearch'] = $value;
        return '';
    }

     
    public function setParent(? AGwEventItem $parent = null): AGwEventItem
    {
        if($parent instanceof TeamChat) $this->setEvncomevnid($parent->getId());
        $this->parent = $parent;
        return $this;
    }

     
    public function setEvnlocation($evnlocation): TeamChat
    {
                 $this->evnlocation = $evnlocation;
        return $this;
    }

     
    public function getEvnlocation($encoded = false)
    {
        return ($encoded) ? rawurlencode(mb_convert_encoding($this->evnlocation, 'UTF-8')) : $this->evnlocation;
    }

     
    public function getEvnurl()
    {
        return $this->evnurl;
    }

     
    public function setEvnurl($evnurl): TeamChat
    {
        $this->evnurl = $evnurl;
        return $this;
    }

     
    public function getTeamchatLinkId()
    {
        return $this->teamchatLinkId;
    }

     
    public function setTeamchatLinkId($teamchatLinkId): TeamChat
    {
        $this->teamchatLinkId = $teamchatLinkId;
        return $this;
    }

     
    public function getEvnRid()
    {
        return $this->evnRid;
    }

     
    public function setEvnRid($evnRid): TeamChat
    {
        $this->evnRid = $evnRid;
        return $this;
    }

     
    public function getEvnnote()
    {
        return $this->evnnote;
    }

     
    public function setEvnnote($evnnote): TeamChat
    {
        $this->evnnote = $evnnote;
        return $this;
    }

     
    public function getEvnsharetype()
    {
        return $this->evnsharetype;
    }

     
    public function setEvnsharetype($evnsharetype): TeamChat
    {
        $this->evnsharetype = $evnsharetype;
        return $this;
    }

     
    public function getEvntitle()
    {
        return $this->evntitle;
    }

     
    public function setEvntitle($evntitle): TeamChat
    {
        $this->evntitle = $evntitle;
        return $this;
    }

     
    public function getCtz()
    {
        return $this->ctz;
    }

     
    public function setCtz($ctz): TeamChat
    {
        $this->ctz = $ctz;
        return $this;
    }

     
    public function getEvngrpId()
    {
        return $this->evngrpId;
    }

     
    public function setEvngrpId($evngrpId): TeamChat
    {
        $this->evngrpId = $evngrpId;
        return $this;
    }

     
    public function getEvnrcrId()
    {
        return $this->evnrcrId;
    }

     
    public function setEvnrcrId($evnrcrId): TeamChat
    {
        $this->evnrcrId = $evnrcrId;
        return $this;
    }

     
    public function getEvnownId()
    {
        return $this->evnownId;
    }

     
    public function setEvnownId($evnownId): TeamChat
    {
        $this->evnownId = $evnownId;
        return $this;
    }

     
    public function getEvnlockownId()
    {
        return $this->evnlockownId;
    }

     
    public function setEvnlockownId($evnlockownId): TeamChat
    {
        $this->evnlockownId = $evnlockownId;
        return $this;
    }

     
    public function getEvnModifiedownId()
    {
        return $this->evnModifiedownId;
    }

     
    public function setEvnModifiedownId($evnModifiedownId): TeamChat
    {
        $this->evnModifiedownId = $evnModifiedownId;
        return $this;
    }

     
    public function getEvnstartdate()
    {
        return $this->evnstartdate;
    }

     
    public function setEvnstartdate($evnstartdate): TeamChat
    {
        $this->evnstartdate = $evnstartdate;
        return $this;
    }

     
    public function setTzEvnstartdate($evnstartdate): TeamChat
    {
        $this->evnstartdate = $evnstartdate;
        return $this;
    }

     
    public function getEvnstarttime()
    {
        return $this->evnstarttime;
    }

     
    public function setEvnstarttime($evnstarttime): TeamChat
    {
        $this->evnstarttime = $evnstarttime;
        return $this;
    }

     
    public function setTzEvnstarttime($evnstarttime): TeamChat
    {
        $this->evnstarttime = $evnstarttime;
        return $this;
    }

     
    public function getEvnenddate()
    {
        return $this->evnenddate;
    }

     
    public function setEvnenddate($evnenddate): TeamChat
    {
        $this->evnenddate = $evnenddate;
        return $this;
    }

     
    public function setTzevnenddate($evnenddate): TeamChat
    {
        $this->evnenddate = $evnenddate;
        return $this;
    }

     
    public function getEvnendtime()
    {
        return $this->evnendtime;
    }

     
    public function setEvnendtime($evnendtime): TeamChat
    {
        $this->evnendtime = $evnendtime;
        return $this;
    }

     
    public function setTzEvnendtime($evnendtime): TeamChat
    {
        $this->evnendtime = $evnendtime;
        return $this;
    }

     
    public function getEvntimeformat()
    {
        return $this->evntimeformat;
    }

     
    public function setEvntimeformat($evntimeformat): TeamChat
    {
        $this->evntimeformat = $evntimeformat;
        return $this;
    }

     
    public function getEvnMetadata()
    {
        return $this->evnMetadata;
    }

     
    public function setEvnMetadata($evnMetadata): TeamChat
    {
        if(empty($this->getEvnthumbnailid()) && preg_match('/&core_thumbnailimage_id=(?P<id>[^&]+)/ui', $evnMetadata ?? '', $matches)){
            $this->setEvnthumbnailid($matches['id']);
        }
        $this->evnMetadata = $evnMetadata;
        return $this;
    }

     
    public function getEvnuid()
    {
        return $this->evnuid;
    }

     
    public function setEvnuid($evnuid): TeamChat
    {
        $this->evnuid = $evnuid;
        return $this;
    }

     
    public function getEvncomplete()
    {
        return $this->evncomplete;
    }

     
    public function setEvncomplete($evncomplete): TeamChat
    {
        $this->evncomplete = $evncomplete;
        return $this;
    }

     
    public function getPinownId()
    {
        return $this->pinownId;
    }

     
    public function setPinownId($pinownId): TeamChat
    {
        $this->pinownId = $pinownId;
        return $this;
    }

     
    public function getPinownemail()
    {
        return $this->pinownemail;
    }

     
    public function setPinownemail($pinownemail): TeamChat
    {
        $this->pinownemail = $pinownemail;
        return $this;
    }

     
    public function getPinownname()
    {
        return $this->pinownname;
    }

     
    public function setPinownname($pinownname): TeamChat
    {
        $this->pinownname = $pinownname;
        return $this;
    }

     
    public function getGpinwhen()
    {
        return $this->gpinwhen;
    }

     
    public function setGpinwhen($gpinwhen): TeamChat
    {
        $this->gpinwhen = $gpinwhen;
        return $this;
    }

     
    public function getLpinwhen()
    {
        return $this->lpinwhen;
    }

     
    public function setLpinwhen($lpinwhen): TeamChat
    {
        $this->lpinwhen = $lpinwhen;
        return $this;
    }

     
    public function getEvnlinkid()
    {
        return $this->evnlinkid;
    }

     
    public function setEvnlinkid($evnlinkid): TeamChat
    {
        $this->evnlinkid = $evnlinkid;
        return $this;
    }

     
    public function getEvnlinktype()
    {
        return $this->evnlinktype;
    }

     
    public function setEvnlinktype($evnlinktype): TeamChat
    {
        $this->evnlinktype = $evnlinktype;
        return $this;
    }

     
    public function getEvncomevnid()
    {
        return $this->evncomevnid;
    }

     
    public function setEvncomevnid($evncomevnid): TeamChat
    {
        $this->evncomevnid = $evncomevnid;
        return $this;
    }

     
    public function getEvnowneremail()
    {
        return $this->evnowneremail;
    }

     
    public function setEvnowneremail($evnowneremail): TeamChat
    {
        $this->evnowneremail = $evnowneremail;
        return $this;
    }

     
    public function getEvnownername()
    {
        return $this->evnownername;
    }

     
    public function setEvnownername($evnownername): TeamChat
    {
        $this->evnownername = $evnownername;
        return $this;
    }

     
    public function getEvnmodifiedowneremail()
    {
        return $this->evnmodifiedowneremail;
    }

     
    public function setEvnmodifiedowneremail($evnmodifiedowneremail): TeamChat
    {
        $this->evnmodifiedowneremail = $evnmodifiedowneremail;
        return $this;
    }

     
    public function getEvnmodifiedownername()
    {
        return $this->evnmodifiedownername;
    }

     
    public function setEvnmodifiedownername($evnmodifiedownername): TeamChat
    {
        $this->evnmodifiedownername = $evnmodifiedownername;
        return $this;
    }

     
    public function getEvnmystatus()
    {
        return $this->evnmystatus;
    }

     
    public function setEvnmystatus($evnmystatus): TeamChat
    {
        $this->evnmystatus = $evnmystatus;
        return $this;
    }

     
    public function getEvnthumbnailid()
    {
        return $this->evnthumbnailid;
    }

     
    public function setEvnthumbnailid($evnthumbnailid): TeamChat
    {
        $this->evnthumbnailid = $evnthumbnailid;
        return $this;
    }

     
    public function getEvnthumbnailticket()
    {
        return \User::addTokenToTicket($this->evnthumbnailticket);
    }

     
    public function setEvnthumbnailticket($evnthumbnailticket): TeamChat
    {
        $this->evnthumbnailticket = $evnthumbnailticket;
        return $this;
    }

     
    public function getEvnticket()
    {
        return \User::addTokenToTicket($this->evnticket);
    }

     
    public function setEvnticket($evnticket): TeamChat
    {
        $this->evnticket = $evnticket;
        return $this;
    }

     
    public function getEvnmentionsInfo()
    {
        return $this->evnmentionsInfo;
    }

     
    public function setEvnmentionsInfo($evnmentionsInfo): TeamChat
    {
        $this->evnmentionsInfo = $evnmentionsInfo;
        return $this;
    }

     
    public function getEvncomlinkextras()
    {
        return $this->evncomlinkextras;
    }

     
    public function setEvncomlinkextras($evncomlinkextras): TeamChat
    {
        $this->evncomlinkextras = $evncomlinkextras;
        return $this;
    }

     
    public function getEvnaccepted()
    {
        return $this->evnaccepted;
    }

     
    public function setEvnaccepted($evnaccepted): TeamChat
    {
        $this->evnaccepted = $evnaccepted;
        return $this;
    }

     
    public function getEvnprocessingqueued()
    {
        return $this->evnprocessingqueued;
    }

     
    public function setEvnprocessingqueued($evnprocessingqueued): TeamChat
    {
        $this->evnprocessingqueued = $evnprocessingqueued;
        return $this;
    }

     
    public function getEvnthumbnailtime()
    {
        return $this->evnthumbnailtime;
    }

     
    public function setEvnthumbnailtime($evnthumbnailtime): TeamChat
    {
        $this->evnthumbnailtime = $evnthumbnailtime;
        return $this;
    }

     
    public function getEvnsizeinfo()
    {
        return $this->evnsizeinfo;
    }

     
    public function setEvnsizeinfo($evnsizeinfo): TeamChat
    {
        $this->evnsizeinfo = $evnsizeinfo;
        return $this;
    }

     
    public function getEvnlinkextras()
    {
        if($this->evnlinkextras){
            preg_match('/&Evn(Thumbnail)?Ticket=([^&]+ticket[^&]+)/ui',$this->evnlinkextras, $matches);
            if($matches['ticket']){
                $this->evnlinkextras = preg_replace('/&Evn(Thumbnail)?Ticket=([^&]+ticket[^&]+)/ui',User::addTokenToTicket($matches['ticket']), $this->evnlinkextras);
            }
        }

        return $this->evnlinkextras;
    }

     
    public function setEvnlinkextras($evnlinkextras): TeamChat
    {
        $this->evnlinkextras = $evnlinkextras;
        return $this;
    }

     
    public function getReavalue()
    {
        return $this->reavalue;
    }

     
    public function setReavalue($reavalue): void
    {
        $this->reavalue = $reavalue;
    }

     
    public function getEvnmeetingid()
    {
        return $this->evnmeetingid;
    }

     
    public function setEvnmeetingid($evnmeetingid): void
    {
        $this->evnmeetingid = $evnmeetingid;
    }

     
    public function getEvnacceptedparticipantscount()
    {
        return $this->evnacceptedparticipantscount;
    }

     
    public function setEvnacceptedparticipantscount($evnacceptedparticipantscount): void
    {
        $this->evnacceptedparticipantscount = $evnacceptedparticipantscount;
    }

     
    public function getGpinId()
    {
        return $this->gpinId;
    }

     
    public function setGpinId($gpinId): void
    {
        $this->gpinId = $gpinId;
    }

     
    public function getGpinownId()
    {
        return $this->gpinownId;
    }

     
    public function setGpinownId($gpinownId): void
    {
        $this->gpinownId = $gpinownId;
    }

     
    public function getGpinMetadata()
    {
        return $this->gpinMetadata;
    }

     
    public function setGpinMetadata($gpinMetadata): void
    {
        $this->gpinMetadata = $gpinMetadata;
    }

     
    public function getMenwhoownId()
    {
        return $this->menwhoownId;
    }

     
    public function setMenwhoownId($menwhoownId): void
    {
        $this->menwhoownId = $menwhoownId;
    }

     
    public function getMenId()
    {
        return $this->menId;
    }

     
    public function setMenId($menId): void
    {
        $this->menId = $menId;
    }

     
    public function getMenevnId()
    {
        return $this->menevnId;
    }

     
    public function setMenevnId($menevnId): void
    {
        $this->menevnId = $menevnId;
    }

     
    public function getMengrpId()
    {
        return $this->mengrpId;
    }

     
    public function setMengrpId($mengrpId): void
    {
        $this->mengrpId = $mengrpId;
    }

     
    public function getMenFolder()
    {
        return $this->menFolder;
    }

     
    public function setMenFolder($menFolder): void
    {
        $this->menFolder = $menFolder;
    }

     
    public function getMenwhoownemail()
    {
        return $this->menwhoownemail;
    }

     
    public function setMenwhoownemail($menwhoownemail): void
    {
        $this->menwhoownemail = $menwhoownemail;
    }

     
    public function getMenwhoownname()
    {
        return $this->menwhoownname;
    }

     
    public function setMenwhoownname($menwhoownname): void
    {
        $this->menwhoownname = $menwhoownname;
    }

     
    public function getMenlinktype()
    {
        return $this->menlinktype;
    }

     
    public function setMenlinktype($menlinktype): void
    {
        $this->menlinktype = $menlinktype;
    }

     
    public function getMenlinkId()
    {
        return $this->menlinkId;
    }

     
    public function setMenlinkId($menlinkId): void
    {
        $this->menlinkId = $menlinkId;
    }

     
    public function getMenlinkemail()
    {
        return $this->menlinkemail;
    }

     
    public function setMenlinkemail($menlinkemail): void
    {
        $this->menlinkemail = $menlinkemail;
    }

     
    public function getMenlinkname()
    {
        return $this->menlinkname;
    }

     
    public function setMenlinkname($menlinkname): void
    {
        $this->menlinkname = $menlinkname;
    }

     
    public function getMenwhen()
    {
        return $this->menwhen;
    }

     
    public function setMenwhen($menwhen): void
    {
        $this->menwhen = $menwhen;
    }

     
    public function getTctfdrId()
    {
        return $this->tctfdr_id;
    }

     
    public function setTctfdrId($tctfdr_id): void
    {
        $this->tctfdr_id = $tctfdr_id;
    }

     
    public function getTctgrpId()
    {
        return $this->tctgrp_id;
    }

     
    public function setTctgrpId($tctgrp_id): void
    {
        $this->tctgrp_id = $tctgrp_id;
    }

     
    public function getTctevnId()
    {
        return $this->tctevn_id;
    }

     
    public function setTctevnId($tctevn_id): void
    {
        $this->tctevn_id = $tctevn_id;
        $this->setId($tctevn_id);
    }

     
    public function getTcttopic()
    {
        return $this->tcttopic;
    }

     
    public function setTcttopic($tcttopic): void
    {
        $this->tcttopic = $tcttopic;
    }

     
    public function getTCOCcreateddate()
    {
        return $this->tcoccreateddate;
    }

     
    public function setTCOCcreateddate($tcoccreateddate): void
    {
        $this->tcoccreateddate = $tcoccreateddate;
    }

     
    public function getIsthread()
    {
        return $this->isthread;
    }

     
    public function setIsthread($isthread): void
    {
        $this->isthread = $isthread;
    }

     
    public function getIsfollowed()
    {
        return $this->isfollowed;
    }

     
    public function setIsfollowed($isfollowed): void
    {
        $this->isfollowed = $isfollowed;
    }

     
    public function getUnreadcount()
    {
        return $this->unreadcount;
    }

     
    public function setUnreadcount($unreadcount): void
    {
        $this->unreadcount = $unreadcount;
    }

     
    public function getComcount()
    {
        return $this->comcount;
    }

     
    public function setComcount($comcount): void
    {
        $this->comcount = $comcount;
    }

     
    public function getTctlastid()
    {
        return $this->tctlastid;
    }

     
    public function setTctlastid($tctlastid): void
    {
        $this->tctlastid = $tctlastid;
    }

     
    public function getTctlasttime()
    {
        return $this->tctlasttime;
    }

     
    public function setTctlasttime($tctlasttime): void
    {
        $this->tctlasttime = $tctlasttime;
    }

     
    public function getEvnacceptedparticipantcount()
    {
        return $this->evnacceptedparticipantcount;
    }

     
    public function setEvnacceptedparticipantcount($evnacceptedparticipantcount): void
    {
        $this->evnacceptedparticipantcount = $evnacceptedparticipantcount;
    }

     
    public function getEvnorganizer()
    {
        return $this->evnorganizer;
    }

     
    public function setEvnorganizer($evnorganizer): TeamChat
    {
        $this->evnorganizer = $evnorganizer;
        return $this;
    }

     
    public function getEvnsequence()
    {
        return $this->evnsequence;
    }

     
    public function setEvnsequence($evnsequence): TeamChat
    {
        $this->evnsequence = $evnsequence;
        return $this;
    }

     
    public function getEvnflags()
    {
        return $this->evnflags;
    }

     
    public function setEvnflags($evnflags): TeamChat
    {
        $this->evnflags = $evnflags;
        return $this;
    }

     
    public function getEvndescformat()
    {
        return $this->evndescformat;
    }

     
    public function setEvndescformat($evndescformat): TeamChat
    {
        $this->evndescformat = $evndescformat;
        return $this;
    }

     
    public function getGpinownemail()
    {
        return $this->gpinownemail;
    }

     
    public function setGpinownemail($gpinownemail): void
    {
        $this->gpinownemail = $gpinownemail;
    }

     
    public function getGpinownname()
    {
        return $this->gpinownname;
    }

     
    public function setGpinownname($gpinownname): void
    {
        $this->gpinownname = $gpinownname;
    }

     
    public function getPinId()
    {
        return $this->pinId;
    }

     
    public function setPinId($pinId): void
    {
        $this->pinId = $pinId;
    }

     
    public function getPinwhen()
    {
        return $this->pinwhen;
    }

     
    public function setPinwhen($pinwhen): void
    {
        $this->pinwhen = $pinwhen;
    }

     
    public function getMeetingAction()
    {
        return $this->meetingAction;
    }

     
    public function setMeetingAction($meetingAction): TeamChat
    {
        $this->meetingAction = $meetingAction;
        return $this;
    }

     
    public function getMeetingPassword()
    {
        return $this->meetingPassword;
    }

     
    public function setMeetingPassword($meetingPassword): TeamChat
    {
        $this->meetingPassword = $meetingPassword;
        return $this;
    }
     
    public function getEvndoceditable()
    {
        return ((int) $this->evndocrights & \MerakGWAPI::RIGHT_WRITE) <> 0;
    }


     
    public function getEvndocinvite()
    {
        return $this->evndocinvite;
    }

     
    public function setEvndocinvite($evndocinvite): void
    {
        $this->evndocinvite = $evndocinvite;
    }

     
    public function getEvndocpass()
    {
        return $this->evndocpass;
    }

     
    public function setEvndocpass($evndocpass): void
    {
        $this->evndocpass = $evndocpass;
    }

     
    public function getEvnmimetype()
    {
        return $this->evnmimetype;
    }

     
    public function setEvnmimetype($evnmimetype): void
    {
        $this->evnmimetype = $evnmimetype;
    }

     
    public function getEvndocrights()
    {
        return $this->evndocrights;
    }

     
    public function setEvndocrights($evndocrights): void
    {
        $this->evndocrights = $evndocrights;
    }

    public function getEvndocpassPlain()
    {
        $api = createobject('API');
        $decrypted = htmlentities($api->ManageConfig("dbpassword",0, $this->getEvndocpass()));
        return $decrypted;
    }

     
    public function getInviteticket()
    {
        return $this->inviteticket;
    }

     
    public function setInviteticket($inviteticket): void
    {
        $this->inviteticket = $inviteticket;
    }

     
    public function getData()
    {
        return $this->data;
    }

     
    public function setData($data): void
    {
        $this->data = $data;
    }

      
    public function getLastevnclass()
    {
        return $this->lastevnclass;
    }

      
    public function setLastevnclass($lastevnclass)
    {
        $this->lastevnclass = $lastevnclass;

        return $this;
    }

      
    public function getLastevnlinkid()
    {
        return $this->lastevnlinkid;
    }

      
    public function setLastevnlinkid($lastevnlinkid)
    {
        $this->lastevnlinkid = $lastevnlinkid;

        return $this;
    }

      
    public function getLastevnthumbnailtime()
    {
        return $this->lastevnthumbnailtime;
    }

      
    public function setLastevnthumbnailtime($lastevnthumbnailtime)
    {
        $this->lastevnthumbnailtime = $lastevnthumbnailtime;

        return $this;
    }
   

      
    public function getLastevnlinktype()
    {
        return $this->lastevnlinktype;
    }

      
    public function setLastevnlinktype($lastevnlinktype)
    {
        $this->lastevnlinktype = $lastevnlinktype;

        return $this;
    }

      
    public function getLastevnlocation()
    {
        return $this->lastevnlocation;
    }

      
    public function setLastevnlocation($lastevnlocation)
    {
        $this->lastevnlocation = $lastevnlocation;

        return $this;
    }

      
    public function getLastevnMetadata()
    {
        return $this->lastevn_metadata;
    }

      
    public function setLastevnMetadata($lastevn_metadata)
    {
        $this->lastevn_metadata = $lastevn_metadata;

        return $this;
    }

      
    public function getLastevncomevnid()
    {
        return $this->lastevncomevnid;
    }

      
    public function setLastevncomevnid($lastevncomevnid)
    {
        $this->lastevncomevnid = $lastevncomevnid;

        return $this;
    }

      
    public function getLastevnstartdate()
    {
        return $this->lastevnstartdate;
    }

      
    public function setLastevnstartdate($lastevnstartdate)
    {
        $this->lastevnstartdate = $lastevnstartdate;

        return $this;
    }

      
    public function getLastevnstarttime()
    {
        return $this->lastevnstarttime;
    }

      
    public function setLastevnstarttime($lastevnstarttime)
    {
        $this->lastevnstarttime = $lastevnstarttime;

        return $this;
    }

      
    public function getLastevnCreated()
    {
        return $this->lastevn_created;
    }

      
    public function setLastevnCreated($lastevn_created)
    {
        $this->lastevn_created = $lastevn_created;

        return $this;
    }

      
    public function getLastevnModified()
    {
        return $this->lastevn_modified;
    }

      
    public function setLastevnModified($lastevn_modified)
    {
        $this->lastevn_modified = $lastevn_modified;

        return $this;
    }

      
    public function getLastevnsharetype()
    {
        return $this->lastevnsharetype;
    }

      
    public function setLastevnsharetype($lastevnsharetype)
    {
        $this->lastevnsharetype = $lastevnsharetype;

        return $this;
    }

      
    public function getLastevnurl()
    {
        return $this->lastevnurl;
    }

      
    public function setLastevnurl($lastevnurl)
    {
        $this->lastevnurl = $lastevnurl;

        return $this;
    }

      
    public function getLastevnId()
    {
        return $this->lastevn_id;
    }

      
    public function setLastevnId($lastevn_id)
    {
        $this->lastevn_id = $lastevn_id;

        return $this;
    }

      
    public function getLastevnmeetingid()
    {
        return $this->lastevnmeetingid;
    }

      
    public function setLastevnmeetingid($lastevnmeetingid)
    {
        $this->lastevnmeetingid = $lastevnmeetingid;

        return $this;
    }

      
    public function getLastreavalue()
    {
        return $this->lastreavalue;
    }

      
    public function setLastreavalue($lastreavalue)
    {
        $this->lastreavalue = $lastreavalue;

        return $this;
    }

      
    public function getLastgpinId()
    {
        return $this->lastgpin_id;
    }

      
    public function setLastgpinId($lastgpin_id)
    {
        $this->lastgpin_id = $lastgpin_id;

        return $this;
    }

      
    public function getLastgpinownemail()
    {
        return $this->lastgpinownemail;
    }

      
    public function setLastgpinownemail($lastgpinownemail)
    {
        $this->lastgpinownemail = $lastgpinownemail;

        return $this;
    }

      
    public function getLastgpinownId()
    {
        return $this->lastgpinown_id;
    }

      
    public function setLastgpinownId($lastgpinown_id)
    {
        $this->lastgpinown_id = $lastgpinown_id;

        return $this;
    }

      
    public function getLastgpinownname()
    {
        return $this->lastgpinownname;
    }

      
    public function setLastgpinownname($lastgpinownname)
    {
        $this->lastgpinownname = $lastgpinownname;

        return $this;
    }

      
    public function getLastpinwhen()
    {
        return $this->lastpinwhen;
    }

      
    public function setLastpinwhen($lastpinwhen)
    {
        $this->lastpinwhen = $lastpinwhen;

        return $this;
    }

      
    public function getLastgpinMetadata()
    {
        return $this->lastgpin_metadata;
    }

      
    public function setLastgpinMetadata($lastgpin_metadata)
    {
        $this->lastgpin_metadata = $lastgpin_metadata;

        return $this;
    }

      
    public function getLastpinId()
    {
        return $this->lastpin_id;
    }

      
    public function setLastpinId($lastpin_id)
    {
        $this->lastpin_id = $lastpin_id;

        return $this;
    }

      
    public function getLastpinownId()
    {
        return $this->lastpinown_id;
    }

      
    public function setLastpinownId($lastpinown_id)
    {
        $this->lastpinown_id = $lastpinown_id;

        return $this;
    }


      
    public function getLastpinMetadata()
    {
        return $this->lastpin_metadata;
    }

      
    public function setLastpinMetadata($lastpin_metadata)
    {
        $this->lastpin_metadata = $lastpin_metadata;

        return $this;
    }
     
      
    public function getLastevnlinkextras()
    {
        return $this->lastevnlinkextras;
    }

      
    public function setLastevnlinkextras($lastevnlinkextras)
    {
        $this->lastevnlinkextras = $lastevnlinkextras;

        return $this;
    }

      
    public function getLastevnowneremail()
    {
        return $this->lastevnowneremail;
    }

      
    public function setLastevnowneremail($lastevnowneremail)
    {
        $this->lastevnowneremail = $lastevnowneremail;

        return $this;
    }

      
    public function getLastevnownername()
    {
        return $this->lastevnownername;
    }

      
    public function setLastevnownername($lastevnownername)
    {
        $this->lastevnownername = $lastevnownername;

        return $this;
    }

      
    public function getLastevnmodifiedowneremail()
    {
        return $this->lastevnmodifiedowneremail;
    }

      
    public function setLastevnmodifiedowneremail($lastevnmodifiedowneremail)
    {
        $this->lastevnmodifiedowneremail = $lastevnmodifiedowneremail;

        return $this;
    }

      
    public function getLastevnmodifiedownername()
    {
        return $this->lastevnmodifiedownername;
    }

      
    public function setLastevnmodifiedownername($lastevnmodifiedownername)
    {
        $this->lastevnmodifiedownername = $lastevnmodifiedownername;

        return $this;
    }

      
    public function getLastevnmystatus()
    {
        return $this->lastevnmystatus;
    }

      
    public function setLastevnmystatus($lastevnmystatus)
    {
        $this->lastevnmystatus = $lastevnmystatus;

        return $this;
    }

      
    public function getLastevnthumbnailid()
    {
        return $this->lastevnthumbnailid;
    }

      
    public function setLastevnthumbnailid($lastevnthumbnailid)
    {
        $this->lastevnthumbnailid = $lastevnthumbnailid;

        return $this;
    }

      
    public function getLastevnthumbnailticket()
    {
        return \User::addTokenToTicket($this->lastevnthumbnailticket);
    }

      
    public function setLastevnthumbnailticket($lastevnthumbnailticket)
    {
        $this->lastevnthumbnailticket = $lastevnthumbnailticket;

        return $this;
    }

      
    public function getLastevnticket()
    {
        return \User::addTokenToTicket($this->lastevnticket);
    }

      
    public function setLastevnticket($lastevnticket)
    {
        $this->lastevnticket = $lastevnticket;

        return $this;
    }

      
    public function getLastevnmentionsInfo()
    {
        return $this->lastevnmentions_info;
    }

      
    public function setLastevnmentionsInfo($lastevnmentions_info)
    {
        $this->lastevnmentions_info = $lastevnmentions_info;

        return $this;
    }

      
    public function getLastevnacceptedparticipantscount()
    {
        return $this->lastevnacceptedparticipantscount;
    }

      
    public function setLastevnacceptedparticipantscount($lastevnacceptedparticipantscount)
    {
        $this->lastevnacceptedparticipantscount = $lastevnacceptedparticipantscount;

        return $this;
    }

      
    public function getLastevnaccepted()
    {
        return $this->lastevnaccepted;
    }

      
    public function setLastevnaccepted($lastevnaccepted)
    {
        $this->lastevnaccepted = $lastevnaccepted;

        return $this;
    }

      
    public function getLastevnprocessingqueued()
    {
        return $this->lastevnprocessingqueued;
    }

      
    public function setLastevnprocessingqueued($lastevnprocessingqueued)
    {
        $this->lastevnprocessingqueued = $lastevnprocessingqueued;

        return $this;
    }

      
    public function getLastevnnote()
    {
        return $this->lastevnnote;
    }

      
    public function setLastevnnote($lastevnnote)
    {
        $this->lastevnnote = $lastevnnote;

        return $this;
    }


      
    public function getEvnfolder()
    {
        return $this->evnfolder;
    }

      
    public function setEvnfolder($evnfolder)
    {
        $this->evnfolder = $evnfolder;

        return $this;
    }

      
    public function getLinkinfo()
    {
        return $this->linkinfo;
    }

      
    public function setLinkinfo($linkinfo)
    {
        $this->linkinfo = trim($linkinfo);

        return $this;
    }

      
    public function getThumbnailimageid()
    {
        return $this->thumbnailimageid;
    }

      
    public function setThumbnailimageid($thumbnailimageid)
    {
        $this->thumbnailimageid = $thumbnailimageid;

        return $this;
    }
    
     
    public function setFilterTag(array &$filterTag) : AGwEventItem
    {
        if($this->getEvndoceditable()){
            if($filterTag['tag']!=''){
                $filterTag['tag'].=',';
            }
            $filterTag['tag'].= 'evndoceditable';
        }
        return parent::setFilterTag($filterTag);
    }
}
