<?php

namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Component;
use Sabre\VObject\Component\VTodo;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use server\inc\gw\Search;
use tools\SearchParserYoda;
use tools\VCalendar;

 
class Task extends AGwEventItem implements IHasAttachments, IHasRecurrences, IHasReminders, IHasAttendees
{
    use THasAttachments, THasRecurrences, THasReminders, THasAttendees, TEvnGwSearch;

     
    protected $evntitle;
    protected $evnenddate;
    protected $evnstartdate;
    protected $evnstatus;
    protected $evnpriority;
    protected $evnnote;
    protected $evntype;
    protected $evnsharetype;
    protected $evndescformat;
    protected $evnstarttime;
    protected $evnendtime;
    protected $evncomplete;
    protected $evnflags;
    protected $ctz;
    protected $dtStart;
    protected $due;

    protected static $statusOptions = [
        'B' => 'NEEDS-ACTION',
        'M' => 'COMPLETED',
        'I' => 'IN-PROCESS',
        'Q' => 'CANCELLED',
        'N' => null
    ];

    public static $searchFields = [
        'EvnTitle',
        'EvnNote'
    ];

    CONST TYPE = 'T';

     
    public function getICalendar(): string
    {
        $vcalendar = new VCalendar();
         
        $vTodo = $vcalendar->add('VTODO');
        if(!empty($this->getEvntype())) $vTodo->add('CATEGORIES', $this->getEvntype());
        $vTodo->add('DESCRIPTION', strip_tags(html_entity_decode($this->getEvnnote())));
        $vTodo->add('X-ALT-DESC', $this->getEvnnote(), ['FMTTYPE' => 'text/html']);
        $vTodo->add('SUMMARY', $this->getEvntitle());
        $vTodo->add('ORGANIZER','mailto:' . $_SESSION['EMAIL']);
        if(!empty($this->getId())){
            $vTodo->UID->setValue($this->getId());
            $vTodo->add('X-SERVER-UID', $this->getId());
        }else{
            unset($vTodo->UID);
        }
        $vTodo->add('PRIORITY', $this->getEvnpriority());
        if(!empty($this->getEvneditcounter())) $vTodo->add('SEQUENCE', $this->getEvneditcounter());
        $vTodo->add('STATUS', $this->getEvnstatus());
        $vTodo->add('DTSTART', $this->getDtStart());
        $vTodo->add('DUE', $this->getDue());
        $vTodo->add('CLASS', ($this->getEvnsharetype() == 'P' ? 'PRIVATE' : 'PUBLIC'));
        $vTodo->add('CREATED', $this->getEvnCreated());
        if($this->getEvnModified() instanceof \DateTime) $vTodo->add('LAST-MODIFIED', $this->getEvnModified());
        if($this->getEvndeleted() instanceof \DateTime) $vTodo->add('DELETED', $this->getEvndeleted());
        $vTodo->add('PERCENT-COMPLETE', $this->getEvncomplete());
         
        return $this->serialize($vcalendar, $vTodo);
    }

     
    public function getType(): string
    {
        return self::TYPE;
    }

    public function fillFromVObject(Node $vObject)
    {
        $vObject = $vObject->VTODO;
        parent::fillFromVObject($vObject);
        $this->setEvntitle($vObject->SUMMARY ?? null);
        $this->setEvntype($vObject->CATEGORIES ?? null);
        $this->setEvnsharetype((string)$vObject->CLASS == 'PRIVATE' ? 'P' : 'U');
        if(isset($vObject->{'X-ALT-DESC'})){
            $this->setEvnnote($vObject->{'X-ALT-DESC'});
        }else{
            $this->setEvnnote($vObject->{'DESCRIPTION'});
        }
        if(isset($vObject->PRIORITY)) $this->setEvnpriority($vObject->PRIORITY);
        if(isset($vObject->SEQUENCE)) $this->setEvneditcounter($vObject->SEQUENCE);
        if(isset($vObject->STATUS)) $this->setEvnstatus($vObject->STATUS);

        if(isset($vObject->DTSTART)) $this->setDtStart($vObject->DTSTART);
        if(isset($vObject->DUE)) $this->setDue($vObject->DUE);
        if(isset($vObject->{'PERCENT-COMPLETE'})) $this->setEvncomplete($vObject->{'PERCENT-COMPLETE'});
    }

    protected function afterLoad(): void
    {
             }

     
    public function afterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnEndDate > %s', $this->strToDelphiDate($value));
    }

    public function aftertimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnEndTime > %s', $this->strToTime($value));
    }

    public function beforetimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnEndTime < %s', $this->strToTimeBefore($value));
    }

    public function beforeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnEndDate < %s', $this->strToDelphiDateBefore($value));
    }

     
     
    public function getEvntitle(): string
    {
        return $this->evntitle;
    }

     
    public function setEvntitle(string $evntitle): Task
    {
        $this->evntitle = $evntitle;
        return $this;
    }

     
    public function getEvnenddate()
    {
        return $this->evnenddate;
    }

     
    public function setEvnenddate($evnenddate): Task
    {
        $this->evnenddate = $evnenddate;
        return $this;
    }

     
    public function getEvnstartdate()
    {
        return $this->evnstartdate;
    }

     
    public function setEvnstartdate($evnstartdate): Task
    {
        $this->evnstartdate = $evnstartdate;
        return $this;
    }

     
    public function getDtStart()
    {
        if(empty($this->dtStart)){
            $this->dtStart = $this->getCalendarToDateTime($this->getEvnenddate(), $this->getEvnendtime());
        }
        return $this->dtStart;
    }

     
    public function setDtStart($dtStart): Task
    {
        if(!empty($dtStart)) $this->dtStart = self::getDateTime($dtStart);
        return $this;
    }

     
    public function getDue()
    {
        if(empty($this->due)){
            $this->due = $this->getCalendarToDateTime($this->getEvnenddate(), $this->getEvnendtime());
        }
        return $this->due;
    }

     
    public function setDue($due): Task
    {
        if(!empty($due)) $this->due = self::getDateTime($due);
        return $this;
    }

     
    public function getEvnstatus()
    {
        return $this->evnstatus;
    }

     
    public function setEvnstatus($evnstatus): Task
    {
        $this->evnstatus = self::$statusOptions[$evnstatus] ?? $evnstatus;
        return $this;
    }

     
    public function getEvnpriority()
    {
        return $this->evnpriority;
    }

     
    public function setEvnpriority($evnpriority): Task
    {
        $this->evnpriority = $evnpriority;
        return $this;
    }

     
    public function getEvnnote()
    {
        return $this->evnnote;
    }

     
    public function setEvnnote($evnnote): Task
    {
                 $this->evnnote = (string)$evnnote;
        return $this;
    }

     
    public function getEvntype()
    {
        return $this->evntype;
    }

     
    public function setEvntype($evntype): Task
    {
        $this->evntype = $evntype;
        return $this;
    }

     
    public function getEvnsharetype()
    {
        return $this->evnsharetype;
    }

     
    public function setEvnsharetype($evnsharetype): Task
    {
        $this->evnsharetype = $evnsharetype;
        return $this;
    }

     
    public function getEvndescformat()
    {
        return $this->evndescformat;
    }

     
    public function setEvndescformat($evndescformat): Task
    {
        $this->evndescformat = $evndescformat;
        return $this;
    }

     
    public function getEvnstarttime()
    {
        return $this->evnstarttime;
    }

     
    public function setEvnstarttime($evnstarttime): Task
    {
        $this->evnstarttime = $evnstarttime;
        return $this;
    }

     
    public function getEvnendtime()
    {
        return $this->evnendtime;
    }

     
    public function setEvnendtime($evnendtime): Task
    {
        $this->evnendtime = $evnendtime;
        return $this;
    }

     
    public function getEvncomplete()
    {
        return $this->evncomplete;
    }

     
    public function setEvncomplete($evncomplete): Task
    {
        $this->evncomplete = $evncomplete;
        return $this;
    }

     
    public function getEvnflags()
    {
        return $this->evnflags;
    }

     
    public function setEvnflags($evnflags): Task
    {
        $this->evnflags = $evnflags;
        return $this;
    }

     
    public function getCtz()
    {
        return $this->ctz;
    }

     
    public function setCtz($ctz): Task
    {
        $this->ctz = $ctz;
        return $this;
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }

    public static function getCountByFilter(\Folder $folder, $filter)
    {
             }
}