<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use tools\ParamLineParser;

 
trait THasReminders
{
     
    protected $reminders = [];

     
    public function getReminders(): array
    {
        return $this->reminders;
    }

     
    public function getReminder(string $hash): ? Reminder
    {
        return $this->reminders[$hash] ?? null;
    }

     
    public function setReminders(array $reminders)
    {
        $this->reminders = $reminders;
        array_walk($reminders, function ($value){ $value = spl_object_hash($value); });
        $this->reminders = array_combine($reminders, $this->reminders);
        return $this;
    }

     
    public function addReminder(Reminder $attachment)
    {
        $this->reminders[spl_object_hash($attachment)] = $attachment;
        return $this;
    }

     
    public static function addRemindersFromSimpleXML(AGwEventItem $hasReminders, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->reminders)) return;
        foreach ($simpleXml->reminders->children() as $attachment) {
            $hasReminders->addReminder(Reminder::createFromXML($hasReminders->getFolder(), $attachment->asXML(), false, $hasReminders));
        }
    }

     
    public static function addRemindersFromVObject(AGwEventItem $hasReminders, Node $component)
    {
        if(!is_iterable($component->VALARM)) return;
        foreach ($component->VALARM as $attach) {
            $reminder = new Reminder($hasReminders->getFolder());
            $reminder->fillFromVObject($attach);
            $hasReminders->addReminder($reminder);
        }
    }

    public function addRemindersFromGW()
    {
        if(!$this instanceof AGwEventItem) return;
        $data = $this->getGwApi()->FunctionCall('getEventReminders', $this->getFolderSessionId(), $this->getId());
        $parser = new ParamLineParser($data);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $reminder = new Reminder($this->getFolder());
            $reminder->fillFromArray($parsedParamLine);
            $this->addReminder($reminder);
        }
    }

    public function addRemindersTemplateDataArray(array & $result)
    {
        $this->addChildrenTemplateDataArray($result, $this->getReminders(), 'reminders', 'reminder',null, [], [], ['rmndaysbefore', 'rmnhoursbefore', 'rmnminutesbefore']);
    }

    public function updateRemindersFromObject(AGwEventItem $source) : void
    {
         
        $this->reminders = [];
        foreach ($source->getReminders() as $reminder) {
            $this->addReminder($reminder);
            $reminder->setParent($this);
        }
    }
}