<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use tools\ParamLineParser;

 
trait THasRecurrences
{
     
    protected $recurrences = [];

     
    public function getRecurrences(): array
    {
        return $this->recurrences;
    }

     
    public function getRecurrence(string $hash): ? Recurrence
    {
        return $this->recurrences[$hash] ?? null;
    }

     
    public function setRecurrences(array $recurrences)
    {
        $this->recurrences = $recurrences;
        array_walk($recurrences, function ($value){ $value = spl_object_hash($value); });
        $this->recurrences = array_combine($recurrences, $this->recurrences);
        return $this;
    }

     
    public function addRecurrence(Recurrence $recurrence)
    {
        $this->recurrences[spl_object_hash($recurrence)] = $recurrence;
        return $this;
    }

     
    public static function addRecurrencesFromSimpleXML(AGwEventItem $hasRecurrences, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->recurrences)) return;
        foreach ($simpleXml->recurrences->children() as $attachment) {
            $hasRecurrences->addRecurrence(Recurrence::createFromXML($hasRecurrences->getFolder(), $attachment->asXML(), false, $hasRecurrences));
        }
    }

     
    public static function addRecurrencesFromVObject(AGwEventItem $hasRecurrences, Node $component)
    {
        if(!is_iterable($component->RRULE)) return;
        foreach ($component->RRULE as $attach) {
            $recurrence = new Recurrence($hasRecurrences->getFolder());
            $recurrence->fillFromVObject($attach);
            $hasRecurrences->addRecurrence($recurrence);
        }
    }

    public function addRecurrencesFromGW()
    {
        if(!$this instanceof AGwEventItem) return;
        $data = $this->getGwApi()->FunctionCall('getEventRecurrence', $this->getFolderSessionId(), $this->getId());
        $parser = new ParamLineParser($data);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $recurrence = new Recurrence($this->getFolder());
            $recurrence->fillFromArray($parsedParamLine);
            $this->addRecurrence($recurrence);
        }
    }

    public function addRecurrencesTemplateDataArray(array & $result)
    {
        $empty = ['rcrdayrepetition', 'rcrdayofweeknumber', 'rcrweekrepetition', 'rcrweekofmonthnumber', 'rcrmonthrepetition', 'rcrmonthofyearnumber', 'rcryearrepetition', 'rcrenddate', 'rcrcount'];
        $this->addChildrenTemplateDataArray($result, $this->getRecurrences(), 'recurrences', 'recurrence', null, [], [], $empty);
    }

    public function updateRecurrencesFromObject(AGwEventItem $source) : void
    {
         
        $this->recurrences = [];
        foreach ($source->getRecurrences() as $recurrence) {
            $this->addRecurrence($recurrence);
            $recurrence->setParent($this);
        }
    }
}