<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use tools\ParamLineParser;

 
trait THasOccurrences
{
     
    protected $occurrences = [];
    protected $uids = [];

     
    public function getOccurrences(): array
    {
        return $this->occurrences;
    }

     
    public function getOccurrence(string $hash): ? Occurrence
    {
        return $this->occurrences[$hash] ?? null;
    }

     
    public function setOccurrences(array $occurrences)
    {
        $this->occurrences = $occurrences;
        array_walk($occurrences, function ($value){ $value = spl_object_hash($value); });
        $this->occurrences = array_combine($occurrences, $this->occurrences);
        return $this;
    }

     
    public function addOccurrence(Occurrence $occurrence)
    {
        $hash = spl_object_hash($occurrence);
        $this->occurrences[$hash] = $occurrence;
        $this->uids[$occurrence->getId()] = $hash;
        return $this;
    }

     
    public function removeOccurrence(string $uid)
    {
        unset($this->occurrences[$this->uids[$uid]]);
    }

     
    public static function addOccurrencesFromSimpleXML(IHasOccurrences $hasOccurrences, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->occurrences)) return;
        foreach ($simpleXml->occurrences->children() as $occurrence) {
            if(isset($occurrence->attributes()->uid)){
                $hasOccurrences->removeOccurrence($occurrence->attributes()->uid);
                continue;
            }
            $hasOccurrences->addOccurrence(Occurrence::createFromXML($hasOccurrences->getFolder(), $occurrence->asXML(), false, $hasOccurrences));
        }
    }

     
    public static function addOccurrencesFromVObject(IHasOccurrences $hasOccurrences, Node $component)
    {
        if(!is_iterable($component->VEVENT)) return;
        foreach ($component->VEVENT as $vEvent) {
            $occurrence = new Occurrence($hasOccurrences->getFolder());
            $occurrence->fillFromVObject($vEvent);
            $hasOccurrences->addOccurrence($occurrence);
        }
    }

    public function updateOccurrencesFromObject(AGwEventItem $source) : void
    {

    }
}