<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use Sabre\VObject\Property;

 
trait THasLocations
{
     
    protected $locations = [];

     
    public function getLocations(): array
    {
        return $this->locations;
    }

     
    public function getLocation(string $hash): ? Location
    {
        return $this->locations[$hash] ?? null;
    }

     
    public function setLocations(array $locations)
    {
        $this->locations = $locations;
        array_walk($locations, function ($value){ $value = spl_object_hash($value); });
        $this->locations = array_combine($locations, $this->locations);
        return $this;
    }

     
    public function addLocation(Location $location)
    {
        $this->locations[spl_object_hash($location)] = $location;
        return $this;
    }

     
    public static function addLocationsFromSimpleXML(AGwEventItem $hasLocations, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->locations)) return;
        foreach ($simpleXml->locations->children() as $location) {
            $hasLocations->addLocation(Location::createFromXML($hasLocations->getFolder(), $location->asXML(), false, $hasLocations));
        }
    }

     
    public static function addLocationsFromVObject(AGwEventItem $hasLocations, Node $component)
    {
        self::addLocationForeach($hasLocations, $component->URL);
        self::addLocationForeach($hasLocations, $component->IMPP);
        self::addLocationForeach($hasLocations, $component->EMAIL);
        self::addLocationForeach($hasLocations, $component->TEL);
        self::addLocationForeach($hasLocations, $component->ADR);
        self::addLocationForeach($hasLocations, $component->ADR);
    }

     
    protected static function addLocationForeach(AGwEventItem $hasLocations, Property $foreach)
    {
        if(!is_iterable($foreach)) return;
        foreach ($foreach as $attach) {
            $location = new Location($hasLocations->getFolder());
            $location->fillFromVObject($attach);
            $hasLocations->addLocation($location);
        }
    }

    public function updateLocationsFromObject(AGwEventItem $source) : void
    {

    }
}