<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use tools\ParamLineParser;

 
trait THasItemAttributes
{
     
    protected $itemAttributes = [];

     
    public function getItemAttributes(): array
    {
        return $this->itemAttributes;
    }

     
    public function getItemAttribute(string $hash): ? ItemAttribute
    {
        return $this->itemAttributes[$hash] ?? null;
    }

     
    public function setItemAttributes(array $itemAttributes)
    {
        $this->itemAttributes = $itemAttributes;
        array_walk($itemAttributes, function ($value){ $value = spl_object_hash($value); });
        $this->itemAttributes = array_combine($itemAttributes, $this->itemAttributes);
        return $this;
    }

     
    public function addItemAttribute(ItemAttribute $itemAttribute)
    {
        $this->itemAttributes[spl_object_hash($itemAttribute)] = $itemAttribute;
        return $this;
    }

     
    public function removeItemAttribute(ItemAttribute $itemAttribute)
    {
        unset($this->itemAttributes[spl_object_hash($itemAttribute)]);
    }

     
    public static function addItemAttributesFromSimpleXML(AGwEventItem $hasItemAttributes, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->itemAttributes)) return;
        foreach ($simpleXml->itemAttributes->children() as $itemAttributes) {
            $hasItemAttributes->addLocation(Location::createFromXML($hasItemAttributes->getFolder(), $itemAttributes->asXML(), false, $hasItemAttributes));
        }
    }

     
    public static function addItemAttributesFromVObject(AGwEventItem $hasItemAttributes, Node $component)
    {

    }

     
    protected static function addItemAttributesForeach(AGwEventItem $hasItemAttributes, iterable $foreach)
    {
        if(!is_iterable($foreach)) return;
        foreach ($foreach as $attach) {
            $itemAttribute = new ItemAttribute($hasItemAttributes->getFolder(), null, $hasItemAttributes);
            $itemAttribute->fillFromArray($attach);
            $hasItemAttributes->addItemAttribute($itemAttribute);
        }
    }

    public function addItemAttributesFromGW()
    {
        if(!$this instanceof AGwEventItem) return;
        $data = $this->getGwApi()->FunctionCall('GetItemAttributes', $this->getFolderSessionId(), $this->getId());
        $parser = new ParamLineParser($data);
        $parser->removeKeysPrefix('att');
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $attachment = new Attachment($this->getFolder());
            $attachment->fillFromArray($parsedParamLine);
            $attachment->setDescription($parsedParamLine['desc']);
            $attachment->setEvnCreated($parsedParamLine['time']);
            $attachment->setFullpath($this->getGwApi()->FunctionCall('getAttachmentPathLocal', $this->getFolderSessionId(), $this->getId(), $parsedParamLine['name']));
            $this->addAttachment($attachment);
        }
             }

    public function updateItemAttributesFromObject(AGwEventItem $source) : void
    {

    }
}