<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use tools\ParamLineParser;

 
trait THasEventReactions
{
     
    protected $eventReactions = [];

     
    public function getEventReactions(): array
    {
        return $this->eventReactions;
    }

     
    public function getEventReaction(string $hash): ? EventReaction
    {
        return $this->eventReactions[$hash] ?? null;
    }

     
    public function setEventReactions(array $eventReactions)
    {
        $this->eventReactions = $eventReactions;
        array_walk($eventReactions, function ($value){ $value = spl_object_hash($value); });
        $this->eventReactions = array_combine($eventReactions, $this->eventReactions);
        return $this;
    }

     
    public function addEventReaction(EventReaction $eventReaction)
    {
        $this->eventReactions[spl_object_hash($eventReaction)] = $eventReaction;
        return $this;
    }

     
    public function removeEventReaction(EventReaction $eventReaction)
    {
        unset($this->eventReactions[spl_object_hash($eventReaction)]);
    }

     
    public static function addEventReactionsFromSimpleXML(AGwEventItem $hasEventReactions, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->reactions)) return;
        foreach ($simpleXml->reactions->children() as $eventReactions) {
            $hasEventReactions->addEventReaction(EventReaction::createFromXML($hasEventReactions->getFolder(), $eventReactions->asXML(), false, $hasEventReactions));
        }
    }

     
    public static function addEventReactionsFromVObject(AGwEventItem $hasEventReactions, Node $component)
    {

    }

     
    protected static function addEventReactionsForeach(AGwEventItem $hasEventReactions, iterable $foreach)
    {
        if(!is_iterable($foreach)) return;
        foreach ($foreach as $attach) {
            $eventReaction = new EventReaction($hasEventReactions->getFolder(), null, $hasEventReactions);
            $eventReaction->fillFromArray($attach);
            $hasEventReactions->addEventReaction($eventReaction);
        }
    }

    public function addEventReactionsFromGW()
    {
        if(!$this instanceof AGwEventItem) return;
        $data = $this->getGwApi()->FunctionCall('GetEventReactions', $this->getFolderSessionId(), $this->getId());
        $parser = new ParamLineParser($data);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $attachment = new EventReaction($this->getFolder());
            $attachment->fillFromArray($parsedParamLine);
            $this->addEventReaction($attachment);
        }
    }

     
    protected function getKeyComparableArray() : array
    {
        $result = [];
        foreach ($this->getEventReactions() as $eventReaction) {
            $result[$eventReaction->getReaownId().':'.$eventReaction->getReaownname()] = $eventReaction;
        }
        return $result;
    }

    public function addEventReactionsTemplateDataArray(array & $result)
    {
        $this->addChildrenTemplateDataArray($result, $this->getEventReactions(), 'reactions', 'reaction', 'reaown_id');
    }

     
    public function updateEventReactionsFromObject(AGwEventItem $source) : void
    {
        $this->eventReactions = [];
        foreach ($source->getEventReactions() as $getEventReaction) {
            $this->addEventReaction($getEventReaction);
            $getEventReaction->setParent($this);
        }
         
    }
}