<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;

 
trait THasCertificates
{
     
    protected $certificates = [];
    protected $uids = [];

     
    public function getCertificates(): array
    {
        return $this->certificates;
    }

     
    public function getCertificate(string $hash): ? Certificate
    {
        return $this->certificates[$hash] ?? null;
    }

     
    public function setCertificates(array $certificates)
    {
        $this->certificates = $certificates;
        array_walk($certificates, function ($value){ $value = spl_object_hash($value); });
        $this->certificates = array_combine($certificates, $this->certificates);
        return $this;
    }

     
    public function addCertificate(Certificate $certificate)
    {
        $hash = spl_object_hash($certificate);
        $this->certificates[$hash] = $certificate;
        $this->uids[$certificate->getDescription()] = $hash;
        return $this;
    }

     
    public static function addCertificatesFromSimpleXML(AGwEventItem $hasCertificates, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->certificates)) return;
        foreach ($simpleXml->certificates->children() as $certificate) {
            $hasCertificates->addCertificate(Certificate::createFromXML($hasCertificates->getFolder(), $certificate->asXML(), false, $hasCertificates));
        }
    }

     
    public static function addCertificatesFromVObject(AGwEventItem $hasCertificates, Node $component)
    {
        if(!is_iterable($component->KEY)) return;
        foreach ($component->KEY as $attach) {
            $certificate = new Certificate($hasCertificates->getFolder());
            $certificate->fillFromVObject($attach);
            $hasCertificates->addCertificate($certificate);
        }
    }

    public function updateCertificatesFromObject(AGwEventItem $source) : void
    {

    }
}