<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use tools\ParamLineParser;

trait THasAttendees
{
     
    protected $attendees = [];
    protected $uids = [];

     
    public function getAttendees(): array
    {
        return $this->attendees;
    }

     
    public function getAttendee(string $hash): ? Attendee
    {
        return $this->attendees[$hash] ?? null;
    }

     
    public function setAttendees(array $attendees)
    {
        $this->attendees = $attendees;
        array_walk($attendees, function ($value){ $value = spl_object_hash($value); });
        $this->attendees = array_combine($attendees, $this->attendees);
        return $this;
    }

     
    public function addAttendee(Attendee $attendee)
    {
        $hash = spl_object_hash($attendee);
        $this->attendees[$hash] = $attendee;
        $this->uids[$attendee->getId()] = $hash;
        return $this;
    }

     
    public function removeAttendee(string $uid)
    {
        unset($this->attendees[$this->uids[$uid]]);
    }

     
    public static function addAttendeesFromSimpleXML(AGwEventItem $hasAttendees, \SimpleXMLElement $simpleXml)
    {
        if(isset($simpleXml->attendees)){
            $attendees = $simpleXml->attendees;
        }elseif(isset($simpleXml->contacts)){
            $attendees = $simpleXml->contacts;
        }else{
            return;
        }
        foreach ($attendees->children() as $attendee) {
            $hasAttendees->addAttendee(Attendee::createFromXML($hasAttendees->getFolder(), $attendee->asXML(), false, $hasAttendees));
        }
    }

    public static function addAttendeesFromVObject(AGwEventItem $hasAttendees, Node $component)
    {
        if(!is_iterable($component->ATTENDEE)) return;
        foreach ($component->ATTENDEE as $attach) {
            $attendee = new Attendee($hasAttendees->getFolder());
            $attendee->fillFromVObject($attach);
            $hasAttendees->addAttendee($attendee);
        }
    }

    public function addAttendeesFromGW()
    {
        if(!$this instanceof AGwEventItem) return;
        $data = $this->getGwApi()->FunctionCall('getEventContacts', $this->getFolderSessionId(), $this->getId());
        $parser = new ParamLineParser($data);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $attendee = new Attendee($this->getFolder());
            $attendee->fillFromArray($parsedParamLine);
           $this->addAttendee($attendee);
        }
    }

    public function addAttendeesTemplateDataArray(array & $result)
    {
        $this->addChildrenTemplateDataArray($result, $this->getAttendees(), 'contacts', 'contact', 'cnt_id');
    }

    public function updateAttendeesFromObject(IHasAttendees $source) : void
    {
        $newAttendees = $source->getAttendees();
        foreach ($newAttendees as $newAttendee) {
            $this->removeAttendee($newAttendee->getId());
            if(!$newAttendee->removed){
                $this->addAttendee($newAttendee);
            }
        }
    }
}