<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use tools\ParamLineParser;

 
trait THasAttachments
{
     
    protected $attachments = [];
    protected $uids = [];

     
    public function getAttachments(): array
    {
        return $this->attachments;
    }

     
    public function getAttachment(string $hash): ? Attachment
    {
        return $this->attachments[$hash] ?? null;
    }

     
    public function setAttachments(array $attachments)
    {
        $this->attachments = $attachments;
        array_walk($attachments, function ($value){ $value = spl_object_hash($value); });
        $this->attachments = array_combine($attachments, $this->attachments);
        return $this;
    }

     
    public function addAttachment(Attachment $attachment)
    {
        $hash = spl_object_hash($attachment);
        $this->attachments[$hash] = $attachment;
        $this->uids[$attachment->getId()] = $hash;
        return $this;
    }

     
    public function removeAttachment(string $uid)
    {
        unset($this->attachments[$this->uids[$uid]]);
    }

     
    public static function addAttachmentsFromSimpleXML(AGwEventItem $hasAttachments, \SimpleXMLElement $simpleXml)
    {
        if(!isset($simpleXml->attachments)) return;
        foreach ($simpleXml->attachments->children() as $attachment) {
            $hasAttachments->addAttachment(Attachment::createFromXML($hasAttachments->getFolder(), $attachment->asXML(), false, $hasAttachments));
        }
    }

     
    public static function addAttachmentsFromVObject(AGwEventItem $hasAttachments, Node $component)
    {
        if(!is_iterable($component->ATTACH)) return;
        foreach ($component->ATTACH as $attach) {
            $attachment = new Attachment($hasAttachments->getFolder());
            $attachment->fillFromVObject($attach);
            $hasAttachments->addAttachment($attachment);
        }
    }

    public function addAttachmentsFromGW()
    {
        if(!$this instanceof AGwEventItem) return;
        $data = $this->getGwApi()->FunctionCall('getAttachmentList', $this->getFolderSessionId(), $this->getId());
        $parser = new ParamLineParser($data);
        $parser->removeKeysPrefix('att');
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $attachment = new Attachment($this->getFolder(), null, $this);
            $attachment->fillFromArray($parsedParamLine);
            $attachment->setDescription($parsedParamLine['desc']);
            $attachment->setEvnCreated($parsedParamLine['time']);
            $attachment->setFullpath($this->getGwApi()->FunctionCall('getAttachmentPathLocal', $this->getFolderSessionId(), $this->getId(), $parsedParamLine['name']));
            $this->addAttachment($attachment);
        }
    }

    public function addAttachmentsTemplateDataArray(array & $result, $uidField = 'description', array $skipFields = [], array $renameFields = [])
    {
        $rename = [
            'fileLocation' => 'ticket',
            'description' => 'attdesc',
            'name' => 'attname',
            'size' => 'attsize',
            'fileType' => 'attparams',
            ];
        $this->addChildrenTemplateDataArray($result, $this->getAttachments(), 'attachments', 'attachment', $uidField, $skipFields, array_merge($rename, $renameFields));
    }

    protected static function correctPostWithEmailAttachments(& $result, bool & $save)
    {
        if(is_array($result)){
            foreach ($result as $index => $item) {
                $result[$index] = self::getCorrectedPostWithEmailAttachment($item, $save);
            }
        }else{
            $result = self::getCorrectedPostWithEmailAttachment($result, $save);
        }
        return $result;
    }

    protected static function getCorrectedPostWithEmailAttachment(AGwEventItem $post, bool & $save)
    {
         
         
        $attachment = current($post->getAttachments());
        if($attachment === false || $attachment->getFileType() != 'message/rfc822') return $post;
        $parent = $post->getParent();
        $folder = $post->getFolder();
        $oDOMDoc = \slToolsDOM::openFromString($post->getSourceSimpleXML()->saveXML());
        $aItem = \Tools::makeArrayFromXML($oDOMDoc->getNode("//item/values"));
        $post = \server\model\TeamChat::createFromMessage($folder, $attachment->getFileLocation(), $post->getEvnnote(), $item, $aItem, true, $folder->name);
        $post->setParent($parent);
        $save = false;
        return $post;
    }

    public function updateAttachmentsFromObject(AGwEventItem $source) : void
    {
         
        $newAttachments = $source->getAttachments();
        foreach ($newAttachments as $attachment) {
            $this->removeAttachment($attachment->getId());
            if(!$attachment->removed){
                $this->addAttachment($attachment);
            }
        }
    }
}