<?php

namespace server\model;

use server\inc\gw\Search;

trait TEvnGwSearch
{
    use TCommonGwSearch;

    public function creationdateCondition(Search $search, $value) : string
    {
        $dateTime = \DateTime::createFromFormat('Y-m-d', $value);
        $dateTime->setTime(0,0);
        $value = [$dateTime->getTimestamp()];
        $dateTime->setTime(23,59,59);
        $value[] = $dateTime->getTimestamp();
        return $this->placeValueToCondition('(EvnCreated > %s AND EvnCreated < %s)', $value);
    }

    public function titleCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(EvnTitle IS NOT NULL AND EvnTitle LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function ridCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(EvnRID = '%s')", $value);
    }

    public function isCondition(Search $search, $value) : string
    {
        if($value == 'read') return $search->addTableName('unread') . ' = 0';
        if($value == 'unread') return $search->addTableName('unread') . ' = 1';
        if($value == 'flagged') return $search->addTableName('color') . " <> 'Z'";
        if($value == 'done') return "EvnStatus = 'M'";
        if($value == 'free') return "{BITAND}EvnFlags,4{/BITAND}";
        if($value == 'busy') return "NOT {BITAND}EvnFlags,4{/BITAND}";
        if($value == 'private') return "(EvnShareType = 'C' OR EvnShareType='P')";
        if($value == 'public') return "(EvnShareType <> 'P' AND EvnShareType <> 'C')";
        return '';
    }

    public function itemsCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(EVN_ID = '%s' )", $value);
    }

    public function afteridCondition(Search $search, $value) : string
    {
        $threadSearchPrefix = $this->isThreadSearch($search) ? 'MainEvent.':'';
        return $this->placeValueToCondition("(".$threadSearchPrefix."Evn_ID > '%s')", $value);
    }

    public function beforeidCondition(Search $search, $value) : string
    {
        $threadSearchPrefix = $this->isThreadSearch($search) ? 'MainEvent.':'';
        return $this->placeValueToCondition("(".$threadSearchPrefix."Evn_ID < '%s')", $value);
    }

    public function uidsCondition(Search $search, $value) : string
    {
        if(!preg_match_all('/[^,\\s]+/', $value, $matches)) return '';
        $in = array_fill(0, count($matches[0]), "'%s'");
        return $this->placeValueToCondition("(EVN_ID IN (" . implode(',', $in) . "))", $matches[0]);
    }

    public function uidCondition(Search $search, $value) : string
    {
        if(!preg_match_all('/[^,\\s]+/', $value, $matches)) return '';
        $in = array_fill(0, count($matches[0]), "'%s'");
        $idCondition = $this->placeValueToCondition("EVN_ID IN (" . implode(',', $in) . ")",$matches[0]);
        $uidCondition = $this->placeValueToCondition("EvnUID IN (" . implode(',', $in) . ")",$matches[0]);
        return '('.$idCondition.' OR '.$uidCondition.')';
    }
 
    public function descriptionCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("((EvnNote is NOT NULL) AND (EvnNote LIKE '%%%s%%'))", $value);
    }

    public function locationCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("((EvnLocation is NOT NULL) AND (EvnLocation LIKE '%%%s%%'))", $value);
    }

    private function isThreadSearch(Search $search)
    {
        return preg_match('/gchat:(threads|unread_threads)/si',$search->filter['type'],$matches) || $search->filter['groupchat_type'] == 'threads';
    }
}
