<?php

namespace server\model;

use server\inc\gw\Search;

trait TCommonGwSearch
{
    public function fulltextCondition(Search $search, $value) : string
    {
        $conditions = [];
        $count = 0;
        foreach(self::$searchFields as $field){
            $conditions[] = "(" . $search->addTableName($field) . " IS NOT NULL AND " . $search->addTableName($field) . " LIKE '%%%s%%' {ESCAPE '\\'})";
            $count++;
        }
        $condition = join(' OR ',$conditions);
        if($search->fulltextEnabled()){
            $condition .= ' OR {FULLTEXT}%s{/FULLTEXT}';
        }
        $condition = '('.$condition.')';
        return $this->placeValueToCondition($condition, $value, ++$count);
    }

    public function tagCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("{TAG}%s{/TAG}", $value);
    }

    public static function kiloByteToByte($str)
    {
        return ((int) $str) * 1024;
    }
}