<?php

namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Component;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use Sabre\VObject\Property\ICalendar\Duration;
use server\inc\gw\Search;

class Reminder extends AGwEventItem implements ISubItem
{
    protected $rmndaysbefore = 0;
    protected $rmnhoursbefore = 0;
    protected $rmnminutesbefore = 0;
    protected $rmntime = null;
    protected $rmnlastack;

    public function save(): AGwEventItem
    {
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $folderSessionId = $this->getFolder()->openAccess();
        if(!$this->prepareParamLine()){
            return false;
        }
        $gwApi->FunctionCall('addEventReminder', $folderSessionId, $this->getParent()->getId(), $this->getParamLine());
        return $this;
    }

    public function getICalendar(): string
    {
        $result = ['BEGIN:VALARM'];
        $result[] = 'ACTION:DISPLAY';
        if(!empty($this->getRmntime())) $result[] = 'TRIGGER;VALUE=DATE-TIME:' . date('Ymd\THis\Z', $this->getRmntime());
        $result[] = 'END:VALARM';
        return implode(PHP_EOL, $result);
    }

    public function getType(): string
    {
        return '';
    }

    protected function getDuration()
    {
        if(!empty($this->getRmnminutesbefore())) return '-PT' . $this->getRmnminutesbefore() . 'M';
        if(!empty($this->getRmnhoursbefore())) return '-PT' . $this->getRmnhoursbefore() . 'H';
        if(!empty($this->getRmndaysbefore())) return '-P' . $this->getRmndaysbefore() . 'D';
    }

    public function addToICalendar(Component $vComponent): void
    {
        $vAlarm = $vComponent->add('VALARM');
        $vAlarm->add('ACTION', 'DISPLAY');
        if(!empty($this->getRmntime())){
            $vAlarm->add('TRIGGER', $this->getRmntime(), ['VALUE' => 'DATE-TIME']);
        }else{
            $vAlarm->add('TRIGGER', $this->getDuration(), ['VALUE' => 'DURATION']);
        }
    }

    public function fillFromVObject(Node $vObject)
    {
        if(!$vObject->TRIGGER instanceof Property) return;
        if($vObject->TRIGGER instanceof Duration){
            if(!preg_match('/\-?PT?(?P<number>\d+)(?P<minutes>M)?(?P<hours>H)?(?P<days>D)?/i', $vObject->TRIGGER->getValue(), $matches)) return;
            if(isset($matches['minutes'])) $this->setRmnminutesbefore($matches['number']);
            if(isset($matches['hours'])) $this->setRmnhoursbefore($matches['number']);
            if(isset($matches['days'])) $this->setRmndaysbefore($matches['number']);
        }elseif($vObject->TRIGGER instanceof Property\ICalendar\DateTime){
            $this->setRmntime($vObject->TRIGGER->getValue());
        }
        if(isset($vObject->{'X-MOZ-LASTACK'})) $this->setRmnlastack((string) $vObject->{'X-MOZ-LASTACK'});
    }

     
    public function getRmndaysbefore(): int
    {
        return $this->rmndaysbefore;
    }

     
    public function setRmndaysbefore($rmndaysbefore): Reminder
    {
        $this->rmndaysbefore = filter_var($rmndaysbefore, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);;
        return $this;
    }

     
    public function getRmnhoursbefore(): int
    {
        return $this->rmnhoursbefore;
    }

     
    public function setRmnhoursbefore($rmnhoursbefore): Reminder
    {
        $this->rmnhoursbefore = filter_var($rmnhoursbefore, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRmnminutesbefore(): int
    {
        return $this->rmnminutesbefore;
    }

     
    public function setRmnminutesbefore($rmnminutesbefore): Reminder
    {
        $this->rmnminutesbefore = filter_var($rmnminutesbefore, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRmntime()
    {
        return $this->rmntime;
    }

     
    public function setRmntime($rmntime): Reminder
    {
        $this->rmntime = AGwEventItem::getDateTime($rmntime);
        return $this;
    }

    protected function afterLoad(): void
    {
             }


     
    public static function getControlInterface(): string
    {
        return '';
    }

     
    public static function getLoadingFunction(): string
    {
        return '';
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }

     
    public function getRmnlastack()
    {
        return $this->rmnlastack;
    }

     
    public function setRmnlastack($rmnlastack): Reminder
    {
        $this->rmnlastack = self::getDateTime($rmnlastack);
        return $this;
    }

}