<?php

namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Component;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use server\inc\gw\Search;

 
class Recurrence extends AGwEventItem implements ISubItem
{
    protected $rcrdayrepetition = 0;
    protected $rcrdayofweeknumber = 0;
    protected $rcrweekrepetition = 0;
    protected $rcrweekofmonthnumber = 0;
    protected $rcrmonthrepetition = 0;
    protected $rcrmonthofyearnumber = 0;
    protected $rcryearrepetition = 0;
    protected $rcrenddate;
    protected $rcrcount = 0;

    public function save(): AGwEventItem
    {
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $folderSessionId = $this->getFolder()->openAccess();
        if(!$this->prepareParamLine()){
            return false;
        }
        $gwApi->FunctionCall('addEventRecurrence', $folderSessionId, $this->getParent()->getId(), $this->getParamLine());
        return $this;
    }

     
    public function getICalendar(): string
    {
        return 'RRULE:' . $this->getRRuleValue();
    }

     
    public function getType(): string
    {
        return '';
    }

     
    protected function getRRuleValue()
    {
        $result = [];
        if(!empty($this->getRcrmonthrepetition())) $result[] = 'FREQ=MONTHLY';
        if(!empty($this->getRcrdayrepetition())) $result[] = 'FREQ=DAILY;INTERVAL='.$this->getRcrdayrepetition();
        if(!empty($this->getRcrweekrepetition())) $result[] = 'FREQ=WEEKLY';
        if(!empty($this->getRcrdayofweeknumber())) $result[] = 'BYWEEKDAY='.$this->getRcrdayofweeknumber();
        if(!empty($this->getRcryearrepetition())) $result[] = 'FREQ=YEARLY';
        if(!empty($this->getRcrmonthofyearnumber())) $result[] = 'BYMONTH='.$this->getRcrmonthofyearnumber();
        if(!empty($this->getRcrcount())) $result[] = 'COUNT='.$this->getRcrcount();
        return implode(';', $result);
    }

     
    public function addToICalendar(Component $vComponent): void
    {
        $vComponent->add('RRULE', $this->getRRuleValue());
    }

     
    public function fillFromVObject(Node $vObject)
    {
        $parts = $vObject->getParts();
        if($parts['FREQ'] == 'DAILY'){
            $this->setRcrdayrepetition($parts['INTERVAL']);
        }
        $this->setRcrcount($parts['COUNT'] ?? 0);
    }

     
    public function getRcrdayrepetition(): int
    {
        return $this->rcrdayrepetition;
    }

     
    public function setRcrdayrepetition($rcrdayrepetition): Recurrence
    {
        $this->rcrdayrepetition = filter_var($rcrdayrepetition, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRcrdayofweeknumber(): int
    {
        return $this->rcrdayofweeknumber;
    }

     
    public function setRcrdayofweeknumber($rcrdayofweeknumber): Recurrence
    {
        $this->rcrdayofweeknumber = filter_var($rcrdayofweeknumber, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRcrweekrepetition(): int
    {
        return $this->rcrweekrepetition;
    }

     
    public function setRcrweekrepetition($rcrweekrepetition): Recurrence
    {
        $this->rcrweekrepetition = filter_var($rcrweekrepetition, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRcrweekofmonthnumber(): int
    {
        return $this->rcrweekofmonthnumber;
    }

     
    public function setRcrweekofmonthnumber($rcrweekofmonthnumber): Recurrence
    {
        $this->rcrweekofmonthnumber = filter_var($rcrweekofmonthnumber, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRcrmonthrepetition(): int
    {
        return $this->rcrmonthrepetition;
    }

     
    public function setRcrmonthrepetition($rcrmonthrepetition): Recurrence
    {
        $this->rcrmonthrepetition = filter_var($rcrmonthrepetition, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRcrmonthofyearnumber(): int
    {
        return $this->rcrmonthofyearnumber;
    }

     
    public function setRcrmonthofyearnumber($rcrmonthofyearnumber): Recurrence
    {
        $this->rcrmonthofyearnumber = filter_var($rcrmonthofyearnumber, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRcryearrepetition(): int
    {
        return $this->rcryearrepetition;
    }

     
    public function setRcryearrepetition($rcryearrepetition): Recurrence
    {
        $this->rcryearrepetition = filter_var($rcryearrepetition, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

     
    public function getRcrenddate()
    {
        return $this->rcrenddate;
    }

     
    public function setRcrenddate($rcrenddate): Recurrence
    {
        $this->rcrenddate = $rcrenddate;
        return $this;
    }

     
    public function getRcrcount(): int
    {
        return $this->rcrcount;
    }

     
    public function setRcrcount($rcrcount): Recurrence
    {
        $this->rcrcount = filter_var($rcrcount, FILTER_VALIDATE_INT, ['options' => ['default' => 0]]);
        return $this;
    }

    protected function afterLoad(): void
    {
             }


     
    public static function getControlInterface(): string
    {
        return '';
    }

     
    public static function getLoadingFunction(): string
    {
        return '';
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }
}