<?php

namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use Sabre\VObject\Property;
use server\inc\gw\Search;
use SimpleXMLElement;
use tools\ParamLineParser;
use tools\VCalendar;
use tools\VNote;

 
class Note extends AGwEventItem implements IHasAttachments
{
    use THasAttachments, THasThumbnail, TEvnGwSearch;

     
    protected $evntitle;
    protected $evntype;
    protected $evnsharetype;
    protected $evndescformat;
    protected $ctz;

    public static $searchFields = [
        'EvnTitle',
        'EvnNote'
    ];

    CONST TYPE = 'N';
     
    protected $note;

     
    public static function createFromXML(\Folder $folder, string $xml, bool $save = false, AGwEventItem $parent = null) : Note
    {
         
        $note = parent::createFromXML($folder, $xml, $save, $parent);
        $simpleXml = $note->getSourceSimpleXML();
        $note->setNote($simpleXml->notes->note->values->note_text ?? null);
        return $note;
    }

    public static function fillValues(AGwEventItem $item, SimpleXMLElement $simpleXMLElement = null)
    {
        $result = parent::fillValues($item, $simpleXMLElement);
        $item->setNote($simpleXMLElement->notes->note->values->note_text ?? null);
        return $result;
    }

     
    public function getICalendar() : string
    {
        $vNote = new VNote();
        if(!empty($this->getEvntype())) $vNote->add('CATEGORIES', $this->getEvntype());
        $vNote->add('DESCRIPTION', strip_tags(html_entity_decode($this->getNote())));
        $vNote->add('X-ALT-DESC', $this->getNote(), ['FMTTYPE' => 'text/html']);
        $vNote->add('SUMMARY', $this->getEvntitle());
        if(!empty($this->getId())){
            $vNote->add('UID', $this->getId());
            $vNote->add('X-SERVER-UID', $this->getId());
        }
        $vNote->add('CLASS', ($this->getEvnsharetype() == 'P' ? 'PRIVATE' : 'PUBLIC'));
        $vNote->add('CREATED', $this->getEvnCreated());
        if($this->getEvnModified() instanceof \DateTime) $vNote->add('LAST-MODIFIED', $this->getEvnModified());
        if($this->getEvndeleted() instanceof \DateTime) $vNote->add('DELETED', $this->getEvndeleted());
         
        return $this->serialize($vNote);
    }

    public function fillFromArray(array $array, $loadAllAddons = false, array $loadAddons = [],bool $markVariablesSet = false)
    {
        parent::fillFromArray($array);
        $data = $this->getGwApi()->FunctionCall('getEventNoteText', $this->getFolderSessionId(), $this->getId());
        $this->setNote($data);
             }

    public function fillFromVObject(Node $vObject)
    {
        parent::fillFromVObject($vObject);
        $this->setEvntitle($vObject->SUMMARY ?? null);
        $this->setEvntype($vObject->CATEGORIES ?? null);
        $this->setEvnsharetype((string)$vObject->CLASS == 'PRIVATE' ? 'P' : 'U');
        if(isset($vObject->{'X-ALT-DESC'})){
            $this->setNote($vObject->{'X-ALT-DESC'});
            $this->setEvndescformat((string)$vObject->{'X-ALT-DESC'}['FMTTYPE']);
        }else{
            $this->setNote($vObject->{'DESCRIPTION'});
        }
    }

     
    public function save() : AGwEventItem
    {
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $folderSessionId = $this->getFolder()->openAccess();
                 if($this->prepareParamLine('use_tzid=1') && (!$sEvnId = $gwApi->FunctionCall('AddEventInfo', $folderSessionId, $this->getParamLine(), ""))){
            $lastError = $gwApi->FunctionCall("GetLastError",$this->getFolder()->account->sGWSessionID);
            if($lastError != 13) throw new \Exc('item_create',$sEvnId);
            throw new \Exc('item_duplicity',$this->getEvntitle());
        }
        $this->setId($sEvnId);
        $this->setEvnCreated();
        $gwApi->FunctionCall('SetEventNoteText', $folderSessionId, $this->getId(), $this->getNote());
        $this->setAttWebdavLink(\User::addTokenToTicket($gwApi->FunctionCall('GetAttachmentPathLocal', $folderSessionId, $this->getId(), '', 'TICKET')));
        return $this;
    }

    public function afterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartDate > %s', $this->strToDelphiDate($value));
    }

    public function aftertimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartTime > %s', $this->strToTime($value));
    }

    public function beforetimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartTime < %s', $this->strToTimeBefore($value));
    }

    public function beforeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartDate < %s', $this->strToDelphiDateBefore($value));
    }

    public function fulltextCondition(Search $search, $value) : string
    {
        $conditions = [];
        $count = 0;
        foreach(self::$searchFields as $field){
            $conditions[] = "(" . $search->addTableName($field) . " IS NOT NULL AND " . $search->addTableName($field) . " LIKE '%%%s%%' {ESCAPE '\\'})";
            $count++;
        }
        $condition = join(' OR ',$conditions);
        $condition .= ' OR {FULLTEXT}%s{/FULLTEXT}';
        $condition .= ' OR {ITEMATTR}LIKE \'%%%s%%\'{/ITEMATTR}';
        $condition = '('.$condition.')';
        $count += 2;
        return $this->placeValueToCondition($condition, $value, $count);
    }

    public function noteCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('{ITEMATTR}LIKE \'%%%s%%\'{/ITEMATTR}', $value);
    }

    public function descriptionCondition(Search $search, $value) : string
    {
        return $this->noteCondition($search, $value);
    }

    public function getType(): string
    {
        return self::TYPE;
    }

     
    public function getEvntitle()
    {
        return $this->evntitle;
    }

     
    public function setEvntitle($evntitle): Note
    {
        $this->evntitle = (string)$evntitle;
        return $this;
    }

     
    public function getEvntype()
    {
        return $this->evntype;
    }

     
    public function setEvntype($evntype): Note
    {
        $this->evntype = $evntype;
        return $this;
    }

     
    public function getEvnsharetype()
    {
        return $this->evnsharetype;
    }

     
    public function setEvnsharetype($evnsharetype): Note
    {
        $this->evnsharetype = $evnsharetype;
        return $this;
    }

     
    public function getEvndescformat()
    {
        return $this->evndescformat;
    }

     
    public function setEvndescformat($evndescformat): Note
    {
        $this->evndescformat = $evndescformat;
        return $this;
    }

     
    public function getCtz()
    {
        return $this->ctz;
    }

     
    public function setCtz($ctz): Note
    {
        $this->ctz = $ctz;
        return $this;
    }

     
    public function getNote()
    {
        return $this->note;
    }

     
    public function setNote(? string $note): Note
    {
        if(!empty($note)) {
            $this->replaceCID($note);
            $this->note = $note;
        }
        return $this;
    }

    protected function afterLoad(): void
    {
             }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }

    public static function getCountByFilter(\Folder $folder, $filter)
    {
             }
}
