<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;
use server\inc\gw\Search;

class Location extends AGwEventItem implements ISubItem
{
    protected $lctstreet;
    protected $lctcity;
    protected $lctstate;
    protected $lctzip;
    protected $lctcountry;
    protected $lctwebpage;
    protected $lctemail1;
    protected $lctemail2;
    protected $lctemail3;
    protected $lctim;
    protected $lctphnwork1;
    protected $lctphnhome1;
    protected $lctphnfaxwork ;
    protected $lcttype;

    public function getICalendar(): string{ return ''; }

     
    public function getType(): string
    {
        return '';
    }

     
    public function addToICalendar(Component $vComponent): void
    {
        if(!empty($this->getLctwebpage())) $vComponent->add('URL', $this->getLctwebpage());
        if(!empty($this->getLctim())) $vComponent->add('IMPP', $this->getLctim(), ['TYPE' => 'PERSONAL']);
        if(!empty($this->getLctemail1())) $vComponent->add('EMAIL', $this->getLctemail1(), ['TYPE' => 'INTERNET', 'PREF' => 1]);
        if(!empty($this->getLctemail2())) $vComponent->add('EMAIL', $this->getLctemail2(), ['TYPE' => 'INTERNET']);
        if(!empty($this->getLctemail3())) $vComponent->add('EMAIL', $this->getLctemail3(), ['TYPE' => 'INTERNET']);
        if(!empty($this->getLctphnwork1())) $vComponent->add('TEL', $this->getLctphnwork1(), ['TYPE' => 'PREF,WORK,VOICE']);
        if(!empty($this->getLctphnhome1())) $vComponent->add('TEL', $this->getLctphnhome1(), ['TYPE' => 'PREF,HOME,VOICE']);

        $adress = ['', '', $this->getLctstreet(), $this->getLctcity(), $this->getLctstate(), $this->getLctzip(), $this->getLctcountry()];
        if(array_filter($adress)){
            $adr = $vComponent->add('ADR', $adress);
            if($this->getLcttype() != 'O'){
                $adr['TYPE'] = ($this->getLcttype() == 'H') ? 'HOME':'WORK';
            }
        }
    }

     
    public function fillFromVObject(Node $vObject)
    {
         
        if($vObject->name == 'URL'){
            $this->setLctwebpage((string)$vObject);
        }elseif($vObject->name == 'ADR'){
            list(,, $this->lctstreet, $this->lctcity, $this->lctstate, $this->lctzip, $this->lctcountry) = explode(';', (string)$vObject);
        }elseif($vObject->name == 'IMPP'){
            $this->setLctim((string)$vObject);
        }elseif($vObject->name == 'IMPP'){
            $this->setLctim((string)$vObject);
        }

             }

     
    public function getLctstreet()
    {
        return $this->lctstreet;
    }

     
    public function setLctstreet($lctstreet): Location
    {
        $this->lctstreet = $lctstreet;
        return $this;
    }

     
    public function getLctcity()
    {
        return $this->lctcity;
    }

     
    public function setLctcity($lctcity): Location
    {
        $this->lctcity = $lctcity;
        return $this;
    }

     
    public function getLctstate()
    {
        return $this->lctstate;
    }

     
    public function setLctstate($lctstate): Location
    {
        $this->lctstate = $lctstate;
        return $this;
    }

     
    public function getLctzip()
    {
        return $this->lctzip;
    }

     
    public function setLctzip($lctzip): Location
    {
        $this->lctzip = $lctzip;
        return $this;
    }

     
    public function getLctcountry()
    {
        return $this->lctcountry;
    }

     
    public function setLctcountry($lctcountry): Location
    {
        $this->lctcountry = $lctcountry;
        return $this;
    }

     
    public function getLctwebpage()
    {
        return $this->lctwebpage;
    }

     
    public function setLctwebpage($lctwebpage): Location
    {
        $this->lctwebpage = $lctwebpage;
        return $this;
    }

     
    public function getLctemail1()
    {
        return $this->lctemail1;
    }

     
    public function setLctemail1($lctemail1): Location
    {
        $this->lctemail1 = $lctemail1;
        return $this;
    }

     
    public function getLctemail2()
    {
        return $this->lctemail2;
    }

     
    public function setLctemail2($lctemail2): Location
    {
        $this->lctemail2 = $lctemail2;
        return $this;
    }

     
    public function getLctemail3()
    {
        return $this->lctemail3;
    }

     
    public function setLctemail3($lctemail3): Location
    {
        $this->lctemail3 = $lctemail3;
        return $this;
    }

     
    public function getLctim()
    {
        return $this->lctim;
    }

     
    public function setLctim($lctim): Location
    {
        $this->lctim = $lctim;
        return $this;
    }

     
    public function getLctphnwork1()
    {
        return $this->lctphnwork1;
    }

     
    public function setLctphnwork1($lctphnwork1): Location
    {
        $this->lctphnwork1 = $lctphnwork1;
        return $this;
    }

     
    public function getLctphnhome1()
    {
        return $this->lctphnhome1;
    }

     
    public function setLctphnhome1($lctphnhome1): Location
    {
        $this->lctphnhome1 = $lctphnhome1;
        return $this;
    }

     
    public function getLctphnfaxwork()
    {
        return $this->lctphnfaxwork;
    }

     
    public function setLctphnfaxwork($lctphnfaxwork): Location
    {
        $this->lctphnfaxwork = $lctphnfaxwork;
        return $this;
    }

     
    public function getLcttype()
    {
        return $this->lcttype;
    }

     
    public function setLcttype($lcttype): Location
    {
        $this->lcttype = $lcttype;
        return $this;
    }

    protected function afterLoad(): void
    {
             }


     
    public static function getControlInterface(): string
    {
        return '';
    }

     
    public static function getLoadingFunction(): string
    {
        return '';
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }
}