<?php

namespace server\model;

use Sabre\VObject\Component;
use server\inc\gw\Search;

 
class ItemAttribute extends AGwEventItem implements ISubItem
{
    protected $atrType;
    protected $atrValue;

    CONST TYPE = '';

    public function save(): AGwEventItem
    {
        return $this->saveOld();
    }

    public function saveOld()
    {
        $this->setEvnCreated();
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $folderSessionId = $this->getFolder()->openAccess();
                 if($this->prepareParamLine() && (!$sEvnId = $gwApi->FunctionCall('addItemAttribute', $folderSessionId, $this->getParent()->getId(), $this->getAtrValue(), $this->getParamLine(), $this->getId()))){
            throw new \Exc('item_create',$sEvnId);
        }
        $this->setId($sEvnId);
        $this->backupState();
        return $this;
    }

    public function getICalendar(): string { return ''; }

    public function getType(): string
    {
        return self::TYPE;
    }

    protected function afterLoad(): void {}

    public function addToICalendar(Component $vComponent): void {}

     
    public function getAtrType()
    {
        return $this->atrType;
    }

     
    public function setAtrType($atrType): ItemAttribute
    {
        $this->atrType = $atrType;
        return $this;
    }

     
    public function getAtrValue()
    {
        return $this->atrValue;
    }

     
    public function setAtrValue($atrValue): ItemAttribute
    {
        $this->atrValue = $atrValue;
        return $this;
    }

    public static function getControlInterface(): string
    {
        return IHasItemAttributes::class;
    }

    public static function getLoadingFunction(): string
    {
        return 'addItemAttributesFromGW';
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }
}