<?php

namespace server\model;

use server\inc\gw\Search;

class GroupWareTrash extends AGwEventItem
{
    use TCommonGwSearch;

    CONST TYPE = 'G';

    public static $searchFields = [
        'ItmTitle',
        'ItmDescription',
        'ItmOriginalFolder',
    ];

    public function getICalendar(): string
    {
        return '';
    }

    public function getType(): string
    {
        return self::TYPE;
    }

    protected function afterLoad(): void {}

    public function creationdateCondition(Search $search, $value) : string
    {
        $dateTime = \DateTime::createFromFormat('Y-m-d', $value);
        $dateTime->setTime(0,0);
        $value = [$dateTime->getTimestamp()];
        $dateTime->setTime(23,59,59);
        $value[] = $dateTime->getTimestamp();
        return $this->placeValueToCondition('(Itm_Created > %s AND Itm_Created < %s)', $value);
    }

    public function classCondition(Search $search, $value) : string
    {
        if(!preg_match_all('/[^,\\s]+/', $value, $matches)) return '';
        $in = array_fill(0, count($matches[0]), "'%s'");
        return $this->placeValueToCondition("(ItmClass IN (" . implode(',', $in) . "))", $matches[0]);
    }

    public function itemsCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ITM_ID = '%s' )", $value);
    }

    public function inCondition(Search $search, $value) : string
    {
        if(trim(strtolower($value)) == 'anywhere') return '1 = 1';
        if(!$account = $this->getFolder()->account) return '0 = 1';
        return $this->placeValueToCondition("(ItmFolder = '%s' )", $value);
    }

    public function ridCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmRID = '%s')", $value);
    }

    public function isCondition(Search $search, $value) : string
    {
        if($value == 'read') return $search->addTableName('unread') . ' = 0';
        if($value == 'unread') return $search->addTableName('unread') . ' = 1';
        if($value == 'flagged') return $search->addTableName('color') . " <> 'Z'";
        if($value == 'private') return "(ItmShareType ='P' OR ItmShareType ='C')";
        if($value == 'public') return "(ItmShareType <> 'P' AND ItmShareType <> 'C')";
        return '';
    }

    public function noteCondition(Search $search, $value) : string
    {
        return $this->descriptionCondition($search, $value);
    }

    public function descriptionCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmDescription IS NOT NULL AND ItmDescription LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function titleCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmTitle IS NOT NULL AND ItmTitle LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function categoryCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmCategory IS NOT NULL AND ItmCategory LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    
    public function itmclassCondition(Search $search, $value): string
    {
        return $this->classCondition($search, $value);
    }
     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }
}