<?php

namespace server\model;

use Sabre\VObject\Component;
use server\inc\gw\Search;

class EventReaction extends AGwEventItem implements ISubItem
{
    protected $reaownId;
    protected $reavalue;
    protected $reaownemail;
    protected $reaownname;

    CONST TYPE = '';

    protected static $renameVariablesExportGW = [
        'reavalue' => 'reaction'
    ];

    protected static $skipVariablesExportGW = [
        'reaownId',
        'reaownemail',
        'reaownname',
        '_tzid',
    ];

     
    public static function createFromXML(\Folder $folder, string $xml, bool $save = false, AGwEventItem $parent = null)
    {
        $item = new EventReaction($folder);
        if($parent instanceof AGwEventItem) $item->setParent($parent);
        $item->setReavalue((string)simplexml_load_string($xml)->values->reaction);
        $item->setReaownemail($_SESSION['EMAIL']);
        $item->setReaownId($parent->getId());
        $item->setReaownname($_SESSION['USERNAME']);
        if($save) $item->save();
        return $item;
    }

    public function save(): AGwEventItem
    {
        return $this->saveOld();
    }

    public function saveOld()
    {
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $folderSessionId = $this->getFolder()->openAccess();
                 if($this->prepareParamLine('','',true, ['reaction']) && (!$sEvnId = $gwApi->FunctionCall('addEventReaction', $folderSessionId, $this->getParent()->getId(), $this->getParamLine()))){
            throw new \Exc('item_create',$sEvnId);
        }
        $this->backupState();
        return $this;
    }

    public function getICalendar(): string { return ''; }

    public function getType(): string
    {
        return self::TYPE;
    }

    protected function afterLoad(): void {}

    public function addToICalendar(Component $vComponent): void {}

    public static function getControlInterface(): string
    {
        return IHasEventReactions::class;
    }

    public static function getLoadingFunction(): string
    {
        return 'addEventReactionsFromGW';
    }

     
    public function getReaownId()
    {
        return $this->reaownId;
    }

     
    public function setReaownId($reaownId): void
    {
        $this->reaownId = $reaownId;
    }

     
    public function getReavalue()
    {
        return $this->reavalue;
    }

     
    public function setReavalue($reavalue): void
    {
        $this->reavalue = $reavalue;
    }

     
    public function getReaownemail()
    {
        return $this->reaownemail;
    }

     
    public function setReaownemail($reaownemail): void
    {
        $this->reaownemail = $reaownemail;
    }

     
    public function getReaownname()
    {
        return $this->reaownname;
    }

     
    public function setReaownname($reaownname): void
    {
        $this->reaownname = $reaownname;
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }
}