<?php

 namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Component;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use Sabre\VObject\Reader;
use server\inc\gw\Search;
use tools\VCalendar;

 
class Event extends AGwEventItem implements IHasAttachments, IHasReminders, IHasRecurrences, IHasAttendees, IHasOccurrences, ICommonGwSearch
{
    use THasAttachments, THasReminders, THasRecurrences, THasAttendees, THasOccurrences, TEvnGwSearch;

    CONST TYPE = 'E';

    public $duplicity;
    protected $evntitle;
    protected $meetingAction;
    protected $meetingPassword;
    protected $evnlocation;
    protected $evntype;
    protected $evnsharetype;
    protected $evndescformat;
    protected $evnnote;
    protected $evnflags;
    protected $evntimeformat;
    protected $_tzevnstartdate;
    protected $_tzevnenddate;
    protected $_tzevnstarttime;
    protected $_tzevnendtime;
    protected $ctz;
    protected $evnOrganizer;
    protected $evnstartdate;
    protected $evnenddate;
    protected $evnstarttime;
    protected $evnendtime;
    protected $evnmeetingid;
    protected $meetingUrl;
    protected $meetingAutoRecording;
    protected $meetingAutoLobby;
    protected $priority;
    protected $sequence;
    protected $transp;
    protected $flagAttendee;
    protected $flagFree;
    protected $flagTentative;
    protected $flagOoo;
    protected $flagUnresponded;
    protected $flagNoReminder;
    protected $flagLobby;
    protected $evnfolder;

     
    private static $lengthVariablesExport = [
        'evnmeetingid' => 255,
        'evnlocation' => 510,
        'evntitle' => 510,
    ];

     
    public static $searchFields = [
        'EvnTitle',
        'EvnNote',
    ];

     
    public static $skipVariablesExportFE = [
        '_tzid'
    ];

    public static $skipVariablesExportGW = [
        'evnfolder'
    ];

    public static $availableFlags = [
        'BUSY' => \GroupWareItem::FLAG_ORGANIZATOR,
        'FREE' => \GroupWareItem::FLAG_TRANSPARENT,
        'TENTATIVE' => \GroupWareItem::FLAG_TENTATIVE,
        'OOF' => \GroupWareItem::FLAG_OUTOFOFFICE,
    ];

    public static $disableUpdate = [
        'evnOrganizer',
        'evntimeformat',
        'evndescformat',
        'ctz',
        '_tzid',
    ];

     
    public function loadById(string $id) : bool
    {
        $this->loadByVObject($id);
        $this->afterLoad();
        return true;
    }

     
    public function delete()
    {
        if(empty($this->getId())) return;
        return $this->getGwApi()->FunctionCall('ProcessVCalendar', $this->getFolderSessionId(), $this->getId() ?? '', '', 'rfc6638=&action=DELETE');
    }

    public static function getCountByFilter(\Folder $folder, $filter)
    {
         
        $gwApi = $folder->account->gwAPI;
        $sessionId = $folder->openAccess();
        if (isset($filter['interval']) && $filter['interval']) return false;
        return $gwApi->FunctionCall('GetEventCount', $sessionId, $filter['sql']);
    }

    public static function getByFilter(\Folder $folder, &$filter): array
    {
         
        $gwApi = $folder->account->gwAPI;
        $sessionId = $folder->openAccess();
        self::handleIdIntervalFilter($filter);
        if(($filter['meeting'] ?? false) && strpos($filter['sql'] ?? '', 'EvnMeetingId IS NOT NULL AND EvnMeetingId <>') === false){
            if(!empty($filter['sql'] ?? null)) $filter['sql'] = '('.$filter['sql'].') AND ';
            $filter['sql'] = ($filter['sql'] ?? '') . '(EvnMeetingId IS NOT NULL AND EvnMeetingId <> \'\')';
        }
        if (isset($filter['interval']) && $filter['interval']) {
            $filter['interval'] .= ';;;;use_tzid=1&freebusy=1&returnowneremail=1';
            $result = $gwApi->FunctionCall('GetIntervalEvents', $sessionId, $filter['interval'], $filter['sql'], 'evntitle,evnlocation,evnstartdate,evnstarttime,evnenddate,evnendtime,evnown_id,evnrcr_id,evngrp_id,rmnevn_id,evntype,evnclass,evnfolder,evnflags,evnmeetingid,evnsharetype', '');
        } else {
            $attributes = $gwApi->filterToAttributes($filter);
            $result = $gwApi->FunctionCall('GetEventList', $sessionId, $filter['sql'], 'evntitle,evnlocation,evnstartdate,evnstarttime,evnenddate,evnendtime,evnown_id,evnrcr_id,evngrp_id,rmnevn_id,evntype,evnclass,evnfolder,evnflags,evnmeetingid,evnsharetype', $attributes);
        }
        $items = [];
        $parser = new \tools\ParamLineParser($result);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $item = new Event($folder);
            $item->fillFromArray($parsedParamLine, false);
            $item->setFilterTag($filter);
            $items[] = $item;
        }

        self::useLimitAndOffset($items, $filter);

        return $items;
    }

    protected static function useLimitAndOffset(array & $events, array & $filter)
    {
        if(($filter['idinterval'] ?? false) && preg_match('/^(?P<direction>(?:FUTURE)|(?:PAST))\+?(?P<id>.*)$/i', $filter['idinterval'], $matches)){
            $idArray = array_map(function($e) { return $e->getId(); }, $events);
            $index = array_search($matches['id'], $idArray);
            $idFilterIntervalDirection = $matches['direction'];
            if($index !== false){
                if(strcasecmp($idFilterIntervalDirection, 'FUTURE') === 0){
                    $filter['offset'] = $index + 1;
                }else{
                    $filter['offset'] = $index;
                }
            }
        }
        if(isset($filter['orderby'], $filter['interval']) && !empty($filter['orderby']) && !empty($filter['interval'])){
            if(preg_match_all('/(?P<key>[^\s,]+)\s(?P<direction>(?:asc)|(?:desc))/i', strtoupper($filter['orderby']), $matches, PREG_SET_ORDER)){
                static::arrayOrderBy($events, $matches);
            }
        }

        if(!empty($filter['limit'] ?? null) && is_numeric($filter['limit']) && $filter['limit'] < ($eventsCount = count($events))) {
            $limit = $filter['limit'];
            $offset = intval($filter['offset'] ?? 0);
            if(($offset+$limit) > $eventsCount){
                $limit = $eventsCount - $offset;
            }
            if($limit < 0) $limit = 0;
            $events = array_slice($events, $offset, $limit);
        }
    }

    protected static function handleIdIntervalFilter(array & $filter)
    {
        if(!($filter['idinterval'] ?? false) || !preg_match('/^(?P<direction>(?:FUTURE)|(?:PAST))\+?(?P<id>.*)$/i', $filter['idinterval'], $matches)) return;
        $dateTime = new \DateTime();
        $idFilterInterval = $matches['id'];
        if(!empty($idFilterInterval)){
            try{
                $filterIntervalItem = new Event($filter['searchObject']->getFolder(), $idFilterInterval);
                if($filterIntervalItem instanceof Event){
                    $dateTime->setTimestamp(\slToolsDate::calendar2unix($filterIntervalItem->getEvnstartdate(), $filterIntervalItem->getEvnstarttime()));
                }
            }catch (\Exception $e){}
        }
        $interval = \slToolsDate::unix2calendardate($dateTime->getTimestamp());
        if(strcasecmp($matches['direction'],'FUTURE') === 0){
            $dateTime->modify('+3 month');
            $interval .= '-' . \slToolsDate::unix2calendardate($dateTime->getTimestamp());
        }else{
            $dateTime->modify('-3 month');
            $interval = \slToolsDate::unix2calendardate($dateTime->getTimestamp()) . '-' . $interval;
        }
        $filter['interval'] = $interval;
    }

     
    public function getICalendar(): string
    {
        $vCalendar = new VCalendar();
         
        $vEvent = $vCalendar->add('VEVENT');
        $vEvent->remove('UID');
        $vEvent->remove('DTSTAMP');
        if(!empty($this->getId())){
            $vEvent->add('UID', $this->getId());
            $vEvent->add('X-SERVER-UID', $this->getId());
        }else{
            unset($vEvent->UID);
        }
        if(!empty($this->getEvntype())) $vEvent->add('CATEGORIES', $this->getEvntype());
        $vEvent->add('DESCRIPTION', strip_tags(html_entity_decode($this->getEvnnote())));

        $vEvent->add('X-ALT-DESC', \slToolsString::basicSanitizeHTML($this->getEvnnote()), ['FMTTYPE' => 'text/html']);
        if(!empty($this->getEvnlocation())) $vEvent->add('LOCATION', $this->getEvnlocation());
        if(!empty($this->getEvnmeetingid())){
            $vEvent->add('X-ICEWARP-MEETING', $this->getEvnmeetingid());
        }elseif(strtolower($this->getMeetingAction()) == 'create'){
            $vEvent->add('X-ICEWARP-MEETING', '1');
        }
        $vEvent->add('X-ICEWARP-AUTO-MEETING-RECORDING', $this->getMeetingAutoRecording() ? 1 : 0);
        $vEvent->add('X-ICEWARP-AUTO-MEETING-LOBBY', $this->getMeetingAutoLobby() ? 1 : 0);
        if(!empty($this->getMeetingUrl())) $vEvent->add('X-ICEWARP-MEETING-URL', $this->getMeetingUrl());
        if(!empty($this->getMeetingPassword())) $vEvent->add('X-ICEWARP-MEETING-PASSWORD', $this->getMeetingPassword());
        $vEvent->add('SUMMARY', $this->getEvntitle());
        $vEvent->add('PRIORITY', $this->getPriority() ?? 0);
        if(!empty($this->getTransp())) $vEvent->add('TRANSP', $this->getTransp());
        $vEvent->add('CLASS', ($this->getEvnsharetype() == 'P' ? 'PRIVATE' : 'PUBLIC'));
        $vEvent->add('CREATED', $this->getEvnCreated());
        if($this->getEvnModified() instanceof \DateTime) $vEvent->add('LAST-MODIFIED', $this->getEvnModified());
        if($this->getEvndeleted() instanceof \DateTime) $vEvent->add('DELETED', $this->getEvndeleted());
        $vEvent->add('DTSTART', $this->getCalendarToDateTime($this->getTzevnstartdate() ?? $this->getEvnstartdate(), $this->getTzevnstarttime() ?? $this->getEvnstarttime()));
                 $vEvent->add('DTEND', $this->getCalendarToDateTime($this->getTzevnenddate() ?? $this->getEvnenddate(), $this->getTzevnendtime() ?? $this->getEvnendtime()));
        if(!empty($this->getTzid())){
            $vEvent->DTSTART['TZID'] = $this->getTzid();
            $vEvent->DTEND['TZID'] = $this->getTzid();
        }
        $organizer = $vEvent->add('ORGANIZER', $this->getEvnOrganizer() ?? $_SESSION['EMAIL']);
        $organizer['CN'] = $_SESSION['FULLNAME'];
        if($this->getEvnflags() == \GroupWareItem::FLAG_ORGANIZATOR){
            $vEvent->add('X-MICROSOFT-CDO-BUSYSTATUS', 'BUSY');
        }elseif($this->getEvnflags() == \GroupWareItem::FLAG_TRANSPARENT){
            $vEvent->add('X-MICROSOFT-CDO-BUSYSTATUS', 'FREE');
        }elseif($this->getEvnflags() == \GroupWareItem::FLAG_TENTATIVE){
            $vEvent->add('X-MICROSOFT-CDO-BUSYSTATUS', 'TENTATIVE');
        }elseif($this->getEvnflags() == \GroupWareItem::FLAG_OUTOFOFFICE){
            $vEvent->add('X-MICROSOFT-CDO-BUSYSTATUS', 'OOF');
        }else{
            $vEvent->add('X-MICROSOFT-CDO-BUSYSTATUS', 'BUSY');
        }
                 return $this->serialize($vCalendar, $vEvent);
    }

     
    protected function beforeSave() : bool
    {
        $this->setEvnCreated();
        return true;
    }

     
    public static function createFromXML(\Folder $folder, string $xml, bool $save = false, AGwEventItem $parent = null)
    {
        if($folder->type == 'I') return TeamChat::createFromXML($folder, $xml, $save, $parent);
        $item = parent::createFromXML($folder, $xml, $save, $parent);
        $item->setDuplicity($item->getSourceSimpleXML()['duplicity']);
                 if(count($item->getAsArray()) <= 10){
            $item->editChildren = false;
        }
        return $item;
    }

    public function getType(): string
    {
        return self::TYPE;
    }

    public function loadByVObject(string $id)
    {
        $result = $this->getGwApi()->FunctionCall('GetVCalendar', $this->getFolderSessionId(), $id);
        $error = $this->getGwApi()->FunctionCall("GetLastError", $this->getFolderSessionId());
        $vCalendar = Reader::read($result);
        $this->setId($id);
        $this->fillFromVObject($vCalendar);
    }

     
    public function fillFromVObject(Node $vObject)
    {
        $master = $vObject instanceof \Sabre\VObject\Component\VCalendar ? $vObject->VEVENT : $vObject;
        if($this instanceof IHasOccurrences) $this::addOccurrencesFromVObject($this, $vObject);

        parent::fillFromVObject($master);
        if(empty($this->getId())) $this->setId((string)$master->{'X-SERVER-UID'} ?? null);
        $this->setEvntitle((string)$master->SUMMARY ?? null);

        $this->setMeetingUrl((string)$master->{'X-ICEWARP-MEETING-URL'} ?? null);
        $this->setMeetingAutoRecording('1' == ((string)$master->{'X-ICEWARP-AUTO-MEETING-RECORDING'} ?? null));
        $this->setMeetingAutoLobby('1' == ((string)$master->{'X-ICEWARP-AUTO-MEETING-LOBBY'} ?? null));
        $this->setMeetingAction((string)$master->{'X-ICEWARP-MEETING'} ?? null);
        $this->setMeetingPassword((string)$master->{'X-ICEWARP-MEETING-PASSWORD'} ?? null);
        $this->setEvntype((string)$master->CATEGORIES ?? null);
        $this->setEvnsharetype((string)$master->CLASS == 'PRIVATE' ? 'P' : 'U');
        if(isset($master->{'X-ALT-DESC'})){
            $this->setEvnnote((string)$master->{'X-ALT-DESC'});
        }elseif(isset($master->{'DESCRIPTION'})){
            $this->setEvnnote((string)$master->{'DESCRIPTION'});
        }
        $this->setEvnlocation((string)$master->LOCATION ?? null);
        $this->setPriority((string)$master->PRIORITY ?? null);
        $this->setTransp((string)$master->TRANSP ?? null);
        $this->setSequence((string)$master->SEQUENCE ?? null);
        $this->setEvnOrganizer(str_replace('mailto:', '', (string)$master->ORGANIZER ?? ''));
        $this->setEvnflags(self::$availableFlags[(string)$master->{'X-MICROSOFT-CDO-BUSYSTATUS'} ?? 'BUSY'] ?? \GroupWareItem::FLAG_ORGANIZATOR);
        $this->setTransp((string)$master->TRANSP ?? null);
        $this->setEvnstartdate($this->getDateTimeToCalendarDate($master->{'DTSTART'}->getDateTime()));
        $this->setEvnstarttime($this->getDateTimeToCalendarTime($master->{'DTSTART'}->getDateTime()));
        $this->setEvnenddate($this->getDateTimeToCalendarDate($master->{'DTEND'}->getDateTime()));
        $this->setEvnendtime($this->getDateTimeToCalendarTime($master->{'DTEND'}->getDateTime()));
        $this->setTzid((string)$vObject->{'DTSTART'}['TZID'] ?? null);
                               }

    protected function afterLoad(): void
    {
        if($this->getEvnstarttime() == 0 && $this->getEvnendtime() == 0 && ($this->getEvnenddate() - $this->getEvnstartdate()) === 1){
            $this->setEvnstarttime(-1);
            $this->setEvnendtime(-1);
        }
    }

     
    public function getTemplateDataArray(array $allowEmpty = []) : array
    {
        $result = $this->getAsArrayFE(false, true, $allowEmpty);
        $result['id'] = \slToolsPHP::htmlspecialchars($this->getId());
        $result['sFields'] = '<values>' . $this->xml . '</values>';
        $this->addAttachmentsTemplateDataArray($result);
        $this->addAttendeesTemplateDataArray($result);
        $this->addRemindersTemplateDataArray($result);
        $this->addRecurrencesTemplateDataArray($result);
        return $result;
    }

         public function afterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartDate > %s', $this->strToDelphiDate($value));
    }

    public function aftertimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartTime > %s', $this->strToTime($value));
    }

    public function beforetimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartTime < %s', $this->strToTimeBefore($value));
    }

    public function beforeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnStartDate < %s', $this->strToDelphiDateBefore($value));
    }

    public function hasCondition(Search $search, $value) : string
    {
        if($value == 'conference') return "(EvnMeetingID IS NOT NULL AND EvnMeetingID <> '')";
        return '';
    }

    public function conferenceCondition(Search $search, $value) : string
    {
        $accountID = $this->folder->account->accountID;
        if($value == 'organizer') return $this->placeValueToCondition("((EvnMeetingID IS NOT NULL AND EvnMeetingID <> '') AND (EvnOrganizer LIKE '%%%s%%' {ESCAPE '\\'}))", $accountID);
        if($value == 'attendee') return $this->placeValueToCondition("((EvnMeetingID IS NOT NULL AND EvnMeetingID <> '') AND NOT (EvnOrganizer IS NOT NULL AND EvnOrganizer LIKE '%%%s%%' {ESCAPE '\\'}))", $accountID);
        return '';
    }

    public function afterendCondition(Search $search, $value) : string
    {
        $filter = & $search->filter;
        if($filter) $filter['idinterval'] = 'FUTURE';
        return '';
    }

    public function beforeendCondition(Search $search, $value) : string
    {
        $filter = & $search->filter;
        if($filter) $filter['idinterval'] = 'PAST';
        return '';
    }

    public function afteridCondition(Search $search, $value) : string
    {
        $filter = & $search->filter;
        if(preg_match('/(?:afterend|beforeend)/i', $search->searchCondition)){
            $filter['idinterval'] = ($filter['idinterval'] ?? '') . '+' . $value;
            return '';
        }
        return $this->placeValueToCondition("(Evn_ID > '%s')", $value);
    }

    public function beforeidCondition(Search $search, $value) : string
    {
        $filter = & $search->filter;
        if(preg_match('/(?:afterend|beforeend)/i', $search->searchCondition)){
            $filter['idinterval'] = ($filter['idinterval'] ?? '') . '+' . $value;
        }else {
            return $this->placeValueToCondition("(Evn_ID < '%s')", $value);
        }
        return '';
    }

     
     
    public function getEvnOrganizer()
    {
        return $this->evnOrganizer;
    }

     
    public function setEvnOrganizer($evnOrganizer): Event
    {
        $this->evnOrganizer = $evnOrganizer;
        return $this;
    }

     
    public function getDuplicity()
    {
        return $this->duplicity;
    }

     
    public function setDuplicity($duplicity): Event
    {
        $this->duplicity = $duplicity;
        return $this;
    }

     
    public function getEvntitle()
    {
        return $this->evntitle;
    }

     
    public function setEvntitle($evntitle): Event
    {
        $this->evntitle = (string)$evntitle;
        return $this;
    }

     
    public function getMeetingAction()
    {
        return $this->meetingAction;
    }

     
    public function setMeetingAction($meetingAction): Event
    {
        $this->meetingAction = $meetingAction;
        return $this;
    }

     
    public function getEvnlocation()
    {
        return $this->evnlocation;
    }

     
    public function setEvnlocation($evnlocation): Event
    {
        $this->evnlocation = $evnlocation;
        return $this;
    }

     
    public function getEvntype()
    {
        return $this->evntype;
    }

     
    public function setEvntype($evntype): Event
    {
        $this->evntype = $evntype;
        return $this;
    }

     
    public function getEvnsharetype()
    {
        return $this->evnsharetype;
    }

     
    public function setEvnsharetype($evnsharetype): Event
    {
        $this->evnsharetype = $evnsharetype;
        return $this;
    }

     
    public function getEvndescformat()
    {
        return $this->evndescformat;
    }

     
    public function setEvndescformat($evndescformat): Event
    {
        $this->evndescformat = $evndescformat;
        return $this;
    }

     
    public function getEvnnote()
    {
        return $this->evnnote;
    }

     
    public function setEvnnote($evnnote): Event
    {
        $this->replaceCID($evnnote);
        $this->evnnote = $evnnote;
        return $this;
    }

     
    public function getEvnflags()
    {
        return $this->evnflags;
    }

     
    public function getEvnstartdate()
    {
        return $this->evnstartdate;
    }

     
    public function setEvnstartdate($evnstartdate): Event
    {
        $this->evnstartdate = $evnstartdate;
        return $this;
    }

     
    public function getEvnenddate()
    {
        return $this->evnenddate;
    }

     
    public function setEvnenddate($evnenddate): Event
    {
        $this->evnenddate = $evnenddate;
        return $this;
    }

     
    public function getEvnstarttime()
    {
        return $this->evnstarttime;
    }

     
    public function setEvnstarttime($evnstarttime): Event
    {
        $this->evnstarttime = $evnstarttime;
        return $this;
    }

     
    public function getEvnendtime()
    {
        return $this->evnendtime;
    }

     
    public function setEvnendtime($evnendtime): Event
    {
        $this->evnendtime = $evnendtime;
        return $this;
    }

     
    public function setEvnflags($evnflags): Event
    {
        $this->evnflags = $evnflags;
        if(empty($this->evnOrganizer) && !empty($evnflags) && \GroupWareItem::isOrganizator($evnflags)){
            $groupChatOwnerEmail = '';
            $sOrganizer = $this->getFolder()->account->gwAPI->getFolderOwner($this->getFolder(), $groupChatOwnerEmail);
            if(empty($sOrganizer)) $sOrganizer = $_SESSION['EMAIL'];
            $this->setEvnOrganizer($sOrganizer);
        }
        return $this;
    }

     
    public function getEvntimeformat()
    {
        return $this->evntimeformat;
    }

     
    public function setEvntimeformat($evntimeformat): Event
    {
        $this->evntimeformat = $evntimeformat;
        return $this;
    }

     
    public function getTzevnstartdate()
    {
        return $this->_tzevnstartdate;
    }

     
    public function setTzevnstartdate($_tzevnstartdate): Event
    {
        $this->_tzevnstartdate = $_tzevnstartdate;
        return $this;
    }

     
    public function getTzevnenddate()
    {
        return $this->_tzevnenddate;
    }

     
    public function setTzevnenddate($_tzevnenddate): Event
    {
        $this->_tzevnenddate = $_tzevnenddate;
        return $this;
    }

     
    public function getTzevnstarttime()
    {
        return $this->_tzevnstarttime;
    }

     
    public function setTzevnstarttime($_tzevnstarttime): Event
    {
        $this->_tzevnstarttime = $_tzevnstarttime;
        return $this;
    }

     
    public function getTzevnendtime()
    {
        return $this->_tzevnendtime;
    }

     
    public function setTzevnendtime($_tzevnendtime): Event
    {
        $this->_tzevnendtime = $_tzevnendtime;
        return $this;
    }

     
    public function getCtz()
    {
        return $this->ctz;
    }

     
    public function setCtz($ctz): Event
    {
        $this->ctz = $ctz;
        return $this;
    }

     
    public function getMeetingPassword()
    {
        return $this->meetingPassword;
    }

     
    public function setMeetingPassword($meetingPassword): Event
    {
        $this->meetingPassword = $meetingPassword;
        return $this;
    }

     
    public function getEvnmeetingid()
    {
        return $this->evnmeetingid;
    }

     
    public function setEvnmeetingid($evnmeetingid): Event
    {
        $this->evnmeetingid = $evnmeetingid;
        return $this;
    }

     
    public function setFolder(\Folder $folder) : AGwEventItem
    {
        $this->folder = $folder;
        if($folder instanceof \VirtualFolder){
            $folder = $folder->getPrimary();
        }
        $this->setEvnfolder($folder->name);
        return $this;
    }

     
    public function getMeetingUrl()
    {
        return $this->meetingUrl;
    }

     
    public function setMeetingUrl($meetingUrl): void
    {
        $this->meetingUrl = $meetingUrl;
    }

     
    public function getMeetingAutoRecording()
    {
        return $this->meetingAutoRecording;
    }

     
    public function setMeetingAutoRecording($meetingAutoRecording): void
    {
        $this->meetingAutoRecording = $meetingAutoRecording;
    }

     
    public function getMeetingAutoLobby()
    {
        return $this->meetingAutoLobby;
    }

     
    public function setMeetingAutoLobby($meetingAutoLobby): void
    {
        $this->meetingAutoLobby = $meetingAutoLobby;
    }

     
    public function getPriority()
    {
        return $this->priority;
    }

     
    public function setPriority($priority): void
    {
        $this->priority = $priority;
    }

     
    public function getSequence()
    {
        return $this->sequence;
    }

     
    public function setSequence($sequence): void
    {
        $this->sequence = $sequence;
    }

     
    public function getTransp()
    {
        return $this->transp;
    }

     
    public function setTransp($transp): void
    {
        $this->transp = $transp;
    }

     
    public function getFlagAttendee()
    {
        return $this->flagAttendee;
    }

     
    public function setFlagAttendee($flagAttendee): Event
    {
        $this->flagAttendee = $flagAttendee;
        return $this;
    }

     
    public function getFlagFree()
    {
        return $this->flagFree;
    }

     
    public function setFlagFree($flagFree): Event
    {
        $this->flagFree = $flagFree;
        return $this;
    }

     
    public function getFlagTentative()
    {
        return $this->flagTentative;
    }

     
    public function setFlagTentative($flagTentative): Event
    {
        $this->flagTentative = $flagTentative;
        return $this;
    }

     
    public function getFlagOoo()
    {
        return $this->flagOoo;
    }

     
    public function setFlagOoo($flagOoo): Event
    {
        $this->flagOoo = $flagOoo;
        return $this;
    }

     
    public function getFlagUnresponded()
    {
        return $this->flagUnresponded;
    }

     
    public function setFlagUnresponded($flagUnresponded): Event
    {
        $this->flagUnresponded = $flagUnresponded;
        return $this;
    }

     
    public function getFlagNoReminder()
    {
        return $this->flagNoReminder;
    }

     
    public function setFlagNoReminder($flagNoReminder): Event
    {
        $this->flagNoReminder = $flagNoReminder;
        return $this;
    }

     
    public function getFlagLobby()
    {
        return $this->flagLobby;
    }

     
    public function setFlagLobby($flagLobby): Event
    {
        $this->flagLobby = $flagLobby;
        return $this;
    }

     
    public function getEvnfolder()
    {
        return $this->evnfolder;
    }

     
    public function setEvnfolder($evnfolder): AGwEventItem
    {
        $this->evnfolder = $evnfolder;
        return $this;
    }
}