<?php

namespace server\model;

class Email extends AGwEventItem implements IHasAttachments
{
    use THasAttachments;

    CONST TYPE = 'M';

    protected $id;
    protected $from;
    protected $flags;    protected $static_flags;    protected $to;
    protected $bcc;
    protected $cc;
    protected $priority;
    protected $subject;
    protected $date;
    protected $message_id;
    protected $smime_status;    protected $color;    protected $has_attachment;
    protected $html;    protected $has_embedded_attachment;
    protected $file;

    public static $skipVariablesExportFE = ['id', 'evnclass'];

    public function __construct(\Folder $folder, string $id, string $file)
    {
        $this->file = $file;
        $ids = [
            'account_id' => $folder->account->account->accountID,
            'folder_id' => $folder->name,
            'item_id' => $id,
            'sid' => $_SESSION['SID']
        ];
        $mailParse = new \MailParse($file, $ids);
        $this->setId($id);
        $this->setFolder($folder);
        $structure = $mailParse->parse(true, true, true);
        $headers = $structure['headers'];
        $this->setFrom($headers['from']);
        $this->setTo($headers['to']);
        $this->setSubject($headers['subject']);
        $this->setDate($headers['date']);
        $this->setBcc($headers['bcc']);
        $this->setCc($headers['cc']);
        $this->setPriority($headers['priority']);
        $this->setMessageId($headers['message-id']);
        $this->setHtml($structure['html_body'] ?? $structure['plain_body']);
        $this->setHasAttachment($mailParse->hasAttachments($structure) ? 'true' : 'false');
        $this->setHasEmbeddedAttachment($structure['has_embedded_attachment'] ? 'true' : 'false');
        $this->addAttachmentsFromArray($structure['attachments']);
        $this->addSmartAttachmentsFromStructure($structure);
    }

    protected function addAttachmentsFromArray($array)
    {
        foreach ($array as $data){
            $attachment = new Attachment($this->getFolder(), null, $this);
            $attachment->setPartId($data['part_id']);
            $attachment->setAttType($data['type']);
            $attachment->setName($data['name']);
            $attachment->setDescription($data['name']);
            $attachment->setSize($data['size']);
            $attachment->setFileLocation($this->file);
            $this->addAttachment($attachment);
        }
    }

    protected function addSmartAttachmentsFromStructure($structure = [])
    {
        if (isset($structure['headers']['x-icewarp-smartattach'])) {
            $smartAttachments = \MailParse::parseSmartAttachments($structure);
            if(is_array($smartAttachments) && !empty($smartAttachments)){
                foreach($smartAttachments as $attach){		
                    $part_id = $message['headers']['x-icewarp-smartattach-prefix'].$attach['part_id'];
                    
                    $attachment = new Attachment($this->getFolder(), null, $this);
                    $attachment->setPartId($part_id);
                    $attachment->setAttType($attach['type']);
                    $attachment->setName($attach['name']);
                    $attachment->setDescription($attach['name']);
                    $attachment->setSize($attach['size']);
                    $attachment->setFileLocation($this->file);
                    $attachment->setIsSmart(true);
                    $attachment->setUrl($attach['url']);
                    $this->addAttachment($attachment);
                }
                $this->setHasAttachment(true);
            }
        }
    }

    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        $result = $this->getAsArrayFE(false, true, $allowEmpty);
        $result['id'] = \slToolsPHP::htmlspecialchars($this->getId());
        $result['sFields'] = '<values>' . $this->xml . '</values>';
        $this->addAttachmentsTemplateDataArray($result, 'part_id', ['fileLocation', 'fileType', 'description', 'class', '_tzid'],['type'=>'type','name'=>'name','size'=>'size','url'=>'url','isSmart'=>'smart']);
        return $result;
    }

    public function getICalendar(): string
    {
        return '';
    }

    public function getType(): string
    {
        return self::TYPE;
    }

    protected function afterLoad(): void
    {
             }

     
    public function getFrom()
    {
        return $this->from;
    }

     
    public function setFrom($from): void
    {
        $this->from = $from;
    }

     
    public function getFlags()
    {
        return $this->flags;
    }

     
    public function setFlags($flags): void
    {
        $this->flags = $flags;
    }

     
    public function getStaticFlags()
    {
        return $this->static_flags;
    }

     
    public function setStaticFlags($static_flags): void
    {
        $this->static_flags = $static_flags;
    }

     
    public function getTo()
    {
        return $this->to;
    }

     
    public function setTo($to): void
    {
        $this->to = $to;
    }

     
    public function getPriority()
    {
        return $this->priority;
    }

     
    public function setPriority($priority): void
    {
        $this->priority = $priority;
    }

     
    public function getSubject()
    {
        return $this->subject;
    }

     
    public function setSubject($subject): void
    {
        $this->subject = $subject;
    }

     
    public function getDate()
    {
        if(!$this->date instanceof \DateTime) return null;
        return $this->date->getTimestamp();
    }

     
    public function setDate($date): void
    {
        $date = \DateTime::createFromFormat('Y-m-d H:i:s', $date);
        if ($date === false) $this->date = new \DateTime();
    }

     
    public function getMessageId()
    {
        return $this->message_id;
    }

     
    public function setMessageId($message_id): void
    {
        $this->message_id = $message_id;
    }

     
    public function getSmimeStatus()
    {
        return $this->smime_status;
    }

     
    public function setSmimeStatus($smime_status): void
    {
        $this->smime_status = $smime_status;
    }

     
    public function getColor()
    {
        return $this->color;
    }

     
    public function setColor($color): void
    {
        $this->color = $color;
    }

     
    public function getHasAttachment()
    {
        return $this->has_attachment;
    }

     
    public function setHasAttachment($has_attachment): void
    {
        $this->has_attachment = $has_attachment;
    }

     
    public function getHtml()
    {
        return \slToolsString::basicSanitizeHTML($this->html);
    }

     
    public function setHtml($html): void
    {
        $this->html = $html;
    }

     
    public function getBcc()
    {
        return $this->bcc;
    }

     
    public function setBcc($bcc): void
    {
        $this->bcc = $bcc;
    }

     
    public function getCc()
    {
        return $this->cc;
    }

     
    public function setCc($cc): void
    {
        $this->cc = $cc;
    }

     
    public function getFolder(): \Folder
    {
        return $this->folder;
    }

     
    public function setFolder(\Folder $folder) : AGwEventItem
    {
        $this->folder = $folder;
        return $this;
    }

     
    public function getId()
    {
        return $this->id;
    }

     
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

     
    public function getHasEmbeddedAttachment()
    {
        return $this->has_embedded_attachment;
    }

     
    public function setHasEmbeddedAttachment($has_embedded_attachment): Email
    {
        $this->has_embedded_attachment = $has_embedded_attachment;
        return $this;
    }
}