<?php

 

namespace server\model;

use Sabre\VObject\Node;
use server\inc\gw\Search;
use tools\ParamLineParser;

class Document extends AGwEventItem implements IHasAttachments
{
    use THasAttachments, THasThumbnail, TEvnGwSearch, TFileSearch;

    CONST TYPE = 'F';

    protected $sensitivity;
    protected $name;
    protected $size;

    protected $evnsharetype;
    protected $evnstartdate;
    protected $evnstarttime;
    protected $ctz;
    protected $evntitle;
    protected $evnlocation;
    protected $evnrid;
    protected $evncomplete;
    protected $evnnote;
    protected $evndescformat = 'text/plain';
    protected $evncomevnid;
    protected $evnuid;
    protected $evntype;
    
    public static $searchFields = [
        'EvnTitle',
        'EvnLocation',
        'EvnNote',
    ];

    public static $lengthVariablesExport = [
        'evnlocation' => 510,
        'evntitle' => 510,
    ];

     
    public function loadById(string $id) : bool
    {
        $this->setId($id);
        $data = $this->getGwApi()->FunctionCall('getEventInfo', $this->getFolderSessionId(), $this->getId(), 'use_tzid=1&revision_extended=1');
        $paramParser = new ParamLineParser($data, true);
        if(empty($paramParser->parsedParamLines[0] ?? null)) return false;
        $this->fillFromArray($paramParser->parsedParamLines[0], true);
        $this->afterLoad();
        return true;
    }

     
    public function save(): AGwEventItem
    {
        $this->saveOld();
        return $this;
    }

     
    public static function createFromXML(\Folder $folder, string $xml, bool $save = false, AGwEventItem $parent = null)
    {
         
        $result = parent::createFromXML($folder, $xml, false, $parent);
        if(($folder->getType() == 'I' && ($result->getEvnclass() == 'F' || $result->getEvnclass() == 'M')) && !\GroupWareItem::checkAttachmentName($result->getEvntitle())){
            throw new \Exc('attachment_name',$result->getEvntitle());
        }
        if(count($result->getAttachments()) > 1){
            $item = $result;
            $result = [];
            $attachments = $item->getAttachments();
            $item->setAttachments([]);
            $evnnote = $item->getEvnnote();
            $item->setEvnnote('');
            $first = true;
            foreach ($attachments as $attachment) {
                $tempItem = clone $item;
                if($first){
                    $tempItem->setEvnnote($evnnote);
                }
                $tempItem->addAttachment($attachment);
                $attachment->setParent($tempItem);
                $tempItem->setEvnRid($attachment->getName())
                    ->setEvnlocation($attachment->getName())
                    ->setEvncomplete($attachment->getSize())
                    ->setEvntitle($attachment->getName());
                
                $result[] = $tempItem;
                $first = false;
            }
            unset($item);
        }
        if($folder->getType() == 'I') self::correctPostWithEmailAttachments($result, $save);

        if($save){
            if(!is_array($result)){
                $result->save();
            }else{
                foreach ($result as $item) {
                    $item->save();
                }
            }
        }
        return $result;
    }

     
    public function saveOld($finalize = true)
    {
        $this->setEvnCreated();
                 if(!$this->prepareParamLine('use_tzid=1')){
            if($this->finalized) $finalize = false;
        }elseif(!$sEvnId = $this->getGwApi()->FunctionCall('AddEventInfo', $this->getFolderSessionId(), $this->getParamLine(), $this->getId())){
            $lastError = $this->getGwApi()->FunctionCall("GetLastError",$this->getFolder()->account->sGWSessionID);
            if($lastError != 13) throw new \Exc('item_create',$sEvnId);

            $freename = \GroupWareItem::proposeFreeFileName($this->folder, $this->getEvnlocation());

            $this->setEvntitle($freename);
            $this->setEvnLocation($freename);
            $this->setEvnrid($freename);

            if(!$this->prepareParamLine('use_tzid=1')) throw new \Exc('item_create',$sEvnId);
            if(!$sEvnId = $this->getGwApi()->FunctionCall('AddEventInfo', $this->getFolderSessionId(), $this->getParamLine(), $this->getId())) throw new \Exc('item_create',$sEvnId);
        }
        $this->setId($sEvnId ?? $this->getId());

        foreach ($this->getAttachments() as $attachment) {
            $attachment->saveOld();
            if(empty($attachment->getSize())) $attachment->setSize(filesize($attachment->getFileLocation()));
            $attachment->setAttWebdavLink(\User::addTokenToTicket($this->getGwApi()->FunctionCall("getAttachmentPath", $this->getFolderSessionId(), $this->getId(), $attachment->getId(), 'READONLYTICKET')));
        }

        $this->backupState();
        if(!$finalize) return;
                 $this->getGwApi()->FunctionCall('AddEventInfo', $this->getFolderSessionId(), '', $this->getId());
        $this->getFolder()->groupChatLastActivity = $this->getEvnCreated(false);
        $this->finalized = true;
    }

    public function getFullpath($accountId, $id = false)
    {
        return $accountId . '/' . ($id ? $this->getFolder()->folderID :$this->getFolder()->name) . '/' . $this->getId();
    }

    public function invite(
        int $expire,
                 string $password,
        int $rights
    ) : bool
    {
        return $this->getGWAPI()->FunctionCall(
            "AddDocumentInvite", 
            $this->getFolderSessionId(), 
            $this->getId(), 
            'rights='.urlencode($rights).
            '&expire='.urlencode($expire).
            '&password='.urlencode($password)
        );
    }

    public function inviteByParameters(string $parameters)
    {
        return $this->getGWAPI()->FunctionCall(
            "AddDocumentInvite", 
            $this->getFolderSessionId(), 
            $this->getId(), 
            $parameters
        );
    }

    public function getCreatedData() : array
    {
        $result = parent::getCreatedData();
        if($this->attachments) foreach($this->attachments as $attachment){
            if(!$this->att_webdav_link){
                $this->att_webdav_link = $attachment->att_webdav_link;
                $result['name'] =  $attachment->getName();
            }
        }        
        $result['att_webdav_link'] = $this->getAttWebdavLink();
        $result['att_size'] = $this->getEvncomplete();
        $result['folder'] = $this->getFolder()->folderID;
        return $result;
    }

    public function loadInviteTicket() : string
    {
        $result = $this->getGwApi()->FunctionCall("GetAttachmentPathLocal", $this->getFolderSessionId(), $this->getId(), '', 'INVITETICKET');   
        return $result;
    }

    public function greaterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnComplete > %s', self::kiloByteToByte($value));
    }

    public function smallerCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('EvnComplete < %s', self::kiloByteToByte($value));
    }

    public function afterCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified > %s', strtotime($value));
    }

    public function aftertimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified > %s', strtotime($value));
    }

    public function beforetimeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified < %s', strtotime($value));
    }

    public function beforeCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition('Evn_Modified < %s', strtotime($value));
    }


    public function fillFromVObject(Node $vObject)
    {
             }

    public function getICalendar(): string
    {
        return '';
    }

    public function getType(): string
    {
        return self::TYPE;
    }

    protected function afterLoad(): void
    {
             }

     
    public function getSize()
    {
        return $this->size;
    }

     
    public function setSize($size): Document
    {
        $this->size = $size;
        return $this;
    }

     
    public function getEvnsharetype()
    {
        return $this->evnsharetype;
    }

     
    public function setEvnsharetype($evnsharetype): Document
    {
        $this->evnsharetype = $evnsharetype;
        return $this;
    }

     
    public function getEvnstartdate()
    {
        return $this->evnstartdate;
    }

     
    public function setEvnstartdate($evnstartdate): Document
    {
        $this->evnstartdate = $evnstartdate;
        return $this;
    }

     
    public function getEvnstarttime()
    {
        return $this->evnstarttime;
    }

     
    public function setEvnstarttime($evnstarttime): Document
    {
        $this->evnstarttime = $evnstarttime;
        return $this;
    }

     
    public function getCtz()
    {
        return $this->ctz;
    }

     
    public function setCtz($ctz): Document
    {
        $this->ctz = $ctz;
        return $this;
    }

     
    public function getEvntitle()
    {
        return $this->evntitle;
    }

     
    public function setEvntitle($evntitle): Document
    {
        $this->evntitle = $evntitle;
        return $this;
    }

     
    public function getEvnlocation()
    {
        return $this->evnlocation;
    }

     
    public function setEvnlocation($evnlocation): Document
    {
        $this->evnlocation = $evnlocation;
        return $this;
    }

     
    public function getEvnrid()
    {
        return $this->evnrid;
    }

     
    public function setEvnrid($evnrid): Document
    {
        $this->evnrid = $evnrid;
        return $this;
    }

     
    public function getEvncomplete()
    {
        return $this->evncomplete;
    }

     
    public function setEvncomplete($evncomplete): Document
    {
        $this->evncomplete = $evncomplete;
        return $this;
    }

     
    public function getEvnnote()
    {
        return $this->evnnote;
    }

     
    public function setEvnnote($evnnote): Document
    {
        $this->evnnote = $evnnote;
        return $this;
    }

     
    public function getEvndescformat()
    {
        return $this->evndescformat;
    }

     
    public function setEvndescformat($evndescformat): Document
    {
        $this->evndescformat = $evndescformat;
        return $this;
    }

     
    public function getEvncomevnid()
    {
        return $this->evncomevnid;
    }

     
    public function setEvncomevnid($evncomevnid): Document
    {
        $this->evncomevnid = $evncomevnid;

        return $this;
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }

    public static function getCountByFilter(\Folder $folder, $filter)
    {
             }

      
    public function getEvnuid()
    {
        return $this->evnuid;
    }

      
    public function setEvnuid($evnuid) : Document
    {
        $this->evnuid = $evnuid;

        return $this;
    }

      
    public function getEvntype()
    {
        return $this->evntype;
    }

      
    public function setEvntype($evntype)
    {
        $this->evntype = $evntype;

        return $this;
    }
}
