<?php

namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Component\VCard;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use server\inc\gw\Search;
use tools\SearchParserYoda;

 
class Contact extends AGwEventItem implements IHasAttachments, IHasCertificates, IHasLocations
{
    use THasAttachments, THasCertificates, THasLocations, TCommonGwSearch;

    protected $itmclassifyas;
    protected $itmnickname;
    protected $itmcompany;
    protected $itmjobtitle;
    protected $itmcategory;
    protected $itmbdate;
    protected $itmanniversary;
    protected $itmgender;
    protected $itmspouse;
    protected $itminternetfreebusy;
    protected $itmprofession;
    protected $itmdepartment;
    protected $itmassistantname;
    protected $itmmanagername;
    protected $itmofficelocation;
    protected $itmdescription;
    protected $itmsharetype;
    protected $itmdescformat;
    protected $itmtitle;
    protected $itmfirstname;
    protected $itmmiddlename;
    protected $itmsurname;
    protected $itmsuffix;
    protected $ctz;
    protected $itmId;
    protected $itmgrpId;
    protected $lctemail1;
    protected $lctemail2;
    protected $lctemail3;
    protected $lcttype;
    protected $itmclass;
    protected $itmfolder;

    public static $searchFields = [
        'ItmTitle',
        'ItmClassifyAs',
        'LctEmail1',
        'LctEmail2',
        'LctEmail3',
        'ItmCompany',
        'ItmDepartment',
        'ItmCategory',
        'ItmFirstName',
        'ItmSurName',
        'ItmMiddleName',
        'ItmDescription',

                 'LctPhnHome1',
        'LctPhnHome2',
        'LctPhnAssistant',
        'LctPhnWork1',
        'LctPhnWork2',
        'LctPhnFaxHome',
        'LctPhnFaxWork',
        'LctPhnCallback',
        'LctPhnCompany',
        'LctPhnCar',
        'LctPhnIsdn',
        'LctPhnMobile',
        'LctPhnOther',
        'LctPhnOtherFax',
        'LctPhnPager',
        'LctPhnPrimary',
        'LctPhnRadio',
        'LctPhnTelex',
        'LctPhnHearing'
    ];

    public static $phoneColumns = ['LCTPHNHOME1', 'LCTPHNHOME2', 'LCTPHNASSISTANT', 'LCTPHNWORK1', 'LCTPHNWORK2', 'LCTPHNFAXHOME', 'LCTPHNFAXWORK', 'LCTPHNCALLBACK', 'LCTPHNCOMPANY', 'LCTPHNCAR', 'LCTPHNISDN', 'LCTPHNMOBILE', 'LCTPHNOTHER', 'LCTPHNOTHERFAX', 'LCTPHNPAGER', 'LCTPHNPRIMARY', 'LCTPHNRADIO', 'LCTPHNTELEX', 'LCTPHNHEARING'];


    CONST TYPE = 'C';

     
    public function save(): AGwEventItem
    {
        $sEvnId = $this->getGwApi()->FunctionCall('AddVCard', $this->getFolderSessionId(), $this->getICalendar(), $this->getId() ?? '');
        $this->setId($sEvnId);
        $this->setAttWebdavLink(\User::addTokenToTicket($this->getGwApi()->FunctionCall('GetAttachmentPathLocal', $this->getFolderSessionId(), $this->getId(), '', 'TICKET')));
        return $this;
    }

     
    public function getICalendar(): string
    {
        $vCard = new VCard();
        unset($vCard->PRODID, $vCard->VERSION);
        if(!empty($this->getId())){
            $vCard->add('UID', $this->getId());
            $vCard->add('X-SERVER-UID', $this->getId());
        }else{
            unset($vCard->UID);
        }
        if(!empty($this->getItmcategory())) $vCard->add('CATEGORIES', $this->getItmcategory());
        $vCard->add('FN', $this->getItmclassifyas());
        $vCard->add('N', [$this->getItmsurname(), $this->getItmfirstname(), $this->getItmmiddlename(), $this->getItmtitle()]);
        $vCard->add('NOTE', strip_tags(html_entity_decode($this->getItmdescription())));
        $vCard->add('X-ALT-NOTE', $this->getItmdescription(), ['FMTTYPE' => 'text/html']);
        $vCard->add('FBURL', $this->getItminternetfreebusy());
        $vCard->add('X-MS-ASSISTANT', $this->getItmassistantname());
        $vCard->add('X-MS-MANAGER', $this->getItmmanagername());
        $vCard->add('X-MS-SPOUSE', $this->getItmspouse());
        $vCard->add('CLASS', ($this->getItmsharetype() == 'P' ? 'PRIVATE' : 'PUBLIC'));
        $vCard->add('NICKNAME', $this->getItmnickname());
        $vCard->add('OFFICE', $this->getItmofficelocation());
        $vCard->add('SEX', $this->getItmgender());
        $vCard->add('X-WAB-GENDER', (int)$this->getItmgender()+1);
        $vCard->add('BDAY', $this->getItmbdate());
        $vCard->add('ANNIVERSARY', $this->getItmanniversary());
        $vCard->add('TITLE', $this->getItmtitle());
        $vCard->add('ROLE', $this->getItmprofession());
        $vCard->add('ORG', [$this->getItmcompany(), $this->getItmdepartment()]);

        $vCard->add('CREATED', $this->getEvnCreated());
        if($this->getEvnModified() instanceof \DateTime) $vCard->add('LAST-MODIFIED', $this->getEvnModified());
        if($this->getEvndeleted() instanceof \DateTime) $vCard->add('DELETED', $this->getEvndeleted());

         
        return $this->serialize($vCard);
    }

    public function getType(): string
    {
        return self::TYPE;
    }

     
    protected function getDefaults()
    {
        return [];
    }

    public function fillFromVObject(Node $vObject)
    {
        parent::fillFromVObject($vObject);
         
        if(isset($vObject->CATEGORIES)) $this->setItmcategory($vObject->CATEGORIES);
        $this->setItmclassifyas((string)$vObject->FN);
        list($this->itmsurname, $this->itmfirstname, $this->itmmiddlename, $this->itmtitle) = explode(';', (string)$vObject->N);

        if(isset($vObject->{'X-ALT-NOTE'})){
            $this->setItmdescription($vObject->{'X-ALT-NOTE'});
        }else{
            $this->setItmdescription($vObject->{'NOTE'});
        }
        $this->setItminternetfreebusy((string)$vObject->FBURL);
        $this->setItmassistantname((string)$vObject->{'X-MS-ASSISTANT'});
        $this->setItmmanagername((string)$vObject->{'X-MS-MANAGER'});
        $this->setItmspouse((string)$vObject->{'X-MS-SPOUSE'});
        $this->setItmsharetype((string)$vObject->CLASS == 'PRIVATE' ? 'P' : 'U');
        $this->setItmnickname((string)$vObject->NICKNAME);
        $this->setItmofficelocation((string)$vObject->OFFICE);
        if(isset($vObject->{'X-WAB-GENDER'})){
            $this->setItmgender((int)$vObject->{'X-WAB-GENDER'}->getValue()-1);
        }else{
            $this->setItmgender((string)$vObject->SEX);
        }
        $this->setItmbdate((string)$vObject->BDAY);
        $this->setItmanniversary((string)$vObject->ANNIVERSARY);
        $this->setItmtitle((string)$vObject->TITLE);
        $this->setItmprofession((string)$vObject->ROLE);

        list($this->itmcompany, $this->itmdepartment) = explode(';', (string)$vObject->ORG);
    }

     
    public static function getByFilter(\Folder $folder, &$filter)
    {
        $items = [];
         
        $gwApi = $folder->account->gwAPI;
        $sessionId = $folder->openAccess();
        \slToolsIcewarp::removeEmptyConditionsSQL($filter['sql']);
        $attributes = $gwApi->filterToAttributes($filter);
        $attributes .= ($attributes?';':'') . 'ignore_dl=1';
        $selectFields = explode(',', strtolower($filter['tag']));
        $selectFields[] = 'itmfolder';
        $result = $gwApi->FunctionCall('getContactDetailList', $sessionId, $filter['sql'], implode(',', $selectFields), $attributes);
        $parser = new \tools\ParamLineParser($result);
        foreach ($parser->parsedParamLines as $parsedParamLine) {
            $item = new Contact($folder);
            $item->fillFromArray($parsedParamLine, false);
            $item->setFilterTag($filter);
            if($item->getItmclass() == 'L'){
                $items[$item->getId()] = $item;
            }else{
                $items[$item->getEmail()] = $item;
            }
        }

        if ($filter['includeSentFolderEmails']) {
            $defaultSentFolder = \User::getDefaultFolder('S');
            if(!$defaultSentFolder){
                \User::syncDefaultFolders();
                $defaultSentFolder = \User::getDefaultFolder('S');
            }
            if(!$defaultSentFolder){
                $defaultSentFolder = \Storage::getDefaultMailFolder('sent');
            }
            if(isset($filter['addressbook'])){
                $account = $_SESSION['user']->getAccount($_SESSION['EMAIL']);
                $emailContacts = self::getContactFromMailFolderEmail($filter['addressbook']['mail'], $account->getFolderWithAutoCreate($defaultSentFolder));
                if(isset($search['value'])) $items = array_merge($emailContacts, $items);
            }elseif($filter['searchObject'] instanceof Search && $filter['searchObject']->hasKeyword('addressbook')){
                $search = $filter['searchObject']->getConditionByKeyword('addressbook');
                $account = $_SESSION['user']->getAccount($_SESSION['EMAIL']);
                $emailContacts = self::getContactFromMailFolder($search['value'], $account->getFolderWithAutoCreate($defaultSentFolder));
                if(isset($search['value'])) $items = array_merge($emailContacts, $items);
            }
        }

        usort($items, [Contact::class, 'compare']);
        return $items;
    }

     
    public static function compare(Contact $contactA, Contact $contactB) {
        return strcmp($contactA->getEmail(), $contactB->getEmail());
    }

     
    public function getEmail(string $search = '')
    {
        if(!empty($search)){
            $search = strtolower($search);
            if(strpos(strtolower($this->getLctemail1()), $search) !== false) return $this->getLctemail1();
            if(strpos(strtolower($this->getLctemail2()), $search) !== false) return $this->getLctemail2();
            if(strpos(strtolower($this->getLctemail3()), $search) !== false) return $this->getLctemail3();
        }
        return $this->getLctemail1() ?? $this->getLctemail2() ?? $this->getLctemail3();
    }

    public function __debugInfo()
    {
        return [self::class, $this->getItmclassifyas()];
    }

    private static function getContactDateFilterValue() : int
    {
        return time() - 31536000;      }

     
    public static function getContactFromMailFolder($searchValue, \CacheFolder $folder) : array
    {
        $result = [];
        $search = false;
        $cache = \Cache::instance( $_SESSION['user'] );
        $ismssql = strtoupper($cache->dbtype)=='ODBC'; 
        if($_SESSION['FULLTEXT_SUPPORT'] && false){
            $search = new \server\inc\imap\Search($folder, $searchValue);
        }
        if(!$search instanceof SearchParserYoda || !$search->isSearchEnabled() || ($sql = $search->getSearchSql()) === false) {
            $startInnerLimit = strtoupper($_SESSION['DBTYPE'])=='MYSQL'?'(':'';
            $endInnerLimit = strtoupper($_SESSION['DBTYPE'])=='MYSQL'?' LIMIT 60)':'';
            $dateFilterValue = self::getContactDateFilterValue();
            $dateFilter = "date >= ".($ismssql?$dateFilterValue:":date");

            $sql = "SELECT DISTINCT contact FROM (
$startInnerLimit SELECT DISTINCT header_to AS contact FROM item WHERE folder_id = ".($ismssql?"'$folder->folderID'":":folder")."
AND ".$dateFilter." AND (sort_to LIKE ".($ismssql?"'$searchValue%'":":match1")." {ESCAPE '\\'} OR sort_to LIKE ".($ismssql?"'%.$searchValue%'":":match2")." {ESCAPE '\\'} OR sort_to LIKE ".($ismssql?"'%@$searchValue%'":":match3")." {ESCAPE '\\'} OR sort_to LIKE ".($ismssql?"'% $searchValue%'":":match4")." {ESCAPE '\\'})$endInnerLimit
UNION 
$startInnerLimit SELECT DISTINCT header_cc AS contact FROM item WHERE folder_id = ".($ismssql?"'$folder->folderID'":":folder")."
AND ".$dateFilter." AND (sort_cc LIKE ".($ismssql?"'$searchValue%'":":match1")." {ESCAPE '\\'} OR sort_cc LIKE ".($ismssql?"'%.$searchValue%'":":match2")." {ESCAPE '\\'} OR sort_cc LIKE ".($ismssql?"'%@$searchValue%'":":match3")." {ESCAPE '\\'} OR sort_cc LIKE ".($ismssql?"'% $searchValue%'":":match4")." {ESCAPE '\\'})$endInnerLimit
UNION 
$startInnerLimit SELECT DISTINCT header_bcc AS contact FROM item WHERE folder_id = ".($ismssql?"'$folder->folderID'":":folder")."
AND ".$dateFilter." AND (sort_bcc LIKE ".($ismssql?"'$searchValue%'":":match1")." {ESCAPE '\\'} OR sort_bcc LIKE ".($ismssql?"'%.$searchValue%'":":match2")." {ESCAPE '\\'} OR sort_bcc LIKE ".($ismssql?"'%@$searchValue%'":":match3")." {ESCAPE '\\'} OR sort_bcc LIKE ".($ismssql?"'% $searchValue%'":":match4")." {ESCAPE '\\'})$endInnerLimit
) AS dummy";

            $cacheSearch = $ismssql?[]:array(
                'folder'=>$folder->folderID,
                'match1'=>"$searchValue%",
                'match2'=>"%.$searchValue%",
                'match3'=>"%@$searchValue%",
                'match4'=>"% $searchValue%",
                'date'=>$dateFilterValue
            );
        } else {
            $cacheSearch = array();
        }

        
        $cacheResult = $cache->getFromCacheBySQL($sql, 0, 60, $cacheSearch, 'contact ASC');
        foreach (array_column($cacheResult, 'contact') as $contactString) {
            foreach (\slMailParse::parseAddresses($contactString) as $item) {
                if(stripos($item['display'], $searchValue) === false && stripos($item['address'], $searchValue) === false ) continue;
                $contact = new Contact($folder);
                $contact->setItmclassifyas($item['display']);
                $contact->setLctemail1($item['address']);
                $result[$item['address']] = $contact;
            }
        }
        return $result;
    }

    public static function getContactFromMailFolderEmail($email, \CacheFolder $folder) : array
    {
        $result = [];
        $search = false;
        if($_SESSION['FULLTEXT_SUPPORT'] && false){
            $search = new \server\inc\imap\Search($folder, '+email:'.$email);
        }
        if(!$search instanceof SearchParserYoda || !$search->isSearchEnabled() || ($sql = $search->getSearchSql()) === false) {
            $startInnerLimit = strtoupper($_SESSION['DBTYPE'])=='MYSQL'?'(':'';
            $endInnerLimit = strtoupper($_SESSION['DBTYPE'])=='MYSQL'?' LIMIT 60)':'';
            $dateFilterValue = self::getContactDateFilterValue();
            $dateFilter = "date >= :date";

            $sql = "SELECT DISTINCT contact FROM (
$startInnerLimit SELECT DISTINCT header_to AS contact FROM item WHERE folder_id = :folder
AND ".$dateFilter." AND (sort_to LIKE :match1 {ESCAPE '\\'})$endInnerLimit
UNION 
$startInnerLimit SELECT DISTINCT header_cc AS contact FROM item WHERE folder_id = :folder
AND ".$dateFilter." AND (sort_cc LIKE :match1 {ESCAPE '\\'})$endInnerLimit
UNION 
$startInnerLimit SELECT DISTINCT header_bcc AS contact FROM item WHERE folder_id = :folder
AND ".$dateFilter." AND (sort_bcc LIKE :match1 {ESCAPE '\\'})$endInnerLimit
) AS dummy";
            $cacheSearch = array(
                'folder'=>$folder->folderID,
                'match1'=>"%$email%",
                'date'=>$dateFilterValue
            );
        } else {
            $cacheSearch = array();
        }

        $cache = \Cache::instance( $_SESSION['user'] );
        $cacheResult = $cache->getFromCacheBySQL($sql, 0, 60, $cacheSearch);
        foreach (array_column($cacheResult, 'contact') as $contactString) {
            foreach (\slMailParse::parseAddresses($contactString) as $item) {
                if(stripos($item['address'], $email) === false) continue;
                $contact = new Contact($folder);
                $contact->setItmclassifyas($item['display']);
                $contact->setLctemail1($email);
                $result[$email] = $contact;
            }
        }
        return $result;
    }

    public function getTemplateDataArray(array $allowEmpty = []) : array
    {
        $result = $this->getAsArrayFE(false, true, $allowEmpty);
        $result['id'] = \slToolsPHP::htmlspecialchars($this->getId());
        $result['sFields'] = '<values>' . $this->xml . '</values>';
        $this->addAttachmentsTemplateDataArray($result);
        return $result;
    }

    public static function getCountByFilter(\Folder $folder, $filter)
    {
         
        $gwApi = $folder->account->gwAPI;
        $sessionId = $folder->openAccess();
        return $gwApi->FunctionCall('GetContactDetailCount', $sessionId, $filter['sql'], 'ignore_dl=1');
    }

    public function creationdateCondition(Search $search, $value) : string
    {
        $dateTime = \DateTime::createFromFormat('Y-m-d', $value);
        $dateTime->setTime(0,0);
        $value = [$dateTime->getTimestamp()];
        $dateTime->setTime(23,59,59);
        $value[] = $dateTime->getTimestamp();
        return $this->placeValueToCondition('(Itm_Created > %s AND Itm_Created < %s)', $value);
    }

    public function classCondition(Search $search, $value) : string
    {
        if(!preg_match_all('/[^,\\s]+/', $value, $matches)) return '';
        $in = array_fill(0, count($matches[0]), "'%s'");
        return $this->placeValueToCondition("(ItmClass IN (" . implode(',', $in) . "))", $matches[0]);
    }

    public function itemsCondition(Search $search, $value) : string
    {
        return $this->uidsCondition($search, $value);
    }

    public function uidsCondition(Search $search, $value) : string
    {
        if(!preg_match_all('/[^,\\s]+/', $value, $matches)) return '';
        $in = array_fill(0, count($matches[0]), "'%s'");
        return $this->placeValueToCondition("(ITM_ID IN (" . implode(',', $in) . "))", $matches[0]);
    }

    public function inCondition(Search $search, $value) : string
    {
        if(trim(strtolower($value)) == 'anywhere') return '1 = 1';
        if(!$account = $this->getFolder()->account) return '0 = 1';
        return $this->placeValueToCondition("(ItmFolder = '%s' )", $value);
    }

    public function ridCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmRID = '%s')", $value);
    }

    public function hasCondition(Search $search, $value) : string
    {
        if($value == 'email1') return "(NULLIF(LCTEMAIL1, '') IS NOT NULL)";
        if($value == 'email2') return "(NULLIF(LCTEMAIL2, '') IS NOT NULL)";
        if($value == 'email3') return "(NULLIF(LCTEMAIL3, '') IS NOT NULL)";
        if($value == 'mobile') return "(NULLIF(LCTPHNMOBILE, '') IS NOT NULL)";
        if($value == 'email') return "((NULLIF(LCTEMAIL1, '') IS NOT NULL) OR (NULLIF(LCTEMAIL2, '') IS NOT NULL) OR (NULLIF(LCTEMAIL3, '') IS NOT NULL) OR ItmClass = 'L')";

        if($value == 'phone'){
            $result = "(COALESCE(";
            $result .= "NULLIF(" . implode(", ''), NULLIF(", self::$phoneColumns);
            $result .= ", '')) IS NOT NULL)";
            return $result;
        }

        if($value == 'sip') return "(LctPhnOther IS NOT NULL AND LctPhnOther LIKE 'sip:%')";
        return '';
    }

    public function isCondition(Search $search, $value) : string
    {
        if($value == 'read') return $search->addTableName('unread') . ' = 0';
        if($value == 'unread') return $search->addTableName('unread') . ' = 1';
        if($value == 'flagged') return $search->addTableName('color') . " <> 'Z'";
        if($value == 'private') return "(ItmShareType ='P' OR ItmShareType ='C')";
        if($value == 'public') return "(ItmShareType <> 'P' AND ItmShareType <> 'C')";
        return '';
    }

    public function noteCondition(Search $search, $value) : string
    {
        return $this->descriptionCondition($search, $value);
    }

    public function descriptionCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmDescription IS NOT NULL AND ItmDescription LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function companyCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmCompany IS NOT NULL AND ItmCompany LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function departmentCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmDepartment IS NOT NULL AND ItmDepartment LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function titleCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmTitle IS NOT NULL AND ItmTitle LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function nameCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("((ItmClassifyAs IS NOT NULL AND ItmClassifyAs LIKE '%%%s%%' {ESCAPE '\\'}) OR (ItmFirstName IS NOT NULL AND ItmFirstName LIKE '%%%s%%' {ESCAPE '\\'}) OR (ItmMiddleName IS NOT NULL AND ItmMiddleName LIKE '%%%s%%' {ESCAPE '\\'}) OR (ItmSurName IS NOT NULL AND ItmSurName LIKE '%%%s%%' {ESCAPE '\\'}))", $value, 4);
    }

    public function isemailCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("((LCTEMAIL1 = '%s') OR (LCTEMAIL2 ='%s') OR (LCTEMAIL3 = '%s'))", $value, 3);
    }

    public function emailCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("((LctType <> 'L' AND LCTEMAIL1 IS NOT NULL AND LCTEMAIL1 LIKE '%%%s%%'  {ESCAPE '\\'}) OR (LctType <> 'L' AND LCTEMAIL2 IS NOT NULL AND LCTEMAIL2 LIKE '%%%s%%'  {ESCAPE '\\'}) OR (LctType <> 'L' AND LCTEMAIL3 IS NOT NULL AND LCTEMAIL3 LIKE '%%%s%%' {ESCAPE '\\'}))", $value, 3);
    }

    public function categoryCondition(Search $search, $value) : string
    {
        return $this->placeValueToCondition("(ItmCategory IS NOT NULL AND ItmCategory LIKE '%%%s%%' {ESCAPE '\\'})", $value);
    }

    public function addressbookCondition(Search $search, $value) : string
    {
        if(preg_match('/(?:(?:^\'(?P<name>[^\']+)\')|(?:^"(?P<name>[^\']+)")|(?:^(?P<name>[^<]+?)))(?:\\s|<)+(?P<mail>[^@\\s]+@.*?)>?$/uiJ', $value, $matches)){
            return $this->addressbookComplicatedCondition($search, $matches);
        }
        if(iconv_strlen($value,'utf-8') <= 3){
            return $this->placeValueToCondition("(ItmClass <> 'L' AND LCTEMAIL1 IS NOT NULL AND (LCTEMAIL1 LIKE '%s%%' OR LCTEMAIL1 LIKE '%%@%s%%' OR LCTEMAIL1 LIKE '%%.%s%%')) 
OR (ItmClass <> 'L' AND LCTEMAIL2 IS NOT NULL AND (LCTEMAIL2 LIKE '%s%%' OR LCTEMAIL2 LIKE '%%@%s%%' OR LCTEMAIL2 LIKE '%%.%s%%'  )) 
OR (ItmClass <> 'L' AND LCTEMAIL3 IS NOT NULL AND (LCTEMAIL3 LIKE '%s%%' OR LCTEMAIL3 LIKE '%%@%s%%' OR LCTEMAIL3 LIKE '%%.%s%%' )) 
OR (ItmTitle IS NOT NULL AND (ItmTitle LIKE '%s%%' OR ItmTitle LIKE '%% %s%%')) 
OR (ItmClassifyAs IS NOT NULL AND (ItmClassifyAs LIKE '%s%%' OR ItmClassifyAs LIKE '%% %s%%')) 
OR (ItmFirstName IS NOT NULL AND (ItmFirstName LIKE '%s%%' OR ItmFirstName LIKE '%% %s%%')) 
OR (ItmMiddleName IS NOT NULL AND (ItmMiddleName LIKE '%s%%' OR ItmMiddleName LIKE '%% %s%%')) 
OR (ItmSurName IS NOT NULL AND (ItmSurName LIKE '%s%%' OR ItmSurName LIKE '%% %s%%'))", $value);
        } else if (str_contains($value, '@')) {
            return $this->placeValueToCondition("(ItmClass <> 'L' AND LCTEMAIL1 IS NOT NULL AND LCTEMAIL1 LIKE '%%%s%%') 
OR (ItmClass <> 'L' AND LCTEMAIL2 IS NOT NULL AND LCTEMAIL2 LIKE '%%%s%%') 
OR (ItmClass <> 'L' AND LCTEMAIL3 IS NOT NULL AND LCTEMAIL3 LIKE '%%%s%%') 
OR (ItmTitle IS NOT NULL AND (ItmTitle LIKE '%%%s%%')) 
OR (ItmClassifyAs IS NOT NULL AND (ItmClassifyAs LIKE '%%%s%%')) 
OR (ItmFirstName IS NOT NULL AND (ItmFirstName LIKE '%%%s%%')) 
OR (ItmMiddleName IS NOT NULL AND (ItmMiddleName LIKE '%%%s%%')) 
OR (ItmSurName IS NOT NULL AND (ItmSurName LIKE '%%%s%%'))", $value);
        } else {
            return $this->placeValueToCondition("(ItmClass <> 'L' AND LCTEMAIL1 IS NOT NULL AND (LCTEMAIL1 LIKE '%%%s%%@%%' OR LCTEMAIL1 LIKE '%%@%s%%' OR LCTEMAIL1 LIKE '%%.%s%%')) 
OR (ItmClass <> 'L' AND LCTEMAIL2 IS NOT NULL AND (LCTEMAIL2 LIKE '%%%s%%@%%' OR LCTEMAIL2 LIKE '%%@%s%%' OR LCTEMAIL2 LIKE '%%.%s%%'  )) 
OR (ItmClass <> 'L' AND LCTEMAIL3 IS NOT NULL AND (LCTEMAIL3 LIKE '%%%s%%@%%' OR LCTEMAIL3 LIKE '%%@%s%%' OR LCTEMAIL3 LIKE '%%.%s%%' )) 
OR (ItmTitle IS NOT NULL AND (ItmTitle LIKE '%%%s%%')) 
OR (ItmClassifyAs IS NOT NULL AND (ItmClassifyAs LIKE '%%%s%%')) 
OR (ItmFirstName IS NOT NULL AND (ItmFirstName LIKE '%%%s%%')) 
OR (ItmMiddleName IS NOT NULL AND (ItmMiddleName LIKE '%%%s%%')) 
OR (ItmSurName IS NOT NULL AND (ItmSurName LIKE '%%%s%%'))", $value);
        }
    }

    protected function addressbookComplicatedCondition(Search $search, array $values) : string
    {
        $search->filter['addressbook'] = $values;
        return $this->placeValueToCondition("(ItmClass <> 'L' AND LCTEMAIL1 IS NOT NULL AND (LCTEMAIL1 LIKE '%s')) 
OR (ItmClass <> 'L' AND LCTEMAIL2 IS NOT NULL AND (LCTEMAIL2 LIKE '%s')) 
OR (ItmClass <> 'L' AND LCTEMAIL3 IS NOT NULL AND (LCTEMAIL3 LIKE '%s')) 
OR (ItmTitle IS NOT NULL AND (ItmTitle LIKE '%%%s%%')) 
OR (ItmClassifyAs IS NOT NULL AND (ItmClassifyAs LIKE '%%%s%%')) 
OR (ItmFirstName IS NOT NULL AND (ItmFirstName LIKE '%%%s%%')) 
OR (ItmMiddleName IS NOT NULL AND (ItmMiddleName LIKE '%%%s%%')) 
OR (ItmSurName IS NOT NULL AND (ItmSurName LIKE '%%%s%%'))", [$values['mail'], $values['mail'], $values['mail'], $values['name'], $values['name'], $values['name'], $values['name'], $values['name']]);
    }

     
    public function getItmclassifyas()
    {
        return $this->itmclassifyas;
    }

     
    public function setItmclassifyas($itmclassifyas): Contact
    {
        $this->itmclassifyas = $itmclassifyas;
        return $this;
    }

     
    public function getItmnickname()
    {
        return $this->itmnickname;
    }

     
    public function setItmnickname($itmnickname): Contact
    {
        $this->itmnickname = $itmnickname;
        return $this;
    }

     
    public function getItmcompany()
    {
        return $this->itmcompany;
    }

     
    public function setItmcompany($itmcompany): Contact
    {
        $this->itmcompany = $itmcompany;
        return $this;
    }

     
    public function getItmjobtitle()
    {
        return $this->itmjobtitle;
    }

     
    public function setItmjobtitle($itmjobtitle): Contact
    {
        $this->itmjobtitle = $itmjobtitle;
        return $this;
    }

     
    public function getItmcategory()
    {
        return $this->itmcategory;
    }

     
    public function setItmcategory($itmcategory): Contact
    {
        $this->itmcategory = $itmcategory;
        return $this;
    }

     
    public function getItmbdate()
    {
        return $this->itmbdate;
    }

     
    public function setItmbdate($itmbdate): Contact
    {

        $this->itmbdate = $this->getCalendarToDateTime($itmbdate);
        return $this;
    }

     
    public function getItmanniversary()
    {
        return $this->itmanniversary;
    }

     
    public function setItmanniversary($itmanniversary): Contact
    {
        $this->itmanniversary = $this->getCalendarToDateTime($itmanniversary);
        return $this;
    }

     
    public function getItmgender()
    {
        return $this->itmgender;
    }

     
    public function setItmgender($itmgender): Contact
    {
        $this->itmgender = $itmgender;
        return $this;
    }

     
    public function getItmspouse()
    {
        return $this->itmspouse;
    }

     
    public function setItmspouse($itmspouse): Contact
    {
        $this->itmspouse = $itmspouse;
        return $this;
    }

     
    public function getItminternetfreebusy()
    {
        return $this->itminternetfreebusy;
    }

     
    public function setItminternetfreebusy($itminternetfreebusy): Contact
    {
        $this->itminternetfreebusy = $itminternetfreebusy;
        return $this;
    }

     
    public function getItmprofession()
    {
        return $this->itmprofession;
    }

     
    public function setItmprofession($itmprofession): Contact
    {
        $this->itmprofession = $itmprofession;
        return $this;
    }

     
    public function getItmdepartment()
    {
        return $this->itmdepartment;
    }

     
    public function setItmdepartment($itmdepartment): Contact
    {
        $this->itmdepartment = $itmdepartment;
        return $this;
    }

     
    public function getItmassistantname()
    {
        return $this->itmassistantname;
    }

     
    public function setItmassistantname($itmassistantname): Contact
    {
        $this->itmassistantname = $itmassistantname;
        return $this;
    }

     
    public function getItmmanagername()
    {
        return $this->itmmanagername;
    }

     
    public function setItmmanagername($itmmanagername): Contact
    {
        $this->itmmanagername = $itmmanagername;
        return $this;
    }

     
    public function getItmofficelocation()
    {
        return $this->itmofficelocation;
    }

     
    public function setItmofficelocation($itmofficelocation): Contact
    {
        $this->itmofficelocation = $itmofficelocation;
        return $this;
    }

     
    public function getItmdescription()
    {
        return $this->itmdescription;
    }

     
    public function setItmdescription($itmdescription): Contact
    {
        $this->itmdescription = $itmdescription;
        return $this;
    }

     
    public function getItmsharetype()
    {
        return $this->itmsharetype;
    }

     
    public function setItmsharetype($itmsharetype): Contact
    {
        $this->itmsharetype = $itmsharetype;
        return $this;
    }

     
    public function getItmdescformat()
    {
        return $this->itmdescformat;
    }

     
    public function setItmdescformat($itmdescformat): Contact
    {
        $this->itmdescformat = $itmdescformat;
        return $this;
    }

     
    public function getItmtitle()
    {
        return $this->itmtitle;
    }

     
    public function setItmtitle($itmtitle): Contact
    {
        $this->itmtitle = $itmtitle;
        return $this;
    }

     
    public function getItmfirstname()
    {
        return $this->itmfirstname;
    }

     
    public function setItmfirstname($itmfirstname): Contact
    {
        $this->itmfirstname = $itmfirstname;
        return $this;
    }

     
    public function getItmmiddlename()
    {
        return $this->itmmiddlename;
    }

     
    public function setItmmiddlename($itmmiddlename): Contact
    {
        $this->itmmiddlename = $itmmiddlename;
        return $this;
    }

     
    public function getItmsurname()
    {
        return $this->itmsurname;
    }

     
    public function setItmsurname($itmsurname): Contact
    {
        $this->itmsurname = $itmsurname;
        return $this;
    }

     
    public function getItmsuffix()
    {
        return $this->itmsuffix;
    }

     
    public function setItmsuffix($itmsuffix): Contact
    {
        $this->itmsuffix = $itmsuffix;
        return $this;
    }

     
    public function getCtz()
    {
        return $this->ctz;
    }

     
    public function setCtz($ctz): Contact
    {
        $this->ctz = $ctz;
        return $this;
    }

    protected function afterLoad(): void
    {
             }

     
    public function getItmId()
    {
        return $this->evnId;
    }

     
    public function setItmId($itmId): void
    {
        $this->setId($itmId);
    }

     
    public function getItmgrpId()
    {
        return $this->itmgrpId;
    }

     
    public function setItmgrpId($itmgrpId): void
    {
        $this->itmgrpId = $itmgrpId;
    }

     
    public function getLctemail1()
    {
        return $this->lctemail1;
    }

     
    public function setLctemail1($lctemail1): void
    {
        $this->lctemail1 = $lctemail1;
    }

     
    public function getLctemail2()
    {
        return $this->lctemail2;
    }

     
    public function setLctemail2($lctemail2): void
    {
        $this->lctemail2 = $lctemail2;
    }

     
    public function getLctemail3()
    {
        return $this->lctemail3;
    }

     
    public function setLctemail3($lctemail3): void
    {
        $this->lctemail3 = $lctemail3;
    }

     
    public function getLcttype()
    {
        return $this->lcttype;
    }

     
    public function setLcttype($lcttype): void
    {
        $this->lcttype = $lcttype;
    }

     
    public function getItmclass()
    {
        return $this->itmclass;
    }

     
    public function setItmclass($itmclass): void
    {
        $this->itmclass = $itmclass;
    }

     
    public function getItmfolder()
    {
        return $this->itmfolder;
    }

     
    public function setItmfolder($itmfolder): void
    {
        $this->itmfolder = $itmfolder;
    }
}
