<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Node;

class Certificate extends Attachment
{
    protected $passphrase;
    protected $content;

     
    public function getPassphrase()
    {
        return $this->passphrase;
    }

     
    public function setPassphrase(
                 $passphrase
    ): Certificate
    {
        $this->passphrase = $passphrase;
        return $this;
    }

     
    public function addToICalendar(Component $vComponent) : void
    {
        if(empty($this->content)){
            if(!openssl_pkcs12_read(file_get_contents($this->getFileLocation()), $cert_info, $this->getPassphrase())) return;
            $this->content = $cert_info['cert'];
        }
        $attach = $vComponent->add('KEY', $this->content, ['VALUE' => 'BINARY']);
        $attach['ENCODING'] = 'BASE64';
    }

     
    public function fillFromVObject(Node $vObject) : void
    {
        $this->content = (string)$vObject;
    }
}