<?php

namespace server\model;

use Sabre\VObject\Component;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use server\inc\gw\Search;

 
class Attendee extends AGwEventItem implements ISubItem
{
    protected $cntcontactname;
    protected $cntemail;
    protected $cntrole;
    protected $cntstatus;
    protected $cntId;
    public $removed = false;

    CONST TYPE = '';

    public static $skipVariablesExportFE = [
        '_tzid',
        'removed',
    ];

    public function addToICalendar(Component $vComponent): void
    {
                 $attendee = $vComponent->add('ATTENDEE', 'mailto:' . $this->getCntemail());
        $attendee['CN'] = $this->getCntcontactname();
        $attendee['ROLE'] = $this->getCntrole();
        $attendee['RSVP'] = 'TRUE';
        $attendee['PARTSTAT'] = $this->getCntstatus();
    }

    public static function createFromXML(\Folder $folder, string $xml, bool $save = false, AGwEventItem $parent = null)
    {
         
        $attendee = parent::createFromXML($folder, $xml, $save, $parent);
        $simpleXml = simplexml_load_string($xml);
        if(empty($attendee->getId())){
            if(isset($simpleXml->attributes()->uid)){
                $attendee->setId((string)$simpleXml->attributes()->uid);
                $attendee->removed = true;
            }else{
                $attendee->setId($attendee->getCntemail());
            }
        }
        return $attendee;
    }

    public function fillFromVObject(Node $vObject)
    {
        $this->setCntemail(str_replace('mailto:', '', (string)$vObject));
        $this->setCntcontactname((string)$vObject['CN']);
        $this->setCntrole((string)$vObject['ROLE']);
        $this->setCntstatus((string)$vObject['PARTSTAT']);
        $this->setCntId($this->getCntemail());
    }

    public function getId()
    {
        return $this->cntId;
    }

    public function setId($value)
    {
        $this->cntId = $value;
        return $this;
    }

     
    public function getCntcontactname()
    {
        return $this->cntcontactname;
    }

     
    public function setCntcontactname($cntcontactname): Attendee
    {
        $this->cntcontactname = $cntcontactname;
        return $this;
    }

     
    public function getCntemail()
    {
        return $this->cntemail;
    }

     
    public function setCntemail($cntemail): Attendee
    {
        $this->cntemail = $cntemail;
        return $this;
    }

     
    public function getCntrole()
    {
        return $this->cntrole;
    }

     
    public function setCntrole($cntrole): Attendee
    {
        if($cntrole == 'Q') $cntrole = 'REQ-PARTICIPANT';
        $this->cntrole = $cntrole;
        return $this;
    }

     
    public function getCntstatus()
    {
        if(empty($this->cntstatus)) return 'B';
        return $this->cntstatus;
    }

     
    public function setCntstatus($cntstatus): Attendee
    {
        if($cntstatus == 'ACCEPTED') $cntstatus = 'A';
        $this->cntstatus = $cntstatus;
        return $this;
    }

     
    public function getCntId()
    {
        return $this->cntId;
    }

     
    public function setCntId($cntId): Attendee
    {
        $this->cntId = $cntId;
        return $this;
    }

    public function save(): AGwEventItem
    {
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $folderSessionId = $this->getFolder()->openAccess();
        if(!empty($this->getCntemail()) && $this->getCntemail() != '__@@groupchat@@__' && !\slIOVariable::isEmail($this->getCntemail())){
            throw new \Exc('attendee_email_invalid',$this->getCntemail().'|'.$this->getId());
        }
        if(!$this->prepareParamLine()){
            return false;
        }
        $gwApi->FunctionCall('addEventContact', $folderSessionId, $this->getParent()->getId(), $this->getParamLine());
        return $this;
    }

    public function getICalendar(): string
    {
        return '';
    }

    public function getType(): string
    {
        return '';
    }

    protected function afterLoad(): void
    {
             }


     
    public static function getControlInterface(): string
    {
        return '';
    }

     
    public static function getLoadingFunction(): string
    {
        return '';
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }
}