<?php

namespace server\model;

use GroupWareFolder;
use Sabre\VObject\Component;
use Sabre\VObject\Document;
use Sabre\VObject\Node;
use server\inc\gw\Search;
use tools\SearchParserYoda;

 
class Attachment extends AGwEventItem implements ISubItem
{
    protected $class;
    protected $description;
    protected $size;
    protected $fullpath;
    protected $fileLocation;
    protected $cid;
    protected $fileType;
    protected $attType;
    protected $name;
    protected $params;
    protected $type;
    protected $orientation;
    protected $height;
    protected $width;
    protected $fileContent;
    protected $part_id;
    protected $atttime;
    protected $url = '';
    public $isMail = false;
    public $isSmart = false;
    public $removed = false;
    protected $locationGenerated = false;
    public $data;

    protected static $skipVariablesExport = [
        'fileContent',
        'part_id',
        'isMail',
    ];

    protected static $skipVariablesExportFE = [
        '_tzid',
    ];

    protected static $renameVariablesExportFE = [
        'class' => 'atttype',
        'attType' => 'type',
    ];

    CONST TYPE = '';

     
    protected function base64File(string $filePath) : string
    {
        $result = '';
        $handle = @fopen($filePath, "rb");
        while(!feof($handle))
        {
            $plain = fread($handle, 57 * 143);
            $encoded = base64_encode($plain);
            $result .= chunk_split($encoded, 76, PHP_EOL.'  ');
        }
        return $result;
    }

     
    public function addToICalendar(Component $vComponent) : void
    {
        if(!filter_var($this->getFileLocation(), FILTER_VALIDATE_URL)){
                         $this->addToICalendarFilePath($vComponent);
            return;
        }
        $attach = $vComponent->add('ATTACH', $this->getFileLocation(), ['VALUE' => 'TEXT']);
        $attach['X-FILENAME'] = $this->getDescription();
        $attach['FMTTYPE'] = $this->getFileType();
    }

    protected function addToICalendarFilePath(Component $vComponent) : void
    {
        $attach = $vComponent->add('ATTACH', 'IW_FILEPATH:' . $this->getFileLocation());
        $attach['X-FILENAME'] = $this->getDescription();
        $attach['FMTTYPE'] = $this->getFileType();
    }

    public static function createFromXML(\Folder $folder, string $xml, bool $save = false, AGwEventItem $parent = null)
    {
         
        
        $attachment = parent::createFromXML($folder, $xml, $save, $parent);
        $simpleXml = simplexml_load_string($xml);
        if(empty($attachment->getId())){
            if(isset($simpleXml->attributes()->uid)){
                $attachment->setId((string)$simpleXml->attributes()->uid);
                $attachment->removed = true;
            }else{
                $attachment->setId($attachment->getDescription());
            }
        }
        return $attachment;
    }

     
    protected function addToICalendarBase64(Component $vComponent) : void
    {
        $attach = $vComponent->add('ATTACH', file_get_contents($this->getFileLocation()), ['VALUE' => 'BINARY']);
        $attach['X-FILENAME'] = $this->getDescription();
        $attach['FMTTYPE'] = $this->getFileType();
        $attach['ENCODING'] = 'BASE64';
    }

     
    public function getICalendar() : string
    {
        $result = ['ATTACH'];
        $result[] = 'X-FILENAME=' . $this->getDescription();
        $result[] = 'FMTTYPE=' . $this->getFileType();
        $result[] = 'IW_FILEPATH=' . $this->getFileLocation();
        $result = implode(';', $result);
        return $result;
    }

    public function getType(): string
    {
        return '';
    }

     
    public function fillFromVObject(Node $vObject) : void
    {
        $this->setFileLocation((string)$vObject);
        $this->setDescription((string)$vObject['X-FILENAME']);
        $this->setId((string)$vObject['X-FILENAME']);
        $this->setName((string)$vObject['X-FILENAME']);
        $this->setFileType((string)$vObject['FMTTYPE']);
        $this->setSize((string)$vObject['X-SIZE']);
        $this->setAtttime((string)$vObject['X-TIME']);
    }

     
    protected function generateFileLocation() : void
    {
        if($this->locationGenerated) return;
         
        $gwApi = $this->getFolder()->account->gwAPI;
        $attData = \Tools::parseFullPath(urldecode($this->getFullpath()), $this->getClass());

        if(!empty($attData['account']) && ($this->getClass() == 'item' || $this->getClass() == 'attachment')){
            $oAccount = $_SESSION['user']->getAccount($attData['account']);
            $targetFolder = $oAccount->getFolder($attData['folder']);
            if($targetFolder->getType() == 'M'){
                 
                $mailItem = $targetFolder->getItem($attData['item']);
                if(!empty($attData['part'])){
                    $ifile = $mailItem->getAttachmentDataFile($attData['part']);
                }else{
                    $ifile = $mailItem->getMessageFile();
                }
                if(!file_exists($ifile)){
                    $ifile = $mailItem->autoCreateMessage($ifile);
                }
                $this->setFileLocation($ifile);
            }else{
                $folderSessionId = $this->getFolder()->openAccess();
                $this->setFileLocation($gwApi->FunctionCall("GetAttachmentPathLocal", $folderSessionId, $attData['item'], $this->getDescription()));
            }
        }elseif($this->getClass() == 'file'){
            $this->setFileLocation($_SESSION['user']->getAttachments($attData['folder'], $attData['item'])['file']);
        }else{
            $this->setFileLocation($this->getFullpath());
        }
        $this->setSize(filesize($this->getFileLocation()));
        $this->locationGenerated = true;
    }

     
    public function getFileLocation() : string
    {
        if (empty($this->fileLocation)) {
            $this->generateFileLocation();
        }
        return $this->fileLocation;
    }

     
    public function setFileLocation($fileLocation): Attachment
    {
        $this->fileLocation = $fileLocation;
        return $this;
    }

     
    public function getClass()
    {
        if(!empty($this->class)) return $this->class;
        if($this->getAttType() == 'T') return $this->class = 'thumbnail';
        if($this->getAttType() == 'D') return $this->class = 'pdf';
        if($this->getAttType() == 'I') return $this->class = 'itemlink';
        if($this->getAttType() == 'U') return $this->class = 'url';
        if($this->getAttType() == 'P') return $this->class = 'P';
        return $this->class = 'attachment';
    }

     
    public function setClass($class): Attachment
    {
        $this->class = $class;
        return $this;
    }

     
    public function getDescription()
    {
        return $this->description;
    }

     
    public function setDescription($description): Attachment
    {
        $this->description = $description;
        return $this;
    }

     
    public function getSize()
    {
        return $this->size;
    }

     
    public function setSize($size): Attachment
    {
        $this->size = $size;
        return $this;
    }

     
    public function getFullpath()
    {
        return $this->fullpath;
    }

     
    public function setFullpath($fullpath): Attachment
    {
        $this->fullpath = $fullpath;
        return $this;
    }

     
    public function getCid()
    {
        return $this->cid;
    }

     
    public function setCid($cid): Attachment
    {
        $this->cid = $cid;
        return $this;
    }

     
    public function getFileType()
    {
        if(empty($this->fileType) && !empty($this->fileLocation)){
            $this->setFileType('mimetype=' . \mime_content_type($this->getFileLocation()));
        }
        return 'mimetype=' . $this->fileType;
    }

     
    public function setFileType($fileType): Attachment
    {
        $this->fileType = $fileType;
        return $this;
    }

     
    public function save() : AGwEventItem
    {
        $this->saveOld();
        return $this;
    }

    public function attachItem($account, $folder, $item, $description, &$mimeType = '',&$size = '')
    {
        $attAccount = $_SESSION['user']->getAccount($account);
        $attFolder = $attAccount->getFolder($folder);
        $attItem = $attFolder->getItem($item);
        $info = array();
                 if ($attFolder->gw) {
            if((string) $attItem->item['EVNCLASS'] == 'F' || (string) $attItem->item['EVNCLASS'] == 'M'){
                $addons  = $attItem->getAddons();
                $attachment = $addons['attachment'];
                $data = $attachment->getData();
                @$data = reset($data);
                $description = $description?$description:$data['ATTDESC'];
                $file = $attachment->getAttachmentFile($data['ATTNAME']);
                $size = filesize($file);
                $ext = substr($data['ATTNAME'],strrpos($data['ATTNAME'],'.'));
                $mimeType = \Tools::parseURL($data['ATTPARAMS']);
                $mimeType = (string) $mimeType['mimetype'];
            }else{
                $value = $attItem->getVersitObject($info);
                $size = strlen($value);
                $file = \Tools::randomFilename();
                \slSystem::import('tools/icewarp');
                \slToolsIcewarp::iw_file_put_contents($file,$value);
                $ext = (string) $info['fileext'];
                $mimeType = (string) $info['mimetype'];
            }
                     } else {
            $file = $attItem->getMessageFile();
            if(!file_exists($file)) $file = $attItem->autoCreateMessage($file);
            $size = filesize($file);
            $ext = messageext;
            $mimeType =  'message/rfc822';
        }

                 if(preg_match("/\\".$ext."$/i",$description)){
            $ext = '';
        }
        $now = $this->getEvnCreated(false);
        $param = array();
        $param['AttName'] = $description ? $description . $ext : md5($attItem->itemID . $now);
        $param['AttType'] = 'F';
        $param['AttDesc'] = $description . $ext;
        $param['AttSize'] = $size;
        $param['AttTime'] = $now;
        $param['AttParams'] = \Tools::createURL(array('mimetype' => $mimeType));
        $this->gwAddAttachment($param, $file);
    }

    protected function attachFile($path, $filename, $mimeType, $fcontent = '', $attType = 'F',$description = '')
    {
        if ($fcontent) {
            $path = false;
        } else {
            if (!is_file($path)) throw new \Exc('attachment_file_not_found', 'file_missing|' . $this->getId());
        }
        $param['AttDesc'] = $description ? : $filename;
        if($this->isMail){
            $param['AttName'] = $description ? : $filename;
        }else{
            $param['AttName'] = $this->parent->getEvntitle() ? : (($description) ? : $filename);
        }
        $param['AttType'] = $attType;
        $param['AttSize'] = filesize($path);
        $param['AttTime'] = $this->getParent()->getEvnCreated(false);
        $param['AttParams'] = \Tools::createURL(array('mimetype' => $mimeType));

        $this->gwAddAttachment($param, $path);
    }

    protected function gwAddAttachment($param, $filePath)
    {
        $oAccount = $this->getFolder()->account;

                 $attName = $param['AttDesc'] ? $param['AttDesc'] : $param['AttName'];
                 $param['AttSkipValue'] = 1;
        $param = $oAccount->gwAPI->CreateParamLine($param);
        $this->setId($oAccount->gwAPI->FunctionCall("AddAttachment", $this->getFolderSessionId(), $this->getParent()->getId(), $param, ''));
        if(empty($this->getId())){
            $lastError = $oAccount->gwAPI->FunctionCall("GetLastError",$oAccount->gwAPI->sessid);
            throw new \Exc('attachment_add',\MerakGWAPI::getGwErrorMessage($lastError).'|'.$this->getParent()->getId().'|'.$attName);
        }

        $path = $oAccount->gwAPI->FunctionCall("GetAttachmentPathLocal", $this->getFolderSessionId(), $this->getParent()->getId(), $this->getId(), 'LOCK');
        \slSystem::import('tools/icewarp');
        log_buffer("Copying $filePath to $path size: ".filesize($filePath),"EXTENDED");
        \slToolsIcewarp::iw_copy($filePath, $path);
        if(!$oAccount->gwAPI->FunctionCall("GetAttachmentPathLocal", $this->getFolderSessionId(), $this->getParent()->getId(), $this->getId(), 'UNLOCK')){
            $lastError = $oAccount->gwAPI->FunctionCall("GetLastError",$oAccount->gwAPI->sessid);
            $oAccount->gwAPI->FunctionCall("DeleteAttachments",$this->getFolderSessionId(), $this->getParent()->getId(), $this->getId());
            throw new \Exc('attachment_add', \MerakGWAPI::getGwErrorMessage($lastError).'|'.$this->getParent()->getId().'|'.$attName);
        }
        if(in_array($this->getFolder()->getType(), ['F', 'I']) && $this->getClass() == 'file' && strpos($this->getFileLocation(), DIRECTORY_SEPARATOR . '~webmail/~upload/') !== false && preg_match('/\\d{4}-\\d{2}-\\d{2}-[^\\/]+\\/[^\\/]+/', $this->getFullpath())){
            $this->getGwApi()->FunctionCall('addEventReference', $this->getFolderSessionId(), $this->getParent()->getId());
        }
        $this->setFileLocation($path);
    }

    public function attachAttachment($account, $folder, $item, $partid, $description = false, &$mimeType = '',&$size = '')
    {
        $attAccount = $_SESSION['user']->getAccount($account);
        $attFolder = $attAccount->getFolder($folder);
        $attItem = $attFolder->getItem($item);
        $info = array();
        $file = $attItem->getAttachmentDataFile($partid, $info);
        $now = time();
        $param = array();
        $param['AttDesc'] = $this->parent->getEvntitle() ? : $description;
        $param['AttName'] = $this->parent->getEvntitle() ? : $description;
        $param['AttType'] = 'F';
        $param['AttSize'] = filesize($file);
        $param['AttTime'] = $now;
        $param['AttParams'] = \Tools::createURL(array('mimetype' => $info['mimetype']));
        $mimeType = $info['mimetype'];
        $size = $param['AttSize'];

        if ($description)
            $param['AttDesc'] = $description;

        $this->gwAddAttachment($param, $file);
    }

    public function saveOld()
    {
        $result = [];
        $attData = \Tools::parseFullPath(urldecode($this->getFullpath()), $this->getClass());
        $aData = [];
                 switch ($this->getClass()) {
                         case 'file':
                $attachItems = $_SESSION['user']->getAttachments($attData['folder']);
                $attachItem = $attachItems[$attData['item']];
                if('application/octet-stream' == ($attachItem['type'] ?? null)){
                    $attachItem['type'] = 'text/plain';
                }
                $this->attachFile($attachItem['file'], $attachItem['name'], $attachItem['type'], '', $this->getAttType(), $this->getDescription());
                break;
            case 'item':
                $this->attachItem($attData['account'], $attData['folder'], $attData['item'], $this->getDescription(),$result['type'],$result['size']);
                break;
            case 'file_attachment':
                                                  break;
            case 'attachment':
                 
                $this->attachAttachment($attData['account'], $attData['folder'], $attData['item'], $attData['part'], $aData['description'], $result['type'],$result['size']);
                break;
            case 'itemlink':
                                                  break;
            case 'image':
                $attachItems = $_SESSION['user']->getAttachments($attData['folder']);
                $attachItem = $attachItems[$attData['item']];
                $this->attachFile($attachItem['file'], $attachItem['name'], $attachItem['type'], '', 'P',$aData['description']);

                                                  break;
            case 'document':
                $mimetypes = array(
                    'txt'=>'text/plain',
                    'html'=>'text/html',
                    'htm'=>'text/html',
                    'pptx'=>'application/vnd.openxmlformats-officedocument.presentationml.presentation',
                    'xlsx'=>'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                    'docx'=>'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
                );
                $attachItem['AttDesc'] = $this->getDescription();
                $attachItem['AttName'] = $this->getDescription();
                $attachItem['AttType'] = 'F';
                $attachItem['AttTime'] = time();
                $ext = substr($this->getDescription(),strrpos($this->getDescription(),'.')+1);
                $ext = strtolower($ext);
                $mimetype = $mimetypes[$ext];
                $attachItem['AttParams'] = \Tools::createURL(array('mimetype' => $mimetype));
                switch($ext){
                    case 'pptx':
                    case 'xlsx':
                    case 'docx':
                        $template = $this->getBlankDocumentFile($_SESSION['LANGUAGE'],$ext);
                        $size = filesize($template);
                        $attachItem['AttSize'] = $size;
                        $this->gwAddAttachment($attachItem, $template);
                        break;
                    default:
                        $attachItem['AttSize'] = 0;
                        $this->gwAddAttachment($attachItem, '');
                        break;


                                         }
                $result['size'] = $attachItem['AttSize'];
                $result['type'] = $mimetype;
                break;
            case 'url':
                                                  break;
        }
        if(isset($result['size']) && ($this->getFolder()->getType() == 'I' || $this->getFolder()->getType()=='F')) {
                     }
    }

    public function getBlankDocumentFile($language, $ext)
    {
        $root = getcwd().'/inc/templates/document/';
        if(file_exists($root.$language.'/new.'.$ext)){
            $template = $root.$language.'/new.'.$ext;
        }else{
            $template = $root.'default/new.'.$ext;
        }
        return $template;
    }

    protected function afterLoad(): void
    {
             }

     
    public function getAttType(bool $allowEmpty = false)
    {
        return $this->attType ?? ($allowEmpty ? null : 'F');
    }

     
    public function setAttType($attType): Attachment
    {
        $this->attType = $attType;
        return $this;
    }

     
    public function setType($attType): Attachment
    {
        $this->attType = $attType;
        return $this;
    }

    public static function getControlInterface(): string
    {
        return 'IHasAttachments';
    }

    public static function getLoadingFunction(): string
    {
        return 'addAttachmentsFromGW';
    }

     
    public function getName()
    {
        return $this->name;
    }

     
    public function setName($name): Attachment
    {
        $this->name = $name;
        return $this;
    }

     
    public function getDesc()
    {
        return $this->description;
    }

     
    public function setDesc($desc): Attachment
    {
        $this->description = $desc;
        return $this;
    }

     
    public function getParams()
    {
        return $this->params;
    }

     
    public function setParams($params): Attachment
    {
        $this->params = $params;
        return $this;
    }

     
    public function getOrientation()
    {
        return $this->orientation;
    }

     
    public function setOrientation($orientation): Attachment
    {
        $this->orientation = $orientation;
        return $this;
    }

     
    public function getHeight()
    {
        return $this->height;
    }

     
    public function setHeight($height): Attachment
    {
        $this->height = $height;
        return $this;
    }

     
    public function getWidth()
    {
        return $this->width;
    }

     
    public function setWidth($width): Attachment
    {
        $this->width = $width;
        return $this;
    }

     
    public function getFileContent()
    {
        if (empty($this->data)){
            if ($this->getSize() > 524288) return;
            $name = $this->getDescription() ?? $this->getName();
            $ext = strtolower(substr($name, strrpos($name, '.') + 1));
            if($ext == 'txt' || $ext == 'md'){
                $this->data = file_get_contents($this->getFileLocation());
            }elseif($ext == 'htm' || $ext == 'html'){
                \slSystem::import('tools/string');
                $enableExternalResources = false;
                if (isset($_SESSION['clientSettings']) && isset($_SESSION['clientSettings']['show_inline_images']) && true === $_SESSION['clientSettings']['show_inline_images']) {
                    $enableExternalResources = true;
                }
                $this->data = \slToolsString::basicSanitizeHTML(file_get_contents($this->getFileLocation()), $enableExternalResources);
            }
        }
        return $this->data;
    }

     
    public function getPartId()
    {
        return $this->part_id;
    }

     
    public function setPartId($part_id): Attachment
    {
        $this->part_id = $part_id;
        return $this;
    }

     
    public function getTemplateDataArray(array $allowEmpty = []): array
    {
        return [];
    }

     
    public function getAtttime()
    {
        return $this->atttime;
    }

     
    public function setAtttime($atttime): Attachment
    {
        $this->atttime = $atttime;
        return $this;
    }

      
    public function getIsSmart()
    {
        return $this->isSmart;
    }

      
    public function setIsSmart($isSmart)
    {
        $this->isSmart = $isSmart;

        return $this;
    }

      
    public function getUrl()
    {
        return $this->url;
    }

      
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }
}
