<?php


class WebmailRSA
{
	static private $instance;  	private $keyData = [];  	static private $serverKeysChecked = false;  
	static public function instance(){
		if(!isset(self::$instance)){
			self::$instance = new WebmailRSA();
		}
		return self::$instance;
	}

    public function rsaToPlain($rsa)
	{
		$plain = '';
		if($rsa){
			$privateData = $this->getServerData('private');
			$privateKey = openssl_pkey_get_private($privateData);
			openssl_private_decrypt(self::hexStringToBinary($rsa), $plain, $privateKey);
		}
		return $plain;
	}
	public function getServerData($type = 'private')
	{
		return $this->getKey($type);
	}

	public function checkServerKeys() 
	{
		$pair = [];
		if(is_file(WM_CONFIGPATH.'public.key') && filesize(WM_CONFIGPATH.'public.key') < 512){
			@unlink(WM_CONFIGPATH.'public.key');
			@unlink(WM_CONFIGPATH.'private.key');
		}
		 		if (!is_file(WM_CONFIGPATH.'private.key')) {
			$pair = icewarp_openssl_generate_RSA(2048);
			if (!file_exists(WM_CONFIGPATH)) {
				slSystem::import('tools/filesystem');
				slToolsFilesystem::mkdir_r(WM_CONFIGPATH);
			}
			
			$private = $pair['Private-PEM'];
			$public = ltrim($pair['modulus'],'0');
			if(!file_put_contents(WM_CONFIGPATH.'private.key', $private)){
				throw new Exc('rsa_create_key_pair_write_private');
			}
			if(!file_put_contents(WM_CONFIGPATH.'public.key', $public)){
				throw new Exc('rsa_create_key_pair_write_public');
			}
			$this->setKey('private',$private);
			$this->setKey('public', $public);
		}
		if (!is_file(WM_CONFIGPATH.'public.key')) {
			@unlink(WM_CONFIGPATH.'private.key');
			throw new Exc('rsa_create_key_pair');
		}
		return $pair;
	}

    public function checkLoginKeyPair()
	{
		$public = self::getServerData('public');
		$private = self::getServerData('private');
		$pkey = openssl_pkey_get_private($private);
		$details = openssl_pkey_get_details($pkey);
		$modulus = self::binaryToHexString(strrev($details['rsa']['n']));
		if($modulus!=$public){
			log_buffer("Invalid key-pair","EXTENDED");
			@unlink($publicfile);
			@unlink($privatefile);
			throw new Exc('login_invalid_keypair');
		}
	}
    static protected function binaryToHexString($binary)
	{
		$binary = strrev($binary);
		$valueToHexChar = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f');
		$binaryLength = strlen($binary);
		$result = '';
		for ($i = 0; $i < $binaryLength; $i++) {
			$result .= $valueToHexChar[ord($binary[$i]) >> 4];
			$result .= $valueToHexChar[ord($binary[$i]) & 0x0F];
		}
		return ltrim($result, '0');
	}

    static protected function hexStringToBinary($hexString) {
		$result = '';
		$hexStringLength = strlen($hexString ?? '');
		$i = 0;
		if ($hexStringLength % 2) {
			$result = chr(self::hexCharValue($hexString[0]));
			$i = 1;
		}
		for (; $i < $hexStringLength; $i += 2) {
			$result .= chr(self::hexCharValue($hexString[$i])*16 + self::hexCharValue($hexString[$i+1]));
		}
		return $result;
	}
	
	static protected function hexCharValue($hexChar) {
		if ($hexChar == '') return 0;
		if ($hexChar <= '9') {
			if ($hexChar >= '0') return ord($hexChar) - ord('0');
			throw new Exc('auth_invalid_char');
		} else if ($hexChar <= 'F') {
			if ($hexChar >= 'A') return ord($hexChar) - ord('A') + 10;
			throw new Exc('auth_invalid_char');
		} else if ($hexChar <= 'f') {
			if ($hexChar >= 'a') return ord($hexChar) - ord('a') + 10;
			throw new Exc('auth_invalid_char');
		}
		throw new Exc('auth_invalid_char');
	} 
	private function getKey($type)
	{
		$this->loadKeyFromFile($type);
		return $this->keyData[$type];
	}

	private function deleteKey($type)
	{
		if(isset($this->keyData[$type])){
			unset($this->keyData[$type]);
		}
	} 
	private function setKey($type, $data)
	{
		$this->keyData[$type] = $data;
	}

	protected function loadKeyFromFile($type)
	{
		$type = strtolower($type);
		if(!$this->serverKeysChecked){
			$this->checkServerKeys();
		}
		if(!$this->keyData[$type]){
			slToolsFilesystem::securePath($type);
			$this->keyData[$type] = file_get_contents(WM_CONFIGPATH.$type.'.key');
		}
	}
}

?>