<?php
 

function fullpath_sort($a,$b)
{
	$a1 = substr($a[2],strrpos($a[2],'.')+1);
	$b1 = substr($b[2],strrpos($b[2],'.')+1);
	return $a1 > $b1;
}

class WebmailIqMessage extends XMLRequestInterface
{
	public $sCharset = 'UTF-8';
	public $addrList;
	public $aAttrs;
	public $queryType;
	public $sAID;
	public $sFID;
	public $sIID;
	
	public $sFrom;
	public $sTO;
	public $sCC;
	public $sBCC;
	public $sSubject;
	public $sBody;
	
	public $bHTML;

	public $sSave;
	public $sSaveAccount;
	public $sSaveFolder;
	public $sSaveItem;

	public $bSaveToTeamChat;
	
	
	public $sSEmail;
	public $sSIM;
	
	public $sKA;
	
	public $bAutobook;
	public $bEncrypt;
	public $bSign;
	public $bRelay;
	public $bSmartAttach;

	public $sPhoneNumber;
	public $sExternalDevice;

	protected static $errors;

	public $oDOMQuery;
	public $bSmartAttachFolder;
	public $bSmartAttachAccount;
	public $bPassPhrase;
	public $oTeamChatRoom;
	public $oTeamchatComment;
	public $session_user;
	public $bAllowEmptyRecipient;
	public $sDeferred;
	public $SmartAttachAccount;
	public $SmartAttachFolder;
	public $SmartAttachEditable;
	public $bSmartAttachEditable;
	public $SmartAttachPassword;
	public $bSmartAttachPassword;
	public $SmartAttachExpire;
	public $bSmartAttachExpire;
	public $SmartAttachRights;
	public $oDOMMessage;
	public $sText;
	public $sAttachments;
	public $oDistrib;
	public $aEmbeddedAttachments;
	public $EA;
	public $oDOMAttachments;
	public $oDOMDoc;
	public $sPassPhrase;
	public $sRFCDate;
	public $aSMS;
	public $oDistribVal;
	public $smimeRecipients;
	public $bAutoABook;
	public $sSaveTeamchatAccount;
	public $sSaveTeamChatItem;
	public $sSaveTeamchatItem;
	public $sSaveTeamchatFolder;
	public $aBcc;
	public $bccDlAddrList;
	public $sSMS;
	public $isDraft;
	public $sEncrypt;
	public $sSign;
	public $sTeamChatRoom;
	public $sTeamChatComment;
	public $aFolderList;
	public $draftID;

	 
	public function __construct($oDOMQuery, &$oDOMDoc, &$attrs)
	{
		 		$this->oDOMQuery = $oDOMQuery;
		$this->oDOMDoc = &$oDOMDoc;
		$this->aAttrs = &$attrs;
		$this->addrList = array();
		$this->loadUser();
		$this->checkInputXML();
		$this->exeInputXML();
	}
	 
	private function checkInputXML()
	{
		 		if ($this->oDOMMessage = $this->oDOMDoc->getNode(
			'message:message', 
			$this->oDOMQuery
		)){
			$this->queryType = 'regular';
			$result = $this->checkMessageXML();
			 		} else {
			if ($this->oDOMMessage = $this->oDOMDoc->getNode(
				'message:dial', 
				$this->oDOMQuery
			)){
				$this->queryType = 'phonecall';
				$result = $this->checkDialXML();
			} else {
				throw new Exc('message_missing_tag', 'message');
			}
		}
		return $result;
	}

	private function checkDialXML()
	{
		if (!$oDOMAction = $this->oDOMDoc->getNode(
			'message:phone',
			$this->oDOMMessage
		)){
			throw new Exc('message_missing_tag', 'phone');
		}
		$this->sPhoneNumber = $this->oDOMDoc->getNodeValue(
			'message:phone', 
			$this->oDOMMessage
		);
		$userSettings = Storage::getUserData('sip');
		$domainSettings = Storage::getDomainDefaults('sip');
		$serverSettings = Storage::getDefaults('sip');
		$sipSettings = WebmailIqPrivate::get(
			'sip',
			$userSettings,
			$domainSettings,
			$serverSettings
		);
		$this->sExternalDevice = false;
		if($sipSettings['@childnodes']['item'][0]['@childnodes']['mode'][0]['@value']=='external'){	
			if(isset($sipSettings['@childnodes']['item'][0]['@childnodes']['dial'][0]['@value'])
			){
				$dial = $sipSettings['@childnodes']['item'][0]['@childnodes']['dial'][0]['@value'];
				if($dial){
					$this->sExternalDevice = $dial;
				}
			}
		}
		
		return true;
	}

	private function checkMessageXML()
	{
		$this->bAllowEmptyRecipient = false;
		if ($this->aAttrs['type'] == 'get') {
			$this->sAID = $this->oDOMMessage->getAttribute('account');
			$this->sFID = $this->oDOMMessage->getAttribute('folder');
			$this->sIID = $this->oDOMMessage->getAttribute('uid');
			if (!isset($this->sAID)){
				throw new Exc('message_missing_account_id');
			}
			if (!isset($this->sFID)){
				throw new Exc('message_missing_folder_id');
			}
			if (!isset($this->sIID)){
				throw new Exc('message_missing_item_id');
			}
			$this->aData['mid'] = $this->sIID;
		}
		if ($this->aAttrs['type'] == 'set')
		{
			 			if (!$oDOMAction = $this->oDOMDoc->getNode('message:action', $this->oDOMMessage))
				throw new Exc('message_missing_tag', 'action');
			 			if ($this->sSEmail = $this->oDOMDoc->getNode('message:send_as_email', $oDOMAction))
				$this->sSEmail = $this->oDOMDoc->getNodeValue('message:send_as_email', $oDOMAction) =='true' ? true : false;
			 			if ($this->sSIM = $this->oDOMDoc->getNode('message:send_as_im', $oDOMAction))
				$this->sSIM = $this->oDOMDoc->getNodeValue('message:send_as_im', $oDOMAction) ==
					'true' ? true : false;
			 			if ($this->sKA = $this->oDOMDoc->getNode('message:keep_attachments', $oDOMAction))
				$this->sKA = $this->oDOMDoc->getNodeValue('message:keep_attachments', $oDOMAction) ==
					'true' ? true : false;

			 			if ($this->bHTML = $this->oDOMDoc->getNode('message:html_body', $oDOMAction))
				$this->bHTML = $this->oDOMDoc->getNodeValue('message:html_body', $oDOMAction) ==
					'true' ? true : false;
			 			if ($this->bAutoABook = $this->oDOMDoc->getNode('message:auto_addressbook', $oDOMAction))
				$this->bAutoABook = $this->oDOMDoc->getNodeValue('message:auto_addressbook', $oDOMAction) ==
					'true' ? true : false;
			 			if ($oDOMSave = $this->oDOMDoc->getNode('message:save_to_folder', $oDOMAction)){
				$this->sSave = true;
			}else{
				$this->sSave = false;
			}
			 			if ($oDOMSaveToTeamchat = $this->oDOMDoc->getNode('message:save_to_teamchat', $oDOMAction)){
				$this->bSaveToTeamChat = true;
			}else{
				$this->bSaveToTeamChat = false;
			}
			 			if ($oDOMIncludeInSentFolder = $this->oDOMDoc->getNode('message:include_in_sent_folder', $oDOMAction)){
				$this->bIncludeInSentFolder = $this->oDOMDoc->getNodeValue('message:include_in_sent_folder', $oDOMAction) ==
					'1' ? true : false;
			}else{
				$this->bIncludeInSentFolder = false;
			}

			 			if ($this->sEncrypt = $this->oDOMDoc->getNode('message:encrypt', $oDOMAction))
				$this->sEncrypt = $this->oDOMDoc->getNodeValue('message:encrypt', $oDOMAction) ==
					'true' ? true : false;
			 			if ($this->sSign = $this->oDOMDoc->getNode('message:sign', $oDOMAction))
				$this->sSign = $this->oDOMDoc->getNodeValue('message:sign', $oDOMAction) ==
					'true' ? true : false;

			 			if ($this->sSave){
	
				 				if (!$this->sSaveAccount = $this->oDOMDoc->getNode('message:account', $oDOMSave))
					throw new Exc('message_missing_tag', 'account');
				$this->sSaveAccount = $this->oDOMDoc->getNodeValue('message:account', $oDOMSave);
				 				if (!$this->sSaveFolder = $this->oDOMDoc->getNode('message:folder', $oDOMSave))
					throw new Exc('message_missing_tag', 'folder');
				$this->sSaveFolder = $this->oDOMDoc->getNodeValue('message:folder', $oDOMSave);
				$oAccount = $_SESSION['user']->getAccount($this->sSaveAccount);
				$oFolder = $oAccount->getFolderWithAutoCreate($this->sSaveFolder, 'main');
				if($oFolder->isDraft()){
					$this->bAllowEmptyRecipient = true;
					$this->isDraft = true;
				}else{
					$this->isDraft = false;
				}
				 				if ($this->sSaveItem = $this->oDOMDoc->getNode('message:item', $oDOMSave)){
					$this->sSaveItem = $this->oDOMDoc->getNodeValue('message:item', $oDOMSave);
				}
			}
			 			if ($this->bRelay = $this->oDOMDoc->getNode('message:smtp_relay', $oDOMAction))
				$this->bRelay = $this->oDOMDoc->getNodeValue('message:smtp_relay', $oDOMAction) ==
					'true' ? true : false;
			 			if ($oDOMSmartAttach = $this->oDOMDoc->getNode('message:smartattach', $oDOMAction)){
				if ($this->oDOMDoc->getNode('message:process', $oDOMSmartAttach)){
					$this->bSmartAttach = $this->oDOMDoc->getNodeValue('message:process', $oDOMSmartAttach) ==
						'true' ? true : false;;
				}	
			}
			if ($this->bSmartAttach || $this->isDraft){
				 				if ($this->bSmartAttachFolder = $this->oDOMDoc->getNode('message:folder', $oDOMSmartAttach)){
					$this->SmartAttachFolder = $this->oDOMDoc->getNodeValue('message:folder', $oDOMSmartAttach);
				}
				 				if ($this->bSmartAttachAccount = $this->oDOMDoc->getNode('message:account', $oDOMSmartAttach)){
					$this->SmartAttachAccount = $this->oDOMDoc->getNodeValue('message:account', $oDOMSmartAttach);
				}
				if($this->SmartAttachFolder && !$this->SmartAttachAccount){
					$this->SmartAttachAccount = $_SESSION['EMAIL'];
				}
				 				if ($this->bSmartAttachExpire = $this->oDOMDoc->getNode('message:expire', $oDOMSmartAttach)){
					$this->SmartAttachExpire = $this->oDOMDoc->getNodeValue('message:expire', $oDOMSmartAttach);
				}
				 				if ($this->bSmartAttachPassword = $this->oDOMDoc->getNode('message:password', $oDOMSmartAttach)){
					$this->SmartAttachPassword = $this->oDOMDoc->getNodeValue('message:password', $oDOMSmartAttach);
				}
				$this->SmartAttachRights = 0;
				 				if ($this->bSmartAttachEditable = $this->oDOMDoc->getNode('message:editable', $oDOMSmartAttach)){
					$this->SmartAttachEditable = $this->oDOMDoc->getNodeValue('message:editable', $oDOMSmartAttach) ==
					'true' ? true : false;
					$this->SmartAttachRights = MerakGWAPI::getEditableRights($this->SmartAttachEditable);
				}
			}
			
			 			if ($this->sRFCDate = $this->oDOMDoc->getNode('message:rfc_date', $this->oDOMMessage))
				$this->sRFCDate = $this->oDOMDoc->getNodeValue('message:rfc_date', $this->oDOMMessage);
			 			if ($this->oDOMDoc->getNode('message:deferred_date', $this->oDOMMessage)){
				$this->sDeferred = $this->oDOMDoc->getNodeValue('message:deferred_date', $this->oDOMMessage);
			}
			 			if ($this->bPassPhrase = $this->oDOMDoc->getNode('message:passphrase', $this->oDOMMessage)){
				$sPassword = $this->oDOMDoc->getNodeValue('message:passphrase', $this->oDOMMessage);
				$this->sPassPhrase = $sPassword;
			}
			 			if (!$this->sSEmail && !$this->sSIM && !$this->sSave && !$this->bSaveToTeamChat)
				throw new Exc('message_invalid_action');
			 
			if ($this->sSMS = $this->oDOMDoc->getNode('message:sms', $this->oDOMMessage)){
				$this->sSMS = $this->oDOMDoc->getNodeValue('message:sms', $this->oDOMMessage);
				$this->bAllowEmptyRecipient = true;
			}
			$this->sSubject = $this->oDOMDoc->getNodeValue('message:subject', $this->oDOMMessage);
			$this->sBody = $this->oDOMDoc->getNodeValue('message:body', $this->oDOMMessage);
			$this->sText = $this->oDOMDoc->getNodeValue('message:text', $this->oDOMMessage);
			$this->sTO = $this->oDOMDoc->getNodeValue('message:to', $this->oDOMMessage);
			$this->sCC = $this->oDOMDoc->getNodeValue('message:cc', $this->oDOMMessage);
			$this->sBCC = $this->oDOMDoc->getNodeValue('message:bcc', $this->oDOMMessage);
			if($this->oDistrib = $this->oDOMDoc->getNode('message:distrib', $this->oDOMMessage)){
				$this->oDistribVal = $this->oDOMDoc->getNodeValue('message:distrib', $this->oDOMMessage);
			}
			if($this->oTeamChatRoom = $this->oDOMDoc->getNode('message:teamchat', $this->oDOMMessage)){
				$this->sTeamChatRoom = $this->oDOMDoc->getNodeValue('message:teamchat', $this->oDOMMessage);
			}
			 			if ($this->oTeamchatComment = $this->oDOMDoc->getNode('message:teamchat_comment', $this->oDOMMessage)){
				$this->sTeamChatComment = $this->oDOMDoc->getNodeValue('message:teamchat_comment', $this->oDOMMessage);
			}
			if (!$this->sFrom = $this->oDOMDoc->getNodeValue('message:from', $this->oDOMMessage))
				throw new Exc('message_missing_tag', 'from');
			 			if ($this->sSEmail && !$this->sTO && !$this->sCC && !$this->sBCC && !$this->oDistribVal && !$this->sSMS)
				throw new Exc('message_missing_tag', 'recipient(to,cc,bcc..)');
			
			if ($this->sSIM && !$this->sTO)
				throw new Exc('message_missing_tag', 'to');

			if ($this->oDOMAttachments = $this->oDOMDoc->getNode('message:attachments', $this->
				oDOMMessage))
				$this->sAttachments = true;
			else
				$this->sAttachments = false;

			if($this->isDraft && $this->sSaveItem){
				$this->draftID = $this->sSaveItem;
			}
			if($oDOMDraftID = $this->oDOMDoc->getNode('message:draft_id', $oDOMAction)){
				$this->draftID = $this->oDOMDoc->getNodeValue('message:draft_id', $oDOMAction);
			}
			 			if ($this->bSaveToTeamChat){
				 				if (!$this->sSaveTeamchatAccount = $this->oDOMDoc->getNode('message:account', $oDOMSaveToTeamchat))
					throw new Exc('message_missing_tag', 'account');
				$this->sSaveTeamchatAccount = $this->oDOMDoc->getNodeValue('message:account', $oDOMSaveToTeamchat);
				 				if (!$this->sSaveTeamchatFolder = $this->oDOMDoc->getNode('message:folder', $oDOMSaveToTeamchat))
					throw new Exc('message_missing_tag', 'folder');
				$this->sSaveTeamchatFolder = $this->oDOMDoc->getNodeValue('message:folder', $oDOMSaveToTeamchat);
				 				if ($this->sSaveTeamchatItem = $this->oDOMDoc->getNode('message:item', $oDOMSaveToTeamchat))
					$this->sSaveTeamchatItem = $this->oDOMDoc->getNodeValue('message:item', $oDOMSaveToTeamchat);
			}
		}

		return true;
	}
	 
	private function exeInputXML()
	{
		 		$oUser = &$_SESSION['user'];
		$this->session_user = $oUser;
		switch ($this->aAttrs['type'])
		{
			 			case 'get':
				if ($this->queryType !== 'regular')
					throw new Exc('message_get_not_allowed');
				$this->parseMessage($this->sPassPhrase);
				break;
			case 'set':
				switch ($this->queryType)
				{
					case 'regular':
						$this->sendMessage();
						break;
					case 'phonecall':
						$this->dialPhone();
						break;
				}
				break;
		}
	}

	 
	private function parseMessage(
		 		$passphrase = ''
	) {
		$oUser = &$this->session_user;
		 		$this->sTemplateFile = 'webmailiqmessage_get';
		 		$oAccount = $oUser->getAccount($this->sAID);
		$oFolder = $oAccount->getFolder($this->sFID);
		$oItem = $oFolder->getItem($this->sIID);
		 		$newMessage = false;
		$blocked = false;
		$aMessage = $oItem->parseMessage(true, '1', $newMessage, false, $blocked, false, false, false, $passphrase);
		 		$this->aData['body'] = $aMessage['plain_body'];
		if ($aMessage['attachments'][0])
			$this->aData['attachments']['num'] = $aMessage['attachments'];
		if ($aMessage['cc'])
			$this->aData['cc'] = $aMessage['cc'];
		if ($aMessage['bcc'])
			$this->aData['bcc'] = $aMessage['bcc'];
		if ($aMessage['reply_to'])
			$this->aData['reply_to'] = $aMessage['reply_to'];
		if ($aMessage['html_body'])
			$this->aData['html'] = $aMessage['html_body'];
		$this->aData['to'] = $oItem->to;
		$this->aData['from'] = $oItem->from;
		$this->aData['subject'] = $oItem->subject;
	}


	 
	private function sendMessage()
	{
		$oUser = &$this->session_user;
		$this->sTemplateFile = 'webmailiqmessage_set';
		$oMail = new Mail($this->sCharset, $this->bRelay, $this->bAllowEmptyRecipient);
		$oMail->PassPhrase = $this->sPassPhrase;
		$oMail->XMailer.='-Desktop';
		$oMail->DeferredDelivery = $this->sDeferred;
		$oMail->CipherStrength = $_SESSION['SMIME_CIPHER'];
		$oMail->isDraft = $this->isDraft;
		if($this->bSmartAttach || $this->isDraft){
			$oMail->SmartAttach = ($this->bSmartAttach || $this->isDraft);
			$smartAttachAccountString = $this->SmartAttachAccount?$this->SmartAttachAccount:$_SESSION['EMAIL'];
			$this->SmartAttachAccount = $oUser->getAccount($smartAttachAccountString);
			try{
				$smartAttachFolderString = $this->SmartAttachFolder?$this->SmartAttachFolder:'__@@UPLOAD@@__';
				$this->SmartAttachFolder = $this->SmartAttachAccount->getFolderWithAutocreate($smartAttachFolderString,'gw');

				 				if($this->SmartAttachFolder->getType()!='F'){
					$smartAttachFolderString = '__@@UPLOAD@@__';
					$this->SmartAttachFolder = $this->SmartAttachAccount->getFolderWithAutocreate($smartAttachFolderString,'gw');
				}
			}catch(Exc $e){
				throw new Exc('default_folder_missing', '__@@UPLOAD@@__');
			}
			Folder::checkRights($this->SmartAttachFolder,Folder::RIGHT_FOLDER_WRITE);
			$oMail->SmartAttachFolder = $smartAttachFolderString;
			$oMail->SmartAttachAccount = $smartAttachAccountString;
			$oMail->SmartAttachExpiration = $this->bSmartAttachExpire?strval(round(($this->SmartAttachExpire - time())/86400)):0;
			$oMail->SmartAttachPassword = $this->SmartAttachPassword;
			$oMail->SmartAttachRights = $this->SmartAttachRights;
		}
		 		$this->processAddrList( $oMail, 'to' );
		 		$this->processAddrList( $oMail, 'cc' );
		 		$this->processAddrList( $oMail, 'bcc' );
		
		if(strtolower($_SESSION['DBTYPE'])!='sqlite'){
			log_buffer("WebmailIQMessage->execFinalMessageAction(SEND) SESSION WRITE CLOSE","EXTENDED");
			User::closeSession();
		}
		$aFrom = MailParse::parseAddresses($this->sFrom);
		$oMail->setFrom($aFrom[0]['address'], $aFrom[0]['display'], true);
		 		$this->aFolderList = array();
		 		if ($this->sSubject || ($this->sSubject === '0'))
			$oMail->setSubject($this->sSubject);
		 		if ($oDOMXHeader = $this->oDOMDoc->getNode('message:custom_headers', $this->
			oDOMMessage))
		{
			foreach ($this->oDOMDoc->query('//message:header', $oDOMXHeader) as $oDOMXHeaderNode)
			{
				$aHeaderArr = Tools::makeArrayFromXML($oDOMXHeaderNode);
				$aHeaderArr['#text'] = Tools::cr2crlf($aHeaderArr['#text']);
				$headerName = explode(':',$aHeaderArr['#text']);
				$headerName = strtolower(trim($headerName[0]));
				switch($headerName){
					case 'x-reply-fullpath':
					case 'x-forward-fullpath':
						break;
					default:
						$oMail->addHeader($aHeaderArr['#text']);
						break;
				}
			}
		}
		 		if (isset($this->sBody))
		{
			slSystem::import('tools/string');
			$plainBody = slToolsString::removeHTML($this->sBody);
			if ($this->bHTML){
				$this->processEmbeddedAttachments($oMail,$this->sSEmail);
				$oMail->SetBody($plainBody, $this->sBody);
			} else {
				$oMail->SetBody($plainBody);
			}
			unset($plainBody);
			unset($this->sBody);
		}
		
		if($this->sText){
			$plainBody = $this->sText;
			if($this->bHTML){
				slSystem::import('tools/string');
				$altBody = slToolsString::text2html($this->sText,true);
				$oMail->SetBody($plainBody,$altBody);
			}else{
				$oMail->SetBody($plainBody);	
			}
			unset($plainBody);
			unset($altBody);
			unset($this->sText);
		}
		
		 		if ($this->sAttachments)
			$this->processAttachments($oMail);

		 		if ($this->sSMS ){
			$this->aSMS = MailParse::parseAddresses($this->sSMS,true);
		}

		if(!$this->isDraft){
			 			foreach ($this->oDOMDoc->query('message:account', $this->oDistrib) as $dAccount)
			{
				$sAID = $dAccount->getAttribute('uid');
				 				foreach ($this->oDOMDoc->query('message:folder', $dAccount) as $dFolder)
				{
					$sFID = $dFolder->getAttribute('uid');
					self::processDistributedList('message', $oUser, $this->oDOMDoc, $sAID, $sFID, $dFolder,
						$oMail, $this);
				}
			}
		}
		 		 		if($this->sEncrypt){
			if(self::$errors['no_recipient_certificate']){
				throw new Exc(
					'no_recipient_certificate',
					implode(',',self::$errors['no_recipient_certificate'])
				);
			}
		}

		 		$this->execFinalMessageAction($oMail);
	}

	 

	public function processAddrList( &$oMail, $type )
	{
		slSystem::import('tools/php');
		$type = strtolower($type);
		$var = 's'.strtoupper($type);
		$func = 'add'.ucfirst($type);
		
		if($this->isDraft){	
			if($this->$var){
				$oMail->addHeader(ucfirst($type).': '.$this->$var);
			}
			return;
		}
		
		if ($this->$var)
		{
			$aArray = MailParse::parseAddresses($this->$var);
			
			if($aArray)foreach ($aArray as $key => $aItm)
			{
				 				if ($_SESSION['PRIMARY_DOMAIN_AUTOFILL'] && strpos($aItm['address'], '@') === false && $this->sSEmail)
				{
					if ($aArray[$key]['address'])
						$aArray[$key]['address'] .= '@' . $_SESSION['PRIMARY_DOMAIN'];
				}
				if($aItm['display'] == $aItm['address']){
					$aItm['display'] = '';
				}
				if($this->sEncrypt){
					slSystem::import('mail/smime');
					$rcp = $aArray[$key]['address'];
					$gwmanage = new GroupWareManagement();
					if($gwmanage->getEmailCertificates($rcp)){
						$oMail->$func($rcp, $aItm['display']);
						$this->smimeRecipients[] = $rcp;
					}else{
						self::$errors['no_recipient_certificate'][] = $rcp;
					} 
				}else{
					$oMail->$func($aArray[$key]['address'], $aItm['display']);
				}
			}
			@$this->addrList = slToolsPHP::array_merge($this->addrList, $aArray);
			if($type == 'bcc'){
				$this->aBcc = $aArray;
			}
		}
	}

	public static function processDistributedList($namespace, $oUser, $oDOMDoc, $accountID,
		$folderID, $oDOMFdr, &$oMail, &$iq)
	{
		$isTeamChat = false;
		$oAccount = $oUser->getAccount($accountID);
		$oFolder = $oAccount->getFolder($folderID);
		$aContactList = array();
		 		if($oFolder->getType()=='I'){
			$membersFolder = $oAccount->getFolder('__@@GROUP@@__/'.$folderID);
			$members = $membersFolder->getItems();
			$isTeamChat = true;
			foreach($members as $member){
				$aContactList[] = array(
									'email'=>$member->item['FRTEMAIL'],
									'name'=>$member->item['FRTNAME']
								);
			}
		}
		$aDest = array(0 => 'To', 1 => 'CC', 2 => 'BCC');
		$gw = new GroupWareManagement();

		foreach ($aDest as $dest)
		{
			foreach ($oDOMDoc->query($namespace . ':' . strtolower($dest), $oDOMFdr) as $dst)
			{
				
				 				if(!$isTeamChat){
					$aContactList = array();
					$value = $dst->nodeValue;
					$aLocations = $gw->getDistributionListItems($value,$oFolder);
					foreach ($aLocations as $location)
					{
						$aContactList[] = array(
											'email'=>$location['LCTEMAIL1'],
											'name'=>$location['LCTDESCRIPTION']
										);
					}
				}
				foreach ($aContactList as $contact)
				{
					$email = $contact['email'];
					$methodName = 'add' . $dest;
					if (strtolower($email) != 'undefined'){
						$error = false;
						if($iq->sEncrypt){
							slSystem::import('mail/smime');
							$gwmanage = new GroupWareManagement();
							if($gwmanage->getEmailCertificates($email)){
								$iq->smimeRecipients[] = $email;
							}else{
								$error = true;
								self::$errors['no_recipient_certificate'][] = $email;
							} 
						}
						if(!$error){
							$oMail->$methodName($email);
							$iq->dlAddrList[] = $email;
							if(strtoupper($dest) == 'BCC'){
								$iq->bccDlAddrList[] = array(
									'address'=>$email,
									'display'=>$contact['name']
								);
							}
						}
					}
				}
			}
		}
	}

	 
	private function processEmbeddedAttachments(&$oMail,$send = false)
	{
		$this->sBody = preg_replace('/-.._._.--.._[0-9]{0,}\//si','',$this->sBody);
		$this->aEmbeddedAttachments = array();
		$this->clearSessionMailCache = $this->replaceEmbeddedAttachments($oMail,$send);
	}
	
	private function replaceEmbeddedAttachments(&$oMail,$send = false)
	{
		$result = false;
		 
		$absolute = User::getWebmailURL(DOWNLOAD_PHP);
		$prefixmatch = '('.preg_quote(DOWNLOAD_PHP).
						'|'.preg_quote($absolute).
						'|'.preg_quote($this->getDottedURI()).')';
		$urlmatch = 'src\="('.$prefixmatch. '\?(?:(?:sid=' . preg_quote(urlencode($this->aAttrs['sid'])).')|(?:dlsess=' . $this->aAttrs['dlsess'].')))';
		$pos = 0;
		while(preg_match('#'.$urlmatch.'#si',$this->sBody,$matches,PREG_OFFSET_CAPTURE,$pos)){
			$start = $matches[1][1];
			$end = strpos($this->sBody, '"', $start);
			if ($end === false)
				break;
			$start2 = $start + strlen($matches[1][0]);
			$sUrl = str_replace("&amp;", "&", substr($this->sBody, $start2, $end - $start2));
			$data = Tools::parseURL($sUrl);
			if ($data['class'] && $data['fullpath'])
			{
				$uid = $data['class'].'#'.$data['fullpath'];
				if(!$this->EA[$uid]){
					if($data['class']=='cid'){
						$pathData = Tools::parseFullPath($data['fullpath'],$data['class']);
						$cid = urldecode($pathData['part']);
					}else{
						$cid = strval(Tools::my_uniqid(rand(), true));
					}
					$addAttachments[] = $cid;
					try{
						$this->addAttachment($oMail,'embedded', $data['class'], $data['fullpath'], $cid); 
					}catch(Exc $e){
					}
					if(isset($oMail->inlineAttachmentsCidDedup[$cid])) $cid = $oMail->inlineAttachmentsCidDedup[$cid];
					$this->EA[$uid] = $cid;
				}else{
					$cid = $this->EA[$uid];
				}
				$this->sBody = substr_replace($this->sBody, 'cid:' . $cid, $start, $end - $start);
			}
			$pos = $start + strlen('cid:'.$cid);
		}
		 		$match = 'src="(\/?client\/skins\/default\/images\/smiles\/'.
				'(activity|flags|food|nature|objects|people|places|symbols)\/([^"]+))';
		$matches = array();
		$pos = 0;
		while(preg_match('#'.$match.'#si',$this->sBody,$matches,PREG_OFFSET_CAPTURE,$pos)){
			$start = $matches[1][1];
			$end = strpos($this->sBody, '"', $start);
			if ($end === false)
				break;
			$start2 = $start + strlen($matches[1][0]);
			$uid = 'smiley#'.$matches[2][0].'/'.$matches[3][0];
			if(!$this->EA[$uid]){
				$cid = strval(Tools::my_uniqid(rand(), true));
				$addAttachments[] = $cid;
				try{
					$this->addAttachment($oMail,'embedded', 'smiley', $matches[2][0].'/'.$matches[3][0], $cid);
				}catch(Exc $e){}
				if(isset($oMail->inlineAttachmentsCidDedup[$cid])) $cid = $oMail->inlineAttachmentsCidDedup[$cid];
				$this->EA[$uid] = $cid;
			}else{
				$cid = $this->EA[$uid];
			}
			$this->sBody = substr_replace($this->sBody, 'cid:' . $cid, $start, $end - $start);
			$pos = $start + strlen('cid:'.$cid);	
		}		
		 		if(is_array($addAttachments)) $result = true;
		return $result;
	}
	
	private function getDottedURI()
	{
		$uri = $_SERVER['REQUEST_URI'];
		$uri = str_replace('/'.WEBMAIL_PHP,'',$uri);
		$slashes = substr_count($uri,'/');
		$result = '';
		for($i = 0; $i < $slashes; $i++){
			$result .= '../';
		}
		$result.=ltrim($uri.'/'.DOWNLOAD_PHP,'/');
		return $result;
	}
	
	 
	private function processAttachments(&$oMail)
	{
		foreach ($this->oDOMDoc->query('message:attachment', $this->oDOMAttachments) as $oDOMAttach)
		{
			if (!$oDOMAttValues = $this->oDOMDoc->getNode("message:values", $oDOMAttach)) throw new Exc('message_missing_tag', 'values');

			$class = $this->oDOMDoc->getNodeValue("message:class", $oDOMAttValues);
			$fullpath = $this->oDOMDoc->getNodeValue("message:fullpath", $oDOMAttValues);
			$type = $this->oDOMDoc->getNodeValue("message:type", $oDOMAttValues);
			$description = $this->oDOMDoc->getNodeValue("message:description", $oDOMAttValues);
			$size = $this->oDOMDoc->getNodeValue("message:size", $oDOMAttValues);

			if (!$class || !$fullpath || !$type) throw new Exc('message_missing_tag', 'type,class,fullpath');
			$this->addAttachment($oMail, $type, $class, $fullpath, '', false, $description, $size);
			
		}
	}

	 
	private function addAttachment($oMail, $type, $class, $fullpath, $cid = '',$dummy = false, $description = '', $size = '')
	{
		if(($this->isDraft || $this->bSmartAttach) && $type != 'embedded'){
			$this->addSmartAttach($oMail, $type, $class, $fullpath, $cid, $dummy, $description, $size);
		}else{
			$this->addClassicAttachment($oMail, $type, $class, $fullpath, $cid, $dummy, $description);
		}
	}

	protected function addClassicAttachment($oMail, $type, $class, $fullpath, $cid = '', $dummy = false, $description = '', $oldFullPath = '')
	{
		$oUser = &$this->session_user;
		$aAttachments = $oUser->getAttachments();
		$attData = Tools::parseFullPath($fullpath, $class);
		$info = [];

		if($class == 'item' && $attData['account'][0] == '@') $class = 'special';
		if($class == 'cid') return $this->addAttachmentCid($oUser, $attData, $oMail, $type, $description, $cid);
		if($class == 'item' || $class == 'message') return $this->addAttachmentMessage($attData, $oUser, $oMail, $info, $description, $type, $aAttachments, $oldFullPath);
		if($class == 'gwattachment' || $class=='teamchat_attachment' || $class == 'attachment' || $class == 'special') return $this->addAttachmentSpecial($oUser, $attData, $oMail, $info, $class, $type, $description, $cid, $oldFullPath);
		if($class == 'smiley'){
			$smileyPath = '../client/skins/default/images/smiles/';
			$oMail->addEmbededAttachment(slToolsFilesystem::truepath($smileyPath . $fullpath), 'image/png', $cid, basename($fullpath));
		}
		if($class == 'file') return $this->addAttachmentFile($aAttachments, $attData, $type, $oMail, $description, $dummy, $cid, $oldFullPath);
		if($class == 'link') return $this->addClassicAttachmentFromSmartAttach($attData, $type, $oMail, $description, $cid, $oldFullPath);
	}

	public function addClassicAttachmentFromSmartAttach($attData, $type, $oMail, $description = '', $cid = '', $oldFullPath = '')
	{
		 		$download = new slToolsDownload($attData['url']);
		$location = $download->getLocation();
		if($location){
			$location = str_replace('/collaboration/?','/teamchatapi/'.$attData['name'].'?override_method=files.download&',$location); 
			$location = preg_replace('/&url=.*/u','',$location);		
			$download = new slToolsDownload($location);
		}
		$fileName = $download->getFileName();
		$contentType = $download->getContentType();
		$fileToDownload = User::getUploadDir('url').'/'.$fileName;
		$download->saveLocal($fileToDownload);

		if ($type == 'normal') {
			if($oldFullPath <> '') $attData['oldFullPath'] = $oldFullPath;
			$oMail->addAttachment($fileToDownload, $contentType, $description ? $description : $fileName, 'base64', '', false, false, $attData);
		} else{
			throw new Exc('message_attachment_type', $type);
		}
		return true;
	}

	protected function reSmartAttach($oMail, $name, $size, $type, $url)
	{
		if ($this->isDraft){
			$oMail->addHeader('X-IceWarp-SmartAttach-Draft: class="link" ; fullpath="'.$url.'"; size="'.$size.'"; type="'.$type.'" name="'.$name.'"; url="'.$url.'"');
		}
		$oMail->addHeader('X-IceWarp-SmartAttach: size="'.$size.'"; type="'.$type.'" name="'.$name.'"; url="'.$url.'"');
		$oMail->addHeader('Document-Reference:'.urlencode($url).';FileName='.$name.';ProviderType=IceWarp');
		
		return true;
	}

	protected function addSmartAttach($oMail, $type, $class, $fullpath, $cid = '', $dummy = false, $description = '', $size = '', $oldFullPath = '')
	{
		$oUser = &$this->session_user;
		$attachments = $oUser->getAttachments();
		$attData = Tools::parseFullPath($fullpath, $class);
		$attData['fullpath'] = $fullpath;
		$attData['class'] = $class;


		 		if ($class == 'link'){
			if(!$size || !$description){
				 				$download = new slToolsDownload($attData['url']);
				$location = $download->getLocation();
				if($location){
					$location = str_replace('/collaboration/?','/teamchatapi/'.$attData['name'].'?override_method=files.download&',$location); 
					$location = preg_replace('/&url=.*/u','',$location);		
					$download = new slToolsDownload($location);
				}
				$fileName = $description?$description:$download->getFileName();
				$contentType = $download->getContentType();
				$size = $download->getContentLength();
			}
			
			return $this->reSmartAttach($oMail, $fileName, $size, $contentType, $attData['url']);
		}
		 		if(isset($attachments[$attData['folder'] ?? null], $attachments[$attData['folder']][$attData['item']])){
			$upload = $attachments[$attData['folder']][$attData['item']];
			$document = $this->saveFileToDocuments($upload['file'], $upload['name'], $fullpath, $class, '' , $this->bSmartAttach && !$this->isDraft);
			return $this->addSmartAttach($oMail, $type, 'item', $document->getFullpath($this->SmartAttachAccount->accountID), $cid, $dummy, $description, $upload['size'], $fullpath);
		}
		 		if($class == 'attachment' && !empty($attData['part'])){
			$fileInfo = [];
			$file = $this->session_user->getAccount($attData['account'])->getFolder($attData['folder'])->getItem($attData['item'])->getAttachmentDataFile($attData['part'], $fileInfo, false);
			if($fileInfo['is_smarturl']){
				return $this->reSmartAttach($oMail, $fileInfo['name'],$fileInfo['size'], $fileInfo['type'],  $file);
			}
			$partID = $attData['item'].'/'.$attData['part'];
			$document = $this->findDocument($partID);
			if(!$document){
				$document = $this->saveFileToDocuments($file, $fileInfo['name'], $fullpath, $class, $partID, $this->bSmartAttach && !$this->isDraft);
			}else{
				if($this->bSmartAttach && !$this->isDraft){
					$this->checkDocumentSmartAttachTag($document, true);
				}
			}

			return $this->addSmartAttach($oMail, $type, 'item', $document->getFullpath($this->SmartAttachAccount->accountID), $cid, $dummy, $description, $size, $fullpath);
		}
		 		if ($class == 'url'){
			$document = $this->saveUrlToDocuments($attData['url'], $attData['name'], $fullpath, $class);
			return $this->addSmartAttach($oMail, $type, 'item', $document->getFullpath($this->SmartAttachAccount->accountID), $cid, $dummy, $description, $size, $fullpath);
		}

		$this->addAttachmentMessage($attData, $oUser, $oMail, [], $description, $type, $attachments);
		return true;
	}

	public function inviteDocument($document)
	{
		$parameters = '';
		if($this->bSmartAttachExpire){
			$parameters.= '&expire='.urlencode($this->SmartAttachExpire);
		}
		if($this->bSmartAttachPassword){
			$parameters.= '&password='.urlencode($this->SmartAttachPassword);
		}
		if($this->bSmartAttachEditable){
			$parameters.= '&rights='.urlencode($this->SmartAttachRights);
		}
		$document->inviteByParameters($parameters);
	}

	protected function saveFileToDocuments($file, $fileName, $fullpath, $class, $type, $partID = '', $addSmartAttachTag = false)
	{
		$document = new \server\model\Document($this->SmartAttachFolder);
		$document->setEvnsharetype('U')
			->setEvnrid($fileName)
			->setEvnlocation($fileName)
			->setEvntitle($fileName)
			->setEvncomplete(filesize($file));
		if($partID){
			$document->setEvnuid($partID);
		}
		if($addSmartAttachTag){
			$this->checkDocumentSmartAttachTag($document, false);
		}
		$attachment = new \server\model\Attachment($this->SmartAttachFolder, null, $document);
		$attachment->setAttType('F')
			->setDescription($fileName)
			->setFullpath($fullpath)
			->setClass($class);
		$document->addAttachment($attachment);
		if(!$partID && $this->isDraft){
			$partID = 'draft_sa_'.base64_encode($document->getFullPath($this->SmartAttachAccount->accountID, true));
			$document->setEvnuid($partID);
		}
		$document->save();
		return $document;
	}

	protected function saveUrlToDocuments($url, $fileName, $fullpath, $class)
	{
		$fileToDownload = User::getUploadDir('url').'/'.$fileName;
		User::closeSession();
		$download = new slToolsDownload($url);
		$download->saveLocal($fileToDownload);
		User::restoreSession();
		return $this->saveFileToDocuments($fileToDownload, $fileName, $fullpath, $class, '' , $this->bSmartAttach && !$this->isDraft);
	}

	protected function findDocument($partID)
	{
		$document = null;
		$filter['sql'] = "EvnUID = '".$partID."'";
		$items = $this->SmartAttachFolder->getItems($filter);
		if($items){
			$item = reset($items);
			$uid = $item->itemID;
			$document = new \server\model\Document($this->SmartAttachFolder);
			$document->loadById($uid);
		}
		return $document;
	}

	protected function checkDocumentSmartAttachTag($document, $save = true)
	{
		if($document){
			$set = false;
			$found = false;
			$smartAttachTag = urlencode('SmartAttach');
			$evnType = $document->getEvntype();
			$otherTags = [];
			if($evnType){
				$tags = explode(" ",$evnType);
				foreach($tags as $tag){
					if($tag==$smartAttachTag){
						$found = true;
					}else{
						$otherTags[] = $tag;
					}
				}
			}
			if(!$found){
				if($this->bSmartAttach){
					if($evnType){
						$evnType.=' '.$smartAttachTag;
					}else{
						$evnType = $smartAttachTag;
					}
					$set = true;
				}
			}else{
				if(!$this->bSmartAttach && $evnType){
					if($otherTags){
						$evnType = join(" ",$otherTags);
					}else{
						$evnType = ' ';
					}
					$set = true;
				}
			}
			if($set){
				$document->setEvntype($evnType);
			}
			if($save){
				$document->save();
			}

		}
	}

	private function addRecipientsToAddressBook()
	{
	 		$gw = new GroupWareManagement();
		$gw->addRecipientsToAddressBook($this->addrList);
	}

	private function execFinalMessageAction(&$oMail)
	{

		$oUser = &$this->session_user;
		$sPrimaryAccountEmail = $_SESSION['EMAIL'];
		$oPrimaryAccount = $oUser->getAccount($sPrimaryAccountEmail);

		$oMail->setSMTPPassword($oUser->getPassword());
		
		if($this->sRFCDate){
			$oMail->RFCDate = $this->sRFCDate;
		}
		
		 		if ($this->sSEmail){
			
			 			if($this->sSMS && !$this->sEncrypt){
				$message_id = $oMail->sendSMS( $this->aSMS, $this->bHTML );
				$this->aData['time'] = null;
				$account = new IceWarpAccount();
				$account->open($_SESSION['EMAIL']);
				$this->aData['sms_send'] = $account->GetProperty("U_SMS_SentThisMonth");
			}
			 			if($this->sTO || $this->sCC || $this->sBCC || $this->oDistribVal){
				 				 				$t = time();
				$m = microtime();
				 				$preparedFile = $oMail->prepareMessageTempFile($this->sCharset);
				
				log_buffer("Mail::prepareMessageTempFile() : lasts :".(time()-$t+microtime()-$m),"EXTENDED");
				
				if($this->sEncrypt){
					$gwManage = new GroupWareManagement();
					$oMail->encrypt();
					foreach($this->smimeRecipients as $rcp){
						
						if ($this->sSign){
							$oMail->sign();
						}
						
						$oMail->overrideRecipient($rcp);
						if($message_id){
							$oMail->message_id = $message_id;
						}
						$recipientCert = $gwManage->getEmailCertificates($rcp);
						$oMail->publicCertificates[strtoupper($rcp)] = $recipientCert;
						if (!($msg = $oMail->sendFromPreparedFile($preparedFile))){
							throw new Exc($msg);
						}
						if(!$message_id){
							$message_id = $oMail->last_message_id;
						}
						$this->aData['time'] = $oMail->time;
					}
				 				}else{
					if ($this->sSign){
						$oMail->sign();
					}
					$t = time();
					$m = microtime();
					 					if (!($msg = $oMail->sendFromPreparedFile($preparedFile))){
						throw new Exc($msg);
					}
					
					log_buffer("Mail::sendFromPreparedFile() : lasts :".(time()-$t+microtime()-$m),"EXTENDED");
					 					$message_id = $oMail->last_message_id;
					$this->aData['time'] = $oMail->time;
				}
			}
		}
		
		if($message_id){
			$this->aData['message_id'] = $message_id;
		}
		 		if ($this->bSaveToTeamChat && (!$this->sSave || !$this->isDraft ) ){
			if(strtolower($_SESSION['DBTYPE'])!='sqlite'){
				log_buffer("WebmailIQMessage->execFinalMessageAction(SAVE) RESTORE SESSION","EXTENDED");
				User::restoreSession();
			}
			 			$oAccount = $oUser->getAccount($this->sSaveTeamchatAccount);
			if (!is_object($oAccount))
				throw new Exc('message_invalid_account', $this->sSaveTeamchatAccount);
			$oFolder = $oAccount->getFolder($this->sSaveTeamchatFolder);

			if (!is_object($oFolder))
				throw new Exc('message_invalid_folder', $this->sSaveTeamchatFolder);
			
			 			if(!$preparedFile){
				log_buffer("WebmailIQMessage: save prepare message file ".memory_get_usage(),"EXTENDED");
				$preparedFile = $oMail->prepareMessageTempFile($this->sCharset);
			}

			try{
				$oItem = $oFolder->getItem($this->sSaveTeamchatItem);
			}catch(Exc $e){
				$this->sSaveTeamChatItem = false;
			}

			$aItem = array();
			$remove =  false;
			 			if($this->bSaveToTeamChat && (!$this->sSEmail || $this->isDraft) ){
				$aItem['EVNFLAGS'] = 128;
			}else{
				$remove = true;
			}
			
			if(!$this->sSaveTeamchatItem){
				$oItem = null;
				 				 				$oItem = \server\model\TeamChat::createFromMessage($oFolder,$preparedFile,$this->sTeamChatComment, $oItem, $aItem, true, $this->sSaveTeamchatFolder);
				$this->aData['teamchat_id'] = $oItem->getId();
			}else{
				$oItem = $oFolder->getItem($this->sSaveTeamchatItem);
				$mailID = $oItem->getFileAttachmentID();
				$oItem->getAddons();
				$oItem->aAddons['attachment']->delete('');
				 				if($remove){
					$aItem['EVNFLAGS'] = $oItem->item['EVNFLAGS'] & ~128;
				}
				 				$oItem = GroupWareItem::createFromMessage($oFolder,$preparedFile,$this->sTeamChatComment,$oItem,$aItem,true);
				$this->aData['teamchat_id'] = $oItem->itemID;
			}
			$this->aData['teamchat_link_id'] = $oItem->linkID;
			$this->aData['teamchat'] = $this->sSaveTeamchatFolder;
		}

		 		if ($this->sSave){
	
			$t = time();
			$m = microtime();
			 			
			if(strtolower($_SESSION['DBTYPE'])!='sqlite' && User::isClosedSession()){
				log_buffer("WebmailIQMessage->execFinalMessageAction(SAVE) RESTORE SESSION","EXTENDED");
				User::restoreSession();
			}
			 			 			$oAccount = $oUser->getAccount($this->sSaveAccount);
			if (!is_object($oAccount))
				throw new Exc('message_invalid_account', $this->sSaveAccount);
			$oFolder = $oAccount->getFolderWithAutoCreate($this->sSaveFolder, 'main');

			if (!is_object($oFolder))
				throw new Exc('message_invalid_folder', $this->sSaveFolder);
				
			if (strtolower($_SESSION['DBTYPE'])!='sqlite'){
				log_buffer("WebmailIQMessage->execFinalMessageAction(SAVE) SESSION WRITE CLOSE","EXTENDED");
				User::closeSession();
			}
			 			if (($this->sBCC && $this->aBcc) || $this->bccDlAddrList){
				$bccCount = 0;
				if($this->aBcc){
					foreach($this->aBcc as $bccAddress){
						$aFixedBCC[] = $oMail->AddrFormat(
							array(
								$bccAddress['address'],
								$bccAddress['display']
							)
						);
					}
				}
				if($this->bccDlAddrList){
					foreach($this->bccDlAddrList as $address){
						$aFixedBCC[] = $oMail->AddrFormat(
							array(
								$address['address'],
								$address['display']
							)
						);
					}
				}
				 				if(!$this->isDraft && $aFixedBCC){
					$sentHeaders[] = 'Bcc: ' . implode(',',$aFixedBCC);
				}
			}
			
			if($this->sSMS){
				 				$sentHeaders[] = 'Sms:'.$this->sSMS;
			}
			
			if($message_id){
				 				if(!$this->isDraft){
					$sentHeaders[] = 'X-Message-ID: '.$message_id;
				}
			}
			
			if($this->sEncrypt){
				if(!$this->sSMS){
					$oMail->encrypt();
				}
			}
			
			if($this->sSign){
				if(!$this->sSMS){
					$oMail->sign();
				}
			}

			if($this->sTeamChatRoom){
				$sentHeaders[] = 'X-IceWarp-TeamChatRoom:'.$this->sTeamChatRoom;
			}
			if($this->sTeamChatComment){
				$sentHeaders[] = 'X-IceWarp-TeamChatComment:'.base64_encode($this->sTeamChatComment);
			}

			if($this->bSmartAttach){
				$sentHeaders[] = 'X-IceWarp-SentAsSmartAttach: true';
			}
			
			if(!$preparedFile){
				log_buffer("WebmailIQMessage: save prepare message file ".memory_get_usage(),"EXTENDED");
				$preparedFile = $oMail->prepareMessageTempFile($this->sCharset );
			}
			log_buffer("Mail::prepareMessageTempFile (SAVE)() : lasts :".(time()-$t+microtime()-$m),"EXTENDED");
			
			if($sentHeaders){
					 					$t = time();
					$m = microtime();
					$oMail->addHeadersIntoFile($preparedFile,$sentHeaders);
					log_buffer("Mail::prepareMessageTempFile (SAVE)() : lasts :".(time()-$t+microtime()-$m),"EXTENDED");
			}

			if($this->sSign || $this->sEncrypt){
				$oMail->overrideRecipient($oMail->From);
				$oMail->publicCertificates = slSMime::personalToPublic($oMail->personalCertificates);
				if(!isset($oMail->publicCertificates[strtoupper($oMail->From)])){
					throw new Exc('save_certificate_missing');
				}
				$fp = fopen($preparedFile,'r+');
				$oMail->encryptAndSign($fp,$preparedFile);
				@fclose($fp);
			}
			
			$t = time();
			$m = microtime();
			 			if ($this->sSaveItem)
			{
				 				try{
					 					$oItem = $oFolder->getItem($this->sSaveItem);
					$newItem = $oItem->createFromItem($preparedFile);
					$oItem->delete();

					$this->aData['itemid'] = $newItem->itemID;
					 				}catch (Exc $e){
					 					$this->aData['itemid'] = $oFolder->createItem(false, $preparedFile, false, false, "\\Seen");
				}
			} else {
				 				$this->aData['itemid'] = $oFolder->createItem(false, $preparedFile, false, false, "\\Seen");
			}

			if($this->bIncludeInSentFolder){
				$sentFolder = User::getDefaultFolder('S');
				if (!$sentFolder) {
					$sentFolder = \Storage::getDefaultMailFolder('sent');
				}
				$oSentFolder = $oAccount->getFolderWithAutoCreate($sentFolder, 'main');
				 				if($oSentFolder->name != $oFolder->name){
					$this->aData['sentitemid'] = $oSentFolder->createItem(false, $preparedFile, false, false, "\\Seen");
				}else{
					$this->aData['sentitemid'] = $this->aData['itemid'];
				}
			}
			log_buffer("Mail::SAVE() : lasts :".(time()-$t+microtime()-$m),"EXTENDED");
			
			slSystem::import('tools/icewarp');
			@slToolsIcewarp::iw_delete($preparedFile);

			if($this->isDraft){
				foreach ($oMail->attachment as $attachment){
					$att = [
						'part_id' => $attachment[2],
						'oldfullpath' => $attachment[12]['oldfullpath'], 
						'fullpath' => $attachment[12]['fullpath'],
						'class' => $attachment[12]['class'],
						'size' => $attachment[12]['size'],
						
					];
					$this->aData['attachments'][] = $att;
				}
			}
		}
		if(strtolower($_SESSION['DBTYPE'])!='sqlite' && User::isClosedSession()){
			log_buffer("WebmailIQMessage->execFinalMessageAction(FINAL ACTION) RESTORE SESSION","EXTENDED");
			User::restoreSession();
		}
		if($this->bAutoABook){
			$this->addRecipientsToAddressBook();
		}
		if($this->clearSessionMailCache){
			unset($_SESSION['mail']['cache']);
		}
		 		if (!$this->sKA && ($this->aFolderList || $this->itemList))
		{
			 			foreach ($this->aFolderList as $folder)
				$oUser->removeAttachments($folder);

			 			if($this->itemList){
				foreach($this->itemList as $item){
					$item->delete();
				}
			}
		}
	}

	private function dialPhone()
	{
		$api = createobject('api');
		$sPrimaryAccountEmail = $_SESSION['EMAIL'];
		if(!$this->sExternalDevice){
			$api->SIPReferCall($sPrimaryAccountEmail,$this->sPhoneNumber);
		}else{
			$api->SIPReferCall($sPrimaryAccountEmail,$this->sPhoneNumber,$this->sExternalDevice);
		}
	}

	 
	protected function addAttachmentCid($oUser, array $attData, Mail $oMail, string $type, string $description, string $cid): bool
	{
		$oAccount = $oUser->getAccount($attData['account']);
		$oFolder = $oAccount->getFolder($attData['folder']);
		if (($pos = strpos($attData['item'], '|')) !== false) {
			$attData['item'] = substr($attData['item'], 0, $pos);
		}
		try{
			$oItem = $oFolder->getItem($attData['item']);
		}catch(Exc $e){
			if($this->draftID){
				$oItem = $oFolder->getItem($this->draftID);
			}else{
				throw $e;
			}
		}
		$oMail->addReferenceItem($oItem);
		$info = [];
		$cid = urldecode($attData['part']);
		if ($type == 'normal') {
			$file = $oItem->getAttachmentDataFileCID($attData['part'], $info);
			$oMail->addAttachment($file, $info['mimetype'], $description ? $description : $info['name'], 'base64', '', false, false,$attData);
		} elseif ($type == 'embedded') {
			$content = $oItem->getAttachmentDataCID($attData['part'], $info);
			$oMail->AddStringAttachment($content, $description ? $description : $info['name'], 'base64', $info['mimetype'], true, $cid);
		} else {
			throw new Exc('message_attachment_type', $type);
		}
		return true;
	}

	 
	protected function addAttachmentFile($aAttachments, array $attData, string $type, Mail $oMail, string $description, bool $dummy, string $cid, $oldFullPath = ''): bool
	{
		if (!isset($aAttachments[$attData['folder']][$attData['item']])) throw new Exc('message_attachment_existence');
		$aAttachData = $aAttachments[$attData['folder']][$attData['item']];
		Tools::overrideContentType($aAttachData['name'], $aAttachData['type']);
		if (!in_array($attData['folder'], $this->aFolderList)) $this->aFolderList[] = $attData['folder'];
		if ((@filesize($aAttachData['file']) > $_SESSION['UPLOAD_LIMIT'] * 1024 * 1024) && !$this->bSmartAttach) {
			throw new Exc('attachment_too_large');
		}
		if ($type == 'normal') {
			if($oldFullPath <> '') $attData['oldFullPath'] = $oldFullPath;
			$oMail->addAttachment($aAttachData['file'], $aAttachData['type'], $description ? $description : $aAttachData['name'], 'base64', '', false, $dummy, $attData);
		} elseif ($type == 'embedded') {
			if (!$aAttachData['cid']) $aAttachData['cid'] = $cid;
			$oMail->addEmbededAttachment($aAttachData['file'], $aAttachData['type'], $aAttachData['cid'], $description ? $description : $aAttachData['name']);
		} else {
			throw new Exc('message_attachment_type', $type);
		}
		return true;
	}

	 
	protected function addAttachmentSpecial($oUser, array $attData, Mail $oMail, array $info, string $class, string $type, string $description, string $cid, $oldFullPath = ''): bool
	{
		$oAccount = $oUser->getAccount($attData['account']);
		$oFolder = $oAccount->getFolder($attData['folder']);
		$item_id = $attData['item'];
		if (($pos = strpos($attData['item'], '|')) !== false) {
			$start_part_id = substr($attData['item'], $pos + 1);
			$item_id = substr($attData['item'], 0, $pos);
		}
		$oItem = $oFolder->getItem($item_id);
		$oMail->addReferenceItem($oItem);
		$file = $oItem->getAttachmentDataFile($attData['part'], $info, $start_part_id);

		if (strtoupper($class) == 'GWATTACHMENT' && ($this->isDraft || $this->bSmartAttach)) {
			$smart_params['url'] = $oItem->item['INVITETICKET']?$oItem->item['INVITETICKET']:$oItem->item['TICKET'];
			$smart_params['size'] = $info['size'];
			$smart_params['type'] = $info['type'];
			$smart_params['zipid'] = $oItem->itemID . '/' . $attData['part'];
			if($oldFullPath <> '') $smart_params['oldfullpath'] = $oldFullPath;
			$oMail->SmartAttachSourceFolders[$oFolder->folderID] = MerakGWAPI::encode($oFolder->folderID);
		}
		if ($type == 'normal') {
			$oMail->addAttachment($file, $info['mimetype'], $description ? $description : $info['name'], 'base64', false, true, false, $smart_params);
		} elseif ($type == 'embedded') {
			$oMail->AddStringAttachment(file_get_contents($file), $description ? $description : $info['name'], 'base64', $info['mimetype'], true, $cid);
			if ($class == 'file' && !$this->sKA) {
				slSystem::import('tools/icewarp');
				@slToolsIcewarp::iw_delete($file);
			}
		} else {
			throw new Exc('message_attachment_type', $type);
		}
		return true;
	}

	 
	protected function addAttachmentMessage(array $attData, $oUser, Mail $oMail, array $info, string $description, string $type, &$aAttachments, $oldFullPath = ''): bool
	{
		$sAID = $attData['account'];
		$sFID = $attData['folder'];
		$sIID = $attData['item'];
		$start_part_id = '';
		if (($pos = strpos($sIID, '|')) !== false) {
			$start_part_id = substr($sIID, $pos + 1);
			$sIID = substr($sIID, 0, $pos);
		}
		$oAccount = $oUser->getAccount($sAID);
		 		$oFolder = $oAccount->getFolder($sFID);
		$oItem = $oFolder->getItem($sIID);	
		if($oItem->item['EVNDOCINVITE']=='1'){
			$invitedBefore = true;
		}
		$noSmartAttach = false;
		$isFile = ($oItem->item['EVNCLASS'] == 'F' || $oItem->item['EVNCLASS'] == 'R' || $oItem->item['EVNCLASS'] == 'M');
		$isSmartAttachable = $isFile;
		if($this->sSEmail){
			if($isFile){
				$attname = $oItem->getFileAttachmentId($attinfo);
				$mimeType = Tools::parseURL($attinfo['ATTPARAMS']);
				$mimeType = (string) $mimeType['mimetype'];
				if(slPHPMailer::isForbiddenSmartAttach($attname, $mimeType)){
					$isSmartAttachable = false;
					$this->itemList[] = $oItem;
				}
			}
		} 

		 		if ($isSmartAttachable) {
			if($this->bSmartAttach && !$this->isDraft){
				$document = new \server\model\Document($oFolder,$oItem->itemID);
				 				if($oItem->item['EVNDOCINVITE']!='1'){
					$oMail->addReferenceItem($oItem);
					$this->inviteDocument($document);
				}
				 				$this->checkDocumentSmartAttachTag($document,true);

				 				if(!$oItem->item['INVITETICKET'] || $oItem->item['INVITETICKET']=='-1'){
					$oItem->item['INVITETICKET'] = $document->loadInviteTicket();
				}
			}
			if(!$invitedBefore && $this->sSEmail && $oFolder->subtype=='U' && !$this->bSmartAttach){
				$this->itemList[] = $oItem;
			}
			
			 			$aAttachments = $oItem->aAddons['attachment']->getData();
			if ($aAttachments) {
				$gwattachment = reset($aAttachments);
				$file = $oItem->getAttachmentDataFile($gwattachment['ATTNAME'], $info);
				$attachment['name'] = $description ? $description : $info['name'];
				$attachment['size'] = $gwattachment['ATTSIZE'];
				$attachment['type'] = $info['mimetype'];
				
				if ($this->bSmartAttach || $this->isDraft) {
					$smart_params['url'] = $oItem->item['INVITETICKET']?$oItem->item['INVITETICKET']:$oItem->item['TICKET'];
					$smart_params['size'] = $attachment['size'];
					$smart_params['type'] = $attachment['type'];
					$smart_params['zipid'] = $oItem->itemID . '/' . $gwattachment['ATTNAME'];
					if(isset($attData['fullpath'])) $smart_params['fullpath'] = $attData['fullpath'];
					if(isset($attData['class'])) $smart_params['class'] = $attData['class'];
					if($oldFullPath <> '') $smart_params['oldfullpath'] = $oldFullPath;
					$oMail->SmartAttachSourceFolders[$oFolder->folderID] = MerakGWAPI::encode($oFolder->folderID);
				}
			}
		 		} else {
			$smart_params = false;
			if ($isFile && !$start_part_id){
					$start_part_id = $oItem->getFileAttachmentID();
			}
			if ($start_part_id) {
				$file = $oItem->getAttachmentDataFile($start_part_id, $info);
			} else {
				$file = $oItem->getItemFile($info, $this->sPassPhrase);
			}
				
			$attachment['type'] = $info['mimetype'];
			$attachment['name'] = $description ? $description : $info['name'];
		}
		if ($type == 'normal') {
			$oMail->AddAttachment($file, $attachment['type'], $attachment['name'], 'base64',false, true, false, $smart_params);
		} else {
			throw new Exc('message_attachment_type', $type);
		}
		return true;
	}

}

?>
