<?php

class SnoozedItem
{
    public $timestamp;
    public $timezone;
    public $accountID;
    public $folderID;
    public $itemID;
    public $originalDate;
    public $data;
    public $wmclass = 'SNOOZED';
    public $mailItem;
    public $cc;
    public $bcc;
    public $color;
    public $date;
    public $dummy_id;
    public $fileid;
    public $flag_update;
    public $flags;
    public $from;
    public $hasAttachments;
    public $is_hidden;
    public $item_moved;
    public $priority;
    public $sMimeStatus;
    public $size;
    public $sms;
    public $sort_bcc;
    public $sort_cc;
    public $sort_from;
    public $sort_sms;
    public $sort_to;
    public $source_folder_id;
    public $staticFlags;
    public $subject;
    public $taglist;
    public $to;
    public $uid;
    public $ctz;

    public function __construct($data = [])
    {
        if($data){
            $this->data = $data;
        }
        $this->setAccountID($_SESSION['EMAIL']);
    }

    public function create()
    {
        $user = $_SESSION['user'];
        $cache = Cache::instance($user);

        return $cache->createSnoozedItem( $this->getItemID(), $this->getOriginalDate());
    }

    public function get()
    {
        $user = $_SESSION['user'];
        $cache = Cache::instance($user);

        return $cache->getSnoozedItem($this->getItemID());
    }

    public function update()
    {
        $user = $_SESSION['user'];
        $cache = Cache::instance($user);

        return $cache->updateSnoozedItem( $this->getItemID(), $this->getOriginalDate());
    }

	public function snooze($minutes = 0)
	{
		 		if(!$minutes){
			if(!$this->timestamp){
				throw new Exc('snooze_minutes_or_timestamp_missing');
			}else{
				$snoozedDate = $this->timestamp;
			}
		}else{
			$snoozedDate = time() + $minutes*60;
		}
		 		$cache = ['cache' => Cache::instance($_SESSION['user'])];
        return $cache['cache']->updateItem($this->itemID, ['date' => $snoozedDate], $cache, 'flags');
	}

    public function unsnooze()
    {
        $user = $_SESSION['user'];
        $cache = Cache::instance($user);
        return $cache->deleteSnoozedItem($this->getItemID());
    }

    public function getMailItem()
    {
        if(!$this->mailItem){
            $user = $_SESSION['user'];
            $account = $user->getAccount($this->getAccountID());
            $folder = $account->getFolderById($this->getFolderID());
            $this->mailItem = $folder->getItem($this->getItemID());
        }
        return $this->mailItem ;
    }

      
    public function getAccountID()
    {
        return $this->accountID;
    }

      
    public function setAccountID(string $accountID)
    {
        $this->accountID = $accountID;

        return $this;
    }

      
    public function getFolderID()
    {
        return $this->folderID;
    }

      
    public function setFolderID(int $folderID)
    {
        $this->folderID = $folderID;

        return $this;
    }

      
    public function getItemID()
    {
        return $this->itemID;
    }

      
    public function setItemID(int $itemID)
    {
        $this->itemID = $itemID;

        return $this;
    }

      
    public function getOriginalDate()
    {
        return $this->originalDate;
    }

      
    public function setOriginalDate(int $date)
    {
        $this->originalDate = $date;

        return $this;
    }


      
    public function getData()
    {
        return $this->data;
    }

      
    public function setData($data)
    {
        $this->setFolderID(intval($data['folder_id']));
        $this->setItemID(intval($data['snoozed_item_id']));
        $this->setOriginalDate($data['original_date']);

        $allowedItems = array(
			'rid'		 => 'uid',
			'size'		=> 'size',
			'date'		=> 'date',
			'flags'		=> 'flags',
			'header_from' => 'from',
			'header_to'	=> 'to',
			'header_cc'	=> 'cc',
			'header_bcc'	=> 'bcc',
			'header_sms'	=> 'sms',
			'sort_to'	=> 'sort_to',
			'sort_cc'	=> 'sort_cc',
			'sort_bcc'	=> 'sort_bcc',
			'sort_sms'	=> 'sort_sms',
			'sort_from'	=> 'sort_from',
			'subject'	 => 'subject',
			'static_flags' => 'staticFlags',
			'priority'	 => 'priority',
			'color'	 => 'color',
			'smime_status' => 'sMimeStatus',
			'has_attachment' => 'hasAttachments',
			'flag_update'=>'flag_update',
			'source_folder_id'=>'source_folder_id',
			'is_hidden'=>'is_hidden',
			'dummy_id'=>'dummy_id',
			'taglist'=>'taglist',
			'item_moved'=>'item_moved',
			'msg_file'=>'fileid'
		);

        $this->data = $data;

        foreach($data as $key => $val){if(isset($allowedItems[$key])){
                $varname = $allowedItems[$key];
                $this->$varname = $val;
            }
        }
        return $this;
    }

      
    public function getTimezone()
    {
        return $this->ctz;
    }

      
    public function setTimezone($minutes)
    {
        $this->ctz = $minutes;

        return $this;
    }

      
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;

        return $this;
    }
     
    public function __call( $name , $arguments )
    {
        $item = $this->getMailItem();
        return call_user_func_array(array($item, $name),$arguments); 
    }
}

?>
