<?php

class SnoozedFolder extends Folder
{
    private  $accountID;
    public  $folderID;
    public  $name;
    public  $defaultRights;
    public  $itemClassName;
    
    public function __construct(User $user, Account $oAccount)
    {
        $rights = Folder::RIGHT_READ;
		$rights |= Folder::RIGHT_DELETE;
		$rights |= Folder::RIGHT_FOLDER_READ;
		$this->defaultRights = $rights;
		$this->rights = $rights;
        $this->itemClassName = 'SnoozedItem';
		$this->type = 'SNOOZED';
        $this->name = '__@@SNOOZED@@__';

        $this->setFolderID('__@@SNOOZED@@__');
        $this->setAccountID($oAccount->accountID);

        $this->account = $oAccount;
        $this->user = $user;
    }

      
    public function getAccountID()
    {
        return $this->accountID;
    }

      
    protected function setAccountID($accountID)
    {
        $this->accountID = $accountID;

        return $this;
    }

      
    public function getFolderID()
    {
        return $this->folderID;
    }

      
    protected function setFolderID($folderID)
    {
        $this->folderID = $folderID;

        return $this;
    }
	
    public function getItemsByIds(array $ids)
	{
		$cache = Cache::instance($this->user);
		return $cache->getSnoozedItemsByIds($ids);
	}

    public function getItems(&$aFilterTag = array(), $createObject = true, $ignoreHidden = true)
    {
        $cache = Cache::instance($this->user);
        if($aFilterTag['search']){
            $aFilterTag['sql'] = $this->filterToSql($aFilterTag);
        }
        return $cache->getSnoozedItems($this, $aFilterTag);
    }



    public function getItem($itemID, $cache = false)
    {
        $item = new SnoozedItem();
        $item->setItemID($itemID);
        return $item->get();
    }

    public function deleteItems($oItems = false)
    {
        $result = true;
                 if($oItems){
            foreach($oItems as $oItem){
                $result = $oItem->delete() && $result;
            }
                 }else{
            throw new Exc('not_implemented');
        }     
        return $result; 
    }

    public function countItems($flags = 0, $positive = true, $filter = "", $search = false)
    {
        $cache = Cache::instance($this->user);
        if($search){
            $aFilterTag['search'] = $search;
            $filter = $this->filterToSql($aFilterTag);
        }
        return $cache->countSnoozedItems( $this, $flags, $positive, $filter, $search);
    
    }

    public function markItems($flag, $oItems = false){
        if($oItems){
            foreach($oItems as $oItem){
                $oItem->setFlags($flag);
            }
        }
    }

    public function unmarkItems($flag, $oItems = false){
        if($oItems){
            foreach($oItems as $oItem){
                $oItem->unsetFlags($flag);
            }
        }
    }
    public function moveItems(&$oFolder,$oItems = false)
    {
        return $this->copymoveItems($oFolder, $oItems, 'move');
    }
    public function copyItems(&$oFolder,$oItems = false)
    {
        return $this->copymoveItems($oFolder, $oItems);
    }
    
    public function copymoveItems(&$oFolder, $oItems = false,$action = 'copy')
    {
        $result = true;
        $originalDates = [];
        $cache = Cache::instance($this->user);
                 if($oItems) foreach($oItems as $oItem) {
            $folderItems[$oItem->getFolderID()][$oItem->getItemID()] = $oItem->getMailItem();
            $originalDates[$oItem->getFolderID()][$oItem->getItemID()] = $oItem->getOriginalDate();
            $snoozedItems[$oItem->getFolderID()][$oItem->getItemID()] = $oItem;
        }
                 if($folderItems){
            foreach($folderItems as $folderID => $items){
                $copiedIds = [];
                $folder = $this->account->getFolderById($folderID);
                if($action=='move'){
                    $newIds = $folder->moveItems($oFolder, $items);
                }else{
                    $newIds = $folder->copyItems($oFolder, $items);
                }
                if(!$newIds){
                    $result = false;
                }
                                 if($action=='copy'){
                    foreach($originalDates[$folderID] as $itemID => $originalDate){
                        $item = $folder->getItem($itemID);
                        $item->updateItem(['date'=>$originalDate]);
                    }
                }
                                 if($action=='move' && $oFolder->isTrash()){
                    foreach($snoozedItems[$folderID] as $snoozedItem){
                        $snoozedItem->unsnooze();
                    }
                }
            }
        }
        return $result;
    }
	
    public function sync() {}
    public function delete() {}
    public function rename($newName) {}
	
	public function setDefault($type,$updateSettings = true){}
	public function setSubscription($state){}
	public function setNotify($bValue){}
	public function setChannels($mailbox,$channels,$encoded = false){} 

    private function filterToSql(&$aFilterTag)
    {
        $cache = Cache::instance($this->user);
        $search = new \server\inc\imap\Search($this, $aFilterTag['search']); 
        if($search->isSearchEnabled()){
                         $stmt = $cache->prepare("SELECT DISTINCT name from snoozed_item LEFT JOIN item on snoozed_item.snoozed_item_id = item.item_id LEFT JOIN folder on folder.folder_id = item.folder_id WHERE snoozed_account_id = ?");
            $stmt->execute([$this->getAccountID()]);
            $allFolders = false;
            $search_folder = '';
            $useFolders = [];
            while($row = $stmt->fetch()){
                $search_folder = $this->account->getFolder($row['name']);
                $useFolders[$row['name']] = $search_folder;
            }
            $sql = $search->getSearchSql($alreadySearched, $useFolders, count($useFolders)>1);
        }
        if($sql===false || !$search->isSearchEnabled()){
            $sql = $search->sqlFallBack($aFilterTag, $this->account);
        }
        unset($aFilterTag['search']);
        return $sql;
    }
}

?>