<?php
define('CHECK_INTERVAL', 1825);

 
class GroupWareItem extends Item
{
    const FLAG_ORGANIZATOR = 0x01;
     
    const FLAG_ATTENDEE = 0x02;
     
    const FLAG_TRANSPARENT = 0x04;      const FLAG_TENTATIVE = 0x08;      const FLAG_OUTOFOFFICE = 0x10;      const FLAG_GROUPCHATATTENDEE = 0x40;      const FLAG_HTMLCONTENT = 0x100;

    const MEETING_NOTE_SEPARATOR_TXT = "\r\n-----------\r\n";
    const MEETING_NOTE_SEPARATOR_HTML = "<div>-----------</div>";

    public $sFields;          public $itemID;       private $itemPrefix;      public $hasNoteAddon = false;      public $addMethod;
    public $deleteMethod;
    public $item;
    public $bSingle;
    public $wmclass;
    public $aAttendees;
    public $occurrenceID;
    public $reactions_metadata;
    public $itemInstances;
    public $duplicity;
    public $rename;
    public $fields;
    public $itemType;
    public $sFID;
    public $aAddons;
    public $folder;
    public $att_webdav_link;

     
    public function __construct(GroupWareFolder &$folder, $item, $aAddonSelect = array(), $fields = '', $bSingle = false, $ctz = 0)
    {
        $this->setPrefix($item);
        $this->folder = &$folder;
        $this->fields = $fields;
        $this->bSingle = $bSingle;
                 $this->itemID = $this->item[$this->itemPrefix . "_ID"];
        if (!$this->itemID) $this->itemID = $this->item[strtolower($this->itemPrefix . "_ID")];
        $this->itemType = $this->folder->getType();
        $this->noteIndex = $noteIndex = $this->itemPrefix=='EVN'?'EVNNOTE':'ITMDESCRIPTION';
        switch($this->itemType){
            case 'C':
                $this->addMethod = 'AddContactInfo';
                $this->deleteMethod = 'DeleteContact';
                break;
            case 'I':
                $this->addMethod = 'AddItemInfo';
                $this->deleteMethod = 'DeleteItem';
                break;
            default:
                $this->addMethod = 'AddEventInfo';
                $this->deleteMethod = 'DeleteEvent';
                break;
        }
        if($this->item['EVNCLASS'] == 'E'){
            if(strtolower($this->item['EVNDESCFORMAT']) === 'text/html'){
                $this->item[$this->noteIndex] = slToolsString::purifyHTML($item[$this->noteIndex], Tools::externalResourcesEnabled());
            }
        }
                 $sAddonsXML = '';
        if ($bSingle) {
                         $sFID = $this->openAccess();
            $this->item['TICKET'] = User::addTokenToTicket($folder->account->gwAPI->FunctionCall('GetAttachmentPathLocal', $sFID, $this->itemID, '', 'READONLYTICKET'));

            $this->getAddons();
			$ticketset = false;
			$inviteticketset = false;
            if ($this->aAddons) foreach ($this->aAddons as $key => $addon) {
                $sAddonsXML .= $addon->getXML($ctz);
                if($addon->oldNoteFormat){
                    $this->item[$this->noteIndex] = $addon->data[0]['note_text'];
                }
                if (!isset($this->item['EVNCLASS']) || ($this->item['EVNCLASS'] != 'F' && $this->item['EVNCLASS'] != 'M' && $this->item['EVNCLASS'] != 'N')) continue;

                if (!$ticketset && $addon->ticket) {
                    $this->item['TICKET'] = $addon->ticket;
                    $ticketset = true;
				}
				if(!$inviteticketset && $addon->inviteTicket){
					$this->item['INVITETICKET'] = $addon->inviteTicket;
					$inviteticketset = true;
				}
                if ($addon->sAddonType != 'attachment' || strpos($fields, 'data') === false) continue;
                if(!$att){
                    $att = $addon->data;
                }
                @$att = reset($att);
                if ($att['ATTSIZE'] && ($att['ATTSIZE'] < 524288)) {
                    $name = $att['ATTDESC'] ? $att['ATTDESC'] : $att['ATTNAME'];
                    $ext = strtolower(substr($name, strrpos($name, '.') + 1));
                    if($ext == 'txt' || $ext == 'md'){
                        $this->item['data'] = $addon->getAttachment($att['ATTNAME']);
                    }elseif($ext == 'htm' || $ext == 'html'){
                        slSystem::import('tools/string');
                        $enableExternalResources = false;
                        if (isset($_SESSION['clientSettings']) && isset($_SESSION['clientSettings']['show_inline_images']) && true === $_SESSION['clientSettings']['show_inline_images']) {
                            $enableExternalResources = true;
                        }
                        $this->item['data'] = slToolsString::basicSanitizeHTML($addon->getAttachment($att['ATTNAME']), $enableExternalResources);
                    }
				}

			}
			if ($this->item['EVNDOCRIGHTS'] ?? false){
				$this->item['EVNDOCEDITABLE'] = ($this->item['EVNDOCRIGHTS'] & MerakGWAPI::RIGHT_WRITE) <> 0;
				$this->item['EVNDOCDISABLEDOWNLOAD'] = ($this->item['EVNDOCRIGHTS'] & MerakGWAPI::RIGHT_TEAMCHAT_DISABLE_DOWNLOAD) <> 0;
			}
                         if(($this->item['EVNDOCINVITE']=='1') && ($this->folder->getType()=='N')){
                $this->item['INVITETICKET'] = $this->folder->account->gwAPI->FunctionCall('GetInvitePublicLink', $sFID, $this->itemID);
            }
        }
        if ($this->item['EVNMENTIONS_INFO'] ?? false) {
            $list = MerakGWAPI::ParseParamLine($this->item['EVNMENTIONS_INFO']);
            $sAddonsXML .= '<mentions>';
            if (is_array($list)) foreach ($list as $itm) {
                $sAddonsXML .= '<mention uid="' . $itm['ID'] . '"><values>';
                unset($itm['ID']);
                if (is_array($itm)) foreach ($itm as $in => $iv) {
                    $in = strtolower($in);
                    $sAddonsXML .= '<' . $in . '>' . @slToolsPHP::htmlspecialchars(trim($iv)) . '</' . $in . '>';
                }
                $sAddonsXML .= '</values></mention>';
            }
            $sAddonsXML .= '</mentions>';
            unset($this->item['EVNMENTIONS_INFO']);
        }
        if(empty($this->item['EVNTHUMBNAILID']) && strpos($fields, 'evnthumbnailid') !== false && preg_match('/&core_thumbnailimage_id=(?P<id>[^&]+)/ui', $this->item['EVN_METADATA'] ?? '', $matches)){
            $this->item['EVNTHUMBNAILID'] = $matches['id'];
        }

        $this->sFields = $this->composeXML($sAddonsXML);
        $this->wmclass = 'GW';
    }

	static public function fixAttachmentName($name)
	{
		$api = IceWarpAPI::instance();
		$c_os = $api->getProperty('C_OS');
        $regex = '/\//si';
		if($c_os==0){
			$regex ='/(:|\/|\\|\*|\||")/si';
		}

        $name = trim(preg_replace($regex, '', $name));
        return $name;
    }

     
    private function setPrefix($item = null)
    {
        $item = array_change_key_case($item, CASE_UPPER);
         
        if ($item) $this->item = $item;
         
        if ((isset($item["ITMCLASS"]) && ($item["ITMCLASS"] == 'C' || $item["ITMCLASS"] == 'L')) || strtolower($item['ITMFOLDER'] ?? '') == '@@trash@@') {
            $sPrefix = 'ITM';
        } else {
            $sPrefix = 'EVN';
        }
         
        $this->itemPrefix = $sPrefix;
    }

    public function getAddons($type = false)
    {
        $type = $type ? $typr : $this->itemType;
        $oAddon = array();
        $oAddon['attachment'] = new GroupWareAddon($this, 'attachment');
        switch ($type) {
            case 'C':
                $oAddon['location'] = new GroupWareAddon($this, 'location');
                $oAddon['certificate'] = new GroupWareAddon($this, 'certificate');
                $oAddon['location']->enableConvertNote();
                break;
                         case 'L':
                $oAddon['location'] = new GroupWareAddon($this, 'location');
                break;
            case 'E':
                $oAddon['recurrence'] = new GroupWareAddon($this, 'recurrence');
                $oAddon['reminder'] = new GroupWareAddon($this, 'reminder');
                $oAddon['contact'] = new GroupWareAddon($this, 'contact');
                $oAddon['note'] = new GroupWareAddon($this, 'note');
                $oAddon['note']->enableConvertNote();
                if ($this->folder->getType() == 'I') {
                    $oAddon['reaction'] = new GroupWareAddon($this, 'reaction');
                }
                break;
            case 'T':
                $oAddon['recurrence'] = new GroupWareAddon($this, 'recurrence');
                $oAddon['reminder'] = new GroupWareAddon($this, 'reminder');
                $oAddon['contact'] = new GroupWareAddon($this, 'contact');
                $oAddon['note'] = new GroupWareAddon($this, 'note');
                $oAddon['note']->enableConvertNote();
                break;
            case 'N':
                $oAddon['note'] = new GroupWareAddon($this, 'note');
                $oAddon['note']->enableConvertNote();
                break;
            case 'M':
            case 'F':
                $oAddon['revision'] = new GroupWareAddon($this, 'revision');
                $oAddon['revision']->enableConvertNote();
                if ($this->folder->getType() == 'I') {
                    $oAddon['reaction'] = new GroupWareAddon($this, 'reaction');
                }
                if ($type == 'M') {
                    $oAddon['xattribute'] = new GroupWareAddon($this, 'xattribute');
                }
                break;
            case 'J':
                $oAddon['contact'] = new GroupWareAddon($this, 'contact');
                break;
            case 'G':
            case 'Y':
            case 'I':
            case 'Q':
            case 'R':
            case 'D':
            case 'S':
            case 'Z':
                $itemType = $this->item[$this->itemPrefix . 'CLASS'];
                if (in_array($itemType, array('Q', 'I', 'R', 'S', 'W', 'D', 'Y', 'M', 'Z'))) {
                    $oAddon['reaction'] = new GroupWareAddon($this, 'reaction');
                    if ($itemType == 'M') {
                        $oAddon['xattribute'] = new GroupWareAddon($this, 'xattribute');
                        $oAddon['revision'] = new GroupWareAddon($this, 'revision');
                    }else{
                        unset($oAddon['attachment']);
                    }
                } else {
                    return $this->getAddons($itemType);
                }
                break;
        }
        return $this->aAddons = $oAddon;
    }

    public function getAddon($sAddonType)
    {
        if(!isset($this->aAddons)){
            $this->getAddons();
        }
        if(isset($this->aAddons[$sAddonType])){
            return $this->aAddons[$sAddonType];
        }
        return null;
    }

    public function getAddonData($sAddonType, $param = false)
    {
        $result = false;
        $addon = $this->getAddon($sAddonType);
        if($addon){
            $result = $addon->loaded ? $addon->data : $addon->getData($param);
        }
        return $result;
    }

    public static function import(&$folder, $sType, $sData, $delete_after_import)
    {
         
        $sFID = $folder->openAccess();
        switch($sType)
        {
            case 'vcalendar':
            case 'sif':
                                                  if (true === $delete_after_import) {
                    $sType .= ';ALLOWOCCURRENCE';
                }
                if(!$sIID = $folder->account->gwAPI->FunctionCall("AddVCalendar", $sFID, $sData, '', $sType)){
                    throw new Exc('import_vcalendar');
                }
                $folder->type = 'E';
                break;
            case 'vcard':
            case 'ldif':
                 
                if(!$sIID = $folder->account->gwAPI->FunctionCall("AddVCard", $sFID, $sData, '', $sType)){
                    throw new Exc('import_vcard');
                }
                break;
        }
        $oItem = $folder->getItem($sIID);
        return $oItem;
    }

	 
	public static function create(&$folder,$aItem = [],$aTreeItem = [])
	{
         
        $sFID = $folder->openAccess();
         		$aItem = array_change_key_case($aItem, CASE_UPPER);
        if($folder->getType() == 'J' && !empty($aItem['EVNMEETINGID'] ?? null)){
            $filter = ['sql' => icewarp_sanitize_db_sql('EvnMeetingId = ' . $aItem['EVNMEETINGID'] . ' AND EvnStartDate = ' . $aItem['_TZEVNSTARTDATE'])];
            $item = $folder->getItems($filter);
            if(current($item) instanceof GroupWareItem) return current($item);
        }

		$duplicityAction = $aItem['DUPLICITY'];
		unset($aItem['DUPLICITY']);
		if(strtoupper($folder->folderID) == '@@MYCARD@@'){
			$aItem['ITMUID'] = '@@mycard@@';
			self::setAccountName($aItem['ITMCLASSIFYAS']);
		}
		$isRecurrent = isset($aTreeItem['@childnodes']['recurrences']);
		if($isRecurrent){
			unset($aItem['CTZ']);
			$aItem['EVNTIMEFORMAT'] = 'Z';
		}
		if(!$aItem['_TZID']){
			$aItem['_TZID'] = $_SESSION['CLIENT_TIMEZONE'] ? $_SESSION['CLIENT_TIMEZONE'] : $_SESSION['SERVER_TIMEZONE'];
		}
		if(isset($aItem['EVNFLAGS']) && self::isOrganizator($aItem['EVNFLAGS']) ){
            $groupchatowneremail = '';
			$sOrganizer = $folder->account->gwAPI->getFolderOwner($folder,$groupchatowneremail);
			$sOrganizerFullAddress = $folder->account->gwAPI->getOwnerFullAddress($sOrganizer,$groupchatowneremail);
			$aItem['EVNORGANIZER'] = $sOrganizerFullAddress;
		}

		 		if(($folder->getType() == 'F' || ($folder->getType() == 'I' && ($aItem['EVNCLASS'] == 'F' || $aItem['EVNCLASS'] == 'M'))) && !self::checkAttachmentName($aItem['EVNTITLE'])){
		    throw new Exc('attachment_name',$aItem['EVNTITLE']);
		}
		         $sPrefix = 'EVN';
        $addMethod = 'AddEventInfo';
        $sNote = 'EVNNOTE';
        if ($folder->getType() == 'C') {
            $sPrefix = 'ITM';
            $addMethod = 'AddContactInfo';
            $sNote = 'ITMDESCRIPTION';
        }
        $aItem[$sPrefix.'CLASS'] = $aItem[$sPrefix.'CLASS'] ?? $folder->getType();

        if(isset($aItem['SKIP_INVITATION'])){
            $skipInvitation = $aItem['SKIP_INVITATION'];
            unset($aItem['SKIP_INVITATION']);
        }
                 $meetingInfo = self::extractNoteAndMeetingInfo($folder, $aItem, $aTreeItem);
		$tzid = $aItem['_TZID'];
		$folder->account->gwAPI->TZClearCache();
		$folder->account->gwAPI->TimeZone($aItem,'in',false,$isRecurrent);
        if(isset($aItem['EVNURL'])){
            $aItem['EVNURL'] = iconv_substr(slToolsString::utf8_bad_replace(slToolsString::removeHTML($aItem['EVNURL'])),0,255, 'utf-8');
        }
		 		$sParametersLine = $folder->account->gwAPI->CreateParamLineStrictLength($aItem, ['EVNURL' => 255, 'EVNTITLE' => 510, 'EVNLOCATION' => 510, 'EVNRID' => 255]);
        $sParameters = 'use_tzid=1';
        if ($sParametersLine) {
            $sParameters .= '&' . $sParametersLine;
        }
        if ($duplicityAction == 'replace') {
            $sParameters .= '&forcereplace=1';
        }
        if ($aItem['THUMBNAILIMAGEID']) {
            $sParameters .= '&thumbnailimageid=' . $aItem['THUMBNAILIMAGEID'];
            unset($aItem['THUMBNAILIMAGEID']);
        }
        if($meetingInfo['note_set'] && $folder->getType() != 'N') $sParameters .= ';SKIP_GROUPCHAT_PROCESSING';
		 		if(!$sEvnId = $folder->account->gwAPI->FunctionCall($addMethod, $sFID, $sParameters, "")){
			$lastError = $folder->account->gwAPI->FunctionCall("GetLastError",$folder->account->sGWSessionID);

            if($lastError != 13) throw new Exc('item_create',$sEvnId);
            if($folder->subtype != 'U') throw new Exc('item_duplicity',$aItem['EVNTITLE']);

                         $freename = GroupWareItem::proposeFreeFileName($folder, $aItem['EVNLOCATION']);
            $originalFilename = $aItem['EVNLOCATION'];
            $aTreeItem['@childnodes']['attachments'][0]['@childnodes']['attachment'][0]['@childnodes']['values'][0]['@childnodes']['description'][0]['@value'] = $freename;
            $aTreeItem['@childnodes']['values'][0]['@childnodes']['evntitle'][0]['@value'] = $freename;
            $aTreeItem['@childnodes']['values'][0]['@childnodes']['evnlocation'][0]['@value'] = $freename;
            $aTreeItem['@childnodes']['values'][0]['@childnodes']['evnrid'][0]['@value'] = $freename;
            $aItem['EVNTITLE'] = $aItem['EVNLOCATION'] = $aItem['EVNRID'] = $freename;
            $sParameters = $folder->account->gwAPI->CreateParamLineStrictLength($aItem,  ['EVNURL' => 255, 'EVNTITLE' => 510, 'EVNLOCATION' => 510, 'EVNRID' => 255]);
            if($meetingInfo['note_set'] && $folder->getType() != 'N') $sParameters .= ';SKIP_GROUPCHAT_PROCESSING';
            $sEvnId = $folder->account->gwAPI->FunctionCall($addMethod, $sFID, $sParameters, "");
		}

        $aItem[strtoupper($sPrefix . '_ID')] = $sEvnId;
        $aItem['EVN_CREATED'] = time();
        $item = new GroupWareItem($folder, $aItem);
        $item->sFID = $sFID;

        if($meetingInfo['note_set'] && ($aItem['meeting_action'] == '1' || $aItem['meeting_action'] == 'create')){
             $reloadedItem = $folder->getItem($sEvnId, NO_ADDONS);
             if($reloadedItem instanceof GroupWareItem) {
                 $meetingInfo['note_value'] = $reloadedItem->item['EVNNOTE'];
             }
             unset($reloadedItem);
        }
        $result = $item->processItemExtras($aItem, $aTreeItem, $meetingInfo, true);
        if($result!==false){
            $item = $result;
        }
		         $finalizeParams = $item->folder->getType() == 'I' ? '&return_link_id=1' : '';
		$id = $folder->account->gwAPI->FunctionCall($addMethod, $sFID, $finalizeParams, $sEvnId);
		if($item->folder->getType() == 'I'){
			parse_str($id,$result);
			if($result['linkid']){
				$item->linkID = $result['linkid'];
			}
		}
		if($folder->getType() == 'I') $folder->groupChatLastActivity = $aItem['EVN_CREATED'];
        if(!$skipInvitation && self::isOrganizator($item->item['EVNFLAGS'])){
            $item->createInvitation();
        }
		return $item;
	}

	static public function proposeFreeFileName($folder,$name,$itemid = '')
	{
		$folder->openAccess();
		return $folder->account->gwAPI->FunctionCall("ProposeFreeFileName", $folder->sFID, $name, $itemid);
	}

	static public function isOrganizator($flags)
	{
		$flags = (int) $flags;
		return  $flags & GroupWareItem::FLAG_ORGANIZATOR;
	}

    static public function isAttendee($flags)
    {
        $flags = (int)$flags;
        return $flags & GroupWareItem::FLAG_ATTENDEE;
    }

    static public function isInvitation($flags)
    {
        return self::isAttendee($flags) || self::isOrganizator($flags);
    }

    static public function isOccurrance($class)
    {
        return ($class=='O' || $class=='V');
    }

    static public function isGroupChatAttendee($flags)
    {
        $flags = (int)$flags;
        return $flags & GroupWareItem::FLAG_GROUPCHATATTENDEE;
    }

    public function getException($rcr_id, $occurence_id)
    {
        $oAccount = &$this->folder->account;
                 $this->openAccess();

        $exceptions = $oAccount->gwAPI->FunctionCall('GetEventException', $this->sFID, $rcr_id);
        $exceptions = $oAccount->gwAPI->ParseParamLine($exceptions);
        if ($exceptions) {
            foreach ($exceptions as $exception) {
                if ($exception['EXPEVNID'] == $occurence_id) {
                    return $exception;
                }
            }
        }
    }

      
    public function delete($reason = '', $ignore_reason = false, $skip_trash = false, $skip_imip = false)
    {
                 if (GroupWareItem::isAttendee($this->item['EVNFLAGS']) && !$reason && !$ignore_reason) {
            throw new Exc('item_decline_failed_id', $this->itemID);
        }
                 $oAccount = &$this->folder->account;
                 $updateMaster = false;
                 $getMaster = false;
                 $masterObject = &$this;
                 $result = false;
                 $this->openAccess();
                 $oAccount->gwAPI->TZClearCache();
        $oAccount->gwAPI->TimeZone($this->item, 'in');
        $datestamp = $this->datestamp ?? false;
        $following = $this->following ?? false;

                          if ($datestamp && ($this->isClassic($datestamp, $following) === false)){
            $updateMaster = true;
            $result = $this->datestampDelete($datestamp, $following, $skip_trash, $skip_imip, $reason);
                 }elseif(self::isOccurrance($this->item['EVNCLASS'])){
            if($this->item['EVNCLASS']=='O'){
                $updateMaster = true;
                $getMaster = true;
            }
            $result = $this->datestampDelete($datestamp, $following, $skip_trash, $skip_imip, $reason);
        }
         
                 if($updateMaster){
            $masterObject = $this->getUpdatedMasterObject($getMaster);
        }
                 if(!$skip_imip && self::isInvitation($this->item['EVNFLAGS'])){
            $invitationInfo = [
                'current_list' => [],
                'changed_list' => $this->getAddonData('contact'),
                'sent_nothing' => $skip_imip,
                'send_counter' => !self::isOccurrance($this->item['EVNCLASS']) && self::isAttendee($this->item['EVNFLAGS']),
                'reset_attendees' => true
            ];
            $this->imipUpdate($masterObject, $this->item, array(),$invitationInfo, $following?'':$datestamp, true);
        }

                          if ($datestamp && ($this->isClassic($datestamp, $following) === false)){
                 }elseif(self::isOccurrance($this->item['EVNCLASS'])){
            $result =  $this->deleteOccurrance();
                 }else{
            $result = $this->classicDelete($skip_trash, $skip_imip, $reason);
        }
         
        return $result;
    }

    private function datestampDelete($datestamp, $following, $skip_trash, $skip_imip, $reason)
    {
        $result = false;
                 if ($following) {
                         $addon = $this->getAddon('recurrence');
            $addonData = current($this->getAddonData('recurrence'));
            $addonData['RCRENDDATE'] = $datestamp - 1;
            $addonData['RCR_COUNT'] = 0;
            $result = $addon->edit($addonData, $addonData['RCR_ID']);
            $result = $this->deleteExceptions($addonData['RCR_ID'], true, $datestamp - 1) && $result;
                 } elseif(!$this->isGroupChatAttendee($this->item['EVNFLAGS'])) {
            $result = $this->addException($datestamp, $this->item['EVNRCR_ID']);
        }
        return $result;
    }

    private function deleteInvitation(&$skip_imip, $reason)
    {
        $result = false;
        try {
            if (!$skip_imip && $this->folder->type != 'G' && $this->item['EVNFLAGS']) {
                                 if($this->isOrganizator($this->item['EVNFLAGS'])){
                    $skip_imip = true;
                    $this->cancel();
                                 } elseif($this->isAttendee($this->item['EVNFLAGS'])){
                    $result = $this->decline($reason);
                }
            }
		}catch(Exc $imipException){
			$result = false;
		}
        return $result;
    }

    private function classicDelete($skip_trash = false, &$skip_imip = false, $reason = 'Deleted')
    {
        $oAccount = &$this->folder->account;
        if(self::isInvitation($this->item['EVNFLAGS'])){
           $result =  $this->deleteInvitation($skip_imip, $reason);
           $skip_imip = true;
           if($result !== false){
                return $result;
           }
        }
        if($skip_trash){
            $sParameters = ';NORECOVERY';
        }
                 $result = $oAccount->gwAPI->FunctionCall($this->deleteMethod, $this->sFID, $this->itemID, '0', $sParameters);

        return $result;
    }

    public function deleteOccurrance()
    {
        $result = false;
                 if (!$result = $this->folder->account->gwAPI->FunctionCall($this->deleteMethod, $this->sFID, $this->itemID, strval(true))) {
            throw new Exc('item_delete_occurrance', $this->itemID);
        }
        return $result;
    }

    public function deleteExceptions($sRcrID, $occurrances = false, $datestamp = false)
    {
        $oAccount = $this->folder->account;
        $result = true;
                 $exceptions = $oAccount->gwAPI->FunctionCall('GetEventException', $this->sFID, $sRcrID);
        $exceptions = $oAccount->gwAPI->ParseParamLine($exceptions);
                 if ($exceptions) foreach ($exceptions as $exception) {
            if (($datestamp < $exception['EXPDATE']) || !$datestamp) {
                                 if ($exception['EXPEVNID'] && $occurrances && !$result = $oAccount->gwAPI->FunctionCall('DeleteEvent', $this->sFID, $exception['EXPEVNID'], strval(true))) {
                    throw new Exc('item_delete', $exception['EXPEVNID']);
                }
                $oAccount->gwAPI->FunctionCall('DeleteEventException', $this->sFID, $exception['EXP_ID']);
            }
        }
        return $result;
    }

	public function moveExceptions($oldRcrID,$newRcrID,$datestamp = false)
	{
		$oAccount = $this->folder->account;
		return $oAccount->gwAPI->FunctionCall('MoveEventException', $this->sFID, $oldRcrID, $newRcrID, " EXPDATE > ".$datestamp);
    }

    protected function renameTeamChatFile(&$aItem)
    {
        $existing = $this->getAddonData('attachment');
        if(is_array($existing) && !empty($existing)){
            foreach($existing as $att){
                if($att['ATTDESC'] == $this->item['EVNTITLE']){
                    $attID = $att['ATTNAME'];
                }
            }
            if(!$attID){
                throw new Exc('item_attachment_uid');
            }
        }
        $attachments = array();
        $attachment = array();
        $attachment['@childnodes']['values'][0]['@childnodes']['description'][0]['@value'] = $aItem['EVNTITLE'];
        $attachment['@attributes']['uid'] = $attID;
        $attachments['@childnodes']['attachment'][$attID] = $attachment;
        $aTreeItem['@childnodes']['attachments'][0] = $attachments;
        $aTreeItem['@childnodes']['values'][0]['@childnodes']['evnlocation'][0]['@value'] = $aItem['EVNTITLE'];
        $aTreeItem['@childnodes']['values'][0]['@childnodes']['evnrid'][0]['@value'] = $aItem['EVNTITLE'];
        $aItem['EVNLOCATION'] = $aItem['EVNRID'] = $aItem['EVNTITLE'];
    }


     
	public function edit($aItem, $aTreeItem, $_datestamp = null, $_following = null, $finalize = false)
	{
        $tmp = $aItem;
        $tmp2 = $aTreeItem;
                 $sFID = $this->openAccess();
        $aItem = array_change_key_case($aItem, CASE_UPPER);
         		$oAccount = &$this->folder->account;
         		$oAccount->gwAPI->TZClearCache();
		$oAccount->gwAPI->TimeZone($aItem, 'in');
                 $result = false;
                 $masterObject = &$this;
                 $updateMaster = false;
                 $getMaster = false;
                 if((boolval($this->item['EVNLOCKAPPMASK']) || !empty($this->item['EVNLOCKHASH'])) && $this->item['EVNLOCKOWN_ID'] != $_SESSION['GW_OWNERID']){
			             throw new Exc('item_attachment_uid_locked');
        }
                 if ($this->folder->getType() == 'E' && $this->isGroupChatAttendee($this->item['EVNFLAGS'])) {
            throw new Exc('item_edit_groupchat_attendee');
        }
         		if($this->folder->getType() == 'F' || ($this->folder->getType() == 'I' && $aItem['EVNCLASS'] == 'F')){
			if(!self::checkAttachmentName($aItem['EVNLOCATION'])){
				throw new Exc('attachment_name');
			}
		}
                 if(isset($aItem['EVNTITLE']) && $this->item['EVNCLASS'] == 'F' && $this->folder->getType() == 'I'){
            $this->renameTeamChatFile($aItem);
        }
                 if($this->folder->folderID == '@@mycard@@' && isset($aItem['ITMCLASSIFYAS'])){
       	    self::setAccountName($aItem['ITMCLASSIFYAS']);
		}
		         if(isset($aItem['EVNURL'])){
            $aItem['EVNURL'] = iconv_substr(slToolsString::utf8_bad_replace(slToolsString::removeHTML($aItem['EVNURL'])),0,255, 'utf-8');
		}
         		if(isset($aItem['DATA'])){
			$data = $aTreeItem['@childnodes']['values'][0]['@childnodes']['data'][0]['@value'];
			$data = self::replaceCID($data, $aTreeItem);
			$aTreeItem['@childnodes']['values'][0]['@childnodes']['data'][0]['@value'] = $data;
			if(!isset($aItem['EVNCOMPLETE'])){
				$aItem['EVNCOMPLETE'] = strlen($data);
			}
			unset($aItem['DATA']);
		}
        if($aItem['_TZID']){
            self::removeTimeTags($aItem, CASE_UPPER);
		}else{
            self::removeTimeTags($aItem, CASE_UPPER, true);
		}
                 $datestamp = $this->datestamp ?? $aItem['EXPDATE'];
        $following = $this->following ?? ($aItem['EXPFOLLOWING']?true:false);
        $editInfo = self::getEditInfo($aItem, $aTreeItem);
    	 		if ($datestamp && ($this->isClassic($datestamp, $following)==false)){
            $updateMaster = true;
            $result = $this->datestampEdit($aItem, $aTreeItem, $editInfo, $datestamp, $following);
		}elseif(self::isOccurrance($this->item['EVNCLASS'])){
            if($this->item['EVNCLASS']=='O'){
                $updateMaster = true;
                $getMaster = true;
            }
            if ($following) {
                $eventsline = $this->folder->account->gwAPI->FunctionCall('GetEventList', $this->sFID, "evnrcr_id='" . $this->item['EVNRCR_ID'] . "' AND EVNCLASS='E'", 'evntitle');
                $eventsline = $this->folder->account->gwAPI->ParseParamLine($eventsline);
                $event = $eventsline[0];
                if (!$event) {
                    $result = $this->editOccurrance($aItem, $aTreeItem, $editInfo);
                } else {
                    $this->deleteOccurrance();
                    $oItem = $this->folder->getItem($event['EVN_ID'], WITH_ADDONS, 0, 0);
                    $tmp['evnclass'] = 'E';
                    return $oItem->edit($tmp, $tmp2, null, null, true);
                }
            } else {
                $result = $this->editOccurrance($aItem, $aTreeItem, $editInfo);
            }
        }else{
            $result = $this->classicEdit($aItem, $aTreeItem, $editInfo);
        }
                 if($finalize && (!$updateMaster || ($masterObject->itemID!==$this->itemID))){
            $result = $oAccount->gwAPI->FunctionCall($this->addMethod, $this->sFID, '', $this->itemID);
        }

                 if($updateMaster){
            $masterObject = $this->getUpdatedMasterObject($getMaster);
        }
                 if(self::isInvitation($this->item['EVNFLAGS']) || self::isInvitation($aItem['EVNFLAGS'])){
            $this->imipUpdate(
                $masterObject,
                $aItem,
                $aTreeItem,
                $editInfo['invitation'],
                $following?'':$datestamp
            );
        }
        return $result;
	}

    private function classicEdit(&$aItem, &$aTreeItem, &$editInfo)
    {
        $oAccount = &$this->folder->account;
                 if (($aItem['EVNCLASS']!='T' && $this->item['EVNCLASS']!='T') && isset($aItem['EVNSTARTDATE']) && isset($aItem['EVNENDDATE'])) {
            $addon = $this->getAddon('recurrence');
            $aAddon = $this->getAddonData('recurrence');
            if ($aAddon && $aAddon['RCRENDDATE']) {
                $aAddon = $aAddon[0];
                $oldEnd = $aAddon['RCRENDDATE'];
                $diff = $aItem['EVNSTARTDATE'] - $this->item['EVNSTARTDATE'];
                if ($aAddon['RCRENDDATE']) {
                    $aAddon['RCRENDDATE'] += $diff;
                    $result = $addon->edit($aAddon, $aAddon['RCR_ID']);
                }
            }
        }
                 $sItem = $oAccount->gwAPI->CreateParamLine($aItem);
        if($sItem){
            $sItem = 'use_tzid=1&'.$sItem;
        }
        if($editInfo['duplicity']=='replace'){
            $sItem .= ($sItem?'&':'').'forcereplace=1';
        }
        if($aItem['THUMBNAILIMAGEID']){
            $thumbnail = $aItem['THUMBNAILIMAGEID'];
            unset($aItem['THUMBNAILIMAGEID']);
            $sItem .= ($sItem ? '&' : '').'thumbnailimageid='.$thumbnail;
        }
                 if($sItem && !$result = $oAccount->gwAPI->FunctionCall($this->addMethod, $this->sFID, $sItem, $this->itemID)){
            $lastError = self::getError($oAccount->gwAPI);
            if($lastError == 13){
                $fullpath = $oAccount->account->accountID.'/'.$this->folder->folderID.'/'.$this->itemID;
                $error = '<duplicate><item><class>item</class><fullpath>'.$fullpath.'</fullpath><name>'.$aItem['EVNTITLE'].'</name><freename>'.self::proposeFreeFileName($this->folder,$aItem['EVNTITLE']).'</freename></item></duplicate>';
                throw new XMLExc('items_duplicity', $error);
            }
            throw new Exc('item_edit', MerakGWAPI::getGwErrorMessage(self::getError($oAccount->gwAPI)));
        }

        $invitationInfo = &$editInfo['invitation'];
                 if(!empty($aTreeItem['@childnodes']['recurrences'][0]['@childnodes']['recurrence'] ?? null) || !empty($aTreeItem['@childnodes']['attachments'][0]['@childnodes']['attachment'] ?? null)){
            $invitationInfo['reset_attendees'] = true;
            $invitationInfo['send_counter']  =  (bool)$invitationInfo['is_attendee'];
        }
                 if('create' == $editInfo['note_and_meeting']['action']){
            $invitationInfo['reset_attendees'] = true;
            $invitationInfo['send_counter']  = false;        }

        $this->processItemExtras($aItem, $aTreeItem, $editInfo['note_and_meeting']);

		return $result;
    }

    private function datestampEdit(&$aItem, &$aTreeItem, &$editInfo, &$datestamp, $following)
    {
        $result = false;
                 if (!$following) {
                         if (!self::isOccurrance($this->item['EVNCLASS'])) {
                $result = $this->addOccurrance($aItem, $aTreeItem, $editInfo, $datestamp);
            }
                 } else {
            $result = $this->editAllFollowing($aItem, $aTreeItem, $editInfo, $datestamp);
        }
        return $result;
    }

    private function isClassic($datestamp, $following)
    {
        $isFirstDisplayDate = $this->item['EVNSTARTDATE'] == $datestamp;
        $isDisplayedOnlyThisDay = $this->isDisplayedOnlyThisDay($this->itemID, $datestamp);
                 return ($following && ($isFirstDisplayDate || $isDisplayedOnlyThisDay)) || ($isFirstDisplayDate && $isDisplayedOnlyThisDay);
    }

    private function editAllFollowing(&$aItem, &$aTreeItem, &$editInfo, $datestamp)
    {
        $result = false;
        if(self::isAttendee($this->item['EVNFLAGS'])){
            throw new Exc('item_edit_all_following_attendee');
        }
        if($this->item['EVNSTARTDATE'] != $datestamp){
            $oldStartDate = $aItem['_TZID']?$this->item['_TZEVNSTARTDATE']:$this->item['EVNSTARTDATE'];
                         $addon = $this->getAddon('recurrence');
            $oldAddon = $this->getAddonData('recurrence');
            $oldAddon = $oldAddon[0];
            $oldEnd = $oldAddon['RCRENDDATE'];
            $oldStart = $oldStartDate;
            $oldRcrID = $oldAddon['RCR_ID'];
            $newAddon = $oldAddon;
            $newAddon['RCRENDDATE'] = $datestamp - 1;
            if(!$oldAddon['RCRCCOUNT']){
                unset($newAddon['RCRCOUNT']);
            }
                         if ($oldAddon['RCRCOUNT']){
                $sAddonParams = $this->folder->account->gwAPI->CreateParamLine($oldAddon);
                $newEndDate = $this->folder->account->gwAPI->FunctionCall('GetEventRecurrenceEndDate', $this->folder->account->sGWSessionID, $oldStartDate.'-'.($oldStartDate + 3650), $sAddonParams);
                $oldAddon['RCRENDDATE'] = $newEndDate;
                $oldAddon['RCRCOUNT'] = 0;
            }
                         $result = $addon->edit($newAddon, $newAddon['RCR_ID']);

                         self::removeEditTags($aItem, CASE_UPPER, false);
            $newItem = $this->createFromCurrent($aItem, $aTreeItem, $datestamp, $editInfo, false, false, false);

                         $addon = $newItem->getAddon('recurrence');
            $newAddon = $oldAddon;
            foreach ($aTreeItem['@childnodes']['recurrences'] ?? [] as $recurrences) {
                foreach ($recurrences['@childnodes']['recurrence'] ?? [] as $recurrence) {
                    foreach ($recurrence['@childnodes']['values'] ?? [] as $values) {
                        foreach ($values['@childnodes'] ?? [] as $key => $value) {
                            $newAddon[strtoupper($key)] = $value[0]['@value'];
                        }
                    }
                }
            }
            unset($newAddon['RCR_ID']);
            $newRcrID = $addon->create($newAddon);
                         $this->moveExceptions($oldRcrID, $newRcrID, $datestamp);
                         if($finalize){
                $this->folder->account->gwAPI->FunctionCall($this->addMethod, $this->sFID, '', $newItem->itemID);
            }
                         $invitationInfo = $editInfo['invitation'];
            if($newItem && !$invitationInfo['sent_nothing']){
                $newItem->createInvitation();
            }
                         if ($oldStartDate == $datestamp){
                $this->folder->deleteItems(array(0 => $this));
            }
            return $newItem->itemID;
        }
    }

    private function editOccurrance(&$aItem,&$aTreeItem, &$editInfo)
    {
        $result = false;
        unset($aItem['EXPDATE']);
        $sItem = $this->folder->account->gwAPI->CreateParamLine($aItem);
        if($sItem){
            $sItem = 'use_tzid=1&'.$sItem;
        }

        $masterID = $this->updateMasterObject($this->folder->account);

                 if (!$result = $this->folder->account->gwAPI->FunctionCall("AddEventInfo", $this->sFID, $sItem, $this->itemID)){
            throw new Exc('item_edit', MerakGWAPI::getGwErrorMessage(self::getError($this->folder->account->gwAPI)));
        }

                 $this->processItemExtras( $aItem, $aItreeItem, $editInfo['note_and_meeting']);

        $invitationInfo = &$editInfo['invitation'];
        $invitationInfo['current_list'] = $this->getAddonData('contact');

        return $result;
    }

	private function getNextDisplayOcurrance($evnID,$datestamp)
	{
		$items = $this->getItemInstances($evnID,$datestamp);
		if($items){
			foreach($items as $item){
				if($item['EVNSTARTDATE']>$datestamp){
					return $item;
				}
			}
		}
		return false;
	}

	 	private function isFirstDisplayDate($evnID,$datestamp)
	{
		$items = $this->getItemInstances($evnID,$datestamp);
		if($items){
			foreach($items as $item){
				if($item['EVNSTARTDATE']<$datestamp){
					return false;
				}
			}
		}
		return true;
	}

	private function isDisplayedOnlyThisDay($evnID,$datestamp)
	{
		$items = $this->getItemInstances($evnID,$datestamp);
		$count = count($items);
		return (bool)($count <= 1);
	}

	private function getItemInstances($evnID,$datestamp)
	{
		if(!$this->itemInstancesLoad){
			$fields = 'EVN_ID,EVNSTARTDATE';
			$interval = ($datestamp - CHECK_INTERVAL).'-'.($datestamp + CHECK_INTERVAL).';;;;max=9';
			$filter = "EVN_ID = '".$evnID."'";
			$items = $this->folder->account->gwAPI->FunctionCall('GetAllIntervalEvents', $this->folder->sFID, $interval, $filter, $fields);
			$this->itemInstances = $this->folder->account->gwAPI->ParseParamLine($items);
            $this->itemInstancesLoad = true;
		}
		return $this->itemInstances;
	}

    private function imipUpdate(&$masterItem, $aItem, $aTreeItem, &$invitationInfo, $datestamp = '', $delete = false)
    {
        $aCurrentList = &$invitationInfo['current_list'];
        $aCurrentID = &$invitationInfo['currentid_list'];
        $aChangedList = &$invitationInfo['changed_list'];
        $bResetAttendees = &$invitationInfo['reset_attendees'];
        $sentNothing = &$invitationInfo['sent_nothing'];
        $sentAlways = &$invitationInfo['sent_always'];
        $bSendCounterAction = &$invitationInfo['send_counter'];
        $aDelete = [];


        $isOccurrance = self::isOccurrance($this->item['EVNCLASS']);

        if ($sentNothing) return;

                 if (!$masterItem->isOrganizator($masterItem->item['EVNFLAGS']) && !$masterItem->isOrganizator($aItem['EVNFLAGS']) && !$bSendCounterAction) return;

                 $occurranceItem = $masterItem;
        if ($isOccurrance || !$datestamp) {
            $occurranceItem = $this;
        }
        $occurranceItem->aAttendees = $aCurrentID;
                 if ($aChangedList) {
            foreach ($aChangedList as $key => $aAttendee) {
                if ($uid = $aAttendee['@attributes']['uid'] ?? false) {
                    if (isset($aAttendee['@childnodes']['values'])) {
                        $sEmail = $aAttendee['@childnodes']['values'][0]['@childnodes']['cntemail'][0]['@value'];
                        $aAction['action'] = 'change';
                        $aAction['email'] = $sEmail;
                        $bResetAttendees = true;
                        if ($occurranceItem->aAttendees[$uid]['CNTEMAIL'] != $aAction['email']) {
                            $aAction['action'] = 'invite';
                            if ($aCurrentList) {
                                foreach ($aCurrentList as $itm) {
                                    if ($itm['CNTEMAIL'] == $occurranceItem->aAttendees[$uid]['CNTEMAIL']) {
                                        $aDelete[] = $itm;
                                    }
                                }
                            }
                            if (isset($aCurrentID[$uid])) {
                                $aCurrentID[$uid]['CNTCONTACTNAME'] = $aAttendee['@childnodes']['values'][0]['@childnodes']['cntcontactname'][0]['@value'];
                                $aCurrentID[$uid]['CNTEMAIL'] = $aAction['email'];
                            }
                            if ($aCurrentList) {
                                foreach ($aCurrentList as $key => $itm) {
                                    if ($itm['CNTEMAIL'] == $occurranceItem->aAttendees[$uid]['CNTEMAIL']) {
                                        $aCurrentList[$key]['CNTCONTACTNAME'] = $aAttendee['@childnodes']['values'][0]['@childnodes']['cntcontactname'][0]['@value'];
                                        $aCurrentList[$key]['CNTEMAIL'] = $aAction['email'];
                                    }
                                }
                            }
                            $occurranceItem->aAttendees[$uid]['CNTCONTACTNAME'] = $aAttendee['@childnodes']['values'][0]['@childnodes']['cntcontactname'][0]['@value'];
                            $occurranceItem->aAttendees[$uid]['CNTEMAIL'] = $aAction['email'];
                        }
                        $aActions[$aAction['email']] = $aAction;
                    } else {
                                                 if (isset($aCurrentID[$uid])) {
                            $bResetAttendees = true;
                            @$aDelete[] = array_change_key_case($aCurrentID[$uid], CASE_UPPER);
                            unset($aCurrentID[$uid]);
                        }
                    }
                                 } else {
                    $bResetAttendees = true;
                    $aAtt = array();
                    $cursor = &$aTreeItem['@childnodes']['contacts'][0]['@childnodes']['contact'][$key]['@childnodes']['values'][0]['@childnodes'];
                    if ($cursor) {
                        foreach ($cursor as $key2 => $val) {
                            $aAtt[strtoupper($key2)] = $val[0]['@value'];
                        }
                    }
                    $aAtt['CNTRSVP'] = 1;
                    $aAtt['CNTEXPECT'] = 1;
                    $aAtt['CNTCONTACTNAME'] = $aAttendee['@childnodes']['values'][0]['@childnodes']['cntcontactname'][0]['@value'];
                    $occurranceItem->aAttendees[] = $aAtt;
                    $sEmail = $aAttendee['@childnodes']['values'][0]['@childnodes']['cntemail'][0]['@value'];
                    $aAction['action'] = 'invite';
                    $aAction['email'] = $sEmail;
                    $aActions[$aAction['email']] = $aAction;
                }
            }
        }
        if ($aCurrentID) {
            foreach ($aCurrentID as $aCurrent) {
                $aAction['action'] = ($aItem['EVNFLAGS'] && ($aItem['EVNFLAGS'] != $occurranceItem->item['EVNFLAGS'])) ? 'invite' : 'change';
                $aAction['email'] = $aCurrent['CNTEMAIL'];
                $occurranceItem->aAttendees[$aCurrent['CNT_ID']]['CNTRSVP'] = 1;
                $aActions[$aAction['email']] = $aAction;
            }
        }
        $isAttendee = $occurranceItem->isAttendee($aItem['evnflags']) || $occurranceItem->isAttendee($masterItem->item['EVNFLAGS']);
        if ($bResetAttendees || $sentAlways || $bSendCounterAction) {
            $aAttachment = false;
            if ($isAttendee) {
                $aAction['action'] = 'counter';
                $sMethod = 'COUNTER';
            } else {
                $sMethod = 'REQUEST';
            }
            if ($datestamp && $delete) {
                if ($isAttendee) {
                    $occurranceItem->decline('', $datestamp);
                } else {
                    $occurranceItem->cancel($aDelete, $datestamp);
                }
            } else {
                $oInvitation = $masterItem->createInvitation($sMethod, $datestamp, $occurranceItem->itemID);
            }
        }
                 if ($aDelete) {
            $masterItem->cancel($aDelete, $datestamp, $isAttendee);
        }
    }

	private function updateSequence()
	{
		if (!$result = $this->folder->account->gwAPI->FunctionCall("AddEventInfo", $this->sFID, 'evnsequence='.($this->item['EVNSEQUENCE'] + 1), $this->item['EVN_ID'])){
			throw new Exc('item_edit', MerakGWAPI::getGwErrorMessage(self::getError($this->folder->account->gwAPI)));
		}
	}

    public function updateMasterObject($account, $deleteException = false, $occuranceID = false)
    {
        if($occuranceID){
            if (!$this->item['EVNRCR_ID']) {
                return false;
            }

            $eventsline = $account->gwAPI->FunctionCall('GetEventList', $this->sFID, "evnrcr_id='" . $this->item['EVNRCR_ID'] . "'", 'evntitle');  
            $eventsline = $account->gwAPI->ParseParamLine($eventsline);
            $event = $eventsline[0];
            if (!$event)
                return false;
            $evnID = $event['EVN_ID'];
            $evnTitle = $event['EVNTITLE'];
        }else{
            $evnID = $this->itemID;
            $evnTitle = $this->item['EVNTITLE'];
        }
                 $sItem = 'evntitle=' . ($evnTitle);

        if (!$result = $account->gwAPI->FunctionCall("AddEventInfo", $this->sFID, $sItem, $evnID)) {
            throw new Exc('item_edit', MerakGWAPI::getGwErrorMessage(self::getError($account->gwAPI)));
        }

        if ($deleteException || $occuranceID) {
                         $exceptions = $account->gwAPI->FunctionCall('GetEventException', $this->sFID, $this->item['EVNRCR_ID']);
            $exceptions = $account->gwAPI->ParseParamLine($exceptions);

            if ($exceptions) foreach ($exceptions as $exc) {
                if ($exc['EXPRCR_ID'] != $this->item['EVNRCR_ID']) continue;
                $toDelete = $exc['EXP_ID'];
                                 if ($occuranceID && $this->itemID == $exc['EXPEVNID']) {
                                         if ($this->item['EVNCLASS'] != 'V') {
                        $sParam = $account->gwAPI->CreateParamLine(array('EXPEVNID' => ''));
                    }
                    if (!$account->gwAPI->FunctionCall('AddEventException', $this->sFID, $exc['EXPRCR_ID'], $sParam, $exc['EXP_ID'])) {
                        throw new Exc("item_occurance_delete", $exc['EXP_ID']);
                    }
                } else if ($deleteException) {
                                         if (!$account->gwAPI->FunctionCall('DeleteEventException', $this->sFID, $toDelete)) {
                        throw new Exc("item_exception_delete", $toDelete);
                    }
                }
            }
        }
                 $account->gwAPI->FunctionCall("AddEventInfo", $this->sFID, '', $evnID);
        return $evnID;
    }

	  
		public function move($destination)
		{
			$folder = $this->folder;
			$account = $folder->account;
			 			$folder->openAccess();
			 			switch($this->duplicity){
				case 'rename':
					$duplicity = ';COPYRENAMETO='.urlencode($this->rename);
					break;
				case 'replace':
					$duplicity = ';FORCEREPLACE=1';
					break;
			}
			 			if(!$account->gwAPI->FunctionCall("MoveItem", $folder->sFID, $this->itemID, MerakGWAPI::encode($destination->folderID), $duplicity)){
				$lastError = self::getError($account->gwAPI);
				if($lastError == 13){
					throw new Exc('item_duplicity',$this->item['EVNTITLE']);
				}
				throw new Exc('item_move',$this->itemID);
			}
			return true;
		}

	  
		public function copy($destination)
		{
			$folder = $this->folder;
			$account = $folder->account;
			 			$folder->openAccess();
            $duplicity = '';
			 			switch($this->duplicity){
				case 'rename':
					$duplicity .= ';COPYRENAMETO='.urlencode($this->rename);
					break;
				case 'replace':
					$duplicity .= ';FORCEREPLACE=1';
					break;
			}
			if(!GroupWareItem::isOrganizator($this->item['EVNFLAGS'])){
                $duplicity .= ';EXCLUDEATTENDEES';
            }
			if(is_callable([$destination, 'handleCopyItemFrom'])) return $destination->handleCopyItemFrom($folder, $this);
			 			if(!($copiedID = $account->gwAPI->FunctionCall("CopyItem", $folder->sFID, $this->itemID, MerakGWAPI::encode($destination->folderID), $duplicity))){
				$lastError = self::getError($account->gwAPI);
				if($lastError == 13){
					throw new Exc('item_duplicity',$this->item['EVNTITLE']);
				}
				throw new Exc('item_copy',$this->itemID);
			}
			return $copiedID;
		}

		 
		public function addException($datestamp, $occurrance_id = false)
		{
			$this->openAccess();
			$folder = $this->folder;
			$oAccount = $folder->account;
			$result = $oAccount->gwAPI->FunctionCall("GetEventRecurrence", $this->sFID, $this->itemID);
			$result = $oAccount->gwAPI->ParseParamLine($result);
			$sEvnRcrID = $result[0]['RCR_ID'];
			$parameters['expDate'] = $datestamp;
			if ($occurrance_id) {
                $parameters['expEvnID'] = $occurrance_id;
            }
            $parameters = $oAccount->gwAPI->CreateParamLine($parameters);
			return $oAccount->gwAPI->FunctionCall("AddEventException", $this->sFID, $sEvnRcrID, $parameters);
		}

    private function addOccurrance(&$aItem, &$aTreeItem, &$editInfo, &$datestamp)
    {
        $result = false;
                 $recurrence = $aTreeItem['@childnodes']['recurrences'][0]['@childnodes']['recurrence'];
                 $newItem = $this->createFromCurrent($aItem, $aTreeItem, $datestamp, $editInfo);
                 $this->addException($datestamp, !isset($recurrence) ? $newItem->itemID : false);
        $result = $newItem->itemID;
        if(isset($recurrence)){
            $datestamp = false;
            $addon = $newItem->getAddon('recurrence');
            $addon->process($aTreeItem);
            $invitationInfo = &$editInfo['invitation'];
            if(!$invitationInfo['sent_nothing']){
                $newItem->createInvitation();
            }
        }
        return $result;
    }

	 	static public function copyEventAddons(&$sourceItem,&$targetItem,$noreminder = false, $datestamp = false)
	{
		         $attendeeData = $sourceItem->getAddonData('contact');

		         $attachmentData = $sourceItem->getAddonData('attachment');

		         $reminderData = $sourceItem->getAddonData('reminder');
        if ($reminderData && is_array($reminderData)) {
		    $rem = current($reminderData);
            $rem = array_change_key_case($rem, CASE_UPPER);
            unset($rem['RMN_ID']);
            unset($rem['RMNEVN_ID']);
        }

		 		if($attendeeData){
			$newAttendee = $targetItem->getAddon('contact');
			foreach($attendeeData as $attendeeItm){
                if(self::isInvitation($sourceItem->item['EVNFLAGS'])){
                    $attendeeItm['CNTRSVP'] = 1;
                    $attendeeItm['CNTSTATUS'] = 'B';
                }
				unset($attendeeItm['CNTEVN_ID']);
				unset($attendeeItm['CNT_ID']);
				$newAttendee->create($attendeeItm);
			}
		}
		 		if($attachmentData){
			$newAttachment = $targetItem->getAddon('attachment');
			foreach($attachmentData as $attacmentItm){
				$att['class'] = 'attachment';
				$att['fullpath'] = $sourceItem->folder->account->account->accountID.'/'.
				$sourceItem->folder->folderID.'/'.
				$sourceItem->item['EVN_ID'].'/'.
				$attacmentItm['ATTNAME'];
				$att['description'] = $attacmentItm['ATTDESC'];
				$newAttachment->create($att);
			}
		}
		 		if(!$noreminder && $rem){
			$newReminder = $targetItem->getAddon('reminder');
            $newReminder->create($rem);
                         if ($datestamp == slToolsDate::unix2calendardate(time())) {
                $rem['RMNLASTACK'] = strtotime("tomorrow") - 1;
                $reminder = $sourceItem->getAddon('reminder');
                $reminder->edit($rem, $rem['RMN_ID']);
            }
		}
		return $result;
	}

    private static function removeTags(&$array, array $unset, $case = CASE_UPPER)
    {
        $unset = array_change_key_case($unset, $case);
        foreach ($unset as $u){
            if ($case == CASE_UPPER) {
                unset($array[strtoupper($u)]);
            } elseif ($case == CASE_LOWER){
                unset($array[strtolower($u)]);
            }
        }
    }

    private static function removeTimeTags(&$array, $case = CASE_UPPER, $tz = false)
    {
        $prefix = $tz ? '_tz' : '';
        $unset = array(0 => $prefix.'evnstarttime', 1 => $prefix.'evnendtime', 2 => $prefix.'evnstartdate', 3 => $prefix.'evnenddate');
        self::removeTags($array, $unset, $case);
    }

	private static function removeEditTags(&$array, $case = CASE_UPPER, $removeEmpty = true)
	{
        $unset = ['evn_editcounter',
                  'evnt_created',
                  'evn_modified',
                  'evn_deleted',
                  'evnfolder',
                  'evn_id',
                  'evnrcr_id',
                  'evngrp_id',
                  'evnown_id',
                  'evnmodifiedown_id',
                  'evnlockown_id',
                  'expdate',
                  'expfollowing',
                  'evnrid',
                  'evnuid',
                  'gpinwhen',
                  'gpinwownname',
                  'gpinwownemail',
                  'pinwhen',
                ];
        if($removeEmpty){
            $array = array_filter($array, function($value) { return !is_null($value) && $value !== ''; });
        }
        self::removeTags($array, $unset, $case);
	}
		 
		public function composeXML($sAddonsXML)
		{
			$additionalFields = '';
			switch ($this->item['EVNCLASS'] ?? null) {
				case 'S':
				case 'Q':
				case 'R':
				case 'D':
				case 'B':
				case 'W':
				case 'Y':
				case 'Z':
					$additionalFields = ',evn_documenteditinginfo,evncomevnid,evncomlinkextras,GPinOwnName,GPinOwnEmail,Pin_MetaData,PinOwnEmail,PinOwnID,PinOwnName,PinWhen,GPinWhen,LPinWhen,PinOwnEmail,PinOwnName,PinEvn_ID,PinOwn_ID,MENWHOOWN_ID,MenLinkType,MenLink_ID,MenLinkEmail,MenLinkName,MenWhoOwnEmail,MenWhoOwnName,MenWhen,evnnote_text,evnmentions_info,reavalue,evntitle,evnlocation,evnnote,evnownername,evnowneremail,evnmodifiedowneremail,evnmodifiedownername,evnlinkextras,evnthumbnailticket,evnsizeinfo';
					break;
				case 'I':
					$additionalFields = ',evncomevnid,evncomlinkextras,GPinOwnName,GPinOwnEmail,Pin_MetaData,PinOwnEmail,PinOwnID,PinOwnName,PinWhen,GPinWhen,LPinWhen,PinOwnEmail,PinOwnName,PinEvn_ID,PinOwn_ID,MENWHOOWN_ID,MenLinkType,MenLink_ID,MenLinkEmail,MenLinkName,MenWhoOwnEmail,MenWhoOwnName,MenWhen,evnnote_text,evnmentions_info,reavalue,evn_metadata,evntitle,evnlocation,evnnote,evnownername,evnowneremail,evnmodifiedowneremail,evnmodifiedownername,evnlinkextras,evnprocessingqueued,evnthumbnailtime,evnthumbnailid,evnthumbnailticket,evnsizeinfo';
					break;
				case 'N':
                case 'M':
				case 'F':
					$additionalFields = ',evndoceditable,evndocdisabledownload,inviteticket,evndocinvite,evndocpass,evndocexpire,evndocrights,evn_documenteditinginfo,evncomevnid,evncomlinkextras,GPinOwnName,GPinOwnEmail,Pin_MetaData,PinOwnEmail,PinOwnID,PinOwnName,PinWhen,GPinWhen,LPinWhen,PinOwnEmail,PinOwnName,PinEvn_ID,PinOwn_ID,MENWHOOWN_ID,MenLinkType,MenLink_ID,MenLinkEmail,MenLinkName,MenWhoOwnEmail,MenWhoOwnName,MenWhen,evnnote_text,evnmentions_info,reavalue,evntitle,evnlocation,evnnote,evnownername,evnowneremail,evnmodifiedowneremail,evnmodifiedownername,evnprocessingqueued,evnthumbnailtime,evnthumbnailid,evnticket,evnsizeinfo,evnlockown_email,evnthumbnailticket,evnsizeinfo,evnlockown_id';
					break;
                case 'E':
					$additionalFields = ',osd,evncomevnid,evncomlinkextras,GPinOwnName,GPinOwnEmail,Pin_MetaData,PinOwnEmail,PinOwnID,PinOwnName,PinWhen,GPinWhen,LPinWhen,PinOwnEmail,PinOwnName,PinEvn_ID,PinOwn_ID,MENWHOOWN_ID,MenLinkType,MenLink_ID,MenLinkEmail,MenLinkName,MenWhoOwnEmail,MenWhoOwnName,MenWhen,evnnote_text,evnmentions_info,reavalue,evntitle,evnlocation,evnnote,evnownername,evnowneremail,evnmodifiedowneremail,evnmodifiedownername,evnmystatus,evnaccepted,evnacceptedparticipantcount,evnthumbnailticket,evnsizeinfo';
					break;
				case 'T':
					if (isset($this->item['EVNDESCFORMAT']) && isset($this->item['EVNNOTE']) && 'text/html' === $this->item['EVNDESCFORMAT']) {
						$enableExternalResources = false;
						if (isset($_SESSION['clientSettings']) && isset($_SESSION['clientSettings']['show_inline_images']) && true === $_SESSION['clientSettings']['show_inline_images']) {
							$enableExternalResources = true;
						}
						$this->item['EVNNOTE'] = slToolsString::purifyHTML($this->item['EVNNOTE'], $enableExternalResources);
					}
					break;
				default:
					 					break;
			}
			$sReturn = '<values>'.Tools::makeXMLTags($this->item,$this->fields.$additionalFields).'</values>'.$sAddonsXML;

        return $sReturn;
    }

		 
		public function openAccess($reload = true)
		{
            if(!$this->sFID || $reload){
			    $this->sFID = $this->folder->openAccess();
            }
			return $this->sFID;
    	}

		public function closeAccess() {}
 
    public function getItemData(&$info = array())
    {
        $data = $this->getVersitObject($vinfo);

        $title = $this->item['ITMCLASSIFYAS'] ? $this->item['ITMCLASSIFYAS'] : $this->item['EVNTITLE'];
        if (!$title) $title = 'item';

        $info['size'] = strlen($data);
        $info['name'] = $title . $vinfo['fileext'];
        $info['mimetype'] = $vinfo['mimetype'];
        $info['encoding'] = 'base64';

        return $data;
    }

    public function getItemFile(&$info = array())
    {
        $data = $this->getVersitObject($vinfo);

        $file = \Tools::randomFilename();
        file_put_contents($file, $data);

        $title = $this->item['ITMCLASSIFYAS'] ? $this->item['ITMCLASSIFYAS'] : $this->item['EVNTITLE'];
        if (!$title) $title = 'item';

        $info['size'] = strlen($data);
        $info['name'] = $title . $vinfo['fileext'];
        $info['mimetype'] = $vinfo['mimetype'];
        $info['encoding'] = 'base64';

        return $file;
    }

     
     
    public function sendData($disposition)
    {
        if($this->item['EVNCLASS']=='F'){
            return $this->sendAttachment($this->item['EVNLOCATION'], false, false, false, false, false, false, false, false, $disposition);
        }
        $data = $this->getVersitObject($info);
        $size = strlen($data);
        if ($this->item['ITMCLASS'] == 'C' || $this->item['ITMCLASS'] == 'L') {
            $name = $this->item['ITMCLASSIFYAS'] . '-' . $this->item['ITM_ID'];
        } else {
            $name = $this->item['EVNTITLE'] . '-' . $this->item['EVN_ID'];
        }
        $fileName = $name . $info['fileext'];
        $mimeType = $info['mimetype'];
        $_SESSION['user']->closeSession();
        slToolsFilesystem::sendFileHeaders($fileName, $size, $mimeType);
        echo $data;
    }

    public function sendCID($cid, $start_part_id, $ids)
    {
        $attachment = $this->getAddon('attachment');
        $p = $start_part_id;
        $partID = null;
		$oItem = $this->getEML($attachment,$partID,$p);
		return $oItem->sendCID($cid,$start_part_id,$ids);
	}
  
	public function getVersitObject(&$info = array())
	{
		 
		$folder = $this->folder;
		$account = $folder->account;
		$folder->openAccess();
		$info = array();
		$params = ';EMBEDATT';

		if($this->itemType == 'C'){
            $function = 'GetvCard';
            $info['fileext'] = VCARD_EXT;
            $info['mimetype'] = 'text/x-vcard';
        }else{
            $function = 'GetvCalendar';
            $info['fileext'] = VCALENDAR_EXT;
            $info['mimetype'] = 'text/x-vcalendar';
        }

		 
		return $account->gwAPI->FunctionCall($function, $this->sFID, $this->itemID, $params);
	   	}

	public function getDataFile(&$info)
	{
		$versit = $this->getVersitObject($info);
		$filename = Tools::randomFilename();
		slSystem::import('tools/icewarp');
		slToolsIcewarp::iw_file_put_contents($filename,$versit);
		if($this->item['ITMCLASS']=='C'){
			$name = $this->item['ITMCLASSIFYAS'].'-'.$this->item['ITM_ID'];
		}else{
			$name = $this->item['EVNTITLE'].'-'.$this->item['EVN_ID'];
		}
		$info['name'] = $name.$info['fileext'];
		$info['type'] = $info['mimetype'];
		$info['size'] = filesize($filename);
		$info['file'] = $filename;
		return $filename;
	}

	 

    public function getAllAttachments()
    {
        $attachment = $this->getAddon('attachment');
        $aAttachments = $this->getAddonData('attachment');

                 if ($aAttachments) foreach ($aAttachments as $key => $aAttachment) {
            $aResult[$key]['file_content'] = $attachment->getAttachment($aAttachment['ATTNAME']);
            $aResult[$key]['name'] = $aAttachment['ATTDESC'];
            $aResult[$key]['param'] = Tools::parseURL($aAttachment['ATTPARAMS']);
        }

        if (!$aResult) throw new Exc('attachment_get');

        return $aResult;
    }

	public function getAttachmentData($partID,&$info = array())
	{
		$attachment = $this->getAttachment($partID);
		$info['name'] = $attachment['name'];
		$info['mimetype'] = $attachment['param']['mimetype'];
		$info['encoding'] = 'base64';

		return base64_encode($attachment['file_content']);
	}

	 
	public function getAttachmentDataFile($partID,&$info = array(),$start_part_id = '')
	{
		$attachment = $this->getAddon('attachment');
		 		if(strpos($partID,'|')!==false){
			$partID = str_replace('|','/',$partID);
		}
		if($start_part_id){
			$partID = $start_part_id.'/'.$partID;
		}
        $attInfo = [];
        if (strpos($partID, '/') !== false) {
            $parts = explode('/', $partID);
            $attachmentID = $parts[0];
            $emlAttachmentID = $parts[1];
            $startPartID = $parts[0] . '|' . $parts[1];
            $oItem = $this->getEML($attachment, $partID, $startPartID);
            $result = $oItem->getAttachmentDataFile(substr($partID, strpos($partID, '/') + 1), $attInfo);
            $info['name'] = $attInfo['name'];
            $info['mimetype'] = $attInfo['mimetype'];
            return $result;
        } else {
            $attInfo = $this->getAttachment($partID, false, false);

            $info['name'] = $attInfo['name'];
            $info['mimetype'] = $attInfo['param']['mimetype'];

            return $attachment->getAttachmentFile($partID);
        }
    }

    public function getAttachmentDataFileCID($cid, &$info = array())
    {
        $attachment = $this->getAddon('attachment');
        $startPartID = null;
		$oItem = $this->getEML($attachment, $cid, $startPartID);
		$result = $oItem->getAttachmentDataFileCID($cid, $info);
		return $result;
	}

	public function getAllAttachmentFiles($start_part_id = false)
	{
		$attachment = $this->getAddon('attachment');
		if($start_part_id){
			$partID = $start_part_id;
			$oItem = $this->getEML($attachment,$partID,$start_part_id);
            $attachmentID = '1';
			if(strpos($partID,'|')!==false){
				$parts = explode('|',$partID);
				$attachmentID = $parts[1];
			}
			return $oItem->getAllAttachmentFiles($attachmentID);
		}else{
			$aAttachments = $this->getAddonData('attachment');
			 			if ($aAttachments) foreach ($aAttachments as $key => $aAttachment) {
                $aResult[$key]['file'] = $attachment->getAttachmentFile($aAttachment['ATTNAME']);
                $aResult[$key]['name'] = $aAttachment['ATTNAME'];
                if(strpos($aAttachment['ATTNAME'],'.')===false){
                    $aResult[$key]['name'] = $aAttachment['ATTDESC'];
                }
			}
		}

		if (!$aResult){
			throw new Exc('attachment_get','list');
		}
		return $aResult;
	}

	 
	public function getAttachment($partID,$startPartID = false,$content = true)
	{
		$attachment = $this->getAddon('attachment');
		 		if($startPartID){
			$oItem = $this->getEML($attachment,$partID,$startPartID);
			return $oItem->getAttachment($startPartID);
		}else{
			$aAttachments = $attachment->getData($partID);
			if(!$aAttachments){
                $aAttachments = $attachment->getData(urlencode($partID));
            }
             			if($aAttachments) foreach ($aAttachments as $key => $aAttachment) {
                if($content){
                    $aResult['file_content'] = $attachment->getAttachment($aAttachment['ATTNAME']);
                }
                $aResult['name'] = $aAttachment['ATTDESC'];
                $aResult['param'] = Tools::parseURL($aAttachment['ATTPARAMS']);
            }
		}
		if (!$aResult) throw new Exc('attachment_get',$partID);

		return $aResult;
	}

	public function getEML($attachment,&$partID,&$startPartID)
	{
		if(!$attachment){
			$attachment = $this->getAddon('attachment');
		}
		if(strpos($startPartID,'|') !== false){
			$parts = explode('|',$startPartID);
			$attachmentID = $parts[0];
			$startPartID = $parts[1];
		}else{
			$attachmentID = $startPartID;
			$startPartID = false;
		}
		if($attachmentID=='@@MAIN@@'){
			$attachmentID = $this->getFileAttachmentID();
		}
		@$att = reset($attachment->getData($attachmentID));

		$params = $att['ATTPARAMS'];
		$params = Tools::parseURL($params);
		if($params['mimetype'] == 'message/rfc822' || $params['mimetype'] = 'mimetype=message%2Frfc822'){  			$file = $attachment->getAttachmentFile($att['ATTNAME']);

			if($startPartID){
				$parser = new MailParse($file,array(),false,'',$startPartID);
			}else{
				$parser = new MailParse($file);
			}
			$oItem = new GroupWareItemMail($this,$partID,$parser,$attachmentID,$startPartID);

			return $oItem;
		}
	}

	public function sendAttachment(
        $partID,
        $startPartID = false,
        $ids = array(),
        $sForceName = false,
        $resize = false,
        $atttype = '',
        $skin = false,
                 $passphrase = '',
        $return = false,
        $disposition = null
    ) {
        $fName = null;
		$attachment = $this->getAddon('attachment');

		 		if($startPartID){
			$oItem = $this->getEML($attachment,$partID,$startPartID);
			return $oItem->sendAttachment($partID,$startPartID,$ids,$sForceName,$resize,$atttype,false,$passphrase, false, $disposition);
		 		}else{
            $attachments = $attachment->getData();
            foreach($attachments as $key => $a){
                if($a['ATTNAME']==$partID
                || urldecode($a['ATTNAME'])==$partID
                || $a['ATTNAME']==urldecode($partID)
                || urldecode($a['ATTNAME'])==urldecode($partID)){                      $att = $attachments[$key];
                }
            }
			if (!$att){
				if($skin != false){

					if(!slToolsFilesystem::securepath($skin)){
						throw new Exc('skin_secure_path');
					}
					$name = 'face-placeholder.gif';
					$file = '../client/skins/'.$skin.'/images/'.$name;
					if(!file_exists($file)){
						$file = '../client/skins/default/images/'.$name;
					}
					$size = icewarp_file_get_size($fName,true);
					slToolsFilesystem::sendFileHeaders($name, $size, 'image/gif', false, 'inline');
					slToolsFilesystem::downloadFile($file,false);
				}
				throw new Exc('attachment_get',$partID);
			}
			if(!$att['ATTPARAMS']){
				$att['ATTPARAMS'] = Tools::createURL(array('mimetype' => 'application/octet-stream'));
			}

			$fName = $attachment->getAttachmentFile($att['ATTNAME'],'',$atttype);
			if($_SESSION['user']){
				$_SESSION['user']->closeSession();
			}

            if ($resize) {
                                 $uPath = User::getUploadDir('resize/');
                $uName = $uPath . slSystem::uniqueID() . urlencode($att['ATTNAME']);
                copy($fName, $uName);
                slSystem::import('tools/image');
                $image = new slToolsImage();
                $image->load($uName);
                $image->edit($resize['width'], $resize['height'], $resize['crop']);
                $fName = $uPath . $image->save();
            }
            $atttype = $atttype ? $atttype : $att['ATTTYPE'];
                         if ($att['ATTTYPE'] == 'U') {
                $url = trim(icewarp_file_get_contents($fName, true));
                header("Location: " . $url);
                die();
            } else {
                switch ($atttype) {
                    case 'T':
                        $mimeType = 'image/jpeg';
                        $fileName = 'THUMB.jpg';
                        $mode = 'inline';
                        break;
                    case 'D':
                        $mimeType = 'application/pdf';
                        $fileName = 'PDF.pdf';
                        $mode = 'inline';
                        break;
                    case 'H':
                                                 $mimeType = 'text/html';
                        $fileName = '';
                        $mode = 'inline';
                        break;
                    case 'E':
                                                 $mimeType = 'text/plain';
                        $fileName = '';
                        $mode = 'inline';
                        break;
                    default:
                        $params = Tools::parseURL($att['ATTPARAMS']);
                        $mimeType = $params['mimetype'];
                        $fileName = $att['ATTDESC'];
                        $mode = 'attachment';
                        break;
                }
                $size = icewarp_file_get_size($fName, true);
                $disposition = $disposition ?? $mode ?? 'attachment';
                slToolsFilesystem::sendFileHeaders($fileName, $size, $mimeType, false, $disposition);
                slToolsFilesystem::downloadFile($fName, false);
            }
        }
    }

    public function sendDocument(
        $type = 'attachment',
        $resize = array(),
                 $passphrase = ''
    ) {
                                   switch ($type) {
            case 'attachment':
                $this->sendAttachment($this->item['EVNTITLE'], false, array(), false, $resize, '', false, $passphrase);
                break;
            case 'pdf':
                $this->sendAttachment($this->item['EVNTITLE'], false, array(), false, $resize, 'D', false, $passphrase);
                break;
            case 'thumbnail':
                $this->sendAttachment($this->item['EVNTITLE'], false, array(), false, $resize, 'T', false, $passphrase);
                break;
        }
    }

    public function getSubjectFileName()
    {
        return '';
    }

    public function importAttachment($att_id, $delete_after_import = false)
    {
        $path = explode("|", $att_id);
        $att_id = $path[0];
        $part_id = $path[1];
        $attachment = $this->getAddon('attachment');
        $oItem = $this->getEML($attachment, $att_id, $att_id);
        $info = array();
        $vcard = $oItem->getAttachmentData($part_id, $info);

        $gwAPI = &$this->folder->account->gwAPI;
        if (!$gwAPI->IsConnected()) {
            throw new Exc('groupware_init_failed');
        }
        $sXML = $gwAPI->FunctionCall("ConvertVersit", $gwAPI->sessid, $vcard, 'XML;FILTER=ATTACH');
        $oXML = simplexml_load_string($sXML);

        switch ($info['mimetype']) {
            case 'text/directory':
            case 'text/vcard':
            case 'text/x-vcard':
                $mimetype = 'vcard';
                $type = 'C';
                break;
            case 'text/x-vcalendar':
            case 'text/calendar':
            default:
                $mimetype = 'vcalendar';
                if ($oXML->VEVENT) {
                    $type = 'E';
                } elseif ($oXML->VTODO) {
                    $type = 'T';
                } elseif ($oXML->VNOTE) {
                    $type = 'N';
                } elseif ($oXML->VJOURNAL) {
                    $type = 'J';
                } else {
                    $name = $oXML->getName();
                    if ($name == 'VNOTE') {
                        $type = 'N';
                    } else {
                        throw new Exc('item_invalid_type');
                    }
                }
                break;
        }
        $fdrType = 'gw';

        $oAccount = $_SESSION['user']->getAccount($_SESSION['EMAIL']);
        $sFolderName = $_SESSION['user']->getDefaultFolder($type);
        if ($delete_after_import) {
            try {
                $oFolder = $oAccount->account->getFolder('__@@GWTRASH@@__', $fdrType);
                $sFolderName = '__@@GWTRASH@@__';
            } catch (Exc $e) {
                             }
        }
        try {
            if (!is_object($oFolder)) {
                $oFolder = $oAccount->getFolder($sFolderName, $fdrType);
            }
        } catch (Exc $e) {
            throw new Exc('default_folder_missing', $type);
        }
        $oItem = $oFolder->importItem($mimetype, $vcard);
        $result['folder'] = $oFolder;
        $result['item'] = $oItem;
        if ($delete_after_import) {
            $oItem->delete(false, false, '', true, true, true);
        }
        return $result;
    }

     

    public function createInvitation($sMethod = 'REQUEST', $datestamp = false, $occurranceID = false)
    {
                 $iMIP = iMIP::load($this->folder->account);
        $iMIP->setItem($this);
        $oInvitation = $iMIP->createInvitation($this->folder->folderID, $this->itemID, $sMethod, $datestamp, $occurranceID);
        return $oInvitation;
    }

    public function createInvitationAttachment($oInvitation, $sMethod = 'REQUEST')
    {
                 $oGWAccount = &$this->folder->account;
                 $iMIP = iMIP::load($oGWAccount);
        $iMIP->setItem($this);
                 $aAttachment = $iMIP->createAttachment($oInvitation->sInvitation, '', $sMethod);

        $sXML = $iMIP->convertVersit($oInvitation->sInvitation);
        $aAttachment['xml'] = $sXML;
        return $aAttachment;
    }

              public function cancel($aAttendees = array(), $datestamp = '')    {
                 $iMIP = iMIP::load($this->folder->account);
        $iMIP->setItem($this);
        $oInvitation = $iMIP->loadInvitationID($this->folder->folderID, $this->itemID);

                          if (!$aAttendees) {
            $oAttendees = $this->getAddon('contact');
            $aAttendees = $this->getAddonData('contact');
            $this->aAttendees = $aAttendees;
        }
        $aAttendeID = [];
        if ($aAttendees) foreach ($aAttendees as $aAttendee)
            $aAttendeeID[] = $aAttendee['CNTEMAIL'];


        $sData = $oInvitation->cancel($aAttendeeID, $datestamp);


        $sXML = $iMIP->convertVersit($sData);

                 $aAttachment = $iMIP->createAttachment($sData, '', 'CANCEL');
        $aAttachment['imip_xmlstr'] = $sXML;

        return $aAttachment;
    }

              public function decline($reason = '', $datestamp = '')
    {
        if(self::isOrganizator($this->item['EVNFLAGS'])){
            return false;
        }
                 $iMIP = iMIP::load($this->folder->account);
        $iMIP->setItem($this);
        $oInvitation = $iMIP->loadInvitationID($this->folder->folderID, $this->itemID);

                          $sData = $oInvitation->decline($this->folder->account->gwAPI->getFolderOwner($this->folder), $reason, $datestamp);
        $sXML = $iMIP->convertVersit($sData);

                 $aAttachment = $iMIP->createAttachment($sData, 'REPLY');
        $aAttachment['imip_xmlstr'] = $sXML;

        return $aAttachment;
    }

    public function getCertificate(
        $part_id = 'current',
                 $passphrase = ''
    ) {
        $addon = $this->getAddon('certificate');
        $list = $this->getAddonData('certificate');
        if ($part_id == 'current') {
            return Storage::getCurrentCertificate($list);
        } else {
            return $list[$part_id];
        }
    }

    public function processTZID($aItem, $edit = false, $isRecurrent = false)
    {
        if (isset($aItem['EVNTIMEFORMAT'])) {
            switch (strtoupper($aItem['EVNTIMEFORMAT'])) {
                case 'Z':
                    if ($aItem['_TZID']) {
                        if ($edit) {
                            $attributes = $this->folder->account->gwAPI->FunctionCall(
                                "GetItemAttributes",
                                $this->folder->sFID,
                                $this->item['EVN_ID']
                            );
                            $attributes = $this->folder->account->gwAPI->ParseParamLine($attributes);
                            if (is_array($attributes) && !empty($attributes)) {
                                foreach ($attributes as $attr) {
                                    if (strtolower($attr['ATRTYPE']) == 'tz') {
                                        $this->folder->account->gwAPI->FunctionCall(
                                            "DeleteItemAttribute",
                                            $this->folder->sFID,
                                            $this->item['EVN_ID'],
                                            $attr['ATR_ID'],
                                            'tz'
                                        );
                                    }
                                }
                            }
                        }

                        $vtimezone = $this->folder->account->gwAPI->FunctionCall(
                            "GetTZIDVTIMEZONE",
                            $aItem['_TZID']
                        );
                        $this->folder->account->gwAPI->FunctionCall(
                            "AddItemAttribute",
                            $this->folder->sFID,
                            $this->item['EVN_ID'],
                            $vtimezone,
                            'AtrType=tz'
                        );
                    }
                    break;
                case 'L':
                case 'F':
                default:
                    if ($edit) {
                        $this->folder->account->gwAPI->FunctionCall(
                            "DeleteItemAttribute",
                            $this->folder->sFID,
                            $this->item['EVN_ID'],
                            '',
                            'tz'
                        );
                    }
                    break;
            }
        }
    }

    public function processTags($aItem)
    {
        $sFID = $this->openAccess(false);
        $gwAPI = &$this->folder->account->gwAPI;
        if (isset($aItem['EVNTYPE']) || isset($aItem['ITMCATEGORY'])) {
            if (!$gwAPI->FunctionCall(
                "SetItemTags",
                $sFID,
                $this->itemID,
                isset($aItem['EVNTYPE']) ? $aItem['EVNTYPE'] : $aItem['ITMCATEGORY'],
                ";NOEDITCOUNTER"
            )) {
                throw new Exc('item_tags');
            }
        }
    }

    public function processStatus(&$aItem, $aTreeItem, $setStatus = false, $rcrID = false)
    {
        $sClass = $aItem['EVNCLASS'] ? $aItem['EVNCLASS'] : $this->item['EVNCLASS'];
        $sRcrID = $rcrID ? $rcrID : $this->item['EVNRCR_ID'];
                 if ($sClass == 'T' && $aItem['EVNCOMPLETE'] == 100 && $aItem['EVNSTATUS'] != 'M') {
            $aItem['EVNSTATUS'] = 'M';
        }

                 if (isset($aItem['EVNSTATUS']) && $aItem['EVNSTATUS'] == 'M' && $setStatus) {
                         if ($sClass == 'T') {
                                 if ($sRcrID) {
                    $param = $this->item;
                    $param['EVNSTATUS'] = 'M';
                    $param['EVNCOMPLETE'] = 100;
                    $param['EVNCOMPLETED'] = time();
                    $next = $this->getNextDisplayOcurrance($this->item['EVN_ID'], $this->item['EVNSTARTDATE']);
                    if ($next) {
                        if ($this->item['EVNENDDATE']) {
                            $aItem['EVNENDDATE'] = $next['EVNENDDATE'];
                            $difference = $next['EVNENDDATE'] - $this->item['EVNENDDATE'];
                        }
                        if ($this->item['EVNSTARTDATE']) {
                            $aItem['EVNSTARTDATE'] = $next['EVNSTARTDATE'];
                            $difference = $next['EVNSTARTDATE'] - $this->item['EVNSTARTDATE'];
                        }
                    }

                    self::removeEditTags($param, CASE_UPPER);
                    $datestamp = $this->item['EVNENDDATE'] ? $this->item['EVNENDDATE'] : $this->item['EVNSTARTDATE'];

                    if ($next) {
                        $result = $this->createFromCurrent(
                            $param,
                            $aTreeItem,
                            $datestamp,
                            $editInfo,
                            true,
                            true
                        );
                        $currentRecurrence = $this->getAddon('recurrence');
                        $currentRecurrenceData = $this->getAddonData('recurrence');
                        $currentRecurrenceData = $currentRecurrenceData[0];
                        if ($currentRecurrenceData['RCRCOUNT'] > 1) {
                            $currentRecurrenceData['RCRCOUNT']--;
                            $currentRecurrence->edit($currentRecurrenceData, $currentRecurrenceData['RCR_ID']);
                        }

                        $currentReminder = $this->getAddon('reminder');
                        $currentReminderData = $this->getAddonData('reminder');
                        if ($currentReminderData) foreach ($currentReminderData as $reminderData) {
                            $timestamp = $reminderData['RMNTIME'];
                            $addonID = $reminderData['RMN_ID'];
                            $editData = array();
                            $editData['RMNTIME'] = $timestamp + $difference * 86400;
                            $editData['RMNLASTACK'] = 0;
                            $currentReminder->edit($editData, $addonID);
                        }

                        $aItem['EVNSTATUS']='B';
                        $aItem['EVNCOMPLETE'] = '0';
                        $aItem['EVNCOMPLETED'] = '';
                    } else {
                        $aItem['EVNSTATUS'] = 'M';
                        $aItem['EVNCOMPLETE'] = 100;
                        $aItem['EVNCOMPLETED'] = time();
                    }
                                     } else {
                    $aItem['EVNSTATUS'] = 'M';
                    $aItem['EVNCOMPLETE'] = 100;
                    $aItem['EVNCOMPLETED'] = time();

                }
                $sFID = $this->openAccess(false);
                $sParameters = $this->folder->account->gwAPI->CreateParamLine($aItem);
                if ($sParameters) {
                    $sParameters = 'use_tzid=1&' . $sParameters;
                }
                                 if (!$sEvnId = $this->folder->account->gwAPI->FunctionCall(
                    "AddEventInfo",
                    $sFID,
                    $sParameters,
                    $this->item['EVN_ID']
                )) {
                    throw new Exc('item_status', $sParameters);
                }
            }
        }
        if (!$sRcrID) {
            $result = $sEvnId;
        }
        return $result;
    }

    private function processAddons(&$aItem, &$aTreeItem, &$meetingInfo, $create = false)
    {
        $result = false;
        $this->getAddons();
        foreach ($this->aAddons as $addon) {
                         if ($addon->sAddonType == 'note') {
                $this->hasNoteAddon = true;
                continue;
            }
            $addonResult = $addon->process($aTreeItem);
            if ($addon->sAddonType == 'recurrence' && isset($aTreeItem['@childnodes']['recurrences'])) {
                $data = $this->getAddonData('recurrence');
                $data = $data[0];
                $this->rcrID = $data['RCR_ID'];
            }
            if ($addon->sAddonType == 'reaction') {
                parse_str($addonResult, $data);
                $this->reactions_metadata = $data['reactions'];
            }
            if ($create && $addon->sAddonType == 'attachment' && isset($addonResult['id'])) {
                if ($this->folder->getType() == 'I' || $this->folder->getType() == 'F') {
                    $this->att_webdav_link = User::addTokenToTicket($addon->GetAttachmentFile($addonResult['id'], 'READONLYTICKET'));
                    if ($originalFilename) {
                        $this->att_webdav_link .= '&filename=' . urlencode($originalFilename);
                    }
                    $this->att_size = $addonResult['size'];
                    $contentType = $addonResult['type'];
                } else {
                    $data = $this->getAddonData('attachment');
                    $data = reset($data);
                    $this->att_webdav_link = User::addTokenToTicket($addon->GetAttachmentFile($data['ATTNAME'], 'TICKET'));
                    $this->att_size = $this->item['EVNCOMPLETE'];
                }
                if($meetingInfo['note_has_attachments']) {
                    $noteReplace = 'attachment_id_' . md5($addonResult['id']);
                    if (strpos($meetingInfo['note_value'], $noteReplace) !== false) {
                        $attachmentPath = User::addTokenToTicket($folder->account->gwAPI->FunctionCall("getAttachmentPath", $sFID, $this->itemID, $addonResult['id'], 'READONLYTICKET'));
                        $meetingInfo['note_value'] = str_replace('attachment_id_' . md5($addonResult['id']), $attachmentPath, $meetingInfo['note_value']);
                    }
                }
            }

                         if($create && $this->folder->getType() == 'I' && ($aItem['EVNCLASS'] == 'M' || $contentType == 'message/rfc822') && $addon->sAddonType == 'attachment' && (!isset($aItem['EVNCLASS']) || $aItem['EVNCLASS'] == 'F')){
                                 $mailID = $this->getFileAttachmentID();
                $file = $addon->getAttachmentFile($mailID);
                if($contentType == 'message/rfc822'){
                    $aItem['EVNCLASS'] = 'M';
                }
                $result = GroupWareItem::createFromMessage($this->folder, $file, ($aItem['EVNCLASS'] == 'M' ? ($aItem['EVNNOTE'] ? $aItem['EVNNOTE'] : $aItem['EVNTITLE']) : ''), $this, $aItem);
                if($contentType == 'message/rfc822'){
                    $result->getAddons('M');
                }
            }
        }
        return $result;
    }

         private function processItemExtras(&$aItem, &$aTreeItem, &$meetingInfo, $create = false)
    {
        $result = &$this;
                 $result->processTZID($aItem, !$create, isset($aTreeItem['@childnodes']['recurrences']));
                 $item =  $result->processAddons($aItem, $aTreeItem, $meetingInfo, $create);
        if($item!==false){
            $result = $item;
        }
                 $result->processTags($aItem);
		 		$status = $result->item['EVNSTATUS'];
		$result->occurrenceID = $result->processStatus($aItem, $aTreeItem, true, $result->rcrID);
	    if($status=='M' && ($status <> $aItem['EVNSTATUS'])){
            $this->folder->account->gwAPI->FunctionCall($this->addMethod, $result->sFID, 'evnstatus=B', $result->itemID);
	    }
                 $result->noteAndMeetingAction($aItem, $meetingInfo);

        return $result;
    }


     
    public function recover(array $aMapping = [])
    {
        $sOriginalFolder = $this->item['EVNORIGINALFOLDER'] ? $this->item['EVNORIGINALFOLDER'] : $this->item['ITMORIGINALFOLDER'];

        if (array_key_exists($sOriginalFolder, $aMapping)) {
            $sOriginalFolder = $aMapping[$sOriginalFolder];
        }

        $destination = $this->folder->account->getFolder($sOriginalFolder);
        $this->move($destination);
    }

    public function getPublicUrl($att_id = false, $rights = Folder::RIGHT_READ, $expire = false, $sAttType = 'TICKET')
    {
        $rights = GroupWareFolder::encodeRights($rights);
        $expire = $expire ? $expire : (time() + DAY_LENGTH);

        $attachments = $this->aAddons['attachment']->getData();

        if ($att_id === false) {
            $attachment = reset($attachments);
        } else {
            if ($attachments) foreach ($attachments as $att) {
                if ($att['ATTNAME'] == $att_id) {
                    $attachment = $att;
                }
            }
        }
        if ($attachment) {
            $ticket = User::addTokenToTicket($this->aAddons['attachment']->getAttachmentFile($attachment['ATTNAME'], $sAttType . '&short=1&rights=' . $rights));
            return $ticket;
        }
    }

    public function lock()
    {
        $gwAPI = &$this->folder->account->gwAPI;
        $sFID = $this->openAccess();
        if (($result = $gwAPI->FunctionCall(
                "LockItem",
                $sFID,
                $this->item['EVN_ID'],
                1              )) <= 0) {
            throw new Exc('item_lock', $result);
        }
    }

    public function unlock()
    {
        $gwAPI = &$this->folder->account->gwAPI;
        $sFID = $this->openAccess();
        if (($result = $gwAPI->FunctionCall(
                "UnlockItem",
                $sFID,
                $this->item['EVN_ID'],
                1,                  1               )) <= 0) {
            throw new Exc('item_unlock', $result);
        }
    }

    public function notify($copy_to, $all, $comment = false)
    {
        $gwAPI = &$this->folder->account->gwAPI;
        $sFID = $this->openAccess();
        if ($copy_to != '') {
            $parameters['list'] = $copy_to;
        }
        if ($all !== '') {
            $parameters['all'] = $all;
        }
        if ($comment) {
            $parameters['comment'] = $comment;
        }

		$paramline = $gwAPI->CreateParamLine($parameters);
		if(($result = $gwAPI->FunctionCall(
				"NotifyAboutItemChanges",
				$sFID,
				$this->item['EVN_ID'],
				$paramline
		)) <= 0){
			throw new Exc('item_notify',$result);
		}
	}

	public function revertToRevision($revisionID)
	{
		$gwAPI = &$this->folder->account->gwAPI;
		$sFID = $this->openAccess();
		if(($result = $gwAPI->FunctionCall(
				"RevertToItemRevision",
				$sFID,
				$this->item['EVN_ID'],
				$revisionID
		)) <= 0){
			throw new Exc('item_revert_to_revision',$result);
		}
	}

	public function notifyGroupChat($email)
	{
		$gwAPI = &$this->folder->account->gwAPI;
		$sFID = $this->openAccess();
		if(($result = $gwAPI->FunctionCall(
				"NotifyAboutItemSharing",
				$sFID,
				$this->item['EVN_ID'],
				'email='.urlencode($email)
		)) <= 0){
			throw new Exc('item_notify_groupchat',$result);
		}
	}

	public function getRevisionFile($attachmentID,$revisionID)
	{
		if($this->folder->getType() != 'F' && $this->folder->getType()!='I'){
			throw new Exc('item_invalid_type');
		}
		$gwAPI = &$this->folder->account->gwAPI;
		$sFID = $this->openAccess();
		if(!$path = $gwAPI->FunctionCall(
				"GetAttachmentPathLocal",
				$sFID,
				$this->item['EVN_ID'],
				$attachmentID,
				'REVID='.$revisionID
		)){
			throw new Exc('item_get_attachment_path',$path);
		}
		return $path;
	}

	public function getRevisionProperties($attachmentID,$revisionID)
	{
		if($this->folder->getType() != 'F' && $this->folder->getType()!='I'){
			throw new Exc('item_invalid_type');
		}
		$gwAPI = &$this->folder->account->gwAPI;
		$sFID = $this->openAccess();
		if(!$param = $gwAPI->FunctionCall(
				"GetAttachmentList",
				$sFID,
				$this->item['EVN_ID'],
				$attachmentID,
				$revisionID
		)){
			throw new Exc('item_get_attachment_path',$param);
		}
		$param = MerakGWAPI::parseParamLine($param);
		return $param;
	}

	public function downloadRevision($attachmentID,$revisionID)
	{
		 		$sFID = $this->openAccess();
		$gwAPI = &$this->folder->account->gwAPI;
		$attachment = $this->getAddon('attachment');
		$data = $this->getAddonData('attachment');
		if(!$data){
			throw new Exc('attachment_get');
		}
		 		$filename = $this->getRevisionFile($attachmentID, $revisionID);
		$info = $this->getRevisionProperties($attachmentID, $revisionID);
		 		$info = reset($info);
		$params = $info['ATTPARAMS'];
		$params = Tools::parseURL($params);
		$mimetype = $params['mimetype'];
		 		slToolsFilesystem::sendFileHeaders($info['ATTDESC']?$info['ATTDESC']:$info['ATTNAME'], $info['ATTSIZE'], $mimetype);
		slToolsFilesystem::downloadFile($filename);
	}

     
	static public function dataContainsAttachment(? string &$data) : bool
    {
        return (bool)preg_match('/(\<img[^>]+src=").*?((sid=' . preg_quote($_SESSION['SID']) . ')|(dlsess=' . $_SESSION['DLSESS'] . '))&amp;class=([^&]+)&amp;fullpath=((?:[^\'"&\/]+\/)+([^"&]+)[^"]*)([^>]+>)/i', $data);
    }

	static public function replaceCID(&$data, & $aTreeItem)
    {
        $pattern = '/(?P<prefix>\<img[^>]+src=").*?(?:(?:sid=' . preg_quote($_SESSION['SID']) . ')|(?:dlsess=' . $_SESSION['DLSESS'] . '))&amp;class=(?P<class>[^&]+)&amp;fullpath=(?P<fullpath>(?:[^\'"&\/]+\/)+(?P<name>[^"&]+)[^"]*)(?P<suffix>[^>]+>)/i';
        if(preg_match_all($pattern, $data, $matches, PREG_SET_ORDER)){
            foreach ($matches as $match) {
                $attachment = [];
                $attachment['fullpath'] = urldecode($match['fullpath']);
                $attachment['class'] = $match['class'];
                $attachment['description'] = urldecode($match['name']);
                $attachment['cid'] = 'attachment_id_'.md5($attachment['description']);

                $result['@childnodes'] = [];
                foreach ($attachment as $key => $item) {
                    $result['@childnodes'][$key][0]['@value'] = $item;
                }
                $aTreeItem['@childnodes']['attachments'][0]['@childnodes']['attachment'][0]['@childnodes']['values'][] = $result;

                $data = str_replace($match[0], $match['prefix'] . $attachment['cid'] . $match['suffix'], $data);
            }
        }
        return $data;
    }

	static public function getError(&$gwAPI)
	{
		$error = $gwAPI->FunctionCall("GetLastError",$gwAPI->sessid);
		if(strpos($error,':')!==false){
			$error = explode(':',$error);
			$error = $error[0];
		}
		return $error;
	}

	public function accept()
	{
        if(self::isOrganizator($this->item['EVNFLAGS'])){
            return false;
        }
		$oIMIP = iMIP::load($this->folder->account);
        $oIMIP->setItem($this);
		$oInvitation = $oIMIP->loadInvitationID($this->folder->name,$this->itemID);
        $sReply = $oInvitation->accept($this->folder->name,$this->folder->account->gwAPI->getFolderOwner($this->folder));

        $sReplyXML = $oIMIP->convertVersit($sReply);
        $aAttachment = $oIMIP->createAttachment($sReply,'', 'REPLY');
        $aAttachment['xml'] = $sReplyXML;
	}

    public function tentative()
    {
        if(self::isOrganizator($this->item['EVNFLAGS'])){
            return false;
        }
        $oIMIP = iMIP::load($this->folder->account);
        $oIMIP->setItem($this);
        $oInvitation = $oIMIP->loadInvitationID($this->folder->name,$this->itemID);
        $sReply = $oInvitation->tentative($this->folder->account->gwAPI->getFolderOwner($this->folder));
        $sReplyXML = $oIMIP->convertVersit($sReply);
        $aAttachment = $oIMIP->createAttachment($sReply,'', 'REPLY');
        $aAttachment['xml'] = $sReplyXML;
        return $aAttachment;
    }

	public function addPin($global = false)
	{
		$sFID = $this->openAccess();
		$response = $this->folder->account->gwAPI->FunctionCall("AddEventPin",$sFID,$this->itemID,'global='.($global?'1':'0'));
		parse_str($response,$result);
		switch($result['result']){
			case '1':
				 			break;
			     			case '2':
				throw new Exc('add_pin_already_exists');
			break;
			     			case '':
			case '0':
				throw new Exc('add_pin');
				break;
		}
		return $result['timestamp'];
	}

	public function deletePin($global = false)
	{
		$sFID = $this->openAccess();
		$result = $this->folder->account->gwAPI->FunctionCall("DeleteEventPin",$sFID,$this->itemID,'global='.($global?'1':'0'));
		if(!$result){
			throw new Exc('delete_pin');
		}
	}

	public static function setAccountName($name)
	{
		$aProperties = array();
		$aProperties['fullname'] = $name;
		return $_SESSION['user']->editAccount($_SESSION['EMAIL'],$aProperties);
	}

	public function getFileAttachmentID(&$attachment = [])
	{
		if($this->folder->getType() != 'F' && $this->folder->getType()!='I'){
			throw new Exc('item_invalid_type');
		}
		$gwAPI = &$this->folder->account->gwAPI;
		$sFID = $this->openAccess();
		if(!$param = $gwAPI->FunctionCall("GetAttachmentList", $sFID, $this->item['EVN_ID'], '', '')){
			throw new Exc('item_get_attachment_path',$param);
		}
		$param = MerakGWAPI::parseParamLine($param);
		if(is_array($param) && !empty($param)){
			foreach($param as $attachment){
				if($attachment['ATTTYPE']=='F'){
					return $attachment['ATTNAME'];
				}
			}
		}
		return null;
	}


         static public function createFromMessage(&$folder, $file, $comment = '', &$item = false, &$aItem = array(), $finalize = false)
    {
        $folder->openAccess();

        $parser = new slMailParse($file, array(), true);
        $structure = $parser->parse(false, false);

                 if (!isset($aItem['EVNCLASS']) || $aItem['EVNCLASS'] == 'F') {
            $aItem['EVNCLASS'] = 'M';
        }

		$aItem['EVNORGANIZER'] = $structure['headers']['from'];
		$aItem['EVNMEETINGID'] = $structure['headers']['to'];

		if($structure['headers']['cc']){
			$aItem['EVNMEETINGID'].=','.$structure['headers']['cc'];
		}
		if($structure['headers']['bcc']){
			$aItem['EVNMEETINGID'].=','.$structure['headers']['bcc'];
		}
		$aItem['EVNMEETINGID'] = substr($aItem['EVNMEETINGID'],0,255);
		$to_count = count(slMailParse::parseAddresses($structure['headers']['to']) ?? []);
		$cc_count = count(slMailParse::parseAddresses($structure['headers']['cc']) ?? []);
		$bcc_count = count(slMailParse::parseAddresses($structure['headers']['bcc']) ?? []);
		$aItem['EVNSEQUENCE'] = $to_count+$cc_count+$bcc_count;
		$unixtime = strtotime($structure['headers']['date']);
		$aItem['EVNSTARTTIME'] = IceWarpGWAPI::unix2calendarTime($unixtime);
		$aItem['EVNSTARTDATE'] = IceWarpGWAPI::unix2calendarDate($unixtime);
		$aItem['EVNNOTE'] = $comment;
		$aItem['EVNLOCATION'] = $structure['isHTML']?slToolsString::removeHTML($structure['html_body']):$structure['text_body'];
		$aItem['EVNLOCATION'] = iconv_substr(slToolsString::utf8_bad_replace($aItem['EVNLOCATION']),0,510, 'utf-8');
		if($structure['isHTML']){
			if(!$aItem['EVNFLAGS']){
				$aItem['EVNFLAGS'] = GroupWareItem::FLAG_HTMLCONTENT;
  			}else{
				  $aItem['EVNFLAGS'] |= GroupWareItem::FLAG_HTMLCONTENT;
			}
		}
		$aItem['EVNDESCFORMAT'] = 'text/plain';
		$aItem['EVNCOMPLETE'] = filesize($file);
		if(!isset($aItem['EVNSHARETYPE'])){
			$aItem['EVNSHARETYPE'] = 'U';
		}

		if(isset($structure['attachments']) && is_array($structure['attachments']) && !empty($structure['attachments'])){
			$attachments = '[';
			foreach($structure['attachments'] as $key => $attachment){
				$attachmentjson[]= '{' .
					'"name":"'.trim(json_encode($attachment['name']),'"').'",'.
					'"part_id":"'.trim(json_encode($attachment['part_id']),'"').'",'.
					'"size":"'.trim(json_encode($attachment['size']),'"').'",'.
					'"type":"'.trim(json_encode($attachment['type']),'"').'"'.
				'}';
			}
			$attachments.= join(",",$attachmentjson);
			$attachments.= ']';
			$metadata= '&attachments='.urlencode($attachments);
		}
		$name = slMailParse::getAttachmentName($structure,'1',array(),true,messageext);
		if(!$name){
			$name = trim(Storage::getNoTitleLabel()).messageext;
		}
		$fixed_name = CacheItem::getSubjectFileNameStatic($name,'',messageext);

		$aItem['EVNTITLE'] = iconv_substr(slToolsString::utf8_bad_replace($name), 0, 510, 'utf-8');
		$aItem['EVNRID'] = $aItem['EVNTITLE'];

        $sParameters = $folder->account->gwAPI->CreateParamLine($aItem);
        $sItemID = $folder->account->gwAPI->FunctionCall(
            "AddEventInfo",
            $folder->sFID,
            $sParameters . '&metadata=' . urlencode($metadata),
            $item ? $item->itemID : ''
        );
        $finalizeItem = $finalize;
        if (!$item) {
            $aItem['EVN_ID'] = $sItemID;
            $item = new GroupWareItem($folder, $aItem);
            $item->aAddons = array();
            $item->getAddons('M');
            $finalizeItem = true;
        }
        if ($structure['headers']['to']) {
            $aData = array();
            $aData['atrtype'] = 'to';
            $aData['atrvalue'] = $structure['headers']['to'];
            $item->aAddons['xattribute']->create($aData);
        }
        if ($structure['headers']['cc']) {
            $aData = array();
            $aData['atrtype'] = 'cc';
            $aData['atrvalue'] = $structure['headers']['cc'];
            $item->aAddons['xattribute']->create($aData);
        }
        if ($structure['headers']['bcc']) {
            $aData = array();
            $aData['atrtype'] = 'bcc';
            $aData['atrvalue'] = $structure['headers']['bcc'];
            $item->aAddons['xattribute']->create($aData);
        }
                 $parser = new slMailParse(
            $file,
            array(
                'sid' => $_SESSION['SID'],
                'account_id' => $_SESSION['EMAIL'],
                'folder_id' => $folder->folderID,
                'item_id' => $item->itemID,
                'placeholder' => true
            )
            ,
            true
        );
        $structure = $parser->parse(false, false);

        $url = '';
		 		if ($finalizeItem){
			$folderID = date('Y-m-d-') . Tools::my_uniqid();
			$itemID = Tools::my_uniqid();
			$aData['class'] = 'file';
			$aData['fullpath'] = $folderID.'/'.$itemID;
			$_SESSION['user']->addFileAttachment(
				$file,
				$fixed_name,
				'message/rfc822',
				$folderID,
				$itemID
			);
            $folderAccess = $item->openAccess();
			$addonMessage = $item->aAddons['attachment']->create($aData);
            $url = $attachmentPath = User::addTokenToTicket($folder->account->gwAPI->FunctionCall("getAttachmentPath", $folderAccess, $item->itemID, $addonMessage['id'], 'READONLYTICKET'));
		}

		if($structure['isHTML']){
			$html = $structure['html_body'];
			$plain = slToolsString::removeHTML($html);
		}else{
			$html = slToolsString::text2html($structure['plain_body']);
			$plain = $structure['plain_body'];
		}

		$previewHtml = urldecode($html);
        if(!empty($url) && preg_match_all('/(?P<search>src=""\s*icewarp-src="(?:[^"&]+&amp;)+(?:[^"&]+&amp;)*part=(?P<part>[^"&]+)[^"]*")/i', $previewHtml, $matches, PREG_SET_ORDER)){
            foreach ($matches as $match) {
                $previewHtml = str_replace($match['search'], 'src="' . $url . '&partid=' . $match['part'] . '"', $previewHtml);
            }
        }

		$folderID = $folderID?$folderID:Tools::my_uniqid();
		$itemID_html = Tools::my_uniqid();
		$_SESSION['user']->addStringAttachment(
            $previewHtml,
			'MAIL_PREVIEW.html',
			'text/html',
			$folderID,
			$itemID_html
		);
		$aData['class'] = 'file';
		$aData['fullpath'] = $folderID.'/'.$itemID_html;
		$aData['AttType'] = 'H';
		$item->aAddons['attachment']->create($aData);

		$itemID_text = Tools::my_uniqid();
		$_SESSION['user']->addStringAttachment(
            $previewHtml,
			'MAIL_PREVIEW.txt',
			'text/plain',
			$folderID,
			$itemID_text
		);
		$aData['class'] = 'file';
		$aData['fullpath'] = $folderID.'/'.$itemID_text;
		$aData['AttType'] = 'E';
		$item->aAddons['attachment']->create($aData);

		if($finalizeItem){
			 			$sItemID = $folder->account->gwAPI->FunctionCall(
				"AddEventInfo",
				$folder->sFID,
				'&return_link_id=1',
				$item->itemID
			);
			parse_str($sItemID,$result);
			if($result['linkid']){
				$item->linkID = $result['linkid'];
			}
		}
		return $item;
	}

	public function documentInvite(
        $expire,
        $editable,
                 $pass)
	{
		$sFID = $this->openAccess();

		if($editable){
			$rights = \MerakGWAPI::RIGHT_BITS | \MerakGWAPI::RIGHT_READ | \MerakGWAPI::RIGHT_FOLDER_READ | \MerakGWAPI::RIGHT_WRITE;
		}else{
			$rights = \MerakGWAPI::RIGHT_BITS | \MerakGWAPI::RIGHT_READ | \MerakGWAPI::RIGHT_FOLDER_READ;
		}

		$result = $this->folder->account->gwAPI->FunctionCall(
			"AddDocumentInvite",
			$sFID,
			$this->itemID,
			'rights='.urlencode($rights).
			'&expire='.urlencode($expire).
			'&password='.urlencode($pass)
		);
		if(!$result){
			throw new Exc('document_invite');
		}
	}

	public function documentUninvite()
	{
		$sFID = $this->openAccess();
		$result = $this->folder->account->gwAPI->FunctionCall(
			"DeleteDocumentInvite",
			$sFID,
			$this->itemID
		);
		if(!$result){
			throw new Exc('document_uninvite');
		}
	}

	public function documentLink($targetFolder,$note = '')
	{
		$sFID = $this->openAccess();
		$targetFolder = $this->folder->account->getFolder($targetFolder);
		$sTargetFID = $targetFolder->openAccess();

		$result = $this->folder->account->gwAPI->FunctionCall(
			"AddDocumentLink",
			$sFID,
			$sTargetFID,
			$this->itemID,
			'EvnNote='.urlencode($note)
		);
		if(!$result){
			throw new Exc('document_link');
		}
	}

    public function getInviteTicket()
    {
        $sFID = $this->openAccess();
        return $this->folder->account->gwAPI->FunctionCall(
			"GetAttachnebtPathLocal",
			$sFID,
			$this->itemID,
			'',
            'INVITETICKET'
        );
    }

    public function getMessage()
    {
                 return '';
    }

    public function subscribe()
    {
        return $this->follow();
    }

    public function unsubscribe()
    {
        return $this->unfollow();
    }

    public function follow()
    {
        if($this->folder->getType() != 'I') return;
        return $this->folder->account->gwAPI->FunctionCall('FollowTeamChatThread',$this->openAccess(), $this->itemID,"1");
    }

    public function unfollow()
    {
        if($this->folder->getType() != 'I') return;
        return $this->folder->account->gwAPI->FunctionCall('FollowTeamChatThread',$this->openAccess(), $this->itemID,"0");
    }

    public function getCreatedData() : array
    {
        $result = [];

        $result['id'] = $this->itemID;
        $result['created'] = $this->item['EVNCREATED'];
        $result['att_webdav_link'] = $this->att_webdav_link;
        $result['att_size'] = $this->item['EVNSIZEINFO'];

        return $result;
    }

     
    private function createFromCurrent(&$aItem, &$aTreeItem, $datestamp, &$editInfo, $occurrance = false, $noreminder = false, $finalize = true)
    {
        $oAccount = &$this->folder->account;
		$newItem = $this->item;
        if($aItem['_TZID']){
            $newItem['_TZID'] = $aItem['_TZID'];
			self::removeTimeTags($newItem, CASE_UPPER);
		}else{
			self::removeTimeTags($newItem, CASE_UPPER, true);
		}
        if ($aItem){
            foreach ($aItem as $itemProperty => $itemValue){
                $newItem[$itemProperty] = $itemValue;
            }
        }
        if($occurrance){
                         $newItem['EVNCLASS'] = ($this->folder->getType() == 'T') ? $newItem['EVNCLASS'] : 'O';           }else{
                         $newItem['EVNSTARTDATE'] = $datestamp;
            if(isset($aItem['EVNENDTIME'])){
                if ($aItem['EVNENDTIME'] != -1){
                    $newItem['EVNENDDATE'] = $datestamp;
                }else{
                                         $newItem['EVNENDDATE'] = $datestamp + 1;
                }
            }
        }
                 if($newItem['EVNCLASS'] != 'T'){
            self::fixAllDayEvent($newItem, $datestamp);
            self::fixAllDayEvent($newItem, $datestamp, true);
        }
                 if($newItem['EVNMEETINGID']){
            $p = &$editInfo['note_and_meeting'];
            if (empty($p['action'])) {
                unset($newItem['EVNMEETINGID']);
                $p['action'] = 'create';
            }
            if($newItem[$this->noteIndex]!=''){
                if(!$p['note_set']){
                    $p['note_set'] = true;
                    $p['note_value'] = $newItem[$this->noteIndex];
                    $separator = (($newItem['EVNDESCFORMAT'] ?? '')=='text/plain') ? self::MEETING_NOTE_SEPARATOR_TXT : self::MEETING_NOTE_SEPARATOR_HTML;
                    $sep = strpos($p['note_value'], $separator);
                    if($sep!==false){
                        $p['note_value'] = substr($p['note_value'], $sep + strlen($separator));
                    }
                }
                unset($newItem[$this->noteIndex]);
            }
            if(isset($newItem['EVNMEETINGLOBBYBACKGROUND'])){
                if(!$p['set_background']){
                    $p['set_background'] = true;
                    $p['background'] = $newItem['EVNMEETINGLOBBYBACKGROUND'];
                }
                unset($newItem['EVNMEETINGLOBBYBACKGROUND']);
            }
            if(isset($newItem['EVNMEETINGPASSWORD'])){
                if(!$p['set_password']){
                    $p['set_password'] = true;
                    $p['password'] = $newItem['EVNMEETINGPASSWORD'];
                }
                unset($newItem['EVNMEETINGPASSWORD']);
            }
        }
                 self::removeEditTags($newItem, CASE_UPPER, true);
                 $sNewItem = $oAccount->gwAPI->CreateParamLine($newItem);
        if($sNewItem){
            $sNewItem = 'use_tzid=1&'.$sNewItem;
        }
        if (!$sEvnId = $oAccount->gwAPI->FunctionCall($this->addMethod, $this->sFID, $sNewItem)){
            throw new Exc('item_edit', MerakGWAPI::getGwErrorMessage(self::getError($oAccount->gwAPI)));
        }
        $aTreeItem['@attributes']['uid'] = $sEvnId;
        $result = $this->folder->getItem($sEvnId, NO_ADDONS);
                 self::copyEventAddons($this, $result, $noreminder, $datestamp);
                 if ($contactData = $this->getAddonData('contact')) {
            $contacts = array_combine(array_column($contactData, 'CNT_ID'), $contactData);
            foreach ($aTreeItem['@childnodes']['contacts'] ?? [] as $key => $item) {
                $id = key($item['@childnodes']['contact']);
                if(isset($contacts[$id])){
                    $contact = $contacts[key($item['@childnodes']['contact'])];
                    $aTreeItem['@childnodes']['contacts'][$key]['@childnodes']['contact'][$id]['EMAIL'] = $contact['CNTEMAIL'];
                }
            }
        }
                 $result->processItemExtras($aItem, $aTreeItem, $editInfo['note_and_meeting']);
                 if($finalize){
            $oAccount->gwAPI->FunctionCall($this->addMethod, $this->sFID, '', $sEvnId);
        }
        return $result;
    }

    private function getEditInfo(&$aItem, &$aTreeItem)
    {
        $editInfo['duplicity'] = $aItem['DUPLICITY'];
        $editInfo['skip_invitation'] = $aItem['SKIP_INVITATION'];
		$editInfo['auto_save'] = $aItem['AUTO_SAVE'];
        if ($editInfo['auto_save']){
        	unset($aTreeItem['@childnodes']['reminders']);
        	unset($aTreeItem['@childnodes']['attachments']);
        	unset($aTreeItem['@childnodes']['contacts']);
        }
		         unset($aItem['AUTO_SAVE'], $aItem['SKIP_INVITATION'], $aItem['DUPLICITY']);
        $editInfo['invitation'] = $this->checkForInvitation($aItem, $aTreeItem, $editInfo['skip_invitation'],$editInfo['auto_save']);
        $editInfo['note_and_meeting'] = self::extractNoteAndMeetingInfo($this->folder, $aItem, $aTreeItem);
        return $editInfo;
    }

    private function checkForInvitation(&$aItem, &$aTreeItem, $skipInvitation, $autoSave)
    {
         		$aCompare = $this->item;
		$this->folder->account->gwAPI->TimeZone($aCompare, 'in');
        $result = [];
        $aCurrentID = [];
        $result['groupchatowneremail'] = '';
        $result['invitation'] = false;
        $result['is_attendee'] = $this->isAttendee($aItem['EVNFLAGS']) || $this->isAttendee($this->item['EVNFLAGS']);
        $result['is_organizer'] = $this->isOrganizator($this->item['EVNFLAGS']) || $this->isOrganizator($aItem['EVNFLAGS']);
        if ($result['is_organizer']) {
            $result['organizer_email'] = $this->folder->account->gwAPI->getFolderOwner($this->folder, $result['groupchatowneremail']);
            $sOrganizerFullAddress = $this->folder->account->gwAPI->getOwnerFullAddress($result['organizer_email'], $result['groupchatowneremail']);
            $result['organizer_full'] = $aItem['EVNORGANIZER'] = $sOrganizerFullAddress;
            $aCurrentList = $this->getAddonData('contact');
            if ($aCurrentList) {
                foreach ($aCurrentList as $key => $aAtt) {
                    if (isset($aAtt['CNTEVN_ID'])) {
                        unset($aCurrentList[$key]['CNTEVN_ID']);
                    }
                    $aCurrentID[$aAtt['CNT_ID']] = $aAtt;
                }
            }
            if (isset($aTreeItem['@childnodes']['contacts'][0]['@childnodes']['contact'])) {
                $aDelete = [];
                $aChangedList = &$aTreeItem['@childnodes']['contacts'][0]['@childnodes']['contact'];
                foreach ($aChangedList as $id => $changed) {
                    if (isset($aCurrentID[$id]) && $changed['@attributes']['uid'] && !isset($changed['@childnodes'])) {
                        $aDelete[$aCurrentID[$id]['CNTEMAIL']] = $id;
                    }
                    if (isset($changed['@childnodes'])) {
                        $email = $changed['@childnodes']['values'][0]['@childnodes']['cntemail'][0]['@value'];
                        if (isset($aDelete[$email])) {
                            $aChangedList[$aDelete[$email]] = $changed;
                            $aChangedList[$aDelete[$email]]['@attributes']['uid'] = $aDelete[$email];
                            unset($aChangedList[$id]);
                        }
                    }
                }
            }
            $result['invitation'] = true;
        }

		$result['sent_nothing'] = $this->item['EVNFLAGS'] && (isset($aItem['EVNFLAGS']) && !$aItem['EVNFLAGS']);
        $result['sent_always'] = !$this->item['EVNFLAGS'] && ($this->isOrganizator($aItem['EVNFLAGS']));
		if ($skipInvitation || $autoSave) $result['sent_nothing'] = true;
		if($result['is_attendee']){
			$result['organizer_email'] = $this->item['EVNORGANIZER'];
			$result['attendee_email'] = $this->folder->account->gwAPI->getFolderOwner($this->folder);
		}
		if (($result['invitation'] || $result['is_attendee'] || $this->folder->getType() == 'T') && $aItem) {
            foreach ($aItem as $property => $value){
                $propertyUpper = strtoupper($property);
                if ($propertyUpper != 'CTZ' && ($aCompare[$propertyUpper] != $aItem[$property])) {
                    if ($propertyUpper == 'TZLINK' || $propertyUpper == 'EVNTYPE' || ($propertyUpper == 'MEETING_ACTION' && $aItem[$property] != 1)) continue;
                    if ($propertyUpper == 'EVNSTATUS') {
                        $result['status_change'] = true;
                    }
                    if ($result['is_attendee'] ) {
                        $result['send_counter']  = true;
                    } else {
                        $result['reset_attendees']  = true;
                    }
                }
            }
            if (!$result['invitation'] && !$result['is_attendee']) {
                $result['sent_nothing'] = true;
                unset($result['send_counter']);
                unset($result['reset_attendees']);
            }
		}
        $result['changed_list'] = $aChangedList;
        $result['current_list'] = $aCurrentList;
        $result['currentid_list'] = $aCurrentID;
        return $result;
    }

     
    private static function extractNoteAndMeetingInfo(&$folder, &$aItem, &$aTreeItem)
    {
        $sNote = $folder->getType() == 'C' ? 'ITMDESCRIPTION' : 'EVNNOTE';
        $result = [];

                 $result['note_set'] = false;
        $result['note_value'] = null;
        if(isset($aItem[$sNote])){
            $result['note_set']  = true;
            $result['note_value']  = $aItem[$sNote];
            unset($aItem[$sNote]);
        }
        if(empty($result['note_value'])){
		    $result['note_value'] = $aTreeItem['@childnodes']['notes'][0]['@childnodes']['note'][0]['@childnodes']['values'][0]['@childnodes']['note_text'][0]['@value'];
            if(isset($result['note_value'])){
                $result['note_set'] = true;
                unset($aTreeItem['@childnodes']['notes']);
            }
        }
                 if($aItem['EVNDESCFORMAT'] == 'text/html' && $result['note_value'] !== '') {
            $sanitizedNote = slToolsString::purifyHTML($result['note_value'], true);
            $result['note_value'] = $sanitizedNote;
        }
                 $result['note_has_attachments'] = false;
        $noteHasAttachments = self::dataContainsAttachment($result['note_value']);
        if($noteHasAttachments) {
           $result['note_value'] = self::replaceCID($result['note_value'], $aTreeItem);
           $result['note_has_attachments'] = true;
        }
        if($result['note_set']) {
            $result['action'] = $aItem['MEETING_ACTION'] ?? null;
            $result['set_password'] = false;
            if(isset($aItem['MEETING_PASSWORD'])){
                $result['password'] = $aItem['MEETING_PASSWORD'];
                $result['set_password'] = true;
            }
            $result['set_background'] = false;
            if(isset($aItem['EVNMEETINGLOBBYBACKGROUND'])){
                $result['background'] = $aItem['EVNMEETINGLOBBYBACKGROUND'];
                $result['set_background'] = true;
            }    
            unset($aItem['MEETING_ACTION'], $aItem['MEETING_PASSWORD'], $aItem['EVNMEETINGLOBBYBACKGROUND']);
        }
        return $result;
    }

     
    static private function applyNoteAndMeetingInfo(&$folder, &$aItem, $meetingInfo)
    {
        $sNote = $folder->getType() == 'C' ? 'ITMDESCRIPTION' : 'EVNNOTE';
        if($meetingInfo['note_set']) $aItem[$sNote] = $meetingInfo['note_value'];
        if(!empty($meetingInfo['action']) && ($meetingInfo['action'] !== 'edit')) $aItem['MEETING_ACTION'] = $meetingInfo['action'];
        if($meetingInfo['set_password']) $aItem['MEETING_PASSWORD'] = $meetingInfo['password'];
        if($meetingInfo['set_background']) $aItem['EVNMEETINGLOBBYBACKGROUND'] = $meetingInfo['background'];
    }

     
    private function noteAndMeetingAction(&$aItem, $meetingInfo )
    {
        $gwAPI = &$this->folder->account->gwAPI;
        if($meetingInfo['note_set']){
            $this->openAccess(false);
            $gwAPI->FunctionCall("DeleteItemAttribute", $this->sFID, $this->itemID, '', 'note');
            $aItem[$this->noteIndex] = $meetingInfo['note_value'];
            if($this->folder->getType() == 'N' && !$this->hasNoteAddon){
                $result = $gwAPI->FunctionCall("setEventNoteText", $this->sFID, $this->itemID, $aItem[$this->noteIndex]);
            }else{
                $noteparams = [$this->noteIndex => $aItem[$this->noteIndex]];
                self::applyNoteAndMeetingInfo($this->folder, $noteparams, $meetingInfo);
                $result = $gwAPI->FunctionCall($this->addMethod, $this->sFID, '&' . $gwAPI->CreateParamLine($noteparams), $this->itemID, '', ';NOEDITCOUNTER');
            }
        }
        return $result;
    }

    static private function fixAllDayEvent(&$event, $datestamp, $tz = false)
    {
        $p = $tz?'_TZ':'';
        if($event[$p.'EVNENDTIME'] == '-1' && $event[$p.'EVNSTARTDATE'] == $event[$p.'EVNENDDATE']){
            $event[$p.'EVNSTARTDATE'] = $datestamp;
            $event[$p.'EVNENDDATE'] = $datestamp + 1;
        }
    }

    private function getUpdatedMasterObject($getMaster = true)
    {
        $result = &$this;
        if (($masterID = $this->updateMasterObject($this->folder->account, false, true))) {
            if($getMaster){
                try {
                    $result = $this->folder->getItem($masterID, NO_ADDONS);
                } catch (Exception $e) {}
            }
        }
        return $result;
    }
}