<?php

namespace server\inc\gw;

 

use server\model\AGwEventItem;
use tools\SearchParserYoda;

class Search extends SearchParserYoda
{
     
    protected $conditions = [];
     
    public $folder;
    public $enabled = true;
    protected $isVirtual = true;
    protected $preparedSql = '';
    protected $tableName;
    public $filter = [];
    public $searchCondition;
    protected $lastConditionsSearched = [];

    private $fulltextSupport;

    static public $_allowedKeywords = [
        'from',
        'to',
        'subject',
        'after',
        'before',
        'has',
        'fulltext',
        'is',
        'tag',
        'taglist',
        'with',
        'yoda',
        'afterack',
        'afterackid',
        'beforeack',
        'beforeackid',
        'untilid',
        'aroundid',
        'addressbook',
        'uids',
        'uid',
        'itmclass'
    ];

    public static $_default_keyword = 'fulltext';
    public $fallback = true;

    public function __construct($folder, &$searchCondition = '', string $arrayKey = null)
    {
        if(is_array($searchCondition)){
            $this->filter = &$searchCondition;
            $this->searchCondition = $searchCondition[$arrayKey] ?? '';
        }else{
            $this->searchCondition = $searchCondition;
        }
        $this->configTableName($_SESSION['DBTYPE']);
        $this->fulltextSupport = $_SESSION['FULLTEXT_SUPPORT'];
        if($folder instanceof \VirtualFolder) $this->isVirtual = true;
        $this->folder = $folder;
                 try {
            $this->conditions = self::parseExpression($this->searchCondition);
        }catch (\Exception $e){
            return $this->enabled = false;
        }
        try {
            $model = AGwEventItem::getModelByFolder($this->folder);
            if(!$model instanceof AGwEventItem) return $this->enabled = false;
            $this->preparedSql = $model->getSearchSqlQuery($this, $this->conditions, $searchCondition);
        }catch (\Exception $e){
            $this->enabled = false;
        }
    }

    public function configTableName($dbType)
    {
        $this->setTableName(false);
        if($this->folder && $this->folder->type == 'V' && $this->folder->getType() == 'M' && $this->folder->isEmpty()){
            if (strtoupper($dbType) == 'MYSQL') $this->setTableName('i');
        }
    }

    public function setTableName($tableName)
    {
        $this->tableName = $tableName;
    }

    public function addTableName($column)
    {
        return ($this->tableName ? $this->tableName . '.' : '') . $column;
    }

     
    public function isSearchEnabled(): bool
    {
        return $this->enabled;
    }

     
    public function getSearchSql(&$alreadySearched = false) : string
    {
        return $this->preparedSql;
    }

     
    public function hasKeyword($keyword) : bool
    {
        $keyword = strtolower($keyword);
        foreach (array_column($this->conditions, 'keyword') as $index => $found) {
            if($keyword == strtolower($found)){
                $this->lastConditionsSearched[$keyword] = $this->conditions[$index];
                return true;
            }
        }
        return false;
    }

     
    public function getConditionByKeyword($keyword) : array
    {
        $keyword = strtolower($keyword);
        if(isset($this->lastConditionsSearched[$keyword])) {
            $this->lastConditionsSearched[$keyword]['value'] = \slToolsString::removeQuotes($this->lastConditionsSearched[$keyword]['value']);
            return $this->lastConditionsSearched[$keyword];
        }
        foreach (array_column($this->conditions, 'keyword') as $index => $found) {
            if(strtolower($keyword) == $found) {
                $this->conditions[$index]['value'] = \slToolsString::removeQuotes($this->conditions[$index]['value']);
                return $this->lastConditionsSearched[$keyword] = $this->conditions[$index];
            }
        }
        return [];
    }

     
    public function getFolder()
    {
        return $this->folder;
    }

    public function fulltextEnabled()
    {
        return $this->fulltextSupport ? true : false;
    }
}
