<?php

namespace Sabre\VObject;

abstract class Node implements \IteratorAggregate, \ArrayAccess, \Countable, \JsonSerializable, Xml\XmlSerializable {}

class ElementList extends \ArrayIterator {};
class Component extends Node {
    public function count(): int { return 0; }
    public function getIterator(): ElementList { return new ElementList(); }
    public function jsonSerialize(): array { return []; }
    public function offsetExists($offset): bool { return true; }
    public function offsetGet($offset): int { return 0; }
    public function offsetSet($offset, $value): void { }
    public function offsetUnset($offset): void { }
    public function serialize(): string { return ''; }

    public function xmlSerialize($writer) {}
    
}

abstract class Document extends Component {}

class Reader {
    public static function read($data, $options = 0, $charset = 'UTF-8') {}
}

class Property extends Component {}