_me = frm_main_resize.prototype;
function frm_main_resize(){};

_me._initResize = function(){
	var me = this,
		slider = this._getAnchor('slider'),
		slider2 = this._getAnchor('slider2');

	this._add_destructor('_destructResizeEvn');

	slider.ondragstart = function(e){ return false };
	slider.onmousedown = function(e){
		e.preventDefault();
		e.stopPropagation();

		[].forEach.call(document.querySelectorAll('iframe'), function(iframe) {
			iframe.style.pointerEvents = 'none';
		});

		me.__activeSlider = this.id.substr(me._pathName.length+1);

		var epos = getSize(this).x,
			cpos = getSize(me._getAnchor('container')).x,
			spos = e.clientX - epos,
			iPos = null,
			max,
			dw = document.body.offsetWidth;

		addcss(this,'active',true);

		if (me.__activeSlider == 'slider'){
			max = 450>dw-cpos?dw-cpos:450;
		}
		else{
			// Calculate max x to leave space space for main content (IM resize)
			if (me.main && me.main._type == 'frm_main_mail_wide')
				max = getSize(me.main._getAnchor('slider')).x + (gui._rtl?-260:260);
			else {
				max = getSize(slider).x || Cookie.get(['vertical_slider',screen.width+'x'+screen.height]) || 260;
				max = max || dw - 68;
				max = gui._rtl ? max-300 : max+300;
			}
		}

		if (!me._mousemove_bar){
			me._mousemove_bar = function (e){
				iPos = e.clientX - spos;
				if (me.__activeSlider == 'slider'){
					iPos -= cpos;

					if (gui._rtl)
						iPos = dw-iPos-64;

					iPos = iPos>max?max:iPos;
					iPos = iPos<180?180:iPos;

					me._resize(iPos);
				} else {
					// right panel resizing, width between 340 and 680 (or less if there is not enough space)
					if(gui._rtl) {
						iPos = iPos>680?680:iPos;
						iPos = iPos>max?max:iPos;
						iPos = iPos<340?340:iPos;
					} else {
						iPos = iPos<max?max:iPos;
						iPos = iPos>dw-340?dw-340:iPos;
						iPos = (dw - iPos>680?dw - 680:iPos);
					}

					me._resize(gui._rtl ? iPos : dw - iPos);
				}
			};

			gui._obeyEvent('mousemove',[me._mousemove_bar]);
		}

		if (!me._mouseup_bar){
			me._mouseup_bar = function (e){
				[].forEach.call(document.querySelectorAll('iframe'), function(iframe) {
					iframe.style.pointerEvents = '';
				});

				//disobey
				gui._disobeyEvent('mousemove',[me._mousemove_bar]);
				gui._disobeyEvent('mouseup',[me._mouseup_bar]);

				me._mousemove_bar = null;
				setTimeout(function() {
					me._mouseup_bar = null;
				}, 5);

				//remove class
				removecss(me._getAnchor(me.__activeSlider),'active',true);

				//save position
				if (iPos !== null){
					if (me.__activeSlider == 'slider')
						me._resize(iPos);
					else
					me._resize(gui._rtl ? iPos : dw - iPos);
				}
			};
			gui._obeyEvent('mouseup',[me._mouseup_bar]);
		}
	};

	if (slider2) {
		if ((!GWOthers.getItem('BANNER_OPTIONS', 'below_type') || GWOthers.getItem('BANNER_OPTIONS', 'below_type') === 'none')) {
			slider2.onmousedown = slider.onmousedown;
			slider2.ondragstart = slider.ondragstart;
		} else {
			slider2.classList.remove('y');
		}
	}

	//initial size
	this.__activeSlider = 'slider';
	this._resize(Cookie.get(['vertical_slider', screen.width + 'x' + screen.height]) || 260, true);
	this.__activeSlider = 'slider2';
	this._resize(Cookie.get(['vertical_slider2', screen.width + 'x' + screen.height]) || 360, true);

	gui._obeyEvent('resize', [function () {
		me.__activeSlider = 'slider';
		me._resize(Cookie.get(['vertical_slider', screen.width + 'x' + screen.height]) || 260, true);
		me.__activeSlider = 'slider2';
		me._resize(Cookie.get(['vertical_slider2', screen.width + 'x' + screen.height]) || 360, true);
	}]);
};

_me._destructResizeEvn = function(){

	if (this._mousemove_bar){
		gui._disobeyEvent('mousemove',[this._mousemove_bar]);
		this._mousemove_bar = null;
	}

	if (this._mouseup_bar){
		gui._disobeyEvent('mouseup',[this._mouseup_bar]);
		this._mouseup_bar = null;
	}
};

/**
 * slider position from left side
 **/
_me._resize = function(x, bNoUpdate){

    //set width
	x = parseInt(x);
	x = Is.Number(x)?x:0;

    var dw = document.body.offsetWidth;
	var slider = this._getAnchor('slider');

	if (this.__activeSlider == 'slider'){

		var max;
		if (this.__rightDock === true) {
			max = dw - 640;
		} else if (this.__rightDock === false) {
			max = dw - 300 - 34;
		} else {
			max = dw - 300;
		}

		x = x>max?max:x;
		x = x<180?180:x;

		this._getAnchor('bar').style.width = x + 4 + 'px';
		this._getAnchor('bar').style.maxWidth = x + 4 + 'px';
		slider.style[gui._rtl?'right':'left'] = x + 'px';
		this._getAnchor('toolbar1').style['margin-inline-start'] = x + 4 + 'px';

		if (!bNoUpdate)	{
			Cookie.set(['vertical_slider', screen.width + 'x' + screen.height], x);
			gui.__exeEvent('settings_changed');
		}

		this._getAnchor('main').style['margin-inline-start'] = x + 4 + 'px';
	} else {

		x = dw - x;

		var min = (Cookie.get(['vertical_slider', screen.width + 'x' + screen.height]) || 260) + (gui._rtl?-300:300);

		x = x<min?min:x;
		x = (dw - x)>340?x:(x==0?dw - 150:dw - 340);
		x = dw - x>680?dw - 680:x;

		var rightPanel = this._getAnchor('right');
		rightPanel.classList.add('resizing');
		this._getAnchor('slider2').style[gui._rtl?'left':'right'] = (dw - x - 16) + 'px';
		rightPanel.style.width = (dw - x - 16) + 'px';
		setTimeout(function() {
			rightPanel.classList.remove('resizing');
		}, 5);

		if (!bNoUpdate)	Cookie.set(['vertical_slider2',screen.width+'x'+screen.height],dw-x);
	}
};