/************* XmlTool *************
* @brief   XML tools
* @author  DRZ 16.05.2005
*
* mozna najit lepsi cestu jak vytvaret XMLDoc, aby se to nevolalo pokazdy kdyz XML2Array
*/
function cXMLTools(){

	this.noparse = {'http://www.w3.org/1999/xhtml':true};
};

/**
 * @brief: Return latest supported DomDocument
 */
cXMLTools.prototype.XMLDoc = function(){
	return document.implementation.createDocument("", "", null);
};

/**
 * @brief: Converts XMLObj into JS Array
 */
cXMLTools.prototype.XML2Arr = function(xInput,bNasted){

	var aOutput = {}, iKey, i;

	for(i=0;;i++){
		if (i==0)
			var xTag = xInput.firstChild;
		else
		if (xTag.nextSibling)
			xTag = xTag.nextSibling;
		else{

			//Throw error
			if (!bNasted && (!aOutput || (aOutput.PARSERERROR && aOutput.PARSERERROR[0])))
				throw "XML parsing error: "+aOutput.PARSERERROR[0].VALUE;

			return aOutput;
		}

		if (!xTag.tagName) {
			 console.error('Missing tagName', xTag, xInput);
			continue;
		}

		//get upercase name
		var sTagname = xTag.tagName.toUpperCase();

		//get position key number
		if (aOutput[sTagname]){
			//aOutput[sTagname][iKey] = [];
			aOutput[sTagname].push({});
			iKey = aOutput[sTagname].length-1;
		}
		else{
			iKey = 0;
			aOutput[sTagname] = [{}];
			//aOutput[sTagname][iKey] = [];
		}

		//html
		var ns = xTag.getAttribute('xmlns');
		if (ns && this.noparse[ns]){
			var v = this.XML2Str(xTag);
			v = v.substring(v.indexOf('>')+1,v.lastIndexOf('<'));

			aOutput[sTagname][iKey]['VALUE'] = v;
		}
		else
		//xml
		if (xTag.hasChildNodes()){
			if (xTag.firstChild.nodeValue){
				var tmpTag = xTag.firstChild;

				aOutput[sTagname][iKey]['VALUE'] = tmpTag.nodeValue;

				while (1){
					if((tmpTag = tmpTag.nextSibling)){
						if (tmpTag.nodeValue)
							aOutput[sTagname][iKey]['VALUE'] += tmpTag.nodeValue;
					}
					else{
						tmpTag = null;
						break;
					}
				}
			}
			else
				aOutput[sTagname][iKey] = this.XML2Arr(xTag,true);
		}

		//get attributes
		if (xTag.attributes.length){
			aOutput[sTagname][iKey]['ATTRIBUTES'] = {};
			for (i=0;i<xTag.attributes.length;i++)
				aOutput[sTagname][iKey]['ATTRIBUTES'][xTag.attributes.item(i).nodeName.toUpperCase()] = xTag.attributes.item(i).nodeValue;
		}
	}
};

/** OK
 * @brief: Converts JS Array into XMLObj
 */
cXMLTools.prototype.Arr2XML = function(aIn,xElm,bPreserveCase){

	/* clone input array */
	var aInput = (xElm?aIn:clone(aIn,true)),
		elm;

	/* prepare new XMLDocument */
	if (!xElm){
		this.xDoc = null;
		this.xDoc = this.XMLDoc();
	}

	for(var i in aInput){
		for(var ii in aInput[i]){

			if (aInput[i][ii]['ATTRIBUTES'] && (aInput[i][ii]['ATTRIBUTES'].XMLNS || aInput[i][ii]['ATTRIBUTES'].xmlns) && this.xDoc.createElementNS){
				elm = this.xDoc.createElementNS(aInput[i][ii]['ATTRIBUTES'].XMLNS || aInput[i][ii]['ATTRIBUTES'].xmlns ,(bPreserveCase) ? i : i.toLowerCase());
				delete aInput[i][ii]['ATTRIBUTES'].XMLNS;
				delete aInput[i][ii]['ATTRIBUTES'].xmlns;
			}
			else
			if (xElm && xElm.namespaceURI && this.xDoc.createElementNS)
				elm = this.xDoc.createElementNS(xElm.namespaceURI,(bPreserveCase) ? i : i.toLowerCase());
			else
				elm = this.xDoc.createElement((bPreserveCase) ? i : i.toLowerCase());

			//Add attributes
			if (typeof aInput[i][ii]['ATTRIBUTES'] == 'object' && aInput[i][ii]['ATTRIBUTES'].constructor != Array){
				for(var ai in aInput[i][ii]['ATTRIBUTES'])
					elm.setAttribute((bPreserveCase) ? ai : ai.toLowerCase(),aInput[i][ii]['ATTRIBUTES'][ai]);

				delete aInput[i][ii]['ATTRIBUTES'];
			}

			//Add values
			if (typeof aInput[i][ii]['VALUE'] != 'undefined' && typeof aInput[i][ii]['VALUE'] != 'object'){
				elm.appendChild(this.xDoc.createTextNode(aInput[i][ii]['VALUE']));
			}
			//Add children
			else
				this.Arr2XML(aInput[i][ii],elm,bPreserveCase);

			//Append element
			if (!xElm){
				this.xDoc.appendChild(elm);

				return this.xDoc;
			}
			else
				xElm.appendChild(elm);
		}
	}
};

/** OK
 * @brief   Converts String into XMLObj
 */
cXMLTools.prototype.Str2XML = function(sInput){
	var xParser = new DOMParser();
	var xOutput = xParser.parseFromString(sInput, 'text/xml');

	this.stripWhiteSpace(xOutput);

	return xOutput;
};

/** OK
* @brief   Converts XMLObj into String
*/
cXMLTools.prototype.XML2Str  = function(xInput){
	try{
		var sOut;
		if (xInput.xml)
			sOut = xInput.xml;
		else
			sOut = (new XMLSerializer()).serializeToString(xInput);

		return sOut;
	}
	catch {
		return '';
	}
};

/**
 * @brief: Converts String into Array
 */
cXMLTools.prototype.Str2Arr  = function(sInput){
	try{
		return this.XML2Arr(this.Str2XML(sInput));
	}
	catch (e){
		 console.warn('Str2Arr', e, sInput);
		return [];
	}
};

cXMLTools.prototype.Arr2Str = function(aInput,bPreserveCase) {
	try {
		return this.XML2Str(this.Arr2XML(aInput,null,bPreserveCase));
	}
	catch (e) { 
		 console.log('Arr2Str', e);
	}
};

/**
 * @brief: strip WhiteSpaces from XML
 */
cXMLTools.prototype.stripWhiteSpace = function (node) {
	var nodesToDelete = [];
	this.findWhiteSpace(node, 0, nodesToDelete);
	for(var i = nodesToDelete.length; i--; ) {
		var nodeRef = nodesToDelete[i];
		nodeRef.parentNode.removeChild(nodeRef);
	}

	return node;
};

cXMLTools.prototype.is_ws = function (nod) {
	return !(/[^\t\n\r ]/.test(nod.data));
};

cXMLTools.prototype.findWhiteSpace = function (node, nodeNo, nodesToDelete) {
	for (var i = node.childNodes.length; i--; ) {

		//if (node.childNodes[i].nodeType == 3 && this.is_ws(node.childNodes[i]))
		if (node.childNodes[i].splitText !== undefined && this.is_ws(node.childNodes[i]))
			nodesToDelete[nodesToDelete.length] = node.childNodes[i];
		if (node.childNodes[i].hasChildNodes())
			this.findWhiteSpace(node.childNodes[i], i, nodesToDelete);
	}
	node = node.parentNode;
	i = nodeNo;
};

/////////////////////////////////////

var XMLTools = new cXMLTools();