function wm_conference(id, aData) {
	id = (id || 'tmp').toString().replace(/@/, '_');
	if (!~id.indexOf('_')) {
		id = id + '_' + location.hostname;
	}
	this.id = id;
	this.messageID = 1;
	this.messageCallbacks = {};
	this.data = aData || {};
	this.options = {};
	this.isRunning = false;
	wm_conference.conferences[id] = this;

	var windowExistsInterval = setInterval(function () {
		if (this.isRunning && (!this.window || this.window.closed)) {
			clearInterval(windowExistsInterval);
			this.close();
		}
	}.bind(this), 1000);

};

wm_conference.linkRegExp = /https?:\/\/([^/]*)\/(?:conference\/|.*\?meeting=)([0-9]{5,})/;
wm_conference.conferences = {};

wm_conference.get = function (id, aData) {
	return wm_conference.conferences[id] || new wm_conference(id, aData);
};

wm_conference.create = function (callback, options) {
	options = options || {};

	icewarpapi.send({
		commandname: 'GWAddMeetingInfo',
		commandparams: {
			meetingtype: 'conference',
			organizer: sPrimaryAccount,
			summary: options.subject || '',
			password: options.password || '',
			folder: options.folder || '',
			autorecording: options.recording ? '1' : '0',
			autolobby: options.autolobby ? '1': '0',
			lobbybackground: options.lobbybackground || ''
		}
	}, {
		success: function (response) {
			if (!response.meetingid) {
				return gui.notifier._value({
					type: 'error',
					args: {
						header: 'CONFERENCE::CANNOT_START_NEW'
					}
				});
			}
			var conference = wm_conference.get(response.meetingid);
			conference.options = options;
			Object.assign(conference.data, options);
			conference.getDetail(function () {
				callback(conference);
			});
		},
		error: function (error) {
			console.error('Unable to create conference', error);
			window.Sentry && Sentry.withScope(function(scope) {
				scope.setTag('module', 'conference');
				Sentry.captureException(error);
			});
		},
		context: this
	});
};

_me = wm_conference.prototype;

_me.getDetail = function (callback, errorCallback) {
	if (!window.icewarpapi) {
		return callback();
	}
	icewarpapi.authenticate({
		success: function () {
			icewarpapi.send({
				commandname: 'GWGetMeetingInfo',
				commandparams: {
					meetingid: this.id
				}
			}, {
				success: function (response) {
					for (var i in response) {
						if (i === 'server') {
							continue;
						}
						this.data[i] = response[i] || this.data[i];
					}
					this.data.organizer = this.data.organizer || sPrimaryAccount;

					callback(this.data);
				},
				error: function (error) {
					console.error('Unable to get conference detail', this.id, error);
					window.Sentry && Sentry.withScope(function(scope) {
						scope.setTag('module', 'conference');
						Sentry.captureException(error);
					});
					errorCallback && errorCallback(error);
				},
				context: this
			});
		},
		context: this
	});
};

_me.join = function () {
	if (this.isRunning && this.focus()) {
		return;
	}

	var conference = wm_conference.conferences[dataSet.get('main', ['conference'])];
	if (conference && conference.window){
		if (conference.window.closed){
			var id = conference.id,
				data = conference.data;

			conference.close();
			this.get(id, data);
		}
		else{
			if (dataSet.get('main', ['conference']) === this.id)  {
				conference.focus();
			} else {
				gui.notifier._value({
					type: 'conference',
					args: {
						header: 'CONFERENCE::CANNOT_START_NEW',
						text_plain: getLang('CONFERENCE::ALREADY_RUNNING'),
						conferenceid: dataSet.get('main', ['conference'])
					}
				});
			}
			return;
		}
	}

	this.getDetail(this.open.bind(this), function(error) {

		gui.notifier._value({
			type: 'conference',
			args: {
				text_plain: getLang('ERROR::MEETING_NOT_FOUND'),
			}
		});
	});
};

_me.remoteJoin = function () {
	icewarpapi.send({
		commandname: 'MeetingRemoteJoined',
		commandparams: {
			meetingid: this.id.replace('_', '@'),
			meetingurl: this.data.meetingurl,
			organizer: MailAddress.createEmail(this.data.organizername, this.data.organizer).escapeHTML(),
			summary: this.data.subject,
			recordingsuri: this.data.recordingsuri || '',
			recordingsapiuri: this.data.recordingsapiuri || ''
		}
	}, {
		success: function () {
		},
		error: function (error) {
			console.error('Unable to create conference', error);
			window.Sentry && Sentry.withScope(function(scope) {
				scope.setTag('module', 'conference');
				Sentry.captureException(error);
			});
		},
		context: this
	});
};

_me.invite = function (aRecipients) {
	gui.frm_main.im && (aRecipients || []).forEach(function (sRecipient) {
		gui.frm_main.im._send(sRecipient, getLang('CONFERENCE::CHATINVITE', [this.getLink()]), void 0, true);
	}, this);
};

_me.focus = function () {
	if (this.window && !this.window.closed){
		this.isRunning = true;
		this.window.focus();
		return true;
	}

	this.isRunning = false;
	return false;
};

_me.open = function () {
	this.window = open(this.getLink(), 'jitsi_' + sPrimaryAccount);

	this.isRunning = true;
};

_me.close = function (forceClose) {
	this.isRunning = false;
	if (this.window && !this.window.closed && !forceClose) {
		this.postMessage({
			event: 'executeCommand',
			args: ['hangup']
		}, function () {
			this.window.close();
			this.window = null;
			dataSet.remove('main', ['conference']);
			gui.__exeEvent('conference_ended');
			gui.__exeEvent('conference_window_closed');
			delete wm_conference.conferences[this.id];
		}.bind(this));
	} else {
		if (forceClose && this.window) {
			this.window.close();
			this.window = null;
		}
		dataSet.remove('main', ['conference']);
		gui.__exeEvent('conference_ended');
		gui.__exeEvent('conference_window_closed');
		delete wm_conference.conferences[this.id];
	}
};

_me.postMessage = function (data, callback) {
	if (!this.window || this.window.closed) {
		return;
	}

	if (callback) {
		this.messageCallbacks[this.messageID] = callback;
	}

	data.cid = this.id;
	data.mid = this.messageID++;
	this.window.postMessage(data, '*');
};

_me.receiveMessage = async function (event) {
	switch (event.data.event) {
		case 'readyToClose':
			this.close(true);
			break;

		case 'setup':
			var isLocal = ((this.data.meetingid || this.id).split('@')[1] || location.hostname) === location.hostname;
			this.postMessage({
				event: 'setup',
				data: {
					session: isLocal ? dataSet.get('main', ['sid']) : null,
					icewarpapi_session: isLocal ? icewarpapi.getSession() : null,
					dashboard_url: dataSet.get('dashboard', ['config', 'dashboard_url']),
					password: this.data.password,
					username: dataSet.get('accounts', [sPrimaryAccount, 'FULLNAME']),
					email: sPrimaryAccount,
					avatar: await obj_avatar.getOwnPublicAvatarURL(),
					dynamiclink: this.data.dynamiclink,
					language: (GWOthers.getItem('LAYOUT_SETTINGS', 'language') || navigator.language || navigator.userLanguage).split(/[_-]/)[0],
					startWithAudioMuted: !this.options.mic,
					startWithVideoMuted: !this.options.camera
				}
			});
			break;

		case 'load':
			dataSet.add('main', ['conference'], this.id);
			Object.assign(this.data, event.data.data);
			this.isRunning = true;
			this.window = event.source;
			this.getDetail(function () {
				if (this.data.remote) {
					this.remoteJoin();
				}
				gui.__exeEvent('conference_started');
			}.bind(this));
			break;

		default:
			//participantRoleChanged participantJoined participantLeft
			gui.__exeEvent('conference_event', event.data);

	}

	if (event.data.mid && this.messageCallbacks[event.data.mid]) {
		this.messageCallbacks[event.data.mid](event.data.data);
		delete this.messageCallbacks[event.data.mid];
	}
};

_me.getLink = function () {
	var ids = this.id.split(/[_@]/);
	var host = ids[1] ? 'https://' + ids[1] : location.origin;

	return host + '/conference/' + ids[0];
};
