(function(){
	function cApi(){}

	function fire(id, sAction, arg) {
		if (gui.socket){
			var t = WMFolders.getType(id);
			if (t !== 'X'){
				var f = dataSet.get('folders', [id.aid, id.fid]) || {
					RELATIVE_PATH: id.fid,
					TYPE:t,
					OWNER: sPrimaryAccount
				};

				var aOut = {
					'ACTION':sAction,
					'TYPE':'item',
					'FOLDER':f.RELATIVE_PATH,
					'FOLDER-TYPE':t,
					'EMAIL':f.OWNER,
					'ORIGINATOR-EMAIL': sPrimaryAccount
				};

				if (id.iid)
					aOut.ITEM = WMItems.__serverID(id.iid);

				if (Is.Object(arg))
					Object.assign(aOut, arg);

				gui.socket.api._notify(aOut);
				return true;
			}
		}

		return false;
	};

	var statusBuffer = {};
	var unreadThreads = {};
	const STATUS = {
		OFFLINE:0,
		ONLINE:3,
		TYPING:1,
		COMMENTING:2,
		BACKGROUND:4
	};

	cApi.prototype = {

		//Message
		message:function(aPath, aItemInfo, aHandler){

			var aData = {
				values:{
					EVNNOTE: aItemInfo.body,
					EVNSHARETYPE: 'U'
				}
			};

			//Add link
			if (aItemInfo.url)
				aData.values.EVNURL = aItemInfo.url;

			//Message with link
			if (aItemInfo.title)
				aData.values.EVNTITLE = aItemInfo.title;
			if (aItemInfo.desc)
				aData.values.EVNLOCATION = aItemInfo.desc;
			if (aItemInfo.thumbnailimageid)
				aData.values.THUMBNAILIMAGEID = aItemInfo.thumbnailimageid;

			var info = {};
			if (aItemInfo.type)	info.type = aItemInfo.type;
			if (aItemInfo.linkData) info.linkData = aItemInfo.linkData;
			if (aItemInfo.videourl) info.videourl = aItemInfo.videourl;
			if (aItemInfo.videotype) info.videotype = aItemInfo.videotype;
			if (!Is.Empty(info)) {
				aData.values.LINKINFO = buildURL(info);
			}

			//Comment message
			if (aItemInfo.comevnid) {
				aData.values.EVNCOMEVNID = aItemInfo.comevnid;
				aData.values.COMEVNID = aItemInfo.comevnid;
			}

			var tmpId = WMItems.__clientID(unique_id());
			fire({
				aid: aPath.aid,
				fid: aPath.fid,
				cid: aItemInfo.comevnid || ''
			}, 'tmp_message', Object.assign({
				'ITEM-TYPE': 'I',
				id: tmpId,
				tmp: true,
			}, aData.values, aItemInfo));

			WMItems.add([aPath.aid,aPath.fid], aData,'','','', [this,'__messageHandler',[aPath, aItemInfo, aHandler, tmpId]]);
		},

		__messageHandler:function(bOK, aResponse, aPath, aItemInfo, aHandler, tmpId) {
			aHandler && executeCallbackFunction(aHandler, bOK, aResponse, aPath, aItemInfo);
			if (bOK){
				//Update Recent Position
				this.__updateRecent(aPath);

				//Add temporary msg
				var x;
				if (aResponse.id && aResponse.xml && (x = aResponse.xml.IQ) && (x = x[0].RESULT) && (x = x[0])){

					var aData = {
						body:aItemInfo.body,
						timestamp: x.EVN_CREATED?x.EVN_CREATED[0].VALUE:0
					};

					Object.assign(aData, aItemInfo, aPath, {
						iid:WMItems.__clientID(aResponse.id)
					});

					if (aData.mentions){
						//Fire add_mention event
						for(var m in aData.mentions)
							if (m == sPrimaryAccount){
								fire(aData, 'add_mention', {'ITEM-TYPE':'I'});
								break;
							}
					}

					fire(aData, 'update', Object.assign({
						'ITEM-TYPE': 'I',
						BODY: aItemInfo.body,
						THMBNAILIMAGEID: aData.thumbnailimageid,
						tmpId: tmpId
					}, aItemInfo.comevnid ? {
						COMEVNID: aItemInfo.comevnid
					} : null));
				}
			} else {
				fire({
					aid: aPath.aid,
					fid: aPath.fid,
					iid: tmpId
				}, 'delete', {
					'ITEM-TYPE': '*'
				});
			}
		},

		__updateRecent:function(aPath){
			var active_folder = aPath.aid + '/' + aPath.fid,
				recent = Cookie.get(['recent']) || [],
				index = recent.indexOf(active_folder);

			!!~index && recent.splice(index, 1);
			recent.unshift(active_folder);
			Cookie.set(['recent'], recent);
		},

		//All Items
		remove:function(aPath, aHandler){
			WMItems.remove(aPath,'','','',[function(bOK, aData){

				if (bOK){
					aPath.iid.forEach(function(iid){
						fire({aid:aPath.aid, fid:aPath.fid, iid:iid}, 'delete', {'ITEM-TYPE':'*'});
					});
				}

				aHandler && executeCallbackFunction(aHandler, bOK, aData);
			}]);
		},

		notifyRoom:function(aPath, iValue, aHandler){
			iValue = iValue?1:0;

			dataSet.add('folders', [aPath.aid, aPath.fid, 'NOTIFY'], iValue, true);

			WMFolders.action({
				aid: aPath.aid,
				fid: aPath.fid,
				xmlarray: {
					NOTIFY: [{
						VALUE:iValue
					}]
				}
			}, 'folders', '', 'edit','', aHandler);
		},

		followRoom:function(aPath, iValue, aHandler){
			iValue = iValue?1:0;

			dataSet.add('folders', [aPath.aid, aPath.fid, 'AUTOFOLLOW'], iValue, true);

			WMFolders.action({
				aid: aPath.aid,
				fid: aPath.fid,
				xmlarray: {
					AUTOFOLLOW: [{
						VALUE:iValue
					}]
				}
			}, 'folders', '', 'autofollow','', aHandler);
		},

		//Event & Conference
		addEvent:function(aPath, aItemInfo, aHandler, oGui){
			aItemInfo = aItemInfo || {};
			var aValues = getCurrentEventTime();
				aValues.EVNSHARETYPE = 'U';

			if (aItemInfo.comevnid)
				aValues.EVNCOMEVNID = aItemInfo.comevnid;

			if (aItemInfo.conference){
				aValues.conference = true;
				aValues.EVNFLAGS = 1;
				aValues.MEETING_ACTION = 1;
			}

			WMItems.list({
				aid: aPath.aid,
				fid: '__@@GROUP@@__/' + aPath.fid,
				values:[],
				filter: {
					sort: 'FRTNAME asc, FRTEMAIL asc'
				}
			}, '', '', '', [function(aData) {
				aValues.CONTACTS = {};
				if (aData && (aData = aData[aPath.aid]) && (aData = aData['__@@GROUP@@__/' + aPath.fid])){
					var i = 0;
					for(var id in aData) {
						if (id.indexOf('*') === 0) {
							aValues.CONTACTS[i++] = {
								values: {
									CNTEMAIL: aData[id].FRTEMAIL,
									CNTCONTACTNAME: aData[id].FRTNAME,
									CNTROLE: 'Q',
									CNTSTATUS: 'B',
									NEW: true,
									GROUPCHAT: true
								}
							};
						}
					}
				}

				Item.openwindow([sPrimaryAccount, Mapping.getDefaultFolderForGWType('E')], aValues, null, 'E', [function(bOK, aData){
					if (bOK){
						aPath.iid = aData.id;
						fire(aPath, 'add', Object.assign({'ITEM-TYPE': 'Q'}, aItemInfo.comevnid?{COMEVNID:aItemInfo.comevnid}:null));
						fire(aPath, 'add', {'ITEM-TYPE':'E'});
					}
	
					aHandler && executeCallbackFunction(aHandler, bOK, aData);
				}], void 0, void 0, oGui);
			}]);
		},

		addEmail:function(aPath, aItemInfo, oGui){
			var fid = aPath.fid;
			if (aItemInfo && aItemInfo.comevnid)
				fid += '/' + aItemInfo.comevnid;

			NewMessage.compose({teamchat:fid + '::' + aPath.fid.split('/')[0] + '/' + WMFolders.getFolderName(aPath)}, void 0, oGui);

			//Fire follow on thread
			// frm.__message.onTChCallback.push([function(aChatPath){
			// 	//It's thread
			// 	if (!dataSet.get('folders', [aChatPath.aid, aChatPath.fid])){
			// 		var tmp = aChatPath.fid.split('/');
			// 		fire({aid:aChatPath.aid, iid: tmp.pop(), fid: tmp.join('/')}, 'follow');
			// 	}
			// }]);
		},

		addDocument:function(aPath, aItemInfo, aHandler, oGui){
			aItemInfo.type = aItemInfo.type || 'F';

			var aValues = {};
			if (aItemInfo.doc)
				aValues = {'ATTACHMENTS': [{'values': {'ATTTYPE': 'document', 'ATTDESC': aItemInfo.doc}}]};

			if (aItemInfo.comevnid)
				aValues.EVNCOMEVNID = aItemInfo.comevnid;

			Item.openwindow([aPath.aid, aPath.fid], aValues, null, aItemInfo.type, [function (bOK, aData) {
				if (bOK) {
					aPath.iid = aData.id;
					fire(aPath, 'add', Object.assign({'ITEM-TYPE': 'R'}, aItemInfo.comevnid?{COMEVNID:aItemInfo.comevnid}:null));
				}

				aHandler && executeCallbackFunction(aHandler, bOK, aData);

			}], null, aItemInfo.type === 'F', oGui);
		},

		addFiles:function(aPath, aFiles, comevnid, aHandler){
			if (aFiles.length == 1) {
				gui._create('chat_upload', 'frm_chat_upload', '', '', aFiles[0].name, aFiles[0].description, aPath, [function (sName, sDesc, aArg) {
					this.__filesHandler(aPath, aFiles, comevnid, {name:sName, desc:sDesc, mentions:aArg?aArg.mentions:false}, aHandler);
				}.bind(this)]);
			}
			else
				this.__filesHandler(aPath, aFiles, comevnid, null, aHandler);
		},

		addMessageWithAttachments:function(aPath, aFiles, arg, aHandler){
			aFiles = aFiles.map(function(file) {
				var fullpath = file.fullpath;
				if (!fullpath) {
					if (file.folder && file.id) {
						fullpath = file.folder + '/' + file.id;
					} else if (file.aid && file.fid && file.iid) {
						fullpath = file.aid + '/' + Path.slash(file.fid) + '/' + WMItems.__serverID(file.iid);
						if (~['I', 'K', 'F'].indexOf(WMFolders.getType(file))) {
							file.class = 'attachment';
							fullpath += '/' + file.name;
						}
					} else {
						fullpath = this._getFolder() + '/' + file.id;
					}
				}
				return {
					id: file.id,
					class: file.class || 'file',
					name: file.name,
					size: file.size,
					fullpath: fullpath
				};
			});
			this.__filesHandler(aPath, aFiles, arg.comevnid, arg, aHandler);
		},

		queueMessageWithAttachments:function(aPath, oUpload, arg, aHandler){
			this.__queue = mkArrayPath([aPath.aid, aPath.fid, aPath.cid], this.__queue, []);

			if (!~this.__queue[aPath.aid][aPath.fid][aPath.cid].indexOf(oUpload)) {
				this.__queue[aPath.aid][aPath.fid][aPath.cid].push(oUpload);

				var queue = [].concat(oUpload.file.__value, oUpload.file.__queue).filter(function(file) {
					if (file.xhr.readyState === 4) {
						this.addMessageWithAttachments(aPath, [file], arg, aHandler);
						arg.body = '';
						return false;
					}
					return true;
				}, this);
				queue.forEach(function(attachment) {
					fire(aPath, 'tmp_message', Object.assign(attachment, {
						'ITEM-TYPE': 'R',
						attachment: attachment,
						EVNCLASS: 'R',
						EVNLINKEXTRAS: buildURL({
							EvnTitle: attachment.name,
							EvnTicket: URL.createObjectURL(attachment)
						}),
					}, arg));
				}, this);

				oUpload._onuploadsuccess = function(file) {
					this.addMessageWithAttachments(aPath, [file], arg, [function() {
						fire(aPath, 'delete', {'ITEM-TYPE': 'R', iid: file.iid});
						executeCallbackFunction(aHandler);
					}]);
					oUpload._clearAttachments(true);
					arg.body = '';
				}.bind(this);
				oUpload._onuploadaborted = function(file) {
					fire(aPath, 'delete', {'ITEM-TYPE': 'R', iid: file.iid});
				}.bind(this);
				oUpload._onuploadend = function() {
					this.__queue[aPath.aid][aPath.fid][aPath.cid] = this.__queue[aPath.aid][aPath.fid][aPath.cid].filter(function(upload) {
						return upload !== oUpload;
					});
				}.bind(this);
			}
		},

		restoreMessageQueue: function(aPath) {
			((((this.__queue || {})[aPath.aid] || {})[aPath.fid] || {})[aPath.cid] || []).forEach(function(oUpload) {
				[].concat(oUpload.file.__value, oUpload.file.__queue).filter(function(file) {
					return file.xhr.readyState !== 4;
				}, this).forEach(function(attachment) {
					fire(aPath, 'tmp_message', attachment);
				}, this);
			}, this);
		},

		__filesHandler:function(aPath, aFiles, comevnid, arg, aHandler){
			if (aFiles && aFiles.length){

				arg = arg || {};

				var d = new IcewarpDate(),
					aItemInfo = {values:{},ATTACHMENTS:[]};

				aItemInfo.values.EVNNOTE = arg.body;
				aItemInfo.values.EVNSHARETYPE = 'U';
				aItemInfo.values.EVNCLASS = 'F';
				aItemInfo.values.EVNSTARTDATE = d.format(IcewarpDate.JULIAN);
				aItemInfo.values.EVNSTARTTIME = d.hour()*60 + d.minute();

				if (comevnid)
					aItemInfo.values.EVNCOMEVNID = comevnid;

				if (aFiles.length == 1){

					aItemInfo['values']['EVNRID'] = aItemInfo['values']['EVNLOCATION'] = aItemInfo['values']['EVNTITLE'] = arg.name || aFiles[0].name;
					aItemInfo['values']['EVNCOMPLETE'] = aFiles[0].size;

					if (Is.String(arg.desc) && arg.desc.length){
						aItemInfo['values']['EVNNOTE'] = arg.desc;
						aItemInfo['values']['EVNDESCFORMAT'] = 'text/plain';
					}
				}

				for(var i=0, j = aFiles.length;i<j;i++) {
					var file = clone(aFiles[i], true);
					delete file.id;
					aItemInfo['ATTACHMENTS'].push({values:file});
				}

				var bMentions = false;
				if (arg.mentions)
					for(var m in arg.mentions)
						if (m == sPrimaryAccount){
							bMentions = true;
							break;
						}

				//Sent to server
				WMItems.add([aPath.aid, aPath.fid], aItemInfo, '','','', [function(bOK, aData){
					if (bOK){
						aData = Is.Array(aData) ? aData : [aData];

						aData.forEach(function(aData, index) {
							var data = Object.assign({}, aPath, {
								iid: aData.postid || aData.id
							});
							fire(data, 'add', Object.assign({'ITEM-TYPE':'R'}, aItemInfo.values, comevnid?{COMEVNID:comevnid}:null));
							gui.__exeEvent('onuploadcommit', { id: aFiles[index].id, data: aData });

							//Fire add_mention event
							if (bMentions)
								fire(aPath, 'add_mention', {'ITEM-TYPE':'I'});
						});
					}

					aHandler && executeCallbackFunction(aHandler, bOK);

				}]);
			}
		},

		//members
		removeMember:function(aPath, aHandler){
			aPath.fid = aPath.fid.replace(/^__@@GROUP@@__\//gi,'');

			var sAccount = WMItems.__serverID(aPath.iid),
				aItemInfo = {
					aid:aPath.aid,
					fid:aPath.fid,
					xmlarray:{ACCOUNT:[{VALUE:sAccount}]}
				};

			WMFolders.action(aItemInfo,'','','remove_member','',[function(bOK, aFolderInfo){
				if (bOK){
					fire(aPath, 'update', {TYPE:'acl'});
					fire(aPath, 'stop', {TYPE:'account'});
				}

				aHandler && executeCallbackFunction(aHandler, bOK, aFolderInfo);
			}]);
		},
		addMember: async function(aPath, aItemInfo, aHandler){
			var aDistribList = MailAddress.findDistribList({'rcp': aItemInfo.rcp});

			aItemInfo = {
				aid:aPath.aid,
				fid:aPath.fid,
				xmlarray:{
					TO:[{VALUE:aDistribList.rcp}],
					COMMENT:[{VALUE:aItemInfo.comment || ''}]
				}
			};

			var sItem =	MailAddress.splitEmailsAndNames(aDistribList.rcp)[0];
				sItem = sItem.email || '';

			if (!Is.Empty(aDistribList.distrib)){
				await storage.library('wm_messages');
				aItemInfo.xmlarray.DISTRIB = wm_messages.parse_distrib(aDistribList.distrib);
			}

			WMFolders.action(aItemInfo,'','','add_member','',[function(bOK, aFolderInfo){
				if (bOK){
					fire(aPath, 'update', {TYPE:'acl', ITEM:sItem});
					fire(aPath, 'start', {TYPE:'account', ITEM:sItem});
					fire(aPath, 'add', {TYPE:'item', ITEM:'*','ITEM-TYPE':'W'});
				}

				aHandler && executeCallbackFunction(aHandler, bOK, aFolderInfo);
			}]);
		},

		manageMembers: function(channel, _gui) {
			WMItems.list({
				aid: channel.aid,
				fid: '__@@GROUP@@__/' + channel.fid,
				values:[],
				filter: {
					sort: 'FRTISGUEST desc, FRTNAME asc, FRTEMAIL asc'
				}
			}, '', '', '', [function(aData) {
				var aUsers = [];
				if (aData && (aData = aData[channel.aid]) && (aData = aData['__@@GROUP@@__/' + channel.fid])){
					for(var id in aData){
						if (id.indexOf('*') === 0){
							aUsers.push({email:aData[id].FRTEMAIL, name:aData[id].FRTNAME, moderator:aData[id].FRTISADMIN == '1', guest:aData[id].FRTISGUEST == '1', id: id});
						}
					}
				}

				var aFormOpt = {
					description1:'CHAT::MANAGE_DESCRIPTION',
					description2:'EVENT::MANAGE_DESCRIPTION2',
					users_heading: getLang('CHAT::MEMBERS'),
					filter_placeholder: getLang('CHAT::FILTER_MEMBERS'),
					role_support: false,
					status_support: false,
					invite_support: WMFolders.getRights({aid: channel.aid, fid: channel.fid}).invite,
					remove_support: WMFolders.getRights({aid: channel.aid, fid: channel.fid}).kick,
					admin_support: WMFolders.getRights({aid: channel.aid, fid: channel.fid}).modify,
					remove_myself_admin_support: false
				};

				(_gui || gui)._create('frm_moderators','frm_moderators','main','', aUsers, function(aUsers) {
					aUsers.forEach(function(user){
						switch(user.action){
							case 'new':
								WMChat.addMember({aid: channel.aid, fid: channel.fid}, {rcp:user.email});
								if (user.moderator) {
									WMChat.makeOwner({aid: channel.aid, fid: channel.fid}, user.email);
								}
								break;
				
							case 'edit':
								if (user.moderator) {
									WMChat.makeOwner({aid: channel.aid, fid: channel.fid}, user.email);
								} else {
									WMChat.resetOwner({aid: channel.aid, fid: channel.fid}, user.email);
								}
								break;
				
							case 'remove':
								if (user.id)
									WMChat.removeMember(Object.assign({aid: channel.aid, fid: channel.fid}, {iid:user.id}));
								break;
						}
					}.bind(this));
				}, aFormOpt);
			}]);
		},

		makeOwner:function(aPath, email, aHandler) {
			var aItemInfo = {
				aid:aPath.aid,
				fid:aPath.fid,
				xmlarray: {
					VALUE: email
				}
			};

			WMFolders.action(aItemInfo,'','','makeowner','',[function(bOK, aFolderInfo){
				if (bOK){
					fire(aPath, 'update', {TYPE:'acl'});
				}
				aHandler && executeCallbackFunction(aHandler, bOK, aFolderInfo);
			}]);
		},
		resetOwner:function(aPath, email, aHandler) {
			var aItemInfo = {
				aid:aPath.aid,
				fid:aPath.fid,
				xmlarray: {
					VALUE: email
				}
			};

			WMFolders.action(aItemInfo,'','','resetowner','',[function(bOK, aFolderInfo){
				if (bOK){
					fire(aPath, 'update', {TYPE:'acl'});
				}
				aHandler && executeCallbackFunction(aHandler, bOK, aFolderInfo);
			}]);
		},

		leaveRoom:function(aPath, aHandler){
			var aItemInfo = {
					aid:aPath.aid,
					fid:aPath.fid
				};

			WMFolders.action(aItemInfo,'','','leave','',[function(bOK, aFolderInfo){
				if (bOK){
					fire(aPath, 'update', {TYPE:'acl'});
				}
				aHandler && executeCallbackFunction(aHandler, bOK, aFolderInfo);
			}]);
		},

		follow:function(aPath, bValue, aHandler){
			var sAction = bValue?'follow':'unfollow';
			WMItems.action(aPath, sAction, [
				function(bOK){
					// if (bOK){
					// 	//Fire follow on thread
					// 	fire({aid:aPath.aid, fid:aPath.fid, iid:aPath.iid[0]}, sAction);
					// }

					aHandler && executeCallbackFunction(aHandler, bOK, sAction);
				}
			]);
		},

		getFid:function(relativePath){
			var folders = dataSet.get('folders', [sPrimaryAccount]),
				domain = dataSet.get('main',['domain']);
			relativePath = Path.slash(relativePath);

			if (folders[domain +'/'+ relativePath] && Path.slash(folders[domain +'/'+ relativePath].RELATIVE_PATH) == relativePath)
				return domain +'/'+ relativePath;
			else
			for (var fid in folders)
				if (Path.slash(folders[fid].RELATIVE_PATH) === relativePath)
					return fid;

			return relativePath;
		},

		setRoomStatus:function(obj, aPath, sStatus, aStatusParam, bForceSend, aHandler, aErrHandler){

			if (!Is.Defined(STATUS[sStatus])){
				 console.warn('WMChat.status', 'wrong status', sStatus);
				return;
			}

			if (gui.socket && gui.socket.api){

				var buffer = statusBuffer[aPath.fid] ? statusBuffer[aPath.fid].objList : [];

				//Remove obj from buffer when offline
				if (sStatus == 'OFFLINE'){

					buffer = buffer.filter(function(v){
						return v != obj._pathName;
					});

					if (buffer.length){
						statusBuffer[aPath.fid].objList = buffer;
						return;
					}
				}
				else
				//Add obj to buffer
				if (!~buffer.indexOf(obj._pathName)){
					buffer.push(obj._pathName);
				}

				if (buffer.length){

					var oldStatus = statusBuffer[aPath.fid]?statusBuffer[aPath.fid].status:'';

					statusBuffer[aPath.fid] = {
						status: sStatus,
						objList: buffer
					};

					//Do not send the same status twice
					if (!bForceSend && sStatus == oldStatus)
						return;
				}
				else
					delete statusBuffer[aPath.fid];

				//Send to socket
				var aFolder = dataSet.get('folders', [aPath.aid, aPath.fid]);
				if (aFolder){
					var msg = {status:[{ATTRIBUTES:{xmlns:"api:iq:control"}, email:[{VALUE:aFolder.OWNER}], folder:[{VALUE:aFolder.RELATIVE_PATH.replace('/', '\\')}], status:[{VALUE:STATUS[sStatus]}]}]};
					aStatusParam && (msg.status[0].aStatusParam = [{VALUE:aStatusParam}]);
					gui.socket.api._create_iq(msg, aHandler, aErrHandler);
				}
			} else {
				 console.warn('WMChat.status', 'no socket');
			}
		},

		setUnreadThread: function(aPath, id) {
			id = WMItems.__serverID(id);
			unreadThreads[aPath.fid] = unreadThreads[aPath.fid] || [];
			if (!WMChat.thread.has(id) && !~unreadThreads[aPath.fid].indexOf(id)) {
				unreadThreads[aPath.fid].push(id);
			}

			fire(aPath, 'unread_thread', {THREADS: unreadThreads[aPath.fid], ITEM: id});
		},

		readThread: function(aPath, id) {
			id = WMItems.__serverID(id);
			unreadThreads[aPath.fid] = (unreadThreads[aPath.fid] || []).filter(function(threadId) {
				return id && threadId !== id;
			});

			fire(aPath, 'unread_thread', {THREADS: unreadThreads[aPath.fid], ITEM: id});
		}

	};

	//store 1:M relation id:[gui.obj]
	function objBuffer(){
		var aBuffer = {},
			tmp = {
				add:function(obj, id){
					tmp.remove(obj);
					id = WMItems.__serverID(id);

					aBuffer[id] = aBuffer[id] || [];
					aBuffer[id].push(obj._pathName);
					aBuffer[id] = aBuffer[id].filter(function(v, i ,a) {
						return a.indexOf(v) === i;
					});
				},
				remove:function(obj){
					for(var id in aBuffer){
						id = WMItems.__serverID(id);
						aBuffer[id] = aBuffer[id].filter(function(pn){
							return pn != obj._pathName;
						});

						if (!aBuffer[id].length)
							delete aBuffer[id];
					}
				},
				has:function(id){
					id = WMItems.__serverID(id);
					return aBuffer[id] && aBuffer[id].length;
				},
				list:function(){
					return aBuffer;
				}
			};

		return tmp;
	};

	window.WMChat = {
		fire: fire,
		thread: objBuffer(),
		room: objBuffer(),
		const: {
			LINK: {
				COLLABORATION: 4,
				'icewarp.collaboration': 4,
				RECORDING: 3,
				'icewarp.recording': 3,
				VIDEO: 2,
				'icewarp.video': 2,
				NOTE: 5,
				'icewarp.note': 5
			}
		}
	};

	//Copy public prototypes without __ prefix
	var api = new cApi();
	for(var i in api.__proto__)
		if (Object.prototype.hasOwnProperty.call(api.__proto__, i) && i.indexOf('__') != 0)
			window.WMChat[i] = api[i].bind(api);
})();