/**
 * @brief  : This class provides storage for GUI data and takes care about JS and CSS loading into page
 * @require: httprequest, browser_ext
 * @status : final
 * @date   : 6.3.2006 13:59:51
 **/
function cStorage(){
	this.aStorage = {css: {}, library: {}, language: {}, defaultLanguage: {}, template: {}, object: {}};

	this.aStorage.library = {
	//preloaded in startscript.js
	'client/inc/debug':'enabled','client/inc/object_ext':'enabled','client/inc/browser_ext':'enabled','client/inc/template':'enabled','client/inc/xmltools':'enabled',
	'client/inc/request':'enabled','client/inc/dataset':'enabled','client/inc/storage':'enabled','client/inc/gui':'enabled','client/inc/wm_generic':'enabled',
	'client/inc/wm_auth':'enabled','client/inc/wm_accounts':'enabled','client/inc/wm_folders':'enabled','client/inc/wm_items':'enabled','client/inc/wm_settings':'enabled','client/inc/wm_storage':'enabled','client/inc/init':'enabled',
	'client/inc/gw_others':'enabled','client/inc/json':'enabled',

	'client/inc/obj_initial_loader':'enabled','client/inc/obj_form_generic':'enabled','client/inc/obj_form_tab':'enabled','client/inc/obj_button':'enabled','client/inc/obj_connection':'enabled'
	};

	this.__styles = {};
	this._colors = {};
};

/**
 * @brief: Append CSS file into page or enabled previously appended one
 * @date: 6.3.2006 13:56:53
 */
cStorage.prototype.css = function(sName, bForce, callback) {
	var skin = GWOthers.getItem('LAYOUT_SETTINGS', 'skin');

	if (skin === 'biggerrtl') {
		skin = 'bigger';
	} else if (skin === 'banner') {
		skin = 'default';
	}

	this.aStorage.css[skin] = this.aStorage.css[skin] || {};
	if (!bForce && this.aStorage.css[skin].style) {
		return callback && callback();
	}

	var oldStyle = false;
	if (sName === 'style' && this.__styles.style && (this.__styles.style.getAttribute('href') !== ('client/skins/' + skin + '/css/' + sName + '.css'))) {
		oldStyle = this.__styles.style;
		delete this.__styles[sName];
	}

	if (!this.__styles[sName] && !this.__styles.style) {
		this.__styles[sName] = mkElement('link', {
			type: 'text/css',
			rel: 'stylesheet',
			id: 'css_' + sName,
			onload: callback
		});
		document.head.appendChild(this.__styles[sName]);
	}

	if (sName === 'style') {
		this.__styles[sName].addEventListener('load', function() {
			for (var i in this.__styles) {
				if (!~['style', 'font'].indexOf(i)) {
					this.__styles[i].parentNode.removeChild(this.__styles[i]);
					delete this.__styles[i];
				}
			};
			oldStyle && document.head.removeChild(oldStyle);
		}.bind(this));
	}

	if (this.__styles[sName]) {
		this.__styles[sName].setAttribute('href', 'client/skins/' + skin + '/css/' + sName + '.css');
	}
};

/**
 * @brief: Append library into page
 * (little odd behavior in Safari, "var" definitions aren't eval as public!)
 */
cStorage.prototype.library = function(sName, sPath) {
	var sFile;
	switch (sPath || ''){
		//client/inc
		case '':
			// JS preloader
			if (this.aStorage.library['client/inc/javascript'] == 'enabled') {
				return Promise.resolve();
			}
			sFile = 'client/inc/'+sName;
			break;

		//client/skins
		case 'skin':
			sFile = 'client/skins/default/inc/'+sName;
			break;

		//client/inc/<sPath>
		default:
			if (/^[\w//-]+$/gi.test(sPath))
				sFile = 'client/inc/'+ sPath +'/'+ sName;
			break;
	}

	//check cache
	if (this.aStorage.library[sFile] == 'enabled') {
		return Promise.resolve();
	}

	return new Promise((resolve, reject) => {
		document.head.appendChild(mkElement('script', {
			src: sFile + '.js',
			onload: () => {
				this.aStorage.library[sFile] = 'enabled';
				resolve();
			},
			onerror: () => {
				reject();
			}
		}));
	});
};

/**
 * Synchronous preload f selected objects in advance
 * (MUST be in synchro mode)
 **/
cStorage.prototype.preloadObj = async function(){
	//retrieve object from server
	var q = await request.get('client/objects/objects.xml');
	if (q){
		var aObjects = q.getArray();
		for(var i in aObjects.OBJECTS[0])
			await this.object(i.toLowerCase(),aObjects.OBJECTS[0][i][0]);
	}
};

/**
 * Asynchronous preload of selected templates
 **/
cStorage.prototype.preloadTpl = function(aResponseData,sName){
	if (aResponseData && sName){
		if (sName == 'templates'){
			if (aResponseData.Array && aResponseData.Array.TEMPLATE && aResponseData.Array.TEMPLATE[0])
				for(var i in aResponseData.Array.TEMPLATE[0])
					this.aStorage.template[i.toLowerCase()] = aResponseData.Array.TEMPLATE[0][i][0].VALUE || '';
		}
		else
			this.aStorage.template[sName] = aResponseData.Text || '';

		return;
	}
};

/**
 * @brief:  load and reconstruct language array from server
 * @return: language array
 */
cStorage.prototype.language = async function(sName) {

    sName = sName || 'en';

	//check cache
	if (typeof this.aStorage.language["_ACTIVE_LANG"] != 'undefined' && this.aStorage.language["_ACTIVE_LANG"] == sName)
		return sName;

	//retrieve language from server
    var lang, defaultLang;
	try{
		lang = (await request.get('client/languages/'+sName+'/data.xml')).getArray();
	}
	catch {
		lang = null;
	}

	// try to load default language
	if (sName != 'en')
		try {
			defaultLang = (await request.get('client/languages/en/data.xml')).getArray();
			if (!Is.Object(lang)) {
				sName = 'en';
				lang = defaultLang;
			}
		}
		catch {
			lang = null;
		}

	if (!Is.Object(lang)) {
		 console.error("cStorage.language() - bad language file syntax: " + sName);
	}

    this.aStorage.language = {'_ACTIVE_LANG':sName};

	//construct storage
	lang = (lang && lang.LANGUAGE) ? lang.LANGUAGE[0] : {};
	defaultLang = (defaultLang && defaultLang.LANGUAGE) ? defaultLang.LANGUAGE[0] : {};

    var i,j,v;
	for (i in lang){
		this.aStorage.language[i] = {};
		for (j in lang[i][0])
			if (j != 'VALUE'){
				if (lang[i][0][j].length>1)
					v = lang[i][0][j];
				else
					v = lang[i][0][j][0]['VALUE'];

				this.aStorage.language[i][j] = (Is.Defined(v)) ? v : '';
			}
	}

	if (sName === 'en') {
		this.aStorage.defaultLanguage = this.aStorage.language;
	} else {
		for (i in defaultLang){
			this.aStorage.defaultLanguage[i] = {};
			for (j in defaultLang[i][0])
				if (j != 'VALUE'){
					if (defaultLang[i][0][j].length>1)
						v = defaultLang[i][0][j];
					else
						v = defaultLang[i][0][j][0]['VALUE'];

					this.aStorage.defaultLanguage[i][j] = (Is.Defined(v)) ? v : '';
				}
		}
	}

	return sName;
};


/**
 * @brief :  load and template file from sever
 * @return: template as string
 * @date  : 4.7.2006 12:37:13
 */
cStorage.prototype.template = async function(sName,bASync) {
	//check cache
	if (typeof this.aStorage.template[sName]!='undefined')
		return this.aStorage.template[sName];


	var skin = GWOthers.getItem('LAYOUT_SETTINGS', 'skin'),
		q;

	if (skin === 'biggerrtl') {
		skin = 'bigger';
	} else if (skin === 'banner') {
		skin = 'default';
	}

	if (bASync){
		await request.get('client/skins/'+skin+'/templates/'+sName+(sName=='templates'?'.xml':'.tpl'), [this,'preloadTpl',[sName],(sName=='templates'?'Array':'Text')]);
		return true;
	}
	else
	if (sName == 'templates'){
		if ((q = await request.get('client/skins/'+skin+'/templates/templates.xml'))){
			this.preloadTpl({Array:q.getArray()},'templates');
			return true;
		}
	}
	else
	if ((q = await request.get('client/skins/'+skin+'/templates/'+sName+'.tpl')))
		return this.aStorage.template[sName] = q.getString();

	throw new Error("cStorage.template() - blank template file: " + skin+'/'+sName);
};

/**
 * @brief:  load  page descriptor from sever
 * @return: page as array
 */
cStorage.prototype.object = async function(sName, aObject) {
	//check cache
	if (typeof this.aStorage.object[sName]!='undefined')
		return this.aStorage.object[sName];

	try{
		//retrieve object from server
		if (!aObject)
			aObject = (await request.get('client/objects/'+sName+'.xml')).getArray();

		//check for <object> root and remove it
		if (aObject['OBJECT'])
			aObject = aObject['OBJECT'][0];
	}
	catch {
		throw "cStorage.object() - blank xml: " + sName;
	}

	var i;

	//load CSS
	if (aObject['CSS'])
		for(i in aObject['CSS'])
			this.css(aObject['CSS'][i]['VALUE']);

	//load JS
	if (aObject.BEFORE)
		for(i in aObject.BEFORE){
			await this.library(aObject.BEFORE[i].VALUE, (aObject.BEFORE[i].ATTRIBUTES || {}).PATH);
		}

	if (aObject.LIBRARY) {
		var async = [];
		for(i in aObject.LIBRARY) {
			var attrs = aObject.LIBRARY[i].ATTRIBUTES || {};
			if (attrs.ASYNC) {
				async.push(new Promise(async function(resolve) {
					await this.library(aObject.LIBRARY[i].VALUE, attrs.PATH);
					resolve();
				}.bind(this)));
				continue;
			}
			await this.library(aObject.LIBRARY[i].VALUE, attrs.PATH);
		}
		await Promise.all(async);
	}

	//save to cache
	return this.aStorage.object[sName] = aObject;
};

window.storage = new cStorage();

///////////////////////////
/*
function getLang(str,aSubstitute,nobr){

	if (typeof str != 'string' || !str) return '';

	var out = '',
		a = str.toUpperCase().split('::');

	try{
		if (typeof a[1] == 'undefined')
			out = storage.aStorage.language[a[0]];
		else
			out = storage.aStorage.language[a[0]][a[1]];

		if (typeof out == 'string'){
			if (aSubstitute && out.length){

				var i = 0;
				out = out.replace(/\%[sS0-9]/g, function(v){
					if (v.toLowerCase() == '%s'){
						return aSubstitute[i];
						i++;
					}
					else
						return aSubstitute[+(v.substr(1))];
				});

				// var parts = out.split('%s');
				// out = parts.shift();
				// for (var i in parts)
				// 	out += aSubstitute.shift() + parts[i];

			}

			return out;
		}
		else
		if (typeof out == 'object')
			return out;
	}
	catch(e){ console.log(this._name||false,e);}

	if (nobr == 2)
	    return '';
	else
	return (nobr?str:'{'+str+'}');
};
*/


window.getLang = function (){

	var regx = /%[sS0-9]/g;

	return function(str, aSubstitute, nobr, bDefaultLanguage) {

		if (typeof str != 'string' || !str) return '';

		var out = '',
			a = str.toUpperCase().split('::');

		try{
			if (typeof a[1] == 'undefined')
				out = bDefaultLanguage ? storage.aStorage.defaultLanguage[a[0]] : (storage.aStorage.language[a[0]] || storage.aStorage.defaultLanguage[a[0]]);
			else
				out = bDefaultLanguage ? storage.aStorage.defaultLanguage[a[0]][a[1]] : ((storage.aStorage.language[a[0]] || {})[a[1]] || (storage.aStorage.defaultLanguage[a[0]] || {})[a[1]]);

			if (a[2] !== void 0) {
				out = out.split(a[3] || ';').slice(0, Math.max(a[2], 1)).pop();
			}

			if (typeof out == 'string'){
				if (aSubstitute && out.length){

					var i = 0;
					out = out.replace(regx, function(v){
						if (v.toLowerCase() == '%s'){
							return aSubstitute[i++];
						}
						else
							return aSubstitute[+(v.substr(1))];
					});
				}

				return out;
			}
			else
			if (typeof out == 'object')
				return out;
		}
		catch(e){ console.log(this._name||false,e);}

		return nobr == 2?'':(nobr?str:'{'+str+'}');
	};
}();
