"use strict";

/* client/inc/browser_ext.js */var _me;window.browserEvent=function(event){if(('on'+event)in window||event.replace(/end|start|update$/,'')in document.body.style){return event;}
if(('onwebkit'+event)in window){return'webkit'+this.capitalize(event[0]).replace(/(end|start|update)$/,this.capitalize);}
return false;};window.clipboardNotifications={};window.toClipboard=function(v,notification_type='link'){if(v instanceof Object&&navigator.clipboard&&navigator.clipboard.write&&'ClipboardItem'in window){var clipboardItemData={};for(var i in v){if(v[i]instanceof Blob){clipboardItemData[i]=v[i];}else if(Is.String(v[i])&&v[i].length){if(i.indexOf('image/')===0){clipboardItemData[i]=async function(){return await fetch(v[i]).then(function(response){return response.blob();});};}else{clipboardItemData[i]=new Blob([v[i]],{type:i});}}}
console.log('toClipboard',clipboardItemData);return navigator.clipboard.write([new ClipboardItem(clipboardItemData)]).then(function(){if(clipboardNotifications[notification_type]){clipboardNotifications[notification_type].close();}
clipboardNotifications[notification_type]=gui.notifier._value({type:'success',args:{text_plain:getLang('notification::clipboard_'+notification_type)}});});}
for(var i in v){v=v[i];break;}
if(Is.String(v[i])&&v[i].length){var inp=mkElement('textarea',{value:v,style:'position: absolute; opacity:0; z-index: -1000;'});document.body.appendChild(inp);inp.select();if(document.queryCommandSupported('copy')&&document.queryCommandEnabled('copy')&&document.execCommand('copy')){gui.notifier._value({type:'success',args:{text_plain:getLang('notification::'+(notification_type||'clipboard_link'))}});setTimeout(function(){if(inp.parentNode)
inp.parentNode.removeChild(inp);},220);return true;}}
gui.notifier._value({type:'alert',args:{header:'',text:'ERROR::CLIPBOARD'}});return false;};window.AttachEvent=function(obj,eventname,handler){eventname=eventname.substr(2);if(eventname==="wheel"){obj.addEventListener(eventname,function(e){var evn={originalEvent:e,type:e.type,target:e.target,deltaX:0,deltaY:0};if(navigator.userAgent.indexOf('WebKit')!=-1){evn.deltaX=e.deltaX/40;evn.deltaY=e.deltaY/40;}else{evn.deltaX=e.deltaX;evn.deltaY=e.deltaY;}
handler(evn);},{passive:true});}else{obj.addEventListener(eventname,handler,false);}};window.unique_id=function(){return(Math.random()*1000000000000000000)+''+(new Date).getTime();};window.downloadItem=function(){function downloadItemOnloadCallback(){var	frm=this.contentDocument,body,error='';try{body=frm.documentElement;error=JSON.parse(body.innerText||body.xtContent).error;}
catch{}
if(error){switch(error){case'no_permission':return gui.notifier._value({type:'alert',args:{text:'ERROR::E_ACCESS',args:[error]}});default:gui.notifier._value({type:'alert',args:{text:'ALERTS::GENERAL_ERROR',args:[error]}});}}};return function(path,full,bForceNewWindow){if(!Is.String(path)){return;}
var win,src=full?path:sPrimaryAccountClient+'server/download.php?'+path;if(bForceNewWindow||(full&&location.protocol=='https:'&&path.toLowerCase().indexOf('http:')==0)){win=window.open(src,'downloadFile');if(win&&win.document){win.document.onload=function(){window.close();};return;}}
var id='ifrm_download_'+unique_id(),frm=mkElement('iframe',{id:id,src:src});frm.style.position='absolute';frm.style.zIndex='-10';frm.onload=downloadItemOnloadCallback;document.body.appendChild(frm);setTimeout(function(){try{if(frm&&frm.parentNode)
frm.parentNode.removeChild(frm);}
catch(e){console.log("downloadItem",src,e);window.Sentry&&Sentry.captureException(e);}},120000);return true;};}();window.getRemoteFileContent=function(src,callback,responseType){var xhr=new XMLHttpRequest();xhr.open('GET',src);if(responseType){xhr.responseType=responseType;}
xhr.onreadystatechange=function(){if(xhr.readyState===4){if(xhr.status===200||xhr.status==0){if(responseType==='blob'){callback(xhr.response);}else{callback(xhr.responseText);}}
else{callback(false);}}};xhr.send();};function cMaxZIndex(){};cMaxZIndex.prototype.zindex=[500];cMaxZIndex.prototype.get=function(b){var z=this.zindex[this.zindex.length-1]+1;if(!b)this.zindex.push(z);return z;};cMaxZIndex.prototype.remove=function(z){var pos=inArray(this.zindex,z);if(pos>-1)this.zindex.splice(pos,1);};window.maxZIndex=new cMaxZIndex();window.mkElement=function(tElm,eatt,doc,children){var elm=(doc||document).createElement(tElm);if(typeof eatt==='object'){for(var i in eatt){if(eatt[i]===void 0){continue;}
try{switch(i){case'contenteditable':case'for':elm.setAttribute(i,eatt[i]);break;case'text':elm.textContent=eatt[i];break;case'style':if(Is.Object(eatt[i])){for(var j in eatt[i])
elm.style[j]=eatt[i][j];break;}
case'href':if(!eatt[i])
break;default:if(i in elm)
elm[i]=eatt[i];else
elm.setAttribute(i,eatt[i]);}}catch{}}}
(Array.isArray(children)?children:[children]).forEach(function(child){child&&elm.appendChild(child);});return elm;};window.addcss=function(elm){if(!elm)return;var arg=[];for(var a=1;a<arguments.length;a++)
if(Is.String(arguments[a]))
arg=arg.concat(arguments[a].trim().split(' '));for(a=0;a<arg.length;a++)
if(arg[a])
elm.classList.add(arg[a]);};window.removecss=function(elm){if(!elm)return;if(arguments.length<2)
elm.className='';else{for(var a=1;a<arguments.length;a++)
if(Is.String(arguments[a]))
elm.classList.remove(arguments[a].indexOf(' ')>-1?arguments[a].trim():arguments[a]);}};window.togglecss=function(elm,sClass,toggle){if(toggle===void 0){toggle=!hascss(elm,sClass);}
if(toggle){addcss(elm,sClass);}else{removecss(elm,sClass);}};window.hascss=function(elm,sClass){return elm.classList.contains(sClass);};window.getSize=function(elm,bDontBubble){var r={x:0,y:0,h:elm.offsetHeight,w:elm.offsetWidth},doc=elm.ownerDocument;if(elm.getBoundingClientRect){var box=elm.getBoundingClientRect();r.x=box.left+Math.max(doc.documentElement.scrollLeft,doc.body.scrollLeft);r.y=box.top+Math.max(doc.documentElement.scrollTop,doc.body.scrollTop);}
else if(elm.nodeType===3){var range=doc.createRange();range.selectNode(elm);var rect=range.getBoundingClientRect();r.h=rect.height;r.w=rect.width;r.x=rect.left+Math.max(doc.documentElement.scrollLeft,doc.body.scrollLeft);r.y=rect.top+Math.max(doc.documentElement.scrollTop,doc.body.scrollTop);}
else{r.x=elm.offsetLeft;r.y=elm.offsetTop;while((elm=elm.offsetParent)){if(!elm||elm.tagName=='BODY')break;r.x+=elm.offsetLeft-elm.scrollLeft;r.y+=elm.offsetTop-elm.scrollTop;}}
if(!bDontBubble&&doc.defaultView!==window&&doc.defaultView.frameElement){var size=getSize(doc.defaultView.frameElement);r.x+=size.x;r.y+=size.y;}
return r;};window.Is=(function(){var reg={email:/^(?:[a-z0-9!#$%&'*+/=?^_`{|}~\-:]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~\-:]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])$/gi,url:/^http(s?):\/\/[a-z0-9]*/gi,filename:/^(?!\.)(?!com[0-9]$)(?!con$)(?!lpt[0-9]$)(?!nul$)(?!prn$)[^<>:/\\|?*""]*$/gm};return{Boolean:function(a){return typeof a=='boolean';},Array:function(a){return Is.Object(a)&&a.constructor==Array;},Empty:function(o){if(Is.Object(o))
if(Is.Array(o)){if(o.length)
return false;}
else
for(var i in o)
if(Is.Defined(o[i]))
return false;return true;},Element:function(a){return a instanceof HTMLElement||a instanceof(((a.ownerDocument||{})||{}).defaultView||window).HTMLElement;},Function:function(a){return typeof a=='function';},Number:function(a){return typeof a=='number'&&isFinite(a);},Object:function(a){return(a&&typeof a=='object')||Is.Function(a);},String:function(a){return typeof a=='string';},Email:function(a){reg.email.lastIndex=0;return Is.String(a)?!!a.match(reg.email)||(((reg.email.lastIndex=0)||true)&&!!punycode.toASCII(a).match(reg.email)):false;},URL:function(a){if(!Is.String(a))return false;return!!a.match(reg.url);},Filename:function(a){return(!Is.String(a)||!a.trim().length)?false:!!a.match(reg.filename);},Defined:function(x){return x!==void 0;},Child:function(elm,eParent,eStop){if(Is.String(eParent)){eParent=eParent.toUpperCase();try{do{if(elm.tagName==eParent)
return elm;if(eStop&&eStop==elm)
return false;}
while((elm=elm.parentNode));}
catch(r){console.log(this._name||false,r)}}
else
if(eParent)
if('contains'in document.body)
try{return eParent.parentNode&&eParent.contains(elm);}
catch(r){console.log(this._name||false,r)}
else
try{do{if(elm==eParent)
return true;if(eStop&&eStop==elm)
return false;}
while((elm=elm.parentNode));}
catch(r){console.log(this._name||false,r)}
return false;},InstanceOf:function(instance,of){if(instance instanceof window[of]){return true;}
for(var i=0;window.frames[i];i++){if(!Object.keys(window.frames[i]).length){continue;}
try{if(window.frames[i][of]&&instance instanceof window.frames[i][of]){return true;}}catch{}}}};})();String.prototype.entityify=function(){return this.replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/</g,"&lt;").replace(/>/g,"&gt;");};String.prototype.unentityify=function(){return this.replace(/&gt;/g,">").replace(/&lt;/g,"<").replace(/&quot;/g,"\"").replace(/&amp;/g,"&");};String.prototype.urlEncode=function(){return encodeURIComponent(this).replace(/!/g,'%21').replace(/'/g,'%27').replace(/\(/g,'%28').replace(/\)/g,'%29').replace(/\*/g,'%2A').replace(/%20/g,'+');};String.prototype.urlDecode=function(){return decodeURIComponent(this.replace(/%(?![\da-f]{2})/gi,function(){return'%25'}).replace(/\+/g,'%20'));};String.prototype.highlight_links=function(on){var str=this;if(this.indexOf('@')>0){on=on||'';var emailPattern=/(([a-z0-9'!#$%&+\-/=?^_`{|}~*]\.?)+@[a-z0-9]+([.\-_]?[a-z0-9])*\.[a-z]{2,})/gi;str=str.replace(emailPattern,"<a href=\"mailto:$1\""+(on?' '+on:'')+">$1</a>");}
var urlPattern=/(?:=?(['"])?)([A-Za-z]{3,5}:\/\/[^\s<>]+?)([.,]\s|[\s<>]|$)/g;str=str.replace(urlPattern,function(match,quote,uri,suffix){if(quote){return uri;}
var url='';try{url=new URL(uri);}catch{try{url=new URL(uri.substring(0,uri.length-1));}catch{}}
if(location.protocol==='https:'&&url&&url.protocol==='http:'){if(url.pathname.match(/\.\w{2,}$/)){url=location.origin+'/teamchatapi/http.download?token='+sPrimaryAccountTeamchatToken+'&url='+encodeURIComponent(uri.unentityify());}}
var opener='';if(ShortURL.matches(url.href)||url.href.match(/\/collaboration\/\?ticket=(.*?)&url=(.*?)(?:&|$)/g)){opener=' rel="opener"';}
return'<a href="'+url.toString()+'" target="_blank"'+opener+'>'+uri+'</a>'+suffix});return str;};String.prototype.highlight_links_array=function(bShort){var str=[],sPrefix='~░',sSuffix='░~',arr=[],elm=bShort?mkElement('A'):null;var stripPattern=/@\[\S+\]/gi,emailPattern=/([a-z0-9'!#$%&+\-/=?^_`{|}~*]\.?)+@[a-z0-9]+([.\-_]?[a-z0-9])*\.[a-z]{2,}/gi,urlPattern=/([A-Za-z-]{3,}:\/\/[^\s<>]+?)([.,]\s|[\s<>]|$)/g,splitStr='```';if(~this.indexOf(splitStr))
str=this.split(splitStr);else
str=[this];for(var i=0,j=str.length;i<j;i+=2){if(!str[i].match(urlPattern)&&str[i].indexOf('@')>0){str[i]=str[i].replace(stripPattern,function(){return sPrefix+(arr.push(arguments[0])-1)+sSuffix;});str[i]=str[i].replace(emailPattern,function(){return sPrefix+(arr.push('<a href="mailto:'+arguments[0]+'">'+arguments[0]+'</a>')-1)+sSuffix;});}
str[i]=str[i].replace(urlPattern,function(x,s){var uri=s;if(bShort&&s.length>48){elm.href=s;s=elm.protocol+'//'+elm.hostname;if(elm.pathname.length>24)
s+=elm.pathname.substr(0,24)+'...';else{s+=elm.pathname;if(elm.search)
s+='?...';}}
var url='';try{url=new URL(uri);}catch{try{url=new URL(uri.substring(0,uri.length-1));}catch{}}
if(location.protocol==='https:'&&url&&url.protocol==='http:'){if(url.pathname.match(/\.\w{2,}$/)){uri=location.origin+'/teamchatapi/http.download?token='+sPrimaryAccountTeamchatToken+'&url='+encodeURIComponent(uri.unentityify());}}
var opener='';if(ShortURL.matches(url.href)||url.href.match(/\/collaboration\/\?ticket=(.*?)&url=(.*?)(?:&|$)/g)){opener=' rel="opener"';}
return sPrefix+(arr.push('<a href="'+uri+'" target="_blank"'+opener+'>'+s.entityify()+'</a>')-1)+sSuffix+arguments[2];});}
return{string:str.join(splitStr),array:arr,replace:sPrefix+'(\\d+)'+sSuffix};};String.prototype.escapeXML=function(bAttr){var s=this.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");if(bAttr)s=s.replace(/'/g,"&apos;").replace(/"/g,"&quot;");return s;};String.prototype.unescapeXML=function(){return this.replace(/&gt;/gi,">").replace(/&lt;/gi,"<").replace(/&quot;/gi,'"').replace(/&apos;/gi,'"').replace(/&amp;/gi,'&');};String.prototype.escapeHTML=function(){var div=document.createElement('div');div.appendChild(document.createTextNode(this));return div.innerHTML;};String.prototype.unescapeHTML=function(){if(this.indexOf('&')<0)return this.toString();var div=document.createElement('div');div.innerHTML=this.toString();div=div.childNodes[0];var out=div.textContent;while(true){if((div=div.nextSibling)){if(div.nodeValue)
out+=div.nodeValue;}
else
break;}
div=null;return out;};String.prototype.removeTags=function(str){return this.replace(/<[!/]?([-a-zA-Z0-9]+)[^>^<]*>/gm,str||'').replace(/&nbsp;/g,' ');};String.prototype.quoteMeta=function(){return this.replace(/([!#$%^@.&*()\-_=+:;"'\\/?<>~[]{}`])/g,"\\$1");};window.parseJulianTime=function(iTime){var H=(iTime-iTime%3600)/3600,M=Math.ceil(iTime%3600/60);M=M<10?'0'+M:M;if(GWOthers.getItem('LAYOUT_SETTINGS','time_format')>0)
return(H%12||12)+':'+M+(H<12?" AM":" PM");else
return H+':'+M;};window.inArray=function(aArray,sElm){if(Is.Array(aArray))
return aArray.indexOf(sElm);else
for(var i in aArray)
if(aArray[i]==sElm)return i;return-1;};window.reverse=function(oObj){if(oObj.constructor==Array)
return oObj.reverse();var key=[],oOut={};for(var i in oObj)
key.push(i);key.reverse();for(i in key)
oOut[key[i]]=oObj[key[i]];return oOut;};window.arrConcat=function(){var main={};for(var a=0;a<arguments.length;a++)
for(var i in arguments[a])main[i]=arguments[a][i];return main;};window.mkArrayPath=function(keys,arr,val){if(typeof arr!='object')arr={};var out=arr;for(var i in keys){if(arguments.length>2&&keys.length-1==i)
arr[keys[i]]=val;else
if(typeof arr[keys[i]]!='object')
arr[keys[i]]={};arr=arr[keys[i]];}
return out;};window.arrayPath=function(aData,aDPath){for(var i in aDPath){aData=aData[aDPath[i]];if(typeof aData=='undefined')
return;}
return aData;};window.getFreeKey=function(arr){for(var i=0;;i++)
if(typeof arr[i]=='undefined')
return i;};window.arrUnique=function(arr){return arr.filter(function(v,i,a){return a.indexOf(v)===i;});};window.count=function(arr){if(Array.isArray(arr))
return arr.length;else
if(arr!=null&&typeof arr=='object')
return Object.keys(arr).length;return-1;};window.arrayCompare=function(arr1,arr2){var length=0;for(var key in arr1){if(arr1[key]!=arr2[key]){return false;}
length++;}
if(count(arr2)==length)
return true;else
return false;};window.buildURL=function(varList){var url=[];for(var name in varList)
url.push(encodeURIComponent(name)+(varList[name]!==void 0?'='+encodeURIComponent(varList[name].toString()):''));return url.join('&');};window.parseURL=function(url){var p,argList,newArg,output={};if(!Is.Defined(url))
url=self.location.search;if(typeof url==='object'){return url;}
if(typeof url=='string'){if((p=url.indexOf('#'))>-1)
url=url.substr(0,p);if((p=url.indexOf('?'))>-1&&(p<url.indexOf('=')))
url=url.substr(p+1);argList=url.split('&');for(var i=0;i<argList.length;i++)
if(argList[i]){newArg=argList[i].split('=');try{output[decodeURIComponent(newArg[0])]=newArg[1]?decodeURIComponent(newArg[1].toString()):'';}
catch{return{};}}}
return output;};window.parseFileSize=function(i){function ceilFloat(num,n){n=Math.pow(10,parseInt(n,10))||1;return Math.ceil(parseFloat(num)*n)/n;};if((i=parseInt(i,10))&&Is.Number(i)){i=ceilFloat(i/1024,1);if(i>=1024*1024)
return ceilFloat(i/1024/1024,1).toLocaleString(document.documentElement.lang)+' '+getLang('UNITS::GB');else if(i>=1024)
return ceilFloat(i/1024,1).toLocaleString(document.documentElement.lang)+' '+getLang('UNITS::MB');else
return i.toLocaleString(document.documentElement.lang)+' '+getLang('UNITS::KB');}
else{i=0;return i.toLocaleString(document.documentElement.lang)+' '+getLang('UNITS::KB');}};window.pushParameterToCallback=function(aResponse,arg){if(Is.Function(aResponse[0])){if(Is.Array(aResponse[1]))
aResponse[1].push(arg);else
aResponse[1]=[arg];}
else
if(Is.Object(aResponse[0])){if(Is.Array(aResponse[2]))
aResponse[2].push(arg);else
aResponse[2]=[arg];}
else
throw'pushParameterToCallback - Invalid argument';};window.getCallbackFunction=function(aResponse,bAlways){if(aResponse){if(Is.Function(aResponse[0]))
return aResponse[0];else
if(Is.Function(aResponse[1]))
return aResponse[1];else
if(bAlways||!aResponse[0]._destructed)
try{return aResponse[0][aResponse[1]];}
catch{}}
return false;};window.executeCallbackFunction=async function(aResponse){if(Is.Array(aResponse)&&((Is.Object(aResponse[0])&&(Is.String(aResponse[1])||Is.Function(aResponse[1])))||Is.Function(aResponse[0])))
try
{var nIndex;if(Is.Function(aResponse[0]))
nIndex=1;else
nIndex=2;var args=[];for(var i=1;i<arguments.length;i++)
args.push(arguments[i]);if(Is.Array(aResponse[nIndex]))
args=args.concat(aResponse[nIndex]);for(i=nIndex+1;i<aResponse.length;i++)
args.unshift(aResponse[i]);var bOut;if(nIndex==1)
bOut=await aResponse[0].apply(null,args);else
if(Is.Function(aResponse[1]))
bOut=await aResponse[1].apply(aResponse[0],args);else{bOut=await aResponse[0][aResponse[1]].apply(aResponse[0],args);}
return bOut;}
catch(e){var err='';if(Is.String(aResponse[0]))
err="Error while executing "+aResponse[0]+"()";else
err="Error while executing "+(aResponse[0]&&aResponse[0]._pathName?aResponse[0]._pathName:'oObject')+"."+aResponse[1]+"()";console.error('browser_ext:executeCallbackFunction',err,e);window.Sentry&&Sentry.captureException(e);}
else
return false;};window.createNameFromLocation=function(aLCTval){if(Is.Object(aLCTval)){var a=[];if(aLCTval.ITMFIRSTNAME)
a.push(aLCTval.ITMFIRSTNAME);if(aLCTval.ITMMIDDLENAME)
a.push(aLCTval.ITMMIDDLENAME);if(aLCTval.ITMSURNAME)
a.push(aLCTval.ITMSURNAME);if(aLCTval.ITMSUFFIX)
a.push(aLCTval.ITMSUFFIX);return(aLCTval.ITMTITLE?aLCTval.ITMTITLE+' ':'')+a.join(' ');}
return'';};window.parseNameToLocation=function(sName,aLCTval){sName=(sName||'').trim();if(Is.Object(aLCTval)){aLCTval.ITMCLASSIFYAS=sName;aLCTval.ITMTITLE='';aLCTval.ITMFIRSTNAME='';aLCTval.ITMMIDDLENAME='';aLCTval.ITMSURNAME='';aLCTval.ITMSUFFIX='';}
else
aLCTval={ITMCLASSIFYAS:sName};if(!sName.length)return aLCTval;var	tmp,p,aName=sName.split(' ');for(var i=aName.length-1;i>-1;i--)
if(!(aName[i]=aName[i].trim()))
aName.splice(i,1);if(aName.length){var aLang=getLang('NAME_PREFIX'),aPref={},aSuff={};for(i in aLang)
if(aLang[i])
aPref[aLang[i].toUpperCase()]=true;aLang=getLang('NAME_SUFFIX');for(i in aLang)
if(aLang[i])
aSuff[aLang[i].toUpperCase()]=true;while(Is.String(aName[0]))
if(aPref[aName[0].toUpperCase()])
aLCTval.ITMTITLE=(aLCTval.ITMTITLE||'')+aName.shift();else
if((p=aName[0].lastIndexOf('.'))>-1){if(p==aName[0].length-1)
aLCTval.ITMTITLE=(aLCTval.ITMTITLE||'')+aName.shift();else{tmp=aName[0].split('.');aName[0]=tmp.pop();aLCTval.ITMTITLE=(aLCTval.ITMTITLE||'')+tmp.join('.')+'.';}}
else
break;aLCTval.ITMFIRSTNAME=aName.shift();while(true){if((tmp=aName[aName.length-1])&&(tmp.toUpperCase()===tmp||(p=tmp.indexOf('.'))>-1||aSuff[tmp.toUpperCase()])){if(p>-1){tmp=tmp.split('.');if(tmp[0]&&tmp[1]){aLCTval.ITMSUFFIX=tmp[1];aName[aName.length-1]=tmp[0];}
else
aLCTval.ITMSUFFIX=aName.pop()+(aLCTval.ITMSUFFIX?' '+aLCTval.ITMSUFFIX:'');}
else
aLCTval.ITMSUFFIX=aName.pop()+(aLCTval.ITMSUFFIX?' '+aLCTval.ITMSUFFIX:'');}
else
break;}
if(aName.length>1&&aName[0].indexOf('.')<0)
aLCTval.ITMMIDDLENAME=aName.shift();if((tmp=aName.shift())){aLCTval.ITMSURNAME=tmp;if((tmp=aName.join(' ')))
aLCTval.ITMSUFFIX=tmp+(aLCTval.ITMSUFFIX?' '+aLCTval.ITMSUFFIX:'');}
else
if(aLCTval.ITMMIDDLENAME){aLCTval.ITMSURNAME=aLCTval.ITMMIDDLENAME;aLCTval.ITMMIDDLENAME='';}
else
if(aLCTval.ITMFIRSTNAME){aLCTval.ITMSURNAME=aLCTval.ITMFIRSTNAME;aLCTval.ITMFIRSTNAME='';}}
return aLCTval;};window.getPrimaryAccountFromAddress=function(bPrintable){var aAccInfo=dataSet.get('accounts',[sPrimaryAccount]);if(aAccInfo['FULLNAME'])
return MailAddress.createEmail(aAccInfo['FULLNAME'],sPrimaryAccount,bPrintable);else
return sPrimaryAccount;};window.getSubobjects=function(oObject,aObjects){aObjects=aObjects||{};for(var i in oObject)
if(i.charAt(0)!='_'&&i.substr(0,2)!='X_'&&i.substr(0,2)!='x_'&&oObject[i].constructor&&oObject[i].constructor===Gui)
if(oObject[i]._type=='obj_tabs'||oObject[i]._type=='obj_tab')
getSubobjects(oObject[i],aObjects);else
aObjects[i]=oObject[i];return aObjects;};window.getAuxiliarySubobjects=function(oObject,aObjects){aObjects=aObjects||{};for(var i in oObject)
if(i.charAt(0)!='_')
if(i.substr(0,2)=='X_'||i.substr(0,2)=='x_')
aObjects[i]=oObject[i];else
if(oObject[i]._type=='obj_tabs'||oObject[i]._type=='obj_tab')
getAuxiliarySubobjects(oObject[i],aObjects);return aObjects;};window.loadDataIntoForm=function(oObject,aValues){var aObjects=getSubobjects(oObject);for(var i in aObjects)
if(Object.prototype.hasOwnProperty.call(aObjects,i)&&Is.Defined(aValues[i])&&aObjects[i]._value)
aObjects[i]._value(aValues[i]);};window.loadDataIntoFormOnAccess=function(oObject,aValues,bIgnoreDomain){var aObjects=getSubobjects(oObject,aObjects);if(aValues['USERACCESS']||aValues['DOMAINADMINACCESS'])
var aAuxiliaryObjects=getAuxiliarySubobjects(oObject);for(var i in aObjects){if(aValues['ACCESS'][i]){switch(aValues['ACCESS'][i]){case'full':aObjects[i]._value(aValues['VALUES'][i]);break;case'view':aObjects[i]._value(aValues['VALUES'][i]);aObjects[i]._disabled(true);break;case'none':aObjects[i]._main.parentNode.style.display="none";}}
if(aValues['DOMAINADMINACCESS']&&!bIgnoreDomain){if(aAuxiliaryObjects['x_'+i+'_set']){aAuxiliaryObjects['x_'+i+'_set'].domadmin._value((aValues['DOMAINADMINACCESS'][i]=='view')?true:false);if(aValues['ACCESS'][i]=='view')
aAuxiliaryObjects['x_'+i+'_set'].domadmin._disabled(true);}}
if(aValues['USERACCESS']){if(aAuxiliaryObjects['x_'+i+'_set']){aAuxiliaryObjects['x_'+i+'_set'].user._value((aValues['USERACCESS'][i]=='view')?true:false);if(aValues['ACCESS'][i]=='view')
aAuxiliaryObjects['x_'+i+'_set'].user._disabled(true);}}}};window.storeDataFromFormWithAccess=function(oObject,aValues,aAccess){var aObjects=getSubobjects(oObject);var aAuxiliaryObjects=getAuxiliarySubobjects(oObject);var value;for(var i in aObjects){if(Is.Defined((value=aObjects[i]._value())))
aValues[i]=value;else
aValues[i]='';if(aAuxiliaryObjects['x_'+i+'_set']&&aAuxiliaryObjects['x_'+i+'_set'].domadmin){if(!aAccess['DOMAINADMINACCESS'])aAccess['DOMAINADMINACCESS']={};aAccess['DOMAINADMINACCESS'][i]=aAuxiliaryObjects['x_'+i+'_set'].domadmin._value()?'view':'full';}
if(aAuxiliaryObjects['x_'+i+'_set']){if(!aAccess['USERACCESS'])aAccess['USERACCESS']={};aAccess['USERACCESS'][i]=aAuxiliaryObjects['x_'+i+'_set'].user._value()?'view':'full';}}};window.storeDataFromForm=function(oObject,aValues){var aObjects=getSubobjects(oObject),value;for(var i in aObjects){if(Is.Function(aObjects[i]._value)){if(Is.Defined((value=aObjects[i]._value()))){aValues[i]=value;}else
aValues[i]='';}}};window.shiftObject=function(oObject){if(Is.Object(oObject)){for(var i in oObject){var result=oObject[i];delete oObject[i];return result;}
return null;}
else
return null;};window.isFormEmpty=function(aValues){for(var i in aValues){if(Is.Object(aValues[i])){if(!isFormEmpty(aValues[i]))return false;}
else
if(aValues[i]!='')return false;}
return true;};function cColors(){this.hexchars="0123456789ABCDEF";};cColors.prototype.fast_contrast=function(hexcolor,options){options=Object.assign({dark:'#333333',light:'#ffffff',threshold:50},options||{});var rgb=this.hex2rgb(hexcolor);var lightness=this.lightness(rgb[0],rgb[1],rgb[2]);return lightness>=options.threshold?options.dark:options.light;};cColors.prototype.lightness=function(Rint,Gint,Bint){var Rlin=(Rint/255)**2.218;var Glin=(Gint/255)**2.218;var Blin=(Bint/255)**2.218;var Ylum=Rlin*0.2126+Glin*0.7156+Blin*0.0722;return Ylum**0.43*100;}
cColors.prototype.hsl2rgb=function(h,s,l){var r,g,b;if(s==0){r=g=b=l;}else{var hue2rgb=function hue2rgb(p,q,t){if(t<0)t+=1;if(t>1)t-=1;if(t<1/6)return p+(q-p)*6*t;if(t<1/2)return q;if(t<2/3)return p+(q-p)*(2/3-t)*6;return p;};var q=l<0.5?l*(1+s):l+s-l*s;var p=2*l-q;r=hue2rgb(p,q,h+1/3);g=hue2rgb(p,q,h);b=hue2rgb(p,q,h-1/3);}
return[Math.round(r*255),Math.round(g*255),Math.round(b*255)];};cColors.prototype.rgb2hsl=function(r,g,b){r/=255,g/=255,b/=255;var max=Math.max(r,g,b),min=Math.min(r,g,b);var h,s,l=(max+min)/2;if(max==min){h=s=0;}else{var d=max-min;s=l>0.5?d/(2-max-min):d/(max+min);switch(max){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break;}
h/=6;}
return[h,s,l];};cColors.prototype.hex2rgb=function(str){str=str.replace('#','');return[(this.toDec(str.substr(0,1))*16)+this.toDec(str.substr(1,1)),(this.toDec(str.substr(2,1))*16)+this.toDec(str.substr(3,1)),(this.toDec(str.substr(4,1))*16)+this.toDec(str.substr(5,1))];};cColors.prototype.toDec=function(hexchar){return this.hexchars.indexOf(hexchar.toUpperCase());};cColors.prototype.rgb2hex=function(r,g,b){return'#'+this.toHex(r)+this.toHex(g)+this.toHex(b);};cColors.prototype.toHex=function(n){n=n||0;n=parseInt(n,10);if(isNaN(n))n=0;n=Math.round(Math.min(Math.max(0,n),255));return this.hexchars.charAt((n-n%16)/16)+this.hexchars.charAt(n%16);};window.colors=new cColors();window.getCurrentEventTime=function(){var now=new IcewarpDate();var julian=now.format(IcewarpDate.JULIAN);var time=now.format(IcewarpDate.JULIAN_TIME);time+=30-time%30;return{'EVNSTARTDATE':julian,'EVNSTARTTIME':time,'EVNENDDATE':julian,'EVNENDTIME':time+30};};window.MailAddress={createEmail:function(name,email,bNoQuotes){var out='';if(email.indexOf('[')===0&&email.indexOf(']')===email.length-1){name='';}
if(name){if(bNoQuotes)
out=name;else{name=name.replace(/(["\\])/g,'\\$1').trim();out=/[\s,;@<]/.test(name)?'"'+name+'"':name;}}
if(email){if(bNoQuotes){if(out)
out+=' ('+email.toLowerCase()+')';else
out=email.toLowerCase();}
else{if(out)out+=' ';out+='<'+email.toLowerCase()+'>';}}
return out;},appendEmail:function(sIn,email){if(email){if(!sIn)
return email;var aMail=MailAddress.splitEmailsAndNames(email),aTmp=MailAddress.splitEmailsAndNames(sIn);if((aMail=aMail[0])&&aMail.email){for(var i=aTmp.length-1;i>-1;i--)
if(aTmp[i].email==aMail.email)
return sIn;aTmp.push(aMail);var aOut;for(aOut=[],i=0;i<aTmp.length;i++){if(!aTmp[i].name&&aTmp[i].email.indexOf('[')===0&&aTmp[i].email.match(/^\[.+\]$/g))
aOut.push(aTmp[i].email);else
aOut.push(MailAddress.createEmail(aTmp[i].name,aTmp[i].email));}
return aOut.join(', ');}}
return sIn;},splitEmails:function(sIn){var aOut=[],sChar,sTemp='',f={block:false,block2:false,slash:false};if(Is.String(sIn)){for(var i=0;i<sIn.length;i++){sChar=sIn.charAt(i);switch(sChar){case',':case';':if(!f.block&&!f.block2&&!f.slash){if((sTemp=sTemp.trim()).length){aOut.push(sTemp);sTemp='';}
continue;}
break;case'"':if(!f.slash)
if(sTemp==''||f.block)
f.block=!f.block;break;case'[':if(!f.block&&!f.slash)
f.block2=true;break;case']':if(f.block2&&!f.slash)
f.block2=false;break;case'\\':if(!f.slash){f.slash=true;sTemp+=sChar;continue;}
case' ':if(sTemp=='')
continue;}
sTemp+=sChar;f.slash=false;}
if((sTemp=sTemp.trim()).length)
aOut.push(sTemp);}
return aOut;},splitEmailsAndNames:function(sIn){var aOut=[],aMails=MailAddress.splitEmails(sIn),aUniq={};for(var i=0;i<aMails.length;i++){if(aMails[i].charAt(aMails[i].length-1)=='>'||aMails[i].charAt(aMails[i].length-1)==')'){var sTemp='',sEmail,sChar,f={block:false,slash:false};for(var j=0,k=aMails[i].length;j<k;j++){sChar=aMails[i].charAt(j);switch(sChar){case'<':case'(':if(!f.block&&!f.slash&&Math.max(aMails[i].lastIndexOf('<'),aMails[i].lastIndexOf('('))===j){sTemp=sTemp.trim();sEmail=aMails[i].substring(j+1,k-1).trim();if(sEmail&&!aUniq[sEmail]){aUniq[sEmail]=true;aOut.push({name:sTemp,email:sEmail});}
if(!sEmail){aOut.push({name:sTemp,email:sEmail});}
j=k;continue;}
break;case'"':if(!f.slash){if(sTemp==''||f.block){f.block=!f.block;continue;}}
break;case'\\':if(!f.slash){f.slash=true;continue;}}
sTemp+=sChar;f.slash=false;}}
else
if(!aUniq[aMails[i]]){aUniq[aMails[i]]=true;aOut.push({name:'',email:aMails[i]});}}
for(var k in aOut){if(!~(aOut[k].email||'').indexOf('@')&&~(aOut[k].name||'').indexOf('@')){var name=aOut[k].name;aOut[k].name=aOut[k].email;aOut[k].email=name;}}
return aOut;},splitNames:function(sIn){var aMails=MailAddress.splitEmailsAndNames(sIn),aOut=[];for(var i=0;i<aMails.length;i++)
aOut.push(aMails[i].name||aMails[i].email);return aOut.join(', ');},findDistribList:function(aType)
{var aEmails,sEmail,sDistribList,aDistribList,sAccId,sFolId,aName,sName;var aResult={};var aDistrib={};for(var sType in aType)
{aResult[sType]='';if(!aType[sType])
continue;aEmails=MailAddress.splitEmails(aType[sType]);for(var n in aEmails)
{sEmail=aEmails[n];if(sEmail.charAt(0)=='['&&sEmail.charAt(sEmail.length-1)==']')
{sDistribList=sEmail.substr(1,sEmail.length-2);aDistribList=sDistribList.split('::');sAccId='';sFolId='';aName=[];switch(aDistribList.length<=3?aDistribList.length:3)
{case 3:sAccId=aDistribList.shift();case 2:sFolId=aDistribList.shift();case 1:for(var m in aDistribList)
aName.push(aDistribList[m]);sName=aName.join('::');}
if(!sAccId)
sAccId=sPrimaryAccount;if(!sFolId)
sFolId="__@@ADDRESSBOOK@@__";if(!aDistrib[sAccId])
aDistrib[sAccId]={};if(!aDistrib[sAccId][sFolId])
aDistrib[sAccId][sFolId]={'to':[],'cc':[],'bcc':[]};aDistrib[sAccId][sFolId][sType].push(sName);}
else
aResult[sType]+=sEmail+',';}
aResult[sType]=aResult[sType].substr(0,aResult[sType].length-1);}
aResult['distrib']=aDistrib;return aResult;}};window.Path={split:function(sFolderPath,bNamed,bIidIncluded){var aid=[];var fid='';var iid='';if(Is.String(sFolderPath)){var tmp=(sFolderPath||'').split('/');for(var i in tmp){aid.push(tmp[i]);if(~tmp[i].indexOf('@')){tmp=tmp.slice(+i+1);break;}}
if(bIidIncluded){iid=tmp.pop();}
fid=tmp.join('/');}
aid=aid.join('/');return bNamed?bIidIncluded?{aid:aid,fid:fid,iid:iid}:{aid:aid,fid:fid}:bIidIncluded?[aid,fid,iid]:[aid,fid];},basename:function(sPath){if(!Is.String(sPath))return false;return sPath.split('/').pop();},basedir:function(sPath){if(!Is.String(sPath))return'';var tmp=sPath.split('/');tmp.pop();return tmp.join('/');},extension:function(sFile){return sFile&&sFile.indexOf('.')!=-1?sFile.split('?')[0].split('.').pop().toLowerCase():'';},slash:function(sPath){return sPath?sPath.replace(/\\/g,'/'):'';},backslash:function(sPath){return sPath?sPath.replace(/\//g,'\\'):'';},build:function(aPath){return[aPath.aid||aPath[0],aPath.fid||aPath[1]].join('/');}};window.Mapping={getDefaultFolderForGWType:function(sType){var sName='';switch(sType){case'C':case'L':sName='contacts';break;case'E':sName='events';break;case'J':sName='journal';break;case'N':sName='notes';break;case'T':sName='tasks';break;case'F':sName='files';break;case'D':sName='dashboard';break;default:return false;}
return Path.split(GWOthers.getItem('DEFAULT_FOLDERS',sName))[1];},getFormNameByGWType:function(sType){switch(sType){case'C':return'frm_contact';case'E':return'frm_event2';case'N':return'frm_note';case'T':return'frm_task';case'J':return'frm_journal';case'L':return'frm_distrib';case'F':return'frm_file';default:throw new Error('Not implemented');}},isGlobalSearchFolder:function(sFolder){return sFolder.match(/__@@VIRTUAL@@__\/((@@SUBTREE@@)|(.*#))/)||sFolder==='__@@ARCHIVE@@__';}};window.makeIDFromIDS=function(ids,j){try{return[ids[0],ids[1],ids[2][j]];}
catch{}};window.makeIDSFromID=function(id){return[id[0],id[1],[id[2]]];};window.currentBrowser=function(){var out='',v='',str=navigator.userAgent.toUpperCase();if(str.indexOf('CHROME')>-1){out='Chrome';v=parseInt(str.substr(str.indexOf('CHROME/')+7).split('.')[0],10);}else if(str.indexOf('WEBKIT')>-1||str.indexOf('SAFARI')>-1){out='Safari';v=parseInt(str.substr(str.indexOf('SAFARI/')+7),10);}else if(str.indexOf('TRIDENT/')>-1){out='MSIE11';}else if(str.indexOf('GECKO')>-1){out='Mozilla';v=parseInt(str.substr(str.indexOf('GECKO/')+6),10);}
return function(bV){return bV?v:out;};}();window.calendarPalette={blue:'#0070EB',green:'#4FC980',brown:'#F48F51',purple:'#633CA3',yellow:'#F5C400',teal:'#008080',plum:'#dda0dd',red:'#EC3E53',aqua:'#8FDFFF',aquamarine:'#3DD8B4',orchid:'#7E5FF1',pink:'#ffc0cb',silver:'#9F9F9F',white:'#ffffff',gray:'#6B6B6B',lemon:'#ffff9f'};window.getCalendarColor=function(fid,sColor){var aColors=Cookie.get(['calendar_colors'])||{};if(!fid)
return aColors;sColor=calendarPalette[sColor]||sColor;if(sColor){var old=aColors[sColor]&&aColors[sColor]!=fid?aColors[sColor]:'';for(var i in aColors)
if((aColors[i]==fid)||(aColors[calendarPalette[i]]==fid)){aColors[i]='';Cookie.set(['calendar_colors',i]);break;}
aColors[sColor]=fid;Cookie.set(['calendar_colors',sColor],fid);if(old)
getCalendarColor(old);return sColor;}
for(sColor in aColors)
if(aColors[sColor]==fid)
return sColor;var aFolders=dataSet.get('folders',[sPrimaryAccount,'__@@VIRTUAL@@__/__@@EVENTS@@__','VIRTUAL','FOLDERS'])||{};var freeColor='#'+Math.floor(Math.random()*16777215).toString(16);for(sColor in calendarPalette){sColor=calendarPalette[sColor]||sColor;if(!aColors[sColor]||!Is.Defined(aFolders[aColors[sColor]])){freeColor=sColor;break;}}
aColors[freeColor]=fid;Cookie.set(['calendar_colors',freeColor],fid);return freeColor;};window.parseParamLine=function(sData){var col,aOut=[],arr;sData.split("\n").forEach(function(val,key){if(val&&(val=val.trim())){if(key==0){arr=val.toUpperCase().split('&');col=arr;}
else{arr=val.split('&');var tmp={};col.forEach(function(v,k){if(v&&Is.String(arr[k]))
tmp[v]=arr[k].urlDecode();});aOut.push({values:tmp});}}});return aOut;};window.CalendarFormatting={formats:{"0":'MM/DD/YY',"1":'MM/DD/YYYY',"5":'DD-MM-YY',"2":'DD-MM-YYYY',"6":'DD/MM/YY',"3":'DD/MM/YYYY',"4":'YYYY-MM-DD',"7":'DD.MM.YY',"8":'DD.MM.YYYY',"9":'DD MMM YY',"10":'DD MMM YYYY'},rtl_formats:false,rtl_langs:['ar','fa','ps','ur','he'],formatRtlTransform:function(){var key;this.rtl_formats={};for(key in this.formats){this.rtl_formats[key]=this.formats[key].split('').reverse().join('');}
return this.rtl_formats;},getFormats:function(){if(~this.rtl_langs.indexOf(document.documentElement.lang)){return this.rtl_formats?this.rtl_formats:this.formatRtlTransform();}
return this.formats;},getFormat:function(id){if(~this.rtl_langs.indexOf(GWOthers.getItem('LAYOUT_SETTINGS','language')||'en')){return this.rtl_formats?this.rtl_formats[id]:this.formatRtlTransform()[id];}
return this.formats[id];},simplified:function(date,override){return date.moment._isValid?date.calendar(null,Object.assign({sameDay:'LT',nextDay:'['+getLang('CALENDAR::TOMORROW')+'] LT',nextWeek:(date.getMoment().localeData().longDateFormat('L').replace(/[/\-.\s]?[ij]?Y+[/\-.\s]?/,'')+' LT'),lastDay:'['+getLang('CALENDAR::YESTERDAY')+'] LT',lastWeek:(date.getMoment().localeData().longDateFormat('L').replace(/[/\-.\s]?[ij]?Y+[/\-.\s]?/,'')+' LT'),sameElse:date.isSame(new IcewarpDate(),'year')?(date.getMoment().localeData().longDateFormat('L').replace(/[/\-.\s]?[ij]?Y+[/\-.\s]?/,'')+' LT'):'L LT'},override||{})):'';},normal:function(date,override){return date.moment._isValid?date.calendar(null,Object.assign({sameDay:'['+getLang('CALENDAR::TODAY')+']',nextDay:'['+getLang('CALENDAR::TOMORROW')+']',nextWeek:'L',lastDay:'['+getLang('CALENDAR::YESTERDAY')+']',lastWeek:'L',sameElse:'L'},override||{})):'';},normalWithTime:function(date,override){return date.moment._isValid?date.calendar(null,Object.assign({sameDay:'['+getLang('CALENDAR::TODAY')+'] LT',nextDay:'['+getLang('CALENDAR::TOMORROW')+'] LT',nextWeek:'L LT',lastDay:'['+getLang('CALENDAR::YESTERDAY')+'] LT',lastWeek:'L LT',sameElse:'L LT'},override||{})):'';},normalWithWeekDay:function(date,override){var today=new IcewarpDate().setTime(0);var diff=Math.abs(date.diff(today,'days'));var withWeekDay=diff<7?'['+this.weekdayToString(date.day(),date.week()<today.week())+']':'L';return this.normal(date,Object.assign({sameElse:withWeekDay,lastWeek:withWeekDay,nextWeek:withWeekDay},override||{}));},normalWithWeekDayAndTime:function(date,override){var today=new IcewarpDate().setTime(0);var diff=Math.abs(date.diff(today,'days'));var withWeekDay=diff<7?'['+this.weekdayToString(date.day(),date.week()<today.week())+'] LT':'L LT';return this.normalWithTime(date,Object.assign({sameElse:withWeekDay,lastWeek:withWeekDay,nextWeek:withWeekDay},override||{}));},formatStartDate:function(event){var formattedDate='';if(event.startdate>0){if(event.starttime>-1){formattedDate=IcewarpDate.julian(event.startdate,event.starttime).format('L LT');}else{formattedDate=IcewarpDate.julian(event.startdate).format('L');}}
return formattedDate;},weekdayToString:function(week_day,in_the_past){return'sunday,monday,tuesday,wednesday,thursday,friday,saturday'.split(',').map(function(day){return getLang('DAYS::'+(in_the_past?'LAST_':'')+day.toUpperCase());})[week_day];}};window.isIos=function(){return/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream};window.isoLanguageCode=function(sCode){return{cn:'zh',dk:'da',jp:'ja',no:'nb',kr:'ko',se:'sv',ua:'uk'}[sCode]||sCode;};window.getCssPath=function(sFilename,sSkin,sBase){var skin=sSkin||GWOthers.getItem('LAYOUT_SETTINGS','skin');var skin_colors=JSON.stringify(dataSet.get('main',['skin_colors']));return(sBase||'')+'client/skins/'+skin+'/css/css.php?'+buildURL({file:sFilename,skin:skin,skin_colors:skin_colors});};window.normalizeTimezone=function(timezone){var timezoneMapping={'UTC/GMT':'Etc/GMT','Africa/Accra':'Africa/Abidjan','Africa/Addis_Ababa':'Africa/Nairobi','Africa/Asmara':'Africa/Nairobi','Africa/Bamako':'Africa/Abidjan','Africa/Bangui':'Africa/Algiers','Africa/Banjul':'Africa/Abidjan','Africa/Blantyre':'Africa/Johannesburg','Africa/Brazzaville':'Africa/Algiers','Africa/Bujumbura':'Africa/Johannesburg','Africa/Conakry':'Africa/Abidjan','Africa/Dakar':'Africa/Abidjan','Africa/Dar_es_Salaam':'Africa/Nairobi','Africa/Djibouti':'Africa/Nairobi','Africa/Douala':'Africa/Algiers','Africa/Freetown':'Africa/Abidjan','Africa/Gaborone':'Africa/Johannesburg','Africa/Harare':'Africa/Johannesburg','Africa/Kampala':'Africa/Nairobi','Africa/Kigali':'Africa/Johannesburg','Africa/Kinshasa':'Africa/Algiers','Africa/Libreville':'Africa/Algiers','Africa/Lome':'Africa/Abidjan','Africa/Luanda':'Africa/Algiers','Africa/Lubumbashi':'Africa/Johannesburg','Africa/Lusaka':'Africa/Johannesburg','Africa/Malabo':'Africa/Algiers','Africa/Maseru':'Africa/Johannesburg','Africa/Mbabane':'Africa/Johannesburg','Africa/Mogadishu':'Africa/Nairobi','Africa/Niamey':'Africa/Algiers','Africa/Nouakchott':'Africa/Abidjan','Africa/Ouagadougou':'Africa/Abidjan','Africa/Porto-Novo':'Africa/Algiers','America/Anguilla':'America/Barbados','America/Antigua':'America/Barbados','America/Aruba':'America/Barbados','America/Atikokan':'America/Bogota','America/Blanc-Sablon':'America/Barbados','America/Cayman':'America/Bogota','America/Creston':'America/Dawson','America/Curacao':'America/Barbados','America/Dominica':'America/Barbados','America/Godthab':'America/Nuuk','America/Grenada':'America/Barbados','America/Guadeloupe':'America/Barbados','America/Kralendijk':'America/Barbados','America/Lower_Princes':'America/Barbados','America/Marigot':'America/Barbados','America/Montserrat':'America/Barbados','America/Nassau':'America/Bogota','America/Nipigon':'America/Chicago','America/Pangnirtung':'','America/Port_of_Spain':'America/Barbados','America/Rainy_River':'','America/St_Barthelemy':'America/Barbados','America/St_Kitts':'America/Barbados','America/St_Lucia':'America/Barbados','America/St_Thomas':'America/Barbados','America/St_Vincent':'America/Barbados','America/Thunder_Bay':'','America/Tortola':'America/Barbados','America/Yellowknife':'','Antarctica/DumontDUrville':'','Antarctica/McMurdo':'','Antarctica/Syowa':'','Antarctica/Vostok':'','Arctic/Longyearbyen':'','Asia/Aden':'Europe/Istanbul','Asia/Bahrain':'Europe/Istanbul','Asia/Brunei':'Asia/Hong_Kong','Asia/Istanbul':'Europe/Istanbul','Asia/Kuala_Lumpur':'Asia/Hong_Kong','Asia/Kuwait':'Europe/Istanbul','Asia/Muscat':'Asia/Baku','Asia/Phnom_Penh':'Asia/Bangkok','Asia/Rangoon':'Asia/Yangon','Asia/Vientiane':'Asia/Bangkok','Atlantic/Reykjavik':'','Atlantic/St_Helena':'','Australia/Currie':'Australia/Hobart','Europe/Amsterdam':'Europe/Andorra','Europe/Bratislava':'Europe/Andorra','Europe/Busingen':'Europe/Andorra','Europe/Copenhagen':'Europe/Andorra','Europe/Guernsey':'Europe/Dublin','Europe/Isle_of_Man':'Europe/Dublin','Europe/Jersey':'Europe/Dublin','Europe/Kiev':'Europe/Athens','Europe/Ljubljana':'Europe/Andorra','Europe/Luxembourg':'Europe/Andorra','Europe/Mariehamn':'Europe/Helsinki','Europe/Monaco':'Europe/Andorra','Europe/Nicosia':'Asia/Famagusta','Europe/Oslo':'Europe/Andorra','Europe/Podgorica':'Europe/Andorra','Europe/San_Marino':'Europe/Andorra','Europe/Sarajevo':'Europe/Andorra','Europe/Skopje':'Europe/Andorra','Europe/Stockholm':'Europe/Andorra','Europe/Uzhgorod':'Europe/Athens','Europe/Vaduz':'Europe/Andorra','Europe/Vatican':'Europe/Andorra','Europe/Zagreb':'Europe/Andorra','Europe/Zaporozhye':'Europe/Athens','Indian/Antananarivo':'','Indian/Cocos':'','Indian/Comoro':'','Indian/Christmas':'','Indian/Kerguelen':'Indian/Maldives','Indian/Mahe':'Indian/Mauritius','Indian/Mayotte':'','Indian/Reunion':'Indian/Mauritius','Pacific/Enderbury':'Pacific/Apia','Pacific/Funafuti':'Pacific/Fiji','Pacific/Chuuk':'Pacific/Guam','Pacific/Johnston':'Pacific/Honolulu','Pacific/Majuro':'Pacific/Fiji','Pacific/Midway':'Pacific/Niue','Pacific/Pohnpei':'','Pacific/Saipan':'Pacific/Guam','Pacific/Wake':'Pacific/Fiji','Pacific/Wallis':'Pacific/Fiji'};return timezoneMapping[timezone]||timezone;};async function replaceAsync(string,regexp,replacerFunction){const replacements=await Promise.all(Array.from(string.matchAll(regexp),match=>replacerFunction(...match)));let i=0;return string.replace(regexp,()=>replacements[i++]);}
function sanitizeFilename(input=''){var illegalRe=/[\/\?<>\\:\*\|"]/g;var controlRe=/[\x00-\x1f\x80-\x9f]/g;var reservedRe=/^\.+$/;var windowsReservedRe=/^(con|prn|aux|nul|com[0-9]|lpt[0-9])(\..*)?$/i;var windowsTrailingRe=/[\. ]+$/;function sanitize(input,replacement){if(typeof input!=='string'){throw new Error('Input must be string');}
var sanitized=input.replace(illegalRe,replacement).replace(controlRe,replacement).replace(reservedRe,replacement).replace(windowsReservedRe,replacement).replace(windowsTrailingRe,replacement).replace(new RegExp(replacement+'+','g'),replacement).replace(new RegExp('^'+replacement),'');sanitized=sanitized.split('.');var ext='';if(sanitized.length>1){ext='.'+sanitized.pop();}
sanitized=sanitized.join('.');return sanitized.substring(0,255-ext.length)+ext;}
return sanitize(input,'-');}
if(typeof Promise.withResolvers==='undefined'){window.Promise.withResolvers=function(){let resolve,reject;const promise=new Promise((res,rej)=>{resolve=res;reject=rej;});return{promise,resolve,reject};};}

/* client/inc/object_ext.js */function objConcat(obj1,obj2){for(var i in obj2){switch(typeof obj2[i]){case'object':break;case'function':break;default:obj1[i]=obj2[i];}}
for(i in obj2.prototype)
obj1.prototype[i]=obj2.prototype[i];return obj1;};Function.prototype.inherit=function(parent){var d=0,p=(this.prototype=new parent());this.prototype.__uber=function(name){var f,r,t=d,v=parent.prototype;if(t){while(t){v=v.constructor.prototype;t-=1;}
f=v[name];}
else{f=p[name];if(f==this[name]){f=v[name];}}
d+=1;r=f.apply(this,Array.prototype.slice.apply(arguments,[1]));d-=1;return r;};return this;};function inherits(main){for(var obj,j,i=1;i<arguments.length;i++){obj=arguments[i];for(j in obj){switch(typeof obj[j]){case'object':break;case'function':break;default:main[j]=obj[j];}}
for(j in obj.prototype)
main[j]=obj.prototype[j];}};function clone(obj,bDeep){if(typeof obj!='object'||obj===null||(typeof IcewarpDate!=='undefined'&&obj instanceof IcewarpDate))
return obj;var objectClone,i,j;try{objectClone=new obj.constructor();}
catch{objectClone={};}
if(objectClone.constructor===Array){for(i=0,j=obj.length;i<j;i++){if(bDeep&&typeof obj[i]==='object')
objectClone.push(clone(obj[i],true));else
if(typeof obj[i]!='undefined')
objectClone.push(obj[i]);}}
else
for(i in obj){if(Object.prototype.hasOwnProperty.call(obj,i)){if(bDeep&&typeof obj[i]=='object')
objectClone[i]=clone(obj[i],true);else
if(typeof obj[i]!='undefined')
objectClone[i]=obj[i];}}
return objectClone;};function compareObj(aold,anew,keepOld){var a1=aold!==void 0?(keepOld?clone(aold,true):aold):void 0,a2=anew;if(a1===a2){return true;}
if(typeof a1=='undefined')
return typeof a2=='undefined';if(typeof a2=='undefined'||(a1&&a2&&a1.constructor!==a2.constructor))
return false;if(typeof a1!='object')
return a1==a2;for(var i in a2)
if(!a1||!compareObj(a1[i],a2[i]))
return false;else
delete a1[i];for(i in a1)
return false;return true;};window.roundTo=function(number,precision){var factor=Math.pow(10,precision);return Math.round(number*factor)/factor;};

/* client/inc/debug.js */

/* client/inc/template.js */_me=cTemplate.prototype;function cTemplate(){this.strict=true;};_me.tmp=async function(sName,aData){return await this.exe(await storage.template(sName),aData);};_me.exe=async function(sTpl,aData){this.sBuffer='';if((this.sTpl=sTpl)){if(typeof aData=='object')
this.aData=arrConcat(storage.aStorage.language,aData);else
this.aData=storage.aStorage.language;await this.parser();return this.sBuffer;}};_me.variable=function(elm10,strict){var result=arrayPath(this.aData,elm10.split('::'));if(Is.Defined(result))
return result;else
if(strict)
return'{'+elm10+'}';else
return'';};_me.anchor=function(elm10){return(this.aData._ins||'')+'#'+elm10;};_me.parser=async function(){var i,part,elm10,elm11;for(;;){if((i=this.sTpl.indexOf('{'))<0)break;this.sBuffer+=this.sTpl.substring(0,i);this.sTpl=this.sTpl.substring(i);if((i=this.sTpl.indexOf('}'))==1){this.sTpl=this.sTpl.substring(2);continue;}
elm10=this.sTpl.substring(1,i);if((part=elm10.indexOf(" "))>-1){elm11=elm10.substring(part+1);elm10=elm10.substring(0,part);}
else
elm11=null;this.sTpl=this.sTpl.substring(i+1);switch(elm10){case'include':await this.include(elm11);break;case'noptional':this.option(elm11,1);break;case'optional':this.option(elm11);break;case'dynamic':this.loop(elm11);break;case'rdynamic':this.option(elm11,1);break;case'htmlspecialchars':this.sBuffer+=(this.variable(elm11,this.strict)).toString().escapeHTML();break;case'quote':this.sBuffer+=(this.variable(elm11,this.strict)).toString().escapeHTML().replace(/"/g,'&quot;');break;case'anchor':if(elm11)
this.sBuffer+=this.anchor(elm11);break;case'lang':elm10=this.variable(elm11);default:this.sBuffer+=this.variable(elm10,this.strict);}}
this.sBuffer+=this.sTpl;};_me.option=function(elm11,bInvert){var b=false,p=this.part((bInvert?'n':'')+'optional');if(elm11.indexOf(' ')>-1){var a=elm11.split(' ');for(var i in a)
if(this.variable(a[i])){b=true;break;}}
else
if(this.variable(elm11))
b=true;if((!b&&!bInvert)||(b&&bInvert))
this.sTpl=this.sTpl.substr(p);};_me.include=async function(elm11){var p=this.part('include');if(elm11){var s=this.sTpl.substr(0,p),o=new cTemplate(),a;try{if(s.length)
a=JSON.parse(s);}
catch{console.log('template.include','JSON error');}
this.sTpl=await o.tmp(elm11,a)+this.sTpl.substr(p);}
else{console.log('template.include','missing template');this.sTpl=this.sTpl.substr(p);}};_me.loop=function(elm11,bInvert){var p=this.part((bInvert?'r':'')+'dynamic');var v=this.variable(elm11);if(typeof v!='object'){this.sTpl=this.sTpl.substr(p);return;}
if(bInvert)v=reverse(v);var segment=this.sTpl.substr(0,p);var sBuffer='',temp='';var exp1=new RegExp('{'+elm11+'::\\*','g'),exp2=new RegExp('[ ]'+elm11+'::\\*','g'),exp3=new RegExp('::'+elm11+'::\\*','g');for(var val in v){temp=segment;if(temp.indexOf('{'+elm11+'::*')>-1)temp=temp.replace(exp1,'{'+elm11+'::'+val);if(temp.indexOf(' '+elm11+'::*')>-1)temp=temp.replace(exp2,' '+elm11+'::'+val);if(temp.indexOf('::'+elm11+'::*')>-1)temp=temp.replace(exp3,'::'+elm11+'::'+val);sBuffer+=temp;}
exp1=exp2=exp3=null;this.sTpl=sBuffer+this.sTpl.substr(p);};_me.part=function(part){var tag1='{'+part,tag2='{/'+part+'}',i,j,skip=0,start=0;for(;;){if((i=this.sTpl.indexOf(tag2,start))<0)return;j=this.sTpl.indexOf(tag1,start);if(j>-1&&j<i){skip++;start=this.sTpl.indexOf('}',j+1);continue;}
if(skip>0){skip--;start=i+tag2.length;continue;}
this.sTpl=this.sTpl.substr(0,i)+this.sTpl.substr(i+tag2.length);return i;}};window.template=new cTemplate();

/* client/inc/xmltools.js */function cXMLTools(){this.noparse={'http://www.w3.org/1999/xhtml':true};};cXMLTools.prototype.XMLDoc=function(){return document.implementation.createDocument("","",null);};cXMLTools.prototype.XML2Arr=function(xInput,bNasted){var aOutput={},iKey,i;for(i=0;;i++){if(i==0)
var xTag=xInput.firstChild;else
if(xTag.nextSibling)
xTag=xTag.nextSibling;else{if(!bNasted&&(!aOutput||(aOutput.PARSERERROR&&aOutput.PARSERERROR[0])))
throw"XML parsing error: "+aOutput.PARSERERROR[0].VALUE;return aOutput;}
if(!xTag.tagName){console.error('Missing tagName',xTag,xInput);continue;}
var sTagname=xTag.tagName.toUpperCase();if(aOutput[sTagname]){aOutput[sTagname].push({});iKey=aOutput[sTagname].length-1;}
else{iKey=0;aOutput[sTagname]=[{}];}
var ns=xTag.getAttribute('xmlns');if(ns&&this.noparse[ns]){var v=this.XML2Str(xTag);v=v.substring(v.indexOf('>')+1,v.lastIndexOf('<'));aOutput[sTagname][iKey]['VALUE']=v;}
else
if(xTag.hasChildNodes()){if(xTag.firstChild.nodeValue){var tmpTag=xTag.firstChild;aOutput[sTagname][iKey]['VALUE']=tmpTag.nodeValue;while(1){if((tmpTag=tmpTag.nextSibling)){if(tmpTag.nodeValue)
aOutput[sTagname][iKey]['VALUE']+=tmpTag.nodeValue;}
else{tmpTag=null;break;}}}
else
aOutput[sTagname][iKey]=this.XML2Arr(xTag,true);}
if(xTag.attributes.length){aOutput[sTagname][iKey]['ATTRIBUTES']={};for(i=0;i<xTag.attributes.length;i++)
aOutput[sTagname][iKey]['ATTRIBUTES'][xTag.attributes.item(i).nodeName.toUpperCase()]=xTag.attributes.item(i).nodeValue;}}};cXMLTools.prototype.Arr2XML=function(aIn,xElm,bPreserveCase){var aInput=(xElm?aIn:clone(aIn,true)),elm;if(!xElm){this.xDoc=null;this.xDoc=this.XMLDoc();}
for(var i in aInput){for(var ii in aInput[i]){if(aInput[i][ii]['ATTRIBUTES']&&(aInput[i][ii]['ATTRIBUTES'].XMLNS||aInput[i][ii]['ATTRIBUTES'].xmlns)&&this.xDoc.createElementNS){elm=this.xDoc.createElementNS(aInput[i][ii]['ATTRIBUTES'].XMLNS||aInput[i][ii]['ATTRIBUTES'].xmlns,(bPreserveCase)?i:i.toLowerCase());delete aInput[i][ii]['ATTRIBUTES'].XMLNS;delete aInput[i][ii]['ATTRIBUTES'].xmlns;}
else
if(xElm&&xElm.namespaceURI&&this.xDoc.createElementNS)
elm=this.xDoc.createElementNS(xElm.namespaceURI,(bPreserveCase)?i:i.toLowerCase());else
elm=this.xDoc.createElement((bPreserveCase)?i:i.toLowerCase());if(typeof aInput[i][ii]['ATTRIBUTES']=='object'&&aInput[i][ii]['ATTRIBUTES'].constructor!=Array){for(var ai in aInput[i][ii]['ATTRIBUTES'])
elm.setAttribute((bPreserveCase)?ai:ai.toLowerCase(),aInput[i][ii]['ATTRIBUTES'][ai]);delete aInput[i][ii]['ATTRIBUTES'];}
if(typeof aInput[i][ii]['VALUE']!='undefined'&&typeof aInput[i][ii]['VALUE']!='object'){elm.appendChild(this.xDoc.createTextNode(aInput[i][ii]['VALUE']));}
else
this.Arr2XML(aInput[i][ii],elm,bPreserveCase);if(!xElm){this.xDoc.appendChild(elm);return this.xDoc;}
else
xElm.appendChild(elm);}}};cXMLTools.prototype.Str2XML=function(sInput){var xParser=new DOMParser();var xOutput=xParser.parseFromString(sInput,'text/xml');this.stripWhiteSpace(xOutput);return xOutput;};cXMLTools.prototype.XML2Str=function(xInput){try{var sOut;if(xInput.xml)
sOut=xInput.xml;else
sOut=(new XMLSerializer()).serializeToString(xInput);return sOut;}
catch{return'';}};cXMLTools.prototype.Str2Arr=function(sInput){try{return this.XML2Arr(this.Str2XML(sInput));}
catch(e){console.warn('Str2Arr',e,sInput);return[];}};cXMLTools.prototype.Arr2Str=function(aInput,bPreserveCase){try{return this.XML2Str(this.Arr2XML(aInput,null,bPreserveCase));}
catch(e){console.log('Arr2Str',e);}};cXMLTools.prototype.stripWhiteSpace=function(node){var nodesToDelete=[];this.findWhiteSpace(node,0,nodesToDelete);for(var i=nodesToDelete.length;i--;){var nodeRef=nodesToDelete[i];nodeRef.parentNode.removeChild(nodeRef);}
return node;};cXMLTools.prototype.is_ws=function(nod){return!(/[^\t\n\r ]/.test(nod.data));};cXMLTools.prototype.findWhiteSpace=function(node,nodeNo,nodesToDelete){for(var i=node.childNodes.length;i--;){if(node.childNodes[i].splitText!==undefined&&this.is_ws(node.childNodes[i]))
nodesToDelete[nodesToDelete.length]=node.childNodes[i];if(node.childNodes[i].hasChildNodes())
this.findWhiteSpace(node.childNodes[i],i,nodesToDelete);}
node=node.parentNode;i=nodeNo;};var XMLTools=new cXMLTools();

/* client/inc/request.js */XMLHttpRequest.prototype.getString=function(){return(this.status&&this.status==200)?this.responseText:'';};XMLHttpRequest.prototype.getXML=function(){try{return XMLTools.stripWhiteSpace(this.responseXML);}
catch{throw"XMLHttpRequest.getXML \n"+this.getString();}};XMLHttpRequest.prototype.getArray=function(){try{var sType=this.getResponseHeader("Content-Type").split(';')[0];switch(sType){case'text/json':return JSON.parse(this.getString());case'text/xml':case'application/xml':return XMLTools.XML2Arr(this.getXML());case null:case'null':return{};default:throw'unsupported content-type "'+sType+'"';}}
catch(e){throw"XMLHttpRequest.getArray \n"+(typeof e=='string'?e+"\n":'')+this.getString();}};function cRequest(sURL){this.sURL=sURL;this.iRetry=10;};cRequest.prototype._send=async function(xData,sType,oResponse,oErrorResponse,sURL){sURL=sURL||this.sURL;var bASync=!!oResponse,me=this;if(!sURL)
throw"cRequest No Target URL";if(gui&&!gui.__online){if(bASync&&gui.connection){return new Promise((resolve)=>{gui._obeyEvent('online',[function(){me._send(xData,sType,oResponse,oErrorResponse,sURL).then(resolve);return false;}]);});gui.connection._queue(0,this.iRetry,[this,'_send',[xData,sType,oResponse,oErrorResponse,sURL]],oErrorResponse);}else{this.error({type:'response',text:'Offline',status:0,url:sURL});}
return false;}
var oXMLHttp=new XMLHttpRequest();return new Promise((resolve)=>{oXMLHttp.open(xData?'POST':'GET',sURL);if(xData)
oXMLHttp.setRequestHeader('Content-Type',sType||'text/xml');oXMLHttp.onabort=function(e){if(me.onfinish)
me.onfinish(this);if(!bASync){return resolve(false);}
try{if(e.target.status===0&&(!me.onreconnect||me.onreconnect(e)))
me._send(xData,sType,oResponse,oErrorResponse,sURL);}
catch{me.error({type:'system',text:'abort, unable to send'});}};oXMLHttp.onerror=async function(e){if(me.onfinish)
me.onfinish(this);if(!bASync){return resolve(false);}
try{if(e.target.status==0){if((oErrorResponse&&await executeCallbackFunction(oErrorResponse,this,[xData,sType,oResponse,oErrorResponse,sURL]))||(me.onerror&&me.onerror(this,[xData,sType,oResponse,oErrorResponse,sURL])))
return;if(gui&&gui.connection)
gui.connection._queue(0,me.iRetry,[me,'_send',[xData,sType,oResponse,oErrorResponse,sURL]],oErrorResponse);else
me.error({stype:'response',text:'Offline',status:0,url:sURL});}}
catch{me.error({type:'system',status:e.target.status,text:'error, can not add to the buffer'});}};oXMLHttp.onreadystatechange=async function(){if(this.readyState==4){if(this.status!=0&&me.onfinish)
me.onfinish(this);if((this.status==200||this.status==304)&&this.getResponseHeader("Content-Type")!=null){if(!bASync){return resolve(oXMLHttp);}
try{var oRData={};switch(oResponse[3]){case'XML':oRData={"XML":this.getXML()};break;case'Text':oRData={"Text":this.getString()};break;default:oRData={"Array":this.getArray()};}}
catch{throw"Response parse error: \n"+this.getString();}
executeCallbackFunction(oResponse,oRData);if(me.onsuccess)
me.onsuccess(oRData);}
else{if(!bASync){return resolve(false);}
switch(this.status){case 0:break;case 409:case 410:if(!oErrorResponse||!await executeCallbackFunction(oErrorResponse,this,[xData,sType,oResponse,oErrorResponse,sURL]))
if(me.onerror)
me.onerror(this,[xData,sType,oResponse,oErrorResponse,sURL]);break;case 404:case 500:if(gui.connection)
gui.connection._queue(this.status,0,null,oErrorResponse);else
me.error({stype:'response',text:'Server Error',status:this.status,url:sURL});return;default:var retry=me.iRetry;if((oErrorResponse&&await executeCallbackFunction(oErrorResponse,this,[xData,sType,oResponse,oErrorResponse,sURL]))||(me.onerror&&me.onerror(this,[xData,sType,oResponse,oErrorResponse,sURL])))
break;case 503:retry=parseInt(this.getResponseHeader('Retry-After'),10)||retry;if(gui.connection)
gui.connection._queue(this.status,retry,[me,'_send',[xData,sType,oResponse,oErrorResponse,sURL]],oErrorResponse);else
me.error({stype:'response',text:'Server Error',status:this.status,url:sURL});}}}};if(me.onstart)
me.onstart(oXMLHttp);oXMLHttp.send(xData||null);if(bASync){return resolve(oXMLHttp);}});};cRequest.prototype.error=function(arg){console.dir(arg);window.Sentry&&Sentry.withScope(function(scope){scope.setTag('module','main');Sentry.captureException(arg);});};cRequest.prototype.sendArray=async function(aData,oResponse,oErrorResponse,sURL,bPreserveCase){return await this._send(XMLTools.Arr2XML(aData,'',bPreserveCase),'text/xml',oResponse,oErrorResponse,sURL);};cRequest.prototype.sendJSON=async function(aData,oResponse,oErrorResponse,sURL){return await this._send(JSON.stringify(aData),'application/json',oResponse,oErrorResponse,sURL);};cRequest.prototype.sendString=async function(sData,oResponse,oErrorResponse,sURL){return await this._send(sData,'text/plain',oResponse,oErrorResponse,sURL);};cRequest.prototype.get=async function(sURL,oResponse,oErrorResponse){return await this._send(null,'',oResponse,oErrorResponse,sURL);};cRequest.timer=new Date();cRequest.lapse=0;cRequest.interval=setInterval(function(){cRequest.lapse=(new Date()-cRequest.timer)/1000;cRequest.timer=new Date();},10000);

/* client/inc/httprequest.js */

/* client/inc/dataset.js */function cDataSet(){this.aDataSets={};this.aListeners={};this.listeners={};};cDataSet.prototype.add=function(sDName,aDPath,Data,bNoUpdate,sUpdater){var bChange=false;if(!bNoUpdate&&!compareObj(this.get(sDName,aDPath),Data,true))
bChange=true;if(Is.Array(aDPath))
this.aDataSets[sDName]=mkArrayPath(aDPath,this.aDataSets[sDName],Data);else
this.aDataSets[sDName]=Data;if(bChange)
this.update(sDName,aDPath,sUpdater);else
if(!bNoUpdate)
return false;return true;};cDataSet.prototype.remove=function(sDName,aDPath,bNoUpdate,sUpdater){if(typeof this.aDataSets[sDName]=='undefined')
return;else
if(!aDPath)
delete this.aDataSets[sDName];else
if(Is.Array(aDPath))
try{if(typeof arrayPath(this.aDataSets[sDName],aDPath)=='undefined')
return;else{var obj=this.aDataSets;var key=sDName;aDPath.forEach(function(path){obj=obj[key];key=path;});delete obj[key];}}
catch{return false;}
if(!bNoUpdate)
this.update(sDName,aDPath,sUpdater);return true;};cDataSet.prototype.get=function(sDName,aDPath,bClone){if(!sDName)return;var aData=this.aDataSets[sDName];if(Is.Array(aDPath)){if(aData){aData=arrayPath(aData,aDPath);if(bClone&&aData)
return clone(aData,1);else
return aData;}
return;}
else
if(bClone)
return clone(aData,1);else
return aData;};cDataSet.prototype.obey=function(oListener,sObjMethod,sDName,bNoUpdate){if(typeof oListener!='object'||!sDName)
return false;oListener[sObjMethod||'_listener']=sDName;if(!this.aListeners[sDName])this.aListeners[sDName]=[];this.aListeners[sDName].push(oListener);if(typeof this.aDataSets[sDName]!='undefined'&&!bNoUpdate)
oListener.__update(sDName);return true;};cDataSet.prototype.disobey=function(oListener,sProperty){sProperty=sProperty||'_listener';if(typeof oListener!='object'||!oListener[sProperty]||!this.aListeners[oListener[sProperty]])return false;for(var i=this.aListeners[oListener[sProperty]].length;i--;){if(this.aListeners[oListener[sProperty]][i]===oListener)
this.aListeners[oListener[sProperty]].splice(i,1);}
return true;};cDataSet.prototype.update=function(sName,aDPath,sUpdater){this.trigger(sName,aDPath);if(!sName||!this.aListeners[sName])return;for(var i in this.aListeners[sName]){try{if(sUpdater){if(typeof sUpdater=='string'){if(this.aListeners[sName][i]._pathName==sUpdater)
continue;}
else
if(typeof sUpdater=='object'){if(this.aListeners[sName][i]._pathName==sUpdater._pathName)
continue;}}
this.aListeners[sName][i].__update(sName,aDPath);}
catch(e){console.log(this._name||false,e);}}};cDataSet.prototype.trigger=function(key,path){try{path=[].slice.apply(path||[]);var path_length=path.length;do{var full_path=[key].concat(path);this.listeners[full_path]&&this.listeners[full_path].forEach(function(listener){if(listener.all||path.length===path_length)
listener.fn.call(listener.context||this,this.get(key,path),key,path);},this);path.pop();}while(full_path.length>1);}
catch(e){console.log(this._name||false,e)}};cDataSet.prototype.on=function(key,path,fn,context,now,all){var full_path=[key].concat(path||[]);!this.listeners[full_path]&&(this.listeners[full_path]=[]);this.listeners[full_path].push({fn:fn,context:context,all:all});if(now)
fn.call(context||this,this.get(key,path),key,path);return this;};cDataSet.prototype.once=function(key,path,fn,context){var full_path=[key].concat(path||[]);!this.listeners[full_path]&&(this.listeners[full_path]=[]);var index=this.listeners[full_path].push({fn:function(){this.listeners[full_path].splice(index,1);fn.call(context||this);},context:this})-1;return this;};cDataSet.prototype.off=function(key,path,fn){var full_path=[key].concat(path||[]);if(this.listeners[full_path]&&this.listeners[full_path].length){for(var i=0;i<this.listeners[full_path].length;i++){if(this.listeners[full_path][i].fn===fn){this.listeners[full_path].splice(i,1);break;}}}
return this;};window.dataSet=new cDataSet();

/* client/inc/storage.js */function cStorage(){this.aStorage={css:{},library:{},language:{},defaultLanguage:{},template:{},object:{}};this.aStorage.library={'client/inc/debug':'enabled','client/inc/object_ext':'enabled','client/inc/browser_ext':'enabled','client/inc/template':'enabled','client/inc/xmltools':'enabled','client/inc/request':'enabled','client/inc/dataset':'enabled','client/inc/storage':'enabled','client/inc/gui':'enabled','client/inc/wm_generic':'enabled','client/inc/wm_auth':'enabled','client/inc/wm_accounts':'enabled','client/inc/wm_folders':'enabled','client/inc/wm_items':'enabled','client/inc/wm_settings':'enabled','client/inc/wm_storage':'enabled','client/inc/init':'enabled','client/inc/gw_others':'enabled','client/inc/json':'enabled','client/inc/obj_initial_loader':'enabled','client/inc/obj_form_generic':'enabled','client/inc/obj_form_tab':'enabled','client/inc/obj_button':'enabled','client/inc/obj_connection':'enabled'};this.__styles={};this._colors={};};cStorage.prototype.css=function(sName,bForce,callback){var skin=GWOthers.getItem('LAYOUT_SETTINGS','skin');if(skin==='biggerrtl'){skin='bigger';}else if(skin==='banner'){skin='default';}
this.aStorage.css[skin]=this.aStorage.css[skin]||{};if(!bForce&&this.aStorage.css[skin].style){return callback&&callback();}
var oldStyle=false;if(sName==='style'&&this.__styles.style&&(this.__styles.style.getAttribute('href')!==('client/skins/'+skin+'/css/'+sName+'.css'))){oldStyle=this.__styles.style;delete this.__styles[sName];}
if(!this.__styles[sName]&&!this.__styles.style){this.__styles[sName]=mkElement('link',{type:'text/css',rel:'stylesheet',id:'css_'+sName,onload:callback});document.head.appendChild(this.__styles[sName]);}
if(sName==='style'){this.__styles[sName].addEventListener('load',function(){for(var i in this.__styles){if(!~['style','font'].indexOf(i)){this.__styles[i].parentNode.removeChild(this.__styles[i]);delete this.__styles[i];}};oldStyle&&document.head.removeChild(oldStyle);}.bind(this));}
if(this.__styles[sName]){this.__styles[sName].setAttribute('href','client/skins/'+skin+'/css/'+sName+'.css');}};cStorage.prototype.library=function(sName,sPath){var sFile;switch(sPath||''){case'':if(this.aStorage.library['client/inc/javascript']=='enabled'){return Promise.resolve();}
sFile='client/inc/'+sName;break;case'skin':sFile='client/skins/default/inc/'+sName;break;default:if(/^[\w//-]+$/gi.test(sPath))
sFile='client/inc/'+sPath+'/'+sName;break;}
if(this.aStorage.library[sFile]=='enabled'){return Promise.resolve();}
return new Promise((resolve,reject)=>{document.head.appendChild(mkElement('script',{src:sFile+'.js',onload:()=>{this.aStorage.library[sFile]='enabled';resolve();},onerror:()=>{reject();}}));});};cStorage.prototype.preloadObj=async function(){var q=await request.get('client/objects/objects.xml');if(q){var aObjects=q.getArray();for(var i in aObjects.OBJECTS[0])
await this.object(i.toLowerCase(),aObjects.OBJECTS[0][i][0]);}};cStorage.prototype.preloadTpl=function(aResponseData,sName){if(aResponseData&&sName){if(sName=='templates'){if(aResponseData.Array&&aResponseData.Array.TEMPLATE&&aResponseData.Array.TEMPLATE[0])
for(var i in aResponseData.Array.TEMPLATE[0])
this.aStorage.template[i.toLowerCase()]=aResponseData.Array.TEMPLATE[0][i][0].VALUE||'';}
else
this.aStorage.template[sName]=aResponseData.Text||'';return;}};cStorage.prototype.language=async function(sName){sName=sName||'en';if(typeof this.aStorage.language["_ACTIVE_LANG"]!='undefined'&&this.aStorage.language["_ACTIVE_LANG"]==sName)
return sName;var lang,defaultLang;try{lang=(await request.get('client/languages/'+sName+'/data.xml')).getArray();}
catch{lang=null;}
if(sName!='en')
try{defaultLang=(await request.get('client/languages/en/data.xml')).getArray();if(!Is.Object(lang)){sName='en';lang=defaultLang;}}
catch{lang=null;}
if(!Is.Object(lang)){console.error("cStorage.language() - bad language file syntax: "+sName);}
this.aStorage.language={'_ACTIVE_LANG':sName};lang=(lang&&lang.LANGUAGE)?lang.LANGUAGE[0]:{};defaultLang=(defaultLang&&defaultLang.LANGUAGE)?defaultLang.LANGUAGE[0]:{};var i,j,v;for(i in lang){this.aStorage.language[i]={};for(j in lang[i][0])
if(j!='VALUE'){if(lang[i][0][j].length>1)
v=lang[i][0][j];else
v=lang[i][0][j][0]['VALUE'];this.aStorage.language[i][j]=(Is.Defined(v))?v:'';}}
if(sName==='en'){this.aStorage.defaultLanguage=this.aStorage.language;}else{for(i in defaultLang){this.aStorage.defaultLanguage[i]={};for(j in defaultLang[i][0])
if(j!='VALUE'){if(defaultLang[i][0][j].length>1)
v=defaultLang[i][0][j];else
v=defaultLang[i][0][j][0]['VALUE'];this.aStorage.defaultLanguage[i][j]=(Is.Defined(v))?v:'';}}}
return sName;};cStorage.prototype.template=async function(sName,bASync){if(typeof this.aStorage.template[sName]!='undefined')
return this.aStorage.template[sName];var skin=GWOthers.getItem('LAYOUT_SETTINGS','skin'),q;if(skin==='biggerrtl'){skin='bigger';}else if(skin==='banner'){skin='default';}
if(bASync){await request.get('client/skins/'+skin+'/templates/'+sName+(sName=='templates'?'.xml':'.tpl'),[this,'preloadTpl',[sName],(sName=='templates'?'Array':'Text')]);return true;}
else
if(sName=='templates'){if((q=await request.get('client/skins/'+skin+'/templates/templates.xml'))){this.preloadTpl({Array:q.getArray()},'templates');return true;}}
else
if((q=await request.get('client/skins/'+skin+'/templates/'+sName+'.tpl')))
return this.aStorage.template[sName]=q.getString();throw new Error("cStorage.template() - blank template file: "+skin+'/'+sName);};cStorage.prototype.object=async function(sName,aObject){if(typeof this.aStorage.object[sName]!='undefined')
return this.aStorage.object[sName];try{if(!aObject)
aObject=(await request.get('client/objects/'+sName+'.xml')).getArray();if(aObject['OBJECT'])
aObject=aObject['OBJECT'][0];}
catch{throw"cStorage.object() - blank xml: "+sName;}
var i;if(aObject['CSS'])
for(i in aObject['CSS'])
this.css(aObject['CSS'][i]['VALUE']);if(aObject.BEFORE)
for(i in aObject.BEFORE){await this.library(aObject.BEFORE[i].VALUE,(aObject.BEFORE[i].ATTRIBUTES||{}).PATH);}
if(aObject.LIBRARY){var async=[];for(i in aObject.LIBRARY){var attrs=aObject.LIBRARY[i].ATTRIBUTES||{};if(attrs.ASYNC){async.push(new Promise(async function(resolve){await this.library(aObject.LIBRARY[i].VALUE,attrs.PATH);resolve();}.bind(this)));continue;}
await this.library(aObject.LIBRARY[i].VALUE,attrs.PATH);}
await Promise.all(async);}
return this.aStorage.object[sName]=aObject;};window.storage=new cStorage();window.getLang=function(){var regx=/%[sS0-9]/g;return function(str,aSubstitute,nobr,bDefaultLanguage){if(typeof str!='string'||!str)return'';var out='',a=str.toUpperCase().split('::');try{if(typeof a[1]=='undefined')
out=bDefaultLanguage?storage.aStorage.defaultLanguage[a[0]]:(storage.aStorage.language[a[0]]||storage.aStorage.defaultLanguage[a[0]]);else
out=bDefaultLanguage?storage.aStorage.defaultLanguage[a[0]][a[1]]:((storage.aStorage.language[a[0]]||{})[a[1]]||(storage.aStorage.defaultLanguage[a[0]]||{})[a[1]]);if(a[2]!==void 0){out=out.split(a[3]||';').slice(0,Math.max(a[2],1)).pop();}
if(typeof out=='string'){if(aSubstitute&&out.length){var i=0;out=out.replace(regx,function(v){if(v.toLowerCase()=='%s'){return aSubstitute[i++];}
else
return aSubstitute[+(v.substr(1))];});}
return out;}
else
if(typeof out=='object')
return out;}
catch(e){console.log(this._name||false,e);}
return nobr==2?'':(nobr?str:'{'+str+'}');};}();

/* client/inc/gui.js */function Gui(sName,sType,oParent,aDocument){this._name=sName;this._type=sType||'document';this._parent=oParent;this._pathName=(this._parent&&this._parent._pathName)?this._parent._pathName+'.'+sName:sName;this._destructed=false;this._anchors={'main':''};this._template='';this._destructors={};this._events={};this._listener;this._listenerPath;this._saver=null;this._saverPath=null;this._skipsaving=false;this._noupdate=false;this._norefresh=false;this._updateBuffer=false;if(!sType&&!oParent)
Gui.__root.call(this,aDocument);Object.defineProperty(this,'_gui',{get:function(){var that=this;while(!that._main&&that._parent){that=that._parent;}
return(that._main&&that._main.parentNode)?(that._main.ownerDocument.defaultView||{}).gui||gui:gui;}});};Gui.prototype._create=async function(sName,sType,target,sClass){sClass=sClass||'';if(this._destructed||(this._main&&!this._main.parentNode))
return false;var sTarget='main',i,aObj=await storage.object(sType),sObj;if(aObj.PARENTS){var er=true;for(i in aObj.PARENTS[0].OBJ)
if(this._type==aObj.PARENTS[0].OBJ[i].VALUE){er=false;break;}
if(er)
throw new Error("await gui._create() -  OBJ "+sType+"\n disallowed parent "+this._type);}
if(aObj.UNIQUE){if(typeof this[sName]!='undefined'){if(aObj.UNIQUE[0].VALUE=='keep')
return this[sName];else
await this[sName]._destruct();}}
else{var sApx='';for(i=0;;i++){if(this[sName+sApx]===undefined){sName+=sApx;break;}
sApx="_"+i;}
sApx=null;}
if(Is.Defined(target)){if(Is.Object(target))
sTarget=target.target||'main';else
sTarget=target.toString()||'main';}
var newObj=this[sName]=new Gui(sName,sType,this);if(aObj.ANCHORS&&typeof(aObj.ANCHORS[0].ELM)!='undefined'){var sAnchor='',aAnchors={};for(i in aObj.ANCHORS[0].ELM){if((sAnchor=aObj.ANCHORS[0].ELM[i].VALUE))
aAnchors[sAnchor]=this._pathName+"."+sName+"#"+sAnchor;}
newObj._anchors=aAnchors;}
newObj._anchor=sTarget;var chld=false;switch(aObj.TYPE?aObj.TYPE[0].VALUE:''){case'none':break;case'inline':chld=mkElement('span');break;case'tr':chld=mkElement('tr');break;case'td':chld=mkElement('td');break;case'form':chld=mkElement('form');chld.onsubmit=function(){return false};chld.name=newObj._pathName;break;default:chld=mkElement('div');}
if(chld){var main;if(!(main=this._getAnchor(sTarget))){main=this._getAnchor('main');console.info('Anchor "'+sTarget+'" doesn\'t exists in "'+this._type+'" object. Creating in component main.')}
chld.setAttribute('id',newObj._pathName);if(Is.Object(target)){if(target.first){main.insertAdjacentElement('afterbegin',chld);}else if(target.position&&target.element){target.element.insertAdjacentElement(target.position,chld);}else{throw'Wrong target';}}else{main.appendChild(chld);}
newObj._css=sClass;newObj._allcss=chld.className=(aObj.ATTRIBUTES&&aObj.ATTRIBUTES.CSS?aObj.ATTRIBUTES.CSS+' ':'')+sType+(sClass?' '+sClass:'');newObj._main=chld;main=null;chld=null;}
var aArg=[].slice.call(arguments).splice(4);if(aObj.BEFORE){for(i in aObj.BEFORE){if(newObj&&newObj._destructed)return;if(aObj.BEFORE[i].ATTRIBUTES&&aObj.BEFORE[i].ATTRIBUTES.CLASS)
sObj=aObj.BEFORE[i].ATTRIBUTES.CLASS;else
sObj=aObj.BEFORE[i].VALUE;if(typeof window[sObj]=='function'){inherits(newObj,window[sObj]);if(window[sObj].prototype.__constructor&&await newObj.__constructor.apply(newObj,aArg)===false){await newObj._destruct();return;}}}}
if(aObj.TEMPLATE&&typeof aObj.TEMPLATE[0].VALUE!='undefined'){newObj._template=aObj.TEMPLATE[0].VALUE;if(Is.Defined(this._parent)&&Is.Defined(this._parent._aTemplateData))
await newObj._draw(null,null,this._parent._aTemplateData);else
if(Is.Defined(this._aTemplateData))
await newObj._draw(null,null,this._aTemplateData);else
await newObj._draw();}
if(aObj.ONUNLOAD)
for(i in aObj.ONUNLOAD)
newObj._add_destructor(aObj.ONUNLOAD[i].VALUE,aObj.ONUNLOAD[i].ATTRIBUTES);if(aObj.LIBRARY){var j;for(sObj='',i=0,j=aObj.LIBRARY.length;i<j;i++){if(newObj&&newObj._destructed)return;sObj=aObj.LIBRARY[i].VALUE;if(aObj.LIBRARY[i].ATTRIBUTES){if(aObj.LIBRARY[i].ATTRIBUTES.INCLUDE)
continue;if(aObj.LIBRARY[i].ATTRIBUTES.CLASS)
sObj=aObj.LIBRARY[i].ATTRIBUTES.CLASS;}
if(typeof window[sObj]=='function'){inherits(newObj,window[sObj]);if(window[sObj].prototype.__constructor)
await newObj.__constructor.apply(newObj,aArg);}}}
if(newObj&&newObj._finished)
newObj._finished();if(this.__onCreateChild)
this.__onCreateChild(sName,sType,sTarget,sClass);newObj&&newObj.__setAutoreopenArgs.call(newObj,{context:'gui',fun:['_create'],args:[].slice.call(arguments)});return newObj;};Gui.prototype._draw=async function(sTmpName,sTarget,aData,append){function rand(n){n=n||10000000000000000;return(Math.floor(Math.random()*n+1));};if(aData&&typeof aData==='object')
aData._ins=this._pathName;else
aData={_ins:this._pathName};if(GWOthers)
aData._skin='client/skins/'+GWOthers.getItem('LAYOUT_SETTINGS','skin');var sHtml=await(new cTemplate()).tmp((sTmpName?sTmpName:this._template),aData)||'';var id,obj=[],tmpObj=[],sAnchor;var xTpl=mkElement('div',{innerHTML:sHtml});if(sHtml.indexOf('<obj ')>-1){var aList=xTpl.getElementsByTagName("obj");if(aList.length){var ep,etmp,etmptag,sType,sName;function parseitem(etmp){var key,n=etmp.getElementsByTagName("item"),out1=[],out2={};if(!n.length){n=null;return etmp.textContent||(typeof etmp.text=='string'?etmp.text.unescapeHTML():null);}
for(var i=0,l=n.length;i<l;i++)
if((key=n[i].getAttribute('key')))
out2[key]=parseitem(n[i]);else
out1.push(parseitem(n[i]));n=null;return Is.Empty(out2)?out1:out2;};var prevObj=[];for(var i=0,l=aList.length;i<l;i++){ep=aList[i].parentNode;sType=aList[i].getAttribute('type');sName=aList[i].getAttribute('name');if(!sName||!sType)continue;if(ep.tagName==='OBJ')
sAnchor=aList[i].getAttribute('anchor')||'main';else{if((id=ep.getAttribute('id'))){sAnchor=inArray(this._anchors,id);if(sAnchor==-1){do{sAnchor=rand();}
while(this._anchors[sAnchor]);this._anchors[sAnchor]=id;}}
else{do{sAnchor=rand();}
while(this._anchors[sAnchor]);this._anchors[sAnchor]=(this._pathName||'')+"#"+sAnchor;ep.setAttribute('id',this._anchors[sAnchor]);}}
tmpObj={"type":sType,"name":sName,"anchor":sAnchor};for(var attrs=aList[i].attributes,iAl=attrs.length;iAl--;){if(tmpObj[attrs[iAl].name]===undefined)
tmpObj[attrs[iAl].name]=attrs[iAl].value;}
for(var nlen=aList[i].childNodes.length;nlen--;){etmp=aList[i].childNodes[nlen];if((etmptag=etmp.tagName?etmp.tagName.toLowerCase():false))
switch(etmptag){case'readonly':case'disabled':var tval=etmp.textContent;if(tval&&(tval!='false'||tval!='0'))
tmpObj[etmptag]=true;break;case'draw':tmpObj.draw=[etmp.getAttribute('form'),etmp.getAttribute('anchor')||'main',parseitem(etmp)];break;case'restrictions':case'init':case'fill':case'value':case'src':case'title':case'text':case'placeholder':tmpObj[etmptag]=parseitem(etmp);break;}}
etmp=null;if(ep.tagName.toLowerCase()=='obj'){for(var iLPos=aList.length;iLPos--;)
if(aList[iLPos]===ep)break;if(prevObj[iLPos].objects)
prevObj[iLPos].objects.push(tmpObj);else
prevObj[iLPos].objects=[tmpObj];}
else
obj.push(tmpObj);prevObj.push(tmpObj);tmpObj=null;}
prevObj=null;for(var j=aList.length;j--;)
aList[j].parentNode.removeChild(aList[j]);ep=null;}}
else
sAnchor=sTarget;[].forEach.call(xTpl.querySelectorAll('[title]'),function(el){gui.tooltip._add(el,el.getAttribute('title'),{y:function(){return getSize(this).y-28}.bind(el)});el.removeAttribute('title');});var eTarget=sTmpName&&sAnchor?this._getAnchor(sTarget):this._main;var result=xTpl.firstElementChild;if(eTarget){if(append===2){var tmp=eTarget.firstChild||null;while(xTpl.firstChild){eTarget.insertBefore(xTpl.firstChild,tmp);}}
else{if(!append){var children=this._getChildObjects();for(var child of children){if(eTarget.contains(child._main)){await child._destruct();}};while(eTarget.firstChild)
eTarget.removeChild(eTarget.firstChild);}
while(xTpl.firstChild){eTarget.appendChild(xTpl.firstChild);}}}
eTarget=null;xTpl=null;delete aData._ins;if(Is.Empty(aData))
await this.__addObjects(obj);else
await this.__addObjects(obj,null,aData);if(this.__onCreateChild)
this.__onCreateChild('','',sTarget);return result;};Gui.prototype.__addObjects=async function(obj,oParent,aData){var newObj,aInit,j;oParent=oParent||this;if(aData)
this._aTemplateData=aData;for(var i=0,l=obj.length;i<l;i++){aInit=[obj[i].name,obj[i].type,obj[i].anchor,obj[i].css];if(obj[i].init){if(typeof obj[i].init=='object'){for(j in obj[i].init)
aInit.push(obj[i].init[j]);}
else
aInit.push(obj[i].init);}
if(this._aTemplateData&&oParent)
oParent._aTemplateData=aData;newObj=await oParent._create.apply(oParent,aInit);if(obj[i].title&&Is.Function(newObj._title))
newObj._title(obj[i].title);if(obj[i].text&&Is.Function(newObj._text))
newObj._text(obj[i].text);if(obj[i].fill&&Is.Function(newObj._fill))
await newObj._fill(obj[i].fill);if(obj[i].value&&Is.Function(newObj._value))
newObj._value(obj[i].value);if(obj[i].src&&Is.Function(newObj._src))
newObj._src(obj[i].src);if(obj[i].readonly&&Is.Function(newObj._readonly))
newObj._readonly(obj[i].readonly);if(obj[i].disabled&&Is.Function(newObj._disabled))
newObj._disabled(obj[i].disabled);if(obj[i].placeholder&&Is.Function(newObj._placeholder))
newObj._placeholder(obj[i].placeholder);if(obj[i].tabindex&&Is.Function(newObj._tabIndex))
newObj._tabIndex(obj[i].tabcontainer,obj[i].tabindex=='true'?undefined:parseInt(obj[i].tabindex,10));if(obj[i].focus&&Is.Function(newObj._focus))
newObj._focus(obj[i].focus);if((obj[i].width||obj[i].height)&&Is.Function(newObj._size))
newObj._size(obj[i].width,obj[i].height);if((obj[i].restrictions)&&Is.Function(newObj._restrict)){var atmp=[];if(typeof obj[i].restrictions=='object'){for(j in obj[i].restrictions)
atmp.push(obj[i].restrictions[j],j);}
else
if(typeof obj[i].restrictions=='string')
atmp.push(obj[i].restrictions);try{if(atmp.length)
newObj._restrict.apply(newObj,atmp);}
catch{throw"invalid input array for restrictions in:\n"+oParent._pathName+'.'+obj[i].name;}}
if(obj[i].draw&&Is.Function(newObj._draw))
if(typeof newObj.__drawTpl!='undefined'&&!newObj._isActive&&obj[i].ondemand){newObj.__drawTpl=obj[i].draw;newObj.__drawData=aData;}
else{aData=arrConcat(aData,obj[i].draw[2]);await newObj._draw(obj[i].draw[0],obj[i].draw[1],aData);if(newObj._isActive&&newObj._active)newObj._active(true);}
if(obj[i].objects&&obj[i].objects.length)
if(typeof newObj.__drawObj!='undefined'&&!newObj._isActive&&obj[i].ondemand){newObj.__drawObj=obj[i].objects;newObj.__drawData=aData;}
else{await this.__addObjects(obj[i].objects,newObj,aData);if(newObj._isActive&&newObj._active)
newObj._active(true);}}};Gui.prototype._obeyEvent=function(sType,oEvn,info){if(this._events[sType])
this._disobeyEvent(sType,oEvn);else
this._events[sType]={};var id=unique_id();this._events[sType][id]=[oEvn,info];return id;};Gui.prototype._disobeyEvent=function(sType,oEvn){var obj=getCallbackFunction(oEvn,true);if(Is.Function(obj)){if(!this._events[sType])
return true;for(var i in this._events[sType]){if(this._events[sType][i]){var oEvn_old=this._events[sType][i][0];if((Is.Function(oEvn_old[0])&&Is.Function(oEvn[0])&&oEvn_old[0]===oEvn[0])||(Is.Function(oEvn_old[1])&&Is.Function(oEvn[1])&&oEvn_old[0]===oEvn[0]&&oEvn_old[1]===oEvn[1])||(oEvn_old[0]._pathName==oEvn[0]._pathName&&obj===getCallbackFunction(oEvn_old,true)))
{delete this._events[sType][i];return true;}}}}
return false;};Gui.prototype.__exeEvent=async function(sType,e,arg){if(this._events[sType])
for(var j in this._events[sType])
try{if(typeof this._events[sType][j]=='undefined'||!Is.Object(this._events[sType][j][0])||await executeCallbackFunction(this._events[sType][j][0],e,arg)===false)
delete this._events[sType][j];}
catch(r){gui._REQUEST_VARS.frm&&console.log('exeEvent',r);delete this._events[sType][j];}};Gui.prototype._getChildObjects=function(sAnchor,sType){var aOut=[];if(Is.Defined(sAnchor))
sAnchor=sAnchor.toString();for(var i in this)
if(i.indexOf('_')!=0&&this[i])
if((!sAnchor||this[i]._anchor==sAnchor)&&(!sType||this[i]._type==sType))
aOut.push(this[i]);return aOut;};Gui.prototype._clean=async function(sAnchor,sType){var aObj=this._getChildObjects(sAnchor,sType);for(var i in aObj)
await aObj[i]._destruct();return true;};Gui.prototype._getAnchor=function(sAnchor){var doc=(this._main||{}).ownerDocument||document;if(Is.Defined(sAnchor))
sAnchor=sAnchor.toString();if(this._anchors[sAnchor])
return doc.getElementById(this._anchors[sAnchor]);else
if(sAnchor=='main'||sAnchor=='self')
if(this._name==='gui'&&doc!==document){return doc.getElementById('gui');}else{return this._main;}
else
return doc.getElementById(this._pathName+(sAnchor?'#'+sAnchor:''));};Gui.prototype._listen=function(sDataSet,aDataPath,bNoUpdate){this._listener=sDataSet;if(typeof aDataPath=='object')this._listenerPath=aDataPath;dataSet.obey(this,'_listener',sDataSet,bNoUpdate);};Gui.prototype._save=function(sDataSet,aDataPath){this._saver=sDataSet;if(typeof aDataPath=='object')this._saverPath=aDataPath;dataSet.obey(this,'_saver',sDataSet);};Gui.prototype._saveme=function(noupd){if(this._skipsaving)return'';if(this._noupdate)noupd=this._noupdate;if(this._saver){dataSet.add(this._saver,this._saverPath,this._value(),noupd,this._pathName);return this._saver;}
else
if(this._listener){dataSet.add(this._listener,this._listenerPath,this._value(),noupd,this._pathName);return this._listener;}};Gui.prototype._add_destructor=function(sMethod,aProperties){if(!sMethod)return false;this._destructors[sMethod]=aProperties;};Gui.prototype._remove_destructor=function(sMethod){delete this._destructors[sMethod];};Gui.prototype._destruct=async function(){if(this._destructed)return;this._destructed=true;if(!this._parent[this._name])return false;for(var val in this._destructors)
if(Is.Function(this[val]))
await this[val].apply(this,Is.Array(this._destructors[val])?this._destructors[val]:arguments);this.__exeEvent('ondestruct',null,{"owner":this});for(var i in this){if(i.indexOf('_')==0||typeof this[i]!='object'||this[i]==null||typeof this[i]._destruct!='function')continue;await this[i]._destruct();delete this[i];}
if(this._listener)
dataSet.disobey(this);if(this._listener_data)
dataSet.disobey(this,'_listener_data');try{this._main&&this._main.parentNode&&this._main.parentNode.removeChild(this._main);}
catch(er){console.log(this._name||false,er)}
this._parent[this._name]=null;delete this._parent[this._name];if(this._parent.__onDestroyChild)
this._parent.__onDestroyChild(this._name,this._type,this._anchor);this.__exeEvent('destructed',null,this);};Gui.prototype.__setAutoreopenArgs=function(aAutoreopenArgs,bForce){if(this.__autoreopen&&(!this.__autoreopenArgs||bForce)){this.__autoreopenArgs=aAutoreopenArgs;gui.__exeEvent('autoreopenArgs_updated');}};Gui.__root=function(aDocument){var me=this;aDocument=aDocument||document;this._main=mkElement('div',{id:this._name,className:GWOthers.getItem('LAYOUT_SETTINGS','blurred_background')==1?'allow-blurred-background':'',style:{width:"100%",height:"100%",overflow:"hidden",position:"absolute",display:'flex','flex-direction':'column',backgroundPosition:'center'}});this._main.onscroll=function(e){this.scrollTop=0;this.scrollLeft=0;e.preventDefault();};aDocument.body.appendChild(this._main);this.__X=0;this.__Y=0;this.__UNIQ=unique_id();this.__BROWSER={touch:false,retina:function(){var mediaQuery="(-webkit-min-device-pixel-ratio: 1.5),\
					(min--moz-device-pixel-ratio: 1.5),\
					(-o-min-device-pixel-ratio: 3/2),\
					(min-resolution: 1.5dppx)";if(window.devicePixelRatio>1)
return true;if(window.matchMedia&&window.matchMedia(mediaQuery).matches)
return true;return false;}()};if(('ontouchstart'in window)||(navigator.maxTouchPoints>0)||(navigator.msMaxTouchPoints>0)){addcss(this._main,'touch');this.__BROWSER.touch=true;}
function evn(e,sForcedType){me.__exeEvent(sForcedType||e.type,e);};window.onresize=function(e){setTimeout(function(){evn(e);},5);};this.__focus=true;window.onfocus=function(e){me.__focus=true;evn(e);};window.onblur=function(e){me.__focus=false;evn(e);};this._isVisible=function(){if(this.__visibilityState){return true;}
for(var i in Gui.__detachedWindows){if(Gui.__detachedWindows[i].gui.__visibilityState){return true;}}}
this.__visibilityState=aDocument.visibilityState==='visible';aDocument.addEventListener('visibilitychange',function(e){me.__visibilityState=aDocument.visibilityState==='visible';if(gui.__lastVisibleDocument!==e.target){gui.__lastVisibleDocument=e.target;gui.__exeEvent('activeWindowChange',e.target.defaultView);}
evn(e);},false);window.addEventListener('pagehide',function(e){if(!e.persisted){if(!~document.cookie.indexOf('permanentLogin=')){auth.logout(true);if(navigator.sendBeacon){var sURL=GWOthers.getItem('LAYOUT_SETTINGS','logout_url')||(location.protocol+'//'+location.hostname+(location.port?':'+location.port:'')+location.pathname);if(window.TeamChatAPI&&TeamChatAPI.teamChatOnly()){sURL+='?'+buildURL({tconly:1,token:TeamChatAPI.getToken(),notifyuri:TeamChatAPI.getNotifyURI()});}
navigator.sendBeacon(sURL);}}
return;}
me.__visibilityState=false;evn(e,'visibilitychange');},false);this.__online=true;var offlineNotification;var offlineNotificationTimeout;aDocument.body.ononline=function(e){clearTimeout(offlineNotificationTimeout);me.__online=true;if(offlineNotification){gui.notifier._closeNotification(offlineNotification);offlineNotification=void 0;}
evn(e);};aDocument.body.onoffline=function(e){me.__online=false;clearTimeout(offlineNotificationTimeout);offlineNotificationTimeout=setTimeout(function(){offlineNotification=offlineNotification||gui.notifier._value({type:'offline',browserOnly:true});},10000);evn(e);};aDocument.onclick=function(e){if(!me.__focus)
me.__focus=true;evn(e);};aDocument.oncontextmenu=function(e){if(!me.__focus)
me.__focus=true;evn(e);};aDocument.onmousedown=evn;aDocument.onmouseup=function(e){if(!me.__focus)
me.__focus=true;evn(e);};AttachEvent(document,"onwheel",function(e){var delta;if(Is.Defined(e.deltaY))
delta=e.deltaY;else{if(e.originalEvent)
e=e.originalEvent;delta=Is.Defined(e.detail)?e.detail:e.wheelDelta/-120;}
evn({type:'wheel',delta:delta});});aDocument.onmousemove=function(e){me.__X=e.clientX;me.__Y=e.clientY;evn(e);};aDocument.onkeydown=function(e){evn(e);if(e.keyCode==116||e.keyCode==27){e.preventDefault();e.stopPropagation();}};aDocument.onkeyup=function(e){evn(e);if(e.keyCode==116||e.keyCode==27){e.preventDefault();e.stopPropagation();e.keyCode==116&&gui.frm_main._getNew&&gui.frm_main._getNew();}};aDocument.onpaste=function(e){evn(e);};this.__loading_stack=[];this._loading=function(xhr,b){var index;if(this.__loading_obj){if(b){this.__loading_stack.push(xhr);setTimeout(this._loading.bind(this,xhr),5000);}else if(~(index=this.__loading_stack.indexOf(xhr))){this.__loading_stack.splice(index,1);}
try{this.__loading_obj._loading(this.__loading_stack.length);}
catch(r){console.log(this._name||false,r)}}
else
this.__loading_stack=[];};window.addEventListener('beforeunload',function(){for(var i in Gui.__detachedWindows){var win=Gui.__detachedWindows[i];win&&!win.closed&&win.close();}});};Gui.__detachedWindows={};Gui.prototype._detach=function(wWindow){if(this._onbeforedetach){this._onbeforedetach(this.__detach.bind(this,wWindow));}else{this.__detach(wWindow);}};Gui.prototype.__detach=function(wWindow){this.__detachedId=unique_id();this.__detached=wWindow||window.open(this.__url||'',this.__detachedId);if(!this.__detached){return;}
var doc=this.__detached.document;focus();Gui.__detachedWindows[this.__detachedId]=this.__detached;var toLoad=0;[].forEach.call(document.head.children,function(child){var clone=child.cloneNode(true);if(clone.tagName==='LINK'&&clone.getAttribute('rel')==='stylesheet'){toLoad++;clone.addEventListener('load',function(){if(!--toLoad){var NM=NightMode(doc.defaultView);if(window.IW_NM&&IW_NM.init){NM.activate();}}});}else if(clone.tagName==='STYLE'){doc.head.appendChild(clone);}
doc.head.appendChild(clone);},this);var new_gui=new Gui('gui',void 0,void 0,doc);this.__detached.component=this;this.__detached.gui=new_gui;this.__detached.opener=this._gui;new_gui._main.appendChild(this._main);doc.body.appendChild(new_gui._main);doc.title=this._title();addcss(this._main,'detached');if(window.FormData){var frm_main=gui.frm_main;doc.addEventListener("dragover",function(e){if(frm_main.__filedrag){e.preventDefault();if(frm_main.__dragtimer==null)
frm_main.__file_dragover(e);else
clearTimeout(frm_main.__dragtimer);frm_main.__dragtimer=setTimeout(function(){frm_main.__dragtimer=null;frm_main.__file_dragover(false);},500);}},false);doc.addEventListener("drop",function(e){if(frm_main.__filedrag)e.preventDefault();},false);doc.addEventListener("dragstart",function(){frm_main.__filedrag=false;},true);doc.addEventListener("dragend",function(){frm_main.__filedrag=true;},true);}
this.__detached.onbeforeunload=function(e){switch(GWOthers.getItem('LAYOUT_SETTINGS','confirm_exit').toString()){case'1':if(this._type!=='frm_compose')
break;case'2':e.preventDefault();e.returnValue=getLang('CONFIRMATION::UNLOAD');return getLang('CONFIRMATION::UNLOAD');}}.bind(this);this.__detached.onunload=function(){this.__detached.onbeforeunload=false;this.__detached.opener._disobeyEvent('resize',[this,'__checkPosition']);new_gui._disobeyEvent('resize',[this,'__checkPosition']);this._destruct();for(var i in Gui.__detachedWindows){if(Gui.__detachedWindows[i].component===this){delete Gui.__detachedWindows[i];}}}.bind(this);this.__detached.focus();gui.__exeEvent('ondetach',new_gui);gui.__exeEvent('activeWindowChange',doc.defaultView);this._add_destructor('__closeWindowOnDestruct');new_gui._obeyEvent('resize',[this,'__checkPosition']);addEventListener('NightMode',function(event){if(!this.__detached||this.__detached.closed){return;}
var NM=NightMode(doc.defaultView);if(event.detail.enabled){NM.activate();}else{NM.reset();}}.bind(this));};Gui.prototype.__closeWindowOnDestruct=function(){this.__detached&&!this.__detached.closed&&this.__detached.close();};Gui.prototype._setTheme=async function(sColor,sImagePath,bCrossOrigin){await storage.library('extract-colors','extract-colors');if(GWOthers.getItem('LAYOUT_SETTINGS','daily_wallpaper')=='1'){var response=await fetch(atob('aHR0cHM6Ly9yYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tL25pdW1vby9iaW5nLXdhbGxwYXBlci9tYWluL2Jpbmctd2FsbHBhcGVyLm1k')).then((response)=>{if(response.ok){return response.text();}});sImagePath=((response||'').match(new RegExp((new Date()).toISOString().split('T')[0]+' \\| \\[.*?\\]\\((.*?)\\)'))||[])[1]||sImagePath;this.__dailyBackgroundCheck=setTimeout(function(){gui._setTheme();},3600000);}else{clearTimeout(this.__dailyBackgroundCheck);}
var eThemeStyle=document.getElementById('iw-theme-background')||mkElement('style',{id:'iw-theme-background'});var sTheme=':root {';if(sColor){sTheme+='--backgroundColor: '+sColor+';';}
if(sImagePath){sTheme+='--backgroundImageURL: url('+sImagePath+');';}
sTheme+='}';eThemeStyle.textContent=sTheme;document.head.appendChild(eThemeStyle);var login_interface_color=GWOthers.getItem('LAYOUT_SETTINGS','login_interface_color');if(sImagePath){extractColors.extractColorsFromSrc(sImagePath,{crossOrigin:bCrossOrigin?'anonymous':false}).then(function(swatches){var mostPopulous=swatches[0];for(var i in swatches){if(swatches[i].area*swatches[i].intensity*swatches[i].saturation*swatches[i].lightness>mostPopulous.area*mostPopulous.intensity*mostPopulous.saturation*mostPopulous.lightness){mostPopulous=swatches[i];}}
var rgb=[mostPopulous.red,mostPopulous.green,mostPopulous.blue];var hsl=colors.rgb2hsl.apply(colors,rgb);this.__backgroundColor=colors.rgb2hex.apply(colors,colors.hsl2rgb(hsl[0],hsl[1],0.45));if(login_interface_color==='background'){this._setInterfaceColors(this.__backgroundColor);}else{this._setInterfaceColors(login_interface_color);}}.bind(this)).catch(function(){this.__backgroundColor=sColor||'#702EB7';if(login_interface_color==='background'){this._setInterfaceColors(this.__backgroundColor);}else{this._setInterfaceColors(login_interface_color);}}.bind(this));if(login_interface_color!=='background'){this._setInterfaceColors(login_interface_color,!Gui.__skin_colors.bg_custom);}}else{var hsl=colors.rgb2hsl.apply(colors,colors.hex2rgb(sColor));this.__backgroundColor=colors.rgb2hex.apply(colors,colors.hsl2rgb(hsl[0],hsl[1],0.45));if(login_interface_color==='background'){this._setInterfaceColors(this.__backgroundColor);}else{this._setInterfaceColors(login_interface_color);}}};Gui.__skin_colors={bg_green:"#4FC980",bg_important:'#d51414',bg_important_darker:'#A44A3E'};Gui.prototype._setInterfaceColors=function(hex,bCustom){var rgb=colors.hex2rgb(hex);var hsl=colors.rgb2hsl.apply(colors,rgb);rgb=colors.hsl2rgb(hsl[0],hsl[1],0.45);hex=colors.rgb2hex(rgb[0],rgb[1],rgb[2]);rgb=colors.hsl2rgb(hsl[0],hsl[1],0.3);var hex_dark=colors.rgb2hex(rgb[0],rgb[1],rgb[2]);rgb=colors.hsl2rgb(hsl[0],hsl[1],0.95);var hex_light=colors.rgb2hex(rgb[0],rgb[1],rgb[2]);Object.assign(Gui.__skin_colors,{bg_main:hex,bg_main_darker:hex_dark,bg_main_lighter:hex_light,bg_ok_button:hex,bg_ok_button_darker:hex_dark});if(bCustom){Gui.__skin_colors.bg_custom=hex;}
dataSet.add('main',['skin_colors'],Gui.__skin_colors);dataSet.add('storage',['LAYOUT_SETTINGS','ITEMS',0,'VALUES','CUSTOM_SKIN_COLORS'],{ATTRIBUTES:{DONT_SEND:true}});GWOthers.setItem('LAYOUT_SETTINGS','custom_skin_colors',JSON.stringify(Gui.__skin_colors));var style=':root{';for(var i in Gui.__skin_colors){style+='--'+i+':'+Gui.__skin_colors[i]+';';}
if(this.__backgroundColor){style+='--bg_color:'+this.__backgroundColor+';';}
style+='}';if(!document.getElementById('iw-skin-colors')){document.head.appendChild(mkElement('style',{id:'iw-skin-colors'}));}
document.getElementById('iw-skin-colors').textContent=style;if(dataSet.get('main',['night_mode_enabled'])){NightMode().activate(false,true);}};

/* client/inc/wm_generic.js */function wm_generic(){this.xmlns;this.error;}
_me=wm_generic.prototype;_me.create_iq=async function(aData,oResponse,oResponse2,sType,sId,sNs,bJSON,bNoSession){var iq=this.__create_iq(aData,sType,sId,sNs,bJSON,bNoSession);if(oResponse){return await request.sendArray(iq,[this,'response_check',[oResponse]],oResponse2);}
else{var q=await request.sendArray(iq);if(q){var aOut=q.getArray();if(aOut['IQ'][0]['ATTRIBUTES']['TYPE']=="error"){var aErr=aOut['IQ'][0]['ERROR'][0];this.error={};this.error["text"]=aErr['VALUE'];if(aErr['ATTRIBUTES']&&aErr['ATTRIBUTES']['UID']){this.error["id"]=aErr['ATTRIBUTES']['UID'];this.error["lang"]=getLang("ERR_"+aErr['ATTRIBUTES']['ID']);}}
return aOut;}}};_me.__create_iq=function(aData,sType,sId,sNs,bJSON,bNoSession){delete this.error;var xmlns={"auth":1,"tools":1,"accounts":1,"folders":1,"items":1,"freebusy":1,"spellchecker":1,"public":1,"private":1,"domain":1,"message":1,"import":1,"export":1,"upload":1};sNs=sNs||this.xmlns;if(!xmlns[sNs]){throw new Error('create_iq: unsupported xmlns "'+sNs+'"');}
sNs='webmail:iq:'+sNs;var iq={"IQ":[{"ATTRIBUTES":{},"QUERY":[{"ATTRIBUTES":{}}]}]};var sSID=bNoSession?'':dataSet.get('main',['sid']);if(sSID)
iq['IQ'][0]['ATTRIBUTES']['SID']=sSID;if(sId)
iq['IQ'][0]['ATTRIBUTES']['UID']=sId;iq['IQ'][0]['ATTRIBUTES']['TYPE']=sType||'get';iq['IQ'][0]['QUERY'][0]['ATTRIBUTES']['XMLNS']=sNs;if(!gui._REQUEST_VARS.xml&&(sType!='set'||bJSON))
iq['IQ'][0]['ATTRIBUTES']['FORMAT']='json';if(aData&&typeof aData=='object')
iq['IQ'][0]['QUERY'][0]=arrConcat(iq['IQ'][0]['QUERY'][0],aData);return iq;};_me.sendBeacon=function(aData,sType,sId,sNs,bJSON,bNoSession){if(!navigator.sendBeacon){return;}
var iq=XMLTools.Arr2XML(this.__create_iq(aData,sType,sId,sNs,bJSON,bNoSession));var serializer=new XMLSerializer();iq=serializer.serializeToString(iq);navigator.sendBeacon(request.sURL,iq);};_me.response_check=function(aData,oResponse){try{var aXMLResponse=aData['Array'];var aIQAttribute=aXMLResponse['IQ'][0]['ATTRIBUTES'];}
catch{return false;}
if(aIQAttribute['TYPE']=='error'){try{var error=aXMLResponse.IQ[0].ERROR[0].ATTRIBUTES.UID||'',email;switch(error){case'folder_does_not_exist':if(aXMLResponse.IQ[0].ERROR[0].VALUE==='__@@ADDRESSBOOK@@__'&&dataSet.get('accounts',[sPrimaryAccount,'GUEST_ACCOUNT'])){return;}
break;case'account_does_not_exist':email=aXMLResponse.IQ[0].ERROR[0].VALUE;if(email&&email!==sPrimaryAccount){gui._create('settings','frm_settings','','','account_settings','other');gui.notifier._value({type:'alert',args:{header:'ALERTS::'+error,text:'ALERTS::UPDATE_LOGIN_INFORMATION',args:[email]}});return false;}
case'session_no_user':document.cookie='permanentLogin=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT';case'session_expired':dataSet.add('main',['sid'],'');if(gui&&gui.frm_main&&gui.frm_main.__logout)
gui.frm_main.__logout();return false;case'imap_authenticate':case'smtp_authenticate':case'groupware_authenticate':email=aXMLResponse.IQ[0].ERROR[0].VALUE||aIQAttribute.UID;if(email&&email!==sPrimaryAccount){gui.notifier._value({type:'alert',args:{header:'ALERTS::'+error,text:'ALERTS::UPDATE_LOGIN_INFORMATION',args:[email]}});if(!gui.settings||!gui.settings._isModal()){gui._create('settings','frm_settings','','','account_settings','other');}
gui.settings._modal(true);}else{gui&&gui.frm_main&&gui.frm_main._acceptChangedIP&&gui.frm_main._acceptChangedIP();}
return false;case'xmlrequest_invalid_sid':case'session_ip_mismatch':if(!gui.reauth)
gui._create('reauth','frm_reauth');return false;default:if(error.indexOf('E_')===0&&getLang('ERROR::'+error,false,2)){gui.notifier._value({type:'alert',args:{header:'ERROR::'+error}});}}}
catch(er){console.log(this._name||false,er);}}
else{var oldTCToken=window.sPrimaryAccountTeamchatToken;var newTCToken=aXMLResponse.IQ[0].ATTRIBUTES&&aXMLResponse.IQ[0].ATTRIBUTES.TEAMCHAT_TOKEN;if(newTCToken&&!~(dataSet.get('temp',['invalidTCTokens'])||[]).indexOf(newTCToken)){sPrimaryAccountTeamchatToken=newTCToken;if(oldTCToken!=newTCToken){gui.__exeEvent('TeamchatTokenChanged');}}}
try{executeCallbackFunction(oResponse,aData);}
catch(e){if(dataSet.get('main',['sid'])){console.warn({InputData:aXMLResponse||'no data',Error:e});}}};_me.response=function(){};

/* client/inc/wm_auth.js */function wm_auth(){this.xmlns='auth';};wm_auth.inherit(wm_generic);_me=wm_auth.prototype;_me.login=async function(auth_array,sDataSet,sDataPath){var request;if(auth_array['username']&&(auth_array['password']||auth_array['digest']||auth_array['auto_digest'])){if(auth_array.password){try{auth_array.digest=await this.digest(auth_array['username'],auth_array['password']);}
catch{this.error={id:'RSA'};return false;}}
else
if(auth_array.auto_digest){try{auth_array.digest=await this.digest(auth_array['username'],'',auth_array['auto_digest']);}
catch{this.error={id:'RSA'};return false;}}
this.logout();request={"USERNAME":[{"VALUE":auth_array.username}],"DIGEST":[{"VALUE":auth_array.digest}],"METHOD":[{"VALUE":'RSA'}]};if(auth_array.auto_login)
request.AUTO_LOGIN=[{"VALUE":'true'}];if(auth_array.language)
request.LANGUAGE=[{"VALUE":auth_array.language}];if(auth_array.disable_ip_check)
request.DISABLE_IP_CHECK=[{"VALUE":1}];}
else
if(auth_array.session){if(auth_array.session.indexOf('wmtr')===0){request={METHOD:[{VALUE:'troubleshootingsession'}],SESSION:[{VALUE:auth_array.session}]};}else{request={"SESSION":[{"VALUE":auth_array.session}]};if(auth_array.from)
request.FROM=[{"VALUE":auth_array.from}];if(auth_array.keep)
request.KEEP=[{"VALUE":'true'}];}}
else
return false;if(!sDataSet){var aData=await this.create_iq(request,'','','set');if(this.error)return false;dataSet.add('main',['dlsess'],aData["IQ"][0]["ATTRIBUTES"]["DLSESS"]);aData=aData["IQ"][0]["ATTRIBUTES"]["SID"];dataSet.add('main',['sid'],aData);return aData;}
else
this.create_iq(request,[this,'response',['login',sDataSet,sDataPath]],'','set');return true;};_me.reconnect=async function(sUser,sPassword,aHandler){var digest=await auth.digest(sUser,sPassword,undefined,await auth.hashid({username:sUser},true));var request={"METHOD":[{"VALUE":'RSAIP'}],"USERNAME":[{"VALUE":dataSet.get('main',['user'])}],"DIGEST":[{"VALUE":digest}],"SESSION":[{"VALUE":dataSet.get('main',['sid'])}]};this.create_iq(request,[this,'response',['reconnect','main',['sid'],aHandler]],'','set');};_me.get_digest=function(hashID,sMethod,aHandler){var request={METHOD:[{VALUE:sMethod}]};if(Is.String(hashID)){request.hashID=[{VALUE:hashID}];}
else
if(hashID.hash){request.hashID=[{VALUE:hashID.hash}];if(hashID.command){request.COMMAND=[{VALUE:hashID.command}];if(hashID.uri)
request.URI=[{VALUE:hashID.uri||''}];}}
else{console.log('get_digest','Invalid hashID',hashID);return;}
this.create_iq(request,[this,'response',['digest','','',aHandler]],'','get');};_me.get_xmpp=function(aHandler){if(aHandler)
this.create_iq({METHOD:[{VALUE:'xmpp'}]},[this,'response',['xmpp','','',aHandler]],'','get');};_me.logout=function(bIgnoreResponse){if(this.__loggedOut){return;}
this.__loggedOut=true;if(window.icewarpapi){icewarpapi.logout();}
window.TeamChatAPI&&TeamChatAPI.logout();if(!dataSet.get("main",['sid']))return true;if(bIgnoreResponse){if(navigator.sendBeacon){this.sendBeacon(false,'set');}else{this.create_iq(null,[this,'_void'],'','set');}
return true;}
else
this.create_iq(null,'','','set');dataSet.remove("main",['sid'],true);return true;};_me.troubleshootingSession=function(validity,aHandler){var aRequest={METHOD:[{VALUE:'troubleshootingsession'}],VALIDITY:[{VALUE:validity}]};this.create_iq(aRequest,[this,'response',['troubleshootingSession',null,null,aHandler]],'','get');};_me.deleteTroubleshooting=function(session,aHandler){var aRequest={METHOD:[{VALUE:'deletetroubleshooting'}],SESSION:[{VALUE:session}]};this.create_iq(aRequest,[this,'response',['deleteTroubleshooting',null,null,aHandler]],'','set');};_me._void=function(){};_me.digest=async function(user,pass,auto,hash){await storage.library('prng4','rsa');await storage.library('rng','rsa');await storage.library('jsbn','rsa');await storage.library('rsa','rsa');var tmp=hash?hash:this.hashid({"username":user}),rsa=new RSAKey();rsa.setPublic(tmp.hash,'10001');try{return pass?rsa.encrypt(buildURL({p:pass,t:tmp.time})):rsa.encrypt(auto);}
catch(r){console.error(r);}};_me.hashid=async function(auth_array,anonymous)
{await storage.library('prng4','rsa');await storage.library('rng','rsa');await storage.library('jsbn','rsa');await storage.library('rsa','rsa');var request={"USERNAME":[{"VALUE":auth_array['username']}],"METHOD":[{"VALUE":'RSA'}]};var response=anonymous?await this.create_iq(request,undefined,undefined,undefined,undefined,undefined,undefined,true):await this.create_iq(request);return{hash:response["IQ"][0]["QUERY"][0]["HASHID"][0]["VALUE"],time:response["IQ"][0]["QUERY"][0]["TIMESTAMP"][0]["VALUE"]};};_me.response=function(aData,sMethodName,sDataSet,sDataPath,aHandler)
{var aXMLResponse=aData['Array'],aIQAttribute=aXMLResponse['IQ'][0]['ATTRIBUTES'];if(sDataSet=='main')
sDataPath=['sid'];else
sDataPath=sDataPath||['sid'];switch(sMethodName){case'login':case'reconnect':if(aIQAttribute['TYPE']=='result'&&aXMLResponse["IQ"][0]["ATTRIBUTES"]["SID"])
dataSet.add(sDataSet,sDataPath,aXMLResponse["IQ"][0]["ATTRIBUTES"]["SID"]);if(aHandler)
executeCallbackFunction(aHandler,aData['Array']["IQ"][0]["ATTRIBUTES"]["TYPE"]=="result");break;case'logout':dataSet.add(sDataSet,sDataPath,'');break;case'digest':if(aIQAttribute['TYPE']=='result')
executeCallbackFunction(aHandler,aXMLResponse["IQ"][0]["QUERY"][0]["DIGEST"][0]["VALUE"]);break;case'xmpp':if(aIQAttribute['TYPE']=='result'){var aOut={};aData=aXMLResponse["IQ"][0]["QUERY"][0];for(var n in aData)
if(aData[n][0]&&aData[n][0].VALUE)
aOut[n]=aData[n][0].VALUE;executeCallbackFunction(aHandler,aOut);}
break;case'troubleshootingSession':Cookie.set(['troubleshooting'],{session:aXMLResponse.IQ[0].QUERY[0].DIGEST[0].VALUE,timestamp:aXMLResponse.IQ[0].QUERY[0].TIMESTAMP[0].VALUE});executeCallbackFunction(aHandler);break;case'deleteTroubleshooting':Cookie.set(['troubleshooting']);executeCallbackFunction(aHandler);break;}};var auth=new wm_auth();

/* client/inc/wm_accounts.js */function wm_accounts(){this.xmlns='accounts';};wm_accounts.inherit(wm_generic);_me=wm_accounts.prototype;_me.add=function(aAccountInfo,sDataSet,aDataPath,aHandler){var aRequest,uid;if(aAccountInfo['aid']){aRequest={"ACCOUNT":[{"ATTRIBUTES":{"ACTION":"edit","UID":aAccountInfo['aid']}}]};var aFrame=aRequest["ACCOUNT"][0];for(var sTag in aAccountInfo)
if(sTag=='acl'){var aGrp=[];for(var i in aAccountInfo['acl'])
aGrp.push({VALUE:aAccountInfo['acl'][i].join(''),ATTRIBUTES:{EMAIL:i}});if(aGrp.length)
aFrame.ACL=[{RIGHT:aGrp}];else
aFrame.ACL=[{VALUE:''}];}
else
if(sTag!='aid')
aFrame[sTag]=[{"VALUE":aAccountInfo[sTag]}];uid=aAccountInfo['aid'];}
else
if(aAccountInfo['SERVER']&&aAccountInfo['USERNAME']&&(aAccountInfo['PASSWORD']||aAccountInfo.DIGEST)&&aAccountInfo['EMAIL']){switch(aAccountInfo['PROTOCOL']){case'imap':case'pop3':case'local':break;default:aAccountInfo['PROTOCOL']='pop3';}
if(!aAccountInfo['PORT'])
if(aAccountInfo['PROTOCOL']=='imap')
aAccountInfo['PORT']=143;else
aAccountInfo['PORT']=110;uid=aAccountInfo['EMAIL'];aRequest={"ACCOUNT":[{"ATTRIBUTES":{"ACTION":"add"},"PROTOCOL":[{"VALUE":aAccountInfo['PROTOCOL']}],"SERVER":[{"VALUE":aAccountInfo['SERVER']}],"USERNAME":[{"VALUE":aAccountInfo['USERNAME']}],"PASSWORD":[{"VALUE":aAccountInfo['PASSWORD']}],"DIGEST":[{"VALUE":aAccountInfo['DIGEST']}],"PORT":[{"VALUE":aAccountInfo['PORT']}],"EMAIL":[{"VALUE":aAccountInfo['EMAIL']}],"DESCRIPTION":[{"VALUE":aAccountInfo['DESCRIPTION']}]}]};}
else
return false;this.create_iq(aRequest,[this,'response',['add',sDataSet,aDataPath,aHandler]],'','set',uid);};_me.subscribe=function(aAccountInfo,aHandler){if(!aAccountInfo||!aAccountInfo.subscription||!aAccountInfo.subscription.length)
return;var aSub=[];for(var i in aAccountInfo.subscription)
aSub.push({VALUE:aAccountInfo.subscription[i]});if(aSub.length){var aRequest={"ACCOUNT":[{"SUBSCRIPTION":aSub,"ATTRIBUTES":{"ACTION":'subscribe',"UID":sPrimaryAccount}}]};this.create_iq(aRequest,[this,'response',['subscribe','','',aHandler]],'','set');return true;}};_me.unsubscribe=function(aAccountInfo,aHandler){if(!aAccountInfo||!aAccountInfo.subscription||!aAccountInfo.subscription.length)
return;var aSub=[];for(var i in aAccountInfo.subscription)
aSub.push({VALUE:aAccountInfo.subscription[i]});if(aSub.length){var aRequest={"ACCOUNT":[{"SUBSCRIPTION":aSub,"ATTRIBUTES":{"ACTION":'unsubscribe_folder',"UID":sPrimaryAccount}}]};this.create_iq(aRequest,[this,'response',['subscribe','','',aHandler]],'','set');return true;}};_me.invite=function(aAccountInfo,aHandler){var aRequest={ACCOUNT:[{ATTRIBUTES:{ACTION:'invite',UID:sPrimaryAccount},INVITE:aAccountInfo.map(function(account){return{VALUE:account.email};})}]};this.create_iq(aRequest,[this,'response',['invite','','',aHandler]],'','set');}
_me.test=function(aAccountInfo,aHandler){if(!sPrimaryAccountRSA){return this._test(aAccountInfo,aHandler);}
this.__authRSA(function(digest){aAccountInfo.DIGEST=digest;delete aAccountInfo.PASSWORD;this._test(aAccountInfo,aHandler);}.bind(this),aAccountInfo);};_me._test=function(aAccountInfo,aHandler){var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"ACTION":"test"}}]};var aAccount=aRequest.ACCOUNT[0];aAccount.EMAIL=[{VALUE:aAccountInfo.EMAIL}];aAccount.USERNAME=[{VALUE:aAccountInfo.USERNAME}];if(aAccountInfo.DIGEST){aAccount.DIGEST=[{VALUE:aAccountInfo.DIGEST}];aAccount.AUTHTYPE=[{VALUE:1}];}else if(aAccountInfo.PASSWORD){aAccount.PASSWORD=[{VALUE:aAccountInfo.PASSWORD}];}
aAccount.SERVER=[{VALUE:aAccountInfo.SERVER}];aAccount.PORT=[{VALUE:aAccountInfo.PORT}];aAccount.PROTOCOL=[{VALUE:aAccountInfo.PROTOCOL}];aAccount.SENTFOLDER=[{VALUE:aAccountInfo.SENTFOLDER}];aAccount.TRASHFOLDER=[{VALUE:aAccountInfo.TRASHFOLDER}];aAccount.DESCRIPTION=[{VALUE:aAccountInfo.DESCRIPTION}];this.create_iq(aRequest,[this,'response',['test','','',aHandler]],'','set');};_me.__authRSA=async function(callback,aAccountInfo){await storage.library('prng4','rsa');await storage.library('rng','rsa');await storage.library('jsbn','rsa');await storage.library('rsa','rsa');icewarpapi.send({commandname:'getauthchallenge',commandparams:{authtype:1}},{success:function(auth){var RSA=new RSAKey();RSA.setPublic(auth.hashid,'10001');var digest=RSA.encrypt('p='+encodeURIComponent(aAccountInfo.PASSWORD).replace(/!/g,'%21').replace(/'/g,'%27').replace(/\(/g,'%28').replace(/\)/g,'%29').replace(/\*/g,'%2A').replace(/%20/g,'+')+'&t='+auth.timestamp);callback(digest);}});};_me.__getLicense=function(callback){if(dataSet.get('main',['license'])!==void 0){return callback();}
if(dataSet.get('main',['license_type'])!==void 0){return callback();}
icewarpapi.authenticate({success:function(){icewarpapi.send({commandname:'GetServerProperties',commandparams:[{serverpropertylist:[{item:[{propname:'c_license_type'}]},{item:[{propname:'c_license'}]}]}]},{success:function(response){for(var i in response.item){var val=(response.item[i].propertyval||{}).val;var name=(response.item[i].apiproperty||{}).propname;switch(name){case'c_license':var license={};try{license=XMLTools.Str2Arr(val.unentityify()).LICENSE[0];}catch{}
dataSet.add('main',['license'],license);break;case'c_license_type':dataSet.add('main',['license_type'],val);}}
callback();},error:this.__errorHandler,context:this});},error:this.__errorHandler,context:this})};_me.license=function(aHandler){var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"ACTION":'license',"UID":sPrimaryAccount}}]};this.create_iq(aRequest,[this,'response',['license',null,null,aHandler]],'','get');return true;};_me.list=async function(aAccountInfo,sDataSet,aDataPath,sParam,aHandler){var aRequest={};if(aAccountInfo&&aAccountInfo.aid)
aRequest.ACCOUNT=[{"ATTRIBUTES":{"UID":aAccountInfo['aid']}}];aRequest.CTZ=[{'VALUE':new IcewarpDate().utcOffset()}];if(sDataSet||aHandler){this.create_iq(aRequest,[this,'response',['list',sDataSet,aDataPath,aHandler]],'','get',sParam);return true;}
else
return this.account_sort(this.parse(await this.create_iq(aRequest)));};_me.account_sort=function(arr){var main={},rss={};for(var i in arr){if(arr[i].PRIMARY){main[i]=arr[i];delete arr[i];}
else
if(arr[i].TYPE=='rss'){rss[i]=arr[i];delete arr[i];}}
for(i in arr)
main[i]=arr[i];for(i in rss)
main[i]=rss[i];return main;};_me.refresh=async function(aAccountInfo,sDataSet,aDataPath,aHandler){if(!aAccountInfo['aid'])return false;var sType='refresh',aRequest={"ACCOUNT":[{"ATTRIBUTES":{"ACTION":"refresh","UID":aAccountInfo['aid'],FORCE:!!aAccountInfo.force}}]};if(aHandler||sDataSet){this.create_iq(aRequest,[this,'response',[sType,sDataSet,aDataPath,aHandler]],'','set',aAccountInfo['aid'],'',true);return true;}
else{var result=WMFolders.parse(await this.create_iq(aRequest,'','','set'));if(result[sPrimaryAccount])
await this.__mapFolders(result[sPrimaryAccount]);return result;}};_me.remove=async function(aAccountInfo,sDataSet,aDataPath,sParam){if(!aAccountInfo['aid'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"ACTION":"delete","UID":aAccountInfo['aid']}}]};if(!sDataSet){var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}
catch(e){console.log(this._name||false,e);}
return false;}
else{this.create_iq(aRequest,[this,'response',['remove',sDataSet,aDataPath]],'','set',sParam);return true;}};_me.synchronize=async function(aFoldersInfo,sDataSet,aDataPath){if(!aFoldersInfo['aid'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aFoldersInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"ACTION":"sync"}}]}]};if(!sDataSet){var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['Array']['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}catch{}
return false;}
else{this.create_iq(aRequest,[this,'response',['synchronize',sDataSet,aDataPath]],'','set');return true;}};_me.synclist=async function(aFoldersInfo,sDataSet,aDataPath){if(!aFoldersInfo['aid'])return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aFoldersInfo['aid'],"ACTION":"sync"}}]};if(!sDataSet){var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
await WMFolders.list({'aid':aFoldersInfo['aid']});}catch{}
return false;}
else{this.create_iq(aRequest,[this,'response',['synclist',sDataSet,aDataPath]],'','set',aFoldersInfo['aid']);return true;}};_me.action=function(aInfo,sType,aHandler){if(aHandler&&sType){var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":sPrimaryAccount,"ACTION":sType}}]};if(aInfo){for(var i in aInfo){aRequest.ACCOUNT[0][i]=[{VALUE:aInfo[i]}];}}
this.create_iq(aRequest,[this,'response',['action',null,null,aHandler]],'','set',sPrimaryAccount);}};_me.response=async function(aResponse,sMethodName,sDataSet,aDataPath,aHandler){var aXMLResponse=aResponse['Array'],aIQAttribute=aXMLResponse['IQ'][0]['ATTRIBUTES'];switch(sMethodName){case'license':if(aHandler)
executeCallbackFunction(aHandler,aXMLResponse);break;case'subscribe':if(aIQAttribute['TYPE']=='result')
this.refresh({'aid':sPrimaryAccount},'folders');if(aHandler)
executeCallbackFunction(aHandler,aXMLResponse);break;case'test':var out=false;try{if(aXMLResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
out=true;}
catch(e){console.log(this._name||false,e);}
executeCallbackFunction(aHandler,out);return;case'list':if(aIQAttribute['TYPE']=='result'){if(sDataSet||aHandler){var acc=this.account_sort(this.parse(aXMLResponse));if(sDataSet)
dataSet.add(sDataSet,aDataPath,acc);if(aHandler)
executeCallbackFunction(aHandler,acc);}
if(aIQAttribute['UID']){var aAccounts=dataSet.get(sDataSet,aDataPath);dataSet.remove(aIQAttribute['UID'],'',true);for(var sAccId in aAccounts)
WMFolders.list({'aid':sAccId},aIQAttribute['UID']);}}
return true;case'refresh':if(aIQAttribute['TYPE']=='error'){var str,att;try{att=aXMLResponse.IQ[0].ERROR[0].ATTRIBUTES.UID;str=aXMLResponse.IQ[0].ERROR[0].VALUE;}catch{str=att='';}
if(att.toLowerCase()=='imap_internal'){if(typeof aHandler=='object')
executeCallbackFunction(aHandler,(aIQAttribute['UID']?aIQAttribute['UID']+"\n":'')+str.unescapeHTML());else
alert((aIQAttribute['UID']?aIQAttribute['UID']+"\n":'')+str.unescapeHTML());}}
case'synchronize':if(aIQAttribute['TYPE']=='result'&&aIQAttribute['UID']){var aParsedData=WMFolders.parse(aXMLResponse),aAccountAttribute=aXMLResponse['IQ'][0]['QUERY'][0]['ACCOUNT'][0].ATTRIBUTES;if(sPrimaryAccount==aIQAttribute['UID']){if(aAccountAttribute.MBOX_QUOTA){dataSet.add('main',['MBOX_QUOTA'],aAccountAttribute.MBOX_QUOTA,true);dataSet.add('main',['MBOX_USAGE'],aAccountAttribute.MBOX_USAGE);}
if(aAccountAttribute.SMS_LIMIT){dataSet.add('main',['SMS_LIMIT'],aAccountAttribute.SMS_LIMIT,true);dataSet.add('main',['SMS_SENT'],aAccountAttribute.SMS_SENT);}
var oRecent={},i;var aFolders=dataSet.get(sDataSet,[aIQAttribute['UID']]);for(i in aFolders){oRecent[i]=aFolders[i].RECENT;}
if(aIQAttribute['UID']==sPrimaryAccount)
await this.__mapFolders(aParsedData[aIQAttribute['UID']]);this.__mergeDataset(aIQAttribute['UID'],aParsedData[aIQAttribute['UID']]);if(sMethodName==='synchronize'){for(i in aParsedData[aIQAttribute['UID']]){if(Object.prototype.hasOwnProperty.call(aParsedData[aIQAttribute['UID']],i)){dataSet.add(sDataSet,[aIQAttribute['UID'],i],aParsedData[aIQAttribute['UID']][i]);}}}
else{dataSet.add(sDataSet,[aIQAttribute['UID']],aParsedData[aIQAttribute['UID']]);}
aFolders=dataSet.get(sDataSet,[aIQAttribute['UID']]);for(i in aFolders){if(aFolders[i].TYPE!=='M'||((i!=='INBOX')&&((GWOthers.getItem('MAIL_SETTINGS_GENERAL','secondary_notify')==0)||!aFolders[i].SYNC||aFolders[i].DEFAULT||aFolders[i].SPAM||(aFolders[i.split('/')[0]]||{}).ARCHIVE))){continue;}
if(oRecent[i]<aFolders[i].RECENT){if(!window.skipNewMailNotification){if(gui.frm_main&&gui.frm_main.title){gui.frm_main.title._add(getLang('TITLE::NEW_EMAIL'),10);}
var emails=dataSet.get('temp',['new_mail',i])||[];if(gui.notifier&&emails.length){gui.notifier._value({type:'new_email',args:{aid:aIQAttribute['UID'],fid:i,emails:emails}});dataSet.add('temp',['new_mail',i],[],true);}
await storage.library('gw_others');if(gui.frm_main&&gui.frm_main.sound&&parseInt(GWOthers.getItem('MAIL_SETTINGS_GENERAL','sound_notify'))>0){gui.frm_main.sound._play('mail');}}}else if(i==='INBOX'&&oRecent[i]>0&&!aFolders[i].RECENT){if(gui.frm_main&&gui.frm_main.title){gui.frm_main.title._reset();}}}
delete window.skipNewMailNotification;}
else
dataSet.add(sDataSet,[aIQAttribute['UID']],aParsedData[aIQAttribute['UID']]);if(typeof aHandler=='object')
executeCallbackFunction(aHandler);}
break;case'remove':try{if(aIQAttribute['TYPE']!='result'&&aIQAttribute['UID'])
this.list(sDataSet,aDataPath,aIQAttribute['UID']);return true;}
catch(e){console.log(this._name||false,e);}
return false;case'add':case'synclist':try{if(aIQAttribute['TYPE']=='result'&&sDataSet&&aIQAttribute['UID']){WMFolders.list({'aid':aIQAttribute['UID']},sDataSet,aDataPath,aHandler);return true;}
else
if(aIQAttribute['TYPE']=='result'&&typeof aHandler=='object'){executeCallbackFunction(aHandler,aIQAttribute['TYPE']=='result');return true;}
else
if(aIQAttribute['TYPE']=='error'&&typeof aHandler=='object')
executeCallbackFunction(aHandler,aXMLResponse['IQ'][0]['ERROR'][0]['ATTRIBUTES']['UID'],aXMLResponse['IQ'][0]['ERROR'][0]['VALUE']);}
catch(r){console.log(this._name||false,r);}
return false;case'action':executeCallbackFunction(aHandler,aIQAttribute['TYPE']=='result',aXMLResponse['IQ'][0]);}};_me.__mapFolders=async function(aFolders){if(this.__mapped==sPrimaryAccount)return;var test={},out={};aFolders=aFolders||{};await storage.library('gw_others');var sTrashFolder=Path.split(GWOthers.getItem('DEFAULT_FOLDERS','trash'))[1];if(!aFolders[sTrashFolder])
test['trash']=sTrashFolder.toLowerCase();var sDraftFolder=Path.split(GWOthers.getItem('DEFAULT_FOLDERS','drafts'))[1];if(!aFolders[sDraftFolder])
test['drafts']=sDraftFolder.toLowerCase();var sSentFolder=Path.split(GWOthers.getItem('DEFAULT_FOLDERS','sent'))[1];if(!aFolders[sSentFolder])
test['sent']=sSentFolder.toLowerCase();for(var itm in aFolders){if(aFolders[itm].ARCHIVE)
dataSet.add('main',['archive_path'],sPrimaryAccount+'/'+itm,true);else
if(aFolders[itm].SPAM)
dataSet.add('main',['spam_path'],sPrimaryAccount+'/'+itm,true);else
if(aFolders[itm].RESOURCE)
dataSet.add('main',['resources_path'],itm,true);else
for(var itm2 in test)
if(itm.toLowerCase()===test[itm2]){out[itm2]=sPrimaryAccount+'/'+itm;delete test[itm2];}}
if(!Is.Empty(out))
GWOthers.set('DEFAULT_FOLDERS',out,'storage');this.__mapped=sPrimaryAccount;};_me.__mergeDataset=function(sAccount,aFolders){var ds=dataSet.get('folders',[sAccount]);if(ds)
for(var fid in aFolders){if(ds[fid]){if(!Is.Defined(aFolders[fid].RECENT)&&ds[fid].RECENT)
aFolders[fid].RECENT=ds[fid].RECENT;if(ds[fid].GROUPCHAT_LASTACTIVITY&&aFolders[fid].GROUPCHAT_LASTACTIVITY<ds[fid].GROUPCHAT_LASTACTIVITY)
aFolders[fid].GROUPCHAT_LASTACTIVITY=ds[fid].GROUPCHAT_LASTACTIVITY;}}
return aFolders;};_me.parse=function(aData){try{var aFrame=aData['IQ'][0]['QUERY'][0]['ACCOUNT'],aResult={},aResultFrame;for(var nAccNum in aFrame){aResultFrame={TYPE:'user'};for(var sTag in aFrame[nAccNum])
if(sTag=='ATTRIBUTES'){for(var sAtt in aFrame[nAccNum].ATTRIBUTES){if(aFrame[nAccNum].ATTRIBUTES[sAtt]=='true')
aResultFrame[sAtt]=1;else
if(aFrame[nAccNum].ATTRIBUTES[sAtt]=='false')
aResultFrame[sAtt]=0;else
aResultFrame[sAtt]=aFrame[nAccNum].ATTRIBUTES[sAtt];}}
else
if(sTag=='ACL'){var aRights;if(aFrame[nAccNum][sTag][0]&&(aRights=aFrame[nAccNum][sTag][0].RIGHT)){aResultFrame.ACL={};for(var i in aRights)
aResultFrame.ACL[aRights[i].ATTRIBUTES.EMAIL]={name:aRights[i].ATTRIBUTES.NAME,external:aRights[i].ATTRIBUTES.EXTERNAL,rights:aRights[i].VALUE?aRights[i].VALUE.split(''):[]};}
aRights=null;}
else
aResultFrame[sTag]=aFrame[nAccNum][sTag][0]['VALUE'];if(aResultFrame['PRIMARY']){aResultFrame.SHARED_PREFIX=(aResultFrame.SHARED_PREFIX||'~').replace(/\\/g,'/');dataSet.add('main',['fullname'],aResultFrame['FULLNAME'],true);dataSet.add('main',['user'],aResultFrame['USERNAME'],true);dataSet.add('main',['account'],aResultFrame['UID'],true);dataSet.add('main',['domain'],aResultFrame['UID'].substr(aResultFrame['UID'].indexOf('@')+1),true);dataSet.add('main',['message_size'],aResultFrame['MESSAGE_SIZE'],true);dataSet.add('main',['keep_deleted_items_force_expiration'],aResultFrame['KEEPDELETEDITEMSFORCEEXPIRATION'],true);dataSet.add('main',['device_id'],aResultFrame['DEVICE_ID'],true);dataSet.add('main',['server_id'],aResultFrame['ICEWARP_SERVER_ID'],true);dataSet.add('main',['MBOX_QUOTA'],aResultFrame.MBOX_QUOTA,true);dataSet.add('main',['MBOX_USAGE'],aResultFrame.MBOX_USAGE);dataSet.add('main',['version'],aResultFrame['VERSION'],true);dataSet.add('main',['nice_version'],aResultFrame['NICE_VERSION'],true);var iwma=aResultFrame.ICEWARPMOBILEAPP_URL;if(iwma){iwma=iwma.replace('1252689833','1591648135');iwma=iwma.replace(/teamchatMobile/g,'servicesHub');iwma=iwma.replace(/teamchatmobile.page.link/g,'icewarpserviceshub.page.link');iwma=iwma.replace(/com.icewarp.teamchatmobile/g,'com.icewarp.serviceshub');dataSet.add('main',['ICEWARPMOBILEAPP_URL'],iwma,true);}
window.sPrimaryAccount=aFrame[nAccNum]['ATTRIBUTES']['UID'];window.sPrimaryAccountTeamchatToken=window.sPrimaryAccountTeamchatToken||false;window.sPrimaryAccountType=aResultFrame['TYPE'];window.sPrimaryAccountProtocol=aResultFrame['PROTOCOL'];window.sPrimaryAccountWebDAV=aFrame[nAccNum]['ATTRIBUTES']['WEBDAV_URL'];window.sTeamchatApiUrl=aFrame[nAccNum]['ATTRIBUTES']['TEAMCHATAPI_URL'];window.sPrimaryAccountWebAdmin=aFrame[nAccNum]['ATTRIBUTES']['WEBADMIN_URL'];window.sPrimaryAccountClient=aFrame[nAccNum]['ATTRIBUTES']['CLIENT_URL'];window.sPrimaryAccountGW=aResultFrame['GW'];window.sPrimaryAccountGWSUPPORT=aFrame[nAccNum]['ATTRIBUTES']['GW_SUPPORT']==='true';window.sPrimaryAccountGWID=aFrame[nAccNum]['ATTRIBUTES']['GW_OWNERID'];window.sPrimaryAccountGWTRASH=aFrame[nAccNum]['ATTRIBUTES']['GWTRASH_SUPPORT'];window.sPrimaryAccountIM=aResultFrame['IM_SUPPORT'];window.sPrimaryAccountIMHISTORY=aResultFrame['IM_HISTORY_SUPPORT'];window.sPrimaryAccountSIP=aResultFrame['SIP_SUPPORT'];window.sPrimaryAccountRSA=true;window.sPrimaryAccount2F=aResultFrame['TWO_FACTOR_SUPPORT'];window.sPrimaryAccount2FE=aResultFrame['TWO_FACTOR_ENABLED'];window.sPrimaryAccountRECALL=aResultFrame['RECALL_MESSAGES_ENABLED'];window.sPrimaryAccountCHAT=aResultFrame['GROUPCHAT_SUPPORT'];window.sPrimaryAccountGUEST=aResultFrame['GUEST_ACCOUNT'];window.sPrimaryAccountACTIVESYNC=aResultFrame['ACTIVESYNC_SUPPORT'];window.sPrimaryAccountSMS=aResultFrame['SMS_SUPPORT'];window.sPrimaryAccountSPREFIX=aResultFrame['SHARED_PREFIX'];window.sPrimaryAccountAPREFIX=aResultFrame['ARCHIVE_PERFIX'];window.sPrimaryAccountSHARING=aResultFrame['SHARING_SUPPORT'];window.sPrimaryAccountDELIVERY=aResultFrame['DELIVERY_SUPPORT'];window.sPrimaryAccountRULES=aResultFrame['RULES_SUPPORT'];window.sPrimaryAccountCONFERENCE=aResultFrame['MEETING_SUPPORT'];window.sPrimaryAccountRECORDING=aResultFrame['RECORDING_SUPPORT'];window.sPrimaryAccountCONFERENCE_PARAM=aResultFrame['CONFERENCEPARAM_ENCRYPTED'];window.sPrimaryAccountFULLTEXT=aResultFrame['FULLTEXT_SUPPORT'];window.sPrimaryAccountSOCKS=aResultFrame['SOCKS_SUPPORT'];window.sPrimaryAccountHTTP=aResultFrame['HTTP_PORT'];window.sPrimaryAccountHTTPS=aResultFrame['HTTPS_PORT'];window.sPrimaryAccountULIMIT=aResultFrame['UPLOAD_LIMIT'];window.sPrimaryAccountSMTP=aResultFrame['SMTP_HEADER_FUNCTION'];window.sPrimaryAccountOLDWC=aResultFrame['OLD_SUPPORT'];window.sPrimaryTelemetry=aResultFrame['TELEMETRY_SUPPORT'];window.aPrimaryAttributes=Object.assign({},aResultFrame,aFrame[nAccNum]['ATTRIBUTES']);}
aResult[aResultFrame['UID']]=aResultFrame;}
return aResult;}catch{return false;}};var accounts=new wm_accounts();var WMAccounts=accounts;

/* client/inc/wm_folders.js */function wm_folders(){this.xmlns='folders';};wm_folders.inherit(wm_generic);_me=wm_folders.prototype;wm_folders.aux={sort:function sort(a,b){var sA,sB;if(Is.String(a['TITLE']))
sA=a['TITLE'].toLowerCase();else
sA=a['TITLE'];if(Is.String(b['TITLE']))
sB=b['TITLE'].toLowerCase();else
sB=b['TITLE'];if(sA>sB)return 1;if(sA<sB)return-1;return 0;}};Object.defineProperty(wm_folders.aux,'private_owner',{get:function(){return this.value||(this.value='private_'+dataSet.get('main',['domain'])+'@##internalservicedomain.icewarp.com##');}});_me.add=async function(aFolderInfo,sDataSet,aDataPath,aHandler,aErrorHandler)
{if(!aFolderInfo['aid'])
return false;var aRequest,i;if(aFolderInfo['fid']){if(!aFolderInfo['default']&&!aFolderInfo['name']&&typeof aFolderInfo['channel']=='undefined'&&!aFolderInfo['acl'])
return false;aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aFolderInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aFolderInfo['fid'],"ACTION":"edit"}}]}]};}
else{if(!aFolderInfo['name'])
return false;if(aFolderInfo['type']&&inArray(['mail','contact','event','journal','note','task','file','m','r','c','e','j','n','t','f','i'],aFolderInfo['type'].toLowerCase())<0)
return false;else
if(!aFolderInfo['type'])
aFolderInfo['type']='M';aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aFolderInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"ACTION":"add"},"TYPE":[{"VALUE":aFolderInfo['type']}]}]}]};}
if(aFolderInfo.name)
aRequest.ACCOUNT[0].FOLDER[0].NAME=[{VALUE:aFolderInfo.name}];if(aFolderInfo.folderName)
aRequest.ACCOUNT[0].FOLDER[0].FOLDERNAME=[{VALUE:aFolderInfo.folderName}];if(aFolderInfo['default'])
aRequest.ACCOUNT[0].FOLDER[0].DEFAULT=[{'VALUE':aFolderInfo['default']}];if(aFolderInfo['private'])
aRequest.ACCOUNT[0].FOLDER[0].PRIVATE=[{'VALUE':aFolderInfo['private']}];if(aFolderInfo['clone'])
aRequest.ACCOUNT[0].FOLDER[0].CLONE=[{'VALUE':aFolderInfo['clone']}];if(aFolderInfo.virtual){aRequest.ACCOUNT[0].FOLDER[0].VIRTUAL=[];if(aFolderInfo.virtual.sharetype)
aRequest.ACCOUNT[0].FOLDER[0].VIRTUAL=[{SHARETYPE:[{'VALUE':aFolderInfo.virtual.sharetype}]}];if(aFolderInfo.virtual.folders){aRequest.ACCOUNT[0].FOLDER[0].VIRTUAL=[{FOLDERS:[{'FOLDER':[]}]}];var tmp;for(i in aFolderInfo.virtual.folders){tmp={'VALUE':i};if(aFolderInfo.virtual.folders[i])
tmp.ATTRIBUTES={'PRIMARY':"true"};aRequest.ACCOUNT[0].FOLDER[0].VIRTUAL[0].FOLDERS[0].FOLDER.push(tmp);}}
if(typeof aFolderInfo['search']!='undefined')
aRequest.ACCOUNT[0].FOLDER[0].VIRTUAL[0].SEARCH=[{'VALUE':aFolderInfo['search']}];}
if(aFolderInfo['acl']){var aGrp=[];for(i in aFolderInfo['acl'])
aGrp.push({VALUE:aFolderInfo['acl'][i].join(''),ATTRIBUTES:{EMAIL:i}});if(aGrp.length)
aRequest.ACCOUNT[0].FOLDER[0].ACL=[{RIGHT:aGrp}];else
aRequest.ACCOUNT[0].FOLDER[0].ACL=[{VALUE:''}];}
if(Is.Array(aFolderInfo['channel'])){aRequest.ACCOUNT[0].FOLDER[0].CHANNELS=[{CHANNEL:[]}];for(i in aFolderInfo['channel'])
if(aFolderInfo['channel'][i])
aRequest.ACCOUNT[0].FOLDER[0].CHANNELS[0].CHANNEL.push({"VALUE":aFolderInfo['channel'][i]});}
if(sDataSet||aHandler){this.create_iq(aRequest,[this,'response',['add',sDataSet,aDataPath,aFolderInfo,aHandler,aErrorHandler]],'','set',aFolderInfo['aid']);return true;}
else{var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}
catch(e){console.log(this._name||false,e);}
return false;}};_me.list=async function(aFoldersInfo,sDataSet,aDataPath,aHandler,aErrorHandler)
{if(!aFoldersInfo.aid)
return false;var aRequest={ACCOUNT:[{ATTRIBUTES:{UID:aFoldersInfo.aid,FORCE:!!aFoldersInfo.force}}]};var folder;if(aFoldersInfo.fid){folder=folder||{};folder.ATTRIBUTES={UID:aFoldersInfo.fid};}
if(aFoldersInfo.search){folder=folder||{};folder.SEARCH=[{VALUE:aFoldersInfo.search}];}
if(folder){aRequest.ACCOUNT[0].FOLDER=[folder];}
if(!sDataSet&&!aHandler)
return this.parse(await this.create_iq(aRequest));else{this.create_iq(aRequest,[this,'response',['list',sDataSet,aDataPath,'',aHandler,aErrorHandler]],'','get',aFoldersInfo['aid']);return true;}};_me.getType=function(aFolderInfo){var aid=aFolderInfo.aid||aFolderInfo[0],fid=Path.slash(aFolderInfo.fid||aFolderInfo[1]||'');if(!Is.Defined(fid))
return'X';if(aid===sPrimaryAccount){if(fid.match(/__@@VIRTUAL@@__\/.*#\w$/)){return fid.slice(-1);}
var subtree;if(subtree=(fid.match(/__@@VIRTUAL@@__\/@@SUBTREE@@\/(.*)/)||[])[1]){return dataSet.get('folders',[sPrimaryAccount,subtree,'TYPE']);}
switch(fid){case'__@@VIRTUAL@@__/__@@PRIVATE_ROOMS@@__':return'Y';case'__@@VIRTUAL@@__/__@@MEETINGS@@__':return'W';case'__@@VIRTUAL@@__/__@@DASHBOARD@@__':return'D';case'__@@VIRTUAL@@__/__@@NOTES@@__':return'N';case'__@@VIRTUAL@@__/__@@EVENTS@@__':return'E';case'__@@THREADS@@__':return'I';case'__@@ARCHIVE@@__':case'__@@SNOOZED@@__':return'M';case'__@@UPLOAD@@__':return'F';case'__@@ADDRESSBOOK@@__':case'__@@mycard@@__':case'@@mycard@@':return'C';}}
else
if(aid==='@@alfresco@@')
return'K';if(aFolderInfo.fid&&aFolderInfo.fid.indexOf(sPrimaryAccountSPREFIX)===0&&!~aFolderInfo.fid.indexOf('/')){return'VA';}
var sType=dataSet.get('folders',[aid,fid,'TYPE'])||'X';if(sType=='X'&&~fid.indexOf('/TeamChat/')&&dataSet.get('folders',[aid,Path.basedir(fid),'TYPE'])=='I')
return'I';return sType;};_me.getRights=function(aFolderInfo,isRight){var aRights={},aid=aFolderInfo.aid||aFolderInfo[0],fid=aFolderInfo.fid||aFolderInfo[1],tmp=null;if(this.getType(aFolderInfo)=='Y')
tmp=dataSet.get('folders',[aid,fid].concat('RIGHTS'));else
if(Cookie)
tmp=Cookie.get(['rights',aid,fid]);if(tmp){for(var i in tmp){switch(tmp[i]){case'l':aRights.read=true;break;case'k':aRights.write=true;break;case'x':aRights.modify=true;aRights.remove=true;break;case'a':aRights.owner=true;break;case'b':aRights.invite=true;break;case'c':aRights.kick=true;break;case'd':aRights.edit_folder=true;break;case'e':aRights.edit_document=true;break;}}}
else
aRights={owner:true,read:true,write:true,modify:true,remove:true};if(isRight)
return!!aRights[isRight];return aRights;};_me.getAccess=function(aFolderInfo,isRight){var aRights={},aid=aFolderInfo.aid||aFolderInfo[0],fid=aFolderInfo.fid||aFolderInfo[1],tmp=null;if(this.getType(aFolderInfo)=='Y')
tmp=dataSet.get('folders',[aid,fid].concat('RIGHTS'));else
if(Cookie)
tmp=Cookie.get(['rights',aid,fid]);if(tmp){for(var i in tmp){switch(tmp[i]){case'r':aRights.read=true;break;case'i':aRights.write=true;break;case'w':aRights.modify=true;break;case't':aRights.remove=true;break;case'e':aRights.edit_document=true;break;}}}
else
aRights={owner:true,read:true,write:true,modify:true,remove:true};if(isRight)
return!!aRights[isRight];return aRights;};_me.remove=function(aFolderInfo,sDataSet,aDataPath)
{return this.action(aFolderInfo,sDataSet,aDataPath,'delete');};_me.empty=function(aFolderInfo,sDataSet,aDataPath,aDestination,aHandler)
{if(!sDataSet){if(this.action(aFolderInfo,sDataSet,aDataPath,'empty',aDestination,aHandler)){dataSet.add('items',[aFolderInfo['aid'],aFolderInfo['fid']],{});return true;}
else
return false;}
else{return this.action(aFolderInfo,sDataSet,aDataPath,'empty',aDestination,aHandler);}};_me.action=async function(aItemInfo,sDataSet,aDataPath,sAction,aDestination,aHandler)
{if(!sAction||!aItemInfo['aid']||!aItemInfo['fid'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemInfo['fid'],"ACTION":sAction}}]}]};if(aItemInfo.xmlarray)
for(var i in aItemInfo.xmlarray)
aRequest.ACCOUNT[0].FOLDER[0][i]=aItemInfo.xmlarray[i];if(Is.Object(aDestination)){aRequest.ACCOUNT[0].FOLDER[0].ACCOUNT=[{"VALUE":aDestination['aid']}];aRequest.ACCOUNT[0].FOLDER[0].FOLDER=[{"VALUE":aDestination['fid']}];}
if(aItemInfo.filter){aRequest.ACCOUNT[0].FOLDER[0].SEARCH=[{VALUE:aItemInfo.filter}];}
if(!sDataSet&&!aHandler){var aResponse=await this.create_iq(aRequest,'','','set');if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;return false;}
else{this.create_iq(aRequest,[this,'response',[sAction,sDataSet,aDataPath,{aid:aItemInfo.aid,fid:aItemInfo.fid},aHandler]],'','set',aItemInfo['aid']+'/'+aItemInfo['fid']);return true;}};_me.save_folder=function(aItemsInfo,aHandler)
{if(!aItemsInfo['aid']||!aItemsInfo['fid'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid'],"ACTION":'save_items'}}]}]};this.create_iq(aRequest,[this,'response',['save_folder','','','',aHandler]],'','set');return true;};_me.subscribe=function(aFolderInfo,sDataSet,aDataPath,bSync,aHandler){sDataSet=sDataSet||'folders';var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aFolderInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aFolderInfo['fid'],"ACTION":"edit"},"SUBSCRIBED":[{"VALUE":bSync?1:0}]}]}]};var aHandlerOut;if(bSync){aHandlerOut=[function(bOk,aFolderInfo){bOk&&this.sync(aFolderInfo,sDataSet,aDataPath,aHandler);}.bind(this)];}
else
aHandlerOut=aHandler;this.create_iq(aRequest,[this,'response',[bSync?'sync':'unsync',sDataSet,aDataPath,aFolderInfo,aHandlerOut]],'','set',aFolderInfo['aid']+'/'+aFolderInfo['fid']);return true;};_me.sync=function(aFoldersInfo,sDataSet,aDataPath,aHandler){if(!aFoldersInfo.aid)
return false;var aRequest={ACCOUNT:[{ATTRIBUTES:{UID:aFoldersInfo.aid},FOLDER:[{ATTRIBUTES:{ACTION:"sync",UID:aFoldersInfo.fid}}]}]};this.create_iq(aRequest,[WMAccounts,'response',['synchronize',sDataSet,aDataPath,aHandler]],'','set',aFoldersInfo.aid);};_me.markItemsRead=async function(aFolderInfo,sDataSet,aDataPath,bRead)
{if(!aFolderInfo['aid']||!aFolderInfo['fid'])
return false;var sType=bRead?'markasread':'markasunread';var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aFolderInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aFolderInfo['fid'],"ACTION":sType}}]}]};aFolderInfo['bRead']=bRead;if(aFolderInfo.filter){aRequest.ACCOUNT[0].FOLDER[0].SEARCH=[{VALUE:aFolderInfo.filter}];}
if(!sDataSet){var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}
catch(e){console.log(this._name||false,e);}
return false;}
else{this.create_iq(aRequest,[this,'response',['markread',sDataSet,aDataPath,aFolderInfo]],'','set',aFolderInfo['aid']);return true;}};_me.response=async function(aResponse,sMethodName,sDataSet,aDataPath,aFolderInfo,aHandler,aErrorHandler)
{var aXMLResponse=aResponse['Array'];var aIQAttribute=aXMLResponse['IQ'][0]['ATTRIBUTES'];var tmp,aFolder,srt,aDataSet,i,aItems,sAccId,sFolId;try{if(aIQAttribute['TYPE']=='error'){var str,att;try{att=aXMLResponse.IQ[0].ERROR[0].ATTRIBUTES.UID;str=aXMLResponse.IQ[0].ERROR[0].VALUE;}
catch{str=att='';}
if(aErrorHandler){executeCallbackFunction(aErrorHandler,aFolderInfo,att,str);return;}
switch(att.toLowerCase()){case'teamchat_kick_member':gui.notifier._value({type:'alert',args:{header:'ALERTS::ALERT',text:'ALERTS::ALERT',args:[aFolderInfo.name.escapeHTML()]}});break;case'imap_internal':gui.notifier._value({type:'alert',args:{header:'ALERTS::UNDEFINED',text_plain:(aIQAttribute['UID']?aIQAttribute['UID']+"\n":'')+str.unescapeHTML()}});break;case'folder_create':gui.notifier._value({type:'alert',args:{header:'POPUP_FOLDERS::ADD_FOLDER',text:'ALERTS::CREATE_FOLDER',args:[aFolderInfo.name.escapeHTML()]}});break;case'folder_already_exists':gui.notifier._value({type:'alert',args:{header:'POPUP_FOLDERS::ADD_FOLDER',text:'ALERTS::FOLDER_EXIST',args:[aFolderInfo.name.escapeHTML()]}});break;case'folder_name_bad_char':case'folder_rename':gui.notifier._value({type:'alert',args:{header:'POPUP_FOLDERS::RENAME_FOLDER',text:'ALERTS::RENAME_FOLDER',args:[aFolderInfo.fid.escapeHTML(),aFolderInfo.name.escapeHTML()]}});break;case'autocreate_folder_name_reserved_word':gui.notifier._value({type:'alert',args:{header:'POPUP_FOLDERS::ADD_FOLDER',text:'ALERTS::RESERVED_FOLDER',args:[aFolderInfo.name.escapeHTML()]}});}}}
catch(e){console.log(this._name||false,e);}
try{aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].ATTRIBUTES.UID=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].ATTRIBUTES.UID.replace(/^\//,'');}catch{}
try{if(aFolderInfo){aFolderInfo.fid=(aFolderInfo.fid||'').replace(/^\//,'');}}catch{}
switch(sMethodName){case'save_folder':if(aIQAttribute['TYPE']=='result'){var aOut;try{aOut={'class':aXMLResponse.IQ[0].RESULT[0].ACCOUNT[0].FOLDER[0].ITEM[0].VALUES[0].CLASS[0].VALUE,'fullpath':aXMLResponse.IQ[0].RESULT[0].ACCOUNT[0].FOLDER[0].ITEM[0].VALUES[0].FULLPATH[0].VALUE};}
catch{break;}
if(Is.Object(aHandler))
executeCallbackFunction(aHandler,aOut);else{aOut['dlsess']=dataSet.get('main',['dlsess']);downloadItem(buildURL(aOut));}}
break;case'unsync':case'sync':if(aIQAttribute['TYPE']=='result'){dataSet.add('folders',[aFolderInfo['aid'],aFolderInfo['fid'],'SYNC'],sMethodName=='sync'?1:0);}
if(aHandler)
executeCallbackFunction(aHandler,aIQAttribute['TYPE']=='result',aFolderInfo);break;case'add':if(aIQAttribute['TYPE']=='error'){try{if(aIQAttribute['UID'])
this.list({'aid':aIQAttribute['UID']},sDataSet,aDataPath);}
catch(e){console.log(this._name||false,e);}
return true;}
else{if(aFolderInfo.type=='I'&&Is.String(aFolderInfo.name)){tmp=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0];if(!tmp.FOLDER[0].NAME||(Path.basename(aFolderInfo.name)==tmp.FOLDER[0].NAME[0].VALUE))
aFolderInfo.name=tmp.FOLDER[0].ATTRIBUTES.UID;}
if(Cookie&&typeof aFolderInfo.name!='undefined'&&typeof aFolderInfo.aid!='undefined'){try{tmp=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0];if(tmp.ATTRIBUTES.UID==aFolderInfo.aid&&tmp.FOLDER[0].ATTRIBUTES.UID==aFolderInfo.name){Cookie.set(['rights',aFolderInfo.aid,aFolderInfo.name],tmp.FOLDER[0].ATTRIBUTES.RIGHTS?tmp.FOLDER[0].ATTRIBUTES.RIGHTS.split(''):'');if(aFolderInfo.name==='__@@VIRTUAL@@__/__@@EVENTS@@__'){for(i in(aFolderInfo.virtual||{}).folders){if(aFolderInfo.virtual.folders[i]){Cookie.set(['rights',aFolderInfo.aid,i],tmp.FOLDER[0].ATTRIBUTES.RIGHTS?tmp.FOLDER[0].ATTRIBUTES.RIGHTS.split(''):'');break;}}}}}
catch(r){console.log(this._name||false,r);}}}
if(aFolderInfo['fid']&&((aFolderInfo['name']&&aFolderInfo['fid']!=aFolderInfo['name'])||typeof aFolderInfo['channel']!='undefined')||aFolderInfo['default'])
{aFolder=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0];var sName=aFolderInfo['name']||aFolderInfo['fid'],ds;aDataSet=dataSet.get(sDataSet,[aFolderInfo['aid']],true)||{}
for(i in aDataSet){if(i==aFolderInfo['fid']){if(aFolder.RELATIVE_PATH)
aDataSet[i].RELATIVE_PATH=Path.slash(aFolder.RELATIVE_PATH[0].VALUE);if(aFolder.OWNER)
aDataSet[i].OWNER=aFolder.OWNER[0].VALUE;if(aFolder.NAME)
aDataSet[i].NAME=aFolder.NAME[0].VALUE;else
aDataSet[i].NAME=sName.split('/').pop();if(aDataSet[i].TYPE!='I'){ds=aDataSet[i];delete aDataSet[i];if(typeof aFolderInfo['channel']!='undefined')
ds.CHANNEL=aFolderInfo['channel'];aDataSet[aFolder.ATTRIBUTES.UID]=ds;}}
else
if(i.indexOf(aFolderInfo['fid']+'/')===0){ds=aDataSet[i];delete aDataSet[i];ds.RELATIVE_PATH=aFolder.ATTRIBUTES.UID+i.substr(aFolderInfo['fid'].length);aDataSet[aFolder.ATTRIBUTES.UID+i.substr(aFolderInfo['fid'].length)]=ds;}}
if(aFolderInfo['aid']==sPrimaryAccount&&((aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].DEFAULT||[])[0]||{}).VALUE){var tmp_type={C:'CONTACTS',E:'EVENTS',T:'TASKS',N:'NOTES',J:'JOURNAL',F:'FILES',D:'DRAFTS',H:'TRASH',S:'SENT',P:'TEMPLATES'}[aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].DEFAULT[0].VALUE];if(tmp_type){var def=GWOthers.getItem('DEFAULT_FOLDERS',tmp_type);if(def&&(def=Path.split(def))&&aDataSet[def[1]])
delete aDataSet[def[1]].DEFAULT;aDataSet[sName].DEFAULT=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].DEFAULT[0].VALUE;GWOthers.setItem('DEFAULT_FOLDERS',tmp_type,aFolderInfo['aid']+'/'+sName);}}
srt={};srt[aFolderInfo['aid']]=aDataSet;dataSet.add(sDataSet,[aFolderInfo['aid']],this.sort(srt)[aFolderInfo['aid']],true);dataSet.update(sDataSet,[aFolderInfo['aid']]);if(!aFolderInfo.bSkipNotify){if(dataSet.get('folders',[aFolderInfo.aid,aFolderInfo.fid])){Item.notify([aFolderInfo.aid,aFolderInfo.fid],'UPDATE');}else{Item.notify([aFolderInfo.aid,aFolder.ATTRIBUTES.UID],'UPDATE',{FOLDER:aFolderInfo.fid,'FOLDER-ID':aFolder.ATTRIBUTES.UID});}}}
else
if(!aFolderInfo['fid']&&aFolderInfo['name']){aFolder=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0];var out=this.parse(aXMLResponse)[aFolderInfo['aid']][aFolder.ATTRIBUTES.UID];if(typeof aFolderInfo['channel']!='undefined')
out.RSS='true';srt={};tmp=dataSet.get(sDataSet,[aFolderInfo['aid']],true)||{};tmp[aFolder.ATTRIBUTES.UID]=out;srt[aFolderInfo['aid']]=tmp;if(aFolderInfo.type=='I'&&aFolderInfo.private){if(!srt[aFolderInfo['aid']][Path.split(aFolder.ATTRIBUTES.UID).shift()]){srt[aFolderInfo['aid']][Path.split(aFolder.ATTRIBUTES.UID).shift()]={SHARED:"true",OWNER:wm_folders.aux.private_owner,PRIVATE_ROOT:"true",SUBSCRIPTION_TYPE:"account",TYPE:'X'};}
if(!srt[aFolderInfo['aid']][Path.basedir(aFolder.ATTRIBUTES.UID)]){srt[aFolderInfo['aid']][Path.basedir(aFolder.ATTRIBUTES.UID)]={NAME:getLang('COMMON_FOLDERS::PRIVATE_ROOT'),TYPE:'Y'};}}
dataSet.add(sDataSet,[aFolderInfo['aid']],this.sort(srt)[aFolderInfo['aid']]);if(!aFolderInfo.bSkipNotify){Item.notify([aFolderInfo.aid,aFolder.ATTRIBUTES.UID],'ADD');}}
if(typeof aHandler=='object')
executeCallbackFunction(aHandler,aFolderInfo);return false;case'list':try{if(aIQAttribute['UID']){var aData=this.parse(aXMLResponse,true);if(aData[sPrimaryAccount])
await WMAccounts.__mapFolders(aData[sPrimaryAccount]);WMAccounts.__mergeDataset(aIQAttribute['UID'],aData[aIQAttribute['UID']]);if(sDataSet)
dataSet.add(sDataSet,[aIQAttribute['UID']],aData[aIQAttribute['UID']]);if(typeof aHandler=='object')
executeCallbackFunction(aHandler,aData);return true;}}
catch(e){console.log(this._name||false,e);}
return false;case'delete':try{if(aIQAttribute['TYPE']!='result'&&aIQAttribute['UID']){this.list({'aid':aIQAttribute['UID']},sDataSet,aDataPath);return true;}}
catch(e){console.log(this._name||false,e);}
var blank=true;var bPerfm=false;aDataSet=dataSet.get(sDataSet,[aFolderInfo['aid']]);for(i in aDataSet){if(i==aFolderInfo['fid']||i.indexOf(aFolderInfo['fid']+'/')===0){bPerfm=true;delete aDataSet[i];}
else
blank=false;}
if(!aFolderInfo.bSkipNotify){Item.notify([aFolderInfo.aid,aFolderInfo.fid],'DELETE');}
if(blank&&aFolderInfo['aid']==sPrimaryAccount+'_rss'){dataSet.remove('accounts',[aFolderInfo['aid']],true);dataSet.remove(sDataSet,[aFolderInfo['aid']]);}
else
if(bPerfm){dataSet.add(sDataSet,[aFolderInfo['aid']],aDataSet,true);dataSet.update(sDataSet,[aFolderInfo['aid']]);}
return false;case'empty':try{if(aIQAttribute['TYPE']!='result'&&aIQAttribute['UID']){aFolder=Path.split(aIQAttribute['UID']);this.list({'aid':aFolder[0]},sDataSet,aDataPath);aItems=dataSet.get('items');for(sAccId in aItems)
for(sFolId in aItems[sAccId]);if(sAccId==aFolder[0]&&sFolId==aFolder[1])
WMItems.list({'aid':sAccId,'fid':sFolId,'values':WMItems.default_values('M')},'items');return true;}
else
if(aIQAttribute['UID']){aFolder=Path.split(aIQAttribute['UID']);aItems=dataSet.get('items');for(sAccId in aItems)
for(sFolId in aItems[sAccId]);if(sAccId==aFolder[0]&&sFolId==aFolder[1])
dataSet.add('items',[aFolder[0],aFolder[1]],{});}}
catch(e){console.log(this._name||false,e);}
if(dataSet.get(sDataSet,[aFolderInfo['aid'],aFolderInfo['fid'],'RECENT'])>0)
dataSet.add(sDataSet,[aFolderInfo['aid'],aFolderInfo['fid'],'RECENT'],'0');if(typeof aHandler=='object')
executeCallbackFunction(aHandler,aIQAttribute['TYPE']=='result',aFolderInfo);return false;case'copyall':case'moveall':if(aFolderInfo['aid']){this.list({'aid':aFolderInfo['aid']},sDataSet,aDataPath);gui.frm_main._getNew();}
break;case'markread':if(aIQAttribute['TYPE']=='error')
return true;if(aFolderInfo.bRead){if(dataSet.get(sDataSet,[aFolderInfo['aid'],aFolderInfo['fid'],'RECENT'])>0)
dataSet.add(sDataSet,[aFolderInfo['aid'],aFolderInfo['fid'],'RECENT'],'0');}
else{var nCount=0;if(Is.Defined(aXMLResponse['IQ'][0]['QUERY'][0]['RECENT'])){nCount=parseInt(aXMLResponse['IQ'][0]['QUERY'][0]['RECENT']);if(!Is.Number(nCount))
nCount=0;}
i=dataSet.get(sDataSet,[aFolderInfo['aid'],aFolderInfo['fid'],'RECENT']);i=i>0?i:0;if(i!=nCount)
dataSet.add(sDataSet,[aFolderInfo['aid'],aFolderInfo['fid'],'RECENT'],nCount.toString());}
window.skipNewMailNotification=true;gui.frm_main._getNew();return true;default:if(typeof aHandler=='object')
executeCallbackFunction(aHandler,aIQAttribute['TYPE']=='result',aFolderInfo);}};_me.sort=function(aFolders)
{var aResult={},aResultFolFrame,aFolder,aFolderSplit,aSortInbox,aSortDefault,aSortGWDefault,aSortOthers,aSortShared,aCommon=getLang('COMMON_FOLDERS');var fld;for(var sAccId in aFolders){aSortInbox=[];aSortDefault=[];aSortGWDefault=[];aSortOthers=[];aSortShared=[];for(var sFolId in aFolders[sAccId]){if(sFolId=='__@@GWTRASH@@__'){aFolders[sAccId][sFolId]['NAME']=aCommon['GW-TRASH'];aSortOthers.push({'FOLDER':sFolId,'TITLE':aCommon['GW-TRASH']});continue;}
aFolderSplit=sFolId.split('/');if(aFolderSplit[0]=='INBOX'){if(aFolderSplit[0]==sFolId)
aFolders[sAccId][sFolId]['NAME']=aCommon['INBOX'];aFolderSplit[0]=aCommon['INBOX'];aSortInbox.push({'FOLDER':sFolId,'TITLE':aFolderSplit.join('/')});}
else
if(aFolderSplit[0]=='__@@VIRTUAL@@__'){if(aFolderSplit[0]==sFolId)
aFolders[sAccId][sFolId]['NAME']=aCommon['VIRTUAL-FOLDERS'];else
if(aFolderSplit[1]=='__@@EVENTS@@__')
aFolders[sAccId][sFolId]['NAME']=aCommon['CALENDARS'];aFolderSplit[0]=aCommon['VIRTUAL-FOLDERS'];aSortOthers.push({'FOLDER':sFolId,'TITLE':aFolderSplit.join('/')});}
else
if(aFolderSplit[0]=='SPAM_QUEUE'){if(aFolderSplit[1])
aFolders[sAccId][sFolId]['NAME']=aCommon['SPAM_QUEUE-'+aFolderSplit[1].toUpperCase()];aSortOthers.push({'FOLDER':sFolId,'TITLE':sFolId});}
else
if(aFolderSplit[0]=='Quarantine'&&aFolders[sAccId][sFolId].TYPE=='Q'){aFolders[sAccId][sFolId]['NAME']=aCommon['QUARANTINE'];aSortOthers.push({'FOLDER':sFolId,'TITLE':sFolId});}
else{if(aFolders[sAccId][sFolId].PRIVATE_ROOT){aFolders[sAccId][sFolId].TYPE='Y';}
var sort='';if(aFolders[sAccId][sFolId].TYPE=='I'){if((fld=Path.basedir(sFolId))&&!aFolders[sAccId][fld]){var val={TYPE:'Y'};if(aFolders[sAccId][sFolId].OWNER==wm_folders.aux.private_owner){val.NAME=aCommon['PRIVATE_ROOT'];sort='*';}
else
if(aFolders[sAccId][sFolId].OWNER&&~aFolders[sAccId][sFolId].OWNER.indexOf('@##internalservicedomain.icewarp.com##')){val.NAME=getLang('COMMON_FOLDERS::PRIVATE_ROOT_EXT',[sFolId.split('/')[0]]);sort='*'+fld;}
aFolders[sAccId][fld]=val;aSortOthers.push({'FOLDER':fld,'TITLE':sort||fld});sort='';}
if(aFolders[sAccId][sFolId].NAME)
sort=sFolId.substr(0,sFolId.lastIndexOf('/')+1)+aFolders[sAccId][sFolId].NAME;if(aFolders[sAccId][sFolId].OWNER&&~aFolders[sAccId][sFolId].OWNER.indexOf('@##internalservicedomain.icewarp.com##'))
sort='*'+(sort||sFolId);}
if(sFolId.indexOf(sPrimaryAccountSPREFIX)==0&&sFolId.indexOf('@')>0){aSortShared.push({'FOLDER':sFolId,'TITLE':aFolders[sAccId][sFolId].SORT||sFolId});if(aFolders[sAccId][sFolId].TYPE=='M'&&aFolderSplit[aFolderSplit.length-1]=='INBOX'&&(aFolderSplit[aFolderSplit.length-2]||'').indexOf('@')>-1)
aFolders[sAccId][sFolId].NAME=aCommon['INBOX'];else
if(!aFolderSplit[1])
aFolders[sAccId][sFolId].NAME=sFolId.substr(sPrimaryAccountSPREFIX.length);}
else
if(aFolders[sAccId][sFolId].TYPE=='M'&&(aFolders[sAccId][sFolId].DEFAULT||aFolders[sAccId][sFolId].SPAM)){aSortDefault.push({'FOLDER':sFolId,'TITLE':sFolId});}
else
if(aFolders[sAccId][sFolId].DEFAULT){aSortGWDefault.push({'FOLDER':sFolId,'TITLE':sFolId});}
else{aSortOthers.push({'FOLDER':sFolId,'TITLE':sort||sFolId});if(aFolders[sAccId][aFolderSplit[0]]&&aFolders[sAccId][aFolderSplit[0]].PUBLIC&&aFolderSplit[1]=='INBOX'&&aFolders[sAccId][sFolId].TYPE=='M'&&!aFolderSplit[2])
aFolders[sAccId][sFolId].NAME=aCommon['INBOX'];}}}
aSortInbox.sort(wm_folders.aux.sort);aSortDefault.sort(wm_folders.aux.sort);aSortGWDefault.sort(wm_folders.aux.sort);aSortOthers.sort(wm_folders.aux.sort);aSortShared.sort(wm_folders.aux.sort);var tmp,k;for(var i=0;i<aSortShared.length;i++){if(aSortShared[i].FOLDER.indexOf('/')>-1){fld=aSortShared[i].FOLDER.split('/'),tmp='',k=0;for(var j=0;j<=fld.length;j++){fld.pop();tmp=fld.join('/');if(tmp==''||(aSortShared[i-1]&&aSortShared[i-1].FOLDER==tmp))
break;aSortShared.splice(i,0,{FOLDER:tmp});k++;}
i+=k;}}
aResultFolFrame={};var n,sItem;for(n in aSortInbox){aFolder=aFolders[sAccId][aSortInbox[n]['FOLDER']];aResultFolFrame[aSortInbox[n]['FOLDER']]={};for(sItem in aFolder)
aResultFolFrame[aSortInbox[n]['FOLDER']][sItem]=aFolder[sItem];}
for(n in aSortDefault){aFolder=aFolders[sAccId][aSortDefault[n]['FOLDER']];aResultFolFrame[aSortDefault[n]['FOLDER']]={};for(sItem in aFolder)
aResultFolFrame[aSortDefault[n]['FOLDER']][sItem]=aFolder[sItem];}
for(n in aSortGWDefault){aFolder=aFolders[sAccId][aSortGWDefault[n]['FOLDER']];aResultFolFrame[aSortGWDefault[n]['FOLDER']]={};for(sItem in aFolder)
aResultFolFrame[aSortGWDefault[n]['FOLDER']][sItem]=aFolder[sItem];}
for(n in aSortOthers){aFolder=aFolders[sAccId][aSortOthers[n]['FOLDER']];if(!aFolder&&aSortOthers[n]['VALUES'])
aResultFolFrame[aSortOthers[n]['FOLDER']]=aSortOthers[n]['VALUES'];else{aResultFolFrame[aSortOthers[n]['FOLDER']]={};for(sItem in aFolder)
aResultFolFrame[aSortOthers[n]['FOLDER']][sItem]=aFolder[sItem];}}
for(n in aSortShared){aFolder=aFolders[sAccId][aSortShared[n]['FOLDER']];if(!aFolder&&aSortShared[n].FOLDER.indexOf(sPrimaryAccountSPREFIX)==0&&aSortShared[n].FOLDER.indexOf('@')>0){if(aSortShared[n].FOLDER.substr(sPrimaryAccountSPREFIX.length).indexOf('/')<1)
aResultFolFrame[aSortShared[n]['FOLDER']]={TYPE:'VA',NAME:aSortShared[n]['FOLDER'].substr(sPrimaryAccountSPREFIX.length)};else
aResultFolFrame[aSortShared[n]['FOLDER']]={};}
else
if(aFolder&&aFolder.SHARED)
aResultFolFrame[aSortShared[n]['FOLDER']]={TYPE:'VA'};else
aResultFolFrame[aSortShared[n]['FOLDER']]={};for(sItem in aFolder)
if(!aResultFolFrame[aSortShared[n]['FOLDER']][sItem])
aResultFolFrame[aSortShared[n]['FOLDER']][sItem]=aFolder[sItem];}
aResult[sAccId]=aResultFolFrame;}
return aResult;};_me.parse=function(aData)
{try
{var aAccFrame=aData['IQ'][0]['QUERY'][0]['ACCOUNT'][0],sAccId=aAccFrame['ATTRIBUTES']['UID'],aFolFrame=aAccFrame['FOLDER'],sFolId,aResult={},aResultAccFrame={},aResultFolFrame,aRights,i;var aTmp={C:'CONTACTS',E:'EVENTS',T:'TASKS',N:'NOTES',J:'JOURNAL',F:'FILES',D:'DRAFTS',H:'TRASH',S:'SENT'},sFolderType='';for(var nFolNum in aFolFrame){aResultFolFrame={};sFolId=aFolFrame[nFolNum]['ATTRIBUTES']['UID'].replace(/^\//,'');for(var sItem in aFolFrame[nFolNum])
if(sItem=='CHANNELS'){if(aFolFrame[nFolNum][sItem][0]&&aFolFrame[nFolNum][sItem][0].CHANNEL){aResultFolFrame[sItem]=[];aRights=aFolFrame[nFolNum][sItem][0].CHANNEL;for(i in aRights)
if(aRights[i].VALUE)
aResultFolFrame[sItem].push(aRights[i].VALUE);}}
else
if(sItem=='ACL'){if(aFolFrame[nFolNum][sItem][0]&&aFolFrame[nFolNum][sItem][0].RIGHT){aResultFolFrame[sItem]={};aRights=aFolFrame[nFolNum][sItem][0].RIGHT;for(i in aRights)
aResultFolFrame[sItem][aRights[i].ATTRIBUTES.EMAIL]={name:aRights[i].ATTRIBUTES.NAME,isGuest:aRights[i].ATTRIBUTES.ISGUEST,rights:aRights[i].VALUE?aRights[i].VALUE.split(''):[]};}}
else
if(sItem=='DEFAULT'&&sAccId==sPrimaryAccount&&aFolFrame[nFolNum].ATTRIBUTES.UID.indexOf(sPrimaryAccountSPREFIX)!==0){sFolderType=aFolFrame[nFolNum].TYPE[0].VALUE;if(sFolderType=='M')
sFolderType=aFolFrame[nFolNum][sItem][0].VALUE;if(!sFolderType||!aTmp[sFolderType]){continue;}
GWOthers.setItem('DEFAULT_FOLDERS',aTmp[sFolderType],sPrimaryAccount+'/'+aFolFrame[nFolNum].ATTRIBUTES.UID);aResultFolFrame[sItem]=aFolFrame[nFolNum][sItem][0]['VALUE'];}
else
if((sItem=='VIRTUAL'&&sAccId==sPrimaryAccount)||sItem=='SUBFOLDERS'){aResultFolFrame[sItem]={};if(aFolFrame[nFolNum][sItem][0].FOLDERS&&aFolFrame[nFolNum][sItem][0].FOLDERS[0].FOLDER){aResultFolFrame[sItem].FOLDERS={};var aFolers=aFolFrame[nFolNum][sItem][0].FOLDERS[0].FOLDER;for(i in aFolers)
if(!aFolers[i].ATTRIBUTES||!aFolers[i].ATTRIBUTES.NOEXIST)
aResultFolFrame[sItem].FOLDERS[aFolers[i].VALUE]=aFolers[i].ATTRIBUTES&&aFolers[i].ATTRIBUTES.PRIMARY?true:false;}
if(aFolFrame[nFolNum][sItem][0].SHARETYPE)
aResultFolFrame[sItem].SHARETYPE=aFolFrame[nFolNum][sItem][0].SHARETYPE[0].VALUE;if(aFolFrame[nFolNum][sItem][0].SEARCH)
aResultFolFrame[sItem].SEARCH=aFolFrame[nFolNum][sItem][0].SEARCH[0].VALUE;}
else
if(sItem!='ATTRIBUTES')
aResultFolFrame[sItem]=aFolFrame[nFolNum][sItem][0]['VALUE'];aResultAccFrame[sFolId]=aResultFolFrame;}
aResult[sAccId]=aResultAccFrame;return aFolFrame?this.sort(aResult):{};}
catch{return false;}};_me.__emptyFolder=async function(sAccId,sFolId,bMoveToTrash,sSQLsearch)
{var aTrashFolder,aHandler;if(this.getType([sAccId,sFolId])==='M'){await storage.library('gw_others');var aFolData=clone(dataSet.get('folders',[sAccId,sFolId]),true),aTrash=Path.split(GWOthers.getItem('DEFAULT_FOLDERS','trash'));aTrash={'aid':aTrash[0],'fid':aTrash[1]};if(bMoveToTrash){var aDestData=dataSet.get('folders',[aTrash.aid,aTrash.fid],true);if(Is.Defined(aDestData)&&Is.Defined(aFolData)){var iRec=parseInt(aFolData['RECENT']||0)+parseInt(aDestData['RECENT']||0),iOld=parseInt(dataSet.get('folders',[aTrash.aid,aTrash.fid,'RECENT'])||0);if(iRec!=iOld)
dataSet.add('folders',[aTrash.aid,aTrash.fid,'RECENT'],iRec.toString());}
aTrashFolder=aTrash;aHandler=[function(bOK){if(bOK){dataSet.add('folders',[sAccId,sFolId,'COUNT'],0);}}]}
else
if(aTrash.aid===sAccId&&aTrash.fid===sFolId)
aHandler=[function(bOK){if(bOK){dataSet.add('folders',[sAccId,sFolId,'COUNT'],0);WMAccounts.refresh({aid:aTrash.aid},'folders');}}];if(dataSet.get('folders',[sAccId,sFolId,'RECENT'])>0)
dataSet.add('folders',[sAccId,sFolId,'RECENT'],'0');var aMView=dataSet.get('preview');if(typeof aMView=='object'){for(var mwa in aMView)
for(var mwf in aMView[mwa]);if(mwa==sAccId&&mwf==sFolId)
dataSet.remove('preview');}}
this.empty({aid:sAccId,fid:sFolId,xmlarray:sSQLsearch&&{SEARCH:[{VALUE:sSQLsearch}]}},'folders','',aTrashFolder,aHandler);};_me.toTree=function(flat_list){var folders={};flat_list.forEach(function(folder){folder.split('/').reduce(function(previous,current){var name=previous+(previous?'/':'')+current;if(!folders[name]){var folder_data=dataSet.get('folders',[sPrimaryAccount,name]);if(folder_data)
folders[name]={full_path:name,name:current,children:[],type:folder_data.TYPE,owner:folder_data.OWNER,public:folder_data.PUBLIC,recent:folder_data.RECENT||0,rights:folder_data.RIGHTS};}
if(previous&&!~folders[previous].children.indexOf(folders[name])){folders[previous].children.push(folders[name]);}
return name;},'');});return folders;};_me.getUnsubscribedChatFolders=function(){var folders,unsubscribed;unsubscribed=(Object.keys(folders=dataSet.get('folders',[sPrimaryAccount]))).filter(function(name){return folders[name].TYPE==='I'&&(!folders[name].SYNC||folders[name].SYNC==='0');});dataSet.add('unsubscribed_rooms_count',false,unsubscribed.length);return unsubscribed;};_me._notify=function(sAction,args){gui.__exeEvent('folder',sAction,args);};_me._getFolderByRelativePath=function(aid,fid){var folders=dataSet.get('folders',[sPrimaryAccount]);for(var i in folders){if(folders[i].OWNER===aid&&folders[i].RELATIVE_PATH===Path.slash(fid)){return folders[i];}}};_me.getFolderName=function(aPath){var fid=Path.slash(aPath.fid);var ds=dataSet.get('folders',[aPath.aid,fid])||{};var name=ds.NAME||Path.basename(Path.slash(ds.RELATIVE_PATH||fid));if(~fid.indexOf('__@@VIRTUAL@@__/@@SUBTREE@@/')){ds=dataSet.get('folders',[aPath.aid,fid.replace(/__@@VIRTUAL@@__\/@@SUBTREE@@\//,'')])||{};name=ds.NAME||Path.basename(Path.slash(ds.RELATIVE_PATH||fid.replace(/__@@VIRTUAL@@__\/@@SUBTREE@@\//,'')));return getLang('COMMON_FOLDERS::SUBTREE',[name]);}
if(~fid.indexOf('__@@VIRTUAL@@__/@@PUBLIC@@/')){return getLang('COMMON_FOLDERS::ALL_FOLDERS',[fid.replace('__@@VIRTUAL@@__/@@PUBLIC@@/','').replace(/\/#\w/,'')]);}
if(~fid.indexOf('__@@VIRTUAL@@__/@@PERSONAL@@/#')){return getLang('COMMON_FOLDERS::ALL_PERSONAL');}
if(~fid.indexOf('__@@VIRTUAL@@__/@@SHARED@@/~')){var uid=fid.replace('__@@VIRTUAL@@__/@@SHARED@@/~','').replace(/\/#\w/,'');return getLang('COMMON_FOLDERS::ALL_FOLDERS',[dataSet.get('accounts',[uid,'USERNAME'])||uid]);}
switch(fid){case'@@UPLOAD@@':case'__@@UPLOAD@@__':return getLang('COMMON_FOLDERS::UPLOAD');case'__@@ARCHIVE@@__':return getLang('COMMON_FOLDERS::ALL_ARCHIVES');case'__@@SNOOZED@@__':return getLang('COMMON_FOLDERS::SNOOZED');}
return name;};_me.getFolderPath=function(aPath,delimiter){var account=aPath.aid;var path=Path.slash(aPath.fid).split('/');var folders=[];var sType=WMFolders.getType([account,path.join('/')]);if(Mapping.isGlobalSearchFolder(path.join('/'))){folders.push(WMFolders.getFolderName({aid:account,fid:path.join('/')}));}else{for(var i=0;i<path.length;i++){var name=(dataSet.get('folders',[account,path.slice(0,i+1).join('/')])||{}).NAME||path.slice(i,i+1)[0];if(!(sType==='E'&&name==='__@@VIRTUAL@@__')&&(name!=='SPAM_QUEUE')){name=name.replace('__@@VIRTUAL@@__',getLang('COMMON_FOLDERS::VIRTUAL-FOLDERS'));folders.push(WMFolders.getFolderName({fid:name}));}}
if(account!==sPrimaryAccount){folders.unshift(account);}}
return folders.filter(Boolean).join(delimiter||' / ');};_me.addToFavorites=function(aFolder,bSkipDashboardNotification){var favs=Cookie.get(['favorites'])||[];if(!favs.some(function(fav){return fav.arg.aid===aFolder.aid&&fav.arg.fid===aFolder.fid;})){favs.push({title:WMFolders.getFolderName(aFolder),arg:aFolder});}
Cookie.set(['favorites'],favs,true);if(!bSkipDashboardNotification&&gui.frm_main._dashboardLoaded()){gui.frm_main.dashboard._addFolderToFavorites({aid:aFolder.aid,fid:aFolder.fid});}};_me.removeFromFavorites=function(aFolder,bSkipDashboardNotification){var aData=Cookie.get(['favorites'])||[];for(var i=0;i<aData.length;i++){if(aData[i].arg&&aData[i].arg.aid==aFolder.aid&&aData[i].arg.fid==aFolder.fid){aData.splice(i,1);Cookie.set(['favorites'],aData,true);if(!bSkipDashboardNotification&&gui.frm_main._dashboardLoaded()){gui.frm_main.dashboard._removeFolderFromFavorites({aid:aFolder.aid,fid:aFolder.fid});}
break;}}};window.WMFolders=new wm_folders();

/* client/inc/wm_items.js */function wm_items(){this.xmlns='items';this.__clientID=function(id){return'*'+this.__serverID(id);};this.__serverID=function(id){return(id||'').replace(/^\*/,'');};this._stripPipe=function(s){return s.split('|')[0];};this.__defaultValues={'C':['ITMCLASSIFYAS','ITMTITLE','ITMFIRSTNAME','ITMMIDDLENAME','ITMSURNAME','ITMCLASS','ITMSUFFIX','ITMCOMPANY','ITMDEPARTMENT','LCTEMAIL1','LCTEMAIL2','LCTEMAIL3','LCTIM','ITMCATEGORY','LCTPHNWORK1','LCTPHNFAXWORK','LCTPHNHOME1','LCTPHNMOBILE'],'E':['EVNTITLE','EVNLOCATION','EVNSTARTDATE','EVNSTARTTIME','EVNENDDATE','EVNENDTIME','OSD','EVNOWN_ID','EVNRCR_ID','EVNGRP_ID','RMNEVN_ID','EVNTYPE','EVNCLASS','EVNFOLDER','EVNFLAGS','EVNMEETINGID','EVNSHARETYPE'],'EI':['EVNTITLE','EVNLOCATION','EVNSTARTDATE','EVNSTARTTIME','EVNENDDATE','EVNENDTIME','OSD','OED','EVNOWN_ID','EVNRCR_ID','EVNGRP_ID','RMNEVN_ID','EVNTIMEFORMAT','EVNTYPE','EVNCLASS','EVNFOLDER','EVNMEETINGID','EVNFLAGS','EVNSHARETYPE'],'J':['EVNTITLE','EVNLOCATION','EVNSTARTDATE','EVNSTARTTIME','EVNENDDATE','EVNENDTIME','EVNCONTACT','EVNTYPE'],'F':['EVNTITLE','EVNDESCFORMAT','EVNNOTE','EVNLOCATION','EVN_MODIFIED','EVNTYPE','EVNCOMPLETE','EVNLOCKOWN_ID','EVNEXPIRE','EVNOWN_ID','EVNURL','EVNDOCINVITE'],'R':['SUBJECT','TO','FROM','DATE','SIZE','FLAGS','HAS_ATTACHMENT','COLOR','PRIORITY','SMIME_STATUS'],'M':['SUBJECT','TO','SMS','FROM','DATE','SIZE','FLAGS','STATIC_FLAGS','HAS_ATTACHMENT','COLOR','PRIORITY','SMIME_STATUS','ITEM_MOVED','TAGS'],'T':['EVNTITLE','EVNSTATUS','EVNSTARTDATE','EVNENDDATE','EVNRCR_ID','RMNEVN_ID','EVNTYPE','EVNPRIORITY','EVNCOMPLETE'],'N':['EVNTITLE','EVNTYPE','EVN_MODIFIED'],'Q':['SNDEMAIL','SNDSUBJECT','QDATE','SNDOWNER','SNDDOMAIN'],'QL':['SNDEMAIL','SNDOWNER','SNDDOMAIN','QDATE'],'G':['ITM_ID','ITMTITLE','ITMDESCRIPTION','ITMCLASS','ITM_DELETED','ITMORIGINALFOLDER'],'I':['EVNTITLE','EVNDESCRIPTION']};};wm_items.inherit(wm_generic);_me=wm_items.prototype;_me.__lastListId={};_me.action=async function(aItemInfo,sAction,aHandler){var aIn,aValues,aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemInfo['fid']},"ITEM":[]}]}]},i;if(aItemInfo.values){aValues={};for(i in aItemInfo.values){if(!Is.Array(aValues[i]))
aValues[i]=[{VALUE:aItemInfo.values[i]}];}}
if(!Is.Array(aItemInfo['iid']))
aItemInfo['iid']=[aItemInfo['iid']];for(i in aItemInfo['iid']){aIn={"ATTRIBUTES":{"UID":this.__serverID(aItemInfo['iid'][i]),"ACTION":sAction}};if(aValues)
aIn.VALUES=[aValues];if(aItemInfo.attrs){for(i in aItemInfo.attrs){aIn[i]=[{VALUE:aItemInfo.attrs[i]}];}}
if(aItemInfo.nodes){for(var n in aItemInfo.nodes){if(Object.prototype.hasOwnProperty.call(aItemInfo.nodes,n))
aIn[n.toUpperCase()]=[{VALUE:aItemInfo.nodes[n]}];}}
aRequest.ACCOUNT[0].FOLDER[0].ITEM.push(aIn);}
if(!aHandler){var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}
catch(e){console.log(this._name||false,e);}
return false;}
else{this.create_iq(aRequest,[this,'response',['action','','','',aItemInfo,aHandler]],'','set');return true;}};_me.add=async function(id,aItemInfo,sDataSet,aDataPath,sFolderDataSet,aHandler,bAuto,aErrorHandler)
{function parse_addons(sAddOns,aFrom,aTo){if(typeof aFrom=='object'){var aFrame=aTo[sAddOns]=[{}];var sAddOn=sAddOns.substr(0,sAddOns.length-1);aFrame=aFrame[0][sAddOn]=[{}];var aValues,n;}
n=0;for(var sId in aFrom){aFrame[n]={};for(var sValues in aFrom[sId]){aValues=aFrom[sId][sValues];if(sValues=='uid')
aFrame[n]['ATTRIBUTES']={'UID':aValues};else
if(sValues=='values'){var aValuesFrame=aFrame[n]['VALUES']=[{}];parse_values(aValues,aValuesFrame[0]);}
else
parse_addons(sValues,aValues,aFrame[n]);}
n++;}};function parse_values(aFrom,aTo){for(var sValue in aFrom)
if(typeof aFrom[sValue]==='function')
continue;else
if(Is.Array(aFrom[sValue]))
aTo[sValue]=[{'VALUE':aFrom[sValue].pop()}];else
aTo[sValue]=[{'VALUE':aFrom[sValue]}];};if(!id[0]||!id[1])
return false;if(id[2]&&aItemInfo['values']&&(typeof aItemInfo['values']['flags']!='undefined')&&sDataSet){var nFlag=aItemInfo['values']['flags'];dataSet.add(sDataSet,id.concat(['FLAGS']),nFlag);if(sFolderDataSet){var nRecent=dataSet.get(sFolderDataSet,[id[0],id[1],'RECENT']);if(typeof nRecent=='undefined')
nRecent=0;if(this.hasFlag(nFlag,'SEEN')){if(nRecent)
nRecent--;}
else
nRecent++;if(parseInt(dataSet.get(sFolderDataSet,[id[0],id[1],'RECENT'])||0)!=nRecent)
dataSet.add(sFolderDataSet,[id[0],id[1],'RECENT'],nRecent.toString());}}
var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":id[0]},"FOLDER":[{"ATTRIBUTES":{"UID":id[1]},"ITEM":[]}]}]},ids,aFrame;if(!id[2])
ids=[''];else
if(Is.Array(id[2]))
ids=id[2];else
ids=[id[2]];for(var i=0;i<ids.length;i++){if(ids[i])
aFrame={ATTRIBUTES:{ACTION:'edit',UID:this.__serverID(ids[i])},VALUES:[{}]};else
aFrame={ATTRIBUTES:{ACTION:'add'},VALUES:[{}]};for(var sValues in aItemInfo)
if(sValues!='aid'&&sValues!='fid'&&sValues!='iid')
switch(sValues){case'values':parse_values(aItemInfo['values'],aFrame['VALUES'][0]);break;case'replace':aFrame.ATTRIBUTES.DUPLICITY='replace';break;case'duplicity':aFrame.ATTRIBUTES.DUPLICITY=aItemInfo[sValues];break;default:parse_addons(sValues,aItemInfo[sValues],aFrame);}
aFrame.ATTRIBUTES.DUPLICITY='rename';if(bAuto&&aFrame['VALUES'])
aFrame['VALUES'][0]['AUTO_SAVE']=[{VALUE:1}];if(aFrame['VALUES']){aFrame['VALUES'][0]['CTZ']=[{VALUE:new IcewarpDate().utcOffset()}];}
aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"].push(aFrame);}
if(!sDataSet&&!aHandler)
return this.parse(await this.create_iq(aRequest,'','','set'));else{this.create_iq(aRequest,[this,'response',['add',sDataSet,aDataPath,sFolderDataSet,{aid:id[0],fid:id[1],iid:id[2]},aHandler,{type:'add',args:arguments}]],aErrorHandler,'set');return true;}};_me.copy=async function(aItemsInfo,sDataSet,aDataPath,sFolderDataSet,aHandler)
{if(!aItemsInfo['aid']||!aItemsInfo['fid']||!aItemsInfo['folder'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[]}]}]},aFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"],bItems;for(var n in aItemsInfo['iid']){if(aItemsInfo['account'])
aFrame[n]={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":"copy"},"ACCOUNT":[{"VALUE":aItemsInfo['account']}],"FOLDER":[{"VALUE":aItemsInfo['folder']}]};else
aFrame[n]={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":"copy"},"FOLDER":[{"VALUE":aItemsInfo['folder']}]};if(aItemsInfo.duplicity)
aFrame[n].ATTRIBUTES.DUPLICITY=aItemsInfo.duplicity;if(aItemsInfo.rename)
aFrame[n].ATTRIBUTES.RENAME=aItemsInfo.rename;bItems=1;}
if(!bItems)return false;if(!sDataSet){var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}
catch(e){console.log(this._name||false,e);}
return false;}
else{this.create_iq(aRequest,[this,'response',['copy',sDataSet,aDataPath,sFolderDataSet,aItemsInfo,aHandler,{type:'copy',args:arguments}]],'','set');return true;}};_me.move=function(aItemsInfo,sDataSet,aDataPath,sFolderDataSet,aHandler)
{if(!aItemsInfo['aid']||!aItemsInfo['fid']||!aItemsInfo['folder'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[]}]}]},aFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"],bItems;for(var n in aItemsInfo['iid']){if(aItemsInfo['account'])
aFrame[n]={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":"move"},"ACCOUNT":[{"VALUE":aItemsInfo['account']}],"FOLDER":[{"VALUE":aItemsInfo['folder']}]};else
aFrame[n]={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":"move"},"FOLDER":[{"VALUE":aItemsInfo['folder']}]};if(aItemsInfo.duplicity)
aFrame[n].ATTRIBUTES.DUPLICITY=aItemsInfo.duplicity;if(aItemsInfo.rename)
aFrame[n].ATTRIBUTES.RENAME=aItemsInfo.rename;bItems=1;}
if(!bItems)return false;return this.create_iq(aRequest,[this,'response',['move',sDataSet,aDataPath,sFolderDataSet,aItemsInfo,aHandler,{type:'move',args:arguments}]],'','set');};_me.snooze=function(aItemsInfo,aHandler){var aRequest={ACCOUNT:[{ATTRIBUTES:{UID:aItemsInfo.aid},FOLDER:[{ATTRIBUTES:{UID:aItemsInfo.fid},ITEM:[]}]}]};var aFrame=aRequest.ACCOUNT[0].FOLDER[0].ITEM;for(var n in aItemsInfo.iid){aFrame[n]={ATTRIBUTES:{UID:this.__serverID(aItemsInfo.iid[n]),ACTION:aItemsInfo.timestamp?'snooze':'unsnooze'},VALUES:aItemsInfo.timestamp?[{timestamp:[{VALUE:aItemsInfo.timestamp}]}]:void 0};}
return this.create_iq(aRequest,[this,'response',['snooze','items','','folders',aItemsInfo,aHandler,{type:'snooze',args:arguments}]],'','set');};_me.getFlag=function(id,sFlagName,sDataSet){var nFlag=this._getFlagValue(id,sDataSet,'FLAGS');if(!Is.Defined(nFlag))return false;return this.hasFlag(nFlag,sFlagName);};_me.hasFlag=function(nFlag,sFlagName)
{switch(sFlagName){case'ANSWERED':nFlag&=1;break;case'DELETED':nFlag&=2;break;case'DRAFT':nFlag&=4;break;case'FLAGGED':nFlag&=8;break;case'RECENT':nFlag&=16;break;case'SEEN':nFlag&=32;break;case'FORWARDED':nFlag&=64;break;case'COMPLETED':nFlag&=128;break;default:return false;}
return(nFlag)?true:false;};_me.setFlag=async function(aItemsInfo,aFlagsSet,sDataSet,sFolderDataSet)
{function _setFlag(nFlag,sFlagName,bValue){switch(sFlagName){case'ANSWERED':return(bValue?nFlag|33:nFlag&~1);case'DELETED':return(bValue?nFlag|2:nFlag&~2);case'DRAFT':return(bValue?nFlag|4:nFlag&~4);case'FLAGGED':return(bValue?nFlag|8:nFlag&~8);case'RECENT':return(bValue?nFlag|16:nFlag&~16);case'SEEN':return(bValue?nFlag|32:nFlag&~32);case'FORWARDED':return(bValue?nFlag|96:nFlag&~64);case'COMPLETED':return(bValue?nFlag|128:nFlag&~128);}
return nFlag;}
var sFlagType='FLAGS',sFlagValue='',i;if(count(aFlagsSet)==1)
for(i in aFlagsSet){if(aFlagsSet[i])
sFlagType='SET_FLAG';else
sFlagType='CLEAR_FLAG';sFlagValue=_setFlag(0,i,true);}
if(!aItemsInfo['aid']||!aItemsInfo['fid']||!aItemsInfo['iid']||typeof aItemsInfo['iid']!='object'||Is.Empty(aItemsInfo['iid']))
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[]}]}]};var aItemFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"],nFlag,nNewFlag,nCounter=0,bUpdate=false,tmp;for(var n in aItemsInfo['iid'])
{nFlag=this._getFlagValue([aItemsInfo['aid'],aItemsInfo['fid'],aItemsInfo['iid'][n]],sDataSet,'FLAGS');if(typeof nFlag=='undefined')
nFlag=0;nNewFlag=nFlag;for(var sFlagName in aFlagsSet)
nNewFlag=_setFlag(nNewFlag,sFlagName,aFlagsSet[sFlagName]);if(nNewFlag!=nFlag)
{var folders=dataSet.get(sDataSet,[aItemsInfo.aid]);aItemsInfo.folders=aItemsInfo.folders||[aItemsInfo.fid];for(i in folders){if(folders[i][aItemsInfo.iid[n]]){!~aItemsInfo.folders.indexOf(i)&&aItemsInfo.folders.push(i);dataSet.add(sDataSet,[aItemsInfo.aid,i,aItemsInfo.iid[n],'FLAGS'],nNewFlag,true);}}
tmp={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":"edit"},"VALUES":[{}]};tmp.VALUES[0][sFlagType]=[{"VALUE":sFlagValue||nNewFlag}];aItemFrame.push(tmp);nCounter++;bUpdate=true;}}
if(bUpdate){if(aItemsInfo['iid'].length==1){aItemsInfo.folders.forEach(function(folder){dataSet.update(sDataSet,[aItemsInfo['aid'],folder,aItemsInfo['iid'][0],'FLAGS']);});}
else
dataSet.update(sDataSet);}
if(sFolderDataSet&&nCounter>0&&aItemsInfo.fid!=='__@@SNOOZED@@__')
{var nRecent=parseInt(dataSet.get(sFolderDataSet,[aItemsInfo['aid'],aItemsInfo['fid'],'RECENT'])||0);if(this.hasFlag(nNewFlag,'SEEN'))
dataSet.add(sFolderDataSet,[aItemsInfo['aid'],aItemsInfo['fid'],'RECENT'],(nRecent-nCounter>0?nRecent-nCounter:0).toString());else
dataSet.add(sFolderDataSet,[aItemsInfo['aid'],aItemsInfo['fid'],'RECENT'],(nRecent+nCounter).toString());}
if(dataSet.get('active_folder')===aItemsInfo.aid+'/'+aItemsInfo.fid){dataSet.add('temp',['includeIds'],aItemsInfo.iid);}
if(!nCounter)
return false;if(!sDataSet)
return this.parse(await this.create_iq(aRequest,'','','set'));else
{this.create_iq(aRequest,[this,'response',['edit',sDataSet,'',sFolderDataSet,{'aid':aItemsInfo['aid']}]],'','set');return true;}};_me.getStaticFlag=function(id,sFlagName,sDataSet)
{var nFlag=this._getFlagValue(id,sDataSet,'STATIC_FLAGS');if(typeof nFlag!='undefined')
return false;switch(sFlagName)
{case'HTMLBODY':return nFlag&1;case'CACHED':return nFlag&2;}
return false;};_me._getFlagValue=function(id,sDataSet,sFlagType)
{if(!sDataSet||!sFlagType)
return false;return dataSet.get(sDataSet,id.concat([sFlagType]));};_me.quarantine=async function(aItemsInfo,sDataSet,aDataPath,sFolderDataSet)
{if(!aItemsInfo['aid']||!aItemsInfo['fid']||!aItemsInfo['action'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[]}]}]};var aFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"];var bItems;for(var n in aItemsInfo['iid']){aFrame[n]={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":aItemsInfo['action']}};bItems=1;}
if(!bItems)
return false;var aResponse=await this.create_iq(aRequest,'','','set');try{if(sDataSet)
this.response({"Array":aResponse},'quarantine',sDataSet,aDataPath,sFolderDataSet,{'aid':aItemsInfo['aid'],'fid':aItemsInfo['fid']});else
if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')return true;}
catch(e){console.log(this._name||false,e);}
return false;};_me.recover=async function(aItemsInfo,sDataSet,aDataPath,sFolderDataSet,aFoldersMapping)
{var aFrame,aResponse,aRequest,bItems,n,i;aFoldersMapping=aFoldersMapping||[];if(!aItemsInfo['aid']||!aItemsInfo['fid']||!aItemsInfo['action'])
return false;aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[]}]}]};aFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"];for(n in aItemsInfo['iid']){aFrame[n]={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":aItemsInfo['action']}};bItems=1;}
if(aFoldersMapping.length>0){aFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["FOLDERMAPPING"]=[];}
for(i=0;i<aFoldersMapping.length;i++){aFrame.push({'ATTRIBUTES':{'SOURCE':aFoldersMapping[i].source,'DESTINATION':aFoldersMapping[i].destination}});}
if(!bItems)
return false;aResponse=await this.create_iq(aRequest,'','','set');try{if(sDataSet)
this.response({"Array":aResponse},'recover',sDataSet,aDataPath,sFolderDataSet,{'aid':aItemsInfo['aid'],'fid':aItemsInfo['fid']});else
if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')return true;}
catch(e){console.log(this._name||false,e);}
return false;};_me.imip=function(aItemInfo,sAction,aHandler)
{if(!aItemInfo['aid']||!aItemInfo['fid']||!aItemInfo['iid'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemInfo['fid']},"ITEM":[{"ATTRIBUTES":{"UID":this.__serverID(aItemInfo['iid']),"ACTION":sAction}}]}]}]};var aItemRequest=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"][0];if(!aItemInfo['destination'])
switch(aItemInfo['imip_type']){case'VEVENT':aItemInfo['destination']=Mapping.getDefaultFolderForGWType('E');break;case'VTODO':aItemInfo['destination']=Mapping.getDefaultFolderForGWType('T');break;case'VJOURNAL':aItemInfo['destination']=Mapping.getDefaultFolderForGWType('J');break;}
aItemRequest["FOLDER"]=[{"VALUE":aItemInfo['destination']}];if(aItemInfo['partid'])
aItemRequest["PARTID"]=[{"VALUE":aItemInfo['partid']}];if(aItemInfo['reason']!==void 0){aItemRequest["VALUES"]=aItemRequest["VALUES"]||[{}];aItemRequest["VALUES"][0].REASON=[{"VALUE":aItemInfo['reason']}];}
if(aItemInfo['EXPDATE']){aItemRequest["VALUES"]=aItemRequest["VALUES"]||[{}];aItemRequest["VALUES"][0].EXPDATE=[{"VALUE":aItemInfo['EXPDATE']}];}
if(aItemInfo['EXPFOLLOWING']){aItemRequest["VALUES"]=aItemRequest["VALUES"]||[{}];aItemRequest["VALUES"][0].EXPFOLLOWING=[{"VALUE":aItemInfo['EXPFOLLOWING']}];}
if(aItemInfo['gwparams']){aItemRequest["GWPARAMS"]=[{}];for(var param in aItemInfo['gwparams'])
aItemRequest["GWPARAMS"][0][param]=[{"VALUE":aItemInfo['gwparams'][param]}];}
this.create_iq(aRequest,[this,'response',[sAction,'','','',{aid:aItemInfo['aid'],fid:aItemInfo['fid'],iid:[aItemInfo['iid']]},aHandler]],'','set');return true;};_me.certificate=function(aItemInfo,aHandler)
{if(!aItemInfo['aid']||!aItemInfo['fid']||!aItemInfo['iid'])
return false;var aRequest={ACCOUNT:[{"ATTRIBUTES":{"UID":aItemInfo['account']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemInfo['folder']},"ITEM":[{"ATTRIBUTES":{"UID":this.__serverID(aItemInfo['item']),"ACTION":'certificate'},CONTACT:[{ACCOUNT:[{VALUE:aItemInfo['aid']}],FOLDER:[{VALUE:aItemInfo['fid']}],ITEM:[{VALUE:this.__serverID(aItemInfo['iid'])}]}]}]}]}]};this.create_iq(aRequest,[this,'response',['certificate','','','',aItemInfo,aHandler]],'','set');return true;};_me.reminders=function(aItemsInfo,aHandler)
{if(!aItemsInfo['rid'].length)
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":sPrimaryAccount},"FOLDER":[{"ATTRIBUTES":{"UID":'__@@REMINDERS@@__'},"ITEM":[]}]}]};var ctz=new IcewarpDate().utcOffset();for(var i in aItemsInfo['rid']){aRequest.ACCOUNT[0].FOLDER[0].ITEM.push({ATTRIBUTES:{UID:this.__serverID(aItemsInfo['rid'][i]),ACTION:typeof aItemsInfo['snooze']!='undefined'?'snooze':'dismiss'},VALUES:[{CTZ:[{VALUE:ctz}],TIMESTAMP:[{VALUE:(new IcewarpDate()).unix()}]}]});if(typeof aItemsInfo['snooze']!='undefined')
aRequest.ACCOUNT[0].FOLDER[0].ITEM[aRequest.ACCOUNT[0].FOLDER[0].ITEM.length-1].VALUES[0].MINUTES=[{VALUE:aItemsInfo['snooze']}];}
this.create_iq(aRequest,[this,'response',['reminders','','','',aItemsInfo,aHandler]],'','set');return true;};_me.redirect=async function(aItemInfo,sDataSet,aDataPath,aHandler)
{if(!aItemInfo['aid']||!aItemInfo['fid']||!aItemInfo['iid']||(!aItemInfo['to']&&!aItemInfo['distrib']))
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemInfo['fid']},"ITEM":[{"ATTRIBUTES":{"UID":this.__serverID(aItemInfo['iid']),"ACTION":"redirect"}}]}]}]};var aItemRequest=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"][0];if(aItemInfo['to'])
aItemRequest["TO"]=[{"VALUE":aItemInfo['to']}];if(aItemInfo['distrib'])
{aItemRequest["ACCOUNT"]=[];var aAccRequest=aItemRequest["ACCOUNT"];var aFolRequest,aToRequest;var aDistribFrame=aItemInfo['distrib'];var aAccFrame;for(var sAccId in aDistribFrame)
{aAccFrame=aDistribFrame[sAccId];aFolRequest=[];for(var sFolId in aAccFrame){var aFolFrame=aAccFrame[sFolId];aToRequest=[];for(var n in aFolFrame)
aToRequest.push({"VALUE":aFolFrame[n]});aFolRequest.push({"ATTRIBUTES":{"UID":sFolId},"TO":aToRequest});}
aAccRequest.push({"ATTRIBUTES":{"UID":sAccId},"FOLDER":aFolRequest});}}
if(!sDataSet){var aResponse=await this.create_iq(aRequest,'','','set');try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}
catch(e){console.log(this._name||false,e);}
return false;}
else{this.create_iq(aRequest,[this,'response',['redirect',sDataSet,aDataPath,'',{'aid':aItemInfo['aid'],'fid':aItemInfo['fid']},aHandler]],'','set');return true;}};_me.remove=async function(aItemsInfo,sDataSet,aDataPath,sFolderDataSet,aHandler){function parse_values(aFrom,aTo){for(var sValue in aFrom)
if(typeof aFrom[sValue]=='object')
aTo[sValue]=[{'VALUE':aFrom[sValue].pop()}];else
aTo[sValue]=[{'VALUE':aFrom[sValue]}];};if(!aItemsInfo['aid']||!aItemsInfo['fid'])return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[]}]}]};var aFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"];var bItems=0;var bValue=Is.Object(aItemsInfo['values']);for(var n in aItemsInfo['iid']){aFrame[n]={"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][n]),"ACTION":"delete"}};bItems++;if(bValue&&Is.Object(aItemsInfo['values'][n])){aFrame[n]['VALUES']=[{}];parse_values(aItemsInfo['values'][n],aFrame[n]['VALUES'][0]);}}
if(!bItems)
return false;if(aHandler)
this.create_iq(aRequest,[this,'response',['remove',sDataSet,aDataPath,sFolderDataSet,aItemsInfo,aHandler,aRequest]],'','set');else{var aResponse=await this.create_iq(aRequest,'','','set');try{if(sDataSet)
this.response({'Array':aResponse},'remove',sDataSet,aDataPath,sFolderDataSet,aItemsInfo);else
if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result'){this._notify('remove',aItemsInfo);return true;}}
catch(e){console.log(this._name||false,e);}
return false;}};_me.save_items=function(aItemsInfo)
{if(!aItemsInfo['aid']||!aItemsInfo['fid'])
return false;var aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[]}]}]};for(var i in aItemsInfo['iid'])
aRequest.ACCOUNT[0].FOLDER[0].ITEM.push({"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'][i]),"ACTION":'save_items'}});this.create_iq(aRequest,[this,'response',['save_items','','','','',true]],'','set');return true;};_me.list=async function(aItemsInfo,sDataSet,aDataPath,sFolderDataSet,aHandler,aErrorHandler)
{if(!aItemsInfo['aid']||!aItemsInfo['fid'])
return false;var aRequest;if(aItemsInfo['iid']){if(aItemsInfo['atid'])
aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[{"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid']),"ATID":aItemsInfo['atid']}}]}]}]};else
aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[{"ATTRIBUTES":{"UID":this.__serverID(aItemsInfo['iid'])}}]}]}]};if(aItemsInfo['date'])
aRequest.ACCOUNT[0].FOLDER[0].ITEM[0].ATTRIBUTES.DATE=aItemsInfo['date'];}
else
if(aItemsInfo['rid']){aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']},"ITEM":[{"ATTRIBUTES":{"RID":this.__serverID(aItemsInfo['rid'])}}]}]}]};}
else{aRequest={"ACCOUNT":[{"ATTRIBUTES":{"UID":aItemsInfo['aid']},"FOLDER":[{"ATTRIBUTES":{"UID":aItemsInfo['fid']}}]}]};var iDay;if(!window.gui.frm_main.__trash_cleaned){var aTrashFolder=Path.split(GWOthers.getItem('DEFAULT_FOLDERS','trash'));if(typeof aTrashFolder=='object'&&aItemsInfo['aid']==aTrashFolder[0]&&aItemsInfo['fid']==aTrashFolder[1]){iDay=0;if(GWOthers.getItem('MAIL_SETTINGS_GENERAL','autoclear_trash')>0&&(iDay=parseInt(GWOthers.getItem('MAIL_SETTINGS_GENERAL','autoclear_trash_days')||0))>0){aRequest.ACCOUNT[0].FOLDER[0].CLEANUP=[{VALUE:parseInt(iDay)}];window.gui.frm_main.__trash_cleaned=true;}}}
if(!window.gui.frm_main.__gwtrash_cleaned){if(aItemsInfo['aid']==sPrimaryAccount&&aItemsInfo['fid']=='__@@GWTRASH@@__'){iDay=0;if(GWOthers.getItem('CALENDAR_SETTINGS','autoclear_trash')>0&&(iDay=parseInt(GWOthers.getItem('CALENDAR_SETTINGS','autoclear_trash_days')||0))>0){aRequest.ACCOUNT[0].FOLDER[0].CLEANUP=[{VALUE:parseInt(iDay)}];window.gui.frm_main.__gwtrash_cleaned=true;}}}}
var aFrame;var bBody;var aValFrame={};if(aItemsInfo['values'])
{for(var nIndex in aItemsInfo['values']){aValFrame[aItemsInfo['values'][nIndex]]=[aItemsInfo['custom_values']&&aItemsInfo['custom_values'][aItemsInfo['values'][nIndex]]?{"VALUE":aItemsInfo['custom_values'][aItemsInfo['values'][nIndex]]}:{}];if(~['CLEAN_HTML','HTML','TEXT'].indexOf(aItemsInfo['values'][nIndex]))
bBody=true;}
if(bBody&&aItemsInfo['iid']&&sDataSet&&aItemsInfo['iid'].indexOf('|')<0){if(this.getFlag([aItemsInfo['aid'],aItemsInfo['fid'],aItemsInfo['iid']],'SEEN','items')==false)
{var nFlags=dataSet.get('items',[aItemsInfo['aid'],aItemsInfo['fid'],aItemsInfo['iid'],'FLAGS']);if(typeof nFlags!='undefined')
{dataSet.add(sDataSet,[aItemsInfo['aid'],aItemsInfo['fid'],aItemsInfo['iid'],'FLAGS'],nFlags|32);if(sFolderDataSet&&((WMFolders.getRights(aItemsInfo,'write')||WMFolders.getRights(aItemsInfo,'owner')))){var nRecent=parseInt(dataSet.get(sFolderDataSet,[aItemsInfo['aid'],aItemsInfo['fid'],'RECENT'])||0);if(nRecent>0)
dataSet.add(sFolderDataSet,[aItemsInfo['aid'],aItemsInfo['fid'],'RECENT'],(--nRecent).toString());}}}}}
if(!aItemsInfo['iid']&&!aItemsInfo['rid'])
aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"]=[{}];aFrame=aRequest["ACCOUNT"][0]["FOLDER"][0]["ITEM"][0];aValFrame['CTZ']=[{VALUE:new IcewarpDate().utcOffset()}];aFrame["VALUES"]=[aValFrame];if(aItemsInfo['locations'])
aFrame["LOCATIONS"]=[{VALUE:''}];var bFilter=0;var excludedIds=dataSet.get('removedFromDataset',[aItemsInfo.aid,aItemsInfo.fid])||[];if(excludedIds.length){aItemsInfo.filter=aItemsInfo.filter||{};aItemsInfo.filter.exclude_ids=excludedIds.map(function(iid){return WMItems.__serverID(iid.split('/').pop());}).join(',');}
if(aItemsInfo['filter']){var aFilFrame={};for(var sFilter in aItemsInfo['filter']){switch(sFilter){case'sort':aFilFrame[sFilter]=[{}];var f=aItemsInfo['filter'][sFilter];if(Is.String(f)){f=f.split(',');for(var i in f){f[i]=f[i].trim().split(/\s+/);if(f[i][0])
aFilFrame[sFilter][0][f[i][0]]=[{"VALUE":f[i][1]||'asc'}];}}
break;default:aFilFrame[sFilter]=[{"VALUE":aItemsInfo['filter'][sFilter]}];break;}
bFilter=1;}
if(bFilter)
aFrame["FILTER"]=[aFilFrame];}
if(!sDataSet&&!aHandler){return this.parse(await this.create_iq(aRequest),(typeof aItemsInfo.iid=='undefined'?true:false));}
else{if(sDataSet){this.__lastListId[sDataSet]={id:unique_id(),handler:this.__lastListId[sDataSet]?this.__lastListId[sDataSet].handler:[]};if(aHandler)
this.__lastListId[sDataSet].handler.push(aHandler);}
return await this.create_iq(aRequest,[this,'response',['list',sDataSet,aDataPath,sFolderDataSet,{'aid':aItemsInfo['aid'],'fid':aItemsInfo['fid'],'iid':aItemsInfo['iid'],'filter':bFilter},aHandler]],aErrorHandler,'get',sDataSet?this.__lastListId[sDataSet].id:'');}};_me.response=async function(aData,sMethodName,sDataSet,aDataPath,sFolderDataSet,aArgs,aHandler,aOrgRequest)
{var aXMLResponse=aData['Array'],aIQAttribute=aXMLResponse['IQ'][0]['ATTRIBUTES'];var str,att,aOut,bOk,n,sAccId,sFolId,i,iids,include_ids;switch(sMethodName){case'save_items':if(aIQAttribute['TYPE']=='result'){try{aOut={'class':aXMLResponse.IQ[0].RESULT[0].ACCOUNT[0].FOLDER[0].ITEM[0].VALUES[0].CLASS[0].VALUE,'fullpath':aXMLResponse.IQ[0].RESULT[0].ACCOUNT[0].FOLDER[0].ITEM[0].VALUES[0].FULLPATH[0].VALUE};}
catch{break;}
if(Is.Object(aHandler))
executeCallbackFunction(aHandler,aOut);else{aOut['dlsess']=dataSet.get('main',['dlsess']);downloadItem(buildURL(aOut));}}
break;case'reminders':if(aHandler){if(aIQAttribute['TYPE']=='result')
pushParameterToCallback(aHandler,true);else
pushParameterToCallback(aHandler,false);executeCallbackFunction(aHandler);}
break;case'certificate':if(aHandler){if(aIQAttribute['TYPE']=='result')
pushParameterToCallback(aHandler,{data:aArgs});else
pushParameterToCallback(aHandler,{error:aXMLResponse.IQ[0].ERROR[0].ATTRIBUTES.UID});executeCallbackFunction(aHandler);}
break;case'accept_counter':case'decline_counter':case'accept':case'tentative':case'decline':case'propose':if(aIQAttribute['TYPE']=='result'){executeCallbackFunction(aHandler,true,false);this._notify('edit',aArgs);}
else{try{att=aXMLResponse.IQ[0].ERROR[0].ATTRIBUTES.UID;str=aXMLResponse.IQ[0].ERROR[0].VALUE;}
catch{str=att='';}
switch(att.toLowerCase()){case'imip_obsolete':gui.notifier._value({type:'alert',args:{header:'',text:'IMIP::OBSOLETE'}});executeCallbackFunction(aHandler,false,true);break;case'imip_no_access_permissions':gui.notifier._value({type:'alert',args:{header:'',text:'IMIP::IMIP_NO_ACCESS_PERMISSIONS'}});executeCallbackFunction(aHandler,false,false);break;case'imip_unknown_attendee':if(sMethodName!='decline')
gui.notifier._value({type:'info',args:{header:'',text:'IMIP::UNKNOWN_ATTENDEE'}});executeCallbackFunction(aHandler,false,true);break;case'imip_versit_empty':gui.notifier._value({type:'alert',args:{header:'',text:'IMIP::MALFORMED'}});break;case'folder_insufficient_rights':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::folder_insufficient_rights'}});break;case'folder_does_not_exist':gui.notifier._value({type:'alert',args:{header:'',text:'IMIP::FOLDER_NOT_EXIST',args:[str.unescapeHTML()]}});break;}}
break;case'edit':if(aIQAttribute['TYPE']!='result'){return;}
case'add':case'list':if(aIQAttribute['TYPE']!='result'){bOk=false;try{att=aXMLResponse.IQ[0].ERROR[0].ATTRIBUTES.UID;str=aXMLResponse.IQ[0].ERROR[0].VALUE;}
catch{str=att='';}
switch(att.toLowerCase()){case'folder_does_not_exist':gui.notifier._value({type:'alert',args:{header:'',text:'IMIP::FOLDER_NOT_EXIST',args:[str?str.unescapeHTML().trim():'']}});break;case'item_invalid_id':break;case'attendee_email_invalid':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::ATTENDEE_INVALID',args:str?[str.unescapeHTML().trim()]:null}});break;case'attachment_blocked_by_filters':gui.notifier._value({type:'alert',args:{header:'ALERTS::ATTACHMENT_FILTER',text_plain:(str?"\n"+str.unescapeHTML():'').trim()}});break;case'attachment_virus':gui.notifier._value({type:'alert',args:{header:'ALERTS::ATTACHMENT_VIRUS',text_plain:(str?"\n"+str.unescapeHTML():'').trim()}});break;case'attachment_groupware_general':case'attachment_webdav_disabled':case'attachment_file_not_found':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::ATTACHMENT_MISSING'}});break;case'attachment_quota_exceeded':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::ATTACHMENT_QUOTA'}});break;case'attachment_size':gui.notifier._value({type:'alert',args:{header:'ALERTS::ATTACHMENT_SIZE',text_plain:(str?"\n"+str.unescapeHTML():'').trim()}});break;case'mailbox_quota_limit':gui.notifier._value({type:'alert',args:{header:'ALERTS::MAILBOX_QUOTA_LIMIT',text_plain:(str?"\n"+str.unescapeHTML():'').trim()}});break;case'smtp_recipients_failed':gui.notifier._value({type:'alert',args:{header:'ALERTS::SMTP_RECIPIENTS_FAILED',text_plain:(str?"\n"+str.unescapeHTML():'').trim()}});bOk=true;break;case'item_edit':if(WMFolders.getType(aArgs)==='C'){gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::COULD_NOT_EDIT_CONTACT'}});}else{gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::COULD_NOT_EDIT'}});}
break;case'item_create':break;case'item_edit_groupchat_attendee':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::ITEM_EDIT_GROUPCHAT_ATTENDEE'}});break;case'imap_fileid_sync_failed':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::IMAP_FILEID_SYNC_FAILED'}});break;case'default_folder_missing':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::DEFAULT_FOLDER_MISSING',args:[str?Mapping.getDefaultFolderForGWType(str):'']}});break;case'items_duplicity':if(aOrgRequest&&aXMLResponse.IQ[0].ERROR[0].DUPLICATE){gui._create('duplicity','frm_duplicity','','',{duplicate:aXMLResponse.IQ[0].ERROR[0].DUPLICATE[0],request:aOrgRequest});bOk=2;break;}
case'imip_no_gw_service':gui.notifier._value({type:'alert',args:{header:'',text:'IMIP::IMIP_NO_GW_SERVICE'}});break;case'imip_no_access_permissions':gui.notifier._value({type:'alert',args:{header:'',text:'IMIP::IMIP_NO_ACCESS_PERMISSIONS'}});break;default:if(sFolderDataSet){await WMFolders.list({'aid':aArgs['aid']},sFolderDataSet);}
else
if(sDataSet){dataSet.remove(sDataSet,aDataPath);dataSet.update(sDataSet);}
switch(att.toLowerCase()){case'folder_insufficient_rights':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::'+att}});break;case'imap_internal':gui.notifier._value({type:'alert',args:{header:'',text_plain:str?str.unescapeHTML():''}});break;default:var err=str?att+': '+str:att;if(err.indexOf('E_')!==0){if(getLang('ALERTS::'+err,false,2)!==""){gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::'+err}});}else if(getLang('ERROR::'+err,false,2)!==""){gui.notifier._value({type:'alert',args:{header:'',text:'ERROR::'+err}});}else{gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::GENERAL_ERROR',args:[err]}});}}}}}
else
{bOk=true;if(sMethodName=='list'){if(sDataSet&&aIQAttribute['UID']&&aIQAttribute['UID']!=(this.__lastListId[sDataSet]||{}).id)
return;var parsedXMLResponse=this.parse(aXMLResponse,(typeof aArgs['iid']=='undefined'?true:false));if(Cookie)
try{var sRight=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].ATTRIBUTES.RIGHTS,sPrima=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].ATTRIBUTES.PRIMARY;sAccId=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].ATTRIBUTES.UID;sFolId=aXMLResponse.IQ[0].QUERY[0].ACCOUNT[0].FOLDER[0].ATTRIBUTES.UID;sRight=sRight?sRight.split(''):'';if(sPrima)
Cookie.set(['rights',sAccId,sPrima],sRight);Cookie.set(['rights',sAccId,sFolId],sRight);}
catch(r){console.log(this._name||false,r);}
if(sDataSet){dataSet.add(sDataSet,aDataPath,parsedXMLResponse,true);dataSet.update(sDataSet);}
if(sDataSet&&aIQAttribute['UID']){this.__lastListId[sDataSet].handler.forEach(function(aHandler){pushParameterToCallback(aHandler,parsedXMLResponse);executeCallbackFunction(aHandler);});delete this.__lastListId[sDataSet];}
else
if(typeof aHandler=='object'){pushParameterToCallback(aHandler,parsedXMLResponse);executeCallbackFunction(aHandler);}
return;}}
aOut=[];iids=[];if(typeof aHandler=='object'&&aXMLResponse.IQ&&aXMLResponse.IQ[0].RESULT){for(n in aXMLResponse.IQ[0].RESULT){var out={xml:aXMLResponse};if(aXMLResponse.IQ[0].RESULT[n].ID){out.id=aXMLResponse.IQ[0].RESULT[n].ID[0].VALUE;iids.push(this.__clientID(out.id));}
if(aXMLResponse.IQ[0].RESULT[n].NAME)
out.name=aXMLResponse.IQ[0].RESULT[n].NAME[0].VALUE;if(aXMLResponse.IQ[0].RESULT[n].ATT_SIZE)
out.att_size=aXMLResponse.IQ[0].RESULT[n].ATT_SIZE[0].VALUE;if(aXMLResponse.IQ[0].RESULT[n].TEAMCHAT_LINK_ID)
out.teamchat_link=aXMLResponse.IQ[0].RESULT[n].TEAMCHAT_LINK_ID[0].VALUE;if(aXMLResponse.IQ[0].RESULT[n].ATT_WEBDAV_LINK)
out.att_link=aXMLResponse.IQ[0].RESULT[n].ATT_WEBDAV_LINK[0].VALUE;if(aXMLResponse.IQ[0].RESULT[n].FOLDER)
out.folder=aXMLResponse.IQ[0].RESULT[n].FOLDER[0].VALUE;aOut.push(out);Item.notify([sPrimaryAccount,out.folder,out.id],sMethodName.toUpperCase(),{'ITEM-NAME':out.name});}
if(aOut.length==1)
aOut=aOut[0];if(iids.length&&aArgs)
aArgs.iid=iids;}
if(bOk&&sMethodName!='list'){this._notify(sMethodName,aArgs);}
executeCallbackFunction(aHandler,bOk,bOk?aOut:att);return true;case'snooze':try{bOk=true;if(aIQAttribute['TYPE']!='result'){bOk=false;}else if(aArgs.aid!==sPrimaryAccount||aArgs.fid!=='__@@SNOOZED@@__'){var aFolderProps=dataSet.get('folders',[aArgs.aid,aArgs.fid],true)||{},aNewFolderProps=dataSet.get('folders',[sPrimaryAccount,'__@@SNOOZED@@__'],true);if(aFolderProps.RECENT===void 0)
aFolderProps.RECENT=0;if(aNewFolderProps!==void 0){if(!aNewFolderProps.RECENT)
aNewFolderProps.RECENT=0;if(!aNewFolderProps.COUNT)
aNewFolderProps.COUNT=0;for(n in aArgs.iid){dataSet.add('folders',[sPrimaryAccount,'__@@SNOOZED@@__','COUNT'],(++aNewFolderProps.COUNT).toString(),true);}
dataSet.update('folders');}
if(dataSet.get('active_folder')===aArgs.aid+'/'+aArgs.fid){include_ids=dataSet.get('temp',['includeIds'])||[];include_ids=include_ids.filter(function(iid){return!~aArgs.iid.indexOf(iid);});dataSet.add('temp',['includeIds'],include_ids);}}
if(typeof aHandler=='object')
executeCallbackFunction(aHandler,bOk,aData);return true;}catch{}
return false;case'move':case'remove':var removed=dataSet.get('removedFromDataset')||{};for(var acc in removed){for(var fol in removed[acc]){removed[acc][fol]=removed[acc][fol].filter(function(iid){return!~aArgs.iid.indexOf(iid)&&!~aArgs.iid.map(function(iid){return acc+'/'+fol+'/'+iid;}).indexOf(iid);});}}
dataSet.add('removedFromDataset','',removed);case'copy':try{bOk=true;if(aIQAttribute['TYPE']!='result'){bOk=false;var error=aXMLResponse.IQ[0].ERROR[0];var errorUID=error.ATTRIBUTES.UID;switch(errorUID){case'items_duplicity':if(aOrgRequest&&error.DUPLICATE){gui._create('duplicity','frm_duplicity','','',{request:aOrgRequest,duplicate:error.DUPLICATE[0]});}
break;case'imap_internal':gui.notifier._value({type:'alert',args:{header:'',text_plain:(error.VALUE||'').unescapeHTML()}});break;case'item_delete':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::ITEM_COULD_NOT_DELETE'}});break;case'item_edit':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::ITEM_COULD_NOT_EDIT'}});break;case'alfresco_error':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::'+error.VALUE}});break;case'item_decline_reason':if(error.FAILED_ID){var values=aOrgRequest.ACCOUNT[0].FOLDER[0].ITEM[0].VALUES||[{}];for(i in values[0])
values[0][i]=values[0][i][0].VALUE;var failids=[];for(i in error.FAILED_ID[0].UID){failids.push(this.__clientID(error.FAILED_ID[0].UID[i].VALUE));}
gui._create('decline','frm_text','','frm_ok_cancel',[function(sReason){values[0].REASON=sReason;values={aid:aArgs.aid,fid:aArgs.fid,iid:failids,values:values};WMItems.remove(values,sDataSet,aDataPath,sFolderDataSet,aHandler);}],'EVENT::SPECIFY_REASON');bOk=true;return;}
break;case'folder_insufficient_rights':gui.notifier._value({type:'alert',args:{header:'',text:'ALERTS::'+errorUID}});break;default:(errorUID||error.VALUE)&&gui.notifier._value({type:'alert',args:{header:errorUID||'',text_plain:error.VALUE||''}});}
if(sFolderDataSet){if(sMethodName!='copy'){var aItems=dataSet.get(sDataSet);for(sAccId in aItems)
for(sFolId in aItems[sAccId])
break;if(sAccId==aArgs['aid']&&sFolId==aArgs['fid']){var aValues=this.default_values(dataSet.get(sFolderDataSet,[sAccId,sFolId,'TYPE']));if(aValues){iids=aArgs.iid.map(function(iid){return this.__serverID(iid);},this);this.list({'aid':sAccId,'fid':sFolId,iid:iids[0],'values':aValues},sDataSet,aDataPath);}}}
if(aArgs['account']&&aArgs['account']!=aArgs['aid'])
await WMFolders.list({'aid':aArgs['account']},sFolderDataSet);await WMFolders.list({'aid':aArgs['aid']},sFolderDataSet);}}
if(bOk){if(sMethodName==='copy'){if(aArgs.folder){aArgs.fid=aArgs.folder;delete aArgs.folder;}}
if(dataSet.get('active_folder')===aArgs.aid+'/'+aArgs.fid){include_ids=dataSet.get('temp',['includeIds'])||[];include_ids=include_ids.filter(function(iid){return!~aArgs.iid.indexOf(iid);});dataSet.add('temp',['includeIds'],include_ids);}
if(aIQAttribute['TYPE']=='result'){this._notify(sMethodName,aArgs);var action={move:'UPDATE',copy:'ADD'}[sMethodName];action&&aArgs.iid.forEach(function(iid){Item.notify([sPrimaryAccount,aArgs.folder||aArgs.fid,WMItems.__serverID(iid)],action,{'ITEM-NAME':aArgs.name||aArgs.rename});});}}
if(typeof aHandler=='object')
executeCallbackFunction(aHandler,bOk,aData);return true;}
catch{return false;}
case'delete':if(aIQAttribute['TYPE']==='result'){this._notify(sMethodName,aArgs);if(dataSet.get('active_folder')===aArgs.aid+'/'+aArgs.fid){include_ids=dataSet.get('temp',['includeIds'])||[];include_ids=include_ids.filter(function(iid){return!~aArgs.iid.indexOf(iid);});dataSet.add('temp',['includeIds'],include_ids);}}
if(typeof aHandler=='object')
executeCallbackFunction(aHandler);return true;case'recover':case'quarantine':try{if(aIQAttribute['TYPE']=='result'){if(sFolderDataSet){await WMFolders.list({'aid':aArgs['aid']},sFolderDataSet);}
return true;}}
catch(e){console.log(this._name||false,e);}
return false;case'redirect':if(typeof aHandler=='object'){if(aIQAttribute['TYPE']!='result'){try{str=aXMLResponse.IQ[0].ERROR[0].VALUE;att=aXMLResponse.IQ[0].ERROR[0].ATTRIBUTES.UID;}
catch{att='';str='unknown error';}
pushParameterToCallback(aHandler,[att,str.unescapeHTML()]);}
executeCallbackFunction(aHandler);}
break;case'action':executeCallbackFunction(aHandler,aIQAttribute['TYPE']=='result',aXMLResponse);break;}};_me.default_values=function(sFolType){return this.__defaultValues[sFolType];};_me.parse=function(aData,bCount)
{try{function parse_addons(sAddOns,aAddOns)
{var sAddOnId,aAddOnFrame,aValuesFrame;var aResult={};var aResultValueFrame;var sAddOn=sAddOns.substr(0,sAddOns.length-1);for(var n in aAddOns[sAddOn])
{aAddOnFrame=aAddOns[sAddOn][n];if(aAddOnFrame['ATTRIBUTES']&&aAddOnFrame['ATTRIBUTES']['UID'])
{sAddOnId=aAddOnFrame['ATTRIBUTES']['UID'];aResult[sAddOnId]={};}
else{sAddOnId='';aResult[n]={};}
for(var sValues in aAddOnFrame)
if(sValues=='VALUES'){aValuesFrame=aAddOnFrame['VALUES'][0];if(sAddOnId)
aResultValueFrame=aResult[sAddOnId]['values']={};else
aResultValueFrame=aResult[n]['values']={};for(var sValue in aValuesFrame)
if(aValuesFrame[sValue][0]['VALUE'])
aResultValueFrame[sValue]=aValuesFrame[sValue][0]['VALUE'];else
if(!Is.Empty(aValuesFrame[sValue][0]))
aResultValueFrame[sValue]=aValuesFrame[sValue][0];}
else
if(sValues!='ATTRIBUTES')
if(sAddOnId)
aResult[sAddOnId][sValues]=parse_addons(sValues,aAddOnFrame[sValues][0]);else
aResult[n][sValues]=parse_addons(sValues,aAddOnFrame[sValues][0]);}
return aResult;};var aAccFrame=aData['IQ'][0]['QUERY'][0]['ACCOUNT'][0];var sAccId=aAccFrame['ATTRIBUTES']['UID'];var aFolFrame=aAccFrame['FOLDER'][0];var sFolId=aFolFrame['ATTRIBUTES']['UID'];if(Is.Defined(aFolFrame['ATTRIBUTES']['RECENT'])&&parseInt(dataSet.get("folders",[sAccId,sFolId,'RECENT'])||0)!=parseInt(aFolFrame['ATTRIBUTES']['RECENT']||0)){if(sPrimaryAccountCHAT&&dataSet.get("teamchat",[sFolId,'recent']))
dataSet.add("teamchat",[sFolId,'recent'],parseInt(aFolFrame['ATTRIBUTES']['RECENT']),true);dataSet.update("teamchat");dataSet.add("folders",[sAccId,sFolId,'RECENT'],(aFolFrame['ATTRIBUTES']['RECENT']).toString());}
var aItmFrame,sItemId,aValFrame;var aResult={};var aResultFrame=aResult[sAccId]={};aResultFrame=aResultFrame[sFolId]={};aResultFrame['@']=aFolFrame['ATTRIBUTES'];if(bCount&&typeof aFolFrame['ATTRIBUTES']['COUNT']!='undefined'){aResultFrame['/']=aFolFrame['ATTRIBUTES']['COUNT']||0;aResultFrame['#']=aFolFrame.ITEM?aFolFrame.ITEM.length:0;}
if(typeof aFolFrame['ATTRIBUTES']['OFFSET']!='undefined'&&aFolFrame['ATTRIBUTES']['OFFSET'])
aResultFrame['$']=aFolFrame['ATTRIBUTES']['OFFSET'];var aItemIds={};for(var n in aFolFrame['ITEM'])
{aItmFrame=aFolFrame['ITEM'][n];var aFrame={'aid':sAccId,'fid':sFolId};var originalAccount,originalFolder;for(var sAddOns in aItmFrame){switch(sAddOns){case'VALUES':aValFrame=aItmFrame['VALUES'][0];for(var sValue in aValFrame){switch(sValue){case'ATTACHMENTS':aFrame[sValue]=aValFrame[sValue].map(function(attachment){return attachment.ATTACHMENT[0];});break;case'X_ICEWARP_ATT_DATA':aFrame[sValue]=aValFrame[sValue].map(function(att){return att.VALUE;});break;case'ORIGINALACCOUNT':originalAccount=aValFrame[sValue][0]['VALUE'];aFrame[sValue]=aValFrame[sValue][0]['VALUE'];break;case'ORIGINALFOLDER':originalFolder=aValFrame[sValue][0]['VALUE'];aFrame[sValue]=aValFrame[sValue][0]['VALUE'];break;case'EVNURL':var url=aValFrame[sValue][0]['VALUE'];if(url&&url.match(/^data:.*?;base64,/)){url='';}
aFrame[sValue]=url;break;default:aFrame[sValue]=aValFrame[sValue][0]['VALUE'];}}
break;case'X_ICEWARP_SERVER_TEAMCHAT_NOTIFICATIONS':aFrame[sAddOns]=aItmFrame[sAddOns][0];break;case'X_ICEWARP_SERVER_REQUEST':case'X_ICEWARP_SERVER_INVITE_REQUEST':aFrame['X_ICEWARP_SERVER_REQUEST']=aItmFrame[sAddOns][0];break;case'NOTE':aFrame[sAddOns]=aItmFrame[sAddOns][0]['VALUE'];break;case'ATTRIBUTES':break;default:aFrame[sAddOns]=parse_addons(sAddOns,aItmFrame[sAddOns][0],aFrame[sAddOns]);}}
sItemId=this.__clientID(aItmFrame['ATTRIBUTES']['UID']);if(aFrame.EVNRCR_ID&&aFrame.EVNSTARTDATE&&aFrame.OSD){if(aFrame.EVNSTARTDATE!=aFrame.OSD)
sItemId+='|'+aFrame.EVNSTARTDATE;}
else{if(typeof aItemIds[sItemId]=='undefined')
aItemIds[sItemId]=0;else
sItemId+='|'+(++aItemIds[sItemId]);}
aResultFrame[sItemId]=aFrame;if(originalAccount){aResult[originalAccount]=aResult[originalAccount]||{};aResult[originalAccount][originalFolder]=aResult[originalAccount][originalFolder]||{};aResult[originalAccount][originalFolder][sItemId]=aFrame;}}
return aResult;}
catch{return false;}};_me._notify=function(sAction,args){gui.__exeEvent('item',sAction,args);};var WMItems=new wm_items;

/* client/inc/wm_storage.js */function wm_storage(){};wm_storage.inherit(wm_generic);_me=wm_storage.prototype;_me.set=async function(aStorageInfo,sDataSet,aDataPath,aHandler)
{function parse_attr(aAttrFrame)
{var aAttributes={};for(var sAttr in aAttrFrame)
if(sAttr!='DEFAULT'&&sAttr!='DONT_SEND'&&sAttr!='ACCESS')
aAttributes[sAttr]=aAttrFrame[sAttr];return aAttributes;}
if(typeof aStorageInfo['resources']!='object')
return false;var xmlns='private';if(aStorageInfo['xmlns']=='public')
xmlns='public';else if(aStorageInfo['xmlns']=='domain')
xmlns='domain';var aRequest={"RESOURCES":[]};if(typeof aStorageInfo['domain']=='string')
aRequest.DOMAIN=[{"VALUE":aStorageInfo['domain']}];var aResourcesFrame=aStorageInfo['resources'];var aAttrFrame,aItemsFrame,aValuesFrame;var aResourcesRequest=aRequest['RESOURCES'][0]={};var aResourceRequest,aItemsRequest,aItemRequest;var m,aAttributes,aValueRequest;var bResource=false;var bItem=false;var bValue=false;var aResourceList=[];for(var sResource in aResourcesFrame)
{aAttrFrame=aResourcesFrame[sResource]['ATTRIBUTES'];if(!aAttrFrame['DONT_SEND']&&(!aAttrFrame['ACCESS']||aAttrFrame['ACCESS']=='full'))
{aAttrFrame['DONT_SEND']=true;aItemsFrame=aResourcesFrame[sResource]['ITEMS'];aResourceRequest=aResourcesRequest[sResource]=[];aResourceRequest=aResourceRequest[0]={};aItemsRequest=aResourceRequest['ITEM']=[];aAttributes=parse_attr(aAttrFrame);if(!Is.Empty(aAttributes))
aResourceRequest['ATTRIBUTES']=aAttributes;m=0;if(!aItemsFrame.length)
bResource=true;else
for(var n in aItemsFrame)
{aAttrFrame=aItemsFrame[n]['ATTRIBUTES'];if(!aAttrFrame['DONT_SEND']&&(!aAttrFrame['ACCESS']||aAttrFrame['ACCESS']=='full'))
{aAttrFrame['DONT_SEND']=true;aValuesFrame=aItemsFrame[n]['VALUES'];aItemRequest=aItemsRequest[m]={};aAttributes=parse_attr(aAttrFrame);if(!Is.Empty(aAttributes))
aItemRequest['ATTRIBUTES']=aAttributes;for(var sValue in aValuesFrame)
{aAttrFrame=aValuesFrame[sValue]['ATTRIBUTES'];if(!aAttrFrame['DONT_SEND']&&!aAttrFrame['DEFAULT']&&(!aAttrFrame['ACCESS']||aAttrFrame['ACCESS']=='full'))
{aValueRequest=aItemRequest[sValue]=[];aValueRequest=aValueRequest[0]={};aAttributes=parse_attr(aAttrFrame);if(!Is.Empty(aAttributes))
aValueRequest['ATTRIBUTES']=aAttributes;aValueRequest['VALUE']=aValuesFrame[sValue]['VALUE'];bValue=true;}}
if(aItemRequest['ATTRIBUTES']||bValue)
{m++;bValue=false;bItem=true;}}}
if(aResourceRequest['ATTRIBUTES']||bItem)
{bItem=false;bResource=true;aResourceList.push(sResource);}}}
if(!bResource)
return 2;if(!sDataSet){var aResponse=await this.create_iq(aRequest,'','','set','',xmlns);try{if(aResponse['IQ'][0]['ATTRIBUTES']['TYPE']=='result')
return true;}
catch(e){console.log(this._name||false,e);}
return false;}
else{this.create_iq(aRequest,[this,'response',['set',sDataSet,aDataPath,aHandler,aResourceList]],'','set','',xmlns);return true;}};_me.get=async function(aStorageInfo,sDataSet,aDataPath,aHandler,bForce){if(typeof aStorageInfo['resources']!='object')
return false;var xmlns='private';if(aStorageInfo['xmlns']=='public')
xmlns='public';else
if(aStorageInfo['xmlns']=='domain')
xmlns='domain';var aResources=aStorageInfo['resources'];var bAnything=false;var aRequest={"RESOURCES":[{}]};if(typeof aStorageInfo['domain']=='string')
aRequest.DOMAIN=[{"VALUE":aStorageInfo['domain']}];var aFrame=aRequest['RESOURCES'][0];for(var n in aResources)
if(!sDataSet||!(xmlns=='private'&&!bForce&&dataSet.get(sDataSet,[aResources[n].toUpperCase()]))){aFrame[aStorageInfo['resources'][n]]=[{}];bAnything=true;}
if(!bAnything){if(typeof aHandler=='object')
executeCallbackFunction(aHandler);}
else
if(!sDataSet&&!aHandler)
return this.parse(await this.create_iq(aRequest,'','','','',xmlns));else{this.create_iq(aRequest,[this,'response',['get',sDataSet,aDataPath,aHandler]],'','','',xmlns);}};_me.response=function(aResponse,sMethodName,sDataSet,aDataPath,aHandler,aResourceList)
{var aXMLResponse=aResponse['Array'];var aIQAttribute=aXMLResponse['IQ'][0]['ATTRIBUTES'];switch(sMethodName)
{case'set':try{var bOK=aIQAttribute['TYPE']=='result';if(typeof aHandler=='object')
executeCallbackFunction(aHandler,[bOK,aResourceList]);if(bOK){gui.__exeEvent('storage',{type:'set'},aResourceList);return true;}}
catch(e){console.log(this._name||false,e);}
return false;case'get':try{if(aIQAttribute['TYPE']=='result'){var aResult=this.parse(aXMLResponse);for(var sResource in aResult)
dataSet.add(sDataSet,[sResource],aResult[sResource]);if(typeof aHandler=='object')
executeCallbackFunction(aHandler,aResult);return true;}}
catch(e){console.log(this._name||false,e);}
return false;}};_me.parse=function(aData)
{try
{function parse_attr(aAttrFrame,bDontSend)
{var aAttributes={};for(var sAttr in aAttrFrame)
aAttributes[sAttr]=aAttrFrame[sAttr];if(!aAttributes['ACCESS'])
aAttributes['ACCESS']='full';if(bDontSend)
aAttributes['DONT_SEND']=true;return aAttributes;};var aResourcesFrame=aData['IQ'][0]['QUERY'][0]['RESOURCES'][0];var aResourceFrame,aItemFrame,aValueFrame;var aResult={};var aResourceResult,aItemsResult,aItemResult,aValuesResult,aValueResult;for(var sResource in aResourcesFrame)
{aResourceFrame=aResourcesFrame[sResource][0];aResourceResult=aResult[sResource]={};aResourceResult['ATTRIBUTES']=parse_attr(aResourceFrame['ATTRIBUTES'],true);aItemsResult=aResourceResult['ITEMS']=[];for(var n in aResourceFrame['ITEM'])
{aItemFrame=aResourceFrame['ITEM'][n];aItemResult={};aItemResult['ATTRIBUTES']=parse_attr(aItemFrame['ATTRIBUTES'],true);aValuesResult=aItemResult['VALUES']={};for(var sTag in aItemFrame)
if(sTag!='ATTRIBUTES')
{aValueFrame=aItemFrame[sTag][0];aValueResult=aValuesResult[sTag]={};aValueResult['ATTRIBUTES']=parse_attr(aValueFrame['ATTRIBUTES'],false);if(typeof aValueFrame['VALUE']=='undefined')
aValueResult['VALUE']='';else
aValueResult['VALUE']=aValueFrame['VALUE'];}
aItemsResult.push(aItemResult);}}
return aResult;}
catch{return false;}};window.WMStorage=new wm_storage();

/* client/inc/init.js */function initPRO(aData){this===void 0&&new initPRO().init(aData);}
initPRO.prototype.init=async function(aLogin){document.body.innerHTML='';document.head.appendChild(mkElement('link',{rel:'stylesheet',type:'text/css',href:'client/skins/index.css'}));window.sSessionUID=unique_id();window.request=new cRequest(location.origin+location.pathname+'server/webmail.php');window.gui=new Gui('gui');window.request.onstart=function(xhr){gui._loading(xhr,true);};window.request.onfinish=function(xhr){gui._loading(xhr);};window.oWM_INIT=this;var allowed_get={"page":'index',"debug":null,"frm":null,"sid":null,"ref":null,"xml":null,"username":null,"password":null,"mailto":null,"subject":null,"body":null,"video":null,"conference":null,"cc":null,"bcc":null,'open':null,'telemetry':null,'from':null,'tconly':null,"RoomID":null,"ThreadID":null,"PostID":null,tracing:null,replay:null,};function arrKeySlice(arr1,arr2){var k,isa=false,out=[];if(arr2.constructor==Array)isa=true;if(!arr1||!arr2)return out;for(var i in arr2){if(isa)
k=arr2[i];else
k=i;if(!isa&&!arr1[k]&&arr2[k])
out[k]=arr2[k];else if(typeof arr1[k]!='undefined')
out[k]=arr1[k];}
return out;};gui._REQUEST_VARS=arrConcat(arrKeySlice(aLogin.get,allowed_get),arrKeySlice(parseURL(),allowed_get));await gui._create('notifier','obj_notifier','','',true);await gui._create('connection','obj_connection');this.__setSession(aLogin,async function(){await GWOthers.load(['layout_settings']);await storage.language(GWOthers.getItem('LAYOUT_SETTINGS','language'));storage.css('font');storage.css('obj_initial_loader',false,async function(){await gui._create('preloader','obj_initial_loader');gui.preloader._value(getLang('PRELOADER::STYLES'));await this._continueLogin();window.Sentry=!1;if(window.SentryEnabled){window.SentryFeatures=window.SentryFeatures||[];if(gui._REQUEST_VARS.tracing){window.SentryFeatures.push('tracing');}
if(gui._REQUEST_VARS.replay){window.SentryFeatures.push('replay');}
if(gui._REQUEST_VARS.debug){window.SentryFeatures.push('debug');}
await storage.library('js-sdk-loader.min','sentry');if(window.Sentry){WMAccounts.__getLicense(function(){Sentry.init({debug:!!gui._REQUEST_VARS.debug,environment:window.SentryEnvironment||'production',initialScope:{tags:{licenseType:dataSet.get('main',['license_type'])},user:{email:sPrimaryAccount}},release:dataSet.get('main',['version']),sampleRate:1.0,maxBreadcrumbs:100,autoSessionTracking:true,tracesSampleRate:1,denyUrls:[/^https?:\/\/api.\.*icewarp\.com\/.*\/avatar\//i,]});});Sentry.setTag=Sentry.setTag||function(){};Sentry.captureException=Sentry.captureException||function(){};Sentry.withScope=Sentry.withScope||function(){};}}
gui.preloader._value(getLang('PRELOADER::FRAMEWORK'));await gui._create('banner','obj_banner');dataSet.on('folders',[sPrimaryAccount],function(folders){for(var key in folders){if(folders[key].TYPE==="I"&&(!folders[key].SYNC||folders[key].SYNC==='0')){folders[key].RECENT=0;}}});if(sPrimaryAccountCHAT=='1'){function teamchat_listener(set,path){if(set==='folders'){if(path&&path.length===1){return;}
var recent=Cookie.get(['recent'])||[],room_name,index;if(path&&path[path.length-1]==='RECENT'&&dataSet.get('folders',path.slice(0,2)).TYPE==="I"&&dataSet.get('folders',path.slice(0,2)).RECENT!=="0"){room_name=path.slice(0,2).join('/');index=recent.indexOf(room_name);!!~index&&recent.splice(index,1);recent.unshift(room_name);}
Cookie.set(['recent'],recent);dataSet.update('cookies',['recent']);return;}};dataSet.on('active_folder',[],teamchat_listener);dataSet.on('folders',[],teamchat_listener);}}.bind(this));}.bind(this));};initPRO.prototype.__setSession=async function(aLogin,callback){var erString='';var sid=await auth.login({"session":gui._REQUEST_VARS['sid'],"keep":gui._REQUEST_VARS['open']?true:false,"from":gui._REQUEST_VARS['from']});if(sid){dataSet.add('main',['sid'],sid);return callback();}else{if(Is.Object(auth.error)){switch(auth.error.id){case'login_account_valid':erString='ACCOUNT_DISABLED';break;case'login_invalid':case'session_no_user':document.cookie='permanentLogin=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT';erString='INVALID_LOGIN';break;case'session_expired':erString='EXPIRED';break;case'session_ip_mismatch':erString='IP_MISMATCH';break;default:console.error(auth.error);window.Sentry&&Sentry.withScope(function(scope){scope.setTag('module','session');Sentry.captureException(auth.error);});}}else
erString='INVALID_LOGIN';}
this._goBack(arrConcat(aLogin.back||{},{reason:erString}));}
initPRO.prototype._goBack=async function(aParam){await storage.library('gw_others');var sURL=GWOthers.getItem('LAYOUT_SETTINGS','logout_url')||(document.location.protocol+'//'+document.location.hostname+(document.location.port?':'+document.location.port:'')+document.location.pathname);if(sURL&&sURL[0]!=='.'&&!sURL.match(/^https?:\/\//)){sURL=document.location.protocol+'//'+sURL;}
if(aParam){var eForm=mkElement('form',{method:'POST',action:sURL,target:'_self',style:'position: absolute;top:0;left:0;'});for(var i in aParam)
eForm.appendChild(mkElement('input',{type:'hidden',name:i,value:aParam[i]}));gui._main.appendChild(eForm);eForm.submit();return;}};initPRO.prototype._continueLogin=async function(){var solid=dataSet.get('storage',['LAYOUT_SETTINGS','ITEMS',0,'VALUES','LOGIN_BACKGROUND_SOLID','VALUE']);if(solid&&solid!=='false'){gui._setTheme(dataSet.get('storage',['LAYOUT_SETTINGS','ITEMS',0,'VALUES','LOGIN_BACKGROUND_COLOR','VALUE']));}else{gui._setTheme(dataSet.get('storage',['LAYOUT_SETTINGS','ITEMS',0,'VALUES','LOGIN_BACKGROUND_COLOR','VALUE']),location.origin+location.pathname+'server/download.php?'+buildURL({class:'background',fullpath:location.hostname,uid:(dataSet.get('storage',['LAYOUT_SETTINGS','ITEMS',0,'VALUES','LOGIN_BACKGROUND_UID','VALUE'])||'').toString().substring(0,32),resize:1,width:Math.max(1280,window.screen.width*window.devicePixelRatio),height:Math.max(720,window.screen.height*window.devicePixelRatio)}));}
gui._main.classList.add(dataSet.get('storage',['LAYOUT_SETTINGS','ITEMS',0,'VALUES','LOGIN_BACKGROUND_WALLPAPER_SIZE','VALUE']));gui.preloader._value(getLang('PRELOADER::SETTINGS'));var old_skin=GWOthers.getItem('LAYOUT_SETTINGS','skin');if(old_skin==='biggerrtl'){old_skin='bigger';}else if(old_skin==='banner'){old_skin='default';}
await GWOthers.load(['skins','banner_options','im','sip','chat','mail_settings_default','mail_settings_general','layout_settings','login_settings','hidden_columns','calendar_settings','default_calendar_settings','cookie_settings','default_reminder_settings','event_settings','spellchecker_languages','signature','groups','restrictions','aliases','read_confirmation','global_settings','paths','streamhost','password_policy','fonts','certificate','timezones','external_settings','gw_mygroup','default_folders','documents','autoresponder','forwarder','custom_backup_form','sound','reset_settings']);gui.preloader._value(getLang('PRELOADER::LANGUAGE'));if(!gui._REQUEST_VARS.debug){await storage.library('javascript');}
storage.css('font');switch(GWOthers.getItem('LAYOUT_SETTINGS','font_weight')){case'auto':if(!gui.__BROWSER.retina)
break;case'light':addcss(document.body,'light');}
await this._setupCalendar();var skin=GWOthers.getItem('LAYOUT_SETTINGS','skin');if(skin==='biggerrtl'){skin='bigger';}else if(skin==='banner'){skin='default';}
if(old_skin!=skin)
storage.aStorage.template={};await storage.library('team_chat_api');var aAccounts=await WMAccounts.list();dataSet.add('accounts','',aAccounts);addEventListener('message',function(e){switch(e.data.event){case'getUser':e.source.postMessage({event:'user',data:{email:sPrimaryAccount,name:dataSet.get('main',['fullname']),language:GWOthers.getItem('LAYOUT_SETTINGS','language'),token:(e.origin===location.origin)&&sPrimaryAccountTeamchatToken}},'*');break;}});await storage.library('json-xml','icewarpapi/json-xml');await storage.library('processResponse','icewarpapi/old-communication');await storage.library('callback','icewarpapi/callback');await storage.library('json-xml','icewarpapi/json-xml');await storage.library('iq-protocol','icewarpapi/iq-protocol');await storage.library('request','icewarpapi/request');await storage.library('xhr-connection','icewarpapi/xhr-connection');await storage.library('old-communication','icewarpapi/old-communication');await storage.library('icewarpapi','icewarpapi');window.icewarpapi=IceWarpAPI();this.__refreshed=false;WMFolders.list({'aid':sPrimaryAccount,force:true},'folders',[sPrimaryAccount],[this,'_updatePreloader']);var lang=GWOthers.getItem('LAYOUT_SETTINGS','language');lang=document.documentElement.lang=isoLanguageCode(lang);gui._rtl=!!~['ar','fa','he'].indexOf(lang);if(gui._rtl){document.body.className+=' rtl';}
var dbappkey=GWOthers.getItem('EXTERNAL_SETTINGS','dropbox_app_key')||'';if(GWOthers.getItem('RESTRICTIONS','disable_dropbox')!='1'&&dbappkey.length){var dropbox=document.createElement('script');dropbox.type="text/javascript";dropbox.src="https://www.dropbox.com/static/api/1/dropbox.js";dropbox.id="dropboxjs";dropbox.setAttribute('data-app-key',dbappkey);document.head.appendChild(dropbox);}
if(sPrimaryAccountSIP){await storage.library('sip_bridge');if(typeof IceSIP!="undefined"&&IceSIP.supported()){dataSet.add('sip',['state'],'offline');dataSet.add('sip',['activity'],'');if(currentBrowser()==='Safari')
await storage.library('AdapterJS','sip');await storage.library('JsSIP','sip');}else
window.JsSIP=null;}else
window.JsSIP=null;};initPRO.prototype._setupCalendar=async function(){await storage.library('icewarpdate.min','calendar');IcewarpDate.Locale.setLocaleURL('client/inc/calendar/locale/');IcewarpDate.setCalendar(+GWOthers.getItem('LAYOUT_SETTINGS','alternative_calendar'),true);if(IcewarpDate.setHijriOffset){IcewarpDate.setHijriOffset(+GWOthers.getItem('CALENDAR_SETTINGS','hijri_offset'),true);}
IcewarpDate.Locale.changeLocalizedFormat('L',CalendarFormatting.getFormat(+GWOthers.getItem('LAYOUT_SETTINGS','date_format')));IcewarpDate.Locale.changeLocalizedFormat('LT',+GWOthers.getItem('LAYOUT_SETTINGS','time_format')?'hh:mm a':'HH:mm');var language=isoLanguageCode(GWOthers.getItem('LAYOUT_SETTINGS','language'));switch(language){case'zh':language='zh-hk'
break;}
IcewarpDate.Locale.chooseLocale(language);var dow,doy;if(GWOthers.getItem('CALENDAR_SETTINGS','begin_on_today')!='0'){dow=(new IcewarpDate()).day();}else{dow={monday:1,tuesday:2,wednesday:3,thursday:4,friday:5,saturday:6,sunday:0}[GWOthers.getItem('CALENDAR_SETTINGS','week_begins')];}
switch(+GWOthers.getItem('CALENDAR_SETTINGS','week_numbers')){case 1:doy=7+dow-1;break;case 2:doy=7+dow-7;break;case 3:doy=7+dow-4;}
IcewarpDate.Locale.setCustomWeekOptions(dow,doy);if(GWOthers.getItem('LAYOUT_SETTINGS','time_format')>0){addcss(document.body,'time_format_long');}else{removecss(document.body,'time_format_long');}
var date_format=CalendarFormatting.getFormats()[GWOthers.getItem('LAYOUT_SETTINGS','date_format')];if(~date_format.indexOf('MMM')||~date_format.indexOf('YYYY')){addcss(document.body,'date_format_long');}else{removecss(document.body,'date_format_long');}};initPRO.prototype._updatePreloader=async function(bSkip){var folders=dataSet.get('folders',[sPrimaryAccount]);if(!folders){if(bSkip!==true){this.__refreshed=true;if(gui.preloader)
gui.preloader._value(getLang('PRELOADER::INDEXING'));WMAccounts.refresh({'aid':sPrimaryAccount},'folders',[sPrimaryAccount],[this,'_updatePreloader',[true]]);return;}else if(window.TeamChatAPI&&TeamChatAPI.teamChatOnly()){dataSet.add('folders',[sPrimaryAccount,'__@@VIRTUAL@@__/__@@PRIVATE_ROOMS@@__'],{TYPE:'Y',NAME:getLang('FOLDER_TYPES::GROUPCHAT')});dataSet.add('folders',[sPrimaryAccount,'__@@VIRTUAL@@__/__@@DASHBOARD@@__'],{TYPE:'D',});}}
await storage.library('class_cookie');window.Cookie=new class_cookie();await window.Cookie.init();if(gui.preloader)
gui.preloader._value(getLang('PRELOADER::STARTUP'));storage.css('style',true,async function(){await storage.library('night_mode');if(window.matchMedia&&window.matchMedia('(prefers-color-scheme)').matches){if(GWOthers.getItem('LAYOUT_SETTINGS','night_mode')==2){dataSet.add('main',['night_mode_enabled'],window.matchMedia('(prefers-color-scheme: dark)').matches);}else{dataSet.add('main',['night_mode_enabled'],GWOthers.getItem('LAYOUT_SETTINGS','night_mode')==1);}
window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change',function(event){if(GWOthers.getItem('LAYOUT_SETTINGS','night_mode')==2){dataSet.add('main',['night_mode_enabled'],!!event.matches);if(event.matches){NightMode().activate();}else{NightMode().reset();}}});}else{dataSet.add('main',['night_mode_enabled'],GWOthers.getItem('LAYOUT_SETTINGS','night_mode')==1);}
if(dataSet.get('main',['night_mode_enabled'])){NightMode().activate();}
if(!gui._REQUEST_VARS.debug){await storage.template('templates');await storage.preloadObj();}
this._updatePreloader2();}.bind(this));};initPRO.prototype._updatePreloader2=async function(){await gui._create('tooltip','obj_tooltip');var folders=dataSet.get('folders',[sPrimaryAccount]);if(sPrimaryAccountGUEST&&!Object.keys(folders||{}).some(function(folder){return folders[folder].TYPE==='I';})){return await gui._create("confirm","frm_alert","","",[function(){frm_main.prototype.__logout();}],'MAIN_MENU::LOGOUT','ERROR::MISSING_TEAMCHAT');}
async function detectTimezoneChange(callback){var last_tz=Cookie.get(['tzoffset']),new_tz=new IcewarpDate().utcOffset()-(60*new IcewarpDate().getMoment().isDST());Cookie.set(['tzoffset'],new_tz);if(last_tz===void 0){callback();}else if(sPrimaryAccountGW>0&&last_tz!=new_tz){await gui._create('timezone','frm_timezone','main','',[function(){callback(true);}]);}else{callback();}}
detectTimezoneChange(function(){icewarpapi.getToken(function(){gui._create('frm_main','frm_main','','',true);});TeamChatAPI.init();});setInterval(function(){detectTimezoneChange(function(bTimezoneChanged){bTimezoneChanged&&gui._create('frm_confirm','frm_confirm','','',[function(){Cookie.store([function(){document.location.reload();}],[function(){document.location.reload();}]);}],'CONFIRMATION::TIMEZONE_CHANGE_TITLE','CONFIRMATION::TIMEZONE_CHANGE_RELOAD',void 0,[function(){Cookie.store();}]);});},5*60*1000);};

/* client/inc/gw_others.js */function gw_others(){this.listeners=[];};_me=gw_others.prototype;_me.load=async function(aResources,sDataSet,sDataPath,bAppend){await storage.library('wm_storage');sDataSet=sDataSet||'storage';var resources=await WMStorage.get({'resources':aResources});if(bAppend){for(var i in resources){dataSet.add(sDataSet,[i],resources[i],true);}}else{dataSet.add(sDataSet,sDataPath,resources,true);}
this.checkLayoutSettings(sDataSet,sDataPath);this.checkCalendarSettings(sDataSet,sDataPath);};_me.getFromServerIfNotLocally=async function(sResourceName,sDataSet,bAdmin,bTryGet,bForceGet){if(!sResourceName||!sDataSet)
return false;var aResource=dataSet.get(sDataSet,[sResourceName]);if((bTryGet&&typeof aResource!='object')||bForceGet){var aRsc=await WMStorage.get({'resources':[sResourceName]});if(aRsc[sResourceName]&&typeof aRsc[sResourceName]=='object'&&!Is.Empty(aRsc[sResourceName]['ITEMS'])){aResource=aRsc[sResourceName];dataSet.add(sDataSet,[sResourceName],aResource,true);}
aRsc=null;}
return this.get(sResourceName,sDataSet,bAdmin);};_me.get=function(sResourceName,sDataSet,bAdmin)
{if(!sResourceName||!sDataSet)
return false;var aResource=dataSet.get(sDataSet,[sResourceName]);var bEmpty=false;if(typeof aResource!='object'||Is.Empty(aResource['ITEMS'])){aResource={'ITEMS':[{'VALUES':{},'ATTRIBUTES':{'DONT_SEND':true}}],'ATTRIBUTES':{'DONT_SEND':true}};bEmpty=true;}
if(!(aResource=this.setDefault(sResourceName,aResource,sDataSet,bEmpty)))
return false;var aAccess2Num={'full':0,'view':1,'none':2};var sAccess=(aResource['ATTRIBUTES']['ACCESS']?aResource['ATTRIBUTES']['ACCESS']:'full');if(bAdmin){var sUserAccess=(aResource['ATTRIBUTES']['USERACCESS']?aResource['ATTRIBUTES']['USERACCESS']:'full');var sDomainAdminAccess=(aResource['ATTRIBUTES']['DOMAINADMINACCESS']?aResource['ATTRIBUTES']['DOMAINADMINACCESS']:'full');}
var aResourceFrame=aResource['ITEMS'][0];var sSubAccess=(aResourceFrame['ATTRIBUTES']['ACCESS']?aResourceFrame['ATTRIBUTES']['ACCESS']:'full');sAccess=(aAccess2Num[sAccess]>=aAccess2Num[sSubAccess]?sAccess:sSubAccess);if(bAdmin){var sUserSubAccess=(aResourceFrame['ATTRIBUTES']['USERACCESS']?aResourceFrame['ATTRIBUTES']['USERACCESS']:'full');var sDomainAdminSubAccess=(aResourceFrame['ATTRIBUTES']['DOMAINADMINACCESS']?aResourceFrame['ATTRIBUTES']['DOMAINADMINACCESS']:'full');sUserAccess=(aAccess2Num[sUserAccess]>=aAccess2Num[sUserSubAccess]?sUserAccess:sUserSubAccess);sDomainAdminAccess=(aAccess2Num[sDomainAdminAccess]>=aAccess2Num[sDomainAdminSubAccess]?sDomainAdminAccess:sDomainAdminSubAccess);}
var aValues=aResourceFrame['VALUES'];var aResult={'VALUES':{},'ACCESS':{}};var aValuesResult=aResult['VALUES'];var aAccessResult=aResult['ACCESS'];if(bAdmin){var aUserAccessResult=aResult['USERACCESS']=[];var aDomainAdminAccessResult=aResult['DOMAINADMINACCESS']=[];}
var sLCValue;for(var sValue in aValues)
{sLCValue=sValue.toLowerCase();aValuesResult[sLCValue]=aValues[sValue]['VALUE'];sSubAccess=(aValues[sValue]['ATTRIBUTES']['ACCESS']?aValues[sValue]['ATTRIBUTES']['ACCESS']:'full');aAccessResult[sLCValue]=(aAccess2Num[sAccess]>=aAccess2Num[sSubAccess]?sAccess:sSubAccess);if(bAdmin){sUserSubAccess=(aValues[sValue]['ATTRIBUTES']['USERACCESS']?aValues[sValue]['ATTRIBUTES']['USERACCESS']:'full');aUserAccessResult[sLCValue]=(aAccess2Num[sUserAccess]>=aAccess2Num[sUserSubAccess]?sUserAccess:sUserSubAccess);sDomainAdminSubAccess=(aValues[sValue]['ATTRIBUTES']['DOMAINADMINACCESS']?aValues[sValue]['ATTRIBUTES']['DOMAINADMINACCESS']:'full');aDomainAdminAccessResult[sLCValue]=(aAccess2Num[sDomainAdminAccess]>=aAccess2Num[sDomainAdminSubAccess]?sDomainAdminAccess:sDomainAdminSubAccess);}}
return aResult;};_me.set=function(sResourceName,aResourceInfo,sDataSet,aAccess)
{if(!sResourceName||typeof aResourceInfo!='object'||!sDataSet)
return false;var aResource=dataSet.get(sDataSet,[sResourceName]),aValues,sValue;if(typeof aResource=='object'&&!Is.Empty(aResource['ITEMS']))
{var aResourceFrame=aResource['ITEMS'][0];aValues=aResourceFrame['VALUES'];var bChange=false;var bLocalChange=false;var sUCValue;for(sValue in aResourceInfo)
{bLocalChange=false;sUCValue=sValue.toUpperCase();if(typeof aValues[sUCValue]!='object')
aValues[sUCValue]={'ATTRIBUTES':{}};if(aValues[sUCValue]['VALUE']!=aResourceInfo[sValue]){aValues[sUCValue]['VALUE']=aResourceInfo[sValue];bLocalChange=true;}
if(aAccess){if(aAccess['USERACCESS']){var sUserAccess=(aValues[sUCValue]['ATTRIBUTES']['USERACCESS'])?aValues[sUCValue]['ATTRIBUTES']['USERACCESS']:'full';var sNewUserAccess=(aAccess['USERACCESS'][sValue])?aAccess['USERACCESS'][sValue]:'full';if(sUserAccess!=sNewUserAccess){aValues[sUCValue]['ATTRIBUTES']['USERACCESS']=sNewUserAccess;bLocalChange=true;}}
if(aAccess['DOMAINADMINACCESS']){var sDomainAdminAccess=(aValues[sUCValue]['ATTRIBUTES']['DOMAINADMINACCESS'])?aValues[sUCValue]['ATTRIBUTES']['DOMAINADMINACCESS']:'full';var sNewDomainAdminAccess=(aAccess['DOMAINADMINACCESS'][sValue])?aAccess['DOMAINADMINACCESS'][sValue]:'full';if(sDomainAdminAccess!=sNewDomainAdminAccess){aValues[sUCValue]['ATTRIBUTES']['DOMAINADMINACCESS']=sNewDomainAdminAccess;bLocalChange=true;}}}
if(bLocalChange){bChange=true;aValues[sUCValue]['ATTRIBUTES']['DEFAULT']=false;}}
if(bChange){aResource['ATTRIBUTES']['DONT_SEND']=false;aResourceFrame['ATTRIBUTES']['DONT_SEND']=false;dataSet.add(sDataSet,[sResourceName],aResource,true);this.listeners.forEach(function(listener){listener(sResourceName,aResourceInfo);});}}
else
{aResource={'ITEMS':[{'VALUES':{},'ATTRIBUTES':{'DONT_SEND':false}}],'ATTRIBUTES':{'DONT_SEND':false}};aValues=aResource['ITEMS'][0]['VALUES'];for(sValue in aResourceInfo)
aValues[sValue.toUpperCase()]={'VALUE':aResourceInfo[sValue],'ATTRIBUTES':{}};dataSet.add(sDataSet,[sResourceName],aResource,true);this.listeners.forEach(function(listener){listener(sResourceName,aResourceInfo);});}
return true;};_me.getItem=function(sResourceName,sItemName,sStorage,bAdmin){sItemName=sItemName.toUpperCase();var aResource=dataSet.get(sStorage||'storage',[sResourceName,'ITEMS',0,'VALUES',sItemName]);if(bAdmin){var aResult=GWOthers.get(sResourceName,sStorage||'storage',true);sItemName=sItemName.toLowerCase();return{VALUE:aResult.VALUES[sItemName]||this.getItem(sResourceName,sItemName,sStorage),ACCESS:aResult.ACCESS[sItemName]||'full'};}
else
if(!aResource){GWOthers.get(sResourceName,sStorage||'storage');aResource=dataSet.get(sStorage||'storage',[sResourceName,'ITEMS',0,'VALUES',sItemName]);}
if(aResource)
return aResource['VALUE'];};_me.getItemAccess=function(sResourceName,sItemName){sItemName=sItemName.toUpperCase();var aResource=dataSet.get('storage',[sResourceName,'ITEMS',0,'VALUES',sItemName]);if(!aResource){GWOthers.get(sResourceName,'storage');aResource=dataSet.get('storage',[sResourceName,'ITEMS',0,'VALUES',sItemName]);}
if(aResource)
return!aResource.ATTRIBUTES||aResource.ATTRIBUTES.ACCESS!='view';return false;};_me.setItem=function(sResourceName,sItemName,v){var tmp={};tmp[sItemName]=v;GWOthers.set(sResourceName,tmp,'storage');};_me.save=async function(aHandler){return await WMStorage.set({'resources':dataSet.get('storage')},'storage','',aHandler);};_me.setDefault=function(sResourceName,aResource,sDataSet,bEmpty){var aValues=this.getDefaultValues(sResourceName);if(typeof aValues=='object')
{var aResourceValues=aResource['ITEMS'][0]['VALUES'],bChange=false;for(var sValue in aValues)
if(typeof aResourceValues[sValue]=='undefined'){aResourceValues[sValue]={'VALUE':aValues[sValue],'ATTRIBUTES':{'DEFAULT':true}};bChange=true;}
if(bChange)
dataSet.add(sDataSet,[sResourceName],aResource,true);return aResource;}
else
if(bEmpty)
return false;else
return aResource;};_me.getDefaultValues=function(sResourceName)
{var aValues;switch(sResourceName){case'GLOBAL_SETTINGS':aValues={'UPLOAD_LIMIT':0,'HTTP_PORT':sPrimaryAccountHTTP};break;case'SKINS':aValues={'DEFAULT':'Default'};break;case'IM':aValues={'AUTO_CHAT':0,'AUTO_STATUS':1,'STATUS_DND':1,'STATUS_OFFLINE':1,'SOUND_NOTIFY':1,'ESC':1,'DISABLE_GONE_MESSAGE':0,SORT_BY_SURNAME:0};break;case'CHAT':aValues={'ENTER_SEND':1,'SMILES':1,'SOUND_NOTIFY':1,'VISUAL_NOTIFY':1,GIFS:1,EDITOR_TYPE:'wysiwyg',};break;case'DOCUMENTS':aValues={'OFFICE_APP':'webdoc','DISABLE_OFFICE':0};break;case'MAIL_SETTINGS_DEFAULT':aValues={'SEND_UNDO':1,'CTRL_ENTER':'0','SEND_DELAY':0,'REPLY_MYSELF':0,'CHECK_SUBJECT':1,'SIGN_TOP':1,'FONT_FAMILY':0,'FONT_SIZE':13,'TEXT_DIRECTION':'LTR','SPELLCHECKER':'en','HTML_MESSAGE':1,'REPLY_MESSAGE':2,'READ_CONFIRMATION':0,'SAVE_SENT_MESSAGE':1,'ENCRYPT':0,'SIGN':0,'REPLY_TO_ADDRESS':'','PRIORITY':3,'CHARSET':'UTF-8',AUTOCAPITALIZATION:0,WEBCLIENT_PRINT:0,WEBCLIENT_FORWARD:0,WEBCLIENT_REPLY:0,WEBCLIENT_EDIT:0,CLASSIFICATION:0,CLASSIFICATION_COLORS:'{"unclassified": "", "classified": "", "public": "", "red": ""}',DIRECT_ATTACH:0,REMEMBER_LAST_USED_SIGNATURE:1,CHECK_EXTERNAL_RECIPIENTS:0,CHECK_MISSING_ATTACHMENTS:1,INCLUDE_ORIGINAL_WHEN_REPLYING:1,WEBCLIENT_SMART_EXPIRATION:0,WEBCLIENT_SMART_EXPIRATION_DAYS:30,SEND_NOTIFICATION_TIMEOUT:5,SUGGEST_SENT_FOLDER_EMAILS:1,SENT_VIA_ICEWARP:0};break;case'MAIL_SETTINGS_GENERAL':aValues={'SOUND_NOTIFY':0,'AUTOUPDATE':1,'AUTOUPDATE_MINUTES':10,'MOVE_TO_TRASH':1,'FORWARD_MESSAGES':'inline','AUTOSAVE':1,'AUTOSAVE_MINUTES':5,'DEFAULT_FLAG':'1','AUTO_RECIPIENT_TO_ADDRESSBOOK':'0','SHOW_INLINE_IMAGES':'1','AUTO_SHOW_IMAGES':'0','AUTOCLEAR_TRASH_DAYS':'30',GROUP_CONTACTS_BY_EMAIL:0,CLASSIC_PREFIX:0,MARK_AS_READ:1,MARK_AS_READ_DELAY:0,SECONDARY_NOTIFY:1,DELETE_INVITATION:0,STORE_PDF_ATTACHMENTS_IN_UPLOAD_FOLDER:1,GROUP_BY_DATE:1};break;case'LAYOUT_SETTINGS':aValues={'DISABLE_PDF':0,'INTERFACES':'abp','ACTIVITY':0,'LOGIN_STYLE':'blue','LOGIN_CLIENT':'advanced','SKIN':'default','LANGUAGE':'en','DISABLE_OFFICE':0,'LOGIN_LOGO':'login_logo.png','DATE_FORMAT':0,'TIME_FORMAT':0,'INITIAL_PAGE':'r','CONFIRM_EXIT':1,'NOTIFICATIONS':0,'NOTIFICATION_POSITION':5,'BANNER_ENABLED':1,'FONT_WEIGHT':'auto',COMPACT_VIEW:0,PREVIEW_DELAY:1500,AUTOREOPEN_WINDOWS:0,ALTERNATIVE_CALENDAR:1,BLURRED_BACKGROUND:0,DASHBOARD_COLUMN_COUNT:6,LOGIN_BACKGROUND_UID:1,DISABLE_DASHBOARD_WIZARD:0,DISABLE_LOADING_TIPS:0,LOGIN_INTERFACE_COLOR:'background',LOGIN_BACKGROUND_SOLID:false,DATAGRID_FULLDATE:0,REMEMBER_FOLDER_PER_TYPE:0,REMEMBER_POPUP_POSITION:0,NIGHT_MODE_MAILVIEW:1,ACTIVITY_FEED:1,AUTOHIDE_TREE:0};break;case'CALENDAR_SETTINGS':aValues={'WEEK_BEGINS':'sunday','BEGIN_ON_TODAY':0,'DAY_BEGINS':8,'DAY_ENDS':16,'WORKWEEK_BEGINS':1,'WORKWEEK_ENDS':5,'TEMPERATURE':'C','AUTOCLEAR_TRASH_DAYS':'30',ALTERNATIVE_CALENDAR:-1,HIJRI_OFFSET:0,WEEK_NUMBERS:0};break;case'DEFAULT_CALENDAR_SETTINGS':aValues={'EVENT_VIEW':'week_view','EVENT_SHOW_AS':'S','EVENT_SHARING':'U','CONTACT_SHARING':'U','NOTE_SHARING':'U','FILE_SHARING':'U','TASK_SHARING':'U'};break;case'EVENT_SETTINGS':aValues={'TIME':0,'RM_TYPE':'E','EMAIL':''};break;case'DEFAULT_FOLDERS':aValues={'AB':'__@@ADDRESSBOOK@@__','SENT':sPrimaryAccount+'/'+getLang('COMMON_FOLDERS::SENT'),'TRASH':sPrimaryAccount+'/'+getLang('COMMON_FOLDERS::TRASH'),'DRAFTS':sPrimaryAccount+'/'+getLang('COMMON_FOLDERS::DRAFTS'),'CONTACTS':sPrimaryAccount+'/'+getLang('FOLDERS::CONTACTS'),'EVENTS':sPrimaryAccount+'/'+getLang('FOLDERS::EVENTS'),'TASKS':sPrimaryAccount+'/'+getLang('FOLDERS::TASKS'),'NOTES':sPrimaryAccount+'/'+getLang('FOLDERS::NOTES'),'JOURNAL':sPrimaryAccount+'/'+getLang('FOLDERS::JOURNAL'),'FILES':sPrimaryAccount+'/'+getLang('FOLDERS::FILES'),'SMARTATTACH':sPrimaryAccount+'/'+'__@@UPLOAD@@__','TEMPLATES':sPrimaryAccount+'/'+getLang('COMMON_FOLDERS::TEMPLATES')};break;case'HIDDEN_COLUMNS':aValues={M:'',E:'',C:'',F:'',T:'',N:'',J:'',S:'',FORCE_SINGLE_LINE_ROWS:false};break;case'READ_CONFIRMATION':aValues={'TEXT':getLang('EMAIL::READING_CONFIRMATION'),'SUBJECT':getLang('EMAIL::READING_CONFIRMATION_SUBJECT'),'SEND_CONFIRMATION':0};break;case'SIGNATURE':aValues={'TEXT':'','ENABLE':1};break;case'LOGIN_DATA':aValues={'IE_6_WARNING_SHOW_ON':0};break;case'RESET_SETTINGS':aValues={'ENABLED':1,'MAIL':getLang('RESET_PASS::EMAIL'),SMS:0,'SUBJECT':getLang('RESET_PASS::SUBJECT')};break;case'RESTRICTIONS':aValues={'SORTSTRING':0,'DISABLE_OTHERACCOUNTS':0,'DISABLE_WEATHER_SETTING':0,'DISABLE_CHANGEPASS':0,'DISABLE_SIGNUP':1,'DISABLE_DROPBOX':0,'GAL_SUGGEST':1,DISABLE_NEW_ALIASES:0,DISABLE_PERSONALITIES:0,DISABLE_FOLDER_EXPORT:0,DISABLE_FOLDER_SHARING:0,DISABLE_GW_TYPES:'',DISABLE_DASHBOARD_MODULES:'',DISABLE_DOC_INTEGRATION:0,DISABLE_DOCUMENT_COPY_OUT:0,DASHBOARD_NOTES_ENABLED:1,DASHBOARD_FILES_ENABLED:0,DASHBOARD_MARKETPLACE_ENABLED:1};break;case'SIP':aValues={'MODE':'integrate',START:1};break;case'SOUND':aValues={MAIL:'',CHAT:'',IM:'',IM_OUT:''}}
return aValues;};_me.checkLayoutSettings=function(sDataSet,sDataPath){var aSkin=this.get('SKINS',sDataSet,sDataPath),aData,i;if(aSkin){aData={};for(i in aSkin['VALUES'])
if(i!='value')
aData[i]=aSkin['VALUES'][i];if(!aData[this.getItem('LAYOUT_SETTINGS','skin')])
this.setItem('LAYOUT_SETTINGS','skin',this.getDefaultValues('LAYOUT_SETTINGS').SKIN);}
var lang=this.getItem('LAYOUT_SETTINGS','language');if(lang!==(lang=(lang.match(/\w{2}/)||[])[0])&&lang){this.setItem('LAYOUT_SETTINGS','language',lang);}
var aLang=this.get('LANGUAGES',sDataSet,sDataPath);if(aLang){aData={};for(i in aLang['VALUES'])
aData[i]=aLang['VALUES'][i];if(!aData[this.getItem('LAYOUT_SETTINGS','language')])
this.setItem('LAYOUT_SETTINGS','language',this.getDefaultValues('LAYOUT_SETTINGS').LANGUAGE);}};_me.checkCalendarSettings=function(sDataSet,sDataPath){var calendarSettings=this.get('CALENDAR_SETTINGS',sDataSet,sDataPath);if(((calendarSettings||{}).VALUES||{}).timezone){this.setItem('CALENDAR_SETTINGS','timezone',normalizeTimezone(calendarSettings.VALUES.timezone));}};_me.addListener=function(listener){this.listeners.push(listener);};_me.removeListener=function(listener){this.listeners=this.listeners.filter(function(list){return list!==listener;});};var GWOthers=new gw_others();

/* client/inc/json.js */

/* client/inc/obj_initial_loader.js */function obj_initial_loader(){};obj_initial_loader.prototype={__constructor:async function(){var tips_enabled=GWOthers.getItem('LAYOUT_SETTINGS','disable_loading_tips')==0;var tip=this.__tips[Math.floor(Math.random()*this.__tips.length)];await this._draw('obj_initial_loader','main',{tip:tips_enabled&&{image:'./client/skins/default/images/preloader/'+tip+(devicePixelRatio>1?'@2x':'')+'.png',label:getLang('PRELOADER::TIP_'+tip),header:getLang('PRELOADER::HEADER_'+tip)}});gui._main.classList.add('initial_loading');},__tips:['move','autohide','rightclick'],_value:function(sValue){this._getAnchor('state').textContent=sValue||'';return this;},_remove:function(){this._main.classList.add('removing');setTimeout(function(){this._destruct();}.bind(this),300);gui._main.classList.remove('initial_loading');}};

/* client/inc/obj_form_generic.js */_me=obj_form_generic.prototype;function obj_form_generic(){};_me.__constructor=async function(){this._telemetry='id';};_me._value=function(v){if(typeof v!='undefined'){this.__eIN.value=v;if(this.__restrictions&&this.__restrictions.length)this.__check();}
else
return this.__eIN.value.replace(/(\r\n)/gm,"\n").replace(/\n/gm,"\r\n");};_me._disabled=function(b){if(typeof b=='undefined')
return this.__eIN.disabled;else
if(b){this.__eIN.disabled=true;addcss(this._main,'disabled');}
else{this.__eIN.disabled=false;removecss(this._main,'disabled');}};_me._getFocusElement=function(){return this.__eIN;};_me._focus=function(){if(navigator.os&&navigator.os.name=="iOS")
return true;var elm=this._getFocusElement();if(elm.offsetParent&&elm.offsetParent.tagName!='BODY'&&getComputedStyle(elm).visibility!='hidden'&&!elm.readonly&&!elm.disabled){elm.focus({preventScroll:true});return true;}
return false;};_me.__update=function(sDataSet){if(!this._listener)
this._listener=sDataSet;else
if(sDataSet&&this._listener!=sDataSet)return;this._value(dataSet.get(this._listener,this._listenerPath));};

/* client/inc/obj_form_tab.js */_me=obj_form_tab.prototype;function obj_form_tab(){};_me.__constructor=async function(){var me=this,eFocus;if(this._getFocusElement&&(eFocus=this._getFocusElement())){AttachEvent(eFocus,'onkeydown',async function(e){if(e.keyCode==9){e.preventDefault();e.stopPropagation();if(!e.ctrlKey&&!e.metaKey&&me.__tabIndex_dock)
if(e.shiftKey)
await me.__tabIndex_dock._tabIndexPrev(me);else
await me.__tabIndex_dock._tabIndexNext(me);}});AttachEvent(eFocus,'onblur',function(){this._focused=false;if(me.__tabIndex_dock)
me.__tabIndex_dock.__lastFocus='';});AttachEvent(eFocus,'onfocus',function(){this._focused=true;if(me.__tabIndex_dock)
me.__tabIndex_dock.__lastFocus=me._pathName;});this._add_destructor('__disobeyTabIndex');}};_me._tabIndex=function(sContainer,i,oDock){if(!oDock){var tmp=this;while((tmp=tmp._parent))
if(tmp.__addTabIndex){oDock=tmp;break;}}
if(oDock){this.__disobeyTabIndex();if(oDock.__addTabIndex(this,sContainer,i))
this.__tabIndex_dock=oDock;}};_me._hasFocus=function(){return this._getFocusElement()._focused;};_me.__disobeyTabIndex=function(){if(this.__tabIndex_dock){this.__tabIndex_dock.__removeTabIndex(this);this.__tabIndex_dock=null;}};

/* client/inc/obj_button.js */_me=obj_button.prototype;function obj_button(){};_me.__constructor=async function(){this.__eIN=mkElement('input',{"type":'button',"name":this._pathName+'#main',"id":this._pathName+'#main'});this._main.appendChild(this.__eIN);this.__eIN.className=this._type=='obj_button'?'obj_button':'obj_button '+this._type;var me=this;this.__eIN.onclick=this._main.onclick=function(e){if(this==e.target){if(!me._disabled()){if(e.target==me._main)
me._focus();if(me._onclick)
me._onclick(e);}
e.preventDefault();}};this.__eIN.onfocus=function(e){me.__hasFocus=true;if(me._onfocus)me._onfocus(e);me.__exeEvent('onfocus',e,{"owner":me});addcss(me._main,'focus');return true;};this.__eIN.onblur=function(e){me.__hasFocus=false;if(me._onblur&&me._onblur(e)===false)return false;me.__exeEvent('onblur',e,{"owner":me});removecss(me._main,'focus');return true;};this._main.oncontextmenu=function(e){if(me._oncontext&&me._oncontext(e)!==false)
me.__exeEvent('oncontext',e,{"owner":me});return false;};this._main.onkeydown=function(e){if(!me._disabled()&&me._onkeypress)
me._onkeypress(e);return true;};};_me._value=function(sValue){if(sValue){this.__eIN.value=getLang(sValue);return this;}
return this.__eIN.value;};_me._text=function(sValue){if(Is.String(sValue))
this.__eIN.value=sValue;else
return this.__eIN.value||'';};_me._title=function(sValue){if(Is.String(sValue)){if(gui.tooltip){gui.tooltip._add(this._main,~sValue.indexOf('::')?getLang(sValue):sValue,{y:function(){return getSize(this).y-28;}.bind(this._main)});}else{this._main.title=this.__eIN.title=(sValue.indexOf('::')!=-1?getLang(sValue):sValue);}}else{return this.__eIN.title||'';}};_me._active=function(b){if(b===true)
addcss(this._main,'active');else
if(b===false)
removecss(this._main,'active');else
return hascss(this._main,'active');};

/* client/inc/obj_connection.js */_me=obj_connection.prototype;function obj_connection(){};_me.__constructor=async function(){this.__requests=[];this.__count=null;this._add_destructor('__destructor');};_me._queue=function(iCode,iDelay,aHandler,aErrorHandler){var arr={id:unique_id(),code:iCode,delay:iDelay||0,handler:aHandler,errorHandler:aErrorHandler},old=this._queueInRequests(arr);if(old)
return old.id;this.__requests.push(arr);this.__exeEvent('_queue',false,{"owner":this,id:arr.id});if(!cRequest||!(cRequest.lapse>70||cRequest.lapse<1)){this._show();}
return arr.id;};_me._queueInRequests=function(obj){return(this.__requests.filter(function(request){return obj.code===request.code&&obj.delay===request.delay&&getCallbackFunction(obj.handler)===getCallbackFunction(request.handler)&&getCallbackFunction(obj.errorHandler)===getCallbackFunction(request.errorHandler);})).pop();};_me._flush=function(){if(this.__notification){gui.notifier._closeNotification(this.__notification);}
for(var iq,i=0,j=this.__requests.length;i<j;i++){if((iq=this.__requests.shift())&&iq.handler){executeCallbackFunction(iq.handler);}}
this.__exeEvent('_flush',false,{"owner":this});this._show();};_me._clear=function(){if(this.__notification){gui.notifier._closeNotification(this.__notification);}
for(var iq,i=0,j=this.__requests.length;i<j;i++){if((iq=this.__requests.shift())&&iq.errorHandler){executeCallbackFunction(iq.errorHandler,false);}}
this.__exeEvent('_flush',false,{"owner":this});this._show();};_me._hide=function(id){if(this.__notification){gui.notifier._closeNotification(this.__notification);}
if(Is.Defined(id)){var bShow=false;this.__requests=this.__requests.filter(function(a){if(id==a.id){bShow=true;return false;}
return true;});if(bShow){this._show();}}};_me._show=function(){var me=this;if(this.__titleID&&gui.frm_main&&gui.frm_main.title){gui.frm_main.title._remove(this.__titleID,true);}
var iq=this.__requests[0];if(iq){if(this.__notification){gui.notifier._closeNotification(this.__notification);}
gui._main.classList.remove('server_overload');var error;switch(iq.code){case 404:error='ERROR::FILENOTFOUND';iq.delay=0;break;case 500:error='ERROR::SERVERERROR';iq.delay=0;break;case 503:error='ERROR::OVERLOADED';gui._main.classList.add('server_overload');break;default:error='ERROR::CONNECTION';}
if(!iq.delay){me.__requests.shift();me._show();}}}