window.Smiles = window.Smiles || {
	loaded: false,
	loading: false,
	flat_smiles_list: false,
	smiles_regex: '',
	smiles_list: {},
	escape_regex: /([()[\]{}|\\/+*])/g,
	loadSmiles: function (callback, context) {
		if (this.loaded) {
			return callback && callback.call(context || this, this.smiles_list);
		}
		if (this.loading) {
			return;
		}
		this.loading = true;
		var req = new XMLHttpRequest();
		req.addEventListener("load", function (e) {
			this.smiles_list = JSON.parse(e.target.responseText);
			this.loaded = true;
			this.loading = false;
			callback && callback.call(context || this, this.smiles_list);
		}.bind(this));
		req.open("GET", 'client/skins/' + GWOthers.getItem('LAYOUT_SETTINGS', 'skin') + '/images/smiles/list.json');
		req.send();
	},
	getSmiles: function (callback, context) {
		if (this.loaded) {
			callback.call(context || this, this.smiles_list);
		} else {
			this.loadSmiles(callback, context);
		}
	},
	getFlatSmilesList: function () {
		if (this.flat_smiles_list !== false) {
			return this.flat_smiles_list;
		}
		this.flat_smiles_list = {};
		for (var type in this.smiles_list) {
			for (var name in this.smiles_list[type]) {
				this.smiles_list[type][name].forEach(function (item) {
					this.flat_smiles_list[item.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(this.escape_regex, '\\$1')] = {name:name,type:type};
				}, this);
			}
		}
		this.smiles_regex = new RegExp('(>|^|\\B|\\s)('+Object.keys(this.flat_smiles_list).join('|')+')($|\\B|\\s|<|[.,!?])', 'g');

		this.smiles_map = Object.keys(this.map).map(function(smile) {
			return smile.replace(/([()*/;:-])/g, '\\$1').entityify();
		}).join('|');
		this.smiles_map_regex = new RegExp(this.smiles_map, 'g');
		this.smiles_map_whole_regex = new RegExp('(>|^|\\s)((?:(?:' + this.smiles_map + ')\\s*)+)($|\\s|<|[.,!?])', 'g');
		return this.flat_smiles_list;
	},
	replaceSmiles: function (text) {
		var list = this.getFlatSmilesList();
		if (Object.keys(list).length) {
			text = text.replace(this.smiles_map_whole_regex, function (whole, before, match, after) {
				return before + match.replace(this.smiles_map_regex, function(match) {
					return this.map[match.unentityify()] || match;
				}.bind(this)) + after;
			}.bind(this));

			text = text.replace(this.smiles_regex, function (whole, before, match, after) {
				var eSpan = mkElement('span',{className: 'smile'});
				eSpan.textContent = match;
				eSpan.classList.add('smiley-'+ list[match.replace(this.escape_regex, '\\$1')].name);
				eSpan.classList.add('sprite-'+ list[match.replace(this.escape_regex, '\\$1')].type);
				return before + eSpan.outerHTML + after;
			}.bind(this));
		}

		// native emojis
		const base = String.raw`\p{Emoji}(?:\p{EMod}|[\u{E0020}-\u{E007E}]+\u{E007F}|\uFE0F?\u20E3?)`;
		text = text.replace(new RegExp(String.raw`\p{RI}{2}|(?![#*\d](?!\uFE0F?\u20E3))${base}(?:\u200D${base})*`, 'gu'), function (match) {
			return '<span class="emoji">' + match + '</span>';
		});

		// twemoji
		if (~window.navigator.userAgent.indexOf('Win')) {
			text = twemoji.parse(text, {
				base: './client/skins/default/images/',
				folder: 'twemoji',
				ext: '.svg'
			}).replace(/<span class="emoji"><img class="emoji" draggable="false" alt="([^"]*?)" src="([^"]*?)"\/>.*?<\/span>/g, function(_, alt, src) {
				return '<span class="emoji twemoji" style="background-image:url(\'' + src + '\')">' + alt + '</span>';
			});
		}

		return text;
	},
	map: {
		':D': '😀',
		':-D': '😀',
		':)': '🙂',
		':-)': '🙂',
		':(': '🙁',
		':-(': '🙁',
		';)': '😉',
		';-)': '😉',
		':P': '😛',
		':-P': '😛',
		';P': '😜',
		';-P': '😜',
		':*': '😘',
		':-*': '😘',
		':O': '😯',
		':-O': '😯',
		':/': '🫤',
		':-/': '🫤',
		'B)': '😎',
		'B-)': '😎',
		'<3': '❤️',
		'(y)': '👍️',
		'xD': '😆',
	}
};
Smiles.loadSmiles();
